/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.jakarta.persistence.codegen;

import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.data.codegen.common.MethodParams;
import io.helidon.data.codegen.common.RepositoryInfo;
import io.helidon.data.codegen.common.spi.PersistenceGenerator;
import io.helidon.data.codegen.query.Criteria;
import io.helidon.data.codegen.query.CriteriaCondition;
import io.helidon.data.codegen.query.DataQuery;
import io.helidon.data.codegen.query.Order;
import io.helidon.data.codegen.query.Projection;
import io.helidon.data.codegen.query.ProjectionAction;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceBaseBuilder;
import io.helidon.data.jakarta.persistence.codegen.JakartaPersistenceTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

final class JakartaPersistenceCriteriaQueryGenerator
extends JakartaPersistenceBaseBuilder {
    private final MethodParams methodParams;
    private final DataQuery dataQuery;
    private final TypeName returnType;
    private final List<PersistenceGenerator.QuerySettings> settings;

    private JakartaPersistenceCriteriaQueryGenerator(RepositoryInfo repositoryInfo, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        super(repositoryInfo);
        this.methodParams = methodParams;
        this.dataQuery = dataQuery;
        this.returnType = returnType;
        this.settings = new ArrayList<PersistenceGenerator.QuerySettings>();
    }

    static JakartaPersistenceCriteriaQueryGenerator create(RepositoryInfo repositoryInfo, MethodParams methodParams, DataQuery dataQuery, TypeName returnType) {
        return new JakartaPersistenceCriteriaQueryGenerator(repositoryInfo, methodParams, dataQuery, returnType);
    }

    List<PersistenceGenerator.QuerySettings> settings() {
        return this.settings;
    }

    void criteriaQuery(Method.Builder builder) {
        ((Method.Builder)builder.addContent(JakartaPersistenceTypes.CRITERIA_BUILDER)).addContentLine(" cb = em.getCriteriaBuilder();");
        this.buildProjection(builder);
        this.dataQuery.criteria().ifPresent(criteria -> this.buildCriteria(builder, (Criteria)criteria, "stmt"));
        this.buildOrder(builder);
        this.buildCreateQuery(builder);
        this.settings.addAll(this.setParameter().values());
    }

    List<PersistenceGenerator.QuerySettings> dynamicSliceQuery(Method.Builder builder, String dataQueryStatement) {
        if (this.dataQuery.projection().action() != ProjectionAction.Select) {
            throw new IllegalArgumentException("Can't build dynamic query for " + String.valueOf(this.dataQuery.projection().action()) + " statement");
        }
        ((Method.Builder)builder.addContent(JakartaPersistenceTypes.CRITERIA_BUILDER)).addContentLine(" cb = em.getCriteriaBuilder();");
        JakartaPersistenceCriteriaQueryGenerator.appendCreateQueryInstance(builder, this.returnType, dataQueryStatement);
        JakartaPersistenceCriteriaQueryGenerator.appendCreateRootFromQuery(builder, this.repositoryInfo(), "root", dataQueryStatement);
        this.appendSetSelectExpression(builder, this.dataQuery.projection(), dataQueryStatement, "root");
        this.dataQuery.criteria().ifPresent(criteria -> this.buildCriteria(builder, (Criteria)criteria, "stmt"));
        JakartaPersistenceCriteriaQueryGenerator.appendCreateOrderList(builder, "orderBy");
        this.dataQuery.order().ifPresent(order -> JakartaPersistenceCriteriaQueryGenerator.appendOrderExpression(builder, order, "orderBy"));
        this.methodParams.order().ifPresent(sort -> JakartaPersistenceCriteriaQueryGenerator.appendSortExpression(builder, sort, "orderBy"));
        JakartaPersistenceCriteriaQueryGenerator.appendSetOrderBy(builder, this.dataQuery.order().isEmpty() || ((Order)this.dataQuery.order().get()).expressions().isEmpty(), "orderBy", dataQueryStatement);
        this.settings.addAll(this.setParameter().values());
        return this.settings();
    }

    List<PersistenceGenerator.QuerySettings> dynamicPageQueries(Method.Builder builder, String dataQueryStatement, String countQueryStatement) {
        if (this.dataQuery.projection().action() != ProjectionAction.Select) {
            throw new IllegalArgumentException("Can't build dynamic query for " + String.valueOf(this.dataQuery.projection().action()) + " statement");
        }
        ((Method.Builder)builder.addContent(JakartaPersistenceTypes.CRITERIA_BUILDER)).addContentLine(" cb = em.getCriteriaBuilder();");
        JakartaPersistenceCriteriaQueryGenerator.appendCreateQueryInstance(builder, this.returnType, dataQueryStatement);
        JakartaPersistenceCriteriaQueryGenerator.appendCreateQueryInstance(builder, NUMBER, countQueryStatement);
        JakartaPersistenceCriteriaQueryGenerator.appendCreateRootFromQuery(builder, this.repositoryInfo(), "root", dataQueryStatement);
        this.appendSetSelectExpression(builder, this.dataQuery.projection(), dataQueryStatement, "root");
        this.appendSetSelectCountExpression(builder, this.dataQuery.projection(), countQueryStatement, "root");
        this.dataQuery.criteria().ifPresent(criteria -> {
            this.appendCriteriaInstance(builder, (Criteria)criteria, "criteria");
            JakartaPersistenceCriteriaQueryGenerator.statement((Method.Builder)builder, b1 -> JakartaPersistenceCriteriaQueryGenerator.where(b1, b2 -> JakartaPersistenceCriteriaQueryGenerator.identifier((Method.Builder)b2, (String)"criteria"), dataQueryStatement));
            JakartaPersistenceCriteriaQueryGenerator.statement((Method.Builder)builder, b1 -> JakartaPersistenceCriteriaQueryGenerator.where(b1, b2 -> JakartaPersistenceCriteriaQueryGenerator.identifier((Method.Builder)b2, (String)"criteria"), countQueryStatement));
        });
        JakartaPersistenceCriteriaQueryGenerator.appendCreateOrderList(builder, "orderBy");
        this.dataQuery.order().ifPresent(order -> JakartaPersistenceCriteriaQueryGenerator.appendOrderExpression(builder, order, "orderBy"));
        this.methodParams.order().ifPresent(sort -> JakartaPersistenceCriteriaQueryGenerator.appendSortExpression(builder, sort, "orderBy"));
        JakartaPersistenceCriteriaQueryGenerator.appendSetOrderBy(builder, this.dataQuery.order().isEmpty() || ((Order)this.dataQuery.order().get()).expressions().isEmpty(), "orderBy", dataQueryStatement);
        this.settings.addAll(this.setParameter().values());
        return this.settings();
    }

    private static void projectionTarget(Method.Builder builder, Projection projection, String rootName) {
        projection.property().ifPresentOrElse(property -> ((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(rootName)).addContent(".get(\"")).addContent(property.name().toString())).addContent("\")"), () -> builder.addContent(rootName));
    }

    private static void appendSetOrderBy(Method.Builder builder, boolean addIf, String orderName, String statementName) {
        if (addIf) {
            ((Method.Builder)((Method.Builder)builder.addContent("if (!")).addContent(orderName)).addContentLine(".isEmpty()) {");
        }
        ((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(statementName)).addContent(".orderBy(")).addContent(orderName)).addContentLine(");");
        if (addIf) {
            builder.addContentLine("}");
        }
    }

    private static void appendSortExpression(Method.Builder builder, TypedElementInfo sortInfo, String orderName) {
        ((Method.Builder)builder.addContent(sortInfo.elementName())).addContentLine(".orderBy().forEach(order -> ");
        JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)2);
        ((Method.Builder)builder.addContent(orderName)).addContent(".add(");
        ((Method.Builder)builder.addContent("switch (order.direction()) ")).addContentLine("{");
        ((Method.Builder)((Method.Builder)builder.addContentLine("case ASC -> cb.asc(order.caseSensitive()")).addContentLine("                    ? root.get(order.property())")).addContentLine("                    : cb.upper(root.get(order.property())));");
        ((Method.Builder)((Method.Builder)builder.addContentLine("case DESC -> cb.desc(order.caseSensitive()")).addContentLine("                    ? root.get(order.property())")).addContentLine("                    : cb.upper(root.get(order.property())));");
        ((Method.Builder)builder.addContent("}")).addContent(")");
        JakartaPersistenceCriteriaQueryGenerator.decreasePadding((Method.Builder)builder, (int)2);
        builder.addContentLine(");");
    }

    private static void select(Method.Builder builder, Consumer<Method.Builder> content, String dataQueryStatement) {
        ((Method.Builder)builder.addContent(dataQueryStatement)).addContent(".select(");
        content.accept(builder);
        builder.addContent(")");
    }

    private static void where(Method.Builder builder, Consumer<Method.Builder> content, String dataQueryStatement) {
        ((Method.Builder)builder.addContent(dataQueryStatement)).addContent(".where(");
        content.accept(builder);
        builder.addContent(")");
    }

    private static void count(Method.Builder builder, Consumer<Method.Builder> content, Projection projection) {
        ((Method.Builder)((Method.Builder)builder.addContent("cb.")).addContent(projection.distinct() ? "countDistinct" : "count")).addContent("(");
        content.accept(builder);
        builder.addContent(")");
    }

    private static void appendCreateQueryInstance(Method.Builder builder, TypeName returnType, String name) {
        TypeName criteriaQuery = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(JakartaPersistenceTypes.RAW_CRITERIA_QUERY)).addTypeArgument(returnType)).build();
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(criteriaQuery)).addContent(" ")).addContent(name)).addContent(" = cb.createQuery(")).addContent(returnType)).addContentLine(".class);");
    }

    private static void appendCreateDeleteInstance(Method.Builder builder, TypeName entityType, String name) {
        TypeName criteriaDelete = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(JakartaPersistenceTypes.RAW_CRITERIA_DELETE)).addTypeArgument(entityType)).build();
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(criteriaDelete)).addContent(" ")).addContent(name)).addContent(" = cb.createCriteriaDelete(")).addContent(entityType)).addContentLine(".class);");
    }

    private static void appendCreateRootFromQuery(Method.Builder builder, RepositoryInfo repositoryInfo, String name, String queryName) {
        TypeName root = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(JakartaPersistenceTypes.RAW_ROOT)).addTypeArgument(repositoryInfo.entity())).build();
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(root)).addContent(" ")).addContent(name)).addContent(" = ")).addContent(queryName)).addContent(".from(")).addContent(repositoryInfo.entity())).addContentLine(".class);");
    }

    private static void appendCreateOrderList(Method.Builder builder, String name) {
        TypeName listType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(List.class)).addTypeArgument(JakartaPersistenceTypes.ORDER)).build();
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(listType)).addContent(" ")).addContent(name)).addContent(" = new ")).addContent(ArrayList.class)).addContentLine("<>();");
    }

    private static void appendOrderExpression(Method.Builder builder, Order order, String orderName) {
        order.expressions().forEach(expression -> {
            ((Method.Builder)builder.addContent(orderName)).addContent(".add(cb.");
            switch (expression.operator()) {
                case ASC: {
                    builder.addContent("asc");
                    break;
                }
                case DESC: {
                    builder.addContent("desc");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown order direction operator " + String.valueOf(expression.operator()));
                }
            }
            ((Method.Builder)((Method.Builder)builder.addContent("(root.get(\"")).addContent(expression.property().name().toString())).addContentLine("\")));");
        });
    }

    private static void max(Method.Builder builder, Consumer<Method.Builder> content) {
        builder.addContent("cb.max(");
        content.accept(builder);
        builder.addContent(")");
    }

    private static void min(Method.Builder builder, Consumer<Method.Builder> content) {
        builder.addContent("cb.min(");
        content.accept(builder);
        builder.addContent(")");
    }

    private static void sum(Method.Builder builder, Consumer<Method.Builder> content) {
        builder.addContent("cb.sum(");
        content.accept(builder);
        builder.addContent(")");
    }

    private static void avg(Method.Builder builder, Consumer<Method.Builder> content) {
        builder.addContent("cb.avg(");
        content.accept(builder);
        builder.addContent(")");
    }

    private static void gt(Method.Builder builder, Consumer<Method.Builder> content1, Consumer<Method.Builder> content2) {
        builder.addContent("cb.gt(");
        content1.accept(builder);
        builder.addContent(", ");
        content2.accept(builder);
        builder.addContent(")");
    }

    private void buildProjection(Method.Builder builder) {
        Projection projection = this.dataQuery.projection();
        switch (projection.action()) {
            case Select: {
                this.appendSelect(builder, projection);
                break;
            }
            case Delete: {
                throw new UnsupportedOperationException("Sort parameter used in delete statement");
            }
            case Update: {
                throw new UnsupportedOperationException("Sort parameter used in update statement");
            }
            default: {
                throw new UnsupportedOperationException("Unknown query action " + String.valueOf(projection.action()));
            }
        }
    }

    private void buildCriteria(Method.Builder builder, Criteria criteria, String name) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder();
        criteriaBuilder.first(criteria.first());
        criteria.next().forEach(nextExpression -> {
            switch (nextExpression.operator()) {
                case AND: {
                    criteriaBuilder.and(nextExpression.criteria());
                    break;
                }
                case OR: {
                    criteriaBuilder.or(nextExpression.criteria());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown criteria logical operator " + String.valueOf(nextExpression.operator()));
                }
            }
        });
        Iterator parameters = this.methodParams.parameters().iterator();
        JakartaPersistenceCriteriaQueryGenerator.statement((Method.Builder)builder, b1 -> JakartaPersistenceCriteriaQueryGenerator.where(b1, b2 -> criteriaBuilder.build((Method.Builder)b2, parameters, this.setParameter()), name));
    }

    private void buildOrder(Method.Builder builder) {
        if (this.dataQuery.projection().action() == ProjectionAction.Select) {
            JakartaPersistenceCriteriaQueryGenerator.appendCreateOrderList(builder, "orderBy");
            this.dataQuery.order().ifPresent(order -> JakartaPersistenceCriteriaQueryGenerator.appendOrderExpression(builder, order, "orderBy"));
            this.methodParams.order().ifPresent(sort -> JakartaPersistenceCriteriaQueryGenerator.appendSortExpression(builder, sort, "orderBy"));
            JakartaPersistenceCriteriaQueryGenerator.appendSetOrderBy(builder, this.dataQuery.order().isEmpty() || ((Order)this.dataQuery.order().get()).expressions().isEmpty(), "orderBy", "stmt");
        }
    }

    private void buildCreateQuery(Method.Builder builder) {
        Projection projection = this.dataQuery.projection();
        switch (projection.action()) {
            case Select: 
            case Delete: {
                if (!this.returnType.equals((Object)TypeNames.PRIMITIVE_VOID) && !this.returnType.equals((Object)TypeNames.BOXED_VOID)) {
                    builder.addContent("return ");
                }
                builder.addContentLine("em.createQuery(stmt)");
                break;
            }
            case Update: {
                throw new UnsupportedOperationException("Update statement is not supported");
            }
            default: {
                throw new UnsupportedOperationException("Unknown query action " + String.valueOf(projection.action()));
            }
        }
    }

    private void appendDelete(Method.Builder builder) {
        JakartaPersistenceCriteriaQueryGenerator.appendCreateDeleteInstance(builder, this.repositoryInfo().entity(), "stmt");
        if (this.dataQuery.criteria().isPresent()) {
            JakartaPersistenceCriteriaQueryGenerator.appendCreateRootFromQuery(builder, this.repositoryInfo(), "root", "stmt");
        }
    }

    private void appendSelect(Method.Builder builder, Projection projection) {
        JakartaPersistenceCriteriaQueryGenerator.appendCreateQueryInstance(builder, this.returnType, "stmt");
        JakartaPersistenceCriteriaQueryGenerator.appendCreateRootFromQuery(builder, this.repositoryInfo(), "root", "stmt");
        this.appendSetSelectExpression(builder, projection, "stmt", "root");
    }

    private void appendSetSelectExpression(Method.Builder builder, Projection projection, String queryName, String rootName) {
        JakartaPersistenceCriteriaQueryGenerator.statement((Method.Builder)builder, b1 -> JakartaPersistenceCriteriaQueryGenerator.select(b1, b2 -> this.appendSelectExpression((Method.Builder)b2, projection, rootName), queryName));
    }

    private void appendSetSelectCountExpression(Method.Builder builder, Projection projection, String queryName, String rootName) {
        JakartaPersistenceCriteriaQueryGenerator.statement((Method.Builder)builder, b1 -> JakartaPersistenceCriteriaQueryGenerator.select(b1, b2 -> JakartaPersistenceCriteriaQueryGenerator.count(b2, b3 -> this.appendSelectExpression((Method.Builder)b3, projection, rootName), projection), queryName));
    }

    private void appendSelectExpression(Method.Builder builder, Projection projection, String rootName) {
        projection.expression().ifPresentOrElse(expression -> {
            switch (expression.operator()) {
                case First: {
                    expression.parameter().ifPresentOrElse(parameter -> {
                        if (parameter.type() != Integer.class) {
                            throw new IllegalArgumentException("First projection operator parameter is not Integer");
                        }
                        JakartaPersistenceCriteriaQueryGenerator.projectionTarget(builder, projection, rootName);
                        this.settings.add(new JakartaPersistenceBaseBuilder.Limit((Integer)parameter.value()));
                    }, () -> {
                        throw new IllegalArgumentException("Missing First projection operator parameter");
                    });
                    break;
                }
                case Count: 
                case Exists: {
                    JakartaPersistenceCriteriaQueryGenerator.count(builder, b -> JakartaPersistenceCriteriaQueryGenerator.projectionTarget(b, projection, rootName), projection);
                    break;
                }
                case Max: {
                    JakartaPersistenceCriteriaQueryGenerator.max(builder, b -> JakartaPersistenceCriteriaQueryGenerator.projectionTarget(b, projection, rootName));
                    break;
                }
                case Min: {
                    JakartaPersistenceCriteriaQueryGenerator.min(builder, b -> JakartaPersistenceCriteriaQueryGenerator.projectionTarget(b, projection, rootName));
                    break;
                }
                case Sum: {
                    JakartaPersistenceCriteriaQueryGenerator.sum(builder, b -> JakartaPersistenceCriteriaQueryGenerator.projectionTarget(b, projection, rootName));
                    break;
                }
                case Avg: {
                    if (this.returnType.equals((Object)TypeNames.PRIMITIVE_DOUBLE) || this.returnType.equals((Object)TypeNames.BOXED_DOUBLE) || this.returnType.equals((Object)NUMBER)) {
                        JakartaPersistenceCriteriaQueryGenerator.avg(builder, b -> JakartaPersistenceCriteriaQueryGenerator.projectionTarget(b, projection, rootName));
                        break;
                    }
                    throw new UnsupportedOperationException("Jakarta Persistence Criteria API avg function does not support " + String.valueOf(this.returnType));
                }
                default: {
                    throw new UnsupportedOperationException("Unknown projection expression operator " + String.valueOf(expression.operator()));
                }
            }
        }, () -> JakartaPersistenceCriteriaQueryGenerator.projectionTarget(builder, projection, rootName));
    }

    private void appendCriteriaInstance(Method.Builder builder, Criteria criteria, String name) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder();
        criteriaBuilder.first(criteria.first());
        criteria.next().forEach(nextExpression -> {
            switch (nextExpression.operator()) {
                case AND: {
                    criteriaBuilder.and(nextExpression.criteria());
                    break;
                }
                case OR: {
                    criteriaBuilder.or(nextExpression.criteria());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown criteria logical operator " + String.valueOf(nextExpression.operator()));
                }
            }
        });
        TypeName expressionType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(JakartaPersistenceTypes.RAW_EXPRESSION)).addTypeArgument(TypeNames.BOXED_BOOLEAN)).build();
        Iterator parameters = this.methodParams.parameters().iterator();
        JakartaPersistenceCriteriaQueryGenerator.statement((Method.Builder)builder, b -> {
            ((Method.Builder)((Method.Builder)((Method.Builder)b.addContent(expressionType)).addContent(" ")).addContent(name)).addContent(" = ");
            criteriaBuilder.build((Method.Builder)b, parameters, this.setParameter());
        });
    }

    private static final class CriteriaBuilder {
        private final List<Expression> expressions = new ArrayList<Expression>();
        private Condition last = null;
        private boolean lastOr;
        private And and = null;

        private CriteriaBuilder() {
        }

        void build(Method.Builder builder, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            if (this.last == null) {
                throw new IllegalStateException("Previous condition is missing");
            }
            if (this.lastOr) {
                this.expressions.add(this.last);
            } else {
                this.and.add(this.last);
                this.expressions.add(this.and);
                this.and = null;
            }
            this.last = null;
            JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)1);
            if (this.expressions.size() > 1) {
                builder.addContentLine("cb.or(");
                JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)1);
            }
            boolean firstExpression = true;
            for (Expression expression : this.expressions) {
                if (firstExpression) {
                    firstExpression = false;
                } else {
                    builder.addContentLine(",");
                }
                expression.build(builder, parameters, setParameter);
            }
            if (this.expressions.size() > 1) {
                JakartaPersistenceCriteriaQueryGenerator.decreasePadding((Method.Builder)builder, (int)1);
                builder.addContent(")");
            }
            JakartaPersistenceCriteriaQueryGenerator.decreasePadding((Method.Builder)builder, (int)1);
        }

        private void first(CriteriaCondition first) {
            if (this.last != null) {
                throw new IllegalStateException("First condition was already set");
            }
            this.last = new Condition(first);
            this.lastOr = true;
        }

        private void or(CriteriaCondition condition) {
            if (this.last == null) {
                throw new IllegalStateException("Previous condition is missing");
            }
            if (this.lastOr) {
                this.expressions.add(this.last);
            } else {
                this.and.add(this.last);
                this.expressions.add(this.and);
                this.and = null;
            }
            this.lastOr = true;
            this.last = new Condition(condition);
        }

        private void and(CriteriaCondition condition) {
            if (this.last == null) {
                throw new IllegalStateException("Previous condition is missing");
            }
            if (this.lastOr) {
                if (this.and != null) {
                    throw new IllegalStateException("Found AND expression already in progress");
                }
                this.and = new And(this.last);
            } else {
                this.and.add(this.last);
            }
            this.lastOr = false;
            this.last = new Condition(condition);
        }
    }

    private static final class And
    implements Expression {
        private final List<Condition> conditions = new ArrayList<Condition>();

        private And(Condition first) {
            this.conditions.add(first);
        }

        @Override
        public void build(Method.Builder builder, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContentLine("cb.and(");
            JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)1);
            boolean firstExpression = true;
            for (Condition condition : this.conditions) {
                if (firstExpression) {
                    firstExpression = false;
                } else {
                    builder.addContentLine(",");
                }
                condition.build(builder, parameters, setParameter);
            }
            JakartaPersistenceCriteriaQueryGenerator.decreasePadding((Method.Builder)builder, (int)1);
            builder.addContent(")");
        }

        private void add(Condition condition) {
            this.conditions.add(condition);
        }
    }

    private static final class Condition
    implements Expression {
        private final CriteriaCondition condition;

        private Condition(CriteriaCondition condition) {
            this.condition = condition;
        }

        @Override
        public void build(Method.Builder builder, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            switch (this.condition.operator()) {
                case Equal: {
                    Condition.criteriaEqual(builder, this.condition, parameters, setParameter);
                    break;
                }
                case Contains: {
                    Condition.criteriaContains(builder, this.condition, parameters, setParameter);
                    break;
                }
                case EndsWith: {
                    Condition.criteriaEndsWith(builder, this.condition, parameters, setParameter);
                    break;
                }
                case StartsWith: {
                    Condition.criteriaStartsWith(builder, this.condition, parameters, setParameter);
                    break;
                }
                case Before: 
                case LessThan: {
                    Condition.criteriaLessThan(builder, this.condition, parameters, setParameter);
                    break;
                }
                case LessThanEqual: {
                    Condition.criteriaLessThanEqual(builder, this.condition, parameters, setParameter);
                    break;
                }
                case After: 
                case GreaterThan: {
                    Condition.criteriaGreaterThan(builder, this.condition, parameters, setParameter);
                    break;
                }
                case GreaterThanEqual: {
                    Condition.criteriaGreaterThanEqual(builder, this.condition, parameters, setParameter);
                    break;
                }
                case Between: {
                    Condition.criteriaBetween(builder, this.condition, parameters, setParameter);
                    break;
                }
                case Like: {
                    Condition.criteriaLike(builder, this.condition, parameters, setParameter);
                    break;
                }
                case In: {
                    Condition.criteriaIn(builder, this.condition, parameters, setParameter);
                    break;
                }
                case Empty: {
                    Condition.criteriaEmpty(builder, this.condition);
                    break;
                }
                case Null: {
                    Condition.criteriaNull(builder, this.condition);
                    break;
                }
                case True: {
                    Condition.criteriaTrue(builder, this.condition);
                    break;
                }
                case False: {
                    Condition.criteriaFalse(builder, this.condition);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown criteria expression operator " + String.valueOf(this.condition.operator()));
                }
            }
        }

        private static void criteriaEqual(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b -> Condition.equal(b, condition, parameters, setParameter), condition.not());
        }

        private static void criteriaContains(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b1 -> Condition.like(b1, b2 -> Condition.containsConcat(b2, condition, parameters, setParameter), condition), condition.not());
        }

        private static void criteriaEndsWith(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b1 -> Condition.like(b1, b2 -> Condition.endsWithConcat(b2, condition, parameters, setParameter), condition), condition.not());
        }

        private static void criteriaStartsWith(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b1 -> Condition.like(b1, b2 -> Condition.startsWithConcat(b2, condition, parameters, setParameter), condition), condition.not());
        }

        private static void criteriaLessThan(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b -> Condition.lessThan(b, condition, parameters, setParameter), condition.not());
        }

        private static void criteriaLessThanEqual(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b -> Condition.lessThanOrEqualTo(b, condition, parameters, setParameter), condition.not());
        }

        private static void criteriaGreaterThan(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b -> Condition.greaterThan(b, condition, parameters, setParameter), condition.not());
        }

        private static void criteriaGreaterThanEqual(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b -> Condition.greaterThanOrEqualTo(b, condition, parameters, setParameter), condition.not());
        }

        private static void criteriaBetween(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b -> Condition.between(b, condition, parameters, setParameter), condition.not());
        }

        private static void criteriaLike(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b1 -> Condition.like(b1, b2 -> Condition.firstParameter(b2, condition, parameters, setParameter), condition), condition.not());
        }

        private static void criteriaIn(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.not(builder, b -> Condition.in(b, condition, parameters, setParameter), condition.not());
        }

        private static void criteriaEmpty(Method.Builder builder, CriteriaCondition condition) {
            Condition.not(builder, b -> Condition.isEmpty(b, condition), condition.not());
        }

        private static void criteriaNull(Method.Builder builder, CriteriaCondition condition) {
            Condition.not(builder, b -> Condition.isNull(b, condition), condition.not());
        }

        private static void criteriaTrue(Method.Builder builder, CriteriaCondition condition) {
            Condition.not(builder, b -> Condition.isTrue(b, condition), condition.not());
        }

        private static void criteriaFalse(Method.Builder builder, CriteriaCondition condition) {
            Condition.not(builder, b -> Condition.isFalse(b, condition), condition.not());
        }

        private static void equal(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContent("cb.equal(");
            Condition.property(builder, condition);
            builder.addContent(", ");
            Condition.firstParameter(builder, condition, parameters, setParameter);
            builder.addContent(")");
        }

        private static void lessThan(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContent("cb.lessThan(");
            Condition.property(builder, condition);
            builder.addContent(", ");
            Condition.firstParameter(builder, condition, parameters, setParameter);
            builder.addContent(")");
        }

        private static void lessThanOrEqualTo(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContent("cb.lessThanOrEqualTo(");
            Condition.property(builder, condition);
            builder.addContent(", ");
            Condition.firstParameter(builder, condition, parameters, setParameter);
            builder.addContent(")");
        }

        private static void greaterThan(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContent("cb.greaterThan(");
            Condition.property(builder, condition);
            builder.addContent(", ");
            Condition.firstParameter(builder, condition, parameters, setParameter);
            builder.addContent(")");
        }

        private static void greaterThanOrEqualTo(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContent("cb.greaterThanOrEqualTo(");
            Condition.property(builder, condition);
            builder.addContent(", ");
            Condition.firstParameter(builder, condition, parameters, setParameter);
            builder.addContent(")");
        }

        private static void between(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContentLine("cb.between(");
            JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)1);
            Condition.property(builder, condition);
            builder.addContentLine(",");
            Condition.firstParameter(builder, condition, parameters, setParameter);
            builder.addContentLine(",");
            Condition.secondParameter(builder, condition, parameters, setParameter);
            JakartaPersistenceCriteriaQueryGenerator.decreasePadding((Method.Builder)builder, (int)1);
            builder.addContent(")");
        }

        private static void in(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            Condition.property(builder, condition);
            builder.addContent(".in(");
            Condition.firstParameter(builder, condition, parameters, setParameter);
            builder.addContent(")");
        }

        private static void like(Method.Builder builder, Consumer<Method.Builder> pattern, CriteriaCondition condition) {
            builder.addContentLine("cb.like(");
            JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)1);
            Condition.property(builder, condition);
            builder.addContentLine(",");
            pattern.accept(builder);
            JakartaPersistenceCriteriaQueryGenerator.decreasePadding((Method.Builder)builder, (int)1);
            builder.addContent(")");
        }

        private static void isEmpty(Method.Builder builder, CriteriaCondition condition) {
            builder.addContent("cb.isEmpty(");
            Condition.property(builder, condition);
            builder.addContent(")");
        }

        private static void isNull(Method.Builder builder, CriteriaCondition condition) {
            builder.addContent("cb.isNull(");
            Condition.property(builder, condition);
            builder.addContent(")");
        }

        private static void isTrue(Method.Builder builder, CriteriaCondition condition) {
            builder.addContent("cb.isTrue(");
            Condition.property(builder, condition);
            builder.addContent(")");
        }

        private static void isFalse(Method.Builder builder, CriteriaCondition condition) {
            builder.addContent("cb.isFalse(");
            Condition.property(builder, condition);
            builder.addContent(")");
        }

        private static void containsConcat(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContentLine("cb.concat(");
            JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)1);
            builder.addContentLine("cb.literal(\"%\"), ");
            builder.addContentLine("cb.concat(");
            JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)1);
            Condition.firstParameter(builder, condition, parameters, setParameter);
            ((Method.Builder)builder.addContentLine(",")).addContent("cb.literal(\"%\")");
            JakartaPersistenceCriteriaQueryGenerator.decreasePadding((Method.Builder)builder, (int)1);
            builder.addContent("))");
        }

        private static void endsWithConcat(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContentLine("cb.concat(");
            JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)1);
            builder.addContentLine("cb.literal(\"%\"), ");
            Condition.firstParameter(builder, condition, parameters, setParameter);
            JakartaPersistenceCriteriaQueryGenerator.decreasePadding((Method.Builder)builder, (int)1);
            builder.addContent(")");
        }

        private static void startsWithConcat(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            builder.addContentLine("cb.concat(");
            JakartaPersistenceCriteriaQueryGenerator.increasePadding((Method.Builder)builder, (int)1);
            Condition.firstParameter(builder, condition, parameters, setParameter);
            ((Method.Builder)builder.addContentLine(",")).addContent("cb.literal(\"%\")");
            JakartaPersistenceCriteriaQueryGenerator.decreasePadding((Method.Builder)builder, (int)1);
            builder.addContent(")");
        }

        private static void not(Method.Builder builder, Consumer<Method.Builder> content, boolean not) {
            if (not) {
                builder.addContent("cb.not(");
            }
            content.accept(builder);
            if (not) {
                builder.addContent(")");
            }
        }

        private static void ignoreCase(Method.Builder builder, Consumer<Method.Builder> content, boolean ignoreCase) {
            if (ignoreCase) {
                builder.addContent("cb.upper(");
            }
            content.accept(builder);
            if (ignoreCase) {
                builder.addContent(")");
            }
        }

        private static void rootGet(Method.Builder builder, CharSequence name) {
            ((Method.Builder)((Method.Builder)builder.addContent("root.get(\"")).addContent(name.toString())).addContent("\")");
        }

        private static void property(Method.Builder builder, CriteriaCondition condition) {
            Condition.ignoreCase(builder, b -> Condition.rootGet(b, condition.property().name()), condition.ignoreCase());
        }

        private static void firstParameter(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            condition.parameters().ifPresentOrElse(criteriaParameters -> Condition.parameter(builder, condition, criteriaParameters.get(0), setParameter), () -> Condition.parameter(builder, condition, (TypedElementInfo)parameters.next(), setParameter));
        }

        private static void secondParameter(Method.Builder builder, CriteriaCondition condition, Iterator<TypedElementInfo> parameters, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            condition.parameters().ifPresentOrElse(criteriaParameters -> Condition.parameter(builder, condition, criteriaParameters.get(1), setParameter), () -> Condition.parameter(builder, condition, (TypedElementInfo)parameters.next(), setParameter));
        }

        private static void parameter(Method.Builder builder, CriteriaCondition condition, TypedElementInfo paramInfo, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            if (condition.ignoreCase() && !paramInfo.typeName().equals((Object)TypeNames.STRING)) {
                throw new IllegalArgumentException(String.format("IgnoreCase requires method %s parameter of type String", paramInfo.elementName()));
            }
            Condition.ignoreCase(builder, b -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)b.addContent("cb.parameter(")).addContent(paramInfo.typeName().genericTypeName().boxed())).addContent(".class, \"")).addContent(paramInfo.elementName())).addContent("\")"), condition.ignoreCase());
            setParameter.putIfAbsent(paramInfo.elementName(), new JakartaPersistenceBaseBuilder.Param(paramInfo.elementName()));
        }

        private static void parameter(Method.Builder builder, CriteriaCondition condition, CharSequence paramName, Map<CharSequence, PersistenceGenerator.QuerySettings> setParameter) {
            if (condition.ignoreCase()) {
                builder.addContent("cb.upper(");
            }
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("cb.parameter(")).addContent(Object.class)).addContent(".class, \"")).addContent(paramName.toString())).addContent("\")");
            if (condition.ignoreCase()) {
                builder.addContent(")");
            }
            setParameter.putIfAbsent(paramName, new JakartaPersistenceBaseBuilder.Param(paramName));
        }
    }

    private static interface Expression {
        public void build(Method.Builder var1, Iterator<TypedElementInfo> var2, Map<CharSequence, PersistenceGenerator.QuerySettings> var3);
    }
}

