/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data;

import io.helidon.data.Page;
import io.helidon.data.PageRequest;
import io.helidon.data.SliceImpl;
import java.util.List;

class PageImpl<T>
extends SliceImpl<T>
implements Page<T> {
    private final int totalSize;

    PageImpl(PageRequest request, List<T> content, int totalSize) {
        super(request, content);
        this.totalSize = totalSize;
    }

    @Override
    public int totalSize() {
        return this.totalSize;
    }

    @Override
    public int totalPages() {
        int size = this.request().size();
        return size == 0 ? 1 : (int)Math.ceil((double)this.totalSize() / (double)size);
    }
}

