/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.data.Order;
import io.helidon.data.SortBlueprint;
import io.helidon.data.SortSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.data.SortBlueprint")
public interface Sort
extends SortBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Sort instance) {
        return (Builder)Sort.builder().from(instance);
    }

    public static Sort create() {
        return Sort.builder().buildPrototype();
    }

    public static Sort unsorted() {
        return SortSupport.unsorted();
    }

    public static Sort create(Order ... orders) {
        return SortSupport.create(orders);
    }

    public static Sort create(List<Order> orders) {
        return SortSupport.create(orders);
    }

    @Override
    public List<Order> orderBy();

    public static class Builder
    extends BuilderBase<Builder, Sort>
    implements io.helidon.common.Builder<Builder, Sort> {
        private Builder() {
        }

        public Sort buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SortImpl(this);
        }

        public Sort build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Sort>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<Order> orderBy = new ArrayList<Order>(List.of(Order.UNSORTED));
        private boolean isOrderByMutated;

        protected BuilderBase() {
        }

        public BUILDER from(Sort prototype) {
            if (!this.isOrderByMutated) {
                this.orderBy.clear();
            }
            this.addOrderBy(prototype.orderBy());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            if (this.isOrderByMutated) {
                if (builder.isOrderByMutated) {
                    this.addOrderBy(builder.orderBy);
                }
            } else {
                this.orderBy.clear();
                this.addOrderBy(builder.orderBy);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER orderBy(List<? extends Order> orderBy) {
            Objects.requireNonNull(orderBy);
            this.isOrderByMutated = true;
            this.orderBy.clear();
            this.orderBy.addAll(orderBy);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOrderBy(List<? extends Order> orderBy) {
            Objects.requireNonNull(orderBy);
            this.isOrderByMutated = true;
            this.orderBy.addAll(orderBy);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOrderBy(Order orderBy) {
            Objects.requireNonNull(orderBy);
            this.orderBy.add(orderBy);
            this.isOrderByMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addOrderBy(Consumer<Order.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Order.Builder builder = Order.builder();
            consumer.accept(builder);
            this.orderBy.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<Order> orderBy() {
            return this.orderBy;
        }

        public String toString() {
            return "SortBuilder{orderBy=" + String.valueOf(this.orderBy) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class SortImpl
        implements Sort {
            private final List<Order> orderBy;

            protected SortImpl(BuilderBase<?, ?> builder) {
                this.orderBy = List.copyOf(builder.orderBy());
            }

            @Override
            public List<Order> orderBy() {
                return this.orderBy;
            }

            public String toString() {
                return "Sort{orderBy=" + String.valueOf(this.orderBy) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sort)) {
                    return false;
                }
                Sort other = (Sort)o;
                return Objects.equals(this.orderBy, other.orderBy());
            }

            public int hashCode() {
                return Objects.hash(this.orderBy);
            }
        }
    }
}

