/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.data.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.data.codegen.DataCodegenTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class QueryMethods {
    private final Map<Type, List<TypedElementInfo>> methods;

    private QueryMethods(Map<Type, List<TypedElementInfo>> methods) {
        this.methods = methods;
    }

    static Builder builder() {
        return new Builder();
    }

    List<TypedElementInfo> methods(Type type) {
        return this.methods.getOrDefault((Object)type, Collections.emptyList());
    }

    static class Builder
    implements io.helidon.common.Builder<Builder, QueryMethods> {
        private final Map<Type, List<TypedElementInfo>> methods = new HashMap<Type, List<TypedElementInfo>>(Type.LENGTH);

        private Builder() {
        }

        static boolean filterMethods(TypedElementInfo info) {
            return info.kind() == ElementKind.METHOD;
        }

        public QueryMethods build() {
            return new QueryMethods(Map.copyOf(this.methods.entrySet().stream().map(Builder::unmodifiableEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        }

        Builder addMethod(TypedElementInfo methodInfo) {
            this.listByType(Builder.methodType(methodInfo)).add(methodInfo);
            return this;
        }

        private static Map.Entry<Type, List<TypedElementInfo>> unmodifiableEntry(Map.Entry<Type, List<TypedElementInfo>> entry) {
            entry.setValue(List.copyOf((Collection)entry.getValue()));
            return entry;
        }

        private static List<TypedElementInfo> createList(Type type) {
            return new ArrayList<TypedElementInfo>();
        }

        private static Type methodType(TypedElementInfo methodInfo) {
            HashSet<Type> types = new HashSet<Type>(Type.LENGTH);
            for (Annotation annotation : methodInfo.annotations()) {
                Type type = Type.TYPES_MAP.get(annotation.typeName());
                if (type == null) continue;
                types.add(type);
            }
            if (types.size() > 1) {
                throw new CodegenException("Method " + methodInfo.elementName() + " contains multiple repository method annotations.");
            }
            return types.isEmpty() ? Type.BY_NAME : (Type)((Object)types.iterator().next());
        }

        private List<TypedElementInfo> listByType(Type methodType) {
            return this.methods.computeIfAbsent(methodType, Builder::createList);
        }
    }

    static enum Type {
        QUERY,
        BY_NAME;

        private static final int LENGTH;
        private static final Map<TypeName, Type> TYPES_MAP;

        static {
            LENGTH = Type.values().length;
            TYPES_MAP = new HashMap<TypeName, Type>(LENGTH);
            TYPES_MAP.put(DataCodegenTypes.QUERY_ANNOTATION, QUERY);
        }
    }
}

