/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.metadata.codegen;

import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.config.metadata.codegen.ConfigMetadataTypes;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

record ConfiguredAnnotation(Optional<String> description, Optional<String> prefix, List<String> provides, boolean root, boolean ignoreBuildMethod) {
    static ConfiguredAnnotation createMeta(Annotation annotation) {
        return new ConfiguredAnnotation(annotation.stringValue("description").filter(Predicate.not(String::isBlank)), annotation.stringValue("prefix").filter(Predicate.not(String::isBlank)), ConfiguredAnnotation.toProvidesMeta(annotation), annotation.booleanValue("root").orElse(false), annotation.booleanValue("ignoreBuildMethod").orElse(false));
    }

    static ConfiguredAnnotation createBuilder(TypeInfo blueprint) {
        Optional<String> config = blueprint.findAnnotation(ConfigMetadataTypes.CONFIGURED).flatMap(rec$ -> ((Annotation)rec$).stringValue()).filter(Predicate.not(String::isBlank));
        boolean isRoot = config.isPresent() && blueprint.findAnnotation(ConfigMetadataTypes.CONFIGURED).flatMap(it -> it.booleanValue("root")).orElse(true) != false;
        return new ConfiguredAnnotation(blueprint.findAnnotation(ConfigMetadataTypes.DESCRIPTION).flatMap(rec$ -> ((Annotation)rec$).stringValue()), config, ConfiguredAnnotation.toProvidesBuilder(blueprint), isRoot, false);
    }

    private static List<String> toProvidesBuilder(TypeInfo blueprint) {
        return blueprint.findAnnotation(ConfigMetadataTypes.PROTOTYPE_PROVIDES).flatMap(rec$ -> ((Annotation)rec$).stringValues()).stream().flatMap(Collection::stream).toList();
    }

    private static List<String> toProvidesMeta(Annotation annotation) {
        return annotation.stringValues("provides").orElseGet(List::of);
    }
}

