/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.testing.virtualthreads;

import io.helidon.common.testing.virtualthreads.PinningAssertionError;
import java.time.Duration;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingStream;

public class PinningRecorder
implements AutoCloseable {
    public static final long DEFAULT_THRESHOLD = 20L;
    private static final String JFR_EVENT_VIRTUAL_THREAD_PINNED = "jdk.VirtualThreadPinned";
    private final RecordingStream recordingStream = new RecordingStream();
    private volatile PinningAssertionError pinningAssertionError;

    private PinningRecorder() {
    }

    public static PinningRecorder create() {
        return new PinningRecorder();
    }

    public void record(Duration threshold) {
        this.recordingStream.enable(JFR_EVENT_VIRTUAL_THREAD_PINNED).withThreshold(threshold).withStackTrace();
        this.recordingStream.onEvent(JFR_EVENT_VIRTUAL_THREAD_PINNED, this::record);
        this.recordingStream.startAsync();
    }

    @Override
    public void close() {
        try {
            this.recordingStream.stop();
        }
        finally {
            this.recordingStream.close();
        }
        this.checkAndThrow();
    }

    void checkAndThrow() {
        if (this.pinningAssertionError != null) {
            throw this.pinningAssertionError;
        }
    }

    private void record(RecordedEvent event) {
        PinningAssertionError e = new PinningAssertionError(event);
        if (this.pinningAssertionError == null) {
            this.pinningAssertionError = e;
        } else {
            this.pinningAssertionError.addSuppressed((Throwable)((Object)e));
        }
    }
}

