/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import io.helidon.common.processor.AnnotationFactory;
import io.helidon.common.processor.ToAnnotationValueVisitor;
import io.helidon.common.processor.TypeFactory;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

@Deprecated(forRemoval=true, since="4.1.0")
public final class TypeInfoFactory {
    private static final AllPredicate ALL_PREDICATE = new AllPredicate();
    private static final Set<TypeName> IGNORED_ANNOTATIONS = Set.of(TypeName.create(SuppressWarnings.class), TypeName.create(Override.class));
    private static final Map<TypeName, List<Annotation>> META_ANNOTATION_CACHE = new ConcurrentHashMap<TypeName, List<Annotation>>();

    private TypeInfoFactory() {
    }

    public static Optional<TypeInfo> create(ProcessingEnvironment processingEnv, TypeName typeName) {
        return TypeInfoFactory.create(processingEnv, typeName, (Predicate<TypedElementInfo>)ALL_PREDICATE);
    }

    public static Optional<TypeInfo> create(ProcessingEnvironment processingEnv, TypeName typeName, Predicate<TypedElementInfo> elementPredicate) throws IllegalArgumentException {
        TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(typeName.fqName());
        if (typeElement == null) {
            return Optional.empty();
        }
        return TypeFactory.createTypeName(typeElement.asType()).flatMap(it -> TypeInfoFactory.create(processingEnv, typeElement, elementPredicate, it));
    }

    public static Optional<TypeInfo> create(ProcessingEnvironment processingEnv, TypeElement typeElement) {
        return TypeInfoFactory.create(processingEnv, typeElement, (Predicate<TypedElementInfo>)ALL_PREDICATE);
    }

    public static Optional<TypeInfo> create(ProcessingEnvironment processingEnv, TypeElement typeElement, Predicate<TypedElementInfo> elementPredicate) throws IllegalArgumentException {
        return TypeFactory.createTypeName(typeElement.asType()).flatMap(it -> TypeInfoFactory.create(processingEnv, typeElement, elementPredicate, it));
    }

    public static Optional<TypedElementInfo> createTypedElementInfoFromElement(ProcessingEnvironment env, Element v, Elements elements) {
        String javadoc;
        TypeName type = TypeFactory.createTypeName(v).orElse(null);
        TypeMirror typeMirror = null;
        String defaultValue = null;
        List<Object> params = List.of();
        List<Object> componentTypeNames = List.of();
        List<Object> elementTypeAnnotations = List.of();
        Set<String> modifierNames = v.getModifiers().stream().map(javax.lang.model.element.Modifier::toString).collect(Collectors.toSet());
        Set<Object> thrownChecked = Set.of();
        if (v instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)v;
            typeMirror = Objects.requireNonNull(ee.getReturnType());
            params = ee.getParameters().stream().map(it -> TypeInfoFactory.createTypedElementInfoFromElement(env, it, elements).orElseThrow()).toList();
            AnnotationValue annotationValue = ee.getDefaultValue();
            defaultValue = annotationValue == null ? null : String.valueOf(annotationValue.accept(new ToAnnotationValueVisitor(elements).mapBooleanToNull(true).mapVoidToNull(true).mapBlankArrayToNull(true).mapEmptyStringToNull(true).mapToSourceDeclaration(true), null));
            thrownChecked = ee.getThrownTypes().stream().filter(it -> TypeInfoFactory.isCheckedException(env, it)).map(TypeFactory::createTypeName).flatMap(Optional::stream).collect(Collectors.toSet());
        } else if (v instanceof VariableElement) {
            VariableElement ve = (VariableElement)v;
            typeMirror = Objects.requireNonNull(ve.asType());
        }
        if (typeMirror != null) {
            if (type == null) {
                Element element = env.getTypeUtils().asElement(typeMirror);
                if (element instanceof TypeElement) {
                    TypeElement typeElement = (TypeElement)element;
                    type = TypeFactory.createTypeName(typeElement, typeMirror).orElse(TypeName.createFromGenericDeclaration((String)typeMirror.toString()));
                } else {
                    type = TypeFactory.createTypeName(typeMirror).orElse(TypeName.createFromGenericDeclaration((String)typeMirror.toString()));
                }
            }
            if (typeMirror instanceof DeclaredType) {
                List<? extends TypeMirror> args = ((DeclaredType)typeMirror).getTypeArguments();
                componentTypeNames = args.stream().map(TypeFactory::createTypeName).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
                elementTypeAnnotations = TypeInfoFactory.createAnnotations(((DeclaredType)typeMirror).asElement(), elements);
            }
        }
        javadoc = (javadoc = env.getElementUtils().getDocComment(v)) == null || javadoc.isBlank() ? "" : javadoc;
        TypedElementInfo.Builder builder = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().description(javadoc)).typeName(type)).componentTypes(componentTypeNames)).elementName(v.getSimpleName().toString())).kind(TypeInfoFactory.kind(v.getKind()))).annotations(TypeInfoFactory.createAnnotations(v, elements))).elementTypeAnnotations(elementTypeAnnotations)).elementModifiers(TypeInfoFactory.modifiers(modifierNames))).accessModifier(TypeInfoFactory.accessModifier(modifierNames))).throwsChecked(thrownChecked)).parameterArguments(params);
        TypeFactory.createTypeName(v.getEnclosingElement()).ifPresent(arg_0 -> ((TypedElementInfo.Builder)builder).enclosingType(arg_0));
        Optional.ofNullable(defaultValue).ifPresent(arg_0 -> ((TypedElementInfo.Builder)builder).defaultValue(arg_0));
        return Optional.of(builder.build());
    }

    private static boolean isCheckedException(ProcessingEnvironment env, TypeMirror it) {
        Elements elements = env.getElementUtils();
        Types types = env.getTypeUtils();
        TypeMirror exception = elements.getTypeElement(Exception.class.getName()).asType();
        TypeMirror runtimeException = elements.getTypeElement(RuntimeException.class.getName()).asType();
        return types.isAssignable(it, exception) && !types.isAssignable(it, runtimeException);
    }

    public static boolean isBuiltInJavaType(TypeName type) {
        return type.primitive() || type.packageName().startsWith("java.");
    }

    static io.helidon.common.types.ElementKind kind(ElementKind kind) {
        try {
            return io.helidon.common.types.ElementKind.valueOf((String)String.valueOf((Object)kind).toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ignored) {
            return io.helidon.common.types.ElementKind.OTHER;
        }
    }

    private static Optional<TypeInfo> create(ProcessingEnvironment processingEnv, TypeElement typeElement, Predicate<TypedElementInfo> elementPredicate, TypeName typeName) {
        Objects.requireNonNull(processingEnv);
        Objects.requireNonNull(typeElement);
        Objects.requireNonNull(elementPredicate);
        Objects.requireNonNull(typeName);
        if (typeName.resolvedName().equals(Object.class.getName())) {
            return Optional.empty();
        }
        TypeName genericTypeName = typeName.genericTypeName();
        LinkedHashSet<TypeName> allInterestingTypeNames = new LinkedHashSet<TypeName>();
        allInterestingTypeNames.add(genericTypeName);
        typeName.typeArguments().stream().map(TypeName::genericTypeName).filter(Predicate.not(TypeInfoFactory::isBuiltInJavaType)).filter(Predicate.not(rec$ -> ((TypeName)rec$).generic())).forEach(allInterestingTypeNames::add);
        Elements elementUtils = processingEnv.getElementUtils();
        try {
            TypeName fqSuperTypeName;
            List<Annotation> annotations = List.copyOf(TypeInfoFactory.createAnnotations(elementUtils.getTypeElement(genericTypeName.resolvedName()), elementUtils));
            HashSet<TypeName> annotationsOnTypeOrElements = new HashSet<TypeName>();
            annotations.stream().map(rec$ -> ((Annotation)rec$).typeName()).forEach(annotationsOnTypeOrElements::add);
            ArrayList elementsWeCareAbout = new ArrayList();
            ArrayList otherElements = new ArrayList();
            typeElement.getEnclosedElements().stream().map(it -> TypeInfoFactory.createTypedElementInfoFromElement(processingEnv, it, elementUtils)).filter(Optional::isPresent).map(Optional::get).forEach(it -> {
                if (elementPredicate.test((TypedElementInfo)it)) {
                    elementsWeCareAbout.add(it);
                } else {
                    otherElements.add(it);
                }
                annotationsOnTypeOrElements.addAll(it.annotations().stream().map(rec$ -> ((Annotation)rec$).typeName()).collect(Collectors.toSet()));
                it.parameterArguments().forEach(arg -> annotationsOnTypeOrElements.addAll(arg.annotations().stream().map(rec$ -> ((Annotation)rec$).typeName()).collect(Collectors.toSet())));
            });
            Set<String> modifiers = TypeInfoFactory.toModifierNames(typeElement.getModifiers());
            TypeInfo.Builder builder = (TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)TypeInfo.builder().typeName(typeName)).kind(TypeInfoFactory.kind(typeElement.getKind()))).annotations(annotations)).elementModifiers(TypeInfoFactory.modifiers(modifiers))).accessModifier(TypeInfoFactory.accessModifier(modifiers))).elementInfo(elementsWeCareAbout)).otherElementInfo(otherElements);
            elementsWeCareAbout.forEach(it -> {
                if (!TypeInfoFactory.isBuiltInJavaType(it.typeName()) && !it.typeName().generic()) {
                    allInterestingTypeNames.add(it.typeName().genericTypeName());
                }
                it.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).typeName()).map(TypeName::genericTypeName).filter(t -> !TypeInfoFactory.isBuiltInJavaType(t)).filter(t -> !t.generic()).forEach(allInterestingTypeNames::add);
            });
            TypeMirror superTypeMirror = typeElement.getSuperclass();
            TypeElement superTypeElement = (TypeElement)processingEnv.getTypeUtils().asElement(superTypeMirror);
            if (superTypeElement != null && (fqSuperTypeName = (TypeName)TypeFactory.createTypeName(superTypeElement, superTypeMirror).orElse(null)) != null && !TypeNames.OBJECT.equals((Object)fqSuperTypeName)) {
                TypeName genericSuperTypeName = fqSuperTypeName.genericTypeName();
                Optional<TypeInfo> superTypeInfo = TypeInfoFactory.create(processingEnv, superTypeElement, elementPredicate, fqSuperTypeName);
                superTypeInfo.ifPresent(arg_0 -> ((TypeInfo.Builder)builder).superTypeInfo(arg_0));
                allInterestingTypeNames.add(genericSuperTypeName);
                fqSuperTypeName.typeArguments().stream().map(TypeName::genericTypeName).filter(it -> !TypeInfoFactory.isBuiltInJavaType(it)).filter(it -> !it.generic()).forEach(allInterestingTypeNames::add);
            }
            typeElement.getInterfaces().forEach(interfaceTypeMirror -> {
                TypeElement element = (TypeElement)processingEnv.getTypeUtils().asElement((TypeMirror)interfaceTypeMirror);
                TypeName fqInterfaceTypeName = TypeFactory.createTypeName(interfaceTypeMirror).orElse(null);
                List<? extends TypeParameterElement> typeParameters = element.getTypeParameters();
                if (fqInterfaceTypeName != null) {
                    TypeName genericInterfaceTypeName = fqInterfaceTypeName.genericTypeName();
                    allInterestingTypeNames.add(genericInterfaceTypeName);
                    fqInterfaceTypeName.typeArguments().stream().map(TypeName::genericTypeName).filter(it -> !TypeInfoFactory.isBuiltInJavaType(it)).filter(it -> !it.generic()).forEach(allInterestingTypeNames::add);
                    TypeElement interfaceTypeElement = elementUtils.getTypeElement(fqInterfaceTypeName.genericTypeName().resolvedName());
                    if (interfaceTypeElement != null) {
                        Optional<TypeInfo> superTypeInfo = TypeInfoFactory.create(processingEnv, interfaceTypeElement, elementPredicate, fqInterfaceTypeName);
                        superTypeInfo.ifPresent(arg_0 -> ((TypeInfo.Builder)builder).addInterfaceTypeInfo(arg_0));
                    }
                }
            });
            AtomicReference moduleName = new AtomicReference();
            allInterestingTypeNames.forEach(it -> {
                TypeElement theTypeElement = elementUtils.getTypeElement(it.name());
                if ((theTypeElement == null || !TypeInfoFactory.isTypeInThisModule(theTypeElement, moduleName, processingEnv)) && TypeInfoFactory.hasValue((String)moduleName.get())) {
                    builder.putReferencedModuleName(it, (String)moduleName.get());
                }
            });
            ModuleElement module = processingEnv.getElementUtils().getModuleOf(typeElement);
            if (module != null) {
                builder.module(module.toString());
            }
            builder.referencedTypeNamesToAnnotations(TypeInfoFactory.toMetaAnnotations(processingEnv, annotationsOnTypeOrElements));
            return Optional.of(builder.build());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to process: " + String.valueOf(typeElement), e);
        }
    }

    private static Set<Modifier> modifiers(Set<String> stringModifiers) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        for (String stringModifier : stringModifiers) {
            try {
                result.add(Modifier.valueOf((String)stringModifier.toUpperCase(Locale.ROOT)));
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private static AccessModifier accessModifier(Set<String> stringModifiers) {
        for (String stringModifier : stringModifiers) {
            try {
                return AccessModifier.valueOf((String)stringModifier.toUpperCase(Locale.ROOT));
            }
            catch (Exception exception) {
            }
        }
        return AccessModifier.PACKAGE_PRIVATE;
    }

    private static void merge(Map<TypeName, List<Annotation>> result, Map<TypeName, List<Annotation>> metaAnnotations) {
        metaAnnotations.forEach((key1, value) -> result.computeIfAbsent((TypeName)key1, key -> new ArrayList()).addAll(value));
    }

    private static List<Annotation> createAnnotations(Element element, Elements elements) {
        return element.getAnnotationMirrors().stream().map(it -> AnnotationFactory.createAnnotation(it, elements)).filter(TypeInfoFactory::filterAnnotations).toList();
    }

    private static boolean filterAnnotations(Annotation annotation) {
        return !IGNORED_ANNOTATIONS.contains(annotation.typeName());
    }

    private static Set<String> toModifierNames(Set<javax.lang.model.element.Modifier> modifiers) {
        return modifiers.stream().map(Enum::name).collect(Collectors.toSet());
    }

    private static boolean isTypeInThisModule(TypeElement type, AtomicReference<String> moduleName, ProcessingEnvironment processingEnv) {
        String name;
        moduleName.set(null);
        ModuleElement module = processingEnv.getElementUtils().getModuleOf(type);
        if (!module.isUnnamed() && TypeInfoFactory.hasValue(name = module.getQualifiedName().toString())) {
            moduleName.set(name);
        }
        try {
            Trees trees = Trees.instance(processingEnv);
            TreePath path = trees.getPath(type);
            if (path == null) {
                return false;
            }
            JavaFileObject sourceFile = path.getCompilationUnit().getSourceFile();
            return sourceFile != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Map<TypeName, List<Annotation>> toMetaAnnotations(ProcessingEnvironment env, Set<TypeName> annotations) {
        if (annotations.isEmpty()) {
            return Map.of();
        }
        HashMap<TypeName, List<Annotation>> result = new HashMap<TypeName, List<Annotation>>();
        TypeInfoFactory.gatherMetaAnnotations(env, annotations, result);
        return result;
    }

    private static void gatherMetaAnnotations(ProcessingEnvironment env, Set<TypeName> annotationTypes, Map<TypeName, List<Annotation>> result) {
        if (annotationTypes.isEmpty()) {
            return;
        }
        Elements elements = env.getElementUtils();
        annotationTypes.stream().filter(Predicate.not(result::containsKey)).forEach(it -> {
            List<Object> meta = META_ANNOTATION_CACHE.get(it);
            boolean fromCache = true;
            if (meta == null) {
                fromCache = false;
                TypeElement typeElement = elements.getTypeElement(it.name());
                if (typeElement != null) {
                    List<Annotation> metaAnnotations = TypeInfoFactory.createAnnotations(typeElement, elements);
                    result.put((TypeName)it, (List<Annotation>)new ArrayList<Annotation>(metaAnnotations));
                    TypeInfoFactory.gatherMetaAnnotations(env, metaAnnotations.stream().map(rec$ -> ((Annotation)rec$).typeName()).collect(Collectors.toSet()), result);
                    meta = metaAnnotations;
                } else {
                    meta = List.of();
                }
            }
            if (!fromCache) {
                META_ANNOTATION_CACHE.putIfAbsent((TypeName)it, (List<Annotation>)meta);
            }
            if (!meta.isEmpty()) {
                result.put((TypeName)it, (List<Annotation>)meta);
            }
        });
    }

    private static boolean hasValue(String val) {
        return val != null && !val.isBlank();
    }

    private static final class AllPredicate
    implements Predicate<TypedElementInfo> {
        private AllPredicate() {
        }

        @Override
        public boolean test(TypedElementInfo typedElementName) {
            return true;
        }
    }
}

