/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import io.helidon.common.processor.AnnotationFactory;
import io.helidon.common.processor.ToStringAnnotationValueVisitor;
import io.helidon.common.processor.TypeFactory;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;

public final class TypeInfoFactory {
    private static final AllPredicate ALL_PREDICATE = new AllPredicate();

    private TypeInfoFactory() {
    }

    public static Optional<TypeInfo> create(ProcessingEnvironment env, TypeElement typeElement) {
        return TypeInfoFactory.create(env, typeElement, ALL_PREDICATE);
    }

    public static Optional<TypeInfo> create(ProcessingEnvironment processingEnv, TypeElement typeElement, Predicate<TypedElementInfo> elementPredicate) throws IllegalArgumentException {
        return TypeFactory.createTypeName(typeElement.asType()).flatMap(it -> TypeInfoFactory.create(processingEnv, typeElement, elementPredicate, it));
    }

    public static Optional<TypedElementInfo> createTypedElementInfoFromElement(ProcessingEnvironment env, Element v, Elements elements) {
        String javadoc;
        TypeName type = TypeFactory.createTypeName(v).orElse(null);
        TypeMirror typeMirror = null;
        String defaultValue = null;
        List<Object> params = List.of();
        List<Object> componentTypeNames = List.of();
        List<Object> elementTypeAnnotations = List.of();
        Set modifierNames = v.getModifiers().stream().map(Modifier::toString).collect(Collectors.toSet());
        if (v instanceof ExecutableElement) {
            ExecutableElement ee = (ExecutableElement)v;
            typeMirror = Objects.requireNonNull(ee.getReturnType());
            params = ee.getParameters().stream().map(it -> TypeInfoFactory.createTypedElementInfoFromElement(env, it, elements).orElseThrow()).collect(Collectors.toList());
            AnnotationValue annotationValue = ee.getDefaultValue();
            defaultValue = annotationValue == null ? null : annotationValue.accept(new ToStringAnnotationValueVisitor().mapBooleanToNull(true).mapVoidToNull(true).mapBlankArrayToNull(true).mapEmptyStringToNull(true).mapToSourceDeclaration(true), null);
        } else if (v instanceof VariableElement) {
            VariableElement ve = (VariableElement)v;
            typeMirror = Objects.requireNonNull(ve.asType());
        }
        if (typeMirror != null) {
            if (type == null) {
                type = TypeFactory.createTypeName(typeMirror).orElse(TypeName.createFromGenericDeclaration((String)typeMirror.toString()));
            }
            if (typeMirror instanceof DeclaredType) {
                List<? extends TypeMirror> args = ((DeclaredType)typeMirror).getTypeArguments();
                componentTypeNames = args.stream().map(TypeFactory::createTypeName).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
                elementTypeAnnotations = TypeInfoFactory.createAnnotations(((DeclaredType)typeMirror).asElement(), elements);
            }
        }
        javadoc = (javadoc = env.getElementUtils().getDocComment(v)) == null || javadoc.isBlank() ? "" : javadoc;
        TypedElementInfo.Builder builder = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().description(javadoc)).typeName(type)).componentTypes(componentTypeNames)).elementName(v.getSimpleName().toString())).elementTypeKind(v.getKind().name())).annotations(TypeInfoFactory.createAnnotations(v, elements))).elementTypeAnnotations(elementTypeAnnotations)).modifiers(modifierNames)).parameterArguments(params);
        TypeFactory.createTypeName(v.getEnclosingElement()).ifPresent(arg_0 -> ((TypedElementInfo.Builder)builder).enclosingType(arg_0));
        Optional.ofNullable(defaultValue).ifPresent(arg_0 -> ((TypedElementInfo.Builder)builder).defaultValue(arg_0));
        return Optional.of(builder.build());
    }

    public static boolean isBuiltInJavaType(TypeName type) {
        return type.primitive() || type.packageName().startsWith("java.");
    }

    private static Optional<TypeInfo> create(ProcessingEnvironment processingEnv, TypeElement typeElement, Predicate<TypedElementInfo> elementPredicate, TypeName typeName) {
        Objects.requireNonNull(processingEnv);
        Objects.requireNonNull(typeElement);
        Objects.requireNonNull(elementPredicate);
        Objects.requireNonNull(typeName);
        if (typeName.fqName().equals(Object.class.getName())) {
            return Optional.empty();
        }
        TypeName genericTypeName = typeName.genericTypeName();
        LinkedHashSet<TypeName> allInterestingTypeNames = new LinkedHashSet<TypeName>();
        allInterestingTypeNames.add(genericTypeName);
        typeName.typeArguments().stream().map(TypeName::genericTypeName).filter(Predicate.not(TypeInfoFactory::isBuiltInJavaType)).filter(Predicate.not(rec$ -> ((TypeName)rec$).generic())).forEach(allInterestingTypeNames::add);
        Elements elementUtils = processingEnv.getElementUtils();
        try {
            TypeElement superTypeElement;
            List<Annotation> annotations = List.copyOf(TypeInfoFactory.createAnnotations(elementUtils.getTypeElement(genericTypeName.fqName()), elementUtils));
            LinkedHashMap<TypeName, List<Annotation>> referencedAnnotations = new LinkedHashMap<TypeName, List<Annotation>>(TypeInfoFactory.toMetaAnnotations(annotations, processingEnv));
            ArrayList elementsWeCareAbout = new ArrayList();
            ArrayList otherElements = new ArrayList();
            typeElement.getEnclosedElements().stream().map(it -> TypeInfoFactory.createTypedElementInfoFromElement(processingEnv, it, elementUtils)).filter(Optional::isPresent).map(Optional::get).forEach(it -> {
                if (elementPredicate.test((TypedElementInfo)it)) {
                    elementsWeCareAbout.add(it);
                } else {
                    otherElements.add(it);
                }
                TypeInfoFactory.merge(referencedAnnotations, TypeInfoFactory.toMetaAnnotations(it.annotations(), processingEnv));
                it.parameterArguments().forEach(arg -> TypeInfoFactory.merge(referencedAnnotations, TypeInfoFactory.toMetaAnnotations(arg.annotations(), processingEnv)));
            });
            TypeInfo.Builder builder = (TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)TypeInfo.builder().typeName(typeName)).typeKind(String.valueOf((Object)typeElement.getKind()))).annotations(annotations)).referencedTypeNamesToAnnotations(referencedAnnotations)).modifiers(TypeInfoFactory.toModifierNames(typeElement.getModifiers()))).elementInfo(elementsWeCareAbout)).otherElementInfo(otherElements);
            elementsWeCareAbout.forEach(it -> {
                if (!TypeInfoFactory.isBuiltInJavaType(it.typeName()) && !it.typeName().generic()) {
                    allInterestingTypeNames.add(it.typeName().genericTypeName());
                }
                List annos = it.annotations();
                Map<TypeName, List<Annotation>> resolved = TypeInfoFactory.toMetaAnnotations(annos, processingEnv);
                resolved.forEach((arg_0, arg_1) -> ((TypeInfo.Builder)builder).putReferencedTypeNamesToAnnotation(arg_0, arg_1));
                resolved.keySet().stream().map(TypeName::genericTypeName).filter(t -> !TypeInfoFactory.isBuiltInJavaType(t)).filter(t -> !t.generic()).forEach(allInterestingTypeNames::add);
                it.parameterArguments().stream().map(rec$ -> ((TypedElementInfo)rec$).typeName()).map(TypeName::genericTypeName).filter(t -> !TypeInfoFactory.isBuiltInJavaType(t)).filter(t -> !t.generic()).forEach(allInterestingTypeNames::add);
            });
            TypeMirror superTypeMirror = typeElement.getSuperclass();
            TypeName fqSuperTypeName = TypeFactory.createTypeName(superTypeMirror).orElse(null);
            if (fqSuperTypeName != null && !fqSuperTypeName.name().equals(Object.class.getName()) && (superTypeElement = elementUtils.getTypeElement(fqSuperTypeName.name())) != null) {
                TypeName genericSuperTypeName = fqSuperTypeName.genericTypeName();
                Optional<TypeInfo> superTypeInfo = TypeInfoFactory.create(processingEnv, superTypeElement, elementPredicate, fqSuperTypeName);
                superTypeInfo.ifPresent(arg_0 -> ((TypeInfo.Builder)builder).superTypeInfo(arg_0));
                allInterestingTypeNames.add(genericSuperTypeName);
                fqSuperTypeName.typeArguments().stream().map(TypeName::genericTypeName).filter(it -> !TypeInfoFactory.isBuiltInJavaType(it)).filter(it -> !it.generic()).forEach(allInterestingTypeNames::add);
            }
            typeElement.getInterfaces().forEach(interfaceTypeMirror -> {
                TypeName fqInterfaceTypeName = TypeFactory.createTypeName(interfaceTypeMirror).orElse(null);
                if (fqInterfaceTypeName != null) {
                    TypeName genericInterfaceTypeName = fqInterfaceTypeName.genericTypeName();
                    allInterestingTypeNames.add(genericInterfaceTypeName);
                    fqInterfaceTypeName.typeArguments().stream().map(TypeName::genericTypeName).filter(it -> !TypeInfoFactory.isBuiltInJavaType(it)).filter(it -> !it.generic()).forEach(allInterestingTypeNames::add);
                    TypeElement interfaceTypeElement = elementUtils.getTypeElement(fqInterfaceTypeName.genericTypeName().fqName());
                    if (interfaceTypeElement != null) {
                        Optional<TypeInfo> superTypeInfo = TypeInfoFactory.create(processingEnv, interfaceTypeElement, elementPredicate, fqInterfaceTypeName);
                        superTypeInfo.ifPresent(arg_0 -> ((TypeInfo.Builder)builder).addInterfaceTypeInfo(arg_0));
                    }
                }
            });
            AtomicReference moduleName = new AtomicReference();
            allInterestingTypeNames.forEach(it -> {
                TypeElement theTypeElement = elementUtils.getTypeElement(it.name());
                if ((theTypeElement == null || !TypeInfoFactory.isTypeInThisModule(theTypeElement, moduleName, processingEnv)) && TypeInfoFactory.hasValue((String)moduleName.get())) {
                    builder.putReferencedModuleName(it, (String)moduleName.get());
                }
            });
            return Optional.of(builder.build());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to process: " + String.valueOf(typeElement), e);
        }
    }

    private static void merge(Map<TypeName, List<Annotation>> result, Map<TypeName, List<Annotation>> metaAnnotations) {
        metaAnnotations.forEach((key1, value) -> result.computeIfAbsent((TypeName)key1, key -> new ArrayList()).addAll(value));
    }

    private static List<Annotation> createAnnotations(Element element, Elements elements) {
        return element.getAnnotationMirrors().stream().map(it -> AnnotationFactory.createAnnotation(it, elements)).collect(Collectors.toList());
    }

    private static Set<String> toModifierNames(Set<Modifier> modifiers) {
        return modifiers.stream().map(Enum::name).collect(Collectors.toSet());
    }

    private static boolean isTypeInThisModule(TypeElement type, AtomicReference<String> moduleName, ProcessingEnvironment processingEnv) {
        String name;
        moduleName.set(null);
        ModuleElement module = processingEnv.getElementUtils().getModuleOf(type);
        if (!module.isUnnamed() && TypeInfoFactory.hasValue(name = module.getQualifiedName().toString())) {
            moduleName.set(name);
        }
        try {
            Trees trees = Trees.instance(processingEnv);
            TreePath path = trees.getPath(type);
            if (path == null) {
                return false;
            }
            JavaFileObject sourceFile = path.getCompilationUnit().getSourceFile();
            return sourceFile != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Map<TypeName, List<Annotation>> toMetaAnnotations(Collection<Annotation> annotations, ProcessingEnvironment processingEnv) {
        if (annotations.isEmpty()) {
            return Map.of();
        }
        Elements elements = processingEnv.getElementUtils();
        LinkedHashMap<TypeName, List<Annotation>> result = new LinkedHashMap<TypeName, List<Annotation>>();
        annotations.stream().filter(it -> !result.containsKey(it.typeName())).forEach(it -> {
            TypeElement typeElement = elements.getTypeElement(it.typeName().name());
            if (typeElement != null) {
                result.put(it.typeName(), new ArrayList<Annotation>(TypeInfoFactory.createAnnotations(typeElement, elements)));
            }
        });
        return result;
    }

    private static boolean hasValue(String val) {
        return val != null && !val.isBlank();
    }

    private static final class AllPredicate
    implements Predicate<TypedElementInfo> {
        private AllPredicate() {
        }

        @Override
        public boolean test(TypedElementInfo typedElementName) {
            return true;
        }
    }
}

