/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor;

import io.helidon.common.processor.ToStringAnnotationValueVisitor;
import io.helidon.common.processor.TypeFactory;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;

public final class AnnotationFactory {
    private AnnotationFactory() {
    }

    public static Set<Annotation> createAnnotations(List<? extends AnnotationMirror> annoMirrors, Elements elements) {
        return annoMirrors.stream().map(it -> AnnotationFactory.createAnnotation(it, elements)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Annotation> createAnnotations(Element type, Elements elements) {
        return AnnotationFactory.createAnnotations(type.getAnnotationMirrors(), elements);
    }

    public static Annotation createAnnotation(AnnotationMirror am, Elements elements) {
        TypeName val = TypeFactory.createTypeName(am.getAnnotationType()).orElseThrow(() -> new IllegalArgumentException("Cannot create annotation for non-existent type: " + String.valueOf(am.getAnnotationType())));
        return Annotation.create((TypeName)val, AnnotationFactory.extractAnnotationValues(am, elements));
    }

    private static Map<String, String> extractAnnotationValues(AnnotationMirror am, Elements elements) {
        return AnnotationFactory.extractAnnotationValues(elements.getElementValuesWithDefaults(am));
    }

    private static Map<String, String> extractAnnotationValues(Map<? extends ExecutableElement, ? extends AnnotationValue> values) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        values.forEach((el, val) -> {
            String name = el.getSimpleName().toString();
            String value = val.accept(new ToStringAnnotationValueVisitor(), null);
            if (value != null) {
                result.put(name, value);
            }
        });
        return result;
    }
}

