/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.ClassType;
import io.helidon.common.processor.classmodel.CommonComponent;
import io.helidon.common.processor.classmodel.ImportOrganizer;
import io.helidon.common.processor.classmodel.JavadocParser;
import io.helidon.common.processor.classmodel.Method;
import io.helidon.common.processor.classmodel.ModelComponent;
import io.helidon.common.processor.classmodel.ModelWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Deprecated(forRemoval=true, since="4.1.0")
public final class Javadoc
extends ModelComponent {
    private final List<String> content;
    private final Map<String, List<String>> parameters;
    private final Map<String, List<String>> genericsTokens;
    private final Map<String, List<String>> throwsDesc;
    private final Map<String, List<List<String>>> otherTags;
    private final List<String> returnDescription;
    private final List<String> deprecation;
    private final Boolean generate;

    private Javadoc(Builder builder) {
        super(builder);
        this.content = List.of(builder.contentBuilder.toString().split("\n"));
        this.parameters = Collections.unmodifiableMap(new LinkedHashMap<String, List<String>>(builder.filteredParameters));
        this.genericsTokens = Collections.unmodifiableMap(new LinkedHashMap<String, List<String>>(builder.genericArguments));
        this.throwsDesc = Collections.unmodifiableMap(new LinkedHashMap<String, List<String>>(builder.throwsDesc));
        this.otherTags = Javadoc.createCopyOfTagMap(builder.otherTags);
        this.returnDescription = List.copyOf(builder.finalReturnDescription);
        this.deprecation = List.copyOf(builder.deprecation);
        this.generate = builder.generate;
    }

    public static Javadoc parse(String fullJavadocString) {
        return Javadoc.builder().parse(fullJavadocString).build();
    }

    public static Javadoc parse(List<String> fullJavadocLines) {
        return Javadoc.builder().parse(fullJavadocLines).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Javadoc javadoc) {
        return new Builder().from(javadoc);
    }

    private static Map<String, List<List<String>>> createCopyOfTagMap(Map<String, List<List<String>>> otherTags) {
        HashMap newTags = new HashMap();
        for (Map.Entry<String, List<List<String>>> entry : otherTags.entrySet()) {
            newTags.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return Map.copyOf(newTags);
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        writer.write("/**\n");
        for (String string : this.content) {
            if (!string.isEmpty() && Character.isWhitespace(string.charAt(0))) {
                writer.writeLine(" *" + string);
                continue;
            }
            if (string.isBlank()) {
                writer.writeLine(" *");
                continue;
            }
            writer.writeLine(" * " + string);
        }
        if (this.hasAnyOtherParts()) {
            writer.write(" *\n");
        }
        for (Map.Entry entry : this.parameters.entrySet()) {
            this.writeTagInformation(writer, "param", (String)entry.getKey(), (List)entry.getValue());
        }
        for (Map.Entry entry : this.genericsTokens.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("<") && key.endsWith(">")) {
                this.writeTagInformation(writer, "param", key, (List)entry.getValue());
                continue;
            }
            this.writeTagInformation(writer, "param", "<" + key + ">", (List)entry.getValue());
        }
        if (!this.returnDescription.isEmpty()) {
            this.writeTagInformation(writer, "return", null, this.returnDescription);
        }
        for (Map.Entry entry : this.throwsDesc.entrySet()) {
            this.writeTagInformation(writer, "throws", (String)entry.getKey(), (List)entry.getValue());
        }
        if (!this.deprecation.isEmpty()) {
            this.writeTagInformation(writer, "deprecated", null, this.deprecation);
        }
        for (Map.Entry entry : this.otherTags.entrySet()) {
            for (List description : (List)entry.getValue()) {
                this.writeTagInformation(writer, (String)entry.getKey(), null, description);
            }
        }
        writer.write(" */");
    }

    private void writeTagInformation(ModelWriter writer, String paramName, String name, List<String> description) throws IOException {
        if (description.isEmpty()) {
            if (name != null) {
                writer.writeLine(" * @" + paramName + " " + name);
            } else {
                writer.writeLine(" * @" + paramName);
            }
        } else {
            boolean first = true;
            String padding = name != null ? " ".repeat(1 + paramName.length() + 1 + name.length() + 1) : " ".repeat(1 + paramName.length() + 1);
            for (String line : description) {
                if (first) {
                    if (name != null) {
                        writer.write(" * @" + paramName + " " + name);
                    } else {
                        writer.write(" * @" + paramName);
                    }
                    if (line.isBlank()) {
                        writer.writeLine("");
                    } else {
                        writer.writeLine(" " + line);
                    }
                    first = false;
                    continue;
                }
                writer.writeLine(" * " + padding + line);
            }
        }
    }

    public List<String> content() {
        return this.content;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public Map<String, List<String>> genericsTokens() {
        return this.genericsTokens;
    }

    public List<String> returnDescription() {
        return this.returnDescription;
    }

    public Map<String, List<String>> throwsDesc() {
        return this.throwsDesc;
    }

    public List<String> deprecation() {
        return this.deprecation;
    }

    public Map<String, List<List<String>>> otherTags() {
        return this.otherTags;
    }

    boolean generate() {
        return this.generate;
    }

    private boolean hasAnyOtherParts() {
        return !this.parameters.isEmpty() || !this.throwsDesc.isEmpty() || !this.genericsTokens.isEmpty() || !this.returnDescription.isEmpty() || !this.deprecation.isEmpty() || !this.otherTags.isEmpty();
    }

    public static final class Builder
    extends ModelComponent.Builder<Builder, Javadoc> {
        private final StringBuilder contentBuilder = new StringBuilder();
        private final Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();
        private final Map<String, List<String>> genericArguments = new LinkedHashMap<String, List<String>>();
        private final Map<String, List<String>> throwsDesc = new LinkedHashMap<String, List<String>>();
        private final Map<String, List<List<String>>> otherTags = new LinkedHashMap<String, List<List<String>>>();
        private final List<String> returnDescription = new ArrayList<String>();
        private final List<String> deprecation = new ArrayList<String>();
        private Map<String, List<String>> filteredParameters = this.parameters;
        private List<String> finalReturnDescription = this.returnDescription;
        private boolean generate = false;

        private Builder() {
        }

        public Javadoc build() {
            return new Javadoc(this);
        }

        public Builder addLine(String line) {
            this.contentBuilder.append(line).append("\n");
            return this;
        }

        public Builder add(String line) {
            this.contentBuilder.append(line);
            return this;
        }

        public Builder content(List<String> content) {
            this.contentBuilder.setLength(0);
            content.forEach(this::addLine);
            return this;
        }

        public Builder addParameter(String paramName, String description) {
            return this.addParameter(paramName, List.of(description.split("\n")));
        }

        public Builder addParameter(String paramName, List<String> description) {
            if (this.parameters.containsKey(paramName) && description.isEmpty()) {
                return this;
            }
            this.parameters.put(paramName, List.copyOf(description));
            return this;
        }

        public Builder addThrows(String exception, List<String> description) {
            this.throwsDesc.put(exception, description);
            return this;
        }

        public Builder addTag(String tag, String description) {
            this.otherTags.computeIfAbsent(tag, k -> new ArrayList()).add(List.of(description.split("\n")));
            return this;
        }

        public Builder addTag(String tag, List<String> description) {
            this.otherTags.computeIfAbsent(tag, k -> new ArrayList()).add(List.copyOf(description));
            return this;
        }

        public Builder returnDescription(String returnDescription) {
            return this.returnDescription(List.of(returnDescription));
        }

        public Builder returnDescription(List<String> returnDescription) {
            Objects.requireNonNull(returnDescription);
            if (returnDescription.isEmpty()) {
                return this;
            }
            this.returnDescription.clear();
            this.returnDescription.addAll(returnDescription);
            return this;
        }

        public Builder addGenericArgument(String argument, List<String> description) {
            this.genericArguments.put(argument, List.copyOf(description));
            return this;
        }

        public Builder addGenericArgument(String argument, String description) {
            this.genericArguments.put(argument, List.of(description.split("\n")));
            return this;
        }

        public Builder deprecation(String deprecation) {
            this.deprecation.clear();
            this.deprecation.add(deprecation);
            return this;
        }

        public Builder deprecation(List<String> deprecation) {
            this.deprecation.clear();
            this.deprecation.addAll(deprecation);
            return this;
        }

        public Builder generate(boolean generate) {
            this.generate = generate;
            return this;
        }

        public Builder from(Javadoc javadoc) {
            this.generate = true;
            this.deprecation.addAll(javadoc.deprecation());
            this.returnDescription.addAll(javadoc.returnDescription());
            this.contentBuilder.append(String.join((CharSequence)"\n", javadoc.content()));
            this.parameters.putAll(javadoc.parameters());
            this.genericArguments.putAll(javadoc.genericsTokens());
            this.throwsDesc.putAll(javadoc.throwsDesc());
            this.otherTags.putAll(javadoc.otherTags());
            return this;
        }

        public Builder parse(String fullJavadocString) {
            return JavadocParser.parse(this, fullJavadocString);
        }

        public Builder parse(List<String> fullJavadocLines) {
            return JavadocParser.parse(this, fullJavadocLines);
        }

        Javadoc build(CommonComponent.Builder<?, ?> componentBuilder) {
            if (componentBuilder instanceof Method.Builder) {
                Method.Builder methodBuilder = (Method.Builder)componentBuilder;
                return this.build(methodBuilder);
            }
            return this.build();
        }

        Javadoc build(Method.Builder methodBuilder) {
            this.filteredParameters = new LinkedHashMap<String, List<String>>();
            for (String paramName : methodBuilder.parameters().keySet()) {
                if (!this.parameters.containsKey(paramName)) continue;
                List<String> strings = this.parameters.get(paramName);
                this.filteredParameters.put(paramName, this.parameters.get(paramName));
            }
            if (methodBuilder.returnType().fqTypeName().equals(Void.TYPE.getName())) {
                this.finalReturnDescription = new ArrayList<String>();
            }
            return this.build();
        }
    }
}

