/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.AnnotatedComponent;
import io.helidon.common.processor.classmodel.Annotation;
import io.helidon.common.processor.classmodel.ClassModelException;
import io.helidon.common.processor.classmodel.ClassType;
import io.helidon.common.processor.classmodel.ImportOrganizer;
import io.helidon.common.processor.classmodel.ModelWriter;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Deprecated(forRemoval=true, since="4.1.0")
public final class Parameter
extends AnnotatedComponent {
    private final boolean optional;
    private final List<String> description;

    private Parameter(Builder builder) {
        super(builder);
        this.optional = builder.optional;
        this.description = List.copyOf(builder.description);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        for (Annotation annotation : this.annotations()) {
            annotation.writeComponent(writer, declaredTokens, imports, classType);
            writer.write(" ");
        }
        this.type().writeComponent(writer, declaredTokens, imports, classType);
        if (this.optional) {
            writer.write("...");
        }
        writer.write(" " + this.name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        return this.optional == parameter.optional && this.type().equals(parameter.type());
    }

    public int hashCode() {
        return Objects.hash(this.optional);
    }

    public String toString() {
        return "Parameter{type=" + this.type().fqTypeName() + ", simpleType=" + this.type().simpleTypeName() + ", name=" + this.name() + "}";
    }

    @Override
    List<String> description() {
        return this.description;
    }

    public static final class Builder
    extends AnnotatedComponent.Builder<Builder, Parameter> {
        private boolean optional = false;
        private final List<String> description = new ArrayList<String>();

        private Builder() {
        }

        public Parameter build() {
            if (this.type() == null || this.name() == null) {
                throw new ClassModelException("Annotation parameter must have name and type set");
            }
            return new Parameter(this);
        }

        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        @Override
        public Builder description(List<String> description) {
            this.description.clear();
            this.description.addAll(description);
            return this;
        }

        @Override
        public Builder type(TypeName type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(String type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(Class<?> type) {
            return (Builder)super.type(type);
        }
    }
}

