/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.AnnotatedComponent;
import io.helidon.common.processor.classmodel.ClassType;
import io.helidon.common.processor.classmodel.Content;
import io.helidon.common.processor.classmodel.ImportOrganizer;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.processor.classmodel.ModelWriter;
import io.helidon.common.processor.classmodel.Parameter;
import io.helidon.common.processor.classmodel.Throws;
import io.helidon.common.processor.classmodel.Type;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class Executable
extends AnnotatedComponent {
    private final Content content;
    private final List<Parameter> parameters;
    private final List<Type> exceptions;

    Executable(Builder<?, ?> builder) {
        super((AnnotatedComponent.Builder<?, ?>)builder);
        this.content = builder.contentBuilder.build();
        this.parameters = List.copyOf(builder.parameters.values());
        this.exceptions = List.copyOf(builder.exceptions);
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        super.addImports(imports);
        this.parameters.forEach(parameter -> parameter.addImports(imports));
        this.content.addImports(imports);
        this.exceptions.forEach(exc -> exc.addImports(imports));
    }

    void writeThrows(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        if (!this.exceptions().isEmpty()) {
            writer.write(" throws ");
            boolean first = true;
            for (Type exception : this.exceptions()) {
                if (first) {
                    first = false;
                } else {
                    writer.write(", ");
                }
                exception.writeComponent(writer, declaredTokens, imports, classType);
            }
        }
    }

    void writeBody(ModelWriter writer, ImportOrganizer imports) throws IOException {
        writer.increasePaddingLevel();
        writer.write("\n");
        this.content.writeBody(writer, imports);
        writer.decreasePaddingLevel();
        writer.write("\n");
    }

    List<Parameter> parameters() {
        return this.parameters;
    }

    List<Type> exceptions() {
        return this.exceptions;
    }

    boolean hasBody() {
        return this.content.hasBody();
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends Executable>
    extends AnnotatedComponent.Builder<B, T> {
        private final Map<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        private final Set<Type> exceptions = new LinkedHashSet<Type>();
        private final Content.Builder contentBuilder = Content.builder();

        Builder() {
        }

        @Override
        public B javadoc(Javadoc javadoc) {
            return (B)((Builder)super.javadoc(javadoc));
        }

        @Override
        public B addJavadocTag(String tag, String description) {
            return (B)((Builder)super.addJavadocTag(tag, description));
        }

        @Override
        public B accessModifier(AccessModifier accessModifier) {
            return (B)((Builder)super.accessModifier(accessModifier));
        }

        public B addLine(String line) {
            this.contentBuilder.addLine(line);
            return (B)((Builder)this.identity());
        }

        public B add(String line) {
            this.contentBuilder.add(line);
            return (B)((Builder)this.identity());
        }

        public B clearContent() {
            this.contentBuilder.clearContent();
            return (B)((Builder)this.identity());
        }

        public B typeName(String fqClassName) {
            this.contentBuilder.typeName(fqClassName);
            return (B)((Builder)this.identity());
        }

        public B typeName(Class<?> type) {
            return this.typeName(type.getCanonicalName());
        }

        public B typeName(TypeName typeName) {
            return this.typeName(typeName.resolvedName());
        }

        public B padding() {
            this.contentBuilder.padding();
            return (B)((Builder)this.identity());
        }

        public B padding(int repetition) {
            this.contentBuilder.padding(repetition);
            return (B)((Builder)this.identity());
        }

        public B increasePadding() {
            this.contentBuilder.increasePadding();
            return (B)((Builder)this.identity());
        }

        public B decreasePadding() {
            this.contentBuilder.decreasePadding();
            return (B)((Builder)this.identity());
        }

        public B content(String content) {
            return this.content(List.of(content));
        }

        public B content(List<String> content) {
            this.contentBuilder.content(content);
            return (B)((Builder)this.identity());
        }

        public B addParameter(Consumer<Parameter.Builder> consumer) {
            Parameter.Builder builder = Parameter.builder();
            consumer.accept(builder);
            return this.addParameter(builder.build());
        }

        public B addParameter(Parameter parameter) {
            this.parameters.put(parameter.name(), parameter);
            return (B)((Builder)this.addJavadocParameter(parameter.name(), parameter.description()));
        }

        public B addParameter(Supplier<Parameter> supplier) {
            Parameter parameter = supplier.get();
            this.parameters.put(parameter.name(), parameter);
            return (B)((Builder)this.addJavadocParameter(parameter.name(), parameter.description()));
        }

        public B addThrows(TypeName exception, String description) {
            Objects.requireNonNull(exception);
            Objects.requireNonNull(description);
            return this.addThrows((Throws.Builder ex) -> ex.type(exception).description(description));
        }

        public B addThrows(Consumer<Throws.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Throws.Builder builder = Throws.builder();
            consumer.accept(builder);
            return this.addThrows((Supplier<Throws>)((Object)builder));
        }

        public B addThrows(Supplier<Throws> supplier) {
            Objects.requireNonNull(supplier);
            return this.addThrows(supplier.get());
        }

        public B addThrows(Throws exception) {
            Objects.requireNonNull(exception);
            this.exceptions.add(exception.type());
            return (B)((Builder)this.addJavadocThrows(exception.type().fqTypeName(), exception.description()));
        }

        @Override
        public B generateJavadoc(boolean generateJavadoc) {
            return (B)((Builder)super.generateJavadoc(generateJavadoc));
        }

        Map<String, Parameter> parameters() {
            return this.parameters;
        }
    }
}

