/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.ClassModelException;
import io.helidon.common.processor.classmodel.ClassType;
import io.helidon.common.processor.classmodel.CommonComponent;
import io.helidon.common.processor.classmodel.ImportOrganizer;
import io.helidon.common.processor.classmodel.ModelWriter;
import io.helidon.common.processor.classmodel.Type;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

@Deprecated(forRemoval=true, since="4.1.0")
public final class AnnotationParameter
extends CommonComponent {
    private final String value;

    private AnnotationParameter(Builder builder) {
        super(builder);
        this.value = AnnotationParameter.resolveValueToString(builder.type(), builder.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        writer.write(this.name() + " = " + this.value);
    }

    private static String resolveValueToString(Type type, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass.isEnum()) {
            return valueClass.getSimpleName() + "." + ((Enum)value).name();
        }
        if (type.fqTypeName().equals(String.class.getName())) {
            String stringValue = value.toString();
            if (!stringValue.startsWith("\"") && !stringValue.endsWith("\"")) {
                return "\"" + stringValue + "\"";
            }
        } else if (value instanceof TypeName) {
            TypeName typeName = (TypeName)value;
            return typeName.fqName() + ".class";
        }
        return value.toString();
    }

    String value() {
        return this.value;
    }

    public static final class Builder
    extends CommonComponent.Builder<Builder, AnnotationParameter> {
        private Object value;

        private Builder() {
        }

        public AnnotationParameter build() {
            if (this.value == null || this.name() == null) {
                throw new ClassModelException("Annotation parameter needs to have value and type set");
            }
            return new AnnotationParameter(this);
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        public Builder value(Object value) {
            this.value = Objects.requireNonNull(value);
            return this;
        }

        @Override
        public Builder type(TypeName type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(String type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder type(Class<?> type) {
            return (Builder)super.type(type);
        }
    }
}

