/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.ClassModelException;
import io.helidon.common.processor.classmodel.ClassType;
import io.helidon.common.processor.classmodel.ImportOrganizer;
import io.helidon.common.processor.classmodel.ModelComponent;
import io.helidon.common.processor.classmodel.ModelWriter;
import io.helidon.common.processor.classmodel.Type;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Deprecated(forRemoval=true, since="4.1.0")
public final class TypeArgument
extends Type
implements TypeName {
    private final TypeName token;
    private final Type bound;
    private final List<String> description;

    private TypeArgument(Builder builder) {
        super(builder);
        this.token = builder.tokenBuilder.build();
        this.bound = builder.bound;
        this.description = builder.description;
    }

    public static TypeArgument create(String token) {
        return TypeArgument.builder().token(token).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public TypeName boxed() {
        return this;
    }

    @Override
    public TypeName genericTypeName() {
        if (this.bound == null) {
            return null;
        }
        return this.bound.genericTypeName();
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        writer.write(this.token.className());
        if (this.bound != null) {
            writer.write(" extends ");
            this.bound.writeComponent(writer, declaredTokens, imports, classType);
        }
    }

    @Override
    void addImports(ImportOrganizer.Builder imports) {
        if (this.bound != null) {
            this.bound.addImports(imports);
        }
    }

    public String token() {
        return this.token.className();
    }

    @Override
    public String packageName() {
        return "";
    }

    List<String> description() {
        return this.description;
    }

    @Override
    String fqTypeName() {
        return this.token.className();
    }

    @Override
    String resolvedTypeName() {
        return this.token.resolvedName();
    }

    @Override
    String simpleTypeName() {
        return this.token.className();
    }

    @Override
    boolean isArray() {
        return false;
    }

    @Override
    boolean innerClass() {
        return false;
    }

    @Override
    Optional<Type> declaringClass() {
        return Optional.empty();
    }

    public String className() {
        return this.token.className();
    }

    public List<String> enclosingNames() {
        return List.of();
    }

    public boolean primitive() {
        return false;
    }

    public boolean array() {
        return this.token.array();
    }

    public boolean generic() {
        return this.token.generic();
    }

    public boolean wildcard() {
        return this.token.wildcard();
    }

    public List<TypeName> typeArguments() {
        return List.of();
    }

    public List<String> typeParameters() {
        return List.of();
    }

    public String toString() {
        if (this.bound == null) {
            return "Token: " + this.token.className();
        }
        return "Token: " + this.token.className() + " Bound: " + String.valueOf(this.bound);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeArgument typeArgument1 = (TypeArgument)o;
        return Objects.equals(this.token, typeArgument1.token) && Objects.equals(this.bound, typeArgument1.bound);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.bound);
    }

    public int compareTo(TypeName o) {
        return this.token.compareTo((Object)o);
    }

    public static final class Builder
    extends ModelComponent.Builder<Builder, TypeArgument> {
        private final TypeName.Builder tokenBuilder = (TypeName.Builder)TypeName.builder().generic(true);
        private Type bound;
        private List<String> description = List.of();

        private Builder() {
        }

        public Builder token(String token) {
            ((TypeName.Builder)this.tokenBuilder.className(Objects.requireNonNull(token))).wildcard(token.startsWith("?"));
            return this;
        }

        public Builder bound(String bound) {
            return this.bound(TypeName.create((String)bound));
        }

        public Builder bound(Class<?> bound) {
            return this.bound(TypeName.create(bound));
        }

        public Builder bound(TypeName bound) {
            this.bound = Type.fromTypeName(bound);
            return this;
        }

        public Builder description(String description) {
            this.description = List.of(description.split("\n"));
            return this;
        }

        public Builder description(List<String> description) {
            this.description = List.copyOf(description);
            return this;
        }

        public TypeArgument build() {
            if (this.tokenBuilder.className().isEmpty()) {
                throw new ClassModelException("Token name needs to be specified.");
            }
            return new TypeArgument(this);
        }
    }
}

