/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.processor.classmodel;

import io.helidon.common.processor.classmodel.ClassBase;
import io.helidon.common.processor.classmodel.ClassModelException;
import io.helidon.common.processor.classmodel.ClassType;
import io.helidon.common.processor.classmodel.ImportOrganizer;
import io.helidon.common.processor.classmodel.ModelWriter;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;

public final class ClassModel
extends ClassBase {
    public static final String PADDING_TOKEN = "<<padding>>";
    public static final String TYPE_TOKEN = "@";
    public static final String TYPE_TOKEN_PATTERN = "@name@";
    public static final String DEFAULT_PADDING = "    ";
    private final String packageName;
    private final String copyright;
    private ImportOrganizer imports;

    private ClassModel(Builder builder) {
        super(builder);
        this.copyright = builder.copyright;
        this.packageName = builder.packageName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, DEFAULT_PADDING);
    }

    public void write(Writer writer, String padding) throws IOException {
        ModelWriter innerWriter = new ModelWriter(writer, padding);
        this.writeComponent(innerWriter, Set.of(), this.imports, this.classType());
    }

    @Override
    void writeComponent(ModelWriter writer, Set<String> declaredTokens, ImportOrganizer imports, ClassType classType) throws IOException {
        if (this.copyright != null) {
            String[] lines = this.copyright.split("\n");
            if (lines.length > 1) {
                boolean applyFormatting;
                boolean bl = applyFormatting = !lines[0].startsWith("/*");
                if (applyFormatting) {
                    writer.write("/*\n");
                }
                for (String line : lines) {
                    if (applyFormatting) {
                        writer.write(" * " + line + "\n");
                        continue;
                    }
                    writer.write(line + "\n");
                }
                if (applyFormatting) {
                    writer.write(" */\n\n");
                }
            } else {
                if (!lines[0].startsWith("//")) {
                    writer.write("// ");
                }
                writer.write(lines[0] + "\n");
            }
            writer.writeSeparatorLine();
        }
        if (this.packageName != null && !this.packageName.isEmpty()) {
            writer.write("package " + this.packageName + ";\n\n");
        }
        imports.writeImports(writer);
        imports.writeStaticImports(writer);
        super.writeComponent(writer, declaredTokens, imports, classType);
        writer.writeSeparatorLine();
    }

    public String toString() {
        return "ClassModel{packageName='" + this.packageName + "'name='" + this.name() + "'}";
    }

    public static final class Builder
    extends ClassBase.Builder<Builder, ClassModel> {
        private String packageName = "";
        private String copyright;

        private Builder() {
        }

        public ClassModel build() {
            if (this.name() == null) {
                throw new ClassModelException("Class need to have name specified");
            }
            ClassModel classModel = new ClassModel(this);
            ImportOrganizer.Builder importOrganizer = this.importOrganizer();
            classModel.addImports(importOrganizer);
            classModel.imports = importOrganizer.build();
            return classModel;
        }

        @Override
        public Builder accessModifier(AccessModifier accessModifier) {
            if (accessModifier == AccessModifier.PRIVATE) {
                throw new IllegalArgumentException("Outer class cannot be private!");
            }
            return (Builder)super.accessModifier(accessModifier);
        }

        public Builder packageName(String packageName) {
            this.packageName = packageName;
            this.importOrganizer().packageName(packageName);
            return this;
        }

        public Builder copyright(String copyright) {
            this.copyright = copyright;
            return this;
        }

        @Override
        public Builder name(String name) {
            this.importOrganizer().typeName(name);
            return (Builder)super.name(name);
        }

        @Override
        public Builder type(TypeName type) {
            this.packageName(type.packageName());
            this.name(type.className());
            return this;
        }
    }
}

