/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.CompositeBufferData;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.SocketWriter;
import io.helidon.common.socket.SocketWriterException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class SocketWriterAsync
extends SocketWriter
implements DataWriter {
    private static final System.Logger LOGGER = System.getLogger(SocketWriterAsync.class.getName());
    private static final BufferData CLOSING_TOKEN = BufferData.empty();
    private final ExecutorService executor;
    private final ArrayBlockingQueue<BufferData> writeQueue;
    private final CountDownLatch cdl = new CountDownLatch(1);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile Throwable caught;
    private volatile boolean run = true;
    private Thread thread;

    SocketWriterAsync(ExecutorService executor, HelidonSocket socket, int writeQueueLength) {
        super(socket);
        this.executor = executor;
        this.writeQueue = new ArrayBlockingQueue(writeQueueLength);
    }

    public void write(BufferData ... buffers) {
        for (BufferData buffer : buffers) {
            this.write(buffer);
        }
    }

    public void write(BufferData buffer) {
        this.checkRunning();
        try {
            if (!this.writeQueue.offer(buffer, 10L, TimeUnit.SECONDS)) {
                this.checkRunning();
                throw new IllegalStateException("Failed to write data to queue, timed out");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while trying to write to a queue", e);
        }
    }

    @Override
    public void close() {
        this.run = false;
        if (!this.started.get()) {
            return;
        }
        try {
            this.writeQueue.put(CLOSING_TOKEN);
            if (this.cdl.await(1000L, TimeUnit.MILLISECONDS)) {
                BufferData available;
                while ((available = this.writeQueue.poll()) != null) {
                    try {
                        this.writeNow(available);
                    }
                    catch (Exception e) {
                        LOGGER.log(System.Logger.Level.TRACE, "Failed to write last buffers during writer shutdown", (Throwable)e);
                    }
                }
            }
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void run() {
        this.thread = Thread.currentThread();
        this.thread.setName("[" + this.socket().socketId() + " " + this.socket().childSocketId() + "]");
        try {
            while (this.run) {
                BufferData newBuf;
                CompositeBufferData toWrite = BufferData.createComposite((BufferData)this.writeQueue.take());
                for (int i = 0; i < 1000 && (newBuf = this.writeQueue.poll()) != null; ++i) {
                    toWrite.add(newBuf);
                }
                this.writeNow((BufferData)toWrite);
            }
            this.cdl.countDown();
        }
        catch (Throwable e) {
            this.caught = e;
            this.run = false;
        }
    }

    private void checkRunning() {
        if (this.started.compareAndSet(false, true)) {
            this.executor.submit(this::run);
        }
        if (!this.run) {
            throw new SocketWriterException(this.caught);
        }
    }
}

