/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features.processor;

import io.helidon.common.features.processor.ModuleDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

class FeatureHandler {
    private static final String META_FILE = "META-INF/helidon/feature-metadata.properties";
    private final ModuleDescriptor descriptor = new ModuleDescriptor();
    private Messager messager;
    private Filer filer;

    FeatureHandler() {
    }

    void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
    }

    boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.doProcess(annotations, roundEnv);
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to process feature metadata annotation processor. " + e.getClass().getName() + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> modules = roundEnv.getElementsAnnotatedWithAny(annotations.toArray(new TypeElement[0]));
        for (Element element : modules) {
            this.processModule(element);
        }
        if (roundEnv.processingOver()) {
            this.storeMetadata();
        }
        return false;
    }

    private void processModule(Element moduleElement) {
        if (moduleElement.getKind() != ElementKind.MODULE) {
            return;
        }
        ModuleElement module = (ModuleElement)moduleElement;
        List<? extends AnnotationMirror> annotations = module.getAnnotationMirrors();
        String moduleName = module.getQualifiedName().toString();
        if (this.descriptor.name() != null && !moduleName.equals(this.descriptor.name())) {
            throw new IllegalStateException("Only one module can be compiled at a single time. Compiling both " + moduleName + ", and " + this.descriptor.name());
        }
        this.descriptor.moduleName(moduleName);
        this.descriptor.name(moduleName);
        for (AnnotationMirror annotationMirror : annotations) {
            switch (annotationMirror.getAnnotationType().asElement().toString()) {
                case "io.helidon.common.features.api.Aot": {
                    annotationMirror.getElementValues().forEach((method, value) -> {
                        if (method.getSimpleName().contentEquals("supported")) {
                            this.descriptor.aotSupported((Boolean)value.getValue());
                        } else if (method.getSimpleName().contentEquals("description")) {
                            this.descriptor.aotDescription((String)value.getValue());
                        }
                    });
                    break;
                }
                case "io.helidon.common.features.api.Preview": {
                    this.descriptor.preview(true);
                    break;
                }
                case "io.helidon.common.features.api.Incubating": {
                    this.descriptor.incubating(true);
                    break;
                }
                case "java.lang.Deprecated": {
                    this.descriptor.deprecated(true);
                    annotationMirror.getElementValues().forEach((method, value) -> {
                        if (method.getSimpleName().contentEquals("since")) {
                            this.descriptor.deprecatedSince((String)value.getValue());
                        }
                    });
                    if (!this.descriptor.noDeprecatedSince()) break;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to process feature metadata annotation processor.  Module " + moduleName + " has @Deprecated without since. Since must be defined.");
                    throw new IllegalStateException("Deprecated without since in module " + moduleName);
                }
                case "io.helidon.common.features.api.Feature": {
                    annotationMirror.getElementValues().forEach((method, value) -> {
                        if (method.getSimpleName().contentEquals("value")) {
                            this.descriptor.name((String)value.getValue());
                        } else if (method.getSimpleName().contentEquals("description")) {
                            this.descriptor.description((String)value.getValue());
                        } else if (method.getSimpleName().contentEquals("path")) {
                            Object pathValue = value.getValue();
                            List values = (List)pathValue;
                            String[] array = new String[values.size()];
                            for (int i = 0; i < array.length; ++i) {
                                array[i] = (String)((AnnotationValue)values.get(i)).getValue();
                            }
                            this.descriptor.path(array);
                        } else if (method.getSimpleName().contentEquals("in")) {
                            this.descriptor.in(this.enumList(value.getValue()));
                        } else if (method.getSimpleName().contentEquals("invalidIn")) {
                            this.descriptor.invalidIn(this.enumList(value.getValue()));
                        } else if (method.getSimpleName().contentEquals("since")) {
                            this.descriptor.since((String)value.getValue());
                        }
                    });
                    break;
                }
            }
        }
    }

    private String[] enumList(Object value) {
        List theValue = (List)value;
        String[] array = new String[theValue.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = String.valueOf(theValue.get(i));
        }
        return array;
    }

    private void storeMetadata() {
        try (PrintWriter metaWriter = new PrintWriter(this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", META_FILE, new Element[0]).openWriter());){
            this.descriptor.write(metaWriter);
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to write feature metadata: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

