/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.TypeInfoFactoryBase;
import io.helidon.codegen.apt.AptAnnotationFactory;
import io.helidon.codegen.apt.AptContext;
import io.helidon.codegen.apt.AptTypeFactory;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ModuleInfoExports;
import io.helidon.common.types.ModuleInfoOpens;
import io.helidon.common.types.ModuleInfoProvides;
import io.helidon.common.types.ModuleInfoRequires;
import io.helidon.common.types.ModuleTypeInfo;
import io.helidon.common.types.TypeName;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;

class AptModuleFactory
extends TypeInfoFactoryBase {
    private AptModuleFactory() {
    }

    static ModuleTypeInfo create(AptContext ctx, ModuleElement element) {
        List annotations = element.getAnnotationMirrors().stream().map(it -> AptAnnotationFactory.createAnnotation(it, ctx.aptEnv().getElementUtils())).flatMap(it -> AptModuleFactory.mapAnnotation((CodegenContext)ctx, (Annotation)it, (ElementKind)ElementKind.MODULE).stream()).collect(Collectors.toUnmodifiableList());
        String javadoc = ctx.aptEnv().getElementUtils().getDocComment(element);
        javadoc = javadoc == null || javadoc.isBlank() ? "" : javadoc;
        ModuleTypeInfo.Builder moduleBuilder = (ModuleTypeInfo.Builder)((ModuleTypeInfo.Builder)((ModuleTypeInfo.Builder)((ModuleTypeInfo.Builder)((ModuleTypeInfo.Builder)ModuleTypeInfo.builder().originatingElement((Object)element)).name(element.getQualifiedName().toString())).isOpen(element.isOpen())).description(javadoc)).annotations(annotations);
        List<? extends ModuleElement.Directive> directives = element.getDirectives();
        block7: for (ModuleElement.Directive directive : directives) {
            switch (directive.getKind()) {
                case REQUIRES: {
                    ModuleElement.RequiresDirective requiresDirective = (ModuleElement.RequiresDirective)directive;
                    moduleBuilder.addRequire(it -> ((ModuleInfoRequires.Builder)((ModuleInfoRequires.Builder)it.isStatic(requiresDirective.isStatic())).isTransitive(requiresDirective.isTransitive())).dependency(requiresDirective.getDependency().getQualifiedName().toString()));
                    break;
                }
                case EXPORTS: {
                    ModuleElement.Directive exportsDirective = (ModuleElement.ExportsDirective)directive;
                    ModuleInfoExports.Builder exportsBuilder = (ModuleInfoExports.Builder)ModuleInfoExports.builder().packageName(exportsDirective.getPackage().getQualifiedName().toString());
                    List<? extends ModuleElement> targetModules = exportsDirective.getTargetModules();
                    if (targetModules != null) {
                        targetModules.forEach(targetModule -> exportsBuilder.addTarget(targetModule.getQualifiedName().toString()));
                    }
                    moduleBuilder.addExport(exportsBuilder.build());
                    break;
                }
                case OPENS: {
                    ModuleElement.Directive exportsDirective = (ModuleElement.OpensDirective)directive;
                    ModuleInfoOpens.Builder opensBuilder = (ModuleInfoOpens.Builder)ModuleInfoOpens.builder().packageName(exportsDirective.getPackage().getQualifiedName().toString());
                    List<? extends ModuleElement> targetModules = exportsDirective.getTargetModules();
                    if (targetModules == null) continue block7;
                    targetModules.forEach(targetModule -> opensBuilder.addTarget(targetModule.getQualifiedName().toString()));
                    break;
                }
                case USES: {
                    ModuleElement.UsesDirective usesDirective = (ModuleElement.UsesDirective)directive;
                    AptTypeFactory.createTypeName(usesDirective.getService()).ifPresent(typeName -> moduleBuilder.addUse(it -> it.service(typeName)));
                    break;
                }
                case PROVIDES: {
                    ModuleElement.ProvidesDirective providesDirective = (ModuleElement.ProvidesDirective)directive;
                    Optional<TypeName> service = AptTypeFactory.createTypeName(providesDirective.getService());
                    List impls = providesDirective.getImplementations().stream().map(AptTypeFactory::createTypeName).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
                    if (!service.isPresent()) continue block7;
                    moduleBuilder.addProvide(it -> ((ModuleInfoProvides.Builder)it.service((TypeName)service.get())).addImplementations(impls));
                    break;
                }
            }
        }
        return moduleBuilder.build();
    }
}

