/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.Codegen;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenEvent;
import io.helidon.codegen.Option;
import io.helidon.codegen.apt.AptContext;
import io.helidon.codegen.apt.AptTypeFactory;
import io.helidon.codegen.apt.AptTypeInfoFactory;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public final class AptProcessor
extends AbstractProcessor {
    private static final TypeName GENERATOR = TypeName.create(AptProcessor.class);
    private AptContext ctx;
    private Codegen codegen;

    @Deprecated
    public AptProcessor() {
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Stream.concat(this.codegen.supportedAnnotations().stream().map(rec$ -> ((TypeName)rec$).fqName()), this.codegen.supportedAnnotationPackagePrefixes().stream().map(it -> it + "*")).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Codegen.supportedOptions().stream().map(Option::name).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.ctx = AptContext.create(processingEnv, Codegen.supportedOptions());
        this.codegen = Codegen.create((CodegenContext)this.ctx, (TypeName)GENERATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Thread thread = Thread.currentThread();
        ClassLoader previousClassloader = thread.getContextClassLoader();
        thread.setContextClassLoader(AptProcessor.class.getClassLoader());
        try {
            this.doProcess(annotations, roundEnv);
            boolean bl = true;
            return bl;
        }
        finally {
            thread.setContextClassLoader(previousClassloader);
        }
    }

    private void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.ctx.logger().log(System.Logger.Level.TRACE, "Process annotations: " + String.valueOf(annotations) + ", processing over: " + roundEnv.processingOver());
        if (roundEnv.processingOver()) {
            this.codegen.processingOver();
            return;
        }
        if (annotations.isEmpty()) {
            this.codegen.process(List.of());
            return;
        }
        List<TypeInfo> allTypes = this.discoverTypes(annotations, roundEnv);
        this.codegen.process(allTypes);
    }

    private List<TypeInfo> discoverTypes(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<TypeName, TypeElement> types = new HashMap<TypeName, TypeElement>();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(typeElement);
            block6: for (Element element2 : elementsAnnotatedWith) {
                ElementKind kind = element2.getKind();
                switch (kind) {
                    case ENUM: 
                    case INTERFACE: 
                    case CLASS: 
                    case ANNOTATION_TYPE: 
                    case RECORD: {
                        this.addType(types, element2, element2, typeElement);
                        continue block6;
                    }
                    case ENUM_CONSTANT: 
                    case CONSTRUCTOR: 
                    case METHOD: 
                    case FIELD: 
                    case STATIC_INIT: 
                    case INSTANCE_INIT: 
                    case RECORD_COMPONENT: {
                        this.addType(types, element2.getEnclosingElement(), element2, typeElement);
                        continue block6;
                    }
                    case PARAMETER: {
                        this.addType(types, element2.getEnclosingElement().getEnclosingElement(), element2, typeElement);
                        continue block6;
                    }
                }
                this.ctx.logger().log(System.Logger.Level.TRACE, "Ignoring annotated element, not supported: " + String.valueOf(element2) + ", kind: " + String.valueOf((Object)kind));
            }
        }
        return types.values().stream().flatMap(element -> {
            Optional<TypeInfo> typeInfo = AptTypeInfoFactory.create(this.ctx, element);
            if (typeInfo.isEmpty()) {
                this.ctx.logger().log(((CodegenEvent.Builder)((CodegenEvent.Builder)((CodegenEvent.Builder)CodegenEvent.builder().level(System.Logger.Level.WARNING)).message("Could not create TypeInfo for annotated type.")).addObject(element)).build());
            }
            return typeInfo.stream();
        }).toList();
    }

    private void addType(Map<TypeName, TypeElement> types, Element typeElement, Element processedElement, TypeElement annotation) {
        Optional<TypeName> typeName = AptTypeFactory.createTypeName(typeElement);
        if (typeName.isPresent()) {
            types.putIfAbsent(typeName.get(), (TypeElement)typeElement);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Could not create TypeName for annotated type. Annotation: " + String.valueOf(annotation), processedElement);
        }
    }
}

