/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.AnnotationDataConfigured;
import io.helidon.builder.processor.AnnotationDataOption;
import io.helidon.builder.processor.CustomMethods;
import io.helidon.builder.processor.PrototypeProperty;
import io.helidon.builder.processor.TypeContext;
import io.helidon.builder.processor.Types;
import io.helidon.common.Errors;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.processor.classmodel.Annotation;
import io.helidon.common.processor.classmodel.ClassModel;
import io.helidon.common.processor.classmodel.Constructor;
import io.helidon.common.processor.classmodel.Field;
import io.helidon.common.processor.classmodel.InnerClass;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.processor.classmodel.Method;
import io.helidon.common.processor.classmodel.Parameter;
import io.helidon.common.processor.classmodel.TypeArgument;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class GenerateAbstractBuilder {
    private GenerateAbstractBuilder() {
    }

    static void generate(ClassModel.Builder classModel, TypeName prototype, TypeName runtimeType, List<TypeArgument> typeArguments, TypeContext typeContext) {
        Optional<TypeName> superType = typeContext.typeInfo().superPrototype();
        classModel.addInnerClass(builder -> {
            typeArguments.forEach(arg_0 -> ((InnerClass.Builder)builder).addGenericArgument(arg_0));
            ((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)builder.name("BuilderBase")).isAbstract(true)).accessModifier(AccessModifier.PACKAGE_PRIVATE)).description("Fluent API builder base for {@link " + runtimeType.className() + "}.")).addGenericArgument(token -> token.token("BUILDER").description("type of the builder extending this abstract builder").bound(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(prototype.fqName() + ".BuilderBase")))).addTypeArguments(typeArguments)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build()))).addGenericArgument(token -> token.token("PROTOTYPE").description("type of the prototype interface that would be built by {@link #buildPrototype()}").bound(prototype))).addConstructor(constructor -> GenerateAbstractBuilder.createConstructor(constructor, typeContext));
            superType.ifPresent(type -> builder.superType(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(type.fqName() + ".BuilderBase")))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build()));
            if (typeContext.configuredData().configured() || GenerateAbstractBuilder.hasConfig(typeContext.propertyData().properties())) {
                builder.addInterface(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)"io.helidon.builder.api.Prototype.ConfiguredBuilder"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build());
            } else {
                builder.addInterface(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)"io.helidon.builder.api.Prototype.Builder"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build());
            }
            GenerateAbstractBuilder.fields(builder, typeContext, true);
            GenerateAbstractBuilder.fromInstanceMethod(builder, typeContext, prototype);
            GenerateAbstractBuilder.fromBuilderMethod(builder, typeContext, typeArguments);
            GenerateAbstractBuilder.preBuildPrototypeMethod(builder, typeContext);
            GenerateAbstractBuilder.validatePrototypeMethod(builder, typeContext);
            GenerateAbstractBuilder.addCustomBuilderMethods(typeContext, builder);
            GenerateAbstractBuilder.builderMethods(builder, typeContext);
            GenerateAbstractBuilder.toString(builder, typeContext, prototype.className() + "Builder", superType.isPresent(), typeContext.customMethods().prototypeMethods(), true);
            GenerateAbstractBuilder.generatePrototypeImpl(builder, typeContext, typeArguments);
        });
    }

    static void buildRuntimeObjectMethod(InnerClass.Builder classBuilder, TypeContext typeContext, boolean isBuilder) {
        TypeContext.TypeInformation typeInformation = typeContext.typeInfo();
        boolean hasRuntimeObject = typeInformation.runtimeObject().isPresent();
        TypeName builtObject = typeInformation.runtimeObject().orElse(typeInformation.prototype());
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("build")).addAnnotation(Annotation.create(Override.class))).returnType(builtObject).add("return ");
        if (hasRuntimeObject) {
            builder.typeName(builtObject.genericTypeName());
            if (isBuilder) {
                builder.addLine(".create(this.buildPrototype());");
            } else {
                builder.addLine(".create(this);");
            }
        } else if (isBuilder) {
            builder.addLine("build();");
        } else {
            builder.addLine("this;");
        }
        classBuilder.addMethod(builder);
        if (!isBuilder) {
            classBuilder.addMethod(method -> ((Method.Builder)((Method.Builder)method.name("get")).returnType(builtObject).addAnnotation(Annotation.create(Override.class))).addLine("return build();"));
        }
    }

    static boolean hasConfig(List<PrototypeProperty> properties) {
        return properties.stream().filter(it -> "config".equals(it.name())).anyMatch(it -> Types.CONFIG_TYPE.equals((Object)it.typeHandler().actualType()));
    }

    private static void addCustomBuilderMethods(TypeContext typeContext, InnerClass.Builder builder) {
        for (CustomMethods.CustomMethod customMethod : typeContext.customMethods().builderMethods()) {
            CustomMethods.Method generated = customMethod.generatedMethod().method();
            Method.Builder method = (Method.Builder)((Method.Builder)Method.builder().name(generated.name())).returnType(TypeName.createFromGenericDeclaration((String)"BUILDER")).addLine(customMethod.generatedMethod().callCode() + ";");
            for (String annotation : customMethod.generatedMethod().annotations()) {
                method.addAnnotation(Annotation.parse((String)annotation));
            }
            for (CustomMethods.Argument argument : generated.arguments()) {
                method.addParameter(param -> ((Parameter.Builder)param.name(argument.name())).type(argument.typeName()));
            }
            if (!generated.javadoc().isEmpty()) {
                Javadoc javadoc = Javadoc.builder().from(Javadoc.parse(generated.javadoc())).returnDescription("updated builder instance").build();
                method.javadoc(javadoc);
            }
            builder.addMethod(method);
        }
    }

    private static void createConstructor(Constructor.Builder constructor, TypeContext typeContext) {
        ((Constructor.Builder)constructor.description("Protected to support extensibility.")).accessModifier(AccessModifier.PROTECTED);
        for (PrototypeProperty prop : typeContext.propertyData().overridingProperties()) {
            if (!prop.configuredOption().hasDefault()) continue;
            constructor.addLine(prop.setterName() + "(" + prop.configuredOption().defaultValue() + ");");
        }
    }

    private static void builderMethods(InnerClass.Builder classBuilder, TypeContext typeContext) {
        List<PrototypeProperty> properties = typeContext.propertyData().properties();
        AnnotationDataConfigured configured = typeContext.configuredData();
        if (configured.configured() || GenerateAbstractBuilder.hasConfig(properties)) {
            GenerateAbstractBuilder.createConfigMethod(classBuilder, typeContext, configured, properties);
        }
        TypeName returnType = TypeName.createFromGenericDeclaration((String)"BUILDER");
        for (PrototypeProperty child : properties) {
            if (child.typeHandler().actualType().equals((Object)Types.CONFIG_TYPE)) continue;
            child.setters(classBuilder, returnType, child.configuredOption().javadoc());
        }
        for (PrototypeProperty child : properties) {
            String getterName = child.getterName();
            if ("config".equals(getterName) && configured.configured()) {
                if (child.typeHandler().actualType().equals((Object)Types.CONFIG_TYPE)) continue;
                throw new IllegalArgumentException("Configured property named \"config\" can only be of type " + Types.CONFIG_TYPE.fqName() + ", but is: " + child.typeName().fqName());
            }
            Method.Builder method = (Method.Builder)((Method.Builder)Method.builder().name(getterName)).returnType(child.builderGetterType()).addLine("return " + child.builderGetter() + ";");
            if (child.configuredOption().javadoc() != null) {
                ((Method.Builder)method.description(child.configuredOption().javadoc().content())).returnType(child.builderGetterType(), "the " + GenerateAbstractBuilder.toHumanReadable(child.name()));
            }
            classBuilder.addMethod(method);
        }
        if (configured.configured()) {
            TypeName configReturnType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Optional.class)).addTypeArgument(Types.CONFIG_TYPE)).build();
            Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("config")).description("If this instance was configured, this would be the config instance used.")).returnType(configReturnType, "config node used to configure this builder, or empty if not configured").add("return ")).typeName(Optional.class)).addLine(".ofNullable(config);");
            classBuilder.addMethod(method);
        }
    }

    private static void createConfigMethod(InnerClass.Builder classBuilder, TypeContext typeContext, AnnotationDataConfigured configured, List<PrototypeProperty> properties) {
        Javadoc javadoc = configured.configured() ? Javadoc.builder().addLine("Update builder from configuration (node of this type).").addLine("If a value is present in configuration, it would override currently configured values.").build() : Javadoc.builder().addLine("Config to use.").build();
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("config")).javadoc(javadoc)).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance").addParameter(param -> ((Parameter.Builder)param.name("config")).type(Types.CONFIG_TYPE).description("configuration instance used to obtain values to update this builder"))).addAnnotation(Annotation.create(Override.class))).typeName(Objects.class)).addLine(".requireNonNull(config);")).addLine("this.config = config;");
        if (typeContext.typeInfo().superPrototype().isPresent()) {
            builder.addLine("super.config(config);");
        }
        if (configured.configured()) {
            for (PrototypeProperty child : properties) {
                if (!child.configuredOption().configured() || child.configuredOption().provider()) continue;
                child.typeHandler().generateFromConfig(builder, child.configuredOption(), child.factoryMethods());
            }
        }
        builder.addLine("return self();");
        classBuilder.addMethod(builder);
    }

    private static void fromInstanceMethod(InnerClass.Builder builder, TypeContext typeContext, TypeName prototype) {
        Method.Builder methodBuilder = ((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("from")).returnType((TypeName)TypeArgument.create((String)"BUILDER")).description("Update this builder from an existing prototype instance.")).addParameter(param -> ((Parameter.Builder)param.name("prototype")).type(prototype).description("existing prototype to update this builder from"))).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance");
        typeContext.typeInfo().superPrototype().ifPresent(it -> methodBuilder.addLine("super.from(prototype);"));
        for (PrototypeProperty property : typeContext.propertyData().properties()) {
            TypeName declaredType = property.typeHandler().declaredType();
            if (declaredType.isSet() || declaredType.isList() || declaredType.isMap()) {
                methodBuilder.add("add");
                methodBuilder.add(GeneratorTools.capitalize((String)property.name()));
                methodBuilder.add("(prototype.");
                methodBuilder.add(property.typeHandler().getterName());
                methodBuilder.addLine("());");
                continue;
            }
            if ("config".equals(property.name()) && property.typeHandler().actualType().equals((Object)Types.CONFIG_TYPE)) {
                methodBuilder.add("this.config = prototype.config()");
                if (declaredType.isOptional()) {
                    methodBuilder.add(".orElse(null)");
                }
                methodBuilder.addLine(";");
                continue;
            }
            methodBuilder.add(property.typeHandler().setterName());
            methodBuilder.add("(prototype.");
            methodBuilder.add(property.typeHandler().getterName());
            methodBuilder.addLine("());");
        }
        methodBuilder.addLine("return self();");
        builder.addMethod(methodBuilder);
    }

    private static void fromBuilderMethod(InnerClass.Builder classBuilder, TypeContext typeContext, List<TypeArgument> arguments) {
        TypeName prototype = typeContext.typeInfo().prototype();
        TypeName parameterType = ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(prototype.fqName() + ".BuilderBase")))).addTypeArguments(arguments)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"?"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"?"))).build();
        Method.Builder methodBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("from")).addParameter(param -> ((Parameter.Builder)param.name("builder")).type(parameterType).description("existing builder prototype to update this builder from"))).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance").description("Update this builder from an existing prototype builder instance.");
        typeContext.typeInfo().superPrototype().ifPresent(it -> methodBuilder.addLine("super.from(builder);"));
        for (PrototypeProperty property : typeContext.propertyData().properties()) {
            TypeName declaredType = property.typeHandler().declaredType();
            String setterName = property.typeHandler().setterName();
            String getterName = property.typeHandler().getterName();
            if (property.builderGetterOptional()) {
                methodBuilder.addLine("builder." + getterName + "().ifPresent(this::" + setterName + ");");
                continue;
            }
            if (declaredType.isSet() || declaredType.isList() || declaredType.isMap()) {
                methodBuilder.add("add" + GeneratorTools.capitalize((String)property.name()));
            } else {
                methodBuilder.add(setterName);
            }
            methodBuilder.addLine("(builder." + getterName + "());");
        }
        methodBuilder.addLine("return self();");
        classBuilder.addMethod(methodBuilder);
    }

    private static void fields(InnerClass.Builder classBuilder, TypeContext typeContext, boolean isBuilder) {
        if (isBuilder && (typeContext.configuredData().configured() || GenerateAbstractBuilder.hasConfig(typeContext.propertyData().properties()))) {
            classBuilder.addField(builder -> builder.type(Types.CONFIG_TYPE).name("config"));
        }
        for (PrototypeProperty child : typeContext.propertyData().properties()) {
            if (isBuilder && child.configuredOption().hasAllowedValues()) {
                String allowedValues = child.configuredOption().allowedValues().stream().map(AnnotationDataOption.AllowedValue::value).map(it -> "\"" + it + "\"").collect(Collectors.joining(", "));
                classBuilder.addField(it -> ((Field.Builder)it.isFinal(true).isStatic(true).name(child.name().toUpperCase(Locale.ROOT) + "_ALLOWED_VALUES")).type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SET).addTypeArgument(Types.STRING_TYPE)).build()).defaultValue("@" + Set.class.getName() + "@.of(" + allowedValues + ")"));
            }
            if (!isBuilder || !child.typeHandler().actualType().equals((Object)Types.CONFIG_TYPE)) {
                classBuilder.addField(child.fieldDeclaration(isBuilder));
            }
            if (!isBuilder || !child.configuredOption().provider()) continue;
            classBuilder.addField(builder -> ((Field.Builder)builder.type(Boolean.TYPE).name(child.name() + "DiscoverServices")).defaultValue(String.valueOf(child.configuredOption().providerDiscoverServices())));
        }
    }

    private static void preBuildPrototypeMethod(InnerClass.Builder classBuilder, TypeContext typeContext) {
        Method.Builder preBuildBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("preBuildPrototype")).accessModifier(AccessModifier.PROTECTED)).description("Handles providers and decorators.");
        if (typeContext.propertyData().hasProvider()) {
            preBuildBuilder.addAnnotation(builder -> builder.type(SuppressWarnings.class).addParameter("value", (Object)"unchecked"));
        }
        typeContext.typeInfo().superPrototype().ifPresent(it -> preBuildBuilder.addLine("super.preBuildPrototype();"));
        if (typeContext.propertyData().hasProvider()) {
            boolean configured = typeContext.configuredData().configured();
            if (configured) {
                preBuildBuilder.addLine("this.config = config == null ? Config.empty() : config;");
            }
            for (PrototypeProperty property : typeContext.propertyData().properties()) {
                AnnotationDataOption configuredOption = property.configuredOption();
                if (!configuredOption.provider()) continue;
                boolean defaultDiscoverServices = configuredOption.providerDiscoverServices();
                preBuildBuilder.addLine("{");
                TypeName providerType = configuredOption.providerType();
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.add("var serviceLoader = ")).typeName("io.helidon.common.HelidonServiceLoader")).add(".create(")).typeName("java.util.ServiceLoader")).add(".load(")).typeName(providerType.fqName())).addLine(".class));");
                if (configured) {
                    TypeName typeName = property.typeHandler().declaredType();
                    if (typeName.isList() || typeName.isSet()) {
                        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.add("this.add")).add(GeneratorTools.capitalize((String)property.name()))).add("(discoverServices(config.get(\"")).add(configuredOption.configKey())).add("\"), serviceLoader, ")).typeName(providerType)).add(".class, ")).typeName(property.typeHandler().actualType())).add(".class, ")).add(property.name())).add("DiscoverServices")).addLine("));");
                    } else {
                        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.add("discoverService(config.get(\"")).add(configuredOption.configKey())).add("\"), serviceLoader, ")).typeName(providerType)).add(".class, ")).typeName(property.typeHandler().actualType())).add(".class, ")).add(property.name())).add("DiscoverServices).ifPresent(this::")).add(property.setterName())).addLine(");");
                    }
                } else if (defaultDiscoverServices) {
                    preBuildBuilder.addLine("this." + property.name() + "(serviceLoader.asList());");
                }
                preBuildBuilder.addLine("}");
            }
        }
        if (typeContext.typeInfo().decorator().isPresent()) {
            ((Method.Builder)((Method.Builder)preBuildBuilder.add("new ")).typeName(typeContext.typeInfo().decorator().get())).addLine("().decorate(this);");
        }
        classBuilder.addMethod(preBuildBuilder);
    }

    private static void validatePrototypeMethod(InnerClass.Builder classBuilder, TypeContext typeContext) {
        Method.Builder validateBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("validatePrototype")).accessModifier(AccessModifier.PROTECTED)).description("Validates required properties.");
        typeContext.typeInfo().superPrototype().ifPresent(it -> validateBuilder.addLine("super.validatePrototype();"));
        TypeContext.PropertyData propertyData = typeContext.propertyData();
        if (propertyData.hasRequired() || propertyData.hasNonNulls() || propertyData.hasAllowedValues()) {
            GenerateAbstractBuilder.requiredValidation(validateBuilder, typeContext);
        }
        classBuilder.addMethod(validateBuilder);
    }

    private static void requiredValidation(Method.Builder validateBuilder, TypeContext typeContext) {
        ((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.typeName(Errors.Collector.class)).add(" collector = ")).typeName(Errors.class)).addLine(".collector();");
        for (PrototypeProperty property : typeContext.propertyData().properties()) {
            String configKey = property.configuredOption().configKey();
            String propertyName = property.name();
            if (property.configuredOption().validateNotNull() && !property.configuredOption().hasDefault()) {
                ((Method.Builder)((Method.Builder)validateBuilder.addLine("if (" + propertyName + " == null) {")).add("collector.fatal(getClass(), \"Property \\\"")).add(configKey == null ? propertyName : configKey);
                if (property.configuredOption().required()) {
                    validateBuilder.addLine("\\\" is required, but not set\");");
                } else {
                    validateBuilder.addLine("\\\" must not be null, but not set\");");
                }
                validateBuilder.addLine("}");
            }
            if (!property.configuredOption().hasAllowedValues()) continue;
            String allowedValuesConstant = propertyName.toUpperCase(Locale.ROOT) + "_ALLOWED_VALUES";
            TypeName declaredType = property.typeHandler().declaredType();
            if (declaredType.isList() || declaredType.isSet()) {
                String single = "single" + GeneratorTools.capitalize((String)propertyName);
                validateBuilder.addLine("for (var " + single + " : " + propertyName + ") {");
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.addLine("if (!" + allowedValuesConstant + ".contains(String.valueOf(" + single + "))) {")).add("collector.fatal(getClass(), \"Property \\\"")).add(configKey == null ? propertyName : configKey)).add("\\\" contains value that is not within allowed values. Configured: \\\"\" + " + single + " + \"\\\"")).addLine(", expected one of: \\\"\" + " + allowedValuesConstant + " + \"\\\"\");");
                validateBuilder.addLine("}");
                validateBuilder.addLine("}");
                continue;
            }
            validateBuilder.add("if (");
            if (!declaredType.primitive()) {
                validateBuilder.add(propertyName + " != null && ");
            }
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.addLine("!" + allowedValuesConstant + ".contains(String.valueOf(" + propertyName + "))) {")).add("collector.fatal(getClass(), \"Property \\\"")).add(configKey == null ? propertyName : configKey)).add("\\\" value is not within allowed values. Configured: \\\"\" + " + propertyName + " + \"\\\"")).addLine(", expected one of: \\\"\" + " + allowedValuesConstant + " + \"\\\"\");");
            validateBuilder.addLine("}");
        }
        validateBuilder.addLine("collector.collect().checkValid();");
    }

    private static void generatePrototypeImpl(InnerClass.Builder classBuilder, TypeContext typeContext, List<TypeArgument> typeArguments) {
        Optional<TypeName> superPrototype = typeContext.typeInfo().superPrototype();
        TypeName prototype = typeContext.typeInfo().prototype();
        TypeName prototypeImpl = typeContext.typeInfo().prototypeImpl();
        String ifaceName = prototype.className();
        String implName = prototypeImpl.className();
        classBuilder.addInnerClass(builder -> {
            typeArguments.forEach(arg_0 -> ((InnerClass.Builder)builder).addGenericArgument(arg_0));
            ((InnerClass.Builder)((InnerClass.Builder)builder.name(implName)).accessModifier(AccessModifier.PROTECTED)).isStatic(true).description("Generated implementation of the prototype, can be extended by descendant prototype implementations.");
            superPrototype.ifPresent(it -> builder.superType(TypeName.create((String)(it.className() + "Impl"))));
            builder.addInterface(prototype);
            if (typeContext.blueprintData().isFactory()) {
                builder.addInterface(((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Supplier.class)).addTypeArgument(typeContext.typeInfo().runtimeObject().orElse(typeContext.typeInfo().prototype()))).build());
            }
            GenerateAbstractBuilder.fields(builder, typeContext, false);
            builder.addConstructor(constructor -> {
                ((Constructor.Builder)((Constructor.Builder)constructor.description("Create an instance providing a builder.")).accessModifier(AccessModifier.PROTECTED)).addParameter(param -> ((Parameter.Builder)param.name("builder")).type(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(ifaceName + ".BuilderBase")))).addTypeArguments(typeArguments)).addTypeArgument((TypeName)TypeArgument.create((String)"?"))).addTypeArgument((TypeName)TypeArgument.create((String)"?"))).build()).description("extending builder base of this prototype"));
                superPrototype.ifPresent(it -> constructor.addLine("super(builder);"));
                GenerateAbstractBuilder.implAssignToFields(constructor, typeContext);
            });
            if (typeContext.blueprintData().isFactory()) {
                GenerateAbstractBuilder.buildRuntimeObjectMethod(builder, typeContext, false);
            }
            for (CustomMethods.CustomMethod customMethod : typeContext.customMethods().prototypeMethods()) {
                CustomMethods.Method generated = customMethod.generatedMethod().method();
                Method.Builder method = ((Method.Builder)Method.builder().name(generated.name())).returnType(generated.returnType());
                for (String annotation : customMethod.generatedMethod().annotations()) {
                    method.addAnnotation(Annotation.parse((String)annotation));
                }
                if (!customMethod.generatedMethod().annotations().contains(Types.OVERRIDE)) {
                    method.addAnnotation(Annotation.create(Override.class));
                }
                generated.arguments().forEach(argument -> method.addParameter(param -> ((Parameter.Builder)param.name(argument.name())).type(argument.typeName())));
                method.addLine(customMethod.generatedMethod().callCode() + ";");
                builder.addMethod(method);
            }
            GenerateAbstractBuilder.implMethods(builder, typeContext);
            GenerateAbstractBuilder.toString(builder, typeContext, ifaceName, superPrototype.isPresent(), typeContext.customMethods().prototypeMethods(), false);
            GenerateAbstractBuilder.hashCodeAndEquals(builder, typeContext, ifaceName, superPrototype.isPresent());
        });
    }

    private static void hashCodeAndEquals(InnerClass.Builder classBuilder, TypeContext typeContext, String ifaceName, boolean hasSuper) {
        List<PrototypeProperty> equalityFields = typeContext.propertyData().properties().stream().filter(PrototypeProperty::equality).toList();
        GenerateAbstractBuilder.equalsMethod(classBuilder, ifaceName, hasSuper, equalityFields);
        GenerateAbstractBuilder.hashCodeMethod(classBuilder, hasSuper, equalityFields);
    }

    private static void equalsMethod(InnerClass.Builder classBuilder, String ifaceName, boolean hasSuper, List<PrototypeProperty> equalityFields) {
        String newLine = "\n<<padding>><<padding>>&& ";
        Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("equals")).returnType(TypeName.create(Boolean.TYPE)).addAnnotation(Annotation.create(Override.class))).addParameter(param -> ((Parameter.Builder)param.name("o")).type(Object.class))).addLine("if (o == this) {")).addLine("return true;")).addLine("}")).addLine("if (!(o instanceof " + ifaceName + " other)) {")).addLine("return false;")).addLine("}");
        method.add("return ");
        if (hasSuper) {
            method.add("super.equals(other)");
            if (!equalityFields.isEmpty()) {
                method.add(newLine);
            }
        }
        if (!hasSuper && equalityFields.isEmpty()) {
            method.add("true");
        } else {
            method.add(equalityFields.stream().map(field -> {
                if (field.typeName().array()) {
                    return "java.util.Arrays.equals(" + field.name() + ", other." + field.getterName() + "())";
                }
                if (field.typeName().primitive()) {
                    return field.name() + " == other." + field.getterName() + "()";
                }
                return "Objects.equals(" + field.name() + ", other." + field.getterName() + "())";
            }).collect(Collectors.joining(newLine)));
        }
        method.addLine(";");
        classBuilder.addMethod(method);
    }

    private static void hashCodeMethod(InnerClass.Builder classBuilder, boolean hasSuper, List<PrototypeProperty> equalityFields) {
        Method.Builder method = (Method.Builder)((Method.Builder)Method.builder().name("hashCode")).returnType(TypeName.create(Integer.TYPE)).addAnnotation(Annotation.create(Override.class));
        if (equalityFields.isEmpty()) {
            if (hasSuper) {
                method.addLine("return super.hashCode();");
            } else {
                method.addLine("return 1;");
            }
        } else {
            if (hasSuper) {
                ((Method.Builder)((Method.Builder)method.add("return 31 * super.hashCode() + ")).typeName(Objects.class)).add(".hash(");
            } else {
                ((Method.Builder)((Method.Builder)method.add("return ")).typeName(Objects.class)).add(".hash(");
            }
            ((Method.Builder)method.add(equalityFields.stream().map(PrototypeProperty::name).collect(Collectors.joining(", ")))).addLine(");");
        }
        classBuilder.addMethod(method);
    }

    private static void toString(InnerClass.Builder classBuilder, TypeContext typeContext, String typeName, boolean hasSuper, List<CustomMethods.CustomMethod> prototypeMethods, boolean isBuilder) {
        if (prototypeMethods.stream().map(CustomMethods.CustomMethod::generatedMethod).map(CustomMethods.GeneratedMethod::method).filter(it -> "toString".equals(it.name())).filter(it -> it.returnType().equals((Object)Types.STRING_TYPE)).anyMatch(it -> it.arguments().isEmpty())) {
            return;
        }
        Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("toString")).returnType(TypeName.create(String.class)).addAnnotation(Annotation.create(Override.class))).add("return \"" + typeName);
        List<PrototypeProperty> toStringFields = typeContext.propertyData().properties().stream().filter(PrototypeProperty::toStringValue).toList();
        if (toStringFields.isEmpty()) {
            method.addLine("{};\"");
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addLine("{\"")).increasePadding()).increasePadding()).addLine(toStringFields.stream().map(it -> {
                boolean secret = it.confidential() || it.typeHandler().actualType().equals((Object)Types.CHAR_ARRAY_TYPE);
                String name = it.name();
                if (secret) {
                    if (it.typeName().primitive() && !it.typeName().array()) {
                        return "+ \"" + name + "=****\"";
                    }
                    if (!isBuilder && it.typeName().genericTypeName().equals((Object)TypeNames.OPTIONAL)) {
                        return "+ \"" + name + "=\" + (" + name + ".isPresent() ? \"****\" : \"null\")";
                    }
                    return "+ \"" + name + "=\" + (" + name + " == null ? \"null\" : \"****\")";
                }
                return "+ \"" + name + "=\" + " + name;
            }).collect(Collectors.joining(" + \",\"\n")));
            if (hasSuper) {
                method.addLine("+ \"};\"");
            } else {
                method.add("+ \"}\"");
            }
        }
        if (hasSuper) {
            method.add("+ super.toString()");
        }
        method.addLine(";");
        classBuilder.addMethod(method);
    }

    private static void implMethods(InnerClass.Builder classBuilder, TypeContext typeContext) {
        for (PrototypeProperty child : typeContext.propertyData().properties()) {
            String fieldName = child.name();
            String getterName = child.getterName();
            classBuilder.addMethod(method -> ((Method.Builder)((Method.Builder)method.name(getterName)).returnType(child.typeHandler().declaredType()).addAnnotation(Annotation.create(Override.class))).addLine("return " + fieldName + ";"));
        }
    }

    private static void implAssignToFields(Constructor.Builder constructor, TypeContext typeContext) {
        for (PrototypeProperty child : typeContext.propertyData().properties()) {
            constructor.add("this." + child.name() + " = ");
            TypeName declaredType = child.typeHandler().declaredType();
            if (declaredType.genericTypeName().equals((Object)TypeNames.LIST)) {
                ((Constructor.Builder)constructor.typeName(List.class)).addLine(".copyOf(builder." + child.getterName() + "());");
                continue;
            }
            if (declaredType.genericTypeName().equals((Object)TypeNames.SET)) {
                ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.typeName(Collections.class)).add(".unmodifiableSet(new ")).typeName(LinkedHashSet.class)).addLine("<>(builder." + child.getterName() + "()));");
                continue;
            }
            if (declaredType.genericTypeName().equals((Object)TypeNames.MAP)) {
                ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.typeName(Collections.class)).add(".unmodifiableMap(new ")).typeName(LinkedHashMap.class)).addLine("<>(builder." + child.getterName() + "()));");
                continue;
            }
            if (child.builderGetterOptional() && !declaredType.isOptional()) {
                constructor.addLine("builder." + child.getterName() + "().get();");
                continue;
            }
            constructor.addLine("builder." + child.getterName() + "();");
        }
    }

    private static String toHumanReadable(String name) {
        char[] nameChars;
        StringBuilder result = new StringBuilder();
        for (char nameChar : nameChars = name.toCharArray()) {
            if (Character.isUpperCase(nameChar)) {
                if (!result.isEmpty()) {
                    result.append(' ');
                }
                result.append(Character.toLowerCase(nameChar));
                continue;
            }
            result.append(nameChar);
        }
        return result.toString();
    }
}

