/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.GeneratedMethod;
import io.helidon.builder.processor.Javadoc;
import io.helidon.builder.processor.MethodSignature;
import io.helidon.builder.processor.ProcessingContext;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

record PrototypeProperty(MethodSignature signature, TypeHandler typeHandler, ConfiguredOption configuredOption, Singular singular, FactoryMethods factoryMethods, boolean equality, boolean toStringValue, boolean confidential) {
    private static final Set<String> RESERVED_WORDS = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null");

    static PrototypeProperty create(ProcessingContext processingContext, TypeInfo blueprint, TypedElementInfo element, boolean beanStyleAccessors) {
        boolean isBoolean = element.typeName().boxed().equals((Object)Types.BOXED_BOOLEAN_TYPE);
        String getterName = element.elementName();
        Object name = PrototypeProperty.propertyName(getterName, isBoolean, beanStyleAccessors);
        String setterName = PrototypeProperty.setterName((String)name, beanStyleAccessors);
        if (RESERVED_WORDS.contains(name)) {
            name = "the" + GeneratorTools.capitalize((String)name);
        }
        TypeName returnType = element.typeName();
        boolean sameGeneric = element.hasAnnotation(Types.PROTOTYPE_SAME_GENERIC_TYPE);
        TypeHandler typeHandler = TypeHandler.create((String)name, getterName, setterName, returnType, sameGeneric);
        ConfiguredOption configuredOption = ConfiguredOption.create(typeHandler, element);
        Singular singular = Singular.create((String)name, element);
        FactoryMethods factoryMethods = FactoryMethods.create(processingContext, blueprint, typeHandler);
        boolean confidential = element.hasAnnotation(Types.CONFIDENTIAL_TYPE);
        Optional redundantAnnotation = element.findAnnotation(Types.REDUNDANT_TYPE);
        boolean toStringValue = redundantAnnotation.flatMap(it -> it.getValue("stringValue")).map(Boolean::parseBoolean).orElse(false) == false;
        boolean equality = redundantAnnotation.flatMap(it -> it.getValue("equality")).map(Boolean::parseBoolean).orElse(false) == false;
        return new PrototypeProperty(MethodSignature.create(element), typeHandler, configuredOption, singular, factoryMethods, equality, toStringValue, confidential);
    }

    List<GeneratedMethod> setters(TypeName builderType, Javadoc blueprintJavadoc) {
        ArrayList<GeneratedMethod> result = new ArrayList<GeneratedMethod>();
        this.typeHandler().setters(this.configuredOption(), this.singular(), result, this.factoryMethods(), builderType, blueprintJavadoc);
        return result;
    }

    String name() {
        return this.typeHandler.name();
    }

    String getterName() {
        return this.typeHandler.getterName();
    }

    String setterName() {
        return this.typeHandler.setterName();
    }

    TypeName typeName() {
        return this.typeHandler.declaredType();
    }

    String builderGetter() {
        return this.typeHandler().generateBuilderGetter();
    }

    public String fieldDeclaration(boolean isBuilder) {
        return this.typeHandler.fieldDeclaration(this.configuredOption(), isBuilder, !isBuilder);
    }

    private static String setterName(String name, boolean beanStyleAccessors) {
        if (beanStyleAccessors || RESERVED_WORDS.contains(name)) {
            return "set" + GeneratorTools.capitalize((String)name);
        }
        return name;
    }

    private static String propertyName(String getterName, boolean isBoolean, boolean beanStyleAccessors) {
        if (beanStyleAccessors) {
            if (isBoolean && getterName.startsWith("is")) {
                return PrototypeProperty.deCapitalize(getterName.substring(2));
            }
            if (getterName.startsWith("get")) {
                return PrototypeProperty.deCapitalize(getterName.substring(3));
            }
        }
        return getterName;
    }

    private static String deCapitalize(String string) {
        if (string.isBlank()) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    private static String toKey(String propertyName) {
        char[] chars;
        StringBuilder result = new StringBuilder(propertyName.length() + 5);
        for (char aChar : chars = propertyName.toCharArray()) {
            if (Character.isUpperCase(aChar)) {
                if (result.length() == 0) {
                    result.append(Character.toLowerCase(aChar));
                    continue;
                }
                result.append('-').append(Character.toLowerCase(aChar));
                continue;
            }
            result.append(aChar);
        }
        return result.toString();
    }

    record ConfiguredOption(String configKey, Javadoc description, boolean required, boolean validateNotNull, String defaultValue, boolean builderMethod, boolean notConfigured, boolean provider, ProviderOption providerOption) {
        static ConfiguredOption create(TypeHandler typeHandler, TypedElementInfo element) {
            ConfiguredOption configuredOption = element.findAnnotation(Types.CONFIGURED_OPTION_TYPE).map(configuredAnnotation -> ConfiguredOption.configuredFromAnnotation(typeHandler, element, configuredAnnotation)).orElseGet(() -> ConfiguredOption.configuredNoAnnotation(typeHandler, element));
            TypeName genericType = typeHandler.declaredType().genericTypeName();
            if (genericType.primitive() && !genericType.array()) {
                return configuredOption;
            }
            if (!(configuredOption.hasDefault() || genericType.equals((Object)TypeNames.OPTIONAL) || genericType.equals((Object)TypeNames.MAP) || genericType.equals((Object)TypeNames.SET) || genericType.equals((Object)TypeNames.LIST))) {
                return configuredOption.withValidateNotNull();
            }
            return configuredOption;
        }

        boolean hasDefault() {
            return this.defaultValue != null;
        }

        ConfiguredOption withValidateNotNull() {
            return new ConfiguredOption(this.configKey, this.description, this.required, true, this.defaultValue, this.builderMethod, this.notConfigured, this.provider, this.providerOption);
        }

        private static ConfiguredOption configuredNoAnnotation(TypeHandler typeHandler, TypedElementInfo element) {
            return new ConfiguredOption(null, element.description().map(Javadoc::parse).orElseGet(() -> new Javadoc(List.of("Option " + typeHandler.name()), List.of(), List.of(typeHandler.name()), List.of())), false, false, null, true, true, false, null);
        }

        private static ConfiguredOption configuredFromAnnotation(TypeHandler typeHandler, TypedElementInfo element, Annotation configuredAnnotation) {
            boolean required = configuredAnnotation.getValue("required").map(Boolean::parseBoolean).orElse(false);
            boolean provider = configuredAnnotation.getValue("provider").map(Boolean::parseBoolean).orElse(false);
            return new ConfiguredOption(ConfiguredOption.toConfigKey(configuredAnnotation, typeHandler.name()), configuredAnnotation.getValue("description").filter(Predicate.not(String::isBlank)).or(() -> element.description()).map(Javadoc::parse).orElseGet(() -> new Javadoc(List.of("Option " + typeHandler.name()), List.of(), List.of(typeHandler.name()), List.of())), required, required, configuredAnnotation.value().filter(Predicate.not("io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED"::equals)).map(typeHandler::toDefaultValue).orElse(null), configuredAnnotation.getValue("builderMethod").map(Boolean::parseBoolean).orElse(true), configuredAnnotation.getValue("notConfigured").map(Boolean::parseBoolean).orElse(false), provider, provider ? ProviderOption.create(configuredAnnotation) : null);
        }

        private static String toConfigKey(Annotation configuredOption, String propertyName) {
            String key = configuredOption.getValue("key").orElse(null);
            if (key == null || key.isBlank()) {
                return PrototypeProperty.toKey(propertyName);
            }
            return key;
        }
    }

    record Singular(boolean hasSingular, String singularName) {
        static Singular empty() {
            return new Singular(false, null);
        }

        static Singular create(String name, TypedElementInfo element) {
            return element.findAnnotation(Types.SINGULAR_TYPE).map(it -> new Singular(true, it.value().filter(Predicate.not(String::isBlank)).orElseGet(() -> name.endsWith("s") ? name.substring(0, name.length() - 1) : name))).orElseGet(Singular::empty);
        }
    }

    record ProviderOption(TypeName serviceProviderInterface, boolean defaultDiscoverServices) {
        public static ProviderOption create(Annotation configuredAnnotation) {
            TypeName providerType = configuredAnnotation.getValue("providerType").map(TypeName::create).filter(Predicate.not(arg_0 -> ((TypeName)Types.CONFIGURED_OPTION_TYPE).equals(arg_0))).orElseThrow(() -> new IllegalArgumentException("When a @ConfiguredOption has provided=true, the providerType must be specified."));
            boolean defaultDiscoverServices = configuredAnnotation.getValue("providerDiscoverServices").map(Boolean::parseBoolean).orElse(true);
            return new ProviderOption(providerType, defaultDiscoverServices);
        }
    }
}

