/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.CustomMethods;
import io.helidon.builder.processor.GeneratedMethod;
import io.helidon.builder.processor.Javadoc;
import io.helidon.builder.processor.PrototypeProperty;
import io.helidon.builder.processor.TypeContext;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class GenerateAbstractBuilder {
    private static final String SOURCE_SPACING = "    ";

    private GenerateAbstractBuilder() {
    }

    static void generate(PrintWriter pw, TypeName prototype, TypeName runtimeType, String typeArguments, TypeContext typeContext) {
        CustomMethods.Method generated;
        Optional<TypeName> superType = typeContext.typeInfo().superPrototype();
        String prototypeWithTypes = prototype.className() + typeArguments;
        Object typeArgumentNames = "";
        if (!typeArguments.isEmpty()) {
            typeArgumentNames = typeArguments.substring(1, typeArguments.length() - 1) + ", ";
        }
        pw.print(SOURCE_SPACING);
        pw.println("/**");
        pw.print(SOURCE_SPACING);
        pw.print(" * Fluent API builder base for {@link ");
        pw.print(runtimeType.className());
        pw.println("}.");
        pw.print(SOURCE_SPACING);
        pw.println(" *");
        pw.print(SOURCE_SPACING);
        pw.println(" * @param <BUILDER> type of the builder extending this abstract builder");
        pw.print(SOURCE_SPACING);
        pw.println(" * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}");
        pw.print(SOURCE_SPACING);
        pw.println(" */");
        pw.print(SOURCE_SPACING);
        pw.print("abstract class BuilderBase<");
        pw.print((String)typeArgumentNames);
        pw.print("BUILDER extends BuilderBase<");
        pw.print((String)typeArgumentNames);
        pw.print("BUILDER, PROTOTYPE>");
        pw.print(", PROTOTYPE extends ");
        pw.print(prototypeWithTypes);
        pw.println(">");
        superType.ifPresent(type -> {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("extends ");
            pw.print(type.fqName());
            pw.println(".BuilderBase<BUILDER, PROTOTYPE>");
        });
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("implements ");
        if (typeContext.configuredData().configured() || GenerateAbstractBuilder.hasConfig(typeContext.propertyData().properties())) {
            pw.print("io.helidon.builder.api.Prototype.ConfiguredBuilder");
        } else {
            pw.print("io.helidon.builder.api.Prototype.Builder");
        }
        pw.print("<BUILDER, PROTOTYPE>,");
        pw.print(prototypeWithTypes);
        pw.println(" {");
        GenerateAbstractBuilder.fields(pw, typeContext, true);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("/**");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * Protected to support extensibility.");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" *");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" */");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("protected BuilderBase() {");
        for (PrototypeProperty prop : typeContext.propertyData().overridingProperties()) {
            if (!prop.configuredOption().hasDefault()) continue;
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(prop.setterName());
            pw.print("(");
            pw.print(prop.configuredOption().defaultValue());
            pw.println(");");
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
        pw.println();
        GenerateAbstractBuilder.fromInstanceMethod(pw, typeContext, prototypeWithTypes);
        GenerateAbstractBuilder.fromBuilderMethod(pw, typeContext, (String)typeArgumentNames);
        GenerateAbstractBuilder.preBuildPrototypeMethod(pw, typeContext);
        GenerateAbstractBuilder.validatePrototypeMethod(pw, typeContext);
        CustomMethods customMethods = typeContext.customMethods();
        for (CustomMethods.CustomMethod customMethod : customMethods.prototypeMethods()) {
            generated = customMethod.generatedMethod().method();
            if (!generated.javadoc().isEmpty()) {
                Javadoc parsed = Javadoc.parse(generated.javadoc()).removeFirstParam();
                pw.print(SOURCE_SPACING);
                pw.println("/**");
                for (String docLine : parsed.toLines()) {
                    pw.print(SOURCE_SPACING);
                    pw.print(" *");
                    pw.println(docLine);
                }
                pw.print(SOURCE_SPACING);
                pw.println(" */");
            }
            for (String annotation : customMethod.generatedMethod().annotations()) {
                pw.print(SOURCE_SPACING);
                pw.print('@');
                pw.println(annotation);
            }
            if (!customMethod.generatedMethod().annotations().contains(Types.OVERRIDE)) {
                pw.print(SOURCE_SPACING);
                pw.println("@Override");
            }
            pw.print(SOURCE_SPACING);
            pw.print("public ");
            pw.print(generated.returnType().fqName());
            pw.print(" ");
            pw.print(generated.name());
            pw.print("(");
            pw.print(generated.arguments().stream().map(it -> it.typeName().fqName() + " " + it.name()).collect(Collectors.joining(", ")));
            pw.println(") {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(customMethod.generatedMethod().callCode());
            pw.println(";");
            pw.print(SOURCE_SPACING);
            pw.println("}");
            pw.println();
        }
        for (CustomMethods.CustomMethod customMethod : customMethods.builderMethods()) {
            generated = customMethod.generatedMethod().method();
            if (!generated.javadoc().isEmpty()) {
                Javadoc parsedDoc = Javadoc.parse(generated.javadoc()).removeFirstParam().updateReturns("updated builder instance");
                List<String> docLines = parsedDoc.toLines();
                pw.print(SOURCE_SPACING);
                pw.println("/**");
                for (String docLine : docLines) {
                    pw.print(SOURCE_SPACING);
                    pw.print(" *");
                    pw.println(docLine);
                }
                pw.print(SOURCE_SPACING);
                pw.println(" */");
            }
            for (String annotation : customMethod.generatedMethod().annotations()) {
                pw.print(SOURCE_SPACING);
                pw.print('@');
                pw.println(annotation);
            }
            pw.print(SOURCE_SPACING);
            pw.print("public BUILDER ");
            pw.print(generated.name());
            pw.print("(");
            pw.print(generated.arguments().stream().map(it -> it.typeName().fqName() + " " + it.name()).collect(Collectors.joining(", ")));
            pw.println(") {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(customMethod.generatedMethod().callCode());
            pw.println(";");
            pw.print(SOURCE_SPACING);
            pw.println("}");
            pw.println();
        }
        GenerateAbstractBuilder.builderMethods(pw, typeContext);
        GenerateAbstractBuilder.toString(pw, typeContext, prototype.className() + "Builder", superType.isPresent(), typeContext.customMethods().prototypeMethods(), true);
        GenerateAbstractBuilder.generatePrototypeImpl(pw, typeContext, (String)typeArgumentNames);
        pw.print(SOURCE_SPACING);
        pw.println("}");
    }

    static void buildRuntimeObjectMethod(PrintWriter pw, TypeContext typeContext, boolean isBuilder) {
        TypeContext.TypeInformation typeInformation = typeContext.typeInfo();
        boolean hasRuntimeObject = typeInformation.runtimeObject().isPresent();
        TypeName builtObject = typeInformation.runtimeObject().orElse(typeInformation.prototype());
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("@Override");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("public ");
        pw.print(builtObject.fqName());
        pw.println(" build() {");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("return ");
        if (hasRuntimeObject) {
            pw.print(builtObject.genericTypeName().fqName());
            if (isBuilder) {
                pw.println(".create(this.buildPrototype());");
            } else {
                pw.println(".create(this);");
            }
        } else if (isBuilder) {
            pw.println("return build();");
        } else {
            pw.println("return this;");
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
        pw.println();
        if (!isBuilder) {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("@Override");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("public ");
            pw.print(builtObject.fqName());
            pw.println(" get() {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("return build();");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("}");
            pw.println();
        }
    }

    static boolean hasConfig(List<PrototypeProperty> properties) {
        return properties.stream().filter(it -> "config".equals(it.name())).anyMatch(it -> Types.CONFIG_TYPE.equals((Object)it.typeHandler().actualType()));
    }

    private static void builderMethods(PrintWriter pw, TypeContext typeContext) {
        List<PrototypeProperty> properties = typeContext.propertyData().properties();
        TypeContext.ConfiguredData configured = typeContext.configuredData();
        if (configured.configured() || GenerateAbstractBuilder.hasConfig(properties)) {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("/**");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            if (configured.configured()) {
                pw.println(" * Update builder from configuration (node of this type).");
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.println(" * If a value is present in configuration, it would override currently configured values.");
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
            } else {
                pw.println(" * Config to use.");
            }
            pw.println(" *");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println(" * @param config configuration instance used to obtain values to update this builder");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println(" * @return updated builder instance");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println(" */");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("@Override");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("public BUILDER");
            pw.println(" config(Config config) {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("Objects.requireNonNull(config);");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("this.config = config;");
            if (typeContext.typeInfo().superPrototype().isPresent()) {
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.println("super.config(config);");
            }
            if (configured.configured()) {
                for (PrototypeProperty child : properties) {
                    Optional<String> fromConfig;
                    if (child.configuredOption().notConfigured() || !(fromConfig = child.typeHandler().generateFromConfig(child.configuredOption(), child.factoryMethods())).isPresent()) continue;
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.println(fromConfig.get());
                }
            }
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("return self();");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("}");
        }
        TypeName returnType = TypeName.createFromGenericDeclaration((String)"BUILDER");
        for (PrototypeProperty child : properties) {
            for (GeneratedMethod setter : child.setters(returnType, child.configuredOption().description())) {
                Javadoc javadoc = setter.javadoc();
                if (javadoc != null) {
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.println("/**");
                    for (String line : javadoc.toLines()) {
                        pw.print(SOURCE_SPACING);
                        pw.print(SOURCE_SPACING);
                        pw.print(" * ");
                        pw.println(line);
                    }
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.println(" */");
                }
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(String.join((CharSequence)" ", setter.modifiers()));
                if (!setter.modifiers().isEmpty()) {
                    pw.print(" ");
                }
                if (setter.genericDeclaration() != null) {
                    pw.print(setter.genericDeclaration());
                    pw.print(" ");
                }
                pw.print(setter.returnType().fqName());
                pw.print(" ");
                pw.print(setter.name());
                pw.print("(");
                pw.print(setter.arguments().stream().map(it -> it.typeName().fqName() + " " + it.name()).collect(Collectors.joining(", ")));
                pw.println(") {");
                for (String methodLine : setter.methodLines()) {
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.println(methodLine);
                }
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.println("}");
            }
        }
        for (PrototypeProperty child : properties) {
            String getterName = child.getterName();
            if (child.configuredOption().description() != null) {
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.println("/**");
                for (String line : child.configuredOption().description().lines()) {
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(" * ");
                    pw.println(line);
                }
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(" * @return the ");
                pw.println(GenerateAbstractBuilder.toHumanReadable(child.name()));
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.println(" */");
            }
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("@Override");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("public ");
            pw.print(child.typeName().fqName());
            pw.print(" ");
            pw.print(getterName);
            pw.println("() {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("return ");
            pw.print(child.builderGetter());
            pw.println(";");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("}");
        }
        if (configured.configured()) {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("/**");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println(" * If this instance was configured, this would be the config instance used.");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println(" *");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println(" * @return config node used to configure this builder, or empty if not configured");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println(" */");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("public Optional<Config> config() {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("return Optional.ofNullable(config);");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("}");
        }
    }

    private static void fromInstanceMethod(PrintWriter pw, TypeContext typeContext, String prototypeWithTypes) {
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("/**");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * Update this builder from an existing prototype instance.");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" *");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * @param prototype existing prototype to update this builder from");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * @return updated builder instance");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" */");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("public BUILDER from(");
        pw.print(prototypeWithTypes);
        pw.println(" prototype) {");
        typeContext.typeInfo().superPrototype().ifPresent(it -> {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("super.from(prototype);");
        });
        for (PrototypeProperty property : typeContext.propertyData().properties()) {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            TypeName declaredType = property.typeHandler().declaredType();
            if (declaredType.isSet() || declaredType.isList() || declaredType.isMap()) {
                pw.print("add");
                pw.print(GeneratorTools.capitalize((String)property.name()));
                pw.print("(prototype.");
                pw.print(property.typeHandler().getterName());
                pw.println("());");
                continue;
            }
            pw.print(property.typeHandler().setterName());
            pw.print("(prototype.");
            pw.print(property.typeHandler().getterName());
            pw.println("());");
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("return self();");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
    }

    private static void fromBuilderMethod(PrintWriter pw, TypeContext typeContext, String typeArgumentNames) {
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("/**");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * Update this builder from an existing prototype builder instance.");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" *");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * @param builder existing builder prototype to update this builder from");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * @return updated builder instance");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" */");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("public BUILDER from(");
        pw.print(typeContext.typeInfo().prototype().className());
        pw.print(".BuilderBase<");
        pw.print(typeArgumentNames);
        pw.println("?, ?> builder) {");
        typeContext.typeInfo().superPrototype().ifPresent(it -> {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("super.from(builder);");
        });
        for (PrototypeProperty property : typeContext.propertyData().properties()) {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            TypeName declaredType = property.typeHandler().declaredType();
            if (declaredType.primitive() || declaredType.isOptional()) {
                pw.print(property.typeHandler().setterName());
                pw.print("(builder.");
                pw.print(property.typeHandler().getterName());
                pw.println("());");
                continue;
            }
            if (declaredType.isSet() || declaredType.isList() || declaredType.isMap()) {
                pw.print("add");
                pw.print(GeneratorTools.capitalize((String)property.name()));
                pw.print("(builder.");
                pw.print(property.typeHandler().getterName());
                pw.println("());");
                continue;
            }
            pw.print("if (builder.");
            pw.print(property.typeHandler().getterName());
            pw.println("() != null) {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(property.typeHandler().setterName());
            pw.print("(builder.");
            pw.print(property.typeHandler().getterName());
            pw.println("());");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("}");
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("return self();");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
    }

    private static void fields(PrintWriter pw, TypeContext typeContext, boolean isBuilder) {
        boolean hasFields;
        Object spacing = "        ";
        if (!isBuilder) {
            spacing = (String)spacing + SOURCE_SPACING;
        }
        boolean bl = hasFields = !typeContext.propertyData().properties().isEmpty();
        if (isBuilder && (typeContext.configuredData().configured() || GenerateAbstractBuilder.hasConfig(typeContext.propertyData().properties()))) {
            hasFields = true;
            pw.print((String)spacing);
            pw.println("private Config config;");
        }
        for (PrototypeProperty child : typeContext.propertyData().properties()) {
            if (!isBuilder || !child.typeHandler().actualType().equals((Object)Types.CONFIG_TYPE)) {
                pw.print((String)spacing);
                pw.print(child.fieldDeclaration(isBuilder));
                pw.println(";");
            }
            if (!isBuilder || !child.configuredOption().provider()) continue;
            pw.print((String)spacing);
            pw.print("private boolean ");
            pw.print(child.name());
            pw.print("DiscoverServices = ");
            pw.print(child.configuredOption().providerOption().defaultDiscoverServices());
            pw.println(";");
        }
        if (hasFields) {
            pw.println();
        }
    }

    private static void preBuildPrototypeMethod(PrintWriter pw, TypeContext typeContext) {
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("/**");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * Handles providers and interceptors.");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" */");
        if (typeContext.propertyData().hasProvider()) {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("@SuppressWarnings(\"unchecked\")");
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("protected void preBuildPrototype() {");
        typeContext.typeInfo().superPrototype().ifPresent(it -> {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("super.preBuildPrototype();");
        });
        if (typeContext.propertyData().hasProvider()) {
            boolean configured = typeContext.configuredData().configured();
            if (configured) {
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.println("this.config = config == null ? Config.empty() : config;");
            }
            for (PrototypeProperty property : typeContext.propertyData().properties()) {
                PrototypeProperty.ConfiguredOption configuredOption = property.configuredOption();
                if (!configuredOption.provider()) continue;
                PrototypeProperty.ProviderOption providerOption = configuredOption.providerOption();
                boolean defaultDiscoverServices = providerOption.defaultDiscoverServices();
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.println("{");
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print("var serviceLoader = io.helidon.common.HelidonServiceLoader.create(java.util.ServiceLoader.load(");
                pw.print(providerOption.serviceProviderInterface().fqName());
                pw.println(".class));");
                if (configured) {
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print("java.util.List<");
                    pw.print(property.typeHandler().actualType().fqName());
                    pw.print("> services = discoverServices(config.get(\"");
                    pw.print(configuredOption.configKey());
                    pw.print("\"), serviceLoader, ");
                    pw.print(providerOption.serviceProviderInterface().fqName());
                    pw.print(".class, ");
                    pw.print(property.typeHandler().actualType().fqName());
                    pw.print(".class, ");
                    pw.print(property.name());
                    pw.print("DiscoverServices");
                    pw.println(");");
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print("this.add");
                    pw.print(GeneratorTools.capitalize((String)property.name()));
                    pw.println("(services);");
                } else if (defaultDiscoverServices) {
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print(SOURCE_SPACING);
                    pw.print("this.");
                    pw.print(property.name());
                    pw.println("(serviceLoader.asList());");
                }
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.println("}");
            }
        }
        if (typeContext.typeInfo().builderInterceptor().isPresent()) {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("new ");
            pw.print(typeContext.typeInfo().builderInterceptor().get().fqName());
            pw.println("().intercept(this);");
            pw.println();
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
    }

    private static void validatePrototypeMethod(PrintWriter pw, TypeContext typeContext) {
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("/**");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * Validates required properties.");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" */");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("protected void validatePrototype() {");
        typeContext.typeInfo().superPrototype().ifPresent(it -> {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("super.validatePrototype();");
        });
        if (typeContext.propertyData().hasRequired() || typeContext.propertyData().hasNonNulls()) {
            GenerateAbstractBuilder.requiredValidation(pw, typeContext);
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
    }

    private static void requiredValidation(PrintWriter pw, TypeContext typeContext) {
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("Errors.Collector collector = Errors.collector();");
        for (PrototypeProperty property : typeContext.propertyData().properties()) {
            if (!property.configuredOption().validateNotNull() || property.configuredOption().hasDefault()) continue;
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("if (");
            pw.print(property.typeHandler().name());
            pw.println(" == null) {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("collector.fatal(getClass(), ");
            pw.print("\"Property \\\"");
            String configKey = property.configuredOption().configKey();
            pw.print(configKey == null ? property.typeHandler().name() : configKey);
            if (property.configuredOption().required()) {
                pw.println("\\\" is required, but not set\");");
            } else {
                pw.println("\\\" must not be null, but not set\");");
            }
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("}");
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("collector.collect().checkValid();");
    }

    private static void generatePrototypeImpl(PrintWriter pw, TypeContext typeContext, String typeArgumentNames) {
        Optional<TypeName> superPrototype = typeContext.typeInfo().superPrototype();
        TypeName prototype = typeContext.typeInfo().prototype();
        TypeName prototypeImpl = typeContext.typeInfo().prototypeImpl();
        String ifaceName = prototype.className();
        String implName = prototypeImpl.className();
        String typeArgs = typeContext.blueprintData().typeArguments();
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("/**");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * Generated implementation of the prototype, can be extended by descendant prototype implementations.");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" */");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("protected static class ");
        pw.print(implName);
        pw.print(typeArgs);
        superPrototype.ifPresent(it -> {
            pw.print(" extends ");
            pw.print(it.className());
            pw.print("Impl");
        });
        pw.print(" implements ");
        pw.print(ifaceName);
        pw.print(typeArgs);
        if (typeContext.blueprintData().isFactory()) {
            pw.print(", java.util.function.Supplier<");
            pw.print(typeContext.typeInfo().runtimeObject().orElse(typeContext.typeInfo().prototype()).fqName());
            pw.print(">");
        }
        pw.println("{");
        GenerateAbstractBuilder.fields(pw, typeContext, false);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("/**");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * Create an instance providing a builder.");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" * @param builder extending builder base of this prototype");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println(" */");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("protected ");
        pw.print(implName);
        pw.print("(");
        pw.print(ifaceName);
        pw.print(".BuilderBase<");
        pw.print(typeArgumentNames);
        pw.print("?, ?>");
        pw.println(" builder) {");
        superPrototype.ifPresent(it -> {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("super(builder);");
        });
        GenerateAbstractBuilder.implAssignToFields(pw, typeContext);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
        if (typeContext.blueprintData().isFactory()) {
            GenerateAbstractBuilder.buildRuntimeObjectMethod(pw, typeContext, false);
        }
        for (CustomMethods.CustomMethod customMethod : typeContext.customMethods().prototypeMethods()) {
            CustomMethods.Method generated = customMethod.generatedMethod().method();
            for (String annotation : customMethod.generatedMethod().annotations()) {
                pw.print(SOURCE_SPACING);
                pw.print('@');
                pw.println(annotation);
            }
            if (!customMethod.generatedMethod().annotations().contains(Types.OVERRIDE)) {
                pw.print(SOURCE_SPACING);
                pw.println("@Override");
            }
            pw.print(SOURCE_SPACING);
            pw.print("public ");
            pw.print(generated.returnType().fqName());
            pw.print(" ");
            pw.print(generated.name());
            pw.print("(");
            pw.print(generated.arguments().stream().map(it -> it.typeName().fqName() + " " + it.name()).collect(Collectors.joining(", ")));
            pw.println(") {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(customMethod.generatedMethod().callCode());
            pw.println(";");
            pw.print(SOURCE_SPACING);
            pw.println("}");
            pw.println();
        }
        GenerateAbstractBuilder.implMethods(pw, typeContext);
        GenerateAbstractBuilder.toString(pw, typeContext, ifaceName, superPrototype.isPresent(), typeContext.customMethods().prototypeMethods(), false);
        GenerateAbstractBuilder.hashCodeAndEquals(pw, typeContext, ifaceName, superPrototype.isPresent());
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
    }

    private static void hashCodeAndEquals(PrintWriter pw, TypeContext typeContext, String ifaceName, boolean hasSuper) {
        List<PrototypeProperty> equalityFields = typeContext.propertyData().properties().stream().filter(PrototypeProperty::equality).toList();
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("@Override");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("public boolean equals(Object o) {");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("if (o == this) {");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("return true;");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("if (!(o instanceof ");
        pw.print(ifaceName);
        pw.println(" other)) {");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("return false;");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("return ");
        if (hasSuper) {
            pw.print("super.equals(other)");
            if (!equalityFields.isEmpty()) {
                pw.print(" && ");
            }
        }
        if (!hasSuper && equalityFields.isEmpty()) {
            pw.print("true");
        } else {
            pw.print(equalityFields.stream().map(field -> {
                if (field.typeName().array()) {
                    return "java.util.Arrays.equals(" + field.name() + ", other." + field.getterName() + "())";
                }
                if (field.typeName().primitive()) {
                    return field.name() + " == other." + field.getterName() + "()";
                }
                return "Objects.equals(" + field.name() + ", other." + field.getterName() + "())";
            }).collect(Collectors.joining(" && ")));
        }
        pw.println(";");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("@Override");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("public int hashCode() {");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        if (equalityFields.isEmpty()) {
            if (hasSuper) {
                pw.println("return super.hashCode();");
            } else {
                pw.println("return 1;");
            }
        } else {
            if (hasSuper) {
                pw.print("return 31 * super.hashCode() + Objects.hash(");
            } else {
                pw.print("return Objects.hash(");
            }
            pw.print(equalityFields.stream().map(PrototypeProperty::name).collect(Collectors.joining(", ")));
            pw.println(");");
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
    }

    private static void toString(PrintWriter pw, TypeContext typeContext, String typeName, boolean hasSuper, List<CustomMethods.CustomMethod> prototypeMethods, boolean isBuilder) {
        if (prototypeMethods.stream().map(CustomMethods.CustomMethod::generatedMethod).map(CustomMethods.GeneratedMethod::method).filter(it -> "toString".equals(it.name())).filter(it -> it.returnType().equals((Object)Types.STRING_TYPE)).anyMatch(it -> it.arguments().isEmpty())) {
            return;
        }
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("@Override");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("public String toString() {");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("return \"");
        pw.print(typeName);
        List<PrototypeProperty> toStringFields = typeContext.propertyData().properties().stream().filter(PrototypeProperty::toStringValue).toList();
        String prefix = SOURCE_SPACING.repeat(6);
        if (toStringFields.isEmpty()) {
            pw.println("{};\"");
        } else {
            pw.println("{\"");
            pw.println(toStringFields.stream().map(it -> {
                boolean secret = it.confidential() || it.typeHandler().actualType().equals((Object)Types.CHAR_ARRAY_TYPE);
                String name = it.name();
                if (secret) {
                    if (it.typeName().primitive() && !it.typeName().array()) {
                        return prefix + " + \"" + name + "=****\"";
                    }
                    if (!isBuilder && it.typeName().genericTypeName().equals((Object)TypeNames.OPTIONAL)) {
                        return prefix + " + \"" + name + "=\" + (" + name + ".isPresent() ? \"****\" : \"null\")";
                    }
                    return prefix + " + \"" + name + "=\" + (" + name + " == null ? \"null\" : \"****\")";
                }
                return prefix + " + \"" + name + "=\" + " + name;
            }).collect(Collectors.joining(" + \",\" \n")));
            pw.print(prefix);
            if (hasSuper) {
                pw.print("+ \"};\"");
            } else {
                pw.print("+ \"}\"");
            }
        }
        if (hasSuper) {
            pw.println();
            pw.print(prefix);
            pw.print(" + super.toString()");
        }
        pw.println(";");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
    }

    private static void implMethods(PrintWriter pw, TypeContext typeContext) {
        for (PrototypeProperty child : typeContext.propertyData().properties()) {
            String fieldName = child.name();
            String getterName = child.getterName();
            pw.println();
            pw.print(SOURCE_SPACING);
            pw.println("@Override");
            pw.print(SOURCE_SPACING);
            pw.print("public ");
            pw.print(child.typeHandler().declaredType().fqName());
            pw.print(" ");
            pw.print(getterName);
            pw.println("() {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("return ");
            pw.print(fieldName);
            pw.println(";");
            pw.print(SOURCE_SPACING);
            pw.println("}");
        }
    }

    private static void implAssignToFields(PrintWriter pw, TypeContext typeContext) {
        for (PrototypeProperty child : typeContext.propertyData().properties()) {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("this.");
            pw.print(child.name());
            pw.print(" = ");
            if (child.typeHandler().declaredType().genericTypeName().equals((Object)TypeNames.LIST)) {
                pw.print("java.util.List.copyOf(builder.");
                pw.print(child.getterName());
                pw.println("());");
                continue;
            }
            if (child.typeHandler().declaredType().genericTypeName().equals((Object)TypeNames.SET)) {
                pw.print("java.util.Collections.unmodifiableSet(new java.util.LinkedHashSet<>(builder.");
                pw.print(child.getterName());
                pw.println("()));");
                continue;
            }
            if (child.typeHandler().declaredType().genericTypeName().equals((Object)TypeNames.MAP)) {
                pw.print("java.util.Collections.unmodifiableMap(new java.util.LinkedHashMap<>(builder.");
                pw.print(child.getterName());
                pw.println("()));");
                continue;
            }
            pw.print(" builder.");
            pw.print(child.getterName());
            pw.println("();");
        }
    }

    private static String toHumanReadable(String name) {
        char[] nameChars;
        StringBuilder result = new StringBuilder();
        for (char nameChar : nameChars = name.toCharArray()) {
            if (Character.isUpperCase(nameChar)) {
                if (result.length() != 0) {
                    result.append(' ');
                }
                result.append(Character.toLowerCase(nameChar));
                continue;
            }
            result.append(nameChar);
        }
        return result.toString();
    }
}

