/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.spi.BuilderCreatorProvider;
import io.helidon.builder.processor.spi.TypeAndBody;
import io.helidon.builder.processor.spi.TypeInfoCreatorProvider;
import io.helidon.builder.processor.tools.BuilderTypeTools;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.Weights;
import io.helidon.common.types.AnnotationAndValue;
import io.helidon.common.types.DefaultTypeName;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class BuilderProcessor
extends AbstractProcessor {
    private static final System.Logger LOGGER = System.getLogger(BuilderProcessor.class.getName());
    private static final Map<TypeName, Set<BuilderCreatorProvider>> PRODUCERS_BY_ANNOTATION = new LinkedHashMap<TypeName, Set<BuilderCreatorProvider>>();
    private static final Set<Class<? extends Annotation>> ALL_ANNO_TYPES_HANDLED = new LinkedHashSet<Class<? extends Annotation>>();
    private static final List<BuilderCreatorProvider> PRODUCERS = BuilderProcessor.initialize();
    private final LinkedHashSet<Element> elementsProcessed = new LinkedHashSet();
    private TypeInfoCreatorProvider tools;
    private Elements elementUtils;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ALL_ANNO_TYPES_HANDLED.stream().map(Class::getName).collect(Collectors.toSet());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.tools = HelidonServiceLoader.create(ServiceLoader.load(TypeInfoCreatorProvider.class, TypeInfoCreatorProvider.class.getClassLoader())).asList().stream().findFirst().orElse(null);
        if (this.tools == null) {
            String msg = "no available " + TypeInfoCreatorProvider.class.getSimpleName() + " instances found";
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            throw new IllegalStateException(msg);
        }
        LOGGER.log(System.Logger.Level.DEBUG, TypeInfoCreatorProvider.class.getSimpleName() + ": " + String.valueOf(this.tools));
        if (PRODUCERS.isEmpty()) {
            String msg = "no available " + BuilderCreatorProvider.class.getSimpleName() + " instances found";
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
            throw new IllegalStateException(msg);
        }
        LOGGER.log(System.Logger.Level.DEBUG, BuilderCreatorProvider.class.getSimpleName() + "s: " + String.valueOf(PRODUCERS));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || this.tools == null || PRODUCERS.isEmpty()) {
            this.elementsProcessed.clear();
            return false;
        }
        try {
            for (Class<? extends Annotation> annoType : ALL_ANNO_TYPES_HANDLED) {
                Set<? extends Element> typesToProcess = roundEnv.getElementsAnnotatedWith(annoType);
                for (Element element : typesToProcess) {
                    if (!this.elementsProcessed.add(element)) continue;
                    try {
                        this.process(annoType, element);
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException("Failed while processing " + String.valueOf(element) + " with " + String.valueOf(annoType), e);
                    }
                }
            }
            return false;
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.ERROR, e.getMessage(), e);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    protected void process(Class<? extends Annotation> annoType, Element element) throws IOException {
        AnnotationMirror am = (AnnotationMirror)BuilderTypeTools.findAnnotationMirror((String)annoType.getName(), element.getAnnotationMirrors()).orElseThrow(() -> new IllegalArgumentException("Cannot find annotation mirror for " + String.valueOf(annoType) + " on " + String.valueOf(element)));
        AnnotationAndValue builderAnno = (AnnotationAndValue)BuilderTypeTools.createAnnotationAndValueFromMirror((AnnotationMirror)am, (Elements)this.elementUtils).get();
        TypeName typeName = BuilderTypeTools.createTypeNameFromElement((Element)element).orElse(null);
        boolean defineDefaultMethods = Boolean.parseBoolean(builderAnno.value("defineDefaultMethods").orElse(null));
        Optional typeInfo = this.tools.createTypeInfo(builderAnno.typeName(), typeName, (TypeElement)element, this.processingEnv, defineDefaultMethods);
        if (typeInfo.isEmpty()) {
            String msg = "Nothing to process, skipping: " + String.valueOf(element);
            LOGGER.log(System.Logger.Level.WARNING, msg);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
            return;
        }
        Set<BuilderCreatorProvider> creators = this.getProducersForType((TypeName)DefaultTypeName.create(annoType));
        Optional<List> result = creators.stream().map(it -> it.create((TypeInfo)typeInfo.get(), builderAnno)).filter(it -> !it.isEmpty()).findFirst();
        if (result.isEmpty()) {
            String msg = "Unable to process " + String.valueOf(typeName);
            LOGGER.log(System.Logger.Level.WARNING, msg);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
        } else {
            this.codegen(result.get());
        }
    }

    protected void codegen(List<TypeAndBody> codegens) throws IOException {
        for (TypeAndBody typeAndBody : codegens) {
            JavaFileObject javaSrc = this.processingEnv.getFiler().createSourceFile(typeAndBody.typeName().name(), new Element[0]);
            Writer os = javaSrc.openWriter();
            try {
                os.write(typeAndBody.body());
            }
            finally {
                if (os == null) continue;
                os.close();
            }
        }
    }

    private static List<BuilderCreatorProvider> initialize() {
        try {
            List producers = HelidonServiceLoader.create(ServiceLoader.load(BuilderCreatorProvider.class, BuilderCreatorProvider.class.getClassLoader())).asList();
            producers.forEach(producer -> producer.supportedAnnotationTypes().forEach(annoType -> PRODUCERS_BY_ANNOTATION.computeIfAbsent((TypeName)DefaultTypeName.create((Class)annoType), it -> new LinkedHashSet()).add(producer)));
            producers.sort(Weights.weightComparator());
            producers.forEach(p -> ALL_ANNO_TYPES_HANDLED.addAll(p.supportedAnnotationTypes()));
            return producers;
        }
        catch (Throwable t) {
            RuntimeException e = new RuntimeException("Failed to initialize", t);
            LOGGER.log(System.Logger.Level.ERROR, e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private Set<BuilderCreatorProvider> getProducersForType(TypeName annoTypeName) {
        Set<BuilderCreatorProvider> set = PRODUCERS_BY_ANNOTATION.get(annoTypeName);
        return set == null ? Set.of() : Set.copyOf(set);
    }
}

