/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.DeprecationData;
import io.helidon.builder.codegen.TypeHandler;
import io.helidon.builder.codegen.Types;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

record AnnotationDataOption(Javadoc javadoc, boolean configured, String configKey, Boolean configMerge, AccessModifier accessModifier, boolean required, boolean validateNotNull, boolean registryService, boolean provider, TypeName providerType, boolean providerDiscoverServices, boolean singular, String singularName, boolean singularAddPrefix, boolean sameGeneric, boolean equalityRedundant, boolean toStringRedundant, boolean confidential, boolean traverseConfig, List<AllowedValue> allowedValues, Consumer<ContentBuilder<?>> defaultValue, DeprecationData deprecationData, List<Annotation> annotations, TypeName decorator) {
    static AnnotationDataOption create(TypeHandler handler, TypedElementInfo element) {
        boolean toStringRedundant;
        boolean equalityRedundant;
        boolean singularAddPrefix;
        String singularName;
        boolean singular;
        Annotation annotation;
        Javadoc javadoc = AnnotationDataOption.javadoc(element);
        boolean configured = false;
        String configKey = null;
        boolean configMerge = false;
        boolean providerBased = false;
        TypeName providerType = null;
        boolean discoverServices = false;
        List<AllowedValue> allowedValues = null;
        if (element.hasAnnotation(Types.OPTION_CONFIGURED)) {
            Annotation annotation2 = element.annotation(Types.OPTION_CONFIGURED);
            configured = true;
            configKey = annotation2.stringValue().filter(Predicate.not(String::isBlank)).orElseGet(() -> AnnotationDataOption.toConfigKey(handler.name()));
            configMerge = annotation2.booleanValue("merge").orElse(false);
        }
        AccessModifier accessModifier = AnnotationDataOption.accessModifier(element);
        boolean registryService = element.hasAnnotation(Types.OPTION_REGISTRY_SERVICE);
        if (element.hasAnnotation(Types.OPTION_PROVIDER)) {
            annotation = element.annotation(Types.OPTION_PROVIDER);
            providerBased = true;
            providerType = annotation.stringValue().map(TypeName::create).orElseThrow();
            discoverServices = annotation.booleanValue("discoverServices").orElse(true);
        }
        if (element.hasAnnotation(Types.OPTION_ALLOWED_VALUES)) {
            annotation = element.annotation(Types.OPTION_ALLOWED_VALUES);
            allowedValues = annotation.annotationValues().orElseGet(List::of).stream().map(it -> {
                String value = (String)it.stringValue().orElseThrow();
                String description = (String)it.stringValue("description").orElseThrow();
                return new AllowedValue(value, description);
            }).toList();
        }
        if (element.hasAnnotation(Types.OPTION_SINGULAR)) {
            Annotation singularAnnot = element.annotation(Types.OPTION_SINGULAR);
            singular = true;
            singularName = singularAnnot.value().filter(Predicate.not(String::isBlank)).orElseGet(() -> AnnotationDataOption.singularName(handler.name()));
            singularAddPrefix = singularAnnot.booleanValue("withPrefix").orElse(true);
        } else {
            singular = false;
            singularName = null;
            singularAddPrefix = true;
        }
        if (element.hasAnnotation(Types.OPTION_REDUNDANT)) {
            annotation = element.annotation(Types.OPTION_REDUNDANT);
            equalityRedundant = annotation.booleanValue("equality").orElse(true);
            toStringRedundant = annotation.booleanValue("stringValue").orElse(true);
        } else {
            equalityRedundant = false;
            toStringRedundant = false;
        }
        Consumer<ContentBuilder<?>> defaultValue = AnnotationDataOption.defaultValue(element, handler);
        TypeName genericType = handler.declaredType().genericTypeName();
        boolean validateNotNull = AnnotationDataOption.shouldValidateNotNull(defaultValue == null, genericType);
        boolean required = element.hasAnnotation(Types.OPTION_REQUIRED);
        boolean bl = validateNotNull = validateNotNull || required;
        if (javadoc == null) {
            javadoc = element.description().map(Javadoc::parse).orElseGet(() -> Javadoc.builder().addLine("Option " + handler.name()).returnDescription(handler.name()).build());
        }
        DeprecationData deprecationData = DeprecationData.create(element, javadoc);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        javadoc = AnnotationDataOption.processDeprecation(deprecationData, annotations, javadoc);
        TypeName decorator = AnnotationDataOption.optionDecorator(element);
        boolean traverseConfig = element.findAnnotation(Types.OPTION_TRAVERSE_CONFIG).flatMap(rec$ -> ((Annotation)rec$).booleanValue()).orElseGet(() -> AnnotationDataOption.traverseByDefault(handler));
        return new AnnotationDataOption(javadoc, configured, configKey, configMerge, accessModifier, required, validateNotNull, registryService, providerBased, providerType, discoverServices, singular, singularName, singularAddPrefix, element.hasAnnotation(Types.OPTION_SAME_GENERIC), equalityRedundant, toStringRedundant, element.hasAnnotation(Types.OPTION_CONFIDENTIAL), traverseConfig, allowedValues, defaultValue, deprecationData, annotations, decorator);
    }

    private static TypeName optionDecorator(TypedElementInfo element) {
        if (element.hasAnnotation(Types.OPTION_DECORATOR)) {
            return (TypeName)element.annotation(Types.OPTION_DECORATOR).typeValue().orElseThrow(() -> new IllegalStateException("There is no value defined on " + Types.OPTION_DECORATOR.fqName() + " on element " + String.valueOf(element) + ", even though it is a required property."));
        }
        return null;
    }

    boolean hasDefault() {
        return this.defaultValue != null;
    }

    boolean hasAllowedValues() {
        return this.allowedValues != null && !this.allowedValues.isEmpty();
    }

    private static AccessModifier accessModifier(TypedElementInfo element) {
        return element.findAnnotation(Types.OPTION_ACCESS).flatMap(rec$ -> ((Annotation)rec$).stringValue()).map(it -> it.isBlank() ? AccessModifier.PACKAGE_PRIVATE : AccessModifier.valueOf((String)it)).orElse(AccessModifier.PUBLIC);
    }

    private static Javadoc javadoc(TypedElementInfo element) {
        if (element.hasAnnotation(Types.BUILDER_DESCRIPTION)) {
            return Javadoc.parse((String)((String)element.annotation(Types.BUILDER_DESCRIPTION).stringValue().orElseThrow()));
        }
        return null;
    }

    private static Consumer<ContentBuilder<?>> defaultValue(TypedElementInfo element, TypeHandler handler) {
        boolean noDefault;
        Annotation annotation;
        List defaultValues = null;
        List defaultInts = null;
        List defaultLongs = null;
        List defaultDoubles = null;
        List defaultBooleans = null;
        DefaultMethod defaultMethod = null;
        String defaultCode = null;
        if (element.hasAnnotation(Types.OPTION_DEFAULT)) {
            annotation = element.annotation(Types.OPTION_DEFAULT);
            defaultValues = annotation.stringValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_INT)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_INT);
            defaultInts = annotation.intValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_LONG)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_LONG);
            defaultLongs = annotation.longValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_DOUBLE)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_DOUBLE);
            defaultDoubles = annotation.doubleValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_BOOLEAN)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_BOOLEAN);
            defaultBooleans = annotation.booleanValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_METHOD)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_METHOD);
            TypeName type = annotation.typeValue("type").orElse(Types.OPTION_DEFAULT_METHOD);
            if (Types.OPTION_DEFAULT_METHOD.equals((Object)type)) {
                type = handler.declaredType();
            }
            String name = (String)annotation.stringValue().orElseThrow();
            defaultMethod = new DefaultMethod(type, name);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_CODE)) {
            defaultCode = (String)element.annotation(Types.OPTION_DEFAULT_CODE).stringValue().orElseThrow();
        }
        boolean bl = noDefault = defaultValues == null && defaultInts == null && defaultLongs == null && defaultDoubles == null && defaultBooleans == null && defaultCode == null && defaultMethod == null;
        if (noDefault) {
            return null;
        }
        return handler.toDefaultValue(defaultValues, defaultInts, defaultLongs, defaultDoubles, defaultBooleans, defaultCode, defaultMethod);
    }

    private static boolean shouldValidateNotNull(boolean noDefault, TypeName genericType) {
        return noDefault && !genericType.equals((Object)TypeNames.OPTIONAL) && (!genericType.primitive() || genericType.array()) && !genericType.equals((Object)TypeNames.MAP) && !genericType.equals((Object)TypeNames.SET) && !genericType.equals((Object)TypeNames.LIST);
    }

    private static Javadoc processDeprecation(DeprecationData deprecationData, List<Annotation> annotations, Javadoc javadoc) {
        if (javadoc == null) {
            return null;
        }
        if (!deprecationData.deprecated()) {
            return javadoc;
        }
        Annotation.Builder deprecated = (Annotation.Builder)Annotation.builder().typeName(Types.DEPRECATED);
        if (deprecationData.since() != null) {
            deprecated.putValue("since", (Object)deprecationData.since());
        }
        if (deprecationData.forRemoval()) {
            deprecated.putValue("forRemoval", (Object)true);
        }
        if (Annotations.findFirst((TypeName)Types.DEPRECATED, annotations).isEmpty()) {
            annotations.add(deprecated.build());
        }
        if (deprecationData.alternativeOption() != null || deprecationData.description() != null) {
            Javadoc.Builder javadocBuilder = Javadoc.builder((Javadoc)javadoc);
            if (deprecationData.alternativeOption() == null) {
                javadocBuilder.deprecation(deprecationData.description());
            } else {
                javadocBuilder.deprecation("use {@link #" + deprecationData.alternativeOption() + "()} instead");
            }
            javadoc = javadocBuilder.build();
        }
        return javadoc;
    }

    private static String singularName(String optionName) {
        if (optionName.endsWith("s")) {
            return optionName.substring(0, optionName.length() - 1);
        }
        return optionName;
    }

    private static String toConfigKey(String propertyName) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        for (char aChar : chars = propertyName.toCharArray()) {
            if (Character.isUpperCase(aChar)) {
                if (result.isEmpty()) {
                    result.append(Character.toLowerCase(aChar));
                    continue;
                }
                result.append('-').append(Character.toLowerCase(aChar));
                continue;
            }
            result.append(aChar);
        }
        return result.toString();
    }

    private static boolean traverseByDefault(TypeHandler handler) {
        TypeName typeName = handler.declaredType();
        if (typeName.isMap()) {
            TypeName valueTypeName = (TypeName)typeName.typeArguments().get(1);
            return handler.toPrimitive(valueTypeName).primitive();
        }
        return false;
    }

    record DefaultMethod(TypeName type, String method) {
    }

    record AllowedValue(String value, String description) {
    }
}

