/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.AnnotationDataBlueprint;
import io.helidon.builder.codegen.AnnotationDataConfigured;
import io.helidon.builder.codegen.CustomConstant;
import io.helidon.builder.codegen.CustomMethods;
import io.helidon.builder.codegen.GenerateAbstractBuilder;
import io.helidon.builder.codegen.GenerateBuilder;
import io.helidon.builder.codegen.PrototypeProperty;
import io.helidon.builder.codegen.TypeContext;
import io.helidon.builder.codegen.Types;
import io.helidon.builder.codegen.ValidationTask;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenEvent;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.FilerTextResource;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.Errors;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

class BuilderCodegen
implements CodegenExtension {
    private static final TypeName GENERATOR = TypeName.create(BuilderCodegen.class);
    private final Set<TypeName> runtimeTypes = new HashSet<TypeName>();
    private final Set<TypeName> blueprintTypes = new HashSet<TypeName>();
    private final Set<String> serviceLoaderContracts = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final CodegenContext ctx;

    BuilderCodegen(CodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RoundContext roundContext) {
        this.runtimeTypes.addAll(roundContext.annotatedTypes(Types.RUNTIME_PROTOTYPED_BY).stream().map(rec$ -> ((TypeInfo)rec$).typeName()).toList());
        Collection blueprints = roundContext.annotatedTypes(Types.PROTOTYPE_BLUEPRINT);
        this.blueprintTypes.addAll(blueprints.stream().map(rec$ -> ((TypeInfo)rec$).typeName()).toList());
        List<TypeInfo> blueprintInterfaces = blueprints.stream().filter(it -> it.kind() == ElementKind.INTERFACE).toList();
        for (TypeInfo blueprintInterface : blueprintInterfaces) {
            this.process(roundContext, blueprintInterface);
        }
    }

    public void processingOver(RoundContext roundContext) {
        this.process(roundContext);
        this.updateServiceLoaderResource();
        ArrayList<ValidationTask> validationTasks = new ArrayList<ValidationTask>();
        validationTasks.addAll(this.addRuntimeTypesForValidation(this.runtimeTypes));
        validationTasks.addAll(this.addBlueprintsForValidation(this.blueprintTypes));
        Errors.Collector collector = Errors.collector();
        for (ValidationTask task : validationTasks) {
            task.validate(collector);
        }
        Errors errors = collector.collect();
        if (errors.hasFatal()) {
            for (Errors.ErrorMessage error : errors) {
                CodegenEvent.Builder builder = (CodegenEvent.Builder)((CodegenEvent.Builder)CodegenEvent.builder().message(error.getMessage().replace('\n', ' '))).addObject(error.getSource());
                switch (error.getSeverity()) {
                    case FATAL: {
                        builder.level(System.Logger.Level.ERROR);
                        break;
                    }
                    case WARN: {
                        builder.level(System.Logger.Level.WARNING);
                        break;
                    }
                    case HINT: {
                        builder.level(System.Logger.Level.INFO);
                        break;
                    }
                    default: {
                        builder.level(System.Logger.Level.DEBUG);
                    }
                }
                this.ctx.logger().log(builder.build());
            }
        }
    }

    private static void addCreateDefaultMethod(AnnotationDataBlueprint blueprintDef, TypeContext.PropertyData propertyData, ClassModel.Builder classModel, TypeName prototype, String ifaceName, String typeArgumentString, List<TypeArgument> typeArguments) {
        if (blueprintDef.createEmptyPublic() && blueprintDef.builderPublic() && !propertyData.hasRequired()) {
            classModel.addMethod(builder -> {
                ((Method.Builder)((Method.Builder)builder.isStatic(true).name("create")).description("Create a new instance with default values.")).returnType(prototype, "a new instance").addContentLine("return " + ifaceName + "." + typeArgumentString + "builder().buildPrototype();");
                typeArguments.forEach(arg_0 -> ((Method.Builder)builder).addGenericArgument(arg_0));
            });
        }
    }

    private static void addCreateFromConfigMethod(AnnotationDataBlueprint blueprintDef, AnnotationDataConfigured configuredData, TypeName prototype, List<TypeArgument> typeArguments, String ifaceName, String typeArgumentString, ClassModel.Builder classModel) {
        if (blueprintDef.createFromConfigPublic() && configuredData.configured()) {
            Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("create")).isStatic(true).description("Create a new instance from configuration.")).returnType(prototype, "a new instance configured from configuration").addParameter(paramBuilder -> ((Parameter.Builder)paramBuilder.type(Types.CONFIG).name("config")).description("used to configure the new instance"));
            typeArguments.forEach(arg_0 -> ((Method.Builder)method).addGenericArgument(arg_0));
            if (blueprintDef.builderPublic()) {
                method.addContentLine("return " + ifaceName + "." + typeArgumentString + "builder().config(config).buildPrototype();");
            } else if (typeArguments.isEmpty()) {
                method.addContentLine("return new Builder().config(config).build();");
            } else {
                method.addContentLine("return new Builder()<>.config(config).build();");
            }
            classModel.addMethod(method);
            Method.Builder commonMethod = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("create")).isStatic(true).returnType(prototype).addParameter(paramBuilder -> paramBuilder.type(Types.COMMON_CONFIG).name("config"))).javadoc(Javadoc.builder().add("Create a new instance from configuration.").returnDescription("a new instance configured from configuration").addParameter("config", "used to configure the new instance").addTag("deprecated", "use {@link #create(" + Types.CONFIG.fqName() + ")}").build())).addContent("return create(")).addContent(Types.CONFIG)).addContentLine(".config(config));")).addAnnotation(Annotations.DEPRECATED);
            typeArguments.forEach(arg_0 -> ((Method.Builder)commonMethod).addGenericArgument(arg_0));
            classModel.addMethod(commonMethod);
        }
    }

    private static void addCopyBuilderMethod(ClassModel.Builder classModel, TypeName builderTypeName, TypeName prototype, List<TypeArgument> typeArguments, String ifaceName, String typeArgumentString) {
        classModel.addMethod(builder -> {
            ((Method.Builder)((Method.Builder)builder.isStatic(true).name("builder")).description("Create a new fluent API builder from an existing instance.")).returnType(builderTypeName, "a builder based on an instance").addParameter(paramBuilder -> ((Parameter.Builder)paramBuilder.type(prototype).name("instance")).description("an existing instance used as a base for the builder"));
            typeArguments.forEach(arg_0 -> ((Method.Builder)builder).addGenericArgument(arg_0));
            builder.addContentLine("return " + ifaceName + "." + typeArgumentString + "builder().from(instance);");
        });
    }

    private static void addBuilderMethod(ClassModel.Builder classModel, TypeName builderTypeName, List<TypeArgument> typeArguments, String ifaceName) {
        classModel.addMethod(builder -> {
            ((Method.Builder)((Method.Builder)builder.isStatic(true).name("builder")).description("Create a new fluent API builder to customize configuration.")).returnType(builderTypeName, "a new builder");
            typeArguments.forEach(arg_0 -> ((Method.Builder)builder).addGenericArgument(arg_0));
            if (typeArguments.isEmpty()) {
                builder.addContentLine("return new " + ifaceName + ".Builder();");
            } else {
                builder.addContentLine("return new " + ifaceName + ".Builder<>();");
            }
        });
    }

    private static void generateCustomConstants(CustomMethods customMethods, ClassModel.Builder classModel) {
        for (CustomConstant customConstant : customMethods.customConstants()) {
            classModel.addField(constant -> ((Field.Builder)constant.type(customConstant.fieldType()).name(customConstant.name())).javadoc(customConstant.javadoc()).addContent(customConstant.declaringType()).addContent(".").addContent(customConstant.name()));
        }
    }

    private static void generateCustomMethods(ClassModel.Builder classModel, TypeName builderTypeName, TypeName prototype, CustomMethods customMethods) {
        for (CustomMethods.CustomMethod customMethod : customMethods.factoryMethods()) {
            String className;
            TypeName typeName = customMethod.declaredMethod().returnType();
            if (typeName.packageName().isBlank() ? !(className = typeName.className()).equals(prototype.className()) && !className.equals(builderTypeName.className()) : !typeName.equals((Object)prototype) && !typeName.equals((Object)builderTypeName)) continue;
            CustomMethods.Method generated = customMethod.generatedMethod().method();
            Method.Builder method = ((Method.Builder)((Method.Builder)Method.builder().name(generated.name())).javadoc(Javadoc.parse(generated.javadoc()))).isStatic(true).returnType(generated.returnType());
            customMethod.generatedMethod().generateCode().accept((ContentBuilder<?>)method);
            for (String annotation : customMethod.generatedMethod().annotations()) {
                method.addAnnotation(io.helidon.codegen.classmodel.Annotation.parse((String)annotation));
            }
            for (CustomMethods.Argument argument : generated.arguments()) {
                method.addParameter(param -> ((Parameter.Builder)param.name(argument.name())).type(argument.typeName()));
            }
            classModel.addMethod(method);
        }
        for (CustomMethods.CustomMethod customMethod : customMethods.prototypeMethods()) {
            CustomMethods.Method generated = customMethod.generatedMethod().method();
            if (generated.javadoc().isEmpty() && customMethod.generatedMethod().annotations().contains(Override.class.getName())) continue;
            Method.Builder method = ((Method.Builder)((Method.Builder)Method.builder().name(generated.name())).javadoc(Javadoc.parse(generated.javadoc()))).returnType(generated.returnType());
            for (String annotation : customMethod.generatedMethod().annotations()) {
                method.addAnnotation(io.helidon.codegen.classmodel.Annotation.parse((String)annotation));
            }
            for (CustomMethods.Argument argument : generated.arguments()) {
                method.addParameter(param -> ((Parameter.Builder)param.name(argument.name())).type(argument.typeName()));
            }
            classModel.addMethod(method);
        }
    }

    private void updateServiceLoaderResource() {
        String moduleName;
        String resourceLocation;
        CodegenFiler filer = this.ctx.filer();
        FilerTextResource serviceLoaderResource = filer.textResource(resourceLocation = "META-INF/helidon" + (String)((moduleName = (String)this.ctx.moduleName().orElse(null)) == null ? "" : "/" + moduleName) + "/service.loader", new Object[0]);
        ArrayList<String> lines = new ArrayList<String>(serviceLoaderResource.lines());
        if (lines.isEmpty()) {
            lines.add("# List of service contracts we want to support either from service registry, or from service loader");
        }
        boolean modified = false;
        for (String serviceLoaderContract : this.serviceLoaderContracts) {
            if (lines.contains(serviceLoaderContract)) continue;
            modified = true;
            lines.add(serviceLoaderContract);
        }
        if (modified) {
            serviceLoaderResource.lines(lines);
            serviceLoaderResource.write();
            filer.manifest().add(resourceLocation);
        }
    }

    private void process(RoundContext roundContext, TypeInfo blueprint) {
        TypeContext typeContext = TypeContext.create(this.ctx, blueprint);
        AnnotationDataBlueprint blueprintDef = typeContext.blueprintData();
        AnnotationDataConfigured configuredData = typeContext.configuredData();
        TypeContext.PropertyData propertyData = typeContext.propertyData();
        TypeContext.TypeInformation typeInformation = typeContext.typeInfo();
        CustomMethods customMethods = typeContext.customMethods();
        TypeInfo typeInfo = typeInformation.blueprintType();
        TypeName prototype = typeContext.typeInfo().prototype();
        String ifaceName = prototype.className();
        List<TypeName> typeGenericArguments = blueprintDef.typeArguments();
        String typeArgumentString = this.createTypeArgumentString(typeGenericArguments);
        ClassModel.Builder classModel = ((ClassModel.Builder)ClassModel.builder().type(prototype).classType(ElementKind.INTERFACE)).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)typeInfo.typeName(), (TypeName)prototype));
        String javadocString = blueprintDef.javadoc();
        ArrayList<TypeArgument> typeArguments = new ArrayList<TypeArgument>();
        Javadoc javadoc = javadocString == null ? Javadoc.parse((String)"Interface generated from definition. Please add javadoc to the definition interface.") : Javadoc.parse((String)blueprintDef.javadoc());
        classModel.javadoc(javadoc);
        typeGenericArguments.forEach(arg -> {
            TypeArgument.Builder tokenBuilder = TypeArgument.builder().token(arg.className());
            if (!arg.upperBounds().isEmpty()) {
                arg.upperBounds().forEach(arg_0 -> ((TypeArgument.Builder)tokenBuilder).addBound(arg_0));
            }
            if (javadoc.genericsTokens().containsKey(arg.className())) {
                tokenBuilder.description((List)javadoc.genericsTokens().get(arg.className()));
            }
            typeArguments.add(tokenBuilder.build());
        });
        List<TypeName> typeArgumentNames = typeArguments.stream().map(it -> TypeName.createFromGenericDeclaration((String)it.className())).collect(Collectors.toList());
        typeArguments.forEach(arg_0 -> ((ClassModel.Builder)classModel).addGenericArgument(arg_0));
        if (blueprintDef.builderPublic()) {
            classModel.addJavadocTag("see", "#builder()");
        }
        if (!propertyData.hasRequired() && blueprintDef.createEmptyPublic() && blueprintDef.builderPublic()) {
            classModel.addJavadocTag("see", "#create()");
        }
        typeContext.typeInfo().annotationsToGenerate().forEach(annotation -> classModel.addAnnotation(io.helidon.codegen.classmodel.Annotation.parse((String)annotation)));
        classModel.addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)typeInfo.typeName(), (TypeName)prototype, (String)"1", (String)""));
        if (typeContext.blueprintData().prototypePublic()) {
            classModel.accessModifier(AccessModifier.PUBLIC);
        } else {
            classModel.accessModifier(AccessModifier.PACKAGE_PRIVATE);
        }
        blueprintDef.extendsList().forEach(arg_0 -> ((ClassModel.Builder)classModel).addInterface(arg_0));
        BuilderCodegen.generateCustomConstants(customMethods, classModel);
        TypeName builderTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(prototype.fqName() + ".Builder")))).typeArguments(prototype.typeArguments())).build();
        BuilderCodegen.addBuilderMethod(classModel, builderTypeName, typeArguments, ifaceName);
        BuilderCodegen.addCopyBuilderMethod(classModel, builderTypeName, prototype, typeArguments, ifaceName, typeArgumentString);
        BuilderCodegen.addCreateFromConfigMethod(blueprintDef, configuredData, prototype, typeArguments, ifaceName, typeArgumentString, classModel);
        BuilderCodegen.addCreateDefaultMethod(blueprintDef, propertyData, classModel, prototype, ifaceName, typeArgumentString, typeArguments);
        BuilderCodegen.generateCustomMethods(classModel, builderTypeName, prototype, customMethods);
        this.generatePrototypeMethods(classModel, blueprint.typeName(), propertyData);
        GenerateAbstractBuilder.generate(classModel, typeInformation.prototype(), typeInformation.runtimeObject().orElseGet(typeInformation::prototype), typeArguments, typeArgumentNames, typeContext);
        GenerateBuilder.generate(classModel, typeInformation.prototype(), typeInformation.runtimeObject().orElseGet(typeInformation::prototype), typeArguments, typeArgumentNames, typeContext.blueprintData().isFactory(), typeContext);
        roundContext.addGeneratedType(prototype, classModel, blueprint.typeName(), new Object[]{blueprint.originatingElementValue()});
        if (typeContext.typeInfo().supportsServiceRegistry()) {
            for (PrototypeProperty property : typeContext.propertyData().properties()) {
                if (!property.configuredOption().provider()) continue;
                this.serviceLoaderContracts.add(property.configuredOption().providerType().genericTypeName().fqName());
            }
        }
    }

    private void generatePrototypeMethods(ClassModel.Builder classModel, TypeName blueprintType, TypeContext.PropertyData propertyData) {
        for (PrototypeProperty property : propertyData.properties()) {
            Method.Builder method = (Method.Builder)((Method.Builder)Method.builder().name(property.getterName())).returnType(property.typeHandler().declaredType()).addAnnotation(Annotations.OVERRIDE);
            property.element().description().map(Javadoc::parse).ifPresent(arg_0 -> ((Method.Builder)method).javadoc(arg_0));
            if (property.element().elementModifiers().contains(Modifier.DEFAULT)) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.isDefault(true).addContent("return ")).addContent(blueprintType.classNameWithEnclosingNames())).addContent(".super.")).addContent(property.getterName())).addContent("();");
            }
            classModel.addMethod(method);
        }
    }

    private Collection<? extends ValidationTask> addBlueprintsForValidation(Set<TypeName> blueprints) {
        ArrayList<ValidationTask> result = new ArrayList<ValidationTask>();
        for (TypeName blueprintType : blueprints) {
            TypeInfo blueprint = (TypeInfo)this.ctx.typeInfo(blueprintType).orElseThrow(() -> new CodegenException("Could not get TypeInfo for " + blueprintType.fqName()));
            result.add(new ValidationTask.ValidateBlueprint(blueprint));
            TypeContext typeContext = TypeContext.create(this.ctx, blueprint);
            if (!typeContext.blueprintData().isFactory()) continue;
            result.add(new ValidationTask.ValidateBlueprintExtendsFactory(typeContext.typeInfo().prototype(), blueprint, this.toTypeInfo(blueprint, typeContext.typeInfo().runtimeObject().get())));
        }
        return result;
    }

    private TypeInfo toTypeInfo(TypeInfo typeInfo, TypeName typeName) {
        return (TypeInfo)this.ctx.typeInfo(typeName.genericTypeName()).orElseThrow(() -> new IllegalArgumentException("Type " + typeName.fqName() + " is not a valid type for Factory declared on type " + typeInfo.typeName().fqName()));
    }

    private List<? extends ValidationTask> addRuntimeTypesForValidation(Set<TypeName> runtimeTypes) {
        return runtimeTypes.stream().map(arg_0 -> ((CodegenContext)this.ctx).typeInfo(arg_0)).flatMap(Optional::stream).map(it -> new ValidationTask.ValidateConfiguredType((TypeInfo)it, this.annotationTypeValue((TypeInfo)it, Types.RUNTIME_PROTOTYPE))).toList();
    }

    private TypeName annotationTypeValue(TypeInfo typeInfo, TypeName annotationType) {
        return (TypeName)typeInfo.findAnnotation(annotationType).flatMap(rec$ -> ((Annotation)rec$).typeValue()).orElseThrow(() -> new IllegalArgumentException("Type " + typeInfo.typeName().fqName() + " has invalid ConfiguredBy annotation"));
    }

    private String createTypeArgumentString(List<TypeName> typeArguments) {
        if (!typeArguments.isEmpty()) {
            String arguments = typeArguments.stream().map(rec$ -> ((TypeName)rec$).className()).collect(Collectors.joining(", "));
            return "<" + arguments + ">";
        }
        return "";
    }
}

