/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.AnnotationDataBlueprint;
import io.helidon.builder.codegen.AnnotationDataConfigured;
import io.helidon.builder.codegen.AnnotationDataOption;
import io.helidon.builder.codegen.CustomMethods;
import io.helidon.builder.codegen.MethodSignature;
import io.helidon.builder.codegen.PrototypeProperty;
import io.helidon.builder.codegen.Types;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.Errors;
import io.helidon.common.Severity;
import io.helidon.common.types.Annotated;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

record TypeContext(TypeInformation typeInfo, AnnotationDataBlueprint blueprintData, AnnotationDataConfigured configuredData, PropertyData propertyData, CustomMethods customMethods) {
    private static final Set<String> IGNORED_NAMES = Set.of("build", "get", "buildPrototype");
    private static final String BLUEPRINT = "Blueprint";
    private static final Set<MethodSignature> IGNORED_METHODS = Set.of(new MethodSignature(TypeName.create(Boolean.TYPE), "equals", List.of(TypeNames.OBJECT)), new MethodSignature(TypeName.create(Integer.TYPE), "hashCode", List.of()), new MethodSignature(TypeNames.STRING, "toString", List.of()));

    static TypeContext create(CodegenContext ctx, TypeInfo blueprint) {
        String javadoc = blueprint.description().orElse(null);
        Optional blueprintAnnotationOpt = blueprint.findAnnotation(Types.PROTOTYPE_BLUEPRINT);
        Optional implementAnnoOpt = blueprint.findAnnotation(Types.PROTOTYPE_IMPLEMENT);
        if (blueprintAnnotationOpt.isEmpty()) {
            throw new IllegalStateException("Cannot get @Prototype.Blueprint annotation when processing it for type " + String.valueOf(blueprint));
        }
        Annotation blueprintAnnotation = blueprintAnnotationOpt.orElseGet(() -> Annotation.create((TypeName)Types.PROTOTYPE_BLUEPRINT));
        List prototypeImplements = implementAnnoOpt.map(TypeContext::prototypeImplements).orElseGet(List::of);
        LinkedHashSet<TypeName> extendList = new LinkedHashSet<TypeName>();
        LinkedHashSet<TypeName> superPrototypes = new LinkedHashSet<TypeName>();
        LinkedHashSet<TypeName> ignoreInterfaces = new LinkedHashSet<TypeName>();
        extendList.add(blueprint.typeName());
        extendList.add(Types.PROTOTYPE_API);
        TypeContext.gatherExtends(blueprint, extendList, superPrototypes, ignoreInterfaces);
        extendList.addAll(prototypeImplements);
        Optional<Object> superPrototype = superPrototypes.isEmpty() ? Optional.empty() : Optional.of((TypeName)superPrototypes.iterator().next());
        boolean beanStyleAccessors = blueprintAnnotation.getValue("beanStyle").map(Boolean::parseBoolean).orElse(false);
        Errors.Collector errors = Errors.collector();
        List<PrototypeProperty> propertyMethods = new ArrayList<PrototypeProperty>();
        HashSet<MethodSignature> ignoredMethods = new HashSet<MethodSignature>(IGNORED_METHODS);
        HashSet<MethodSignature> superPrototypeMethods = new HashSet<MethodSignature>();
        TypeContext.gatherBuilderProperties(ctx, blueprint, errors, propertyMethods, ignoredMethods, ignoreInterfaces, beanStyleAccessors, superPrototypeMethods);
        errors.collect().checkValid();
        ArrayList<PrototypeProperty> overridingProperties = new ArrayList<PrototypeProperty>();
        propertyMethods = propertyMethods.stream().filter(it -> {
            if (superPrototypeMethods.contains(it.signature())) {
                overridingProperties.add((PrototypeProperty)it);
                return false;
            }
            return true;
        }).toList();
        HashSet addedSignatures = new HashSet();
        propertyMethods = propertyMethods.stream().filter(it -> addedSignatures.add(it.signature())).toList();
        boolean hasOptional = propertyMethods.stream().map(PrototypeProperty::typeHandler).anyMatch(it -> it.declaredType().genericTypeName().equals((Object)TypeNames.OPTIONAL));
        boolean hasRequired = propertyMethods.stream().map(PrototypeProperty::configuredOption).anyMatch(AnnotationDataOption::required);
        boolean hasNonNulls = propertyMethods.stream().map(PrototypeProperty::configuredOption).anyMatch(AnnotationDataOption::validateNotNull);
        boolean hasAllowedValues = propertyMethods.stream().map(PrototypeProperty::configuredOption).anyMatch(AnnotationDataOption::hasAllowedValues);
        boolean prototypePublic = blueprintAnnotation.getValue("isPublic").map(Boolean::parseBoolean).orElse(true);
        boolean builderPublic = blueprintAnnotation.getValue("builderPublic").map(Boolean::parseBoolean).orElse(true);
        boolean createFromConfigPublic = blueprintAnnotation.getValue("createFromConfigPublic").map(Boolean::parseBoolean).orElse(true);
        boolean createEmptyPublic = blueprintAnnotation.getValue("createEmptyPublic").map(Boolean::parseBoolean).orElse(true);
        boolean hasProvider = propertyMethods.stream().map(PrototypeProperty::configuredOption).map(AnnotationDataOption::provider).filter(it -> it).findFirst().orElse(false);
        Optional<TypeName> decorator = blueprintAnnotation.getValue("decorator").map(TypeName::create).filter(Predicate.not(arg_0 -> ((TypeName)Types.PROTOTYPE_BUILDER_DECORATOR).equals(arg_0)));
        Optional<TypeInfo> factoryInterface = blueprint.interfaceTypeInfo().stream().filter(it -> Types.PROTOTYPE_FACTORY.equals((Object)it.typeName().genericTypeName())).findFirst();
        boolean isFactory = factoryInterface.isPresent();
        Optional<TypeName> runtimeObject = factoryInterface.map(it -> (TypeName)it.typeName().typeArguments().getFirst());
        AnnotationDataConfigured configured = AnnotationDataConfigured.create(blueprint);
        TypeName prototype = TypeContext.generatedTypeName(blueprint);
        TypeName prototypeImpl = ((TypeName.Builder)TypeName.builder((TypeName)prototype).className(prototype.className() + "Impl")).build();
        TypeName prototypeBuilder = ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)prototype).addEnclosingName(prototype.className())).className("Builder")).build();
        boolean supportsServiceRegistry = blueprint.findAnnotation(Types.PROTOTYPE_SERVICE_REGISTRY).flatMap(rec$ -> ((Annotation)rec$).booleanValue()).orElse(false);
        TypeInformation typeInformation = new TypeInformation(supportsServiceRegistry, blueprint, prototype, prototypeBuilder, prototypeImpl, runtimeObject, decorator, superPrototype, TypeContext.annotationsToGenerate((Annotated)blueprint));
        return new TypeContext(typeInformation, new AnnotationDataBlueprint(prototypePublic, builderPublic, createFromConfigPublic, createEmptyPublic, isFactory, extendList, javadoc, blueprint.typeName().typeArguments()), configured, new PropertyData(hasOptional, hasRequired, hasNonNulls, hasProvider, hasAllowedValues, propertyMethods, overridingProperties), CustomMethods.create(ctx, typeInformation));
    }

    static List<String> annotationsToGenerate(Annotated annotated) {
        return annotated.findAnnotation(Types.PROTOTYPE_ANNOTATED).flatMap(rec$ -> ((Annotation)rec$).stringValues()).stream().flatMap(Collection::stream).toList();
    }

    private static List<TypeName> prototypeImplements(Annotation annotation) {
        return annotation.stringValues().stream().flatMap(Collection::stream).map(TypeName::create).toList();
    }

    private static void gatherExtends(TypeInfo typeInfo, Set<TypeName> extendList, Set<TypeName> superPrototypes, Set<TypeName> ignoredInterfaces) {
        List typeInfos = typeInfo.interfaceTypeInfo();
        for (TypeInfo info : typeInfos) {
            if (info.findAnnotation(Types.PROTOTYPE_BLUEPRINT).isPresent()) {
                TypeName typeName = info.typeName();
                String className = typeName.className();
                TypeName toExtend = ((TypeName.Builder)TypeName.builder((TypeName)typeName).className(className.substring(0, className.length() - 9))).build();
                extendList.add(toExtend);
                superPrototypes.add(toExtend);
                ignoredInterfaces.add(toExtend);
                ignoredInterfaces.add(typeName);
            }
            boolean gatherAll = true;
            for (TypeInfo implementedInterface : info.interfaceTypeInfo()) {
                if (!implementedInterface.typeName().equals((Object)Types.PROTOTYPE_API)) continue;
                extendList.add(info.typeName());
                gatherAll = false;
                superPrototypes.add(info.typeName());
                if (!ignoredInterfaces.add(info.typeName().genericTypeName())) break;
                ignoredInterfaces.add(((TypeName.Builder)TypeName.builder((TypeName)info.typeName()).className(info.typeName().className() + BLUEPRINT)).build());
                TypeContext.ignoreAllInterfaces(ignoredInterfaces, info);
                break;
            }
            if (!gatherAll) continue;
            TypeContext.gatherExtends(info, extendList, superPrototypes, ignoredInterfaces);
        }
    }

    private static void ignoreAllInterfaces(Set<TypeName> ignoredInterfaces, TypeInfo info) {
        List superIfaces = info.interfaceTypeInfo();
        for (TypeInfo superIface : superIfaces) {
            if (!ignoredInterfaces.add(superIface.typeName().genericTypeName())) continue;
            TypeContext.ignoreAllInterfaces(ignoredInterfaces, superIface);
        }
    }

    private static void gatherBuilderProperties(CodegenContext ctx, TypeInfo typeInfo, Errors.Collector errors, List<PrototypeProperty> properties, Set<MethodSignature> ignoredMethods, Set<TypeName> ignoreInterfaces, boolean beanStyleAccessors, Set<MethodSignature> superPrototypeMethods) {
        TypeName typeName = typeInfo.typeName();
        properties.addAll(typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(it -> {
            if (it.elementModifiers().contains(Modifier.DEFAULT)) {
                ignoredMethods.add(MethodSignature.create(it));
                return false;
            }
            return true;
        }).filter(it -> {
            if (IGNORED_NAMES.contains(it.elementName())) {
                return false;
            }
            return !ignoredMethods.contains(MethodSignature.create(it));
        }).filter(it -> {
            if (ignoreInterfaces.contains(it.enclosingType().get())) {
                superPrototypeMethods.add(MethodSignature.create(it));
            }
            return !ignoreInterfaces.contains(it.enclosingType().get());
        }).filter(it -> {
            Severity severity = Severity.WARN;
            if (it.typeName().equals((Object)TypeNames.PRIMITIVE_VOID)) {
                errors.message("Builder definition methods cannot have void return type (must be getters): " + String.valueOf(typeName) + "." + it.elementName(), severity);
                return false;
            }
            if (!it.parameterArguments().isEmpty()) {
                errors.message("Builder definition methods cannot have parameters (must be getters): " + String.valueOf(typeName) + "." + it.elementName(), severity);
                return false;
            }
            return true;
        }).filter(it -> !"get".equals(it.elementName()) || !"T".equals(it.typeName().className())).map(it -> PrototypeProperty.create(ctx, typeInfo, it, beanStyleAccessors)).toList());
        List interfaces = typeInfo.interfaceTypeInfo();
        for (TypeInfo anInterface : interfaces) {
            TypeContext.gatherBuilderProperties(ctx, anInterface, errors, properties, ignoredMethods, ignoreInterfaces, beanStyleAccessors, superPrototypeMethods);
        }
    }

    private static TypeName generatedTypeName(TypeInfo typeInfo) {
        String typeName = typeInfo.typeName().className();
        if (!typeName.endsWith(BLUEPRINT)) {
            throw new IllegalArgumentException("Blueprint interface name must end with Blueprint, this is invalid type: " + typeInfo.typeName().fqName());
        }
        typeName = typeName.substring(0, typeName.length() - BLUEPRINT.length());
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)typeInfo.typeName()).enclosingNames(List.of())).className(typeName)).build();
    }

    record TypeInformation(boolean supportsServiceRegistry, TypeInfo blueprintType, TypeName prototype, TypeName prototypeBuilder, TypeName prototypeImpl, Optional<TypeName> runtimeObject, Optional<TypeName> decorator, Optional<TypeName> superPrototype, List<String> annotationsToGenerate) {
        public TypeName prototypeBuilderBase() {
            return ((TypeName.Builder)TypeName.builder((TypeName)this.prototypeBuilder).className(this.prototypeBuilder.className() + "Base")).build().genericTypeName();
        }
    }

    record PropertyData(boolean hasOptional, boolean hasRequired, boolean hasNonNulls, boolean hasProvider, boolean hasAllowedValues, List<PrototypeProperty> properties, List<PrototypeProperty> overridingProperties) {
    }
}

