/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.api;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigException;
import io.helidon.common.config.ConfiguredProvider;
import io.helidon.common.config.NamedService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;

final class ProvidedUtil {
    private static final String KEY_SERVICE_TYPE = "type";
    private static final String KEY_SERVICE_NAME = "name";
    private static final String KEY_SERVICE_ENABLED = "enabled";

    private ProvidedUtil() {
    }

    static <T extends NamedService> Optional<T> discoverService(Config config, String configKey, HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, boolean discoverServices) {
        List serviceConfigList = (List)config.get(configKey).asNodeList().orElseGet(List::of);
        if (serviceConfigList.size() > 1) {
            throw new ConfigException("There can only be one provider configured for " + String.valueOf(config.key()));
        }
        List<T> services = ProvidedUtil.discoverServices(config, configKey, serviceLoader, providerType, configType, discoverServices);
        return services.isEmpty() ? Optional.empty() : Optional.of((NamedService)services.get(0));
    }

    static <T extends NamedService> List<T> discoverServices(Config config, String configKey, HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, boolean allFromServiceLoader) {
        boolean discoverServices = (Boolean)config.get(configKey + "-discover-services").asBoolean().orElse((Object)allFromServiceLoader);
        Config providersConfig = config.get(configKey);
        ArrayList<ConfiguredService> configuredServices = new ArrayList<ConfiguredService>();
        List serviceConfigList = (List)providersConfig.asNodeList().orElseGet(List::of);
        boolean isList = providersConfig.isList();
        for (Config serviceConfig : serviceConfigList) {
            configuredServices.add(ProvidedUtil.configuredService(serviceConfig, isList));
        }
        if (providersConfig.isList()) {
            return ProvidedUtil.servicesFromList(serviceLoader, providerType, configType, configuredServices, discoverServices);
        }
        return ProvidedUtil.servicesFromObject(serviceLoader, providerType, configType, configuredServices, discoverServices);
    }

    private static <T extends NamedService> List<T> servicesFromObject(HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, List<ConfiguredService> configuredServices, boolean allFromServiceLoader) {
        HashSet availableProviders = new HashSet();
        HashMap allConfigs = new HashMap();
        configuredServices.forEach(it -> allConfigs.put(it.type(), it));
        HashSet unusedConfigs = new HashSet(allConfigs.keySet());
        ArrayList result = new ArrayList();
        serviceLoader.forEach(provider -> {
            ConfiguredService configuredService = (ConfiguredService)allConfigs.get(provider.configKey());
            availableProviders.add(provider.configKey());
            unusedConfigs.remove(provider.configKey());
            if (configuredService == null) {
                if (allFromServiceLoader) {
                    result.add(provider.create(Config.empty(), provider.configKey()));
                }
            } else if (configuredService.enabled()) {
                result.add(provider.create(configuredService.serviceConfig(), configuredService.name()));
            }
        });
        if (!unusedConfigs.isEmpty()) {
            throw new ConfigException("Unknown provider configured. Expected providers with types: " + String.valueOf(unusedConfigs) + ", but only the following providers are supported: " + String.valueOf(availableProviders) + ", provider interface: " + providerType.getName() + ", configured service: " + configType.getName());
        }
        return result;
    }

    private static <T extends NamedService> List<T> servicesFromList(HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, List<ConfiguredService> configuredServices, boolean allFromServiceLoader) {
        HashMap allProvidersByType = new HashMap();
        LinkedHashMap unusedProvidersByType = new LinkedHashMap();
        serviceLoader.forEach(it -> {
            allProvidersByType.put(it.configKey(), it);
            unusedProvidersByType.put(it.configKey(), it);
        });
        ArrayList<NamedService> result = new ArrayList<NamedService>();
        for (ConfiguredService service : configuredServices) {
            ConfiguredProvider provider = (ConfiguredProvider)allProvidersByType.get(service.type());
            if (provider == null) {
                throw new ConfigException("Unknown provider configured. Expecting a provider with type \"" + service.type() + "\", but only the following providers are supported: " + String.valueOf(allProvidersByType.keySet()) + ", provider interface: " + providerType.getName() + ", configured service: " + configType.getName());
            }
            unusedProvidersByType.remove(service.type());
            if (!service.enabled()) continue;
            result.add(provider.create(service.serviceConfig(), service.name()));
        }
        if (allFromServiceLoader) {
            unusedProvidersByType.values().forEach(it -> result.add(it.create(Config.empty(), it.configKey())));
        }
        return result;
    }

    private static ConfiguredService configuredService(Config serviceConfig, boolean isList) {
        if (isList) {
            String type = (String)serviceConfig.get(KEY_SERVICE_TYPE).asString().orElse(null);
            String name = (String)serviceConfig.get(KEY_SERVICE_NAME).asString().orElse((Object)type);
            boolean enabled = (Boolean)serviceConfig.get(KEY_SERVICE_ENABLED).asBoolean().orElse((Object)true);
            Config usedConfig = serviceConfig;
            if (type == null) {
                List configs = (List)serviceConfig.asNodeList().orElseGet(List::of);
                if (configs.size() != 1) {
                    throw new ConfigException("Service provider configuration defined as a list must have a single node that is the type, with children containing the provider configuration. Failed on: " + String.valueOf(serviceConfig.key()));
                }
                usedConfig = (Config)configs.get(0);
                name = usedConfig.name();
                type = (String)usedConfig.get(KEY_SERVICE_TYPE).asString().orElse((Object)name);
                enabled = (Boolean)usedConfig.get(KEY_SERVICE_ENABLED).asBoolean().orElse((Object)enabled);
            }
            return new ConfiguredService(usedConfig, type, name, enabled);
        }
        String name = serviceConfig.name();
        String type = (String)serviceConfig.get(KEY_SERVICE_TYPE).asString().orElse((Object)name);
        boolean enabled = (Boolean)serviceConfig.get(KEY_SERVICE_ENABLED).asBoolean().orElse((Object)true);
        return new ConfiguredService(serviceConfig, type, name, enabled);
    }

    private record ConfiguredService(Config serviceConfig, String type, String name, boolean enabled) {
    }
}

