/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.api;

import io.helidon.builder.api.ProvidedUtil;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfiguredProvider;
import io.helidon.common.config.NamedService;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;

public final class Prototype {
    private Prototype() {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Confidential {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Redundant {
        public boolean equality() default true;

        public boolean stringValue() default true;
    }

    public static @interface Implement {
        public String[] value();
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface PrototypeMethod {
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface BuilderMethod {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface CustomMethods {
        public Class<?> value();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface SameGeneric {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Singular {
        public String value() default "";
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface FactoryMethod {
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Annotated {
        public String[] value();
    }

    @FunctionalInterface
    public static interface BuilderInterceptor<T> {
        public T intercept(T var1);
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Blueprint {
        public boolean isPublic() default true;

        public boolean builderPublic() default true;

        public boolean createFromConfigPublic() default true;

        public boolean createEmptyPublic() default true;

        public boolean beanStyle() default false;

        public Class<? extends BuilderInterceptor> builderInterceptor() default BuilderInterceptor.class;
    }

    public static interface Factory<T> {
        public T build();
    }

    public static interface ConfiguredBuilder<BUILDER, PROTOTYPE>
    extends Builder<BUILDER, PROTOTYPE> {
        public BUILDER config(Config var1);

        default public <S extends NamedService, T extends ConfiguredProvider<S>> List<S> discoverServices(Config config, HelidonServiceLoader<T> serviceLoader, Class<T> providerType, Class<S> configType, boolean allFromServiceLoader) {
            return ProvidedUtil.discoverServices(config, serviceLoader, providerType, configType, allFromServiceLoader);
        }
    }

    public static interface Builder<BUILDER, PROTOTYPE> {
        public PROTOTYPE buildPrototype();

        default public BUILDER self() {
            return (BUILDER)this;
        }

        default public <T> T resolveBuilder(T instance) {
            if (instance instanceof Builder) {
                Builder builder = (Builder)instance;
                return (T)builder.buildPrototype();
            }
            if (instance instanceof io.helidon.common.Builder) {
                io.helidon.common.Builder builder = (io.helidon.common.Builder)instance;
                return (T)builder.build();
            }
            return instance;
        }
    }

    public static interface Api {
    }
}

