/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Unchecked {
    public static <T, E extends Exception> Supplier unchecked(CheckedSupplier<T, E> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static <E extends Exception> Runnable unchecked(CheckedRunnable<E> runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static <T, E extends Exception> Consumer<T> unchecked(CheckedConsumer<T, E> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> unchecked(CheckedBiConsumer<T, U, E> consumer) {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static <T, U, E extends Exception> Function<T, U> unchecked(CheckedFunction<T, U, E> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static interface CheckedSupplier<T, E extends Exception> {
        public T get() throws E;
    }

    public static interface CheckedRunnable<E extends Exception> {
        public void run() throws E;
    }

    public static interface CheckedFunction<T, U, E extends Exception> {
        public U apply(T var1) throws E;
    }

    public static interface CheckedBiConsumer<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    public static interface CheckedConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

