/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class TestUtils {
    private TestUtils() {
    }

    public static boolean isDebugLogEnabled() {
        return DebugLogLevel.ENABLED;
    }

    public static String pathOf(Path path) {
        return path.toString().replace("\\", "/");
    }

    public static Path uniqueDir(Path parentDirectory, String name) {
        Path dir = parentDirectory.resolve(name);
        int i = 1;
        while (Files.exists(dir, new LinkOption[0])) {
            dir = parentDirectory.resolve(name + "-" + i);
            ++i;
        }
        return dir;
    }

    private static boolean resolveDebugLogLevel() {
        String[] cmd = System.getProperty("sun.java.command", "").split(" ");
        if (cmd.length > 0 && "org.apache.maven.surefire.booter.ForkedBooter".equals(cmd[0])) {
            if (cmd.length > 2) {
                Path dir = Paths.get(cmd[1], new String[0]);
                for (int i = 2; i < cmd.length; ++i) {
                    Path p = dir.resolve(cmd[i]);
                    if (!Files.isRegularFile(p, new LinkOption[0])) continue;
                    try {
                        if (Files.readAllLines(p).stream().filter(line -> line.endsWith("=LOGGING_LEVEL_DEBUG")).findAny().isPresent()) {
                            return true;
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        } else if ("debug".equals(System.getProperty("org.slf4j.simpleLogger.defaultLogLevel"))) {
            return true;
        }
        return false;
    }

    private static class DebugLogLevel {
        static final boolean ENABLED = TestUtils.resolveDebugLogLevel();

        private DebugLogLevel() {
        }
    }
}

