/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.StyleFunction;
import io.helidon.build.util.SystemLogWriter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Log {
    private static final AtomicReference<Writer> WRITER = new AtomicReference();
    private static final AtomicInteger MESSAGES = new AtomicInteger();
    private static final AtomicInteger WARNINGS = new AtomicInteger();
    private static final AtomicInteger ERRORS = new AtomicInteger();
    private static final boolean DEBUG = "debug".equals(System.getProperty("log.level"));
    private static final String PAD = " ";

    private Log() {
    }

    public static void writer(Writer writer) {
        WRITER.set(Objects.requireNonNull(writer));
    }

    public static Writer writer() {
        Writer writer = WRITER.get();
        if (writer == null) {
            writer = SystemLogWriter.create();
            Log.writer(writer);
        }
        return writer;
    }

    public static boolean isDebug() {
        return Log.writer().isDebug();
    }

    public static boolean isVerbose() {
        return Log.writer().isVerbose();
    }

    public static int messages() {
        return MESSAGES.get();
    }

    public static int warnings() {
        return WARNINGS.get();
    }

    public static int errors() {
        return ERRORS.get();
    }

    public static void debug(String message, Object ... args) {
        Log.log(Level.DEBUG, message, args);
    }

    public static void verbose(String message, Object ... args) {
        Log.log(Level.VERBOSE, message, args);
    }

    public static void info() {
        Log.log(Level.INFO, "", new Object[0]);
    }

    public static void info(String message, Object ... args) {
        Log.log(Level.INFO, message, args);
    }

    public static void info(Map<Object, Object> map) {
        Log.info(map, Log.maxKeyWidth(map));
    }

    public static void info(Map<Object, Object> map, int maxKeyWidth) {
        Log.info(map, maxKeyWidth, StyleFunction.Italic, StyleFunction.BoldBlue);
    }

    public static void info(Map<Object, Object> map, StyleFunction keyStyle, StyleFunction valueStyle) {
        Log.info(map, Log.maxKeyWidth(map), keyStyle, valueStyle);
    }

    public static void info(Map<Object, Object> map, int maxKeyWidth, StyleFunction keyStyle, StyleFunction valueStyle) {
        if (!map.isEmpty()) {
            map.forEach((key, value) -> {
                String padding = Log.padding(maxKeyWidth, key);
                Log.info("%s %s %s", keyStyle.apply(key), padding, valueStyle.apply(value));
            });
        }
    }

    public static void warn(String message, Object ... args) {
        Log.log(Level.WARN, message, args);
    }

    public static void warn(Throwable thrown, String msg, Object ... args) {
        Log.log(Level.WARN, thrown, msg, args);
    }

    public static void error(String message, Object ... args) {
        Log.log(Level.ERROR, message, args);
    }

    public static void error(Throwable thrown, String message, Object ... args) {
        Log.log(Level.ERROR, thrown, message, args);
    }

    public static void log(Level level, String message, Object ... args) {
        Log.log(level, null, message, args);
    }

    public static void log(Level level, Throwable thrown, String message, Object ... args) {
        MESSAGES.incrementAndGet();
        if (level == Level.WARN) {
            WARNINGS.incrementAndGet();
        } else if (level == Level.ERROR) {
            ERRORS.incrementAndGet();
        }
        if (message == null) {
            message = "<null>";
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) continue;
                args[i] = "<null>";
            }
        }
        Log.writer().write(level, thrown, message, args);
    }

    public static boolean hasWriter() {
        return WRITER.get() != null;
    }

    public static boolean isSystemWriter() {
        return WRITER.get() instanceof SystemLogWriter;
    }

    public static void preInitDebug(String message, Object ... args) {
        if (Log.hasWriter()) {
            Log.debug(message, args);
        } else if (DEBUG) {
            System.out.printf(message + "%n", args);
        }
    }

    @SafeVarargs
    public static int maxKeyWidth(Map<Object, Object> ... maps) {
        int maxLen = 0;
        for (Map<Object, Object> map : maps) {
            for (Object key : map.keySet()) {
                int len = key.toString().length();
                if (len <= maxLen) continue;
                maxLen = len;
            }
        }
        return maxLen;
    }

    private static String padding(int maxKeyWidth, Object key) {
        int keyLen = key.toString().length();
        if (maxKeyWidth > keyLen) {
            return PAD.repeat(maxKeyWidth - keyLen);
        }
        return "";
    }

    public static interface Writer {
        public void write(Level var1, Throwable var2, String var3, Object ... var4);

        public boolean isDebug();

        public boolean isVerbose();

        default public boolean isSystem() {
            return false;
        }
    }

    public static enum Level {
        DEBUG(java.util.logging.Level.FINEST),
        VERBOSE(java.util.logging.Level.FINE),
        INFO(java.util.logging.Level.INFO),
        WARN(java.util.logging.Level.WARNING),
        ERROR(java.util.logging.Level.SEVERE);

        private final java.util.logging.Level julLevel;

        java.util.logging.Level toJulLevel() {
            return this.julLevel;
        }

        private Level(java.util.logging.Level julLevel) {
            this.julLevel = julLevel;
        }
    }
}

