/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.Log;
import io.helidon.build.util.LogFormatter;
import java.io.PrintStream;

public abstract class DefaultLogWriter
implements Log.Writer {
    private static final String DEFAULT_LEVEL = "info";
    private static final String LEVEL_PROPERTY = "log.level";
    private int ordinal;

    private static Log.Level defaultLevel() {
        return Log.Level.valueOf(System.getProperty(LEVEL_PROPERTY, DEFAULT_LEVEL).toUpperCase());
    }

    public DefaultLogWriter() {
        this(DefaultLogWriter.defaultLevel());
    }

    public DefaultLogWriter(Log.Level level) {
        this.level(level);
    }

    public abstract PrintStream stdOut();

    public abstract PrintStream stdErr();

    public void level(Log.Level level) {
        this.ordinal = level.ordinal();
    }

    @Override
    public boolean isDebug() {
        return Log.Level.DEBUG.ordinal() >= this.ordinal;
    }

    @Override
    public boolean isVerbose() {
        return Log.Level.VERBOSE.ordinal() >= this.ordinal;
    }

    @Override
    public void write(Log.Level level, Throwable thrown, String message, Object ... args) {
        if (level.ordinal() >= this.ordinal) {
            String msg = LogFormatter.format(level, thrown, message, args);
            switch (level) {
                case DEBUG: 
                case VERBOSE: 
                case INFO: {
                    this.stdOut().println(msg);
                    break;
                }
                case WARN: 
                case ERROR: {
                    this.stdErr().println(msg);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }
}

