/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.BuildToolsProperties;
import io.helidon.build.util.Constants;
import io.helidon.build.util.FileUtils;
import io.helidon.build.util.HelidonVariant;
import io.helidon.build.util.Log;
import io.helidon.build.util.ProcessMonitor;
import io.helidon.build.util.ProjectConfig;
import io.helidon.build.util.StyleFunction;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class ApplicationGenerator {
    private static final String MAVEN_EXEC = Constants.OS.mavenExec();
    private static final String ARCHETYPES_GROUP_ID = "io.helidon.archetypes";
    private static final String HELIDON_ARTIFACT_ID_PREFIX = "helidon-app-";
    private static final String HELIDON_ARCHETYPES_PREFIX = "helidon-";
    private static final String DEFAULT_ARCHETYPE_NAME = "bare";
    private static final String APPLICATION_PACKAGE_PREFIX = "io.helidon.examples.";
    private Path parentDirectory;
    private HelidonVariant variant;
    private String archetypeName;
    private boolean quiet;
    private String groupId;
    private String artifactId;
    private String version;
    private String packageName;
    private String pluginVersion = BuildToolsProperties.instance().version();

    public static ApplicationGenerator generator() {
        return new ApplicationGenerator();
    }

    private ApplicationGenerator() {
    }

    public ApplicationGenerator archetypeName(String archetypeName) {
        this.archetypeName = archetypeName;
        return this;
    }

    public ApplicationGenerator groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public ApplicationGenerator artifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public ApplicationGenerator packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public ApplicationGenerator helidonVersion(String version) {
        Objects.requireNonNull(version);
        this.version = version;
        return this;
    }

    public ApplicationGenerator helidonVariant(HelidonVariant helidonVariant) {
        this.variant = helidonVariant;
        return this;
    }

    public ApplicationGenerator pluginVersion(String pluginVersion) {
        Objects.requireNonNull(pluginVersion);
        this.pluginVersion = pluginVersion;
        return this;
    }

    public ApplicationGenerator quiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    public ApplicationGenerator parentDirectory(Path parentDirectory) {
        this.parentDirectory = FileUtils.assertDir(parentDirectory);
        return this;
    }

    public Path generate() {
        this.initialize();
        Log.info("Creating %s using version %s", StyleFunction.BoldBrightCyan.apply(this.artifactId), StyleFunction.Blue.apply(this.version));
        String archetypeId = HELIDON_ARCHETYPES_PREFIX + this.archetypeName + "-" + this.variant.toString();
        ApplicationGenerator.execute(new ProcessBuilder(new String[0]).directory(this.parentDirectory.toFile()).command(List.of(MAVEN_EXEC, "archetype:generate", "-DinteractiveMode=false", "-DarchetypeGroupId=io.helidon.archetypes", "-DarchetypeArtifactId=" + archetypeId, "-DarchetypeVersion=" + this.version, "-DgroupId=" + this.groupId, "-DartifactId=" + this.artifactId, "-Dpackage=" + this.packageName)));
        Path projectDir = FileUtils.assertDir(this.parentDirectory.resolve(this.artifactId));
        ProjectConfig.ensureProjectConfig(projectDir, this.version);
        this.log("Created %s", projectDir);
        return projectDir;
    }

    private void initialize() {
        Path projectDir;
        if (this.version == null) {
            throw new IllegalStateException("version required.");
        }
        if (this.variant == null) {
            throw new IllegalStateException("helidonVariant required.");
        }
        if (this.parentDirectory == null) {
            throw new IllegalStateException("projectDirectory required.");
        }
        if (this.pluginVersion == null) {
            throw new IllegalStateException("pluginVersion required.");
        }
        if (this.groupId == null) {
            this.groupId = "test";
        }
        if (this.archetypeName == null) {
            this.archetypeName = DEFAULT_ARCHETYPE_NAME;
        }
        if (this.artifactId == null) {
            this.artifactId = HELIDON_ARTIFACT_ID_PREFIX + this.variant.toString();
        }
        if (this.packageName == null) {
            this.packageName = APPLICATION_PACKAGE_PREFIX + this.variant.toString();
        }
        if (Files.exists(projectDir = this.parentDirectory.resolve(this.artifactId), new LinkOption[0])) {
            throw new IllegalStateException(projectDir + " already exists");
        }
    }

    private void log(String message, Object ... args) {
        if (!this.quiet) {
            Log.info(message, args);
        }
    }

    private static void execute(ProcessBuilder builder) {
        try {
            ProcessMonitor.builder().processBuilder(builder).capture(true).build().execute(5L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

