var _apacheCamelModelVersion = '2.21.1';

var _apacheCamelModel ={
  "definitions": {
    "expression": {
      "type": "object",
      "title": "expression",
      "group": "language",
      "icon": "generic24.png",
      "description": "Expression in the choose language",
      "properties": {
        "expression": {
          "kind": "element",
          "type": "string",
          "title": "Expression",
          "description": "The expression",
          "required": true
        },
        "language": {
          "kind": "element",
          "type": "string",
          "title": "Expression",
          "description": "The chosen language",
          "required": true,
          "enum": [ "constant", "el", "exchangeProperty", "groovy", "header", "javaScript", "jsonpath", "jxpath", "language", "method", "mvel", "ognl", "php", "python", "ref", "ruby", "simple", "spel", "sql", "terser", "tokenize", "xpath", "xquery", "xtokenize" ]
        }
      }
    },
    "aggregate": {
      "type": "object",
      "title": "Aggregate",
      "group": "eip,routing",
      "icon": "aggregate24.png",
      "description": "Aggregates many messages into a single message",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "correlationExpression": {
          "kind": "expression",
          "type": "object",
          "description": "The expression used to calculate the correlation key to use for aggregation. The Exchange which has the same correlation key is aggregated together. If the correlation key could not be evaluated an Exception is thrown. You can disable this by using the ignoreBadCorrelationKeys option.",
          "title": "Correlation Expression",
          "required": true,
          "deprecated": false
        },
        "completionPredicate": {
          "kind": "expression",
          "type": "object",
          "description": "A Predicate to indicate when an aggregated exchange is complete. If this is not specified and the AggregationStrategy object implements Predicate, the aggregationStrategy object will be used as the completionPredicate.",
          "title": "Completion Predicate",
          "required": false,
          "deprecated": false
        },
        "completionTimeoutExpression": {
          "kind": "expression",
          "type": "object",
          "description": "Time in millis that an aggregated exchange should be inactive before its complete (timeout). This option can be set as either a fixed value or using an Expression which allows you to evaluate a timeout dynamically - will use Long as result. If both are set Camel will fallback to use the fixed value if the Expression result was null or 0. You cannot use this option together with completionInterval, only one of the two can be used. By default the timeout checker runs every second, you can use the completionTimeoutCheckerInterval option to configure how frequently to run the checker. The timeout is an approximation and there is no guarantee that the a timeout is triggered exactly after the timeout value. It is not recommended to use very low timeout values or checker intervals.",
          "title": "Completion Timeout",
          "required": false,
          "deprecated": false
        },
        "completionSizeExpression": {
          "kind": "expression",
          "type": "object",
          "description": "Number of messages aggregated before the aggregation is complete. This option can be set as either a fixed value or using an Expression which allows you to evaluate a size dynamically - will use Integer as result. If both are set Camel will fallback to use the fixed value if the Expression result was null or 0.",
          "title": "Completion Size",
          "required": false,
          "deprecated": false
        },
        "optimisticLockRetryPolicy": {
          "kind": "element",
          "type": "object",
          "description": "Allows to configure retry settings when using optimistic locking.",
          "title": "Optimistic Lock Retry Policy",
          "required": false,
          "deprecated": false
        },
        "parallelProcessing": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "When aggregated are completed they are being send out of the aggregator. This option indicates whether or not Camel should use a thread pool with multiple threads for concurrency. If no custom thread pool has been specified then Camel creates a default pool with 10 concurrent threads.",
          "title": "Parallel Processing",
          "required": false,
          "deprecated": false
        },
        "optimisticLocking": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Turns on using optimistic locking, which requires the aggregationRepository being used, is supporting this by implementing org.apache.camel.spi.OptimisticLockingAggregationRepository.",
          "title": "Optimistic Locking",
          "required": false,
          "deprecated": false
        },
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "If using parallelProcessing you can specify a custom thread pool to be used. In fact also if you are not using parallelProcessing this custom thread pool is used to send out aggregated exchanges as well.",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "timeoutCheckerExecutorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "If using either of the completionTimeout, completionTimeoutExpression, or completionInterval options a background thread is created to check for the completion for every aggregator. Set this option to provide a custom thread pool to be used rather than creating a new thread for every aggregator.",
          "title": "Timeout Checker Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "aggregationRepositoryRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the custom aggregate repository to use Will by default use org.apache.camel.processor.aggregate.MemoryAggregationRepository",
          "title": "Aggregation Repository Ref",
          "required": false,
          "deprecated": false
        },
        "strategyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "A reference to lookup the AggregationStrategy in the Registry. Configuring an AggregationStrategy is required, and is used to merge the incoming Exchange with the existing already merged exchanges. At first call the oldExchange parameter is null. On subsequent invocations the oldExchange contains the merged exchanges and newExchange is of course the new incoming Exchange.",
          "title": "Strategy Ref",
          "required": false,
          "deprecated": false
        },
        "strategyMethodName": {
          "kind": "attribute",
          "type": "string",
          "description": "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Name",
          "required": false,
          "deprecated": false
        },
        "strategyMethodAllowNull": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If this option is false then the aggregate method is not used for the very first aggregation. If this option is true then null values is used as the oldExchange (at the very first aggregation), when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Allow Null",
          "required": false,
          "deprecated": false
        },
        "completionSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Number of messages aggregated before the aggregation is complete. This option can be set as either a fixed value or using an Expression which allows you to evaluate a size dynamically - will use Integer as result. If both are set Camel will fallback to use the fixed value if the Expression result was null or 0.",
          "title": "Completion Size",
          "required": false,
          "deprecated": false
        },
        "completionInterval": {
          "kind": "attribute",
          "type": "integer",
          "description": "A repeating period in millis by which the aggregator will complete all current aggregated exchanges. Camel has a background task which is triggered every period. You cannot use this option together with completionTimeout, only one of them can be used.",
          "title": "Completion Interval",
          "required": false,
          "deprecated": false
        },
        "completionTimeout": {
          "kind": "attribute",
          "type": "integer",
          "description": "Time in millis that an aggregated exchange should be inactive before its complete (timeout). This option can be set as either a fixed value or using an Expression which allows you to evaluate a timeout dynamically - will use Long as result. If both are set Camel will fallback to use the fixed value if the Expression result was null or 0. You cannot use this option together with completionInterval, only one of the two can be used. By default the timeout checker runs every second, you can use the completionTimeoutCheckerInterval option to configure how frequently to run the checker. The timeout is an approximation and there is no guarantee that the a timeout is triggered exactly after the timeout value. It is not recommended to use very low timeout values or checker intervals.",
          "title": "Completion Timeout",
          "required": false,
          "deprecated": false
        },
        "completionTimeoutCheckerInterval": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "1000",
          "description": "Interval in millis that is used by the background task that checks for timeouts (org.apache.camel.TimeoutMap). By default the timeout checker runs every second. The timeout is an approximation and there is no guarantee that the a timeout is triggered exactly after the timeout value. It is not recommended to use very low timeout values or checker intervals.",
          "title": "Completion Timeout Checker Interval",
          "required": false,
          "deprecated": false
        },
        "completionFromBatchConsumer": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Enables the batch completion mode where we aggregate from a org.apache.camel.BatchConsumer and aggregate the total number of exchanges the org.apache.camel.BatchConsumer has reported as total by checking the exchange property link org.apache.camel.ExchangeBATCH_COMPLETE when its complete.",
          "title": "Completion From Batch Consumer",
          "required": false,
          "deprecated": false
        },
        "completionOnNewCorrelationGroup": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Enables completion on all previous groups when a new incoming correlation group. This can for example be used to complete groups with same correlation keys when they are in consecutive order. Notice when this is enabled then only 1 correlation group can be in progress as when a new correlation group starts, then the previous groups is forced completed.",
          "title": "Completion On New Correlation Group",
          "required": false,
          "deprecated": false
        },
        "groupExchanges": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Enables grouped exchanges, so the aggregator will group all aggregated exchanges into a single combined Exchange holding all the aggregated exchanges in a java.util.List.",
          "title": "Group Exchanges",
          "required": false,
          "deprecated": true
        },
        "eagerCheckCompletion": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Use eager completion checking which means that the completionPredicate will use the incoming Exchange. As opposed to without eager completion checking the completionPredicate will use the aggregated Exchange.",
          "title": "Eager Check Completion",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidCorrelationKeys": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If a correlation key cannot be successfully evaluated it will be ignored by logging a DEBUG and then just ignore the incoming Exchange.",
          "title": "Ignore Invalid Correlation Keys",
          "required": false,
          "deprecated": false
        },
        "closeCorrelationKeyOnCompletion": {
          "kind": "attribute",
          "type": "integer",
          "description": "Closes a correlation key when its complete. Any late received exchanges which has a correlation key that has been closed, it will be defined and a ClosedCorrelationKeyException is thrown.",
          "title": "Close Correlation Key On Completion",
          "required": false,
          "deprecated": false
        },
        "discardOnCompletionTimeout": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Discards the aggregated message on completion timeout. This means on timeout the aggregated message is dropped and not sent out of the aggregator.",
          "title": "Discard On Completion Timeout",
          "required": false,
          "deprecated": false
        },
        "forceCompletionOnStop": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Indicates to complete all current aggregated exchanges when the context is stopped",
          "title": "Force Completion On Stop",
          "required": false,
          "deprecated": false
        },
        "completeAllOnStop": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Indicates to wait to complete all current and partial (pending) aggregated exchanges when the context is stopped. This also means that we will wait for all pending exchanges which are stored in the aggregation repository to complete so the repository is empty before we can stop. You may want to enable this when using the memory based aggregation repository that is memory based only, and do not store data on disk. When this option is enabled, then the aggregator is waiting to complete all those exchanges before its stopped, when stopping CamelContext or the route using it.",
          "title": "Complete All On Stop",
          "required": false,
          "deprecated": false
        },
        "aggregateControllerRef": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a org.apache.camel.processor.aggregate.AggregateController to allow external sources to control this aggregator.",
          "title": "Aggregate Controller Ref",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "aop": {
      "type": "object",
      "title": "Aop",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Does processing before and/or after the route is completed",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "beforeUri": {
          "kind": "attribute",
          "type": "string",
          "description": "Endpoint to call in AOP before.",
          "title": "Before Uri",
          "required": false,
          "deprecated": false
        },
        "afterUri": {
          "kind": "attribute",
          "type": "string",
          "description": "Endpoint to call in AOP after. The difference between after and afterFinally is that afterFinally is invoked from a finally block so it will always be invoked no matter what, eg also in case of an exception occur.",
          "title": "After Uri",
          "required": false,
          "deprecated": false
        },
        "afterFinallyUri": {
          "kind": "attribute",
          "type": "string",
          "description": "Endpoint to call in AOP after finally. The difference between after and afterFinally is that afterFinally is invoked from a finally block so it will always be invoked no matter what, eg also in case of an exception occur.",
          "title": "After Finally Uri",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "batch-config": {
      "type": "object",
      "title": "Batch-config",
      "group": "eip,routing,resequence",
      "icon": "generic24.png",
      "description": "Configures batch-processing resequence eip.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "batchSize": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "100",
          "description": "Sets the size of the batch to be re-ordered. The default size is 100.",
          "title": "Batch Size",
          "required": false,
          "deprecated": false
        },
        "batchTimeout": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "1000",
          "description": "Sets the timeout for collecting elements to be re-ordered. The default timeout is 1000 msec.",
          "title": "Batch Timeout",
          "required": false,
          "deprecated": false
        },
        "allowDuplicates": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to allow duplicates.",
          "title": "Allow Duplicates",
          "required": false,
          "deprecated": false
        },
        "reverse": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to reverse the ordering.",
          "title": "Reverse",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidExchanges": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to ignore invalid exchanges",
          "title": "Ignore Invalid Exchanges",
          "required": false,
          "deprecated": false
        }
      }
    },
    "bean": {
      "type": "object",
      "title": "Bean",
      "group": "eip,endpoint",
      "icon": "bean24.png",
      "description": "Calls a java bean",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a bean to use",
          "title": "Ref",
          "required": false,
          "deprecated": false
        },
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the method name on the bean to use",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "beanType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Class of the bean",
          "title": "Bean Type",
          "required": false,
          "deprecated": false
        },
        "cache": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Caches the bean lookup, to avoid lookup up bean on every usage.",
          "title": "Cache",
          "required": false,
          "deprecated": false
        },
        "multiParameterArray": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the message body is an array type.",
          "title": "Multi Parameter Array",
          "required": false,
          "deprecated": true
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "beanPostProcessor": {
      "type": "object",
      "title": "Bean Post Processor",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Spring specific DefaultCamelBeanPostProcessor which uses Spring BeanPostProcessor to post process beans.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
      }
    },
    "blacklistServiceFilter": {
      "type": "object",
      "title": "Blacklist Service Filter",
      "group": "routing,cloud,service-filter",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "servers": {
          "kind": "element",
          "type": "array",
          "description": "Sets the server blacklist. Each entry can be a list of servers separated by comma in the format: servicehost:port,servicehost2:port,servicehost3:port",
          "title": "Servers",
          "required": false,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "cachingServiceDiscovery": {
      "type": "object",
      "title": "Caching Service Discovery",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "timeout": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "60",
          "description": "Set the time the services will be retained.",
          "title": "Timeout",
          "required": false,
          "deprecated": false
        },
        "units": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "SECONDS",
          "enum": [ "DAYS", "HOURS", "MICROSECONDS", "MILLISECONDS", "MINUTES", "NANOSECONDS", "SECONDS" ],
          "description": "Set the time unit for the timeout.",
          "title": "Units",
          "required": false,
          "deprecated": false
        },
        "serviceDiscoveryConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Set the service-call configuration to use",
          "title": "Service Discovery Configuration",
          "required": true,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "camelContext": {
      "type": "object",
      "title": "Camel Context",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "CamelContext using XML configuration.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "depends-on": {
          "kind": "attribute",
          "type": "string",
          "description": "List of other bean id's this CamelContext depends up. Multiple bean id's can be separated by comma.",
          "title": "Depends-on",
          "required": false,
          "deprecated": false
        },
        "trace": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether tracing is enabled or not.",
          "title": "Trace",
          "required": false,
          "deprecated": false
        },
        "messageHistory": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Sets whether message history is enabled or not.",
          "title": "Message History",
          "required": false,
          "deprecated": false
        },
        "logMask": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether security mask for Logging is enabled or not.",
          "title": "Log Mask",
          "required": false,
          "deprecated": false
        },
        "logExhaustedMessageBody": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether to log exhausted message body with message history.",
          "title": "Log Exhausted Message Body",
          "required": false,
          "deprecated": false
        },
        "streamCache": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether stream caching is enabled or not.",
          "title": "Stream Cache",
          "required": false,
          "deprecated": false
        },
        "delayer": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a delay value in millis that a message is delayed at every step it takes in the route path, slowing the process down to better observe what is occurring",
          "title": "Delayer",
          "required": false,
          "deprecated": false
        },
        "handleFault": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether fault handling is enabled or not (default is disabled).",
          "title": "Handle Fault",
          "required": false,
          "deprecated": false
        },
        "errorHandlerRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the name of the error handler object used to default the error handling strategy",
          "title": "Error Handler Ref",
          "required": false,
          "deprecated": false
        },
        "autoStartup": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Sets whether the object should automatically start when Camel starts. Important: Currently only routes can be disabled, as CamelContexts are always started. Note: When setting auto startup false on CamelContext then that takes precedence and no routes is started. You would need to start CamelContext explicit using the link org.apache.camel.CamelContextstart() method, to start the context, and then you would need to start the routes manually using link CamelContextstartRoute(String).",
          "title": "Auto Startup",
          "required": false,
          "deprecated": false
        },
        "shutdownEager": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Whether to shutdown CamelContext eager when Spring is shutting down. This ensure a cleaner shutdown of Camel, as dependent bean's are not shutdown at this moment. The bean's will then be shutdown after camelContext.",
          "title": "Shutdown Eager",
          "required": false,
          "deprecated": false
        },
        "registerEndpointIdsFromRoute": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether to register endpoints that has id attribute assigned in the Spring registry. This mode is by default false, but can be turned on for backwards compatibility.",
          "title": "Register Endpoint Ids From Route",
          "required": false,
          "deprecated": true
        },
        "useMDCLogging": {
          "kind": "attribute",
          "type": "string",
          "description": "Set whether MDC is enabled.",
          "title": "Use M D C Logging",
          "required": false,
          "deprecated": false
        },
        "useDataType": {
          "kind": "attribute",
          "type": "string",
          "description": "Whether to enable using data type on Camel messages. Data type are automatic turned on if: one ore more routes has been explicit configured with input and output types when using rest-dsl with binding turned on Otherwise data type is default off.",
          "title": "Use Data Type",
          "required": false,
          "deprecated": false
        },
        "useBreadcrumb": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Set whether breadcrumb is enabled.",
          "title": "Use Breadcrumb",
          "required": false,
          "deprecated": false
        },
        "allowUseOriginalMessage": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether to allow access to the original message from Camel's error handler, or from link org.apache.camel.spi.UnitOfWorkgetOriginalInMessage(). Turning this off can optimize performance, as defensive copy of the original message is not needed.",
          "title": "Allow Use Original Message",
          "required": false,
          "deprecated": false
        },
        "runtimeEndpointRegistryEnabled": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether org.apache.camel.spi.RuntimeEndpointRegistry is enabled.",
          "title": "Runtime Endpoint Registry Enabled",
          "required": false,
          "deprecated": false
        },
        "managementNamePattern": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "#name#",
          "description": "The naming pattern for creating the CamelContext management name.",
          "title": "Management Name Pattern",
          "required": false,
          "deprecated": false
        },
        "threadNamePattern": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "Camel (#camelId#) thread ##counter# - #name#",
          "description": "Sets the thread name pattern used for creating the full thread name. The default pattern is: Camel (camelId) thread counter - name Where camelId is the name of the org.apache.camel.CamelContext and counter is a unique incrementing counter. and name is the regular thread name. You can also use longName is the long thread name which can includes endpoint parameters etc.",
          "title": "Thread Name Pattern",
          "required": false,
          "deprecated": false
        },
        "shutdownRoute": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "Default",
          "enum": [ "Default", "Defer" ],
          "description": "Sets the ShutdownRoute option for routes.",
          "title": "Shutdown Route",
          "required": false,
          "deprecated": false
        },
        "shutdownRunningTask": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "CompleteCurrentTaskOnly",
          "enum": [ "CompleteAllTasks", "CompleteCurrentTaskOnly" ],
          "description": "Sets the ShutdownRunningTask option to use when shutting down a route.",
          "title": "Shutdown Running Task",
          "required": false,
          "deprecated": false
        },
        "lazyLoadTypeConverters": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Sets whether type converters should be loaded lazy",
          "title": "Lazy Load Type Converters",
          "required": false,
          "deprecated": true
        },
        "loadTypeConverters": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Sets whether to load custom type converters by scanning classpath. This can be turned off if you are only using Camel components that does not provide type converters which is needed at runtime. In such situations setting this option to false, can speedup starting Camel.",
          "title": "Load Type Converters",
          "required": false,
          "deprecated": false
        },
        "typeConverterStatisticsEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Sets whether or not type converter statistics is enabled. By default the type converter utilization statistics is disabled. Notice: If enabled then there is a slight performance impact under very heavy load. You can enable/disable the statistics at runtime using the link org.apache.camel.spi.TypeConverterRegistrygetStatistics()setTypeConverterStatisticsEnabled(Boolean) method, or from JMX on the org.apache.camel.api.management.mbean.ManagedTypeConverterRegistryMBean mbean.",
          "title": "Type Converter Statistics Enabled",
          "required": false,
          "deprecated": false
        },
        "typeConverterExists": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "Override",
          "enum": [ "Fail", "Ignore", "Override" ],
          "description": "What should happen when attempting to add a duplicate type converter. The default behavior is to override the existing.",
          "title": "Type Converter Exists",
          "required": false,
          "deprecated": false
        },
        "typeConverterExistsLoggingLevel": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "WARN",
          "enum": [ "DEBUG", "ERROR", "INFO", "OFF", "TRACE", "WARN" ],
          "description": "The logging level to use when logging that a type converter already exists when attempting to add a duplicate type converter. The default logging level is WARN",
          "title": "Type Converter Exists Logging Level",
          "required": false,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "object",
          "description": "Configuration of CamelContext properties such as limit of debug logging and other general options.",
          "title": "Properties",
          "required": false,
          "deprecated": true
        },
        "globalOptions": {
          "kind": "element",
          "type": "object",
          "description": "Configuration of CamelContext properties such as limit of debug logging and other general options.",
          "title": "Global Options",
          "required": false,
          "deprecated": false
        },
        "propertyPlaceholder": {
          "kind": "element",
          "type": "object",
          "description": "Configuration of property placeholder",
          "title": "Property Placeholder",
          "required": false,
          "deprecated": false
        },
        "package": {
          "kind": "element",
          "type": "array",
          "description": "Sets the package names to be recursively searched for Java classes which extend org.apache.camel.builder.RouteBuilder to be auto-wired up to the CamelContext as a route. Note that classes are excluded if they are specifically configured in the spring.xml A more advanced configuration can be done using link setPackageScan(org.apache.camel.model.PackageScanDefinition)",
          "title": "Package",
          "required": false,
          "deprecated": false
        },
        "packageScan": {
          "kind": "element",
          "type": "object",
          "description": "Sets the package scanning information. Package scanning allows for the automatic discovery of certain camel classes at runtime for inclusion e.g. org.apache.camel.builder.RouteBuilder implementations",
          "title": "Package Scan",
          "required": false,
          "deprecated": false
        },
        "contextScan": {
          "kind": "element",
          "type": "object",
          "description": "Sets the context scanning (eg Spring's ApplicationContext) information. Context scanning allows for the automatic discovery of Camel routes runtime for inclusion e.g. org.apache.camel.builder.RouteBuilder implementations",
          "title": "Context Scan",
          "required": false,
          "deprecated": false
        },
        "streamCaching": {
          "kind": "element",
          "type": "object",
          "description": "Configuration of stream caching.",
          "title": "Stream Caching",
          "required": false,
          "deprecated": false
        },
        "jmxAgent": {
          "kind": "element",
          "type": "object",
          "description": "Configuration of JMX.",
          "title": "Jmx Agent",
          "required": false,
          "deprecated": false
        },
        "beansFactory": {
          "kind": "null",
          "type": "array",
          "description": "Miscellaneous configurations",
          "title": "Beans Factory",
          "required": false,
          "deprecated": false
        },
        "beans": {
          "kind": "null",
          "type": "array",
          "description": "Miscellaneous configurations",
          "title": "Beans",
          "required": false,
          "deprecated": false
        },
        "defaultServiceCallConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "ServiceCall EIP default configuration",
          "title": "Default Service Call Configuration",
          "required": false,
          "deprecated": false
        },
        "serviceCallConfiguration": {
          "kind": "element",
          "type": "array",
          "description": "ServiceCall EIP configurations",
          "title": "Service Call Configuration",
          "required": false,
          "deprecated": false
        },
        "defaultHystrixConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Hystrix EIP default configuration",
          "title": "Default Hystrix Configuration",
          "required": false,
          "deprecated": false
        },
        "hystrixConfiguration": {
          "kind": "element",
          "type": "array",
          "description": "Hystrix EIP configurations",
          "title": "Hystrix Configuration",
          "required": false,
          "deprecated": false
        },
        "routeBuilder": {
          "kind": "element",
          "type": "array",
          "description": "Refers to Java RouteBuilder instances to include as routes in this CamelContext.",
          "title": "Route Builder",
          "required": false,
          "deprecated": false
        },
        "routeContextRef": {
          "kind": "element",
          "type": "array",
          "description": "Refers to XML routes to include as routes in this CamelContext.",
          "title": "Route Context Ref",
          "required": false,
          "deprecated": false
        },
        "restContextRef": {
          "kind": "element",
          "type": "array",
          "description": "Refers to XML rest-dsl to include as REST services in this CamelContext.",
          "title": "Rest Context Ref",
          "required": false,
          "deprecated": false
        },
        "threadPoolProfile": {
          "kind": "element",
          "type": "array",
          "description": "Configuration of thread pool profiles.",
          "title": "Thread Pool Profile",
          "required": false,
          "deprecated": false
        },
        "threadPool": {
          "kind": "element",
          "type": "array",
          "description": "Configuration of thread pool",
          "title": "Thread Pool",
          "required": false,
          "deprecated": false
        },
        "endpoint": {
          "kind": "element",
          "type": "array",
          "description": "Configuration of endpoints",
          "title": "Endpoint",
          "required": false,
          "deprecated": false
        },
        "dataFormats": {
          "kind": "element",
          "type": "object",
          "description": "Configuration of data formats.",
          "title": "Data Formats",
          "required": false,
          "deprecated": false
        },
        "transformers": {
          "kind": "element",
          "type": "object",
          "description": "Configuration of transformers.",
          "title": "Transformers",
          "required": false,
          "deprecated": false
        },
        "validators": {
          "kind": "element",
          "type": "object",
          "description": "Configuration of validators.",
          "title": "Validators",
          "required": false,
          "deprecated": false
        },
        "redeliveryPolicyProfile": {
          "kind": "element",
          "type": "array",
          "description": "Configuration of redelivery settings.",
          "title": "Redelivery Policy Profile",
          "required": false,
          "deprecated": false
        },
        "onException": {
          "kind": "element",
          "type": "array",
          "description": "Configuration of error handlers that triggers on exceptions thrown.",
          "title": "On Exception",
          "required": false,
          "deprecated": false
        },
        "onCompletion": {
          "kind": "element",
          "type": "array",
          "description": "Configuration of sub routes to run at the completion of routing.",
          "title": "On Completion",
          "required": false,
          "deprecated": false
        },
        "intercept": {
          "kind": "element",
          "type": "array",
          "description": "Configuration of interceptors.",
          "title": "Intercept",
          "required": false,
          "deprecated": false
        },
        "interceptFrom": {
          "kind": "element",
          "type": "array",
          "description": "Configuration of interceptors that triggers from the beginning of routes.",
          "title": "Intercept From",
          "required": false,
          "deprecated": false
        },
        "interceptSendToEndpoint": {
          "kind": "element",
          "type": "array",
          "description": "Configuration of interceptors that triggers sending messages to endpoints.",
          "title": "Intercept Send To Endpoint",
          "required": false,
          "deprecated": false
        },
        "restConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configuration for rest-dsl",
          "title": "Rest Configuration",
          "required": false,
          "deprecated": false
        },
        "rest": {
          "kind": "element",
          "type": "array",
          "description": "Contains the rest services defined using the rest-dsl",
          "title": "Rest",
          "required": false,
          "deprecated": false
        },
        "route": {
          "kind": "element",
          "type": "array",
          "description": "Contains the Camel routes",
          "title": "Route",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id (name) of this CamelContext",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "choice": {
      "type": "object",
      "title": "Choice",
      "group": "eip,routing",
      "icon": "choice24.png",
      "description": "Routes messages based on a series of predicates",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "whenClauses": {
          "kind": "element",
          "type": "array",
          "description": "Sets the when clauses",
          "title": "When Clauses",
          "required": false,
          "deprecated": false
        },
        "otherwise": {
          "kind": "element",
          "type": "object",
          "description": "Sets the otherwise node",
          "title": "Otherwise",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "circuitBreaker": {
      "type": "object",
      "title": "Circuit Breaker",
      "group": "eip,routing,loadbalance,circuitbreaker",
      "icon": "generic24.png",
      "description": "Circuit break load balancer",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "exception": {
          "kind": "element",
          "type": "array",
          "description": "A list of class names for specific exceptions to monitor. If no exceptions is configured then all exceptions is monitored",
          "title": "Exception",
          "required": false,
          "deprecated": false
        },
        "halfOpenAfter": {
          "kind": "attribute",
          "type": "integer",
          "description": "The timeout in millis to use as threshold to move state from closed to half-open or open state",
          "title": "Half Open After",
          "required": false,
          "deprecated": false
        },
        "threshold": {
          "kind": "attribute",
          "type": "integer",
          "description": "Number of previous failed messages to use as threshold to move state from closed to half-open or open state",
          "title": "Threshold",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "claimCheck": {
      "type": "object",
      "title": "Claim Check",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "The Claim Check EIP allows you to replace message content with a claim check (a unique key), which can be used to retrieve the message content at a later time.",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "operation": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "Get", "GetAndRemove", "Pop", "Push", "Set" ],
          "description": "The claim check operation to use. The following operations is supported: Get - Gets (does not remove) the claim check by the given key. GetAndRemove - Gets and remove the claim check by the given key. Set - Sets a new (will override if key already exists) claim check with the given key. Push - Sets a new claim check on the stack (does not use key). Pop - Gets the latest claim check from the stack (does not use key).",
          "title": "Operation",
          "required": true,
          "deprecated": false
        },
        "key": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a specific key for claim check id.",
          "title": "Key",
          "required": false,
          "deprecated": false
        },
        "filter": {
          "kind": "attribute",
          "type": "string",
          "description": "Specified a filter to control what data gets merging data back from the claim check repository. The following syntax is supported: body - to aggregate the message body attachments - to aggregate all the message attachments headers - to aggregate all the message headers header:pattern - to aggregate all the message headers that matches the pattern. The pattern syntax is documented by: link EndpointHelpermatchPattern(String, String). You can specify multiple rules separated by comma. For example to include the message body and all headers starting with foo body,header:foo. The syntax supports the following prefixes which can be used to specify include,exclude, or remove - to include (which is the default mode) - - to exclude (exclude takes precedence over include) -- - to remove (remove takes precedence) For example to exclude a header name foo, and remove all headers starting with bar -header:foo,--headers:bar Note you cannot have both include and exclude header:pattern at the same time.",
          "title": "Filter",
          "required": false,
          "deprecated": false
        },
        "strategyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a custom AggregationStrategy instead of the default implementation. Notice you cannot use both custom aggregation strategy and configure data at the same time.",
          "title": "Strategy Ref",
          "required": false,
          "deprecated": false
        },
        "strategyMethodName": {
          "kind": "attribute",
          "type": "string",
          "description": "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Name",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "consulServiceDiscovery": {
      "type": "object",
      "title": "Consul Service Discovery",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "url": {
          "kind": "attribute",
          "type": "string",
          "description": "The Consul agent URL",
          "title": "Url",
          "required": false,
          "deprecated": false
        },
        "datacenter": {
          "kind": "attribute",
          "type": "string",
          "description": "The data center",
          "title": "Datacenter",
          "required": false,
          "deprecated": false
        },
        "aclToken": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the ACL token to be used with Consul",
          "title": "Acl Token",
          "required": false,
          "deprecated": false
        },
        "userName": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the username to be used for basic authentication",
          "title": "User Name",
          "required": false,
          "deprecated": false
        },
        "password": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the password to be used for basic authentication",
          "title": "Password",
          "required": false,
          "deprecated": false
        },
        "connectTimeoutMillis": {
          "kind": "attribute",
          "type": "integer",
          "description": "Connect timeout for OkHttpClient",
          "title": "Connect Timeout Millis",
          "required": false,
          "deprecated": false
        },
        "readTimeoutMillis": {
          "kind": "attribute",
          "type": "integer",
          "description": "Read timeout for OkHttpClient",
          "title": "Read Timeout Millis",
          "required": false,
          "deprecated": false
        },
        "writeTimeoutMillis": {
          "kind": "attribute",
          "type": "integer",
          "description": "Write timeout for OkHttpClient",
          "title": "Write Timeout Millis",
          "required": false,
          "deprecated": false
        },
        "blockSeconds": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10",
          "description": "The seconds to wait for a watch event, default 10 seconds",
          "title": "Block Seconds",
          "required": false,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "consumerTemplate": {
      "type": "object",
      "title": "Consumer Template",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Configures a ConsumerTemplate",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "maximumCacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets a custom maximum cache size to use in the backing cache pools.",
          "title": "Maximum Cache Size",
          "required": false,
          "deprecated": false
        },
        "camelContextId": {
          "kind": "attribute",
          "type": "string",
          "description": "Id of CamelContext to use if there are multiple CamelContexts in the same JVM",
          "title": "Camel Context Id",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "contextScan": {
      "type": "object",
      "title": "Context Scan",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Scans for Java org.apache.camel.builder.RouteBuilder instances in the context org.apache.camel.spi.Registry.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "includeNonSingletons": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include non-singleton beans (prototypes) By default only singleton beans is included in the context scan",
          "title": "Include Non Singletons",
          "required": false,
          "deprecated": false
        },
        "excludes": {
          "kind": "element",
          "type": "array",
          "description": "Exclude finding route builder from these java package names.",
          "title": "Excludes",
          "required": false,
          "deprecated": false
        },
        "includes": {
          "kind": "element",
          "type": "array",
          "description": "Include finding route builder from these java package names.",
          "title": "Includes",
          "required": false,
          "deprecated": false
        }
      }
    },
    "convertBodyTo": {
      "type": "object",
      "title": "Convert Body To",
      "group": "eip,transformation",
      "icon": "convertBodyTo24.png",
      "description": "Converts the message body to another type",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "The java type to convert to",
          "title": "Type",
          "required": true,
          "deprecated": false
        },
        "charset": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a specific charset when converting",
          "title": "Charset",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "customLoadBalancer": {
      "type": "object",
      "title": "Custom Load Balancer",
      "group": "eip,routing,loadbalance",
      "icon": "generic24.png",
      "description": "Custom load balancer",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to the custom load balancer to lookup from the registry",
          "title": "Ref",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "customServiceFilter": {
      "type": "object",
      "title": "Custom Service Filter",
      "group": "routing,cloud,service-filter",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference of a ServiceFilter",
          "title": "Ref",
          "required": false,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "defaultLoadBalancer": {
      "type": "object",
      "title": "Default Load Balancer",
      "group": "routing,cloud,load-balancing",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "delay": {
      "type": "object",
      "title": "Delay",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Delays processing for a specified length of time",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to define how long time to wait (in millis)",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a custom Thread Pool if asyncDelay has been enabled.",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "asyncDelayed": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Enables asynchronous delay which means the thread will noy block while delaying.",
          "title": "Async Delayed",
          "required": false,
          "deprecated": false
        },
        "callerRunsWhenRejected": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the caller should run the task when it was rejected by the thread pool. Is by default true",
          "title": "Caller Runs When Rejected",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "description": {
      "type": "object",
      "title": "Description",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "To provide comments about the node.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "lang": {
          "kind": "attribute",
          "type": "string",
          "description": "Language, such as en for english.",
          "title": "Lang",
          "required": false,
          "deprecated": false
        },
        "layoutX": {
          "kind": "attribute",
          "type": "number",
          "description": "Layout position X",
          "title": "Layout X",
          "required": false,
          "deprecated": true
        },
        "layoutY": {
          "kind": "attribute",
          "type": "number",
          "description": "Layout position Y",
          "title": "Layout Y",
          "required": false,
          "deprecated": true
        },
        "layoutWidth": {
          "kind": "attribute",
          "type": "number",
          "description": "Layout width",
          "title": "Layout Width",
          "required": false,
          "deprecated": true
        },
        "layoutHeight": {
          "kind": "attribute",
          "type": "number",
          "description": "Layout height",
          "title": "Layout Height",
          "required": false,
          "deprecated": true
        },
        "text": {
          "kind": "value",
          "type": "string",
          "description": "The description as human readable text",
          "title": "Text",
          "required": true,
          "deprecated": false
        }
      }
    },
    "dnsServiceDiscovery": {
      "type": "object",
      "title": "Dns Service Discovery",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "proto": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "_tcp",
          "description": "The transport protocol of the desired service.",
          "title": "Proto",
          "required": false,
          "deprecated": false
        },
        "domain": {
          "kind": "attribute",
          "type": "string",
          "description": "The domain name;",
          "title": "Domain",
          "required": false,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "doCatch": {
      "type": "object",
      "title": "Do Catch",
      "group": "error",
      "icon": "generic24.png",
      "description": "Catches exceptions as part of a try, catch, finally block",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "exception": {
          "kind": "element",
          "type": "array",
          "description": "The exception(s) to catch.",
          "title": "Exception",
          "required": false,
          "deprecated": false
        },
        "onWhen": {
          "kind": "element",
          "type": "object",
          "description": "Sets an additional predicate that should be true before the onCatch is triggered. To be used for fine grained controlling whether a thrown exception should be intercepted by this exception type or not.",
          "title": "On When",
          "required": false,
          "deprecated": false
        },
        "handled": {
          "kind": "expression",
          "type": "object",
          "description": "Sets whether the exchange should be marked as handled or not.",
          "title": "Handled",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "doFinally": {
      "type": "object",
      "title": "Do Finally",
      "group": "error",
      "icon": "generic24.png",
      "description": "Path traversed when a try, catch, finally block exits",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "doTry": {
      "type": "object",
      "title": "Do Try",
      "group": "error",
      "icon": "generic24.png",
      "description": "Marks the beginning of a try, catch, finally block",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "dynamicRouter": {
      "type": "object",
      "title": "Dynamic Router",
      "group": "eip,endpoint,routing",
      "icon": "dynamicRouter24.png",
      "description": "Routes messages based on dynamic rules",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to call that returns the endpoint(s) to route to in the dynamic routing. Important: The expression will be called in a while loop fashion, until the expression returns null which means the dynamic router is finished.",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "uriDelimiter": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": ",",
          "description": "Sets the uri delimiter to use",
          "title": "Uri Delimiter",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidEndpoints": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Ignore the invalidate endpoint exception when try to create a producer with that endpoint",
          "title": "Ignore Invalid Endpoints",
          "required": false,
          "deprecated": false
        },
        "cacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum size used by the org.apache.camel.impl.ProducerCache which is used to cache and reuse producers when using this dynamic router, when uris are reused.",
          "title": "Cache Size",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "endpoint": {
      "type": "object",
      "title": "Endpoint",
      "group": "spring,configuration,endpoint",
      "icon": "generic24.png",
      "description": "Camel endpoint configuration",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "singleton": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Not in use",
          "title": "Singleton",
          "required": false,
          "deprecated": true
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the URI to use to resolve the endpoint. Notice that additional options can be configured using a series of property.",
          "title": "Uri",
          "required": true,
          "deprecated": false
        },
        "pattern": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "InOnly", "InOptionalOut", "InOut", "OutIn", "OutOnly", "OutOptionalIn", "RobustInOnly", "RobustOutOnly" ],
          "description": "Sets the exchange pattern of the endpoint",
          "title": "Pattern",
          "required": false,
          "deprecated": true
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "To configure additional endpoint options using a XML style which is similar as configuring Spring or Blueprint beans.",
          "title": "Properties",
          "required": true,
          "deprecated": false
        },
        "camelContextId": {
          "kind": "attribute",
          "type": "string",
          "description": "Id of CamelContext to use if there are multiple CamelContexts in the same JVM",
          "title": "Camel Context Id",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "enrich": {
      "type": "object",
      "title": "Enrich",
      "group": "eip,transformation",
      "icon": "enrich24.png",
      "description": "Enriches a message with data from a secondary resource",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression that computes the endpoint uri to use as the resource endpoint to enrich from",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "strategyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to an AggregationStrategy to be used to merge the reply from the external service, into a single outgoing message. By default Camel will use the reply from the external service as outgoing message.",
          "title": "Strategy Ref",
          "required": false,
          "deprecated": false
        },
        "strategyMethodName": {
          "kind": "attribute",
          "type": "string",
          "description": "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Name",
          "required": false,
          "deprecated": false
        },
        "strategyMethodAllowNull": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Allow Null",
          "required": false,
          "deprecated": false
        },
        "aggregateOnException": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If this option is false then the aggregate method is not used if there was an exception thrown while trying to retrieve the data to enrich from the resource. Setting this option to true allows end users to control what to do if there was an exception in the aggregate method. For example to suppress the exception or set a custom message body etc.",
          "title": "Aggregate On Exception",
          "required": false,
          "deprecated": false
        },
        "shareUnitOfWork": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Shares the org.apache.camel.spi.UnitOfWork with the parent and the resource exchange. Enrich will by default not share unit of work between the parent exchange and the resource exchange. This means the resource exchange has its own individual unit of work.",
          "title": "Share Unit Of Work",
          "required": false,
          "deprecated": false
        },
        "cacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum size used by the org.apache.camel.impl.ProducerCache which is used to cache and reuse producer when uris are reused.",
          "title": "Cache Size",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidEndpoint": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Ignore the invalidate endpoint exception when try to create a producer with that endpoint",
          "title": "Ignore Invalid Endpoint",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "errorHandler": {
      "type": "object",
      "title": "Error Handler",
      "group": "spring,configuration,error",
      "icon": "generic24.png",
      "description": "Error handler settings",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "type": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "DefaultErrorHandler",
          "enum": [ "DeadLetterChannel", "DefaultErrorHandler", "LoggingErrorHandler", "NoErrorHandler", "TransactionErrorHandler" ],
          "description": "The type of the error handler",
          "title": "Type",
          "required": true,
          "deprecated": false
        },
        "deadLetterUri": {
          "kind": "attribute",
          "type": "string",
          "description": "The dead letter endpoint uri for the Dead Letter error handler.",
          "title": "Dead Letter Uri",
          "required": false,
          "deprecated": false
        },
        "deadLetterHandleNewException": {
          "kind": "attribute",
          "type": "string",
          "description": "Whether the dead letter channel should handle (and ignore) any new exception that may been thrown during sending the message to the dead letter endpoint. The default value is true which means any such kind of exception is handled and ignored. Set this to false to let the exception be propagated back on the org.apache.camel.Exchange. This can be used in situations where you use transactions, and want to use Camel's dead letter channel to deal with exceptions during routing, but if the dead letter channel itself fails because of a new exception being thrown, then by setting this to false the new exceptions is propagated back and set on the org.apache.camel.Exchange, which allows the transaction to detect the exception, and rollback.",
          "title": "Dead Letter Handle New Exception",
          "required": false,
          "deprecated": false
        },
        "level": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "ERROR",
          "enum": [ "DEBUG", "ERROR", "INFO", "OFF", "TRACE", "WARN" ],
          "description": "Logging level to use when using the logging error handler type.",
          "title": "Level",
          "required": false,
          "deprecated": false
        },
        "rollbackLoggingLevel": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "WARN",
          "enum": [ "DEBUG", "ERROR", "INFO", "OFF", "TRACE", "WARN" ],
          "description": "Sets the logging level to use for logging transactional rollback. This option is default WARN.",
          "title": "Rollback Logging Level",
          "required": false,
          "deprecated": false
        },
        "logName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of the logger to use for the logging error handler",
          "title": "Log Name",
          "required": false,
          "deprecated": false
        },
        "useOriginalMessage": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Will use the original input message when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current inprogress org.apache.camel.Exchange IN body we use the original IN body instead. This allows you to store the original input in the dead letter queue instead of the inprogress snapshot of the IN body. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN body is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. By default this feature is off.",
          "title": "Use Original Message",
          "required": false,
          "deprecated": false
        },
        "transactionTemplateRef": {
          "kind": "attribute",
          "type": "string",
          "description": "References to the org.springframework.transaction.support.TransactionTemplate to use with the transaction error handler.",
          "title": "Transaction Template Ref",
          "required": false,
          "deprecated": false
        },
        "transactionManagerRef": {
          "kind": "attribute",
          "type": "string",
          "description": "References to the org.springframework.transaction.PlatformTransactionManager to use with the transaction error handler.",
          "title": "Transaction Manager Ref",
          "required": false,
          "deprecated": false
        },
        "onRedeliveryRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a processor that should be processed before a redelivery attempt. Can be used to change the org.apache.camel.Exchange before its being redelivered.",
          "title": "On Redelivery Ref",
          "required": false,
          "deprecated": false
        },
        "onExceptionOccurredRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a processor that should be processed just after an exception occurred. Can be used to perform custom logging about the occurred exception at the exact time it happened. Important: Any exception thrown from this processor will be ignored.",
          "title": "On Exception Occurred Ref",
          "required": false,
          "deprecated": false
        },
        "onPrepareFailureRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a processor to prepare the org.apache.camel.Exchange before handled by the failure processor / dead letter channel. This allows for example to enrich the message before sending to a dead letter queue.",
          "title": "On Prepare Failure Ref",
          "required": false,
          "deprecated": false
        },
        "retryWhileRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to an retry while expression. Will continue retrying until expression evaluates to false.",
          "title": "Retry While Ref",
          "required": false,
          "deprecated": false
        },
        "redeliveryPolicyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a RedeliveryPolicy to be used for redelivery settings.",
          "title": "Redelivery Policy Ref",
          "required": false,
          "deprecated": false
        },
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a thread pool to be used by the error handler",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "redeliveryPolicy": {
          "kind": "element",
          "type": "object",
          "description": "Sets the redelivery settings",
          "title": "Redelivery Policy",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "etcdServiceDiscovery": {
      "type": "object",
      "title": "Etcd Service Discovery",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "uris": {
          "kind": "attribute",
          "type": "string",
          "description": "The URIs the client can connect to.",
          "title": "Uris",
          "required": false,
          "deprecated": false
        },
        "userName": {
          "kind": "attribute",
          "type": "string",
          "description": "The user name to use for basic authentication.",
          "title": "User Name",
          "required": false,
          "deprecated": false
        },
        "password": {
          "kind": "attribute",
          "type": "string",
          "description": "The password to use for basic authentication.",
          "title": "Password",
          "required": false,
          "deprecated": false
        },
        "timeout": {
          "kind": "attribute",
          "type": "integer",
          "description": "To set the maximum time an action could take to complete.",
          "title": "Timeout",
          "required": false,
          "deprecated": false
        },
        "servicePath": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "/services/",
          "description": "The path to look for for service discovery",
          "title": "Service Path",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "on-demand",
          "enum": [ "on-demand", "watch" ],
          "description": "To set the discovery type, valid values are on-demand and watch.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "export": {
      "type": "object",
      "title": "Export",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Used for export a service using Spring Remoting to hide the network call using an interface.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Camel endpoint uri to use a remote transport when calling the service",
          "title": "Uri",
          "required": true,
          "deprecated": false
        },
        "serviceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to the service name to lookup in the registry.",
          "title": "Service Ref",
          "required": false,
          "deprecated": false
        },
        "serviceInterface": {
          "kind": "attribute",
          "type": "string",
          "description": "Java interfaces to use as facade for the service to be exported",
          "title": "Service Interface",
          "required": false,
          "deprecated": false
        },
        "camelContextId": {
          "kind": "attribute",
          "type": "string",
          "description": "The id of the CamelContext to use, if there is multiple CamelContext in the same JVM.",
          "title": "Camel Context Id",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "failover": {
      "type": "object",
      "title": "Failover",
      "group": "eip,routing,loadbalance",
      "icon": "generic24.png",
      "description": "Failover load balancer",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "exception": {
          "kind": "element",
          "type": "array",
          "description": "A list of class names for specific exceptions to monitor. If no exceptions is configured then all exceptions is monitored",
          "title": "Exception",
          "required": false,
          "deprecated": false
        },
        "roundRobin": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the failover load balancer should operate in round robin mode or not. If not, then it will always start from the first endpoint when a new message is to be processed. In other words it restart from the top for every message. If round robin is enabled, then it keeps state and will continue with the next endpoint in a round robin fashion. You can also enable sticky mode together with round robin, if so then it will pick the last known good endpoint to use when starting the load balancing (instead of using the next when starting).",
          "title": "Round Robin",
          "required": false,
          "deprecated": false
        },
        "sticky": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the failover load balancer should operate in sticky mode or not. If not, then it will always start from the first endpoint when a new message is to be processed. In other words it restart from the top for every message. If sticky is enabled, then it keeps state and will continue with the last known good endpoint. You can also enable sticky mode together with round robin, if so then it will pick the last known good endpoint to use when starting the load balancing (instead of using the next when starting).",
          "title": "Sticky",
          "required": false,
          "deprecated": false
        },
        "maximumFailoverAttempts": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "-1",
          "description": "A value to indicate after X failover attempts we should exhaust (give up). Use -1 to indicate never give up and continuously try to failover. Use 0 to never failover. And use e.g. 3 to failover at most 3 times before giving up. his option can be used whether or not roundRobin is enabled or not.",
          "title": "Maximum Failover Attempts",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "filter": {
      "type": "object",
      "title": "Filter",
      "group": "eip,routing",
      "icon": "filter24.png",
      "description": "Filter out messages based using a predicate",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to determine if the message should be filtered or not. If the expression returns an empty value or false then the message is filtered (dropped), otherwise the message is continued being routed.",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "fluentTemplate": {
      "type": "object",
      "title": "Fluent Template",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Configures a org.apache.camel.FluentProducerTemplate",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "defaultEndpoint": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the default endpoint URI used by default for sending message exchanges",
          "title": "Default Endpoint",
          "required": false,
          "deprecated": false
        },
        "maximumCacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets a custom maximum cache size to use in the backing cache pools.",
          "title": "Maximum Cache Size",
          "required": false,
          "deprecated": false
        },
        "camelContextId": {
          "kind": "attribute",
          "type": "string",
          "description": "Id of CamelContext to use if there are multiple CamelContexts in the same JVM",
          "title": "Camel Context Id",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "from": {
      "type": "object",
      "title": "From",
      "group": "eip,endpoint,routing",
      "icon": "endpoint24.png",
      "description": "Act as a message source as input to a route",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the URI of the endpoint to use",
          "title": "Uri",
          "required": true,
          "deprecated": false
        },
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the name of the endpoint within the registry (such as the Spring ApplicationContext or JNDI) to use",
          "title": "Ref",
          "required": false,
          "deprecated": true
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "globalOption": {
      "type": "object",
      "title": "Global Option",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Models a string key/value pair for configuring some global options on a Camel context such as max debug log length.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "key": {
          "kind": "attribute",
          "type": "string",
          "description": "Global option key",
          "title": "Key",
          "required": true,
          "deprecated": false
        },
        "value": {
          "kind": "attribute",
          "type": "string",
          "description": "Global option value",
          "title": "Value",
          "required": true,
          "deprecated": false
        }
      }
    },
    "globalOptions": {
      "type": "object",
      "title": "Global Options",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Models a series of string key/value pairs for configuring some global options on a Camel context such as max debug log length.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "globalOption": {
          "kind": "element",
          "type": "array",
          "description": "A series of global options as key value pairs",
          "title": "Global Option",
          "required": false,
          "deprecated": false
        }
      }
    },
    "healthyServiceFilter": {
      "type": "object",
      "title": "Healthy Service Filter",
      "group": "routing,cloud,service-filter",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "hystrix": {
      "type": "object",
      "title": "Hystrix",
      "group": "eip,routing,circuitbreaker",
      "icon": "generic24.png",
      "description": "Hystrix Circuit Breaker EIP",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "hystrixConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configures the Hystrix EIP Use end when configuration is complete, to return back to the Hystrix EIP.",
          "title": "Hystrix Configuration",
          "required": false,
          "deprecated": false
        },
        "hystrixConfigurationRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a Hystrix configuration to use for configuring the Hystrix EIP.",
          "title": "Hystrix Configuration Ref",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "hystrixConfiguration": {
      "type": "object",
      "title": "Hystrix Configuration",
      "group": "eip,routing,circuitbreaker",
      "icon": "generic24.png",
      "description": "Hystrix Circuit Breaker EIP configuration",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "groupKey": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "CamelHystrix",
          "description": "Sets the group key to use. The default value is CamelHystrix.",
          "title": "Group Key",
          "required": false,
          "deprecated": false
        },
        "threadPoolKey": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "CamelHystrix",
          "description": "Sets the thread pool key to use. Will by default use the same value as groupKey has been configured to use.",
          "title": "Thread Pool Key",
          "required": false,
          "deprecated": false
        },
        "circuitBreakerEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to use a HystrixCircuitBreaker or not. If false no circuit-breaker logic will be used and all requests permitted. This is similar in effect to circuitBreakerForceClosed() except that continues tracking metrics and knowing whether it should be open/closed, this property results in not even instantiating a circuit-breaker.",
          "title": "Circuit Breaker Enabled",
          "required": false,
          "deprecated": false
        },
        "circuitBreakerErrorThresholdPercentage": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "50",
          "description": "Error percentage threshold (as whole number such as 50) at which point the circuit breaker will trip open and reject requests. It will stay tripped for the duration defined in circuitBreakerSleepWindowInMilliseconds; The error percentage this is compared against comes from HystrixCommandMetrics.getHealthCounts().",
          "title": "Circuit Breaker Error Threshold Percentage",
          "required": false,
          "deprecated": false
        },
        "circuitBreakerForceClosed": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If true the HystrixCircuitBreakerallowRequest() will always return true to allow requests regardless of the error percentage from HystrixCommandMetrics.getHealthCounts(). The circuitBreakerForceOpen() property takes precedence so if it set to true this property does nothing.",
          "title": "Circuit Breaker Force Closed",
          "required": false,
          "deprecated": false
        },
        "circuitBreakerForceOpen": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If true the HystrixCircuitBreaker.allowRequest() will always return false, causing the circuit to be open (tripped) and reject all requests. This property takes precedence over circuitBreakerForceClosed();",
          "title": "Circuit Breaker Force Open",
          "required": false,
          "deprecated": false
        },
        "circuitBreakerRequestVolumeThreshold": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "20",
          "description": "Minimum number of requests in the metricsRollingStatisticalWindowInMilliseconds() that must exist before the HystrixCircuitBreaker will trip. If below this number the circuit will not trip regardless of error percentage.",
          "title": "Circuit Breaker Request Volume Threshold",
          "required": false,
          "deprecated": false
        },
        "circuitBreakerSleepWindowInMilliseconds": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "5000",
          "description": "The time in milliseconds after a HystrixCircuitBreaker trips open that it should wait before trying requests again.",
          "title": "Circuit Breaker Sleep Window In Milliseconds",
          "required": false,
          "deprecated": false
        },
        "executionIsolationSemaphoreMaxConcurrentRequests": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "20",
          "description": "Number of concurrent requests permitted to HystrixCommand.run(). Requests beyond the concurrent limit will be rejected. Applicable only when executionIsolationStrategy == SEMAPHORE.",
          "title": "Execution Isolation Semaphore Max Concurrent Requests",
          "required": false,
          "deprecated": false
        },
        "executionIsolationStrategy": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "THREAD",
          "enum": [ "SEMAPHORE", "THREAD" ],
          "description": "What isolation strategy HystrixCommand.run() will be executed with. If THREAD then it will be executed on a separate thread and concurrent requests limited by the number of threads in the thread-pool. If SEMAPHORE then it will be executed on the calling thread and concurrent requests limited by the semaphore count.",
          "title": "Execution Isolation Strategy",
          "required": false,
          "deprecated": false
        },
        "executionIsolationThreadInterruptOnTimeout": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether the execution thread should attempt an interrupt (using link Futurecancel) when a thread times out. Applicable only when executionIsolationStrategy() == THREAD.",
          "title": "Execution Isolation Thread Interrupt On Timeout",
          "required": false,
          "deprecated": false
        },
        "executionTimeoutInMilliseconds": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "1000",
          "description": "Time in milliseconds at which point the command will timeout and halt execution. If link executionIsolationThreadInterruptOnTimeout == true and the command is thread-isolated, the executing thread will be interrupted. If the command is semaphore-isolated and a HystrixObservableCommand, that command will get unsubscribed.",
          "title": "Execution Timeout In Milliseconds",
          "required": false,
          "deprecated": false
        },
        "executionTimeoutEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether the timeout mechanism is enabled for this command",
          "title": "Execution Timeout Enabled",
          "required": false,
          "deprecated": false
        },
        "fallbackIsolationSemaphoreMaxConcurrentRequests": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10",
          "description": "Number of concurrent requests permitted to HystrixCommand.getFallback(). Requests beyond the concurrent limit will fail-fast and not attempt retrieving a fallback.",
          "title": "Fallback Isolation Semaphore Max Concurrent Requests",
          "required": false,
          "deprecated": false
        },
        "fallbackEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether HystrixCommand.getFallback() should be attempted when failure occurs.",
          "title": "Fallback Enabled",
          "required": false,
          "deprecated": false
        },
        "metricsHealthSnapshotIntervalInMilliseconds": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "500",
          "description": "Time in milliseconds to wait between allowing health snapshots to be taken that calculate success and error percentages and affect HystrixCircuitBreaker.isOpen() status. On high-volume circuits the continual calculation of error percentage can become CPU intensive thus this controls how often it is calculated.",
          "title": "Metrics Health Snapshot Interval In Milliseconds",
          "required": false,
          "deprecated": false
        },
        "metricsRollingPercentileBucketSize": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10",
          "description": "Maximum number of values stored in each bucket of the rolling percentile. This is passed into HystrixRollingPercentile inside HystrixCommandMetrics.",
          "title": "Metrics Rolling Percentile Bucket Size",
          "required": false,
          "deprecated": false
        },
        "metricsRollingPercentileEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether percentile metrics should be captured using HystrixRollingPercentile inside HystrixCommandMetrics.",
          "title": "Metrics Rolling Percentile Enabled",
          "required": false,
          "deprecated": false
        },
        "metricsRollingPercentileWindowInMilliseconds": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10000",
          "description": "Duration of percentile rolling window in milliseconds. This is passed into HystrixRollingPercentile inside HystrixCommandMetrics.",
          "title": "Metrics Rolling Percentile Window In Milliseconds",
          "required": false,
          "deprecated": false
        },
        "metricsRollingPercentileWindowBuckets": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "6",
          "description": "Number of buckets the rolling percentile window is broken into. This is passed into HystrixRollingPercentile inside HystrixCommandMetrics.",
          "title": "Metrics Rolling Percentile Window Buckets",
          "required": false,
          "deprecated": false
        },
        "metricsRollingStatisticalWindowInMilliseconds": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10000",
          "description": "This property sets the duration of the statistical rolling window, in milliseconds. This is how long metrics are kept for the thread pool. The window is divided into buckets and rolls by those increments.",
          "title": "Metrics Rolling Statistical Window In Milliseconds",
          "required": false,
          "deprecated": false
        },
        "metricsRollingStatisticalWindowBuckets": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10",
          "description": "Number of buckets the rolling statistical window is broken into. This is passed into HystrixRollingNumber inside HystrixCommandMetrics.",
          "title": "Metrics Rolling Statistical Window Buckets",
          "required": false,
          "deprecated": false
        },
        "requestLogEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether HystrixCommand execution and events should be logged to HystrixRequestLog.",
          "title": "Request Log Enabled",
          "required": false,
          "deprecated": false
        },
        "corePoolSize": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10",
          "description": "Core thread-pool size that gets passed to link java.util.concurrent.ThreadPoolExecutorsetCorePoolSize(int)",
          "title": "Core Pool Size",
          "required": false,
          "deprecated": false
        },
        "maximumSize": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10",
          "description": "Maximum thread-pool size that gets passed to link ThreadPoolExecutorsetMaximumPoolSize(int). This is the maximum amount of concurrency that can be supported without starting to reject HystrixCommands. Please note that this setting only takes effect if you also set allowMaximumSizeToDivergeFromCoreSize",
          "title": "Maximum Size",
          "required": false,
          "deprecated": false
        },
        "keepAliveTime": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "1",
          "description": "Keep-alive time in minutes that gets passed to link ThreadPoolExecutorsetKeepAliveTime(long, TimeUnit)",
          "title": "Keep Alive Time",
          "required": false,
          "deprecated": false
        },
        "maxQueueSize": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "-1",
          "description": "Max queue size that gets passed to BlockingQueue in HystrixConcurrencyStrategy.getBlockingQueue(int) This should only affect the instantiation of a threadpool - it is not eliglible to change a queue size on the fly. For that, use queueSizeRejectionThreshold().",
          "title": "Max Queue Size",
          "required": false,
          "deprecated": false
        },
        "queueSizeRejectionThreshold": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "5",
          "description": "Queue size rejection threshold is an artificial max size at which rejections will occur even if link maxQueueSize has not been reached. This is done because the link maxQueueSize of a BlockingQueue can not be dynamically changed and we want to support dynamically changing the queue size that affects rejections. This is used by HystrixCommand when queuing a thread for execution.",
          "title": "Queue Size Rejection Threshold",
          "required": false,
          "deprecated": false
        },
        "threadPoolRollingNumberStatisticalWindowInMilliseconds": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10000",
          "description": "Duration of statistical rolling window in milliseconds. This is passed into HystrixRollingNumber inside each HystrixThreadPoolMetrics instance.",
          "title": "Thread Pool Rolling Number Statistical Window In Milliseconds",
          "required": false,
          "deprecated": false
        },
        "threadPoolRollingNumberStatisticalWindowBuckets": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "10",
          "description": "Number of buckets the rolling statistical window is broken into. This is passed into HystrixRollingNumber inside each HystrixThreadPoolMetrics instance.",
          "title": "Thread Pool Rolling Number Statistical Window Buckets",
          "required": false,
          "deprecated": false
        },
        "allowMaximumSizeToDivergeFromCoreSize": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Allows the configuration for maximumSize to take effect. That value can then be equal to, or higher, than coreSize",
          "title": "Allow Maximum Size To Diverge From Core Size",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "idempotentConsumer": {
      "type": "object",
      "title": "Idempotent Consumer",
      "group": "eip,routing",
      "icon": "idempotentConsumer24.png",
      "description": "Filters out duplicate messages",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression used to calculate the correlation key to use for duplicate check. The Exchange which has the same correlation key is regarded as a duplicate and will be rejected.",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "messageIdRepositoryRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the reference name of the message id repository",
          "title": "Message Id Repository Ref",
          "required": true,
          "deprecated": false
        },
        "eager": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Sets whether to eagerly add the key to the idempotent repository or wait until the exchange is complete. Eager is default enabled.",
          "title": "Eager",
          "required": false,
          "deprecated": false
        },
        "completionEager": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Sets whether to complete the idempotent consumer eager or when the exchange is done. If this option is true to complete eager, then the idempotent consumer will trigger its completion when the exchange reached the end of the block of the idempotent consumer pattern. So if the exchange is continued routed after the block ends, then whatever happens there does not affect the state. If this option is false (default) to not complete eager, then the idempotent consumer will complete when the exchange is done being routed. So if the exchange is continued routed after the block ends, then whatever happens there also affect the state. For example if the exchange failed due to an exception, then the state of the idempotent consumer will be a rollback.",
          "title": "Completion Eager",
          "required": false,
          "deprecated": false
        },
        "skipDuplicate": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Sets whether to skip duplicates or not. The default behavior is to skip duplicates. A duplicate message would have the Exchange property link org.apache.camel.ExchangeDUPLICATE_MESSAGE set to a link BooleanTRUE value. A none duplicate message will not have this property set.",
          "title": "Skip Duplicate",
          "required": false,
          "deprecated": false
        },
        "removeOnFailure": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Sets whether to remove or keep the key on failure. The default behavior is to remove the key on failure.",
          "title": "Remove On Failure",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "inOnly": {
      "type": "object",
      "title": "In Only",
      "group": "eip,endpoint,routing",
      "icon": "eventMessage24.png",
      "description": "Marks the exchange pattern for the route to one way",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the uri of the endpoint to send to.",
          "title": "Uri",
          "required": true,
          "deprecated": false
        },
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the reference of the endpoint to send to.",
          "title": "Ref",
          "required": false,
          "deprecated": true
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "inOut": {
      "type": "object",
      "title": "In Out",
      "group": "eip,endpoint,routing",
      "icon": "requestReply24.png",
      "description": "Marks the exchange pattern for the route to request/reply",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the uri of the endpoint to send to.",
          "title": "Uri",
          "required": true,
          "deprecated": false
        },
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the reference of the endpoint to send to.",
          "title": "Ref",
          "required": false,
          "deprecated": true
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "inputType": {
      "type": "object",
      "title": "Input Type",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Set the expected data type of the input message. If the actual message type is different at runtime, camel look for a required Transformer and apply if exists. If validate attribute is true then camel applies Validator as well.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "urn": {
          "kind": "attribute",
          "type": "string",
          "description": "Set input type URN.",
          "title": "Urn",
          "required": true,
          "deprecated": false
        },
        "validate": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Set if validation is required for this input type.",
          "title": "Validate",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "intercept": {
      "type": "object",
      "title": "Intercept",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Intercepts a message at each step in the route",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "interceptFrom": {
      "type": "object",
      "title": "Intercept From",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Intercepts incoming messages",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Intercept incoming messages from the uri or uri pattern. If this option is not configured, then all incoming messages is intercepted.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "interceptSendToEndpoint": {
      "type": "object",
      "title": "Intercept Send To Endpoint",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Intercepts messages being sent to an endpoint",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Intercept sending to the uri or uri pattern.",
          "title": "Uri",
          "required": true,
          "deprecated": false
        },
        "skipSendToOriginalEndpoint": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If set to true then the message is not sent to the original endpoint. By default (false) the message is both intercepted and then sent to the original endpoint.",
          "title": "Skip Send To Original Endpoint",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "jmxAgent": {
      "type": "object",
      "title": "Jmx Agent",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "JMX configuration.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "disabled": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Disable JMI (default false)",
          "title": "Disabled",
          "required": false,
          "deprecated": false
        },
        "onlyRegisterProcessorWithCustomId": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Only register processor if a custom id was defined for it.",
          "title": "Only Register Processor With Custom Id",
          "required": false,
          "deprecated": false
        },
        "registryPort": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "1099",
          "description": "RMI connector registry port (default 1099)",
          "title": "Registry Port",
          "required": false,
          "deprecated": false
        },
        "connectorPort": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "-1",
          "description": "RMI connector server port (default -1 not used)",
          "title": "Connector Port",
          "required": false,
          "deprecated": false
        },
        "mbeanServerDefaultDomain": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "org.apache.camel",
          "description": "MBean server default domain name (default org.apache.camel)",
          "title": "Mbean Server Default Domain",
          "required": false,
          "deprecated": false
        },
        "mbeanObjectDomainName": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "org.apache.camel",
          "description": "MBean object domain name (default org.apache.camel)",
          "title": "Mbean Object Domain Name",
          "required": false,
          "deprecated": false
        },
        "serviceUrlPath": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "/jmxrmi",
          "description": "JMX Service URL path (default /jmxrmi)",
          "title": "Service Url Path",
          "required": false,
          "deprecated": false
        },
        "createConnector": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "A flag that indicates whether the agent should be created",
          "title": "Create Connector",
          "required": false,
          "deprecated": false
        },
        "usePlatformMBeanServer": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "A flag that indicates whether the platform mbean server should be used",
          "title": "Use Platform M Bean Server",
          "required": false,
          "deprecated": false
        },
        "registerAlways": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "A flag that indicates whether to register mbeans always",
          "title": "Register Always",
          "required": false,
          "deprecated": false
        },
        "registerNewRoutes": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "A flag that indicates whether to register mbeans when starting new routes",
          "title": "Register New Routes",
          "required": false,
          "deprecated": false
        },
        "statisticsLevel": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "Default",
          "description": "Level of granularity for performance statistics enabled",
          "title": "Statistics Level",
          "required": false,
          "deprecated": false
        },
        "loadStatisticsEnabled": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "A flag that indicates whether Load statistics is enabled",
          "title": "Load Statistics Enabled",
          "required": false,
          "deprecated": false
        },
        "endpointRuntimeStatisticsEnabled": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "A flag that indicates whether endpoint runtime statistics is enabled",
          "title": "Endpoint Runtime Statistics Enabled",
          "required": false,
          "deprecated": false
        },
        "includeHostName": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "A flag that indicates whether to include hostname in JMX MBean names.",
          "title": "Include Host Name",
          "required": false,
          "deprecated": false
        },
        "useHostIPAddress": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "A flag that indicates whether to use hostname or IP Address in the service url.",
          "title": "Use Host I P Address",
          "required": false,
          "deprecated": false
        },
        "mask": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "A flag that indicates whether to remove detected sensitive information (such as passwords) from MBean names and attributes.",
          "title": "Mask",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "kubernetesServiceDiscovery": {
      "type": "object",
      "title": "Kubernetes Service Discovery",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "lookup": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "environment",
          "enum": [ "client", "dns", "environment" ],
          "description": "How to perform service lookup. Possible values: client, dns, environment. When using client, then the client queries the kubernetes master to obtain a list of active pods that provides the service, and then random (or round robin) select a pod. When using dns the service name is resolved as name.namespace.service.dnsDomain. When using environment then environment variables are used to lookup the service. By default environment is used.",
          "title": "Lookup",
          "required": false,
          "deprecated": false
        },
        "dnsDomain": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the DNS domain to use for DNS lookup.",
          "title": "Dns Domain",
          "required": false,
          "deprecated": false
        },
        "namespace": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the namespace to use. Will by default use namespace from the ENV variable KUBERNETES_MASTER.",
          "title": "Namespace",
          "required": false,
          "deprecated": false
        },
        "apiVersion": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the API version when using client lookup",
          "title": "Api Version",
          "required": false,
          "deprecated": false
        },
        "masterUrl": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the URL to the master when using client lookup",
          "title": "Master Url",
          "required": false,
          "deprecated": false
        },
        "username": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the username for authentication when using client lookup",
          "title": "Username",
          "required": false,
          "deprecated": false
        },
        "password": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the password for authentication when using client lookup",
          "title": "Password",
          "required": false,
          "deprecated": false
        },
        "oauthToken": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the OAUTH token for authentication (instead of username/password) when using client lookup",
          "title": "Oauth Token",
          "required": false,
          "deprecated": false
        },
        "caCertData": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Certificate Authority data when using client lookup",
          "title": "Ca Cert Data",
          "required": false,
          "deprecated": false
        },
        "caCertFile": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Certificate Authority data that are loaded from the file when using client lookup",
          "title": "Ca Cert File",
          "required": false,
          "deprecated": false
        },
        "clientCertData": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Client Certificate data when using client lookup",
          "title": "Client Cert Data",
          "required": false,
          "deprecated": false
        },
        "clientCertFile": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Client Certificate data that are loaded from the file when using client lookup",
          "title": "Client Cert File",
          "required": false,
          "deprecated": false
        },
        "clientKeyAlgo": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Client Keystore algorithm, such as RSA when using client lookup",
          "title": "Client Key Algo",
          "required": false,
          "deprecated": false
        },
        "clientKeyData": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Client Keystore data when using client lookup",
          "title": "Client Key Data",
          "required": false,
          "deprecated": false
        },
        "clientKeyFile": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Client Keystore data that are loaded from the file when using client lookup",
          "title": "Client Key File",
          "required": false,
          "deprecated": false
        },
        "clientKeyPassphrase": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Client Keystore passphrase when using client lookup",
          "title": "Client Key Passphrase",
          "required": false,
          "deprecated": false
        },
        "trustCerts": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Sets whether to turn on trust certificate check when using client lookup",
          "title": "Trust Certs",
          "required": false,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "loadBalance": {
      "type": "object",
      "title": "Load Balance",
      "group": "eip,routing",
      "icon": "loadBalance24.png",
      "description": "Balances message processing among a number of nodes",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "loadBalancerType": {
          "kind": "element",
          "type": "object",
          "description": "The load balancer to be used",
          "title": "Load Balancer Type",
          "required": true,
          "deprecated": false
        },
        "inheritErrorHandler": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Sets whether or not to inherit the configured error handler. The default value is true. You can use this to disable using the inherited error handler for a given DSL such as a load balancer where you want to use a custom error handler strategy.",
          "title": "Inherit Error Handler",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "loadBalancerConfiguration": {
      "type": "object",
      "title": "Load Balancer Configuration",
      "group": "routing,cloud,load-balancing",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "log": {
      "type": "object",
      "title": "Log",
      "group": "eip,configuration",
      "icon": "log24.png",
      "description": "Logs the defined message to the logger",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "message": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the log message (uses simple language)",
          "title": "Message",
          "required": true,
          "deprecated": false
        },
        "loggingLevel": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "INFO",
          "enum": [ "DEBUG", "ERROR", "INFO", "OFF", "TRACE", "WARN" ],
          "description": "Sets the logging level. The default value is INFO",
          "title": "Logging Level",
          "required": false,
          "deprecated": false
        },
        "logName": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the name of the logger",
          "title": "Log Name",
          "required": false,
          "deprecated": false
        },
        "marker": {
          "kind": "attribute",
          "type": "string",
          "description": "To use slf4j marker",
          "title": "Marker",
          "required": false,
          "deprecated": false
        },
        "loggerRef": {
          "kind": "attribute",
          "type": "string",
          "description": "To refer to a custom logger instance to lookup from the registry.",
          "title": "Logger Ref",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "loop": {
      "type": "object",
      "title": "Loop",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Processes a message multiple times",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to define how many times we should loop. Notice the expression is only evaluated once, and should return a number as how many times to loop. A value of zero or negative means no looping. The loop is like a for-loop fashion, if you want a while loop, then the dynamic router may be a better choice.",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "copy": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the copy attribute is true, a copy of the input Exchange is used for each iteration. That means each iteration will start from a copy of the same message. By default loop will loop the same exchange all over, so each iteration may have different message content.",
          "title": "Copy",
          "required": false,
          "deprecated": false
        },
        "doWhile": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Enables the while loop that loops until the predicate evaluates to false or null.",
          "title": "Do While",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "marshal": {
      "type": "object",
      "title": "Marshal",
      "group": "eip,transformation",
      "icon": "marshal24.png",
      "description": "Marshals data into a specified format for transmission over a transport or component",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "dataFormatType": {
          "kind": "element",
          "type": "object",
          "description": "The data format to be used",
          "title": "Data Format Type",
          "required": true,
          "deprecated": false
        },
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "To refer to a custom data format to use as marshaller",
          "title": "Ref",
          "required": false,
          "deprecated": true
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "multiServiceDiscovery": {
      "type": "object",
      "title": "Multi Service Discovery",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "serviceDiscoveryConfigurations": {
          "kind": "element",
          "type": "array",
          "description": "List of ServiceDiscovery configuration to use",
          "title": "Service Discovery Configurations",
          "required": true,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "multiServiceFilter": {
      "type": "object",
      "title": "Multi Service Filter",
      "group": "routing,cloud,service-filter",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "serviceFilterConfigurations": {
          "kind": "element",
          "type": "array",
          "description": "List of ServiceFilter configuration to use",
          "title": "Service Filter Configurations",
          "required": true,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "multicast": {
      "type": "object",
      "title": "Multicast",
      "group": "eip,routing",
      "icon": "multicast24.png",
      "description": "Routes the same message to multiple paths either sequentially or in parallel.",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "parallelProcessing": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then sending messages to the multicasts occurs concurrently. Note the caller thread will still wait until all messages has been fully processed, before it continues. Its only the sending and processing the replies from the multicasts which happens concurrently.",
          "title": "Parallel Processing",
          "required": false,
          "deprecated": false
        },
        "strategyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to an AggregationStrategy to be used to assemble the replies from the multicasts, into a single outgoing message from the Multicast. By default Camel will use the last reply as the outgoing message. You can also use a POJO as the AggregationStrategy",
          "title": "Strategy Ref",
          "required": false,
          "deprecated": false
        },
        "strategyMethodName": {
          "kind": "attribute",
          "type": "string",
          "description": "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Name",
          "required": false,
          "deprecated": false
        },
        "strategyMethodAllowNull": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy",
          "title": "Strategy Method Allow Null",
          "required": false,
          "deprecated": false
        },
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a custom Thread Pool to be used for parallel processing. Notice if you set this option, then parallel processing is automatic implied, and you do not have to enable that option as well.",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "streaming": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then Camel will process replies out-of-order, eg in the order they come back. If disabled, Camel will process replies in the same order as defined by the multicast.",
          "title": "Streaming",
          "required": false,
          "deprecated": false
        },
        "stopOnException": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Will now stop further processing if an exception or failure occurred during processing of an org.apache.camel.Exchange and the caused exception will be thrown. Will also stop if processing the exchange failed (has a fault message) or an exception was thrown and handled by the error handler (such as using onException). In all situations the multicast will stop further processing. This is the same behavior as in pipeline, which is used by the routing engine. The default behavior is to not stop but continue processing till the end",
          "title": "Stop On Exception",
          "required": false,
          "deprecated": false
        },
        "timeout": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "0",
          "description": "Sets a total timeout specified in millis, when using parallel processing. If the Multicast hasn't been able to send and process all replies within the given timeframe, then the timeout triggers and the Multicast breaks out and continues. Notice if you provide a TimeoutAwareAggregationStrategy then the timeout method is invoked before breaking out. If the timeout is reached with running tasks still remaining, certain tasks for which it is difficult for Camel to shut down in a graceful manner may continue to run. So use this option with a bit of care.",
          "title": "Timeout",
          "required": false,
          "deprecated": false
        },
        "onPrepareRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Uses the Processor when preparing the org.apache.camel.Exchange to be send. This can be used to deep-clone messages that should be send, or any custom logic needed before the exchange is send.",
          "title": "On Prepare Ref",
          "required": false,
          "deprecated": false
        },
        "shareUnitOfWork": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Shares the org.apache.camel.spi.UnitOfWork with the parent and each of the sub messages. Multicast will by default not share unit of work between the parent exchange and each multicasted exchange. This means each sub exchange has its own individual unit of work.",
          "title": "Share Unit Of Work",
          "required": false,
          "deprecated": false
        },
        "parallelAggregate": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then the aggregate method on AggregationStrategy can be called concurrently. Notice that this would require the implementation of AggregationStrategy to be implemented as thread-safe. By default this is false meaning that Camel synchronizes the call to the aggregate method. Though in some use-cases this can be used to archive higher performance when the AggregationStrategy is implemented as thread-safe.",
          "title": "Parallel Aggregate",
          "required": false,
          "deprecated": false
        },
        "stopOnAggregateException": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled, unwind exceptions occurring at aggregation time to the error handler when parallelProcessing is used. Currently, aggregation time exceptions do not stop the route processing when parallelProcessing is used. Enabling this option allows to work around this behavior. The default value is false for the sake of backward compatibility.",
          "title": "Stop On Aggregate Exception",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "onCompletion": {
      "type": "object",
      "title": "On Completion",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Route to be executed when normal route processing completes",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "mode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "AfterConsumer",
          "enum": [ "AfterConsumer", "BeforeConsumer" ],
          "description": "Sets the on completion mode. The default value is AfterConsumer",
          "title": "Mode",
          "required": false,
          "deprecated": false
        },
        "onCompleteOnly": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Will only synchronize when the org.apache.camel.Exchange completed successfully (no errors).",
          "title": "On Complete Only",
          "required": false,
          "deprecated": false
        },
        "onFailureOnly": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Will only synchronize when the org.apache.camel.Exchange ended with failure (exception or FAULT message).",
          "title": "On Failure Only",
          "required": false,
          "deprecated": false
        },
        "onWhen": {
          "kind": "element",
          "type": "object",
          "description": "Sets an additional predicate that should be true before the onCompletion is triggered. To be used for fine grained controlling whether a completion callback should be invoked or not",
          "title": "On When",
          "required": false,
          "deprecated": false
        },
        "parallelProcessing": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then the on completion process will run asynchronously by a separate thread from a thread pool. By default this is false, meaning the on completion process will run synchronously using the same caller thread as from the route.",
          "title": "Parallel Processing",
          "required": false,
          "deprecated": false
        },
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a custom Thread Pool to be used for parallel processing. Notice if you set this option, then parallel processing is automatic implied, and you do not have to enable that option as well.",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "useOriginalMessage": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Will use the original input body when an org.apache.camel.Exchange for this on completion. By default this feature is off.",
          "title": "Use Original Message",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "onException": {
      "type": "object",
      "title": "On Exception",
      "group": "error",
      "icon": "generic24.png",
      "description": "Route to be executed when an exception is thrown",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "exception": {
          "kind": "element",
          "type": "array",
          "description": "A set of exceptions to react upon.",
          "title": "Exception",
          "required": true,
          "deprecated": false
        },
        "onWhen": {
          "kind": "element",
          "type": "object",
          "description": "Sets an additional predicate that should be true before the onException is triggered. To be used for fine grained controlling whether a thrown exception should be intercepted by this exception type or not.",
          "title": "On When",
          "required": false,
          "deprecated": false
        },
        "retryWhile": {
          "kind": "expression",
          "type": "object",
          "description": "Sets the retry while predicate. Will continue retrying until predicate returns false.",
          "title": "Retry While",
          "required": false,
          "deprecated": false
        },
        "redeliveryPolicy": {
          "kind": "element",
          "type": "object",
          "description": "Set the RedeliveryPolicy to be used.",
          "title": "Redelivery Policy",
          "required": false,
          "deprecated": false
        },
        "redeliveryPolicyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a RedeliveryPolicy to lookup in the org.apache.camel.spi.Registry to be used.",
          "title": "Redelivery Policy Ref",
          "required": false,
          "deprecated": false
        },
        "handled": {
          "kind": "expression",
          "type": "object",
          "description": "Sets whether the exchange should be marked as handled or not.",
          "title": "Handled",
          "required": false,
          "deprecated": false
        },
        "continued": {
          "kind": "expression",
          "type": "object",
          "description": "Sets whether the exchange should handle and continue routing from the point of failure. If this option is enabled then its considered handled as well.",
          "title": "Continued",
          "required": false,
          "deprecated": false
        },
        "onRedeliveryRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a processor that should be processed before a redelivery attempt. Can be used to change the org.apache.camel.Exchange before its being redelivered.",
          "title": "On Redelivery Ref",
          "required": false,
          "deprecated": false
        },
        "onExceptionOccurredRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a processor that should be processed just after an exception occurred. Can be used to perform custom logging about the occurred exception at the exact time it happened. Important: Any exception thrown from this processor will be ignored.",
          "title": "On Exception Occurred Ref",
          "required": false,
          "deprecated": false
        },
        "useOriginalMessage": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Will use the original input message when an org.apache.camel.Exchange is moved to the dead letter queue. Notice: this only applies when all redeliveries attempt have failed and the org.apache.camel.Exchange is doomed for failure. Instead of using the current in-progress org.apache.camel.Exchange IN body we use the original IN body instead. This allows you to store the original input in the dead letter queue instead of the in-progress snapshot of the IN body. For instance if you route transform the IN body during routing and then failed. With the original exchange store in the dead letter queue it might be easier to manually re submit the org.apache.camel.Exchange again as the IN body is the same as when Camel received it. So you should be able to send the org.apache.camel.Exchange to the same input. By default this feature is off.",
          "title": "Use Original Message",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "onFallback": {
      "type": "object",
      "title": "On Fallback",
      "group": "eip,routing,circuitbreaker",
      "icon": "generic24.png",
      "description": "Route to be executed when Hystrix EIP executes fallback",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "fallbackViaNetwork": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the fallback goes over the network. If the fallback will go over the network it is another possible point of failure and so it also needs to be wrapped by a HystrixCommand. It is important to execute the fallback command on a separate thread-pool, otherwise if the main command were to become latent and fill the thread-pool this would prevent the fallback from running if the two commands share the same pool.",
          "title": "Fallback Via Network",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "optimisticLockRetryPolicy": {
      "type": "object",
      "title": "Optimistic Lock Retry Policy",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "To configure optimistic locking",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "maximumRetries": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum number of retries",
          "title": "Maximum Retries",
          "required": false,
          "deprecated": false
        },
        "retryDelay": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "50",
          "description": "Sets the delay in millis between retries",
          "title": "Retry Delay",
          "required": false,
          "deprecated": false
        },
        "maximumRetryDelay": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "1000",
          "description": "Sets the upper value of retry in millis between retries, when using exponential or random backoff",
          "title": "Maximum Retry Delay",
          "required": false,
          "deprecated": false
        },
        "exponentialBackOff": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Enable exponential backoff",
          "title": "Exponential Back Off",
          "required": false,
          "deprecated": false
        },
        "randomBackOff": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Enables random backoff",
          "title": "Random Back Off",
          "required": false,
          "deprecated": false
        }
      }
    },
    "otherwise": {
      "type": "object",
      "title": "Otherwise",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Route to be executed when all other choices evaluate to false",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "outputType": {
      "type": "object",
      "title": "Output Type",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Set the expected data type of the output message. If the actual message type is different at runtime, camel look for a required Transformer and apply if exists. If validate attribute is true then camel applies Validator as well.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "urn": {
          "kind": "attribute",
          "type": "string",
          "description": "Set output type URN.",
          "title": "Urn",
          "required": true,
          "deprecated": false
        },
        "validate": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Set if validation is required for this output type.",
          "title": "Validate",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "packageScan": {
      "type": "object",
      "title": "Package Scan",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Scans for Java org.apache.camel.builder.RouteBuilder classes in java packages",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "package": {
          "kind": "element",
          "type": "array",
          "description": "Sets the java package names to use for scanning for route builder classes",
          "title": "Package",
          "required": true,
          "deprecated": false
        },
        "excludes": {
          "kind": "element",
          "type": "array",
          "description": "Exclude finding route builder from these java package names.",
          "title": "Excludes",
          "required": false,
          "deprecated": false
        },
        "includes": {
          "kind": "element",
          "type": "array",
          "description": "Include finding route builder from these java package names.",
          "title": "Includes",
          "required": false,
          "deprecated": false
        }
      }
    },
    "passThroughServiceFilter": {
      "type": "object",
      "title": "Pass Through Service Filter",
      "group": "routing,cloud,service-filter",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "pipeline": {
      "type": "object",
      "title": "Pipeline",
      "group": "eip,routing",
      "icon": "pipeline24.png",
      "description": "Routes the message to a sequence of processors.",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "policy": {
      "type": "object",
      "title": "Policy",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Defines a policy the route will use",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to use for lookup the policy in the registry.",
          "title": "Ref",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "pollEnrich": {
      "type": "object",
      "title": "Poll Enrich",
      "group": "eip,transformation",
      "icon": "pollEnrich24.png",
      "description": "Enriches messages with data polled from a secondary resource",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression that computes the endpoint uri to use as the resource endpoint to enrich from",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "timeout": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "-1",
          "description": "Timeout in millis when polling from the external service. The timeout has influence about the poll enrich behavior. It basically operations in three different modes: negative value - Waits until a message is available and then returns it. Warning that this method could block indefinitely if no messages are available. 0 - Attempts to receive a message exchange immediately without waiting and returning null if a message exchange is not available yet. positive value - Attempts to receive a message exchange, waiting up to the given timeout to expire if a message is not yet available. Returns null if timed out The default value is -1 and therefore the method could block indefinitely, and therefore its recommended to use a timeout value",
          "title": "Timeout",
          "required": false,
          "deprecated": false
        },
        "strategyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to an AggregationStrategy to be used to merge the reply from the external service, into a single outgoing message. By default Camel will use the reply from the external service as outgoing message.",
          "title": "Strategy Ref",
          "required": false,
          "deprecated": false
        },
        "strategyMethodName": {
          "kind": "attribute",
          "type": "string",
          "description": "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Name",
          "required": false,
          "deprecated": false
        },
        "strategyMethodAllowNull": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Allow Null",
          "required": false,
          "deprecated": false
        },
        "aggregateOnException": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If this option is false then the aggregate method is not used if there was an exception thrown while trying to retrieve the data to enrich from the resource. Setting this option to true allows end users to control what to do if there was an exception in the aggregate method. For example to suppress the exception or set a custom message body etc.",
          "title": "Aggregate On Exception",
          "required": false,
          "deprecated": false
        },
        "cacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum size used by the org.apache.camel.impl.ConsumerCache which is used to cache and reuse consumers when uris are reused.",
          "title": "Cache Size",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidEndpoint": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Ignore the invalidate endpoint exception when try to create a producer with that endpoint",
          "title": "Ignore Invalid Endpoint",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "process": {
      "type": "object",
      "title": "Process",
      "group": "eip,endpoint",
      "icon": "process24.png",
      "description": "Calls a Camel processor",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to the Processor to lookup in the registry to use.",
          "title": "Ref",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "properties": {
      "type": "object",
      "title": "Properties",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "A series of key value pair",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "property": {
          "kind": "element",
          "type": "array",
          "description": "A series of properties as key value pairs",
          "title": "Property",
          "required": false,
          "deprecated": false
        }
      }
    },
    "propertiesFunction": {
      "type": "object",
      "title": "Properties Function",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Function to use with properties placeholder",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to the custom properties function to lookup in the registry",
          "title": "Ref",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "propertiesLocation": {
      "type": "object",
      "title": "Properties Location",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Properties to use with properties placeholder",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "resolver": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "classpath",
          "description": "The resolver to use to locate the location",
          "title": "Resolver",
          "required": false,
          "deprecated": false
        },
        "path": {
          "kind": "attribute",
          "type": "string",
          "description": "Property locations to use.",
          "title": "Path",
          "required": true,
          "deprecated": false
        },
        "optional": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the location is optional.",
          "title": "Optional",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "property": {
      "type": "object",
      "title": "Property",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "A key value pair",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "key": {
          "kind": "attribute",
          "type": "string",
          "description": "Property key",
          "title": "Key",
          "required": true,
          "deprecated": false
        },
        "value": {
          "kind": "attribute",
          "type": "string",
          "description": "Property value",
          "title": "Value",
          "required": true,
          "deprecated": false
        }
      }
    },
    "propertyPlaceholder": {
      "type": "object",
      "title": "Property Placeholder",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Properties placeholder",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "location": {
          "kind": "attribute",
          "type": "string",
          "description": "A list of locations to load properties. You can use comma to separate multiple locations. This option will override any default locations and only use the locations from this option.",
          "title": "Location",
          "required": false,
          "deprecated": false
        },
        "encoding": {
          "kind": "attribute",
          "type": "string",
          "description": "Encoding to use when loading properties file from the file system or classpath. If no encoding has been set, then the properties files is loaded using ISO-8859-1 encoding (latin-1) as documented by link java.util.Propertiesload(java.io.InputStream)",
          "title": "Encoding",
          "required": false,
          "deprecated": false
        },
        "cache": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not to cache loaded properties. The default value is true.",
          "title": "Cache",
          "required": false,
          "deprecated": false
        },
        "ignoreMissingLocation": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to silently ignore if a location cannot be located, such as a properties file not found.",
          "title": "Ignore Missing Location",
          "required": false,
          "deprecated": false
        },
        "propertiesResolverRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to a custom PropertiesResolver to be used",
          "title": "Properties Resolver Ref",
          "required": false,
          "deprecated": false
        },
        "propertiesParserRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to a custom PropertiesParser to be used",
          "title": "Properties Parser Ref",
          "required": false,
          "deprecated": false
        },
        "propertyPrefix": {
          "kind": "attribute",
          "type": "string",
          "description": "Optional prefix prepended to property names before resolution.",
          "title": "Property Prefix",
          "required": false,
          "deprecated": false
        },
        "propertySuffix": {
          "kind": "attribute",
          "type": "string",
          "description": "Optional suffix appended to property names before resolution.",
          "title": "Property Suffix",
          "required": false,
          "deprecated": false
        },
        "fallbackToUnaugmentedProperty": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "If true, first attempt resolution of property name augmented with propertyPrefix and propertySuffix before falling back the plain property name specified. If false, only the augmented property name is searched.",
          "title": "Fallback To Unaugmented Property",
          "required": false,
          "deprecated": false
        },
        "defaultFallbackEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "If false, the component does not attempt to find a default for the key by looking after the colon separator.",
          "title": "Default Fallback Enabled",
          "required": false,
          "deprecated": false
        },
        "prefixToken": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "{{",
          "description": "Sets the value of the prefix token used to identify properties to replace. Setting a value of null restores the default token",
          "title": "Prefix Token",
          "required": false,
          "deprecated": false
        },
        "suffixToken": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "}}",
          "description": "Sets the value of the suffix token used to identify properties to replace. Setting a value of null restores the default token",
          "title": "Suffix Token",
          "required": false,
          "deprecated": false
        },
        "propertiesFunction": {
          "kind": "element",
          "type": "array",
          "description": "List of custom properties function to use.",
          "title": "Properties Function",
          "required": false,
          "deprecated": false
        },
        "propertiesLocation": {
          "kind": "element",
          "type": "array",
          "description": "List of property locations to use.",
          "title": "Properties Location",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "proxy": {
      "type": "object",
      "title": "Proxy",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "To proxy a service call using a interface",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "serviceUrl": {
          "kind": "attribute",
          "type": "string",
          "description": "The camel endpoint uri used to send the message to when calling the service from the interface.",
          "title": "Service Url",
          "required": false,
          "deprecated": false
        },
        "serviceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "The camel endpoint reference used to send the message to when calling the service from the interface.",
          "title": "Service Ref",
          "required": false,
          "deprecated": true
        },
        "serviceInterface": {
          "kind": "attribute",
          "type": "string",
          "description": "Java interfaces to use as facade for the service to be proxied",
          "title": "Service Interface",
          "required": false,
          "deprecated": false
        },
        "camelContextId": {
          "kind": "attribute",
          "type": "string",
          "description": "The id of the CamelContext to use, if there is multiple CamelContext in the same JVM.",
          "title": "Camel Context Id",
          "required": false,
          "deprecated": false
        },
        "binding": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Camel parameter binding is enabled by default, which will use binding information from the method signature parameters to bind to the Exchange/Message with the following annotations. If disabled then a org.apache.camel.component.bean.CamelInvocationHandler is used.",
          "title": "Binding",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "random": {
      "type": "object",
      "title": "Random",
      "group": "eip,routing,loadbalance",
      "icon": "generic24.png",
      "description": "Random load balancer",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "recipientList": {
      "type": "object",
      "title": "Recipient List",
      "group": "eip,endpoint,routing",
      "icon": "recipientList24.png",
      "description": "Routes messages to a number of dynamically specified recipients (dynamic to)",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression that returns which endpoints (url) to send the message to (the recipients). If the expression return an empty value then the message is not sent to any recipients.",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "delimiter": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": ",",
          "description": "Delimiter used if the Expression returned multiple endpoints. Can be turned off using the value false. The default value is ,",
          "title": "Delimiter",
          "required": false,
          "deprecated": false
        },
        "parallelProcessing": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then sending messages to the recipients occurs concurrently. Note the caller thread will still wait until all messages has been fully processed, before it continues. Its only the sending and processing the replies from the recipients which happens concurrently.",
          "title": "Parallel Processing",
          "required": false,
          "deprecated": false
        },
        "strategyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to the AggregationStrategy to be used to assemble the replies from the recipients, into a single outgoing message from the RecipientList. By default Camel will use the last reply as the outgoing message. You can also use a POJO as the AggregationStrategy",
          "title": "Strategy Ref",
          "required": false,
          "deprecated": false
        },
        "strategyMethodName": {
          "kind": "attribute",
          "type": "string",
          "description": "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Name",
          "required": false,
          "deprecated": false
        },
        "strategyMethodAllowNull": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy",
          "title": "Strategy Method Allow Null",
          "required": false,
          "deprecated": false
        },
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a custom Thread Pool to be used for parallel processing. Notice if you set this option, then parallel processing is automatic implied, and you do not have to enable that option as well.",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "stopOnException": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Will now stop further processing if an exception or failure occurred during processing of an org.apache.camel.Exchange and the caused exception will be thrown. Will also stop if processing the exchange failed (has a fault message) or an exception was thrown and handled by the error handler (such as using onException). In all situations the recipient list will stop further processing. This is the same behavior as in pipeline, which is used by the routing engine. The default behavior is to not stop but continue processing till the end",
          "title": "Stop On Exception",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidEndpoints": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Ignore the invalidate endpoint exception when try to create a producer with that endpoint",
          "title": "Ignore Invalid Endpoints",
          "required": false,
          "deprecated": false
        },
        "streaming": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then Camel will process replies out-of-order, eg in the order they come back. If disabled, Camel will process replies in the same order as defined by the recipient list.",
          "title": "Streaming",
          "required": false,
          "deprecated": false
        },
        "timeout": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "0",
          "description": "Sets a total timeout specified in millis, when using parallel processing. If the Recipient List hasn't been able to send and process all replies within the given timeframe, then the timeout triggers and the Recipient List breaks out and continues. Notice if you provide a TimeoutAwareAggregationStrategy then the timeout method is invoked before breaking out. If the timeout is reached with running tasks still remaining, certain tasks for which it is difficult for Camel to shut down in a graceful manner may continue to run. So use this option with a bit of care.",
          "title": "Timeout",
          "required": false,
          "deprecated": false
        },
        "onPrepareRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Uses the Processor when preparing the org.apache.camel.Exchange to be send. This can be used to deep-clone messages that should be send, or any custom logic needed before the exchange is send.",
          "title": "On Prepare Ref",
          "required": false,
          "deprecated": false
        },
        "shareUnitOfWork": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Shares the org.apache.camel.spi.UnitOfWork with the parent and each of the sub messages. Recipient List will by default not share unit of work between the parent exchange and each recipient exchange. This means each sub exchange has its own individual unit of work.",
          "title": "Share Unit Of Work",
          "required": false,
          "deprecated": false
        },
        "cacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum size used by the org.apache.camel.impl.ProducerCache which is used to cache and reuse producers when using this recipient list, when uris are reused.",
          "title": "Cache Size",
          "required": false,
          "deprecated": false
        },
        "parallelAggregate": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then the aggregate method on AggregationStrategy can be called concurrently. Notice that this would require the implementation of AggregationStrategy to be implemented as thread-safe. By default this is false meaning that Camel synchronizes the call to the aggregate method. Though in some use-cases this can be used to archive higher performance when the AggregationStrategy is implemented as thread-safe.",
          "title": "Parallel Aggregate",
          "required": false,
          "deprecated": false
        },
        "stopOnAggregateException": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled, unwind exceptions occurring at aggregation time to the error handler when parallelProcessing is used. Currently, aggregation time exceptions do not stop the route processing when parallelProcessing is used. Enabling this option allows to work around this behavior. The default value is false for the sake of backward compatibility.",
          "title": "Stop On Aggregate Exception",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "redeliveryPolicy": {
      "type": "object",
      "title": "Redelivery Policy",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "To configure re-delivery for error handling",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "maximumRedeliveries": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the maximum redeliveries x = redeliver at most x times 0 = no redeliveries -1 = redeliver forever",
          "title": "Maximum Redeliveries",
          "required": false,
          "deprecated": false
        },
        "redeliveryDelay": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the initial redelivery delay",
          "title": "Redelivery Delay",
          "required": false,
          "deprecated": false
        },
        "asyncDelayedRedelivery": {
          "kind": "attribute",
          "type": "string",
          "description": "Allow synchronous delayed redelivery. The route, in particular the consumer's component, must support the Asynchronous Routing Engine (e.g. seda).",
          "title": "Async Delayed Redelivery",
          "required": false,
          "deprecated": false
        },
        "backOffMultiplier": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the back off multiplier",
          "title": "Back Off Multiplier",
          "required": false,
          "deprecated": false
        },
        "useExponentialBackOff": {
          "kind": "attribute",
          "type": "string",
          "description": "Turn on exponential backk off",
          "title": "Use Exponential Back Off",
          "required": false,
          "deprecated": false
        },
        "collisionAvoidanceFactor": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the collision avoidance factor",
          "title": "Collision Avoidance Factor",
          "required": false,
          "deprecated": false
        },
        "useCollisionAvoidance": {
          "kind": "attribute",
          "type": "string",
          "description": "Turn on collision avoidance.",
          "title": "Use Collision Avoidance",
          "required": false,
          "deprecated": false
        },
        "maximumRedeliveryDelay": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the maximum delay between redelivery",
          "title": "Maximum Redelivery Delay",
          "required": false,
          "deprecated": false
        },
        "retriesExhaustedLogLevel": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "DEBUG", "ERROR", "INFO", "OFF", "TRACE", "WARN" ],
          "description": "Sets the logging level to use when retries has exhausted",
          "title": "Retries Exhausted Log Level",
          "required": false,
          "deprecated": false
        },
        "retryAttemptedLogLevel": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "DEBUG", "ERROR", "INFO", "OFF", "TRACE", "WARN" ],
          "description": "Sets the logging level to use for logging retry attempts",
          "title": "Retry Attempted Log Level",
          "required": false,
          "deprecated": false
        },
        "logRetryAttempted": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether retry attempts should be logged or not. Can be used to include or reduce verbose.",
          "title": "Log Retry Attempted",
          "required": false,
          "deprecated": false
        },
        "logStackTrace": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether stack traces should be logged. Can be used to include or reduce verbose.",
          "title": "Log Stack Trace",
          "required": false,
          "deprecated": false
        },
        "logRetryStackTrace": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether stack traces should be logged when an retry attempt failed. Can be used to include or reduce verbose.",
          "title": "Log Retry Stack Trace",
          "required": false,
          "deprecated": false
        },
        "logHandled": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether handled exceptions should be logged or not. Can be used to include or reduce verbose.",
          "title": "Log Handled",
          "required": false,
          "deprecated": false
        },
        "logNewException": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether new exceptions should be logged or not. Can be used to include or reduce verbose. A new exception is an exception that was thrown while handling a previous exception.",
          "title": "Log New Exception",
          "required": false,
          "deprecated": false
        },
        "logContinued": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether continued exceptions should be logged or not. Can be used to include or reduce verbose.",
          "title": "Log Continued",
          "required": false,
          "deprecated": false
        },
        "logExhausted": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether exhausted exceptions should be logged or not. Can be used to include or reduce verbose.",
          "title": "Log Exhausted",
          "required": false,
          "deprecated": false
        },
        "logExhaustedMessageHistory": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether exhausted exceptions should be logged including message history or not (supports property placeholders). Can be used to include or reduce verbose.",
          "title": "Log Exhausted Message History",
          "required": false,
          "deprecated": false
        },
        "logExhaustedMessageBody": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether exhausted message body should be logged including message history or not (supports property placeholders). Can be used to include or reduce verbose. Requires logExhaustedMessageHistory to be enabled.",
          "title": "Log Exhausted Message Body",
          "required": false,
          "deprecated": false
        },
        "disableRedelivery": {
          "kind": "attribute",
          "type": "string",
          "description": "Disables redelivery (same as setting maximum redeliveries to 0)",
          "title": "Disable Redelivery",
          "required": false,
          "deprecated": false
        },
        "delayPattern": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the delay pattern with delay intervals.",
          "title": "Delay Pattern",
          "required": false,
          "deprecated": false
        },
        "allowRedeliveryWhileStopping": {
          "kind": "attribute",
          "type": "string",
          "description": "Controls whether to allow redelivery while stopping/shutting down a route that uses error handling.",
          "title": "Allow Redelivery While Stopping",
          "required": false,
          "deprecated": false
        },
        "exchangeFormatterRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the reference of the instance of org.apache.camel.spi.ExchangeFormatter to generate the log message from exchange.",
          "title": "Exchange Formatter Ref",
          "required": false,
          "deprecated": false
        }
      }
    },
    "redeliveryPolicyProfile": {
      "type": "object",
      "title": "Redelivery Policy Profile",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Configuration of redelivery policy.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "maximumRedeliveries": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the maximum number of times a message exchange will be redelivered. Setting a negative value will retry forever.",
          "title": "Maximum Redeliveries",
          "required": false,
          "deprecated": false
        },
        "redeliveryDelay": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "1000",
          "description": "Sets the maximum redelivery delay. Use -1 if you wish to have no maximum",
          "title": "Redelivery Delay",
          "required": false,
          "deprecated": false
        },
        "asyncDelayedRedelivery": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether asynchronous delayed redelivery is allowed. This is disabled by default. When enabled it allows Camel to schedule a future task for delayed redelivery which prevents current thread from blocking while waiting. Exchange which is transacted will however always use synchronous delayed redelivery because the transaction must execute in the same thread context.",
          "title": "Async Delayed Redelivery",
          "required": false,
          "deprecated": false
        },
        "backOffMultiplier": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "2",
          "description": "Sets the multiplier used to increase the delay between redeliveries if useExponentialBackOff is enabled",
          "title": "Back Off Multiplier",
          "required": false,
          "deprecated": false
        },
        "useExponentialBackOff": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Enables/disables exponential backoff using the backOffMultiplier to increase the time between retries",
          "title": "Use Exponential Back Off",
          "required": false,
          "deprecated": false
        },
        "collisionAvoidanceFactor": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "0.15",
          "description": "Sets the factor used for collision avoidance if enabled via useCollisionAvoidance.",
          "title": "Collision Avoidance Factor",
          "required": false,
          "deprecated": false
        },
        "useCollisionAvoidance": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Enables/disables collision avoidance which adds some randomization to the backoff timings to reduce contention probability",
          "title": "Use Collision Avoidance",
          "required": false,
          "deprecated": false
        },
        "maximumRedeliveryDelay": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "60000",
          "description": "Sets the maximum redelivery delay. Use -1 if you wish to have no maximum",
          "title": "Maximum Redelivery Delay",
          "required": false,
          "deprecated": false
        },
        "retriesExhaustedLogLevel": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "ERROR",
          "enum": [ "DEBUG", "ERROR", "INFO", "OFF", "TRACE", "WARN" ],
          "description": "Sets the logging level to use for log messages when retries have been exhausted.",
          "title": "Retries Exhausted Log Level",
          "required": false,
          "deprecated": false
        },
        "retryAttemptedLogLevel": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "DEBUG",
          "enum": [ "DEBUG", "ERROR", "INFO", "OFF", "TRACE", "WARN" ],
          "description": "Sets the logging level to use for log messages when retries are attempted.",
          "title": "Retry Attempted Log Level",
          "required": false,
          "deprecated": false
        },
        "logRetryAttempted": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Sets whether to log retry attempts",
          "title": "Log Retry Attempted",
          "required": false,
          "deprecated": false
        },
        "logStackTrace": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Sets whether stack traces should be logged or not",
          "title": "Log Stack Trace",
          "required": false,
          "deprecated": false
        },
        "logRetryStackTrace": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether stack traces should be logged or not",
          "title": "Log Retry Stack Trace",
          "required": false,
          "deprecated": false
        },
        "logHandled": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether errors should be logged even if its handled",
          "title": "Log Handled",
          "required": false,
          "deprecated": false
        },
        "logNewException": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Sets whether errors should be logged when a new exception occurred during handling a previous exception",
          "title": "Log New Exception",
          "required": false,
          "deprecated": false
        },
        "logContinued": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether errors should be logged even if its continued",
          "title": "Log Continued",
          "required": false,
          "deprecated": false
        },
        "logExhausted": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Sets whether exhausted exceptions should be logged or not",
          "title": "Log Exhausted",
          "required": false,
          "deprecated": false
        },
        "logExhaustedMessageHistory": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether to log exhausted errors including message history",
          "title": "Log Exhausted Message History",
          "required": false,
          "deprecated": false
        },
        "logExhaustedMessageBody": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether exhausted message body/headers should be logged with message history included",
          "title": "Log Exhausted Message Body",
          "required": false,
          "deprecated": false
        },
        "disableRedelivery": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Disables redelivery by setting maximum redeliveries to 0.",
          "title": "Disable Redelivery",
          "required": false,
          "deprecated": false
        },
        "delayPattern": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets an optional delay pattern to use instead of fixed delay.",
          "title": "Delay Pattern",
          "required": false,
          "deprecated": false
        },
        "allowRedeliveryWhileStopping": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Controls whether to allow redelivery while stopping/shutting down a route that uses error handling.",
          "title": "Allow Redelivery While Stopping",
          "required": false,
          "deprecated": false
        },
        "exchangeFormatterRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the reference of the instance of org.apache.camel.spi.ExchangeFormatter to generate the log message from exchange.",
          "title": "Exchange Formatter Ref",
          "required": false,
          "deprecated": false
        },
        "camelContextId": {
          "kind": "attribute",
          "type": "string",
          "description": "Id of CamelContext to use if there are multiple CamelContexts in the same JVM",
          "title": "Camel Context Id",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "removeHeader": {
      "type": "object",
      "title": "Remove Header",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Removes a named header from the message",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "headerName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of header to remove",
          "title": "Header Name",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "removeHeaders": {
      "type": "object",
      "title": "Remove Headers",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Removes message headers whose name matches a specified pattern",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "pattern": {
          "kind": "attribute",
          "type": "string",
          "description": "Name or pattern of headers to remove",
          "title": "Pattern",
          "required": true,
          "deprecated": false
        },
        "excludePattern": {
          "kind": "attribute",
          "type": "string",
          "description": "Name or patter of headers to not remove",
          "title": "Exclude Pattern",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "removeProperties": {
      "type": "object",
      "title": "Remove Properties",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Removes message exchange properties whose name matches a specified pattern",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "pattern": {
          "kind": "attribute",
          "type": "string",
          "description": "Name or pattern of properties to remove",
          "title": "Pattern",
          "required": true,
          "deprecated": false
        },
        "excludePattern": {
          "kind": "attribute",
          "type": "string",
          "description": "Name or pattern of properties to not remove",
          "title": "Exclude Pattern",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "removeProperty": {
      "type": "object",
      "title": "Remove Property",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Removes a named property from the message exchange",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "propertyName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of property to remove",
          "title": "Property Name",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "resequence": {
      "type": "object",
      "title": "Resequence",
      "group": "eip,routing",
      "icon": "resequence24.png",
      "description": "Resequences (re-order) messages based on an expression",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to use for re-ordering the messages, such as a header with a sequence number",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "resequencerConfig": {
          "kind": "element",
          "type": "object",
          "description": "To configure the resequencer in using either batch or stream configuration. Will by default use batch configuration.",
          "title": "Resequencer Config",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "ribbonLoadBalancer": {
      "type": "object",
      "title": "Ribbon Load Balancer",
      "group": "routing,cloud,load-balancing",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "namespace": {
          "kind": "attribute",
          "type": "string",
          "description": "The namespace",
          "title": "Namespace",
          "required": false,
          "deprecated": false
        },
        "username": {
          "kind": "attribute",
          "type": "string",
          "description": "The username",
          "title": "Username",
          "required": false,
          "deprecated": false
        },
        "password": {
          "kind": "attribute",
          "type": "string",
          "description": "The password",
          "title": "Password",
          "required": false,
          "deprecated": false
        },
        "clientName": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Ribbon client name",
          "title": "Client Name",
          "required": false,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "rollback": {
      "type": "object",
      "title": "Rollback",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Forces a rollback by stopping routing the message",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "markRollbackOnly": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Mark the transaction for rollback only (cannot be overruled to commit)",
          "title": "Mark Rollback Only",
          "required": false,
          "deprecated": false
        },
        "markRollbackOnlyLast": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Mark only last sub transaction for rollback only. When using sub transactions (if the transaction manager support this)",
          "title": "Mark Rollback Only Last",
          "required": false,
          "deprecated": false
        },
        "message": {
          "kind": "attribute",
          "type": "string",
          "description": "Message to use in rollback exception",
          "title": "Message",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "roundRobin": {
      "type": "object",
      "title": "Round Robin",
      "group": "eip,routing,loadbalance",
      "icon": "generic24.png",
      "description": "Round robin load balancer",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "route": {
      "type": "object",
      "title": "Route",
      "group": "configuration",
      "icon": "route24.png",
      "description": "A Camel route",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "group": {
          "kind": "attribute",
          "type": "string",
          "description": "The group that this route belongs to; could be the name of the RouteBuilder class or be explicitly configured in the XML. May be null.",
          "title": "Group",
          "required": false,
          "deprecated": false
        },
        "streamCache": {
          "kind": "attribute",
          "type": "string",
          "description": "Whether stream caching is enabled on this route.",
          "title": "Stream Cache",
          "required": false,
          "deprecated": false
        },
        "trace": {
          "kind": "attribute",
          "type": "string",
          "description": "Whether tracing is enabled on this route.",
          "title": "Trace",
          "required": false,
          "deprecated": false
        },
        "messageHistory": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Whether message history is enabled on this route.",
          "title": "Message History",
          "required": false,
          "deprecated": false
        },
        "logMask": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Whether security mask for Logging is enabled on this route.",
          "title": "Log Mask",
          "required": false,
          "deprecated": false
        },
        "handleFault": {
          "kind": "attribute",
          "type": "string",
          "description": "Whether handle fault is enabled on this route.",
          "title": "Handle Fault",
          "required": false,
          "deprecated": false
        },
        "delayer": {
          "kind": "attribute",
          "type": "string",
          "description": "Whether to slow down processing messages by a given delay in msec.",
          "title": "Delayer",
          "required": false,
          "deprecated": false
        },
        "autoStartup": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Whether to auto start this route",
          "title": "Auto Startup",
          "required": false,
          "deprecated": false
        },
        "startupOrder": {
          "kind": "attribute",
          "type": "integer",
          "description": "To configure the ordering of the routes being started",
          "title": "Startup Order",
          "required": false,
          "deprecated": false
        },
        "errorHandlerRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the bean ref name of the error handler builder to use on this route",
          "title": "Error Handler Ref",
          "required": false,
          "deprecated": false
        },
        "routePolicyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to custom org.apache.camel.spi.RoutePolicy to use by the route. Multiple policies can be configured by separating values using comma.",
          "title": "Route Policy Ref",
          "required": false,
          "deprecated": false
        },
        "shutdownRoute": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "Default", "Defer" ],
          "description": "To control how to shutdown the route.",
          "title": "Shutdown Route",
          "required": false,
          "deprecated": false
        },
        "shutdownRunningTask": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "CompleteCurrentTaskOnly", "CompleteAllTasks" ],
          "description": "To control how to shutdown the route.",
          "title": "Shutdown Running Task",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "routeBuilder": {
      "type": "object",
      "title": "Route Builder",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "To refer to a Java org.apache.camel.builder.RouteBuilder instance to use.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to the route builder instance",
          "title": "Ref",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "routeContext": {
      "type": "object",
      "title": "Route Context",
      "group": "spring,configuration,routing",
      "icon": "generic24.png",
      "description": "Configuration of routes using XML",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "route": {
          "kind": "element",
          "type": "array",
          "description": "Contains the Camel routes",
          "title": "Route",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "routeContextRef": {
      "type": "object",
      "title": "Route Context Ref",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "To refer to an XML file with routes defined using the xml-dsl",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to the routes in the xml dsl",
          "title": "Ref",
          "required": true,
          "deprecated": false
        }
      }
    },
    "routes": {
      "type": "object",
      "title": "Routes",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "A series of Camel routes",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "routes": {
          "kind": "element",
          "type": "array",
          "description": "Contains the Camel routes",
          "title": "Routes",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "routingSlip": {
      "type": "object",
      "title": "Routing Slip",
      "group": "eip,endpoint,routing",
      "icon": "routingSlip24.png",
      "description": "Routes a message through a series of steps that are pre-determined (the slip)",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to define the routing slip, which defines which endpoints to route the message in a pipeline style. Notice the expression is evaluated once, if you want a more dynamic style, then the dynamic router eip is a better choice.",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "uriDelimiter": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": ",",
          "description": "Sets the uri delimiter to use",
          "title": "Uri Delimiter",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidEndpoints": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Ignore the invalidate endpoint exception when try to create a producer with that endpoint",
          "title": "Ignore Invalid Endpoints",
          "required": false,
          "deprecated": false
        },
        "cacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum size used by the org.apache.camel.impl.ProducerCache which is used to cache and reuse producers when using this routing slip, when uris are reused.",
          "title": "Cache Size",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "saga": {
      "type": "object",
      "title": "Saga",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Enables sagas on the route",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "propagation": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "REQUIRED",
          "enum": [ "MANDATORY", "NEVER", "NOT_SUPPORTED", "REQUIRED", "REQUIRES_NEW", "SUPPORTS" ],
          "description": "Set the Saga propagation mode (REQUIRED, REQUIRES_NEW, MANDATORY, SUPPORTS, NOT_SUPPORTED, NEVER).",
          "title": "Propagation",
          "required": false,
          "deprecated": false
        },
        "completionMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "AUTO",
          "enum": [ "AUTO", "MANUAL" ],
          "description": "Determine how the saga should be considered complete. When set to AUTO, the saga is completed when the exchange that initiates the saga is processed successfully, or compensated when it completes exceptionally. When set to MANUAL, the user must complete or compensate the saga using the saga:complete or saga:compensate endpoints.",
          "title": "Completion Mode",
          "required": false,
          "deprecated": false
        },
        "timeoutInMilliseconds": {
          "kind": "attribute",
          "type": "integer",
          "description": "Set the maximum amount of time for the Saga. After the timeout is expired, the saga will be compensated automatically (unless a different decision has been taken in the meantime).",
          "title": "Timeout In Milliseconds",
          "required": false,
          "deprecated": false
        },
        "compensation": {
          "kind": "element",
          "type": "object",
          "description": "The compensation endpoint URI that must be called to compensate all changes done in the route. The route corresponding to the compensation URI must perform compensation and complete without error. If errors occur during compensation, the saga service may call again the compensation URI to retry.",
          "title": "Compensation",
          "required": false,
          "deprecated": false
        },
        "completion": {
          "kind": "element",
          "type": "object",
          "description": "The completion endpoint URI that will be called when the Saga is completed successfully. The route corresponding to the completion URI must perform completion tasks and terminate without error. If errors occur during completion, the saga service may call again the completion URI to retry.",
          "title": "Completion",
          "required": false,
          "deprecated": false
        },
        "option": {
          "kind": "element",
          "type": "array",
          "description": "Allows to save properties of the current exchange in order to re-use them in a compensation/completion callback route. Options are usually helpful e.g. to store and retrieve identifiers of objects that should be deleted in compensating actions. Option values will be transformed into input headers of the compensation/completion exchange.",
          "title": "Option",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "sample": {
      "type": "object",
      "title": "Sample",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Extract a sample of the messages passing through a route",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "samplePeriod": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "1",
          "description": "Sets the sample period during which only a single Exchange will pass through.",
          "title": "Sample Period",
          "required": false,
          "deprecated": false
        },
        "messageFrequency": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the sample message count which only a single Exchange will pass through after this many received.",
          "title": "Message Frequency",
          "required": false,
          "deprecated": false
        },
        "units": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "SECONDS",
          "enum": [ "DAYS", "HOURS", "MICROSECONDS", "MILLISECONDS", "MINUTES", "NANOSECONDS", "SECONDS" ],
          "description": "Sets the time units for the sample period, defaulting to seconds.",
          "title": "Units",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "script": {
      "type": "object",
      "title": "Script",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Executes a script from a language which does not change the message body.",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to return the transformed message body (the new message body to use)",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "serviceCall": {
      "type": "object",
      "title": "Service Call",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "To call remote services",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "name": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the name of the service to use",
          "title": "Name",
          "required": true,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "The uri of the endpoint to send to. The uri can be dynamic computed using the org.apache.camel.language.simple.SimpleLanguage expression.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "component": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "http4",
          "description": "The component to use.",
          "title": "Component",
          "required": false,
          "deprecated": false
        },
        "pattern": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "InOnly", "InOptionalOut", "InOut", "OutIn", "OutOnly", "OutOptionalIn", "RobustInOnly", "RobustOutOnly" ],
          "description": "Sets the optional ExchangePattern used to invoke this endpoint",
          "title": "Pattern",
          "required": false,
          "deprecated": false
        },
        "configurationRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a ServiceCall configuration to use",
          "title": "Configuration Ref",
          "required": false,
          "deprecated": false
        },
        "serviceDiscoveryRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a custom ServiceDiscovery to use.",
          "title": "Service Discovery Ref",
          "required": false,
          "deprecated": false
        },
        "serviceFilterRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a custom ServiceFilter to use.",
          "title": "Service Filter Ref",
          "required": false,
          "deprecated": false
        },
        "serviceChooserRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a custom ServiceChooser to use.",
          "title": "Service Chooser Ref",
          "required": false,
          "deprecated": false
        },
        "loadBalancerRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a custom ServiceLoadBalancer to use.",
          "title": "Load Balancer Ref",
          "required": false,
          "deprecated": false
        },
        "expressionRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Set a reference to a custom Expression to use.",
          "title": "Expression Ref",
          "required": false,
          "deprecated": false
        },
        "serviceDiscoveryConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configures the ServiceDiscovery using the given configuration.",
          "title": "Service Discovery Configuration",
          "required": true,
          "deprecated": false
        },
        "serviceFilterConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configures the ServiceFilter using the given configuration.",
          "title": "Service Filter Configuration",
          "required": true,
          "deprecated": false
        },
        "loadBalancerConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configures the LoadBalancer using the given configuration.",
          "title": "Load Balancer Configuration",
          "required": true,
          "deprecated": false
        },
        "expressionConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configures the Expression using the given configuration.",
          "title": "Expression Configuration",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "serviceCallConfiguration": {
      "type": "object",
      "title": "Service Call Configuration",
      "group": "routing,cloud",
      "icon": "generic24.png",
      "description": "Remote service call configuration",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "The uri of the endpoint to send to. The uri can be dynamic computed using the org.apache.camel.language.simple.SimpleLanguage expression.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "component": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "http4",
          "description": "The component to use.",
          "title": "Component",
          "required": false,
          "deprecated": false
        },
        "pattern": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "InOnly", "InOptionalOut", "InOut", "OutIn", "OutOnly", "OutOptionalIn", "RobustInOnly", "RobustOutOnly" ],
          "description": "Sets the optional ExchangePattern used to invoke this endpoint",
          "title": "Pattern",
          "required": false,
          "deprecated": false
        },
        "serviceDiscoveryRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a custom ServiceDiscovery to use.",
          "title": "Service Discovery Ref",
          "required": false,
          "deprecated": false
        },
        "serviceFilterRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a custom ServiceFilter to use.",
          "title": "Service Filter Ref",
          "required": false,
          "deprecated": false
        },
        "serviceChooserRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a custom ServiceChooser to use.",
          "title": "Service Chooser Ref",
          "required": false,
          "deprecated": false
        },
        "loadBalancerRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to a custom ServiceLoadBalancer to use.",
          "title": "Load Balancer Ref",
          "required": false,
          "deprecated": false
        },
        "expressionRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Set a reference to a custom Expression to use.",
          "title": "Expression Ref",
          "required": false,
          "deprecated": false
        },
        "serviceDiscoveryConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configures the ServiceDiscovery using the given configuration.",
          "title": "Service Discovery Configuration",
          "required": true,
          "deprecated": false
        },
        "serviceFilterConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configures the ServiceFilter using the given configuration.",
          "title": "Service Filter Configuration",
          "required": true,
          "deprecated": false
        },
        "loadBalancerConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configures theL oadBalancer using the given configuration.",
          "title": "Load Balancer Configuration",
          "required": true,
          "deprecated": false
        },
        "expressionConfiguration": {
          "kind": "element",
          "type": "object",
          "description": "Configures the Expression using the given configuration.",
          "title": "Expression Configuration",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "serviceChooserConfiguration": {
      "type": "object",
      "title": "Service Chooser Configuration",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "serviceDiscoveryConfiguration": {
      "type": "object",
      "title": "Service Discovery Configuration",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "serviceExpression": {
      "type": "object",
      "title": "Service Expression",
      "group": "routing,cloud",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "hostHeader": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "CamelServiceCallServiceHost",
          "description": "The header that holds the service host information, default ServiceCallConstants.SERVICE_HOST",
          "title": "Host Header",
          "required": false,
          "deprecated": false
        },
        "portHeader": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "CamelServiceCallServicePort",
          "description": "The header that holds the service port information, default ServiceCallConstants.SERVICE_PORT",
          "title": "Port Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "serviceFilterConfiguration": {
      "type": "object",
      "title": "Service Filter Configuration",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "setBody": {
      "type": "object",
      "title": "Set Body",
      "group": "eip,transformation",
      "icon": "setBody24.png",
      "description": "Sets the contents of the message body",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression that returns the new body to use",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "setExchangePattern": {
      "type": "object",
      "title": "Set Exchange Pattern",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Sets the exchange pattern on the message exchange",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "pattern": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "InOnly", "InOptionalOut", "InOut", "OutIn", "OutOnly", "OutOptionalIn", "RobustInOnly", "RobustOutOnly" ],
          "description": "Sets the new exchange pattern of the Exchange to be used from this point forward",
          "title": "Pattern",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "setFaultBody": {
      "type": "object",
      "title": "Set Fault Body",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Sets the contents of a fault message's body",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression that returns the new fault body to use",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "setHeader": {
      "type": "object",
      "title": "Set Header",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Sets the value of a message header",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to return the value of the header",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "headerName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of message header to set a new value The simple language can be used to define a dynamic evaluated header name to be used. Otherwise a constant name will be used.",
          "title": "Header Name",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "setOutHeader": {
      "type": "object",
      "title": "Set Out Header",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Sets the value of a header on the outbound message",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to return the value of the header",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "headerName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of message header to set a new value",
          "title": "Header Name",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "setProperty": {
      "type": "object",
      "title": "Set Property",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Sets a named property on the message exchange",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to return the value of the message exchange property",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "propertyName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of exchange property to set a new value. The simple language can be used to define a dynamic evaluated exchange property name to be used. Otherwise a constant name will be used.",
          "title": "Property Name",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "sort": {
      "type": "object",
      "title": "Sort",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Sorts the contents of the message",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Optional expression to sort by something else than the message body",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "comparatorRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to lookup for the comparator to use for sorting",
          "title": "Comparator Ref",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "split": {
      "type": "object",
      "title": "Split",
      "group": "eip,routing",
      "icon": "split24.png",
      "description": "Splits a single message into many sub-messages.",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression of how to split the message body, such as as-is, using a tokenizer, or using an xpath.",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "parallelProcessing": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then processing each splitted messages occurs concurrently. Note the caller thread will still wait until all messages has been fully processed, before it continues. Its only processing the sub messages from the splitter which happens concurrently.",
          "title": "Parallel Processing",
          "required": false,
          "deprecated": false
        },
        "strategyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to the AggregationStrategy to be used to assemble the replies from the splitted messages, into a single outgoing message from the Splitter. By default Camel will use the original incoming message to the splitter (leave it unchanged). You can also use a POJO as the AggregationStrategy",
          "title": "Strategy Ref",
          "required": false,
          "deprecated": false
        },
        "strategyMethodName": {
          "kind": "attribute",
          "type": "string",
          "description": "This option can be used to explicit declare the method name to use, when using POJOs as the AggregationStrategy.",
          "title": "Strategy Method Name",
          "required": false,
          "deprecated": false
        },
        "strategyMethodAllowNull": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If this option is false then the aggregate method is not used if there was no data to enrich. If this option is true then null values is used as the oldExchange (when no data to enrich), when using POJOs as the AggregationStrategy",
          "title": "Strategy Method Allow Null",
          "required": false,
          "deprecated": false
        },
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a custom Thread Pool to be used for parallel processing. Notice if you set this option, then parallel processing is automatic implied, and you do not have to enable that option as well.",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "streaming": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "When in streaming mode, then the splitter splits the original message on-demand, and each splitted message is processed one by one. This reduces memory usage as the splitter do not split all the messages first, but then we do not know the total size, and therefore the link org.apache.camel.ExchangeSPLIT_SIZE is empty. In non-streaming mode (default) the splitter will split each message first, to know the total size, and then process each message one by one. This requires to keep all the splitted messages in memory and therefore requires more memory. The total size is provided in the link org.apache.camel.ExchangeSPLIT_SIZE header. The streaming mode also affects the aggregation behavior. If enabled then Camel will process replies out-of-order, eg in the order they come back. If disabled, Camel will process replies in the same order as the messages was splitted.",
          "title": "Streaming",
          "required": false,
          "deprecated": false
        },
        "stopOnException": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Will now stop further processing if an exception or failure occurred during processing of an org.apache.camel.Exchange and the caused exception will be thrown. Will also stop if processing the exchange failed (has a fault message) or an exception was thrown and handled by the error handler (such as using onException). In all situations the splitter will stop further processing. This is the same behavior as in pipeline, which is used by the routing engine. The default behavior is to not stop but continue processing till the end",
          "title": "Stop On Exception",
          "required": false,
          "deprecated": false
        },
        "timeout": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "0",
          "description": "Sets a total timeout specified in millis, when using parallel processing. If the Splitter hasn't been able to split and process all the sub messages within the given timeframe, then the timeout triggers and the Splitter breaks out and continues. Notice if you provide a TimeoutAwareAggregationStrategy then the timeout method is invoked before breaking out. If the timeout is reached with running tasks still remaining, certain tasks for which it is difficult for Camel to shut down in a graceful manner may continue to run. So use this option with a bit of care.",
          "title": "Timeout",
          "required": false,
          "deprecated": false
        },
        "onPrepareRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Uses the Processor when preparing the org.apache.camel.Exchange to be send. This can be used to deep-clone messages that should be send, or any custom logic needed before the exchange is send.",
          "title": "On Prepare Ref",
          "required": false,
          "deprecated": false
        },
        "shareUnitOfWork": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Shares the org.apache.camel.spi.UnitOfWork with the parent and each of the sub messages. Splitter will by default not share unit of work between the parent exchange and each splitted exchange. This means each splitted exchange has its own individual unit of work.",
          "title": "Share Unit Of Work",
          "required": false,
          "deprecated": false
        },
        "parallelAggregate": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then the aggregate method on AggregationStrategy can be called concurrently. Notice that this would require the implementation of AggregationStrategy to be implemented as thread-safe. By default this is false meaning that Camel synchronizes the call to the aggregate method. Though in some use-cases this can be used to archive higher performance when the AggregationStrategy is implemented as thread-safe.",
          "title": "Parallel Aggregate",
          "required": false,
          "deprecated": false
        },
        "stopOnAggregateException": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled, unwind exceptions occurring at aggregation time to the error handler when parallelProcessing is used. Currently, aggregation time exceptions do not stop the route processing when parallelProcessing is used. Enabling this option allows to work around this behavior. The default value is false for the sake of backward compatibility.",
          "title": "Stop On Aggregate Exception",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "staticServiceDiscovery": {
      "type": "object",
      "title": "Static Service Discovery",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "servers": {
          "kind": "element",
          "type": "array",
          "description": "Sets the server list. Each entry can be a list of servers separated by comma in the format: servicehost:port,servicehost2:port,servicehost3:port",
          "title": "Servers",
          "required": false,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "sticky": {
      "type": "object",
      "title": "Sticky",
      "group": "eip,routing,loadbalance",
      "icon": "generic24.png",
      "description": "Sticky load balancer",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "correlationExpression": {
          "kind": "expression",
          "type": "object",
          "description": "The correlation expression to use to calculate the correlation key",
          "title": "Correlation Expression",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "stop": {
      "type": "object",
      "title": "Stop",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Stops the processing of the current message",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "stream-config": {
      "type": "object",
      "title": "Stream-config",
      "group": "eip,routing,resequence",
      "icon": "generic24.png",
      "description": "Configures stream-processing resequence eip.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "capacity": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "100",
          "description": "Sets the capacity of the resequencer's inbound queue.",
          "title": "Capacity",
          "required": false,
          "deprecated": false
        },
        "timeout": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "1000",
          "description": "Sets minimum time to wait for missing elements (messages).",
          "title": "Timeout",
          "required": false,
          "deprecated": false
        },
        "deliveryAttemptInterval": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "1000",
          "description": "Sets the interval in milli seconds the stream resequencer will at most wait while waiting for condition of being able to deliver.",
          "title": "Delivery Attempt Interval",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidExchanges": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to ignore invalid exchanges",
          "title": "Ignore Invalid Exchanges",
          "required": false,
          "deprecated": false
        },
        "comparatorRef": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a custom comparator",
          "title": "Comparator Ref",
          "required": false,
          "deprecated": false
        },
        "rejectOld": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If true, throws an exception when messages older than the last delivered message are processed",
          "title": "Reject Old",
          "required": false,
          "deprecated": false
        }
      }
    },
    "streamCaching": {
      "type": "object",
      "title": "Stream Caching",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Stream caching configuration.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "enabled": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether the stream caching is enabled. Notice: This cannot be changed at runtime.",
          "title": "Enabled",
          "required": false,
          "deprecated": false
        },
        "spoolDirectory": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the spool (temporary) directory to use for overflow and spooling to disk. If no spool directory has been explicit configured, then a temporary directory is created in the java.io.tmpdir directory.",
          "title": "Spool Directory",
          "required": false,
          "deprecated": false
        },
        "spoolChiper": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a chiper name to use when spooling to disk to write with encryption. By default the data is not encrypted.",
          "title": "Spool Chiper",
          "required": false,
          "deprecated": false
        },
        "spoolThreshold": {
          "kind": "attribute",
          "type": "string",
          "description": "Threshold in bytes when overflow to disk is activated. The default threshold is link org.apache.camel.StreamCacheDEFAULT_SPOOL_THRESHOLD bytes (eg 128kb). Use -1 to disable overflow to disk.",
          "title": "Spool Threshold",
          "required": false,
          "deprecated": false
        },
        "spoolUsedHeapMemoryThreshold": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a percentage (1-99) of used heap memory threshold to activate spooling to disk.",
          "title": "Spool Used Heap Memory Threshold",
          "required": false,
          "deprecated": false
        },
        "spoolUsedHeapMemoryLimit": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets what the upper bounds should be when spoolUsedHeapMemoryThreshold is in use.",
          "title": "Spool Used Heap Memory Limit",
          "required": false,
          "deprecated": false
        },
        "spoolRules": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to one or more custom org.apache.camel.spi.StreamCachingStrategy.SpoolRule to use. Multiple rules can be separated by comma.",
          "title": "Spool Rules",
          "required": false,
          "deprecated": false
        },
        "bufferSize": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the buffer size to use when allocating in-memory buffers used for in-memory stream caches. The default size is link org.apache.camel.util.IOHelperDEFAULT_BUFFER_SIZE",
          "title": "Buffer Size",
          "required": false,
          "deprecated": false
        },
        "removeSpoolDirectoryWhenStopping": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "true",
          "description": "Whether to remove the temporary directory when stopping. This option is default true",
          "title": "Remove Spool Directory When Stopping",
          "required": false,
          "deprecated": false
        },
        "statisticsEnabled": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether statistics is enabled.",
          "title": "Statistics Enabled",
          "required": false,
          "deprecated": false
        },
        "anySpoolRules": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "false",
          "description": "Sets whether if just any of the org.apache.camel.spi.StreamCachingStrategy.SpoolRule rules returns true then shouldSpoolCache(long) returns true. If this option is false, then all the org.apache.camel.spi.StreamCachingStrategy.SpoolRule must return true. The default value is false which means that all the rules must return true.",
          "title": "Any Spool Rules",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "template": {
      "type": "object",
      "title": "Template",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Configures a ProducerTemplate",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "defaultEndpoint": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the default endpoint URI used by default for sending message exchanges",
          "title": "Default Endpoint",
          "required": false,
          "deprecated": false
        },
        "maximumCacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets a custom maximum cache size to use in the backing cache pools.",
          "title": "Maximum Cache Size",
          "required": false,
          "deprecated": false
        },
        "camelContextId": {
          "kind": "attribute",
          "type": "string",
          "description": "Id of CamelContext to use if there are multiple CamelContexts in the same JVM",
          "title": "Camel Context Id",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "threadPool": {
      "type": "object",
      "title": "Thread Pool",
      "group": "spring,configuration",
      "icon": "generic24.png",
      "description": "Configuration of thread pools",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "poolSize": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the core pool size (threads to keep minimum in pool)",
          "title": "Pool Size",
          "required": true,
          "deprecated": false
        },
        "maxPoolSize": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the maximum pool size",
          "title": "Max Pool Size",
          "required": false,
          "deprecated": false
        },
        "keepAliveTime": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the keep alive time for inactive threads",
          "title": "Keep Alive Time",
          "required": false,
          "deprecated": false
        },
        "timeUnit": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "SECONDS",
          "enum": [ "DAYS", "HOURS", "MICROSECONDS", "MILLISECONDS", "MINUTES", "NANOSECONDS", "SECONDS" ],
          "description": "Sets the time unit used for keep alive time",
          "title": "Time Unit",
          "required": false,
          "deprecated": false
        },
        "maxQueueSize": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the maximum number of tasks in the work queue. Use -1 for an unbounded queue",
          "title": "Max Queue Size",
          "required": false,
          "deprecated": false
        },
        "allowCoreThreadTimeOut": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets whether to allow core threads to timeout",
          "title": "Allow Core Thread Time Out",
          "required": false,
          "deprecated": false
        },
        "rejectedPolicy": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "CallerRuns",
          "enum": [ "Abort", "CallerRuns", "Discard", "DiscardOldest" ],
          "description": "Sets the handler for tasks which cannot be executed by the thread pool.",
          "title": "Rejected Policy",
          "required": false,
          "deprecated": false
        },
        "threadName": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a custom thread name / pattern",
          "title": "Thread Name",
          "required": true,
          "deprecated": false
        },
        "scheduled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to use a scheduled thread pool",
          "title": "Scheduled",
          "required": false,
          "deprecated": false
        },
        "camelContextId": {
          "kind": "attribute",
          "type": "string",
          "description": "Id of CamelContext to use if there are multiple CamelContexts in the same JVM",
          "title": "Camel Context Id",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "threadPoolProfile": {
      "type": "object",
      "title": "Thread Pool Profile",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "To configure thread pools",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "defaultProfile": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether this profile is the default thread pool profile",
          "title": "Default Profile",
          "required": false,
          "deprecated": false
        },
        "poolSize": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the core pool size",
          "title": "Pool Size",
          "required": false,
          "deprecated": false
        },
        "maxPoolSize": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the maximum pool size",
          "title": "Max Pool Size",
          "required": false,
          "deprecated": false
        },
        "keepAliveTime": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the keep alive time for idle threads in the pool",
          "title": "Keep Alive Time",
          "required": false,
          "deprecated": false
        },
        "timeUnit": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "DAYS", "HOURS", "MICROSECONDS", "MILLISECONDS", "MINUTES", "NANOSECONDS", "SECONDS" ],
          "description": "Sets the time unit to use for keep alive time By default SECONDS is used.",
          "title": "Time Unit",
          "required": false,
          "deprecated": false
        },
        "maxQueueSize": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the maximum number of tasks in the work queue. Use -1 or Integer.MAX_VALUE for an unbounded queue",
          "title": "Max Queue Size",
          "required": false,
          "deprecated": false
        },
        "allowCoreThreadTimeOut": {
          "kind": "attribute",
          "type": "string",
          "description": "Whether idle core threads is allowed to timeout and therefore can shrink the pool size below the core pool size Is by default false",
          "title": "Allow Core Thread Time Out",
          "required": false,
          "deprecated": false
        },
        "rejectedPolicy": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "Abort", "CallerRuns", "Discard", "DiscardOldest" ],
          "description": "Sets the handler for tasks which cannot be executed by the thread pool.",
          "title": "Rejected Policy",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "threads": {
      "type": "object",
      "title": "Threads",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Specifies that all steps after this node are processed asynchronously",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "To refer to a custom thread pool or use a thread pool profile (as overlay)",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "poolSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the core pool size",
          "title": "Pool Size",
          "required": false,
          "deprecated": false
        },
        "maxPoolSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum pool size",
          "title": "Max Pool Size",
          "required": false,
          "deprecated": false
        },
        "keepAliveTime": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the keep alive time for idle threads",
          "title": "Keep Alive Time",
          "required": false,
          "deprecated": false
        },
        "timeUnit": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "DAYS", "HOURS", "MICROSECONDS", "MILLISECONDS", "MINUTES", "NANOSECONDS", "SECONDS" ],
          "description": "Sets the keep alive time unit. By default SECONDS is used.",
          "title": "Time Unit",
          "required": false,
          "deprecated": false
        },
        "maxQueueSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum number of tasks in the work queue. Use -1 or Integer.MAX_VALUE for an unbounded queue",
          "title": "Max Queue Size",
          "required": false,
          "deprecated": false
        },
        "allowCoreThreadTimeOut": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether idle core threads is allowed to timeout and therefore can shrink the pool size below the core pool size Is by default false",
          "title": "Allow Core Thread Time Out",
          "required": false,
          "deprecated": false
        },
        "threadName": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "Threads",
          "description": "Sets the thread name to use.",
          "title": "Thread Name",
          "required": false,
          "deprecated": false
        },
        "rejectedPolicy": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "Abort", "CallerRuns", "Discard", "DiscardOldest" ],
          "description": "Sets the handler for tasks which cannot be executed by the thread pool.",
          "title": "Rejected Policy",
          "required": false,
          "deprecated": false
        },
        "callerRunsWhenRejected": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not to use as caller runs as fallback when a task is rejected being added to the thread pool (when its full). This is only used as fallback if no rejectedPolicy has been configured, or the thread pool has no configured rejection handler. Is by default true",
          "title": "Caller Runs When Rejected",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "throttle": {
      "type": "object",
      "title": "Throttle",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Controls the rate at which messages are passed to the next node in the route",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to configure the maximum number of messages to throttle per request",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a custom thread pool (ScheduledExecutorService) by the throttler.",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "timePeriodMillis": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "1000",
          "description": "Sets the time period during which the maximum request count is valid for",
          "title": "Time Period Millis",
          "required": false,
          "deprecated": false
        },
        "asyncDelayed": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Enables asynchronous delay which means the thread will not block while delaying.",
          "title": "Async Delayed",
          "required": false,
          "deprecated": false
        },
        "callerRunsWhenRejected": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the caller should run the task when it was rejected by the thread pool. Is by default true",
          "title": "Caller Runs When Rejected",
          "required": false,
          "deprecated": false
        },
        "rejectExecution": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not throttler throws the ThrottlerRejectedExecutionException when the exchange exceeds the request limit Is by default false",
          "title": "Reject Execution",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "throwException": {
      "type": "object",
      "title": "Throw Exception",
      "group": "error",
      "icon": "generic24.png",
      "description": "Throws an exception",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to the exception instance to lookup from the registry to throw",
          "title": "Ref",
          "required": false,
          "deprecated": false
        },
        "message": {
          "kind": "attribute",
          "type": "string",
          "description": "To create a new exception instance and use the given message as caused message (supports simple language)",
          "title": "Message",
          "required": false,
          "deprecated": false
        },
        "exceptionType": {
          "kind": "attribute",
          "type": "string",
          "description": "The class of the exception to create using the message.",
          "title": "Exception Type",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "to": {
      "type": "object",
      "title": "To",
      "group": "eip,endpoint,routing",
      "icon": "endpoint24.png",
      "description": "Sends the message to a static endpoint",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the uri of the endpoint to send to.",
          "title": "Uri",
          "required": true,
          "deprecated": false
        },
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the reference of the endpoint to send to.",
          "title": "Ref",
          "required": false,
          "deprecated": true
        },
        "pattern": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "InOnly", "InOptionalOut", "InOut", "OutIn", "OutOnly", "OutOptionalIn", "RobustInOnly", "RobustOutOnly" ],
          "description": "Sets the optional ExchangePattern used to invoke this endpoint",
          "title": "Pattern",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "toD": {
      "type": "object",
      "title": "To D",
      "group": "eip,endpoint,routing",
      "icon": "endpoint24.png",
      "description": "Sends the message to a dynamic endpoint",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "The uri of the endpoint to send to. The uri can be dynamic computed using the org.apache.camel.language.simple.SimpleLanguage expression.",
          "title": "Uri",
          "required": true,
          "deprecated": false
        },
        "pattern": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "InOnly", "InOptionalOut", "InOut", "OutIn", "OutOnly", "OutOptionalIn", "RobustInOnly", "RobustOutOnly" ],
          "description": "Sets the optional ExchangePattern used to invoke this endpoint",
          "title": "Pattern",
          "required": false,
          "deprecated": false
        },
        "cacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum size used by the org.apache.camel.impl.ConsumerCache which is used to cache and reuse producers.",
          "title": "Cache Size",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidEndpoint": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Ignore the invalidate endpoint exception when try to create a producer with that endpoint",
          "title": "Ignore Invalid Endpoint",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "topic": {
      "type": "object",
      "title": "Topic",
      "group": "eip,routing,loadbalance",
      "icon": "generic24.png",
      "description": "Topic load balancer",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "transacted": {
      "type": "object",
      "title": "Transacted",
      "group": "configuration",
      "icon": "transactionalClient24.png",
      "description": "Enables transaction on the route",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a reference to use for lookup the policy in the registry.",
          "title": "Ref",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "transform": {
      "type": "object",
      "title": "Transform",
      "group": "eip,transformation",
      "icon": "transform24.png",
      "description": "Transforms the message body based on an expression",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to return the transformed message body (the new message body to use)",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "transformers": {
      "type": "object",
      "title": "Transformations",
      "group": "transformation",
      "icon": "generic24.png",
      "description": "To configure transformers.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "transformers": {
          "kind": "element",
          "type": "array",
          "description": "The configured transformers",
          "title": "Transformers",
          "required": true,
          "deprecated": false
        }
      }
    },
    "unmarshal": {
      "type": "object",
      "title": "Unmarshal",
      "group": "eip,transformation",
      "icon": "unmarshal24.png",
      "description": "Converts the message data received from the wire into a format that Apache Camel processors can consume",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "dataFormatType": {
          "kind": "element",
          "type": "object",
          "description": "The data format to be used",
          "title": "Data Format Type",
          "required": true,
          "deprecated": false
        },
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "To refer to a custom data format to use as unmarshaller",
          "title": "Ref",
          "required": false,
          "deprecated": true
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "validate": {
      "type": "object",
      "title": "Validate",
      "group": "eip,transformation",
      "icon": "generic24.png",
      "description": "Validates a message based on an expression",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression to use for validation as a predicate. The expression should return either true or false. If returning false the message is invalid and an exception is thrown.",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "validators": {
      "type": "object",
      "title": "Validations",
      "group": "validation",
      "icon": "generic24.png",
      "description": "To configure validators.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "validators": {
          "kind": "element",
          "type": "array",
          "description": "The configured transformers",
          "title": "Validators",
          "required": true,
          "deprecated": false
        }
      }
    },
    "weighted": {
      "type": "object",
      "title": "Weighted",
      "group": "eip,routing,loadbalance",
      "icon": "generic24.png",
      "description": "Weighted load balancer",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "roundRobin": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To enable round robin mode. By default the weighted distribution mode is used. The default value is false.",
          "title": "Round Robin",
          "required": false,
          "deprecated": false
        },
        "distributionRatio": {
          "kind": "attribute",
          "type": "string",
          "description": "The distribution ratio is a delimited String consisting on integer weights separated by delimiters for example 2,3,5. The distributionRatio must match the number of endpoints and/or processors specified in the load balancer list.",
          "title": "Distribution Ratio",
          "required": true,
          "deprecated": false
        },
        "distributionRatioDelimiter": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": ",",
          "description": "Delimiter used to specify the distribution ratio. The default value is ,",
          "title": "Distribution Ratio Delimiter",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "when": {
      "type": "object",
      "title": "When",
      "group": "eip,routing",
      "icon": "generic24.png",
      "description": "Triggers a route when an expression evaluates to true",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression used as the predicate to evaluate whether this when should trigger and route the message or not.",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "whenSkipSendToEndpoint": {
      "type": "object",
      "title": "When Skip Send To Endpoint",
      "group": "configuration",
      "icon": "generic24.png",
      "description": "Predicate to determine if the message should be sent or not to the endpoint, when using interceptSentToEndpoint.",
      "acceptInput": "true",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "expression": {
          "kind": "expression",
          "type": "object",
          "description": "Expression used as the predicate to evaluate whether the message should be sent or not to the endpoint",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "wireTap": {
      "type": "object",
      "title": "Wire Tap",
      "group": "eip,endpoint,routing",
      "icon": "wireTap24.png",
      "description": "Routes a copy of a message (or creates a new message) to a secondary destination while continue routing the original message.",
      "acceptInput": "true",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "true",
      "properties": {
        "processorRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to a Processor to use for creating a new body as the message to use for wire tapping",
          "title": "Processor Ref",
          "required": false,
          "deprecated": false
        },
        "body": {
          "kind": "expression",
          "type": "object",
          "description": "Uses the expression for creating a new body as the message to use for wire tapping",
          "title": "Body",
          "required": false,
          "deprecated": false
        },
        "executorServiceRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Uses a custom thread pool",
          "title": "Executor Service Ref",
          "required": false,
          "deprecated": false
        },
        "copy": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Uses a copy of the original exchange",
          "title": "Copy",
          "required": false,
          "deprecated": false
        },
        "dynamicUri": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether the uri is dynamic or static. If the uri is dynamic then the simple language is used to evaluate a dynamic uri to use as the wire-tap destination, for each incoming message. This works similar to how the toD EIP pattern works. If static then the uri is used as-is as the wire-tap destination.",
          "title": "Dynamic Uri",
          "required": false,
          "deprecated": false
        },
        "onPrepareRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Uses the Processor when preparing the org.apache.camel.Exchange to be send. This can be used to deep-clone messages that should be send, or any custom logic needed before the exchange is send.",
          "title": "On Prepare Ref",
          "required": false,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "The uri of the endpoint to send to. The uri can be dynamic computed using the org.apache.camel.language.simple.SimpleLanguage expression.",
          "title": "Uri",
          "required": true,
          "deprecated": false
        },
        "pattern": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "InOnly", "InOptionalOut", "InOut", "OutIn", "OutOnly", "OutOptionalIn", "RobustInOnly", "RobustOutOnly" ],
          "description": "Sets the optional ExchangePattern used to invoke this endpoint",
          "title": "Pattern",
          "required": false,
          "deprecated": false
        },
        "cacheSize": {
          "kind": "attribute",
          "type": "integer",
          "description": "Sets the maximum size used by the org.apache.camel.impl.ConsumerCache which is used to cache and reuse producers.",
          "title": "Cache Size",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidEndpoint": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Ignore the invalidate endpoint exception when try to create a producer with that endpoint",
          "title": "Ignore Invalid Endpoint",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "zookeeperServiceDiscovery": {
      "type": "object",
      "title": "Zookeeper Service Discovery",
      "group": "routing,cloud,service-discovery",
      "icon": "generic24.png",
      "description": "",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "nodes": {
          "kind": "attribute",
          "type": "string",
          "description": "A comma separate list of servers to connect to in the form host:port",
          "title": "Nodes",
          "required": true,
          "deprecated": false
        },
        "namespace": {
          "kind": "attribute",
          "type": "string",
          "description": "As ZooKeeper is a shared space, users of a given cluster should stay within a pre-defined namespace. If a namespace is set here, all paths will get pre-pended with the namespace",
          "title": "Namespace",
          "required": false,
          "deprecated": false
        },
        "reconnectBaseSleepTime": {
          "kind": "attribute",
          "type": "string",
          "description": "Initial amount of time to wait between retries.",
          "title": "Reconnect Base Sleep Time",
          "required": false,
          "deprecated": false
        },
        "reconnectMaxSleepTime": {
          "kind": "attribute",
          "type": "string",
          "description": "Max time in ms to sleep on each retry",
          "title": "Reconnect Max Sleep Time",
          "required": false,
          "deprecated": false
        },
        "reconnectMaxRetries": {
          "kind": "attribute",
          "type": "integer",
          "description": "Max number of times to retry",
          "title": "Reconnect Max Retries",
          "required": false,
          "deprecated": false
        },
        "sessionTimeout": {
          "kind": "attribute",
          "type": "string",
          "description": "Session timeout.",
          "title": "Session Timeout",
          "required": false,
          "deprecated": false
        },
        "connectionTimeout": {
          "kind": "attribute",
          "type": "string",
          "description": "Connection timeout.",
          "title": "Connection Timeout",
          "required": false,
          "deprecated": false
        },
        "basePath": {
          "kind": "attribute",
          "type": "string",
          "description": "Set the base path to store in ZK",
          "title": "Base Path",
          "required": true,
          "deprecated": false
        },
        "properties": {
          "kind": "element",
          "type": "array",
          "description": "Set client properties to use. These properties are specific to what service call implementation are in use. For example if using ribbon, then the client properties are define in com.netflix.client.config.CommonClientConfigKey.",
          "title": "Properties",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    }
  },
  "rests": {
    "delete": {
      "type": "object",
      "title": "Delete",
      "group": "rest",
      "icon": "generic24.png",
      "description": "Rest DELETE command",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "The HTTP verb such as GET, POST, DELETE, etc.",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Uri template of this REST service such as /id.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "auto",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "outType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Out Type",
          "required": false,
          "deprecated": false
        },
        "toOrRoute": {
          "kind": "element",
          "type": "object",
          "description": "To route from this REST service to a Camel endpoint, or an inlined route",
          "title": "To Or Route",
          "required": true,
          "deprecated": false
        },
        "routeId": {
          "kind": "attribute",
          "type": "string",
          "description": "The route id this rest-dsl is using (read-only)",
          "title": "Route Id",
          "required": false,
          "deprecated": false
        },
        "apiDocs": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include or exclude the VerbDefinition in API documentation. The default value is true.",
          "title": "Api Docs",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "get": {
      "type": "object",
      "title": "Get",
      "group": "rest",
      "icon": "generic24.png",
      "description": "Rest GET command",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "The HTTP verb such as GET, POST, DELETE, etc.",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Uri template of this REST service such as /id.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "auto",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "outType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Out Type",
          "required": false,
          "deprecated": false
        },
        "toOrRoute": {
          "kind": "element",
          "type": "object",
          "description": "To route from this REST service to a Camel endpoint, or an inlined route",
          "title": "To Or Route",
          "required": true,
          "deprecated": false
        },
        "routeId": {
          "kind": "attribute",
          "type": "string",
          "description": "The route id this rest-dsl is using (read-only)",
          "title": "Route Id",
          "required": false,
          "deprecated": false
        },
        "apiDocs": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include or exclude the VerbDefinition in API documentation. The default value is true.",
          "title": "Api Docs",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "head": {
      "type": "object",
      "title": "Head",
      "group": "rest",
      "icon": "generic24.png",
      "description": "Rest HEAD command",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "The HTTP verb such as GET, POST, DELETE, etc.",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Uri template of this REST service such as /id.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "auto",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "outType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Out Type",
          "required": false,
          "deprecated": false
        },
        "toOrRoute": {
          "kind": "element",
          "type": "object",
          "description": "To route from this REST service to a Camel endpoint, or an inlined route",
          "title": "To Or Route",
          "required": true,
          "deprecated": false
        },
        "routeId": {
          "kind": "attribute",
          "type": "string",
          "description": "The route id this rest-dsl is using (read-only)",
          "title": "Route Id",
          "required": false,
          "deprecated": false
        },
        "apiDocs": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include or exclude the VerbDefinition in API documentation. The default value is true.",
          "title": "Api Docs",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "options": {
      "type": "object",
      "title": "Options",
      "group": "rest",
      "icon": "generic24.png",
      "description": "Rest OPTIONS command",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "The HTTP verb such as GET, POST, DELETE, etc.",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Uri template of this REST service such as /id.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "auto",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "outType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Out Type",
          "required": false,
          "deprecated": false
        },
        "toOrRoute": {
          "kind": "element",
          "type": "object",
          "description": "To route from this REST service to a Camel endpoint, or an inlined route",
          "title": "To Or Route",
          "required": true,
          "deprecated": false
        },
        "routeId": {
          "kind": "attribute",
          "type": "string",
          "description": "The route id this rest-dsl is using (read-only)",
          "title": "Route Id",
          "required": false,
          "deprecated": false
        },
        "apiDocs": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include or exclude the VerbDefinition in API documentation. The default value is true.",
          "title": "Api Docs",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "param": {
      "type": "object",
      "title": "Param",
      "group": "rest",
      "icon": "generic24.png",
      "description": "To specify the rest operation parameters using Swagger.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "name": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Swagger Parameter name.",
          "title": "Name",
          "required": true,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "path",
          "enum": [ "body", "formData", "header", "path", "query" ],
          "description": "Sets the Swagger Parameter type.",
          "title": "Type",
          "required": true,
          "deprecated": false
        },
        "defaultValue": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Swagger Parameter default value.",
          "title": "Default Value",
          "required": false,
          "deprecated": false
        },
        "required": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Sets the Swagger Parameter required flag.",
          "title": "Required",
          "required": false,
          "deprecated": false
        },
        "collectionFormat": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "csv",
          "enum": [ "csv", "multi", "pipes", "ssv", "tsv" ],
          "description": "Sets the Swagger Parameter collection format.",
          "title": "Collection Format",
          "required": false,
          "deprecated": false
        },
        "arrayType": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "string",
          "description": "Sets the Swagger Parameter array type. Required if data type is array. Describes the type of items in the array.",
          "title": "Array Type",
          "required": false,
          "deprecated": false
        },
        "dataType": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "string",
          "description": "Sets the Swagger Parameter data type.",
          "title": "Data Type",
          "required": false,
          "deprecated": false
        },
        "dataFormat": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Swagger Parameter data format.",
          "title": "Data Format",
          "required": false,
          "deprecated": false
        },
        "value": {
          "kind": "element",
          "type": "array",
          "description": "Sets the Swagger Parameter list of allowable values (enum).",
          "title": "Value",
          "required": false,
          "deprecated": false
        },
        "access": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Swagger Parameter paramAccess flag.",
          "title": "Access",
          "required": false,
          "deprecated": false
        },
        "examples": {
          "kind": "element",
          "type": "array",
          "description": "Sets the Swagger Parameter examples.",
          "title": "Examples",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Swagger Parameter description.",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "patch": {
      "type": "object",
      "title": "Patch",
      "group": "rest",
      "icon": "generic24.png",
      "description": "Rest PATCH command",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "The HTTP verb such as GET, POST, DELETE, etc.",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Uri template of this REST service such as /id.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "auto",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "outType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Out Type",
          "required": false,
          "deprecated": false
        },
        "toOrRoute": {
          "kind": "element",
          "type": "object",
          "description": "To route from this REST service to a Camel endpoint, or an inlined route",
          "title": "To Or Route",
          "required": true,
          "deprecated": false
        },
        "routeId": {
          "kind": "attribute",
          "type": "string",
          "description": "The route id this rest-dsl is using (read-only)",
          "title": "Route Id",
          "required": false,
          "deprecated": false
        },
        "apiDocs": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include or exclude the VerbDefinition in API documentation. The default value is true.",
          "title": "Api Docs",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "post": {
      "type": "object",
      "title": "Post",
      "group": "rest",
      "icon": "generic24.png",
      "description": "Rest POST command",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "The HTTP verb such as GET, POST, DELETE, etc.",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Uri template of this REST service such as /id.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "auto",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "outType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Out Type",
          "required": false,
          "deprecated": false
        },
        "toOrRoute": {
          "kind": "element",
          "type": "object",
          "description": "To route from this REST service to a Camel endpoint, or an inlined route",
          "title": "To Or Route",
          "required": true,
          "deprecated": false
        },
        "routeId": {
          "kind": "attribute",
          "type": "string",
          "description": "The route id this rest-dsl is using (read-only)",
          "title": "Route Id",
          "required": false,
          "deprecated": false
        },
        "apiDocs": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include or exclude the VerbDefinition in API documentation. The default value is true.",
          "title": "Api Docs",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "put": {
      "type": "object",
      "title": "Put",
      "group": "rest",
      "icon": "generic24.png",
      "description": "Rest PUT command",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "The HTTP verb such as GET, POST, DELETE, etc.",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Uri template of this REST service such as /id.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "auto",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "outType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Out Type",
          "required": false,
          "deprecated": false
        },
        "toOrRoute": {
          "kind": "element",
          "type": "object",
          "description": "To route from this REST service to a Camel endpoint, or an inlined route",
          "title": "To Or Route",
          "required": true,
          "deprecated": false
        },
        "routeId": {
          "kind": "attribute",
          "type": "string",
          "description": "The route id this rest-dsl is using (read-only)",
          "title": "Route Id",
          "required": false,
          "deprecated": false
        },
        "apiDocs": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include or exclude the VerbDefinition in API documentation. The default value is true.",
          "title": "Api Docs",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "responseHeader": {
      "type": "object",
      "title": "Response Header",
      "group": "rest",
      "icon": "generic24.png",
      "description": "To specify the rest operation response headers using Swagger.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "name": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of the parameter. This option is mandatory.",
          "title": "Name",
          "required": true,
          "deprecated": false
        },
        "collectionFormat": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "csv",
          "enum": [ "csv", "multi", "pipes", "ssv", "tsv" ],
          "description": "Sets the Swagger Parameter collection format.",
          "title": "Collection Format",
          "required": false,
          "deprecated": false
        },
        "arrayType": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "string",
          "description": "Sets the Swagger Parameter array type. Required if data type is array. Describes the type of items in the array.",
          "title": "Array Type",
          "required": false,
          "deprecated": false
        },
        "dataType": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "string",
          "description": "Sets the Swagger header data type.",
          "title": "Data Type",
          "required": false,
          "deprecated": false
        },
        "dataFormat": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Swagger Parameter data format.",
          "title": "Data Format",
          "required": false,
          "deprecated": false
        },
        "value": {
          "kind": "element",
          "type": "array",
          "description": "Sets the Swagger Parameter list of allowable values.",
          "title": "Value",
          "required": false,
          "deprecated": false
        },
        "example": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the Swagger example",
          "title": "Example",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "attribute",
          "type": "string",
          "description": "Description of the parameter.",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "responseMessage": {
      "type": "object",
      "title": "Response Message",
      "group": "rest",
      "icon": "generic24.png",
      "description": "To specify the rest operation response messages using Swagger.",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "code": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "200",
          "description": "The response code such as a HTTP status code",
          "title": "Code",
          "required": false,
          "deprecated": false
        },
        "message": {
          "kind": "attribute",
          "type": "string",
          "description": "The response message (description)",
          "title": "Message",
          "required": true,
          "deprecated": false
        },
        "responseModel": {
          "kind": "attribute",
          "type": "string",
          "description": "The response model",
          "title": "Response Model",
          "required": false,
          "deprecated": false
        },
        "header": {
          "kind": "element",
          "type": "array",
          "description": "Adds a response header",
          "title": "Header",
          "required": false,
          "deprecated": false
        },
        "examples": {
          "kind": "element",
          "type": "array",
          "description": "Examples of response messages",
          "title": "Examples",
          "required": false,
          "deprecated": false
        }
      }
    },
    "rest": {
      "type": "object",
      "title": "Rest",
      "group": "rest",
      "icon": "generic24.png",
      "description": "Defines a rest service using the rest-dsl",
      "acceptInput": "false",
      "acceptOutput": "true",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "path": {
          "kind": "attribute",
          "type": "string",
          "description": "Path of the rest service, such as /foo",
          "title": "Path",
          "required": false,
          "deprecated": false
        },
        "tag": {
          "kind": "attribute",
          "type": "string",
          "description": "To configure a special tag for the operations within this rest definition.",
          "title": "Tag",
          "required": false,
          "deprecated": false
        },
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "auto",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "apiDocs": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include or exclude the VerbDefinition in API documentation. This option will override what may be configured on a parent level The default value is true.",
          "title": "Api Docs",
          "required": false,
          "deprecated": false
        },
        "verbs": {
          "kind": "element",
          "type": "array",
          "description": "The HTTP verbs this REST service accepts and uses",
          "title": "Verbs",
          "required": true,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "restBinding": {
      "type": "object",
      "title": "Rest Binding",
      "group": "rest",
      "icon": "generic24.png",
      "description": "To configure rest binding",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "off",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. The default value is off",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from input to POJO for the incoming data The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "outType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from POJO to output for the outgoing data The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Out Type",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do.",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "component": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the component name that this definition will apply to",
          "title": "Component",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "restConfiguration": {
      "type": "object",
      "title": "Rest Configuration",
      "group": "rest",
      "icon": "generic24.png",
      "description": "To configure rest",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "component": {
          "kind": "attribute",
          "type": "string",
          "description": "The Camel Rest component to use for the REST transport (consumer), such as restlet, spark-rest. If no component has been explicit configured, then Camel will lookup if there is a Camel component that integrates with the Rest DSL, or if a org.apache.camel.spi.RestConsumerFactory is registered in the registry. If either one is found, then that is being used.",
          "title": "Component",
          "required": false,
          "deprecated": false
        },
        "apiComponent": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "swagger",
          "description": "The name of the Camel component to use as the REST API (such as swagger)",
          "title": "Api Component",
          "required": false,
          "deprecated": false
        },
        "producerComponent": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the name of the Camel component to use as the REST producer",
          "title": "Producer Component",
          "required": false,
          "deprecated": false
        },
        "scheme": {
          "kind": "attribute",
          "type": "string",
          "description": "The scheme to use for exposing the REST service. Usually http or https is supported. The default value is http",
          "title": "Scheme",
          "required": false,
          "deprecated": false
        },
        "host": {
          "kind": "attribute",
          "type": "string",
          "description": "The hostname to use for exposing the REST service.",
          "title": "Host",
          "required": false,
          "deprecated": false
        },
        "apiHost": {
          "kind": "attribute",
          "type": "string",
          "description": "To use an specific hostname for the API documentation (eg swagger) This can be used to override the generated host with this configured hostname",
          "title": "Api Host",
          "required": false,
          "deprecated": false
        },
        "port": {
          "kind": "attribute",
          "type": "string",
          "description": "The port number to use for exposing the REST service. Notice if you use servlet component then the port number configured here does not apply, as the port number in use is the actual port number the servlet component is using. eg if using Apache Tomcat its the tomcat http port, if using Apache Karaf its the HTTP service in Karaf that uses port 8181 by default etc. Though in those situations setting the port number here, allows tooling and JMX to know the port number, so its recommended to set the port number to the number that the servlet engine uses.",
          "title": "Port",
          "required": false,
          "deprecated": false
        },
        "producerApiDoc": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the location of the api document (swagger api) the REST producer will use to validate the REST uri and query parameters are valid accordingly to the api document. This requires adding camel-swagger-java to the classpath, and any miss configuration will let Camel fail on startup and report the error(s). The location of the api document is loaded from classpath by default, but you can use file: or http: to refer to resources to load from file or http url.",
          "title": "Producer Api Doc",
          "required": false,
          "deprecated": false
        },
        "contextPath": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a leading context-path the REST services will be using. This can be used when using components such as camel-servlet where the deployed web application is deployed using a context-path. Or for components such as camel-jetty or camel-netty4-http that includes a HTTP server.",
          "title": "Context Path",
          "required": false,
          "deprecated": false
        },
        "apiContextPath": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets a leading API context-path the REST API services will be using. This can be used when using components such as camel-servlet where the deployed web application is deployed using a context-path.",
          "title": "Api Context Path",
          "required": false,
          "deprecated": false
        },
        "apiContextRouteId": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the route id to use for the route that services the REST API. The route will by default use an auto assigned route id.",
          "title": "Api Context Route Id",
          "required": false,
          "deprecated": false
        },
        "apiContextIdPattern": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets an CamelContext id pattern to only allow Rest APIs from rest services within CamelContext's which name matches the pattern. The pattern name refers to the CamelContext name, to match on the current CamelContext only. For any other value, the pattern uses the rules from link org.apache.camel.util.EndpointHelpermatchPattern(String, String)",
          "title": "Api Context Id Pattern",
          "required": false,
          "deprecated": false
        },
        "apiContextListing": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Sets whether listing of all available CamelContext's with REST services in the JVM is enabled. If enabled it allows to discover these contexts, if false then only the current CamelContext is in use.",
          "title": "Api Context Listing",
          "required": false,
          "deprecated": false
        },
        "apiVendorExtension": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether vendor extension is enabled in the Rest APIs. If enabled then Camel will include additional information as vendor extension (eg keys starting with x-) such as route ids, class names etc. Not all 3rd party API gateways and tools supports vendor-extensions when importing your API docs.",
          "title": "Api Vendor Extension",
          "required": false,
          "deprecated": false
        },
        "hostNameResolver": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "allLocalIp", "localHostName", "localIp" ],
          "description": "If no hostname has been explicit configured, then this resolver is used to compute the hostname the REST service will be using.",
          "title": "Host Name Resolver",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "off",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. The default value is off",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do.",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "jsonDataFormat": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of specific json data format to use. By default json-jackson will be used. Important: This option is only for setting a custom name of the data format, not to refer to an existing data format instance.",
          "title": "Json Data Format",
          "required": false,
          "deprecated": false
        },
        "xmlDataFormat": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of specific XML data format to use. By default jaxb will be used. Important: This option is only for setting a custom name of the data format, not to refer to an existing data format instance.",
          "title": "Xml Data Format",
          "required": false,
          "deprecated": false
        },
        "componentProperty": {
          "kind": "element",
          "type": "array",
          "description": "Allows to configure as many additional properties for the rest component in use.",
          "title": "Component Property",
          "required": false,
          "deprecated": false
        },
        "endpointProperty": {
          "kind": "element",
          "type": "array",
          "description": "Allows to configure as many additional properties for the rest endpoint in use.",
          "title": "Endpoint Property",
          "required": false,
          "deprecated": false
        },
        "consumerProperty": {
          "kind": "element",
          "type": "array",
          "description": "Allows to configure as many additional properties for the rest consumer in use.",
          "title": "Consumer Property",
          "required": false,
          "deprecated": false
        },
        "dataFormatProperty": {
          "kind": "element",
          "type": "array",
          "description": "Allows to configure as many additional properties for the data formats in use. For example set property prettyPrint to true to have json outputted in pretty mode. The properties can be prefixed to denote the option is only for either JSON or XML and for either the IN or the OUT. The prefixes are: json.in. json.out. xml.in. xml.out. For example a key with value xml.out.mustBeJAXBElement is only for the XML data format for the outgoing. A key without a prefix is a common key for all situations.",
          "title": "Data Format Property",
          "required": false,
          "deprecated": false
        },
        "apiProperty": {
          "kind": "element",
          "type": "array",
          "description": "Allows to configure as many additional properties for the api documentation (swagger). For example set property api.title to my cool stuff",
          "title": "Api Property",
          "required": false,
          "deprecated": false
        },
        "corsHeaders": {
          "kind": "element",
          "type": "array",
          "description": "Allows to configure custom CORS headers.",
          "title": "Cors Headers",
          "required": false,
          "deprecated": false
        }
      }
    },
    "restContext": {
      "type": "object",
      "title": "Rest Context",
      "group": "spring,configuration,rest",
      "icon": "generic24.png",
      "description": "Configuration of REST services using rest-dsl using XML",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "rest": {
          "kind": "element",
          "type": "array",
          "description": "Contains the rest services defined using the rest-dsl",
          "title": "Rest",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "restContextRef": {
      "type": "object",
      "title": "Rest Context Ref",
      "group": "configuration,rest",
      "icon": "generic24.png",
      "description": "To refer to an XML file with rest services defined using the rest-dsl",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to the rest-dsl",
          "title": "Ref",
          "required": true,
          "deprecated": false
        }
      }
    },
    "restProperty": {
      "type": "object",
      "title": "Rest Property",
      "group": "rest",
      "icon": "generic24.png",
      "description": "A key value pair",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "key": {
          "kind": "attribute",
          "type": "string",
          "description": "Property key",
          "title": "Key",
          "required": true,
          "deprecated": false
        },
        "value": {
          "kind": "attribute",
          "type": "string",
          "description": "Property value",
          "title": "Value",
          "required": true,
          "deprecated": false
        }
      }
    },
    "rests": {
      "type": "object",
      "title": "Rests",
      "group": "rest",
      "icon": "generic24.png",
      "description": "A series of rest services defined using the rest-dsl",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "rests": {
          "kind": "element",
          "type": "array",
          "description": "Contains the rest services defined using the rest-dsl",
          "title": "Rests",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    },
    "verb": {
      "type": "object",
      "title": "Verb",
      "group": "rest",
      "icon": "generic24.png",
      "description": "Rest command",
      "acceptInput": "false",
      "acceptOutput": "false",
      "nextSiblingAddedAsChild": "false",
      "properties": {
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "The HTTP verb such as GET, POST, DELETE, etc.",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "uri": {
          "kind": "attribute",
          "type": "string",
          "description": "Uri template of this REST service such as /id.",
          "title": "Uri",
          "required": false,
          "deprecated": false
        },
        "consumes": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service consumes (accept as input), such as application/xml or application/json. This option will override what may be configured on a parent level",
          "title": "Consumes",
          "required": false,
          "deprecated": false
        },
        "produces": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the content type what the REST service produces (uses for output), such as application/xml or application/json This option will override what may be configured on a parent level",
          "title": "Produces",
          "required": false,
          "deprecated": false
        },
        "bindingMode": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "auto",
          "enum": [ "auto", "json", "json_xml", "off", "xml" ],
          "description": "Sets the binding mode to use. This option will override what may be configured on a parent level The default value is auto",
          "title": "Binding Mode",
          "required": false,
          "deprecated": false
        },
        "skipBindingOnErrorCode": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip binding on output if there is a custom HTTP error code header. This allows to build custom error messages that do not bind to json / xml etc, as success messages otherwise will do. This option will override what may be configured on a parent level",
          "title": "Skip Binding On Error Code",
          "required": false,
          "deprecated": false
        },
        "enableCORS": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable CORS headers in the HTTP response. This option will override what may be configured on a parent level The default value is false.",
          "title": "Enable C O R S",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from input to POJO for the incoming data This option will override what may be configured on a parent level. The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "outType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name to use for binding from POJO to output for the outgoing data This option will override what may be configured on a parent level The canonical name of the class of the input data. Append a to the end of the canonical name if you want the input to be an array type.",
          "title": "Out Type",
          "required": false,
          "deprecated": false
        },
        "toOrRoute": {
          "kind": "element",
          "type": "object",
          "description": "To route from this REST service to a Camel endpoint, or an inlined route",
          "title": "To Or Route",
          "required": true,
          "deprecated": false
        },
        "routeId": {
          "kind": "attribute",
          "type": "string",
          "description": "The route id this rest-dsl is using (read-only)",
          "title": "Route Id",
          "required": false,
          "deprecated": false
        },
        "apiDocs": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include or exclude the VerbDefinition in API documentation. The default value is true.",
          "title": "Api Docs",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        },
        "description": {
          "kind": "element",
          "type": "object",
          "description": "Sets the description of this node",
          "title": "Description",
          "required": false,
          "deprecated": false
        }
      }
    }
  },
  "dataformats": {
    "asn1": {
      "type": "object",
      "title": "ASN.1 File",
      "group": "dataformat,transformation,file",
      "icon": "generic24.png",
      "description": "The ASN.1 data format is used for file transfer with telecommunications protocols.",
      "properties": {
        "usingIterator": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the asn1 file has more then one entry, the setting this option to true, allows to work with the splitter EIP, to split the data using an iterator in a streaming mode.",
          "title": "Using Iterator",
          "required": false,
          "deprecated": false
        },
        "clazzName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of class to use when unmarshalling",
          "title": "Clazz Name",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "avro": {
      "type": "object",
      "title": "Avro",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "The Avro data format is used for serialization and deserialization of messages using Apache Avro binary dataformat.",
      "properties": {
        "instanceClassName": {
          "kind": "attribute",
          "type": "string",
          "description": "Class name to use for marshal and unmarshalling",
          "title": "Instance Class Name",
          "required": true,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "barcode": {
      "type": "object",
      "title": "Barcode",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "The Barcode data format is used for creating barccode images (such as QR-Code)",
      "properties": {
        "width": {
          "kind": "attribute",
          "type": "integer",
          "description": "Width of the barcode",
          "title": "Width",
          "required": false,
          "deprecated": false
        },
        "height": {
          "kind": "attribute",
          "type": "integer",
          "description": "Height of the barcode",
          "title": "Height",
          "required": false,
          "deprecated": false
        },
        "imageType": {
          "kind": "attribute",
          "type": "string",
          "description": "Image type of the barcode such as png",
          "title": "Image Type",
          "required": false,
          "deprecated": false
        },
        "barcodeFormat": {
          "kind": "attribute",
          "type": "string",
          "description": "Barcode format such as QR-Code",
          "title": "Barcode Format",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "base64": {
      "type": "object",
      "title": "Base64",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "The Base64 data format is used for base64 encoding and decoding.",
      "properties": {
        "lineLength": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "76",
          "description": "To specific a maximum line length for the encoded data. By default 76 is used.",
          "title": "Line Length",
          "required": false,
          "deprecated": false
        },
        "lineSeparator": {
          "kind": "attribute",
          "type": "string",
          "description": "The line separators to use. Uses new line characters (CRLF) by default.",
          "title": "Line Separator",
          "required": false,
          "deprecated": false
        },
        "urlSafe": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Instead of emitting '' and '/' we emit '-' and '_' respectively. urlSafe is only applied to encode operations. Decoding seamlessly handles both modes. Is by default false.",
          "title": "Url Safe",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "beanio": {
      "type": "object",
      "title": "BeanIO",
      "group": "dataformat,transformation,csv",
      "icon": "generic24.png",
      "description": "The BeanIO data format is used for working with flat payloads (such as CSV, delimited, or fixed length formats).",
      "properties": {
        "mapping": {
          "kind": "attribute",
          "type": "string",
          "description": "The BeanIO mapping file. Is by default loaded from the classpath. You can prefix with file:, http:, or classpath: to denote from where to load the mapping file.",
          "title": "Mapping",
          "required": true,
          "deprecated": false
        },
        "streamName": {
          "kind": "attribute",
          "type": "string",
          "description": "The name of the stream to use.",
          "title": "Stream Name",
          "required": true,
          "deprecated": false
        },
        "ignoreUnidentifiedRecords": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to ignore unidentified records.",
          "title": "Ignore Unidentified Records",
          "required": false,
          "deprecated": false
        },
        "ignoreUnexpectedRecords": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to ignore unexpected records.",
          "title": "Ignore Unexpected Records",
          "required": false,
          "deprecated": false
        },
        "ignoreInvalidRecords": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to ignore invalid records.",
          "title": "Ignore Invalid Records",
          "required": false,
          "deprecated": false
        },
        "encoding": {
          "kind": "attribute",
          "type": "string",
          "description": "The charset to use. Is by default the JVM platform default charset.",
          "title": "Encoding",
          "required": false,
          "deprecated": false
        },
        "beanReaderErrorHandlerType": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a custom org.apache.camel.dataformat.beanio.BeanIOErrorHandler as error handler while parsing. Configure the fully qualified class name of the error handler. Notice the options ignoreUnidentifiedRecords, ignoreUnexpectedRecords, and ignoreInvalidRecords may not be in use when you use a custom error handler.",
          "title": "Bean Reader Error Handler Type",
          "required": false,
          "deprecated": false
        },
        "unmarshalSingleObject": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "This options controls whether to unmarshal as a list of objects or as a single object only. The former is the default mode, and the latter is only intended in special use-cases where beanio maps the Camel message to a single POJO bean.",
          "title": "Unmarshal Single Object",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "bindy": {
      "type": "object",
      "title": "Bindy",
      "group": "dataformat,transformation,csv",
      "icon": "generic24.png",
      "description": "The Bindy data format is used for working with flat payloads (such as CSV, delimited, fixed length formats, or FIX messages).",
      "properties": {
        "type": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "Csv", "Fixed", "KeyValue" ],
          "description": "Whether to use csv, fixed or key value pairs mode.",
          "title": "Type",
          "required": true,
          "deprecated": false
        },
        "classType": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of model class to use.",
          "title": "Class Type",
          "required": false,
          "deprecated": false
        },
        "locale": {
          "kind": "attribute",
          "type": "string",
          "description": "To configure a default locale to use, such as us for united states. To use the JVM platform default locale then use the name default",
          "title": "Locale",
          "required": false,
          "deprecated": false
        },
        "unwrapSingleInstance": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "When unmarshalling should a single instance be unwrapped and returned instead of wrapped in a java.util.List.",
          "title": "Unwrap Single Instance",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "boon": {
      "type": "object",
      "title": "Boon",
      "group": "dataformat,transformation,json",
      "icon": "generic24.png",
      "description": "Boon data format is used for unmarshal a JSon payload to POJO or to marshal POJO back to JSon payload.",
      "properties": {
        "unmarshalTypeName": {
          "kind": "attribute",
          "type": "string",
          "description": "Class name of the java type to use when unarmshalling",
          "title": "Unmarshal Type Name",
          "required": true,
          "deprecated": false
        },
        "useList": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To unarmshal to a List of Map or a List of Pojo.",
          "title": "Use List",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "castor": {
      "type": "object",
      "title": "Castor",
      "group": "dataformat,transformation,xml",
      "icon": "generic24.png",
      "description": "Castor data format is used for unmarshal a XML payload to POJO or to marshal POJO back to XML payload.",
      "properties": {
        "mappingFile": {
          "kind": "attribute",
          "type": "string",
          "description": "Path to a Castor mapping file to load from the classpath.",
          "title": "Mapping File",
          "required": false,
          "deprecated": false
        },
        "whitelistEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Define if Whitelist feature is enabled or not",
          "title": "Whitelist Enabled",
          "required": false,
          "deprecated": false
        },
        "allowedUnmarshallObjects": {
          "kind": "attribute",
          "type": "string",
          "description": "Define the allowed objects to be unmarshalled. You can specify the FQN class name of allowed objects, and you can use comma to separate multiple entries. It is also possible to use wildcards and regular expression which is based on the pattern defined by link org.apache.camel.util.EndpointHelpermatchPattern(String, String). Denied objects takes precedence over allowed objects.",
          "title": "Allowed Unmarshall Objects",
          "required": false,
          "deprecated": false
        },
        "deniedUnmarshallObjects": {
          "kind": "attribute",
          "type": "string",
          "description": "Define the denied objects to be unmarshalled. You can specify the FQN class name of deined objects, and you can use comma to separate multiple entries. It is also possible to use wildcards and regular expression which is based on the pattern defined by link org.apache.camel.util.EndpointHelpermatchPattern(String, String). Denied objects takes precedence over allowed objects.",
          "title": "Denied Unmarshall Objects",
          "required": false,
          "deprecated": false
        },
        "validation": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether validation is turned on or off. Is by default true.",
          "title": "Validation",
          "required": false,
          "deprecated": false
        },
        "encoding": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "UTF-8",
          "description": "Encoding to use when marshalling an Object to XML. Is by default UTF-8",
          "title": "Encoding",
          "required": false,
          "deprecated": false
        },
        "packages": {
          "kind": "attribute",
          "type": "array",
          "description": "Add additional packages to Castor XmlContext",
          "title": "Packages",
          "required": false,
          "deprecated": false
        },
        "classes": {
          "kind": "attribute",
          "type": "array",
          "description": "Add additional class names to Castor XmlContext",
          "title": "Classes",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "crypto": {
      "type": "object",
      "title": "Crypto (Java Cryptographic Extension)",
      "group": "dataformat,transformation,security",
      "icon": "generic24.png",
      "description": "Crypto data format is used for encrypting and decrypting of messages using Java Cryptographic Extension.",
      "properties": {
        "algorithm": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "DES/CBC/PKCS5Padding",
          "description": "The JCE algorithm name indicating the cryptographic algorithm that will be used. Is by default DES/CBC/PKCS5Padding.",
          "title": "Algorithm",
          "required": false,
          "deprecated": false
        },
        "cryptoProvider": {
          "kind": "attribute",
          "type": "string",
          "description": "The name of the JCE Security Provider that should be used.",
          "title": "Crypto Provider",
          "required": false,
          "deprecated": false
        },
        "keyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to the secret key to lookup from the register to use.",
          "title": "Key Ref",
          "required": false,
          "deprecated": false
        },
        "initVectorRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a byte array containing the Initialization Vector that will be used to initialize the Cipher.",
          "title": "Init Vector Ref",
          "required": false,
          "deprecated": false
        },
        "algorithmParameterRef": {
          "kind": "attribute",
          "type": "string",
          "description": "A JCE AlgorithmParameterSpec used to initialize the Cipher. Will lookup the type using the given name as a java.security.spec.AlgorithmParameterSpec type.",
          "title": "Algorithm Parameter Ref",
          "required": false,
          "deprecated": false
        },
        "buffersize": {
          "kind": "attribute",
          "type": "integer",
          "description": "The size of the buffer used in the signature process.",
          "title": "Buffersize",
          "required": false,
          "deprecated": false
        },
        "macAlgorithm": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "HmacSHA1",
          "description": "The JCE algorithm name indicating the Message Authentication algorithm.",
          "title": "Mac Algorithm",
          "required": false,
          "deprecated": false
        },
        "shouldAppendHMAC": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Flag indicating that a Message Authentication Code should be calculated and appended to the encrypted data.",
          "title": "Should Append H M A C",
          "required": false,
          "deprecated": false
        },
        "inline": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Flag indicating that the configured IV should be inlined into the encrypted data stream. Is by default false.",
          "title": "Inline",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "csv": {
      "type": "object",
      "title": "CSV",
      "group": "dataformat,transformation,csv",
      "icon": "generic24.png",
      "description": "The CSV data format is used for handling CSV payloads.",
      "properties": {
        "formatRef": {
          "kind": "attribute",
          "type": "string",
          "description": "The reference format to use, it will be updated with the other format options, the default value is CSVFormat.DEFAULT",
          "title": "Format Ref",
          "required": false,
          "deprecated": false
        },
        "formatName": {
          "kind": "attribute",
          "type": "string",
          "enum": [ "DEFAULT", "EXCEL", "INFORMIX_UNLOAD", "INFORMIX_UNLOAD_CSV", "MYSQL", "RFC4180" ],
          "description": "The name of the format to use, the default value is CSVFormat.DEFAULT",
          "title": "Format Name",
          "required": false,
          "deprecated": false
        },
        "commentMarkerDisabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Disables the comment marker of the reference format.",
          "title": "Comment Marker Disabled",
          "required": false,
          "deprecated": false
        },
        "commentMarker": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the comment marker of the reference format.",
          "title": "Comment Marker",
          "required": false,
          "deprecated": false
        },
        "delimiter": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the delimiter to use. The default value is , (comma)",
          "title": "Delimiter",
          "required": false,
          "deprecated": false
        },
        "escapeDisabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Use for disabling using escape character",
          "title": "Escape Disabled",
          "required": false,
          "deprecated": false
        },
        "escape": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the escape character to use",
          "title": "Escape",
          "required": false,
          "deprecated": false
        },
        "headerDisabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Use for disabling headers",
          "title": "Header Disabled",
          "required": false,
          "deprecated": false
        },
        "header": {
          "kind": "element",
          "type": "array",
          "description": "To configure the CSV headers",
          "title": "Header",
          "required": false,
          "deprecated": false
        },
        "allowMissingColumnNames": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to allow missing column names.",
          "title": "Allow Missing Column Names",
          "required": false,
          "deprecated": false
        },
        "ignoreEmptyLines": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to ignore empty lines.",
          "title": "Ignore Empty Lines",
          "required": false,
          "deprecated": false
        },
        "ignoreSurroundingSpaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to ignore surrounding spaces",
          "title": "Ignore Surrounding Spaces",
          "required": false,
          "deprecated": false
        },
        "nullStringDisabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Used to disable null strings",
          "title": "Null String Disabled",
          "required": false,
          "deprecated": false
        },
        "nullString": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the null string",
          "title": "Null String",
          "required": false,
          "deprecated": false
        },
        "quoteDisabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Used to disable quotes",
          "title": "Quote Disabled",
          "required": false,
          "deprecated": false
        },
        "quote": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the quote which by default is",
          "title": "Quote",
          "required": false,
          "deprecated": false
        },
        "recordSeparatorDisabled": {
          "kind": "attribute",
          "type": "string",
          "description": "Used for disabling record separator",
          "title": "Record Separator Disabled",
          "required": false,
          "deprecated": false
        },
        "recordSeparator": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the record separator (aka new line) which by default is new line characters (CRLF)",
          "title": "Record Separator",
          "required": false,
          "deprecated": false
        },
        "skipHeaderRecord": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to skip the header record in the output",
          "title": "Skip Header Record",
          "required": false,
          "deprecated": false
        },
        "quoteMode": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the quote mode",
          "title": "Quote Mode",
          "required": false,
          "deprecated": false
        },
        "ignoreHeaderCase": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Sets whether or not to ignore case when accessing header names.",
          "title": "Ignore Header Case",
          "required": false,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Sets whether or not to trim leading and trailing blanks.",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "trailingDelimiter": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Sets whether or not to add a trailing delimiter.",
          "title": "Trailing Delimiter",
          "required": false,
          "deprecated": false
        },
        "lazyLoad": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the unmarshalling should produce an iterator that reads the lines on the fly or if all the lines must be read at one.",
          "title": "Lazy Load",
          "required": false,
          "deprecated": false
        },
        "useMaps": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the unmarshalling should produce maps (HashMap)for the lines values instead of lists. It requires to have header (either defined or collected).",
          "title": "Use Maps",
          "required": false,
          "deprecated": false
        },
        "useOrderedMaps": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the unmarshalling should produce ordered maps (LinkedHashMap) for the lines values instead of lists. It requires to have header (either defined or collected).",
          "title": "Use Ordered Maps",
          "required": false,
          "deprecated": false
        },
        "recordConverterRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a custom CsvRecordConverter to lookup from the registry to use.",
          "title": "Record Converter Ref",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "customDataFormat": {
      "type": "object",
      "title": "Custom",
      "group": "dataformat,transformation",
      "icon": "customDataFormat24.png",
      "description": "To use a custom data format implementation that does not come out of the box from Apache Camel.",
      "properties": {
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to the custom org.apache.camel.spi.DataFormat to lookup from the Camel registry.",
          "title": "Ref",
          "required": true,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "dataFormats": {
      "type": "object",
      "title": "Data formats",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "To configure data formats",
      "properties": {
        "dataFormats": {
          "kind": "element",
          "type": "array",
          "description": "A list holding the configured data formats",
          "title": "Data Formats",
          "required": true,
          "deprecated": false
        }
      }
    },
    "fhirJson": {
      "type": "object",
      "title": "FHIR JSon",
      "group": "dataformat,transformation,hl7",
      "icon": "generic24.png",
      "description": "The FHIR JSon data format is used to marshall/unmarshall to/from FHIR objects to/from JSON.",
      "properties": {
        "fhirVersion": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "DSTU3",
          "enum": [ "DSTU2", "DSTU2_1", "DSTU2_HL7ORG", "DSTU3", "R4" ],
          "description": "The version of FHIR to use. Possible values are: DSTU2,DSTU2_HL7ORG,DSTU2_1,DSTU3,R4",
          "title": "Fhir Version",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "fhirXml": {
      "type": "object",
      "title": "FHIR XML",
      "group": "dataformat,transformation,hl7",
      "icon": "generic24.png",
      "description": "The FHIR XML data format is used to marshall/unmarshall from/to FHIR objects to/from XML.",
      "properties": {
        "fhirVersion": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "DSTU3",
          "enum": [ "DSTU2", "DSTU2_1", "DSTU2_HL7ORG", "DSTU3", "R4" ],
          "description": "The version of FHIR to use. Possible values are: DSTU2,DSTU2_HL7ORG,DSTU2_1,DSTU3,R4",
          "title": "Fhir Version",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "flatpack": {
      "type": "object",
      "title": "Flatpack",
      "group": "dataformat,transformation,csv",
      "icon": "generic24.png",
      "description": "The Flatpack data format is used for working with flat payloads (such as CSV, delimited, or fixed length formats).",
      "properties": {
        "definition": {
          "kind": "attribute",
          "type": "string",
          "description": "The flatpack pzmap configuration file. Can be omitted in simpler situations, but its preferred to use the pzmap.",
          "title": "Definition",
          "required": false,
          "deprecated": false
        },
        "fixed": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Delimited or fixed. Is by default false = delimited",
          "title": "Fixed",
          "required": false,
          "deprecated": false
        },
        "ignoreFirstRecord": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether the first line is ignored for delimited files (for the column headers). Is by default true.",
          "title": "Ignore First Record",
          "required": false,
          "deprecated": false
        },
        "textQualifier": {
          "kind": "attribute",
          "type": "string",
          "description": "If the text is qualified with a character. Uses quote character by default.",
          "title": "Text Qualifier",
          "required": false,
          "deprecated": false
        },
        "delimiter": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": ",",
          "description": "The delimiter char (could be ; , or similar)",
          "title": "Delimiter",
          "required": false,
          "deprecated": false
        },
        "allowShortLines": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Allows for lines to be shorter than expected and ignores the extra characters",
          "title": "Allow Short Lines",
          "required": false,
          "deprecated": false
        },
        "ignoreExtraColumns": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Allows for lines to be longer than expected and ignores the extra characters.",
          "title": "Ignore Extra Columns",
          "required": false,
          "deprecated": false
        },
        "parserFactoryRef": {
          "kind": "attribute",
          "type": "string",
          "description": "References to a custom parser factory to lookup in the registry",
          "title": "Parser Factory Ref",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "gzip": {
      "type": "object",
      "title": "GZip",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "The GZip data format is a message compression and de-compression format (which works with the popular gzip/gunzip tools).",
      "properties": {
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "hessian": {
      "type": "object",
      "title": "Hessian",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "Hessian data format is used for marshalling and unmarshalling messages using Cauchos Hessian format.",
      "properties": {
        "whitelistEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Define if Whitelist feature is enabled or not",
          "title": "Whitelist Enabled",
          "required": false,
          "deprecated": false
        },
        "allowedUnmarshallObjects": {
          "kind": "attribute",
          "type": "string",
          "description": "Define the allowed objects to be unmarshalled",
          "title": "Allowed Unmarshall Objects",
          "required": false,
          "deprecated": false
        },
        "deniedUnmarshallObjects": {
          "kind": "attribute",
          "type": "string",
          "description": "Define the denied objects to be unmarshalled",
          "title": "Denied Unmarshall Objects",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "hl7": {
      "type": "object",
      "title": "HL7",
      "group": "dataformat,transformation,hl7",
      "icon": "generic24.png",
      "description": "The HL7 data format can be used to marshal or unmarshal HL7 (Health Care) model objects.",
      "properties": {
        "validate": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to validate the HL7 message Is by default true.",
          "title": "Validate",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "ical": {
      "type": "object",
      "title": "iCal",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "The iCal dataformat is used for working with iCalendar messages.",
      "properties": {
        "validating": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to validate.",
          "title": "Validating",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "jacksonxml": {
      "type": "object",
      "title": "JacksonXML",
      "group": "dataformat,transformation,xml",
      "icon": "generic24.png",
      "description": "JacksonXML data format is used for unmarshal a XML payload to POJO or to marshal POJO back to XML payload.",
      "properties": {
        "xmlMapper": {
          "kind": "attribute",
          "type": "string",
          "description": "Lookup and use the existing XmlMapper with the given id.",
          "title": "Xml Mapper",
          "required": false,
          "deprecated": false
        },
        "prettyPrint": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To enable pretty printing output nicely formatted. Is by default false.",
          "title": "Pretty Print",
          "required": false,
          "deprecated": false
        },
        "unmarshalTypeName": {
          "kind": "attribute",
          "type": "string",
          "description": "Class name of the java type to use when unarmshalling",
          "title": "Unmarshal Type Name",
          "required": false,
          "deprecated": false
        },
        "jsonView": {
          "kind": "attribute",
          "type": "string",
          "description": "When marshalling a POJO to JSON you might want to exclude certain fields from the JSON output. With Jackson you can use JSON views to accomplish this. This option is to refer to the class which has JsonView annotations",
          "title": "Json View",
          "required": false,
          "deprecated": false
        },
        "include": {
          "kind": "attribute",
          "type": "string",
          "description": "If you want to marshal a pojo to JSON, and the pojo has some fields with null values. And you want to skip these null values, you can set this option to NOT_NULL",
          "title": "Include",
          "required": false,
          "deprecated": false
        },
        "allowJmsType": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Used for JMS users to allow the JMSType header from the JMS spec to specify a FQN classname to use to unmarshal to.",
          "title": "Allow Jms Type",
          "required": false,
          "deprecated": false
        },
        "collectionTypeName": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a custom collection type to lookup in the registry to use. This option should rarely be used, but allows to use different collection types than java.util.Collection based as default.",
          "title": "Collection Type Name",
          "required": false,
          "deprecated": false
        },
        "useList": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To unarmshal to a List of Map or a List of Pojo.",
          "title": "Use List",
          "required": false,
          "deprecated": false
        },
        "enableJaxbAnnotationModule": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable the JAXB annotations module when using jackson. When enabled then JAXB annotations can be used by Jackson.",
          "title": "Enable Jaxb Annotation Module",
          "required": false,
          "deprecated": false
        },
        "moduleClassNames": {
          "kind": "attribute",
          "type": "string",
          "description": "To use custom Jackson modules com.fasterxml.jackson.databind.Module specified as a String with FQN class names. Multiple classes can be separated by comma.",
          "title": "Module Class Names",
          "required": false,
          "deprecated": false
        },
        "moduleRefs": {
          "kind": "attribute",
          "type": "string",
          "description": "To use custom Jackson modules referred from the Camel registry. Multiple modules can be separated by comma.",
          "title": "Module Refs",
          "required": false,
          "deprecated": false
        },
        "enableFeatures": {
          "kind": "attribute",
          "type": "string",
          "description": "Set of features to enable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma",
          "title": "Enable Features",
          "required": false,
          "deprecated": false
        },
        "disableFeatures": {
          "kind": "attribute",
          "type": "string",
          "description": "Set of features to disable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma",
          "title": "Disable Features",
          "required": false,
          "deprecated": false
        },
        "allowUnmarshallType": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then Jackson is allowed to attempt to use the CamelJacksonUnmarshalType header during the unmarshalling. This should only be enabled when desired to be used.",
          "title": "Allow Unmarshall Type",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "jaxb": {
      "type": "object",
      "title": "JAXB",
      "group": "dataformat,transformation,xml",
      "icon": "generic24.png",
      "description": "JAXB data format uses the JAXB2 XML marshalling standard to unmarshal an XML payload into Java objects or to marshal Java objects into an XML payload.",
      "properties": {
        "contextPath": {
          "kind": "attribute",
          "type": "string",
          "description": "Package name where your JAXB classes are located.",
          "title": "Context Path",
          "required": true,
          "deprecated": false
        },
        "schema": {
          "kind": "attribute",
          "type": "string",
          "description": "To validate against an existing schema. Your can use the prefix classpath:, file: or http: to specify how the resource should by resolved. You can separate multiple schema files by using the ',' character.",
          "title": "Schema",
          "required": false,
          "deprecated": false
        },
        "schemaSeverityLevel": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "0",
          "enum": [ "0", "1", "2" ],
          "description": "Sets the schema severity level to use when validating against a schema. This level determines the minimum severity error that triggers JAXB to stop continue parsing. The default value of 0 (warning) means that any error (warning, error or fatal error) will trigger JAXB to stop. There are the following three levels: 0=warning, 1=error, 2=fatal error.",
          "title": "Schema Severity Level",
          "required": false,
          "deprecated": false
        },
        "prettyPrint": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To enable pretty printing output nicely formatted. Is by default false.",
          "title": "Pretty Print",
          "required": false,
          "deprecated": false
        },
        "objectFactory": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to allow using ObjectFactory classes to create the POJO classes during marshalling. This only applies to POJO classes that has not been annotated with JAXB and providing jaxb.index descriptor files.",
          "title": "Object Factory",
          "required": false,
          "deprecated": false
        },
        "ignoreJAXBElement": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to ignore JAXBElement elements - only needed to be set to false in very special use-cases.",
          "title": "Ignore J A X B Element",
          "required": false,
          "deprecated": false
        },
        "mustBeJAXBElement": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether marhsalling must be java objects with JAXB annotations. And if not then it fails. This option can be set to false to relax that, such as when the data is already in XML format.",
          "title": "Must Be J A X B Element",
          "required": false,
          "deprecated": false
        },
        "filterNonXmlChars": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To ignore non xml characheters and replace them with an empty space.",
          "title": "Filter Non Xml Chars",
          "required": false,
          "deprecated": false
        },
        "encoding": {
          "kind": "attribute",
          "type": "string",
          "description": "To overrule and use a specific encoding",
          "title": "Encoding",
          "required": false,
          "deprecated": false
        },
        "fragment": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To turn on marshalling XML fragment trees. By default JAXB looks for XmlRootElement annotation on given class to operate on whole XML tree. This is useful but not always - sometimes generated code does not have XmlRootElement annotation, sometimes you need unmarshall only part of tree. In that case you can use partial unmarshalling. To enable this behaviours you need set property partClass. Camel will pass this class to JAXB's unmarshaler.",
          "title": "Fragment",
          "required": false,
          "deprecated": false
        },
        "partClass": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of class used for fragment parsing. See more details at the fragment option.",
          "title": "Part Class",
          "required": false,
          "deprecated": false
        },
        "partNamespace": {
          "kind": "attribute",
          "type": "string",
          "description": "XML namespace to use for fragment parsing. See more details at the fragment option.",
          "title": "Part Namespace",
          "required": false,
          "deprecated": false
        },
        "namespacePrefixRef": {
          "kind": "attribute",
          "type": "string",
          "description": "When marshalling using JAXB or SOAP then the JAXB implementation will automatic assign namespace prefixes, such as ns2, ns3, ns4 etc. To control this mapping, Camel allows you to refer to a map which contains the desired mapping.",
          "title": "Namespace Prefix Ref",
          "required": false,
          "deprecated": false
        },
        "xmlStreamWriterWrapper": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a custom xml stream writer.",
          "title": "Xml Stream Writer Wrapper",
          "required": false,
          "deprecated": false
        },
        "schemaLocation": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the location of the schema",
          "title": "Schema Location",
          "required": false,
          "deprecated": false
        },
        "noNamespaceSchemaLocation": {
          "kind": "attribute",
          "type": "string",
          "description": "To define the location of the namespaceless schema",
          "title": "No Namespace Schema Location",
          "required": false,
          "deprecated": false
        },
        "jaxbProviderProperties": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a custom java.util.Map to lookup in the registry containing custom JAXB provider properties to be used with the JAXB marshaller.",
          "title": "Jaxb Provider Properties",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "jibx": {
      "type": "object",
      "title": "JiBX",
      "group": "dataformat,transformation,xml",
      "icon": "generic24.png",
      "description": "JiBX data format is used for unmarshal a XML payload to POJO or to marshal POJO back to XML payload.",
      "properties": {
        "unmarshallClass": {
          "kind": "attribute",
          "type": "string",
          "description": "Class name to use when unmarshalling from XML to Java.",
          "title": "Unmarshall Class",
          "required": false,
          "deprecated": false
        },
        "bindingName": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a custom binding factory",
          "title": "Binding Name",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "json": {
      "type": "object",
      "title": "JSon",
      "group": "dataformat,transformation,json",
      "icon": "generic24.png",
      "description": "JSon data format is used for unmarshal a JSon payload to POJO or to marshal POJO back to JSon payload.",
      "properties": {
        "objectMapper": {
          "kind": "attribute",
          "type": "string",
          "description": "Lookup and use the existing ObjectMapper with the given id when using Jackson.",
          "title": "Object Mapper",
          "required": false,
          "deprecated": false
        },
        "useDefaultObjectMapper": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to lookup and use default Jackson ObjectMapper from the registry.",
          "title": "Use Default Object Mapper",
          "required": false,
          "deprecated": false
        },
        "prettyPrint": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To enable pretty printing output nicely formatted. Is by default false.",
          "title": "Pretty Print",
          "required": false,
          "deprecated": false
        },
        "library": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "XStream",
          "enum": [ "Fastjson", "Gson", "Jackson", "Johnzon", "XStream" ],
          "description": "Which json library to use.",
          "title": "Library",
          "required": false,
          "deprecated": false
        },
        "unmarshalTypeName": {
          "kind": "attribute",
          "type": "string",
          "description": "Class name of the java type to use when unarmshalling",
          "title": "Unmarshal Type Name",
          "required": false,
          "deprecated": false
        },
        "jsonView": {
          "kind": "attribute",
          "type": "string",
          "description": "When marshalling a POJO to JSON you might want to exclude certain fields from the JSON output. With Jackson you can use JSON views to accomplish this. This option is to refer to the class which has JsonView annotations",
          "title": "Json View",
          "required": false,
          "deprecated": false
        },
        "include": {
          "kind": "attribute",
          "type": "string",
          "description": "If you want to marshal a pojo to JSON, and the pojo has some fields with null values. And you want to skip these null values, you can set this option to NOT_NULL",
          "title": "Include",
          "required": false,
          "deprecated": false
        },
        "allowJmsType": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Used for JMS users to allow the JMSType header from the JMS spec to specify a FQN classname to use to unmarshal to.",
          "title": "Allow Jms Type",
          "required": false,
          "deprecated": false
        },
        "collectionTypeName": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a custom collection type to lookup in the registry to use. This option should rarely be used, but allows to use different collection types than java.util.Collection based as default.",
          "title": "Collection Type Name",
          "required": false,
          "deprecated": false
        },
        "useList": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To unarmshal to a List of Map or a List of Pojo.",
          "title": "Use List",
          "required": false,
          "deprecated": false
        },
        "enableJaxbAnnotationModule": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable the JAXB annotations module when using jackson. When enabled then JAXB annotations can be used by Jackson.",
          "title": "Enable Jaxb Annotation Module",
          "required": false,
          "deprecated": false
        },
        "moduleClassNames": {
          "kind": "attribute",
          "type": "string",
          "description": "To use custom Jackson modules com.fasterxml.jackson.databind.Module specified as a String with FQN class names. Multiple classes can be separated by comma.",
          "title": "Module Class Names",
          "required": false,
          "deprecated": false
        },
        "moduleRefs": {
          "kind": "attribute",
          "type": "string",
          "description": "To use custom Jackson modules referred from the Camel registry. Multiple modules can be separated by comma.",
          "title": "Module Refs",
          "required": false,
          "deprecated": false
        },
        "enableFeatures": {
          "kind": "attribute",
          "type": "string",
          "description": "Set of features to enable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma",
          "title": "Enable Features",
          "required": false,
          "deprecated": false
        },
        "disableFeatures": {
          "kind": "attribute",
          "type": "string",
          "description": "Set of features to disable on the Jackson com.fasterxml.jackson.databind.ObjectMapper. The features should be a name that matches a enum from com.fasterxml.jackson.databind.SerializationFeature, com.fasterxml.jackson.databind.DeserializationFeature, or com.fasterxml.jackson.databind.MapperFeature Multiple features can be separated by comma",
          "title": "Disable Features",
          "required": false,
          "deprecated": false
        },
        "permissions": {
          "kind": "attribute",
          "type": "string",
          "description": "Adds permissions that controls which Java packages and classes XStream is allowed to use during unmarshal from xml/json to Java beans. A permission must be configured either here or globally using a JVM system property. The permission can be specified in a syntax where a plus sign is allow, and minus sign is deny. Wildcards is supported by using . as prefix. For example to allow com.foo and all subpackages then specfy com.foo.. Multiple permissions can be configured separated by comma, such as com.foo.,-com.foo.bar.MySecretBean. The following default permission is always included: -,java.lang.,java.util. unless its overridden by specifying a JVM system property with they key org.apache.camel.xstream.permissions.",
          "title": "Permissions",
          "required": false,
          "deprecated": false
        },
        "allowUnmarshallType": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If enabled then Jackson is allowed to attempt to use the CamelJacksonUnmarshalType header during the unmarshalling. This should only be enabled when desired to be used.",
          "title": "Allow Unmarshall Type",
          "required": false,
          "deprecated": false
        },
        "timezone": {
          "kind": "attribute",
          "type": "string",
          "description": "If set then Jackson will use the Timezone when marshalling/unmarshalling. This option will have no effect on the others Json DataFormat, like gson, fastjson and xstream.",
          "title": "Timezone",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "lzf": {
      "type": "object",
      "title": "LZF Deflate Compression",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "The LZF data format is a message compression and de-compression format (uses the LZF deflate algorithm).",
      "properties": {
        "usingParallelCompression": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Enable encoding (compress) using multiple processing cores.",
          "title": "Using Parallel Compression",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "mime-multipart": {
      "type": "object",
      "title": "MIME Multipart",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "The MIME Multipart data format can marshal a Camel message with attachments into a Camel message having a MIME-Multipart message as message body (and no attachments), and vise-versa when unmarshalling.",
      "properties": {
        "multipartSubType": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "mixed",
          "description": "Specify the subtype of the MIME Multipart. Default is mixed.",
          "title": "Multipart Sub Type",
          "required": false,
          "deprecated": false
        },
        "multipartWithoutAttachment": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Defines whether a message without attachment is also marshaled into a MIME Multipart (with only one body part). Default is false.",
          "title": "Multipart Without Attachment",
          "required": false,
          "deprecated": false
        },
        "headersInline": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Defines whether the MIME-Multipart headers are part of the message body (true) or are set as Camel headers (false). Default is false.",
          "title": "Headers Inline",
          "required": false,
          "deprecated": false
        },
        "includeHeaders": {
          "kind": "attribute",
          "type": "string",
          "description": "A regex that defines which Camel headers are also included as MIME headers into the MIME multipart. This will only work if headersInline is set to true. Default is to include no headers",
          "title": "Include Headers",
          "required": false,
          "deprecated": false
        },
        "binaryContent": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Defines whether the content of binary parts in the MIME multipart is binary (true) or Base-64 encoded (false) Default is false.",
          "title": "Binary Content",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "pgp": {
      "type": "object",
      "title": "PGP",
      "group": "dataformat,transformation,security",
      "icon": "generic24.png",
      "description": "PGP data format is used for encrypting and decrypting of messages using Java Cryptographic Extension and PGP.",
      "properties": {
        "keyUserid": {
          "kind": "attribute",
          "type": "string",
          "description": "The user ID of the key in the PGP keyring used during encryption. Can also be only a part of a user ID. For example, if the user ID is Test User then you can use the part Test User or to address the user ID.",
          "title": "Key Userid",
          "required": false,
          "deprecated": false
        },
        "signatureKeyUserid": {
          "kind": "attribute",
          "type": "string",
          "description": "User ID of the key in the PGP keyring used for signing (during encryption) or signature verification (during decryption). During the signature verification process the specified User ID restricts the public keys from the public keyring which can be used for the verification. If no User ID is specified for the signature verficiation then any public key in the public keyring can be used for the verification. Can also be only a part of a user ID. For example, if the user ID is Test User then you can use the part Test User or to address the User ID.",
          "title": "Signature Key Userid",
          "required": false,
          "deprecated": false
        },
        "password": {
          "kind": "attribute",
          "type": "string",
          "description": "Password used when opening the private key (not used for encryption).",
          "title": "Password",
          "required": false,
          "deprecated": false
        },
        "signaturePassword": {
          "kind": "attribute",
          "type": "string",
          "description": "Password used when opening the private key used for signing (during encryption).",
          "title": "Signature Password",
          "required": false,
          "deprecated": false
        },
        "keyFileName": {
          "kind": "attribute",
          "type": "string",
          "description": "Filename of the keyring; must be accessible as a classpath resource (but you can specify a location in the file system by using the file: prefix).",
          "title": "Key File Name",
          "required": false,
          "deprecated": false
        },
        "signatureKeyFileName": {
          "kind": "attribute",
          "type": "string",
          "description": "Filename of the keyring to use for signing (during encryption) or for signature verification (during decryption); must be accessible as a classpath resource (but you can specify a location in the file system by using the file: prefix).",
          "title": "Signature Key File Name",
          "required": false,
          "deprecated": false
        },
        "signatureKeyRing": {
          "kind": "attribute",
          "type": "string",
          "description": "Keyring used for signing/verifying as byte array. You can not set the signatureKeyFileName and signatureKeyRing at the same time.",
          "title": "Signature Key Ring",
          "required": false,
          "deprecated": false
        },
        "armored": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "This option will cause PGP to base64 encode the encrypted text, making it available for copy/paste, etc.",
          "title": "Armored",
          "required": false,
          "deprecated": false
        },
        "integrity": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Adds an integrity check/sign into the encryption file. The default value is true.",
          "title": "Integrity",
          "required": false,
          "deprecated": false
        },
        "provider": {
          "kind": "attribute",
          "type": "string",
          "description": "Java Cryptography Extension (JCE) provider, default is Bouncy Castle (BC). Alternatively you can use, for example, the IAIK JCE provider; in this case the provider must be registered beforehand and the Bouncy Castle provider must not be registered beforehand. The Sun JCE provider does not work.",
          "title": "Provider",
          "required": false,
          "deprecated": false
        },
        "algorithm": {
          "kind": "attribute",
          "type": "integer",
          "description": "Symmetric key encryption algorithm; possible values are defined in org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags; for example 2 (= TRIPLE DES), 3 (= CAST5), 4 (= BLOWFISH), 6 (= DES), 7 (= AES_128). Only relevant for encrypting.",
          "title": "Algorithm",
          "required": false,
          "deprecated": false
        },
        "compressionAlgorithm": {
          "kind": "attribute",
          "type": "integer",
          "description": "Compression algorithm; possible values are defined in org.bouncycastle.bcpg.CompressionAlgorithmTags; for example 0 (= UNCOMPRESSED), 1 (= ZIP), 2 (= ZLIB), 3 (= BZIP2). Only relevant for encrypting.",
          "title": "Compression Algorithm",
          "required": false,
          "deprecated": false
        },
        "hashAlgorithm": {
          "kind": "attribute",
          "type": "integer",
          "description": "Signature hash algorithm; possible values are defined in org.bouncycastle.bcpg.HashAlgorithmTags; for example 2 (= SHA1), 8 (= SHA256), 9 (= SHA384), 10 (= SHA512), 11 (=SHA224). Only relevant for signing.",
          "title": "Hash Algorithm",
          "required": false,
          "deprecated": false
        },
        "signatureVerificationOption": {
          "kind": "attribute",
          "type": "string",
          "description": "Controls the behavior for verifying the signature during unmarshaling. There are 4 values possible: optional: The PGP message may or may not contain signatures; if it does contain signatures, then a signature verification is executed. required: The PGP message must contain at least one signature; if this is not the case an exception (PGPException) is thrown. A signature verification is executed. ignore: Contained signatures in the PGP message are ignored; no signature verification is executed. no_signature_allowed: The PGP message must not contain a signature; otherwise an exception (PGPException) is thrown.",
          "title": "Signature Verification Option",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "protobuf": {
      "type": "object",
      "title": "Protobuf",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "The Protobuf data format is used for serializing between Java objects and the Google Protobuf protocol.",
      "properties": {
        "instanceClass": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of class to use when unarmshalling",
          "title": "Instance Class",
          "required": false,
          "deprecated": false
        },
        "contentTypeFormat": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "native",
          "enum": [ "json", "native" ],
          "description": "Defines a content type format in which protobuf message will be serialized/deserialized from(to) the Java been. The format can either be native or json for either native protobuf or json fields representation. The default value is native.",
          "title": "Content Type Format",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "rss": {
      "type": "object",
      "title": "RSS",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "RSS data format is used for working with RSS sync feed Java Objects and transforming to XML and vice-versa.",
      "properties": {
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "secureXML": {
      "type": "object",
      "title": "XML Security",
      "group": "dataformat,transformation,xml,security",
      "icon": "generic24.png",
      "description": "The XML Security data format facilitates encryption and decryption of XML payloads.",
      "properties": {
        "xmlCipherAlgorithm": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "TRIPLEDES",
          "description": "The cipher algorithm to be used for encryption/decryption of the XML message content. The available choices are: XMLCipher.TRIPLEDES XMLCipher.AES_128 XMLCipher.AES_128_GCM XMLCipher.AES_192 XMLCipher.AES_192_GCM XMLCipher.AES_256 XMLCipher.AES_256_GCM XMLCipher.SEED_128 XMLCipher.CAMELLIA_128 XMLCipher.CAMELLIA_192 XMLCipher.CAMELLIA_256 The default value is MLCipher.TRIPLEDES",
          "title": "Xml Cipher Algorithm",
          "required": false,
          "deprecated": false
        },
        "passPhrase": {
          "kind": "attribute",
          "type": "string",
          "description": "A String used as passPhrase to encrypt/decrypt content. The passPhrase has to be provided. If no passPhrase is specified, a default passPhrase is used. The passPhrase needs to be put together in conjunction with the appropriate encryption algorithm. For example using TRIPLEDES the passPhase can be a Only another 24 Byte key",
          "title": "Pass Phrase",
          "required": false,
          "deprecated": false
        },
        "secureTag": {
          "kind": "attribute",
          "type": "string",
          "description": "The XPath reference to the XML Element selected for encryption/decryption. If no tag is specified, the entire payload is encrypted/decrypted.",
          "title": "Secure Tag",
          "required": false,
          "deprecated": false
        },
        "secureTagContents": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "A boolean value to specify whether the XML Element is to be encrypted or the contents of the XML Element false = Element Level true = Element Content Level",
          "title": "Secure Tag Contents",
          "required": false,
          "deprecated": false
        },
        "keyCipherAlgorithm": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "RSA_OAEP",
          "description": "The cipher algorithm to be used for encryption/decryption of the asymmetric key. The available choices are: XMLCipher.RSA_v1dot5 XMLCipher.RSA_OAEP XMLCipher.RSA_OAEP_11 The default value is XMLCipher.RSA_OAEP",
          "title": "Key Cipher Algorithm",
          "required": false,
          "deprecated": false
        },
        "recipientKeyAlias": {
          "kind": "attribute",
          "type": "string",
          "description": "The key alias to be used when retrieving the recipient's public or private key from a KeyStore when performing asymmetric key encryption or decryption.",
          "title": "Recipient Key Alias",
          "required": false,
          "deprecated": false
        },
        "keyOrTrustStoreParametersId": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to a KeyStore instance to lookup in the registry, which is used for configuration options for creating and loading a KeyStore instance that represents the sender's trustStore or recipient's keyStore.",
          "title": "Key Or Trust Store Parameters Id",
          "required": false,
          "deprecated": false
        },
        "keyPassword": {
          "kind": "attribute",
          "type": "string",
          "description": "The password to be used for retrieving the private key from the KeyStore. This key is used for asymmetric decryption.",
          "title": "Key Password",
          "required": false,
          "deprecated": false
        },
        "digestAlgorithm": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "SHA1",
          "description": "The digest algorithm to use with the RSA OAEP algorithm. The available choices are: XMLCipher.SHA1 XMLCipher.SHA256 XMLCipher.SHA512 The default value is XMLCipher.SHA1",
          "title": "Digest Algorithm",
          "required": false,
          "deprecated": false
        },
        "mgfAlgorithm": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "MGF1_SHA1",
          "description": "The MGF Algorithm to use with the RSA OAEP algorithm. The available choices are: EncryptionConstants.MGF1_SHA1 EncryptionConstants.MGF1_SHA256 EncryptionConstants.MGF1_SHA512 The default value is EncryptionConstants.MGF1_SHA1",
          "title": "Mgf Algorithm",
          "required": false,
          "deprecated": false
        },
        "addKeyValueForEncryptedKey": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to add the public key used to encrypt the session key as a KeyValue in the EncryptedKey structure or not.",
          "title": "Add Key Value For Encrypted Key",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "serialization": {
      "type": "object",
      "title": "Java Object Serialization",
      "group": "dataformat,transformation,core",
      "icon": "generic24.png",
      "description": "Serialization is a data format which uses the standard Java Serialization mechanism to unmarshal a binary payload into Java objects or to marshal Java objects into a binary blob.",
      "properties": {
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "soapjaxb": {
      "type": "object",
      "title": "SOAP",
      "group": "dataformat,transformation,xml",
      "icon": "generic24.png",
      "description": "SOAP is a data format which uses JAXB2 and JAX-WS annotations to marshal and unmarshal SOAP payloads.",
      "properties": {
        "contextPath": {
          "kind": "attribute",
          "type": "string",
          "description": "Package name where your JAXB classes are located.",
          "title": "Context Path",
          "required": true,
          "deprecated": false
        },
        "encoding": {
          "kind": "attribute",
          "type": "string",
          "description": "To overrule and use a specific encoding",
          "title": "Encoding",
          "required": false,
          "deprecated": false
        },
        "elementNameStrategyRef": {
          "kind": "attribute",
          "type": "string",
          "description": "Refers to an element strategy to lookup from the registry. An element name strategy is used for two purposes. The first is to find a xml element name for a given object and soap action when marshaling the object into a SOAP message. The second is to find an Exception class for a given soap fault name. The following three element strategy class name is provided out of the box. QNameStrategy - Uses a fixed qName that is configured on instantiation. Exception lookup is not supported TypeNameStrategy - Uses the name and namespace from the XMLType annotation of the given type. If no namespace is set then package-info is used. Exception lookup is not supported ServiceInterfaceStrategy - Uses information from a webservice interface to determine the type name and to find the exception class for a SOAP fault All three classes is located in the package name org.apache.camel.dataformat.soap.name If you have generated the web service stub code with cxf-codegen or a similar tool then you probably will want to use the ServiceInterfaceStrategy. In the case you have no annotated service interface you should use QNameStrategy or TypeNameStrategy.",
          "title": "Element Name Strategy Ref",
          "required": false,
          "deprecated": false
        },
        "version": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "1.1",
          "description": "SOAP version should either be 1.1 or 1.2. Is by default 1.1",
          "title": "Version",
          "required": false,
          "deprecated": false
        },
        "namespacePrefixRef": {
          "kind": "attribute",
          "type": "string",
          "description": "When marshalling using JAXB or SOAP then the JAXB implementation will automatic assign namespace prefixes, such as ns2, ns3, ns4 etc. To control this mapping, Camel allows you to refer to a map which contains the desired mapping.",
          "title": "Namespace Prefix Ref",
          "required": false,
          "deprecated": false
        },
        "schema": {
          "kind": "attribute",
          "type": "string",
          "description": "To validate against an existing schema. Your can use the prefix classpath:, file: or http: to specify how the resource should by resolved. You can separate multiple schema files by using the ',' character.",
          "title": "Schema",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "string": {
      "type": "object",
      "title": "String Encoding",
      "group": "dataformat,transformation,core",
      "icon": "generic24.png",
      "description": "String data format is a textual based format that supports character encoding.",
      "properties": {
        "charset": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets an encoding to use. Will by default use the JVM platform default charset.",
          "title": "Charset",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "syslog": {
      "type": "object",
      "title": "Syslog",
      "group": "dataformat,transformation,monitoring",
      "icon": "generic24.png",
      "description": "The Syslog dataformat is used for working with RFC3164 and RFC5424 messages (logging and monitoring).",
      "properties": {
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "tarfile": {
      "type": "object",
      "title": "Tar File",
      "group": "dataformat,transformation,file",
      "icon": "generic24.png",
      "description": "The Tar File data format is a message compression and de-compression format of tar files.",
      "properties": {
        "usingIterator": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the tar file has more then one entry, the setting this option to true, allows to work with the splitter EIP, to split the data using an iterator in a streaming mode.",
          "title": "Using Iterator",
          "required": false,
          "deprecated": false
        },
        "allowEmptyDirectory": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the tar file has more then one entry, setting this option to true, allows to get the iterator even if the directory is empty",
          "title": "Allow Empty Directory",
          "required": false,
          "deprecated": false
        },
        "preservePathElements": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the file name contains path elements, setting this option to true, allows the path to be maintained in the tar file.",
          "title": "Preserve Path Elements",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "thrift": {
      "type": "object",
      "title": "Thrift",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "The Thrift data format is used for serialization and deserialization of messages using Apache Thrift binary dataformat.",
      "properties": {
        "instanceClass": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of class to use when unarmshalling",
          "title": "Instance Class",
          "required": false,
          "deprecated": false
        },
        "contentTypeFormat": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "binary",
          "enum": [ "binary", "json", "sjson" ],
          "description": "Defines a content type format in which thrift message will be serialized/deserialized from(to) the Java been. The format can either be native or json for either native binary thrift, json or simple json fields representation. The default value is binary.",
          "title": "Content Type Format",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "tidyMarkup": {
      "type": "object",
      "title": "TidyMarkup",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "TidyMarkup data format is used for parsing HTML and return it as pretty well-formed HTML.",
      "properties": {
        "dataObjectType": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "org.w3c.dom.Node",
          "description": "What data type to unmarshal as, can either be org.w3c.dom.Node or java.lang.String. Is by default org.w3c.dom.Node",
          "title": "Data Object Type",
          "required": false,
          "deprecated": false
        },
        "omitXmlDeclaration": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "When returning a String, do we omit the XML declaration in the top.",
          "title": "Omit Xml Declaration",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "typeFilter": {
      "type": "object",
      "title": "YAML Type Filter",
      "group": "dataformat,transformation,yaml",
      "icon": "generic24.png",
      "description": "",
      "properties": {
        "value": {
          "kind": "attribute",
          "type": "string",
          "description": "Value of type such as class name or regular expression",
          "title": "Value",
          "required": false,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "object",
          "enum": [ "regexp", "type" ],
          "description": "Whether to filter by class type or regular expression",
          "title": "Type",
          "required": false,
          "deprecated": false
        }
      }
    },
    "univocity-csv": {
      "type": "object",
      "title": "uniVocity CSV",
      "group": "dataformat,transformation,csv",
      "icon": "generic24.png",
      "description": "The uniVocity CSV data format is used for working with CSV (Comma Separated Values) flat payloads.",
      "properties": {
        "quoteAllFields": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not all values must be quoted when writing them.",
          "title": "Quote All Fields",
          "required": false,
          "deprecated": false
        },
        "quote": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "\"",
          "description": "The quote symbol.",
          "title": "Quote",
          "required": false,
          "deprecated": false
        },
        "quoteEscape": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "\"",
          "description": "The quote escape symbol",
          "title": "Quote Escape",
          "required": false,
          "deprecated": false
        },
        "delimiter": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": ",",
          "description": "The delimiter of values",
          "title": "Delimiter",
          "required": false,
          "deprecated": false
        },
        "nullValue": {
          "kind": "attribute",
          "type": "string",
          "description": "The string representation of a null value. The default value is null",
          "title": "Null Value",
          "required": false,
          "deprecated": false
        },
        "skipEmptyLines": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the empty lines must be ignored. The default value is true",
          "title": "Skip Empty Lines",
          "required": false,
          "deprecated": false
        },
        "ignoreTrailingWhitespaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the trailing white spaces must ignored. The default value is true",
          "title": "Ignore Trailing Whitespaces",
          "required": false,
          "deprecated": false
        },
        "ignoreLeadingWhitespaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the leading white spaces must be ignored. The default value is true",
          "title": "Ignore Leading Whitespaces",
          "required": false,
          "deprecated": false
        },
        "headersDisabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the headers are disabled. When defined, this option explicitly sets the headers as null which indicates that there is no header. The default value is false",
          "title": "Headers Disabled",
          "required": false,
          "deprecated": false
        },
        "headerExtractionEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the header must be read in the first line of the test document The default value is false",
          "title": "Header Extraction Enabled",
          "required": false,
          "deprecated": false
        },
        "numberOfRecordsToRead": {
          "kind": "attribute",
          "type": "integer",
          "description": "The maximum number of record to read.",
          "title": "Number Of Records To Read",
          "required": false,
          "deprecated": false
        },
        "emptyValue": {
          "kind": "attribute",
          "type": "string",
          "description": "The String representation of an empty value",
          "title": "Empty Value",
          "required": false,
          "deprecated": false
        },
        "lineSeparator": {
          "kind": "attribute",
          "type": "string",
          "description": "The line separator of the files The default value is to use the JVM platform line separator",
          "title": "Line Separator",
          "required": false,
          "deprecated": false
        },
        "normalizedLineSeparator": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "\n",
          "description": "The normalized line separator of the files The default value is a new line character.",
          "title": "Normalized Line Separator",
          "required": false,
          "deprecated": false
        },
        "comment": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "#",
          "description": "The comment symbol. The default value is",
          "title": "Comment",
          "required": false,
          "deprecated": false
        },
        "lazyLoad": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the unmarshalling should produce an iterator that reads the lines on the fly or if all the lines must be read at one. The default value is false",
          "title": "Lazy Load",
          "required": false,
          "deprecated": false
        },
        "asMap": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the unmarshalling should produce maps for the lines values instead of lists. It requires to have header (either defined or collected). The default value is false",
          "title": "As Map",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "univocity-fixed": {
      "type": "object",
      "title": "uniVocity Fixed Length",
      "group": "dataformat,transformation,csv",
      "icon": "generic24.png",
      "description": "The uniVocity Fixed Length data format is used for working with fixed length flat payloads.",
      "properties": {
        "skipTrailingCharsUntilNewline": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the trailing characters until new line must be ignored. The default value is false",
          "title": "Skip Trailing Chars Until Newline",
          "required": false,
          "deprecated": false
        },
        "recordEndsOnNewline": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the record ends on new line. The default value is false",
          "title": "Record Ends On Newline",
          "required": false,
          "deprecated": false
        },
        "padding": {
          "kind": "attribute",
          "type": "string",
          "description": "The padding character. The default value is a space",
          "title": "Padding",
          "required": false,
          "deprecated": false
        },
        "nullValue": {
          "kind": "attribute",
          "type": "string",
          "description": "The string representation of a null value. The default value is null",
          "title": "Null Value",
          "required": false,
          "deprecated": false
        },
        "skipEmptyLines": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the empty lines must be ignored. The default value is true",
          "title": "Skip Empty Lines",
          "required": false,
          "deprecated": false
        },
        "ignoreTrailingWhitespaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the trailing white spaces must ignored. The default value is true",
          "title": "Ignore Trailing Whitespaces",
          "required": false,
          "deprecated": false
        },
        "ignoreLeadingWhitespaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the leading white spaces must be ignored. The default value is true",
          "title": "Ignore Leading Whitespaces",
          "required": false,
          "deprecated": false
        },
        "headersDisabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the headers are disabled. When defined, this option explicitly sets the headers as null which indicates that there is no header. The default value is false",
          "title": "Headers Disabled",
          "required": false,
          "deprecated": false
        },
        "headerExtractionEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the header must be read in the first line of the test document The default value is false",
          "title": "Header Extraction Enabled",
          "required": false,
          "deprecated": false
        },
        "numberOfRecordsToRead": {
          "kind": "attribute",
          "type": "integer",
          "description": "The maximum number of record to read.",
          "title": "Number Of Records To Read",
          "required": false,
          "deprecated": false
        },
        "emptyValue": {
          "kind": "attribute",
          "type": "string",
          "description": "The String representation of an empty value",
          "title": "Empty Value",
          "required": false,
          "deprecated": false
        },
        "lineSeparator": {
          "kind": "attribute",
          "type": "string",
          "description": "The line separator of the files The default value is to use the JVM platform line separator",
          "title": "Line Separator",
          "required": false,
          "deprecated": false
        },
        "normalizedLineSeparator": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "\n",
          "description": "The normalized line separator of the files The default value is a new line character.",
          "title": "Normalized Line Separator",
          "required": false,
          "deprecated": false
        },
        "comment": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "#",
          "description": "The comment symbol. The default value is",
          "title": "Comment",
          "required": false,
          "deprecated": false
        },
        "lazyLoad": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the unmarshalling should produce an iterator that reads the lines on the fly or if all the lines must be read at one. The default value is false",
          "title": "Lazy Load",
          "required": false,
          "deprecated": false
        },
        "asMap": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the unmarshalling should produce maps for the lines values instead of lists. It requires to have header (either defined or collected). The default value is false",
          "title": "As Map",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "univocity-header": {
      "type": "object",
      "title": "uniVocity Header",
      "group": "dataformat,transformation,csv",
      "icon": "generic24.png",
      "description": "To configure headers for UniVocity data formats.",
      "properties": {
        "name": {
          "kind": "value",
          "type": "string",
          "description": "Header name",
          "title": "Name",
          "required": true,
          "deprecated": false
        },
        "length": {
          "kind": "attribute",
          "type": "integer",
          "description": "Header length",
          "title": "Length",
          "required": false,
          "deprecated": false
        }
      }
    },
    "univocity-tsv": {
      "type": "object",
      "title": "uniVocity TSV",
      "group": "dataformat,transformation,csv",
      "icon": "generic24.png",
      "description": "The uniVocity TSV data format is used for working with TSV (Tabular Separated Values) flat payloads.",
      "properties": {
        "escapeChar": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "\\",
          "description": "The escape character.",
          "title": "Escape Char",
          "required": false,
          "deprecated": false
        },
        "nullValue": {
          "kind": "attribute",
          "type": "string",
          "description": "The string representation of a null value. The default value is null",
          "title": "Null Value",
          "required": false,
          "deprecated": false
        },
        "skipEmptyLines": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the empty lines must be ignored. The default value is true",
          "title": "Skip Empty Lines",
          "required": false,
          "deprecated": false
        },
        "ignoreTrailingWhitespaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the trailing white spaces must ignored. The default value is true",
          "title": "Ignore Trailing Whitespaces",
          "required": false,
          "deprecated": false
        },
        "ignoreLeadingWhitespaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether or not the leading white spaces must be ignored. The default value is true",
          "title": "Ignore Leading Whitespaces",
          "required": false,
          "deprecated": false
        },
        "headersDisabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the headers are disabled. When defined, this option explicitly sets the headers as null which indicates that there is no header. The default value is false",
          "title": "Headers Disabled",
          "required": false,
          "deprecated": false
        },
        "headerExtractionEnabled": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether or not the header must be read in the first line of the test document The default value is false",
          "title": "Header Extraction Enabled",
          "required": false,
          "deprecated": false
        },
        "numberOfRecordsToRead": {
          "kind": "attribute",
          "type": "integer",
          "description": "The maximum number of record to read.",
          "title": "Number Of Records To Read",
          "required": false,
          "deprecated": false
        },
        "emptyValue": {
          "kind": "attribute",
          "type": "string",
          "description": "The String representation of an empty value",
          "title": "Empty Value",
          "required": false,
          "deprecated": false
        },
        "lineSeparator": {
          "kind": "attribute",
          "type": "string",
          "description": "The line separator of the files The default value is to use the JVM platform line separator",
          "title": "Line Separator",
          "required": false,
          "deprecated": false
        },
        "normalizedLineSeparator": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "\n",
          "description": "The normalized line separator of the files The default value is a new line character.",
          "title": "Normalized Line Separator",
          "required": false,
          "deprecated": false
        },
        "comment": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "#",
          "description": "The comment symbol. The default value is",
          "title": "Comment",
          "required": false,
          "deprecated": false
        },
        "lazyLoad": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the unmarshalling should produce an iterator that reads the lines on the fly or if all the lines must be read at one. The default value is false",
          "title": "Lazy Load",
          "required": false,
          "deprecated": false
        },
        "asMap": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the unmarshalling should produce maps for the lines values instead of lists. It requires to have header (either defined or collected). The default value is false",
          "title": "As Map",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "xmlBeans": {
      "type": "object",
      "title": "XML Beans",
      "group": "dataformat,transformation,xml",
      "icon": "generic24.png",
      "description": "XML Beans data format is used for unmarshal a XML payload to POJO or to marshal POJO back to XML payload.",
      "properties": {
        "prettyPrint": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To enable pretty printing output nicely formatted. Is by default false.",
          "title": "Pretty Print",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "xmljson": {
      "type": "object",
      "title": "XML JSon",
      "group": "dataformat,transformation,xml,json",
      "icon": "generic24.png",
      "description": "XML JSon data format can convert from XML to JSON and vice-versa directly, without stepping through intermediate POJOs.",
      "properties": {
        "encoding": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the encoding. Used for unmarshalling (JSON to XML conversion).",
          "title": "Encoding",
          "required": false,
          "deprecated": false
        },
        "elementName": {
          "kind": "attribute",
          "type": "string",
          "description": "Specifies the name of the XML elements representing each array element. Used for unmarshalling (JSON to XML conversion).",
          "title": "Element Name",
          "required": false,
          "deprecated": false
        },
        "arrayName": {
          "kind": "attribute",
          "type": "string",
          "description": "Specifies the name of the top-level XML element. Used for unmarshalling (JSON to XML conversion). For example, when converting 1, 2, 3, it will be output by default as 123. By setting this option or rootName, you can alter the name of element 'a'.",
          "title": "Array Name",
          "required": false,
          "deprecated": false
        },
        "forceTopLevelObject": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Determines whether the resulting JSON will start off with a top-most element whose name matches the XML root element. Used for marshalling (XML to JSon conversion). If disabled, XML string 12 turns into 'x: '1', 'y': '2' . Otherwise, it turns into 'a': 'x: '1', 'y': '2' .",
          "title": "Force Top Level Object",
          "required": false,
          "deprecated": false
        },
        "namespaceLenient": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Flag to be tolerant to incomplete namespace prefixes. Used for unmarshalling (JSON to XML conversion). In most cases, json-lib automatically changes this flag at runtime to match the processing.",
          "title": "Namespace Lenient",
          "required": false,
          "deprecated": false
        },
        "rootName": {
          "kind": "attribute",
          "type": "string",
          "description": "Specifies the name of the top-level element. Used for unmarshalling (JSON to XML conversion). If not set, json-lib will use arrayName or objectName (default value: 'o', at the current time it is not configurable in this data format). If set to 'root', the JSON string 'x': 'value1', 'y' : 'value2' would turn into value1value2, otherwise the 'root' element would be named 'o'.",
          "title": "Root Name",
          "required": false,
          "deprecated": false
        },
        "skipWhitespace": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Determines whether white spaces between XML elements will be regarded as text values or disregarded. Used for marshalling (XML to JSon conversion).",
          "title": "Skip Whitespace",
          "required": false,
          "deprecated": false
        },
        "trimSpaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Determines whether leading and trailing white spaces will be omitted from String values. Used for marshalling (XML to JSon conversion).",
          "title": "Trim Spaces",
          "required": false,
          "deprecated": false
        },
        "skipNamespaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Signals whether namespaces should be ignored. By default they will be added to the JSON output using xmlns elements. Used for marshalling (XML to JSon conversion).",
          "title": "Skip Namespaces",
          "required": false,
          "deprecated": false
        },
        "removeNamespacePrefixes": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Removes the namespace prefixes from XML qualified elements, so that the resulting JSON string does not contain them. Used for marshalling (XML to JSon conversion).",
          "title": "Remove Namespace Prefixes",
          "required": false,
          "deprecated": false
        },
        "expandableProperties": {
          "kind": "attribute",
          "type": "array",
          "description": "With expandable properties, JSON array elements are converted to XML as a sequence of repetitive XML elements with the local name equal to the JSON key, for example: number: 1,2,3 , normally converted to: 123 (where e can be modified by setting elementName), would instead translate to 123, if number is set as an expandable property Used for unmarshalling (JSON to XML conversion).",
          "title": "Expandable Properties",
          "required": false,
          "deprecated": false
        },
        "typeHints": {
          "kind": "attribute",
          "type": "string",
          "description": "Adds type hints to the resulting XML to aid conversion back to JSON. Used for unmarshalling (JSON to XML conversion).",
          "title": "Type Hints",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "xmlrpc": {
      "type": "object",
      "title": "XML RPC",
      "group": "dataformat,transformation,xml",
      "icon": "generic24.png",
      "description": "The XML RPC data format is used for working with the XML RPC protocol.",
      "properties": {
        "request": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to marshal/unmarshal request or response Is by default false",
          "title": "Request",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "xstream": {
      "type": "object",
      "title": "XStream",
      "group": "dataformat,transformation,xml,json",
      "icon": "generic24.png",
      "description": "XSTream data format is used for unmarshal a XML payload to POJO or to marshal POJO back to XML payload.",
      "properties": {
        "permissions": {
          "kind": "attribute",
          "type": "string",
          "description": "Adds permissions that controls which Java packages and classes XStream is allowed to use during unmarshal from xml/json to Java beans. A permission must be configured either here or globally using a JVM system property. The permission can be specified in a syntax where a plus sign is allow, and minus sign is deny. Wildcards is supported by using . as prefix. For example to allow com.foo and all subpackages then specfy com.foo.. Multiple permissions can be configured separated by comma, such as com.foo.,-com.foo.bar.MySecretBean. The following default permission is always included: -,java.lang.,java.util. unless its overridden by specifying a JVM system property with they key org.apache.camel.xstream.permissions.",
          "title": "Permissions",
          "required": false,
          "deprecated": false
        },
        "encoding": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the encoding to use",
          "title": "Encoding",
          "required": false,
          "deprecated": false
        },
        "driver": {
          "kind": "attribute",
          "type": "string",
          "description": "To use a custom XStream driver. The instance must be of type com.thoughtworks.xstream.io.HierarchicalStreamDriver",
          "title": "Driver",
          "required": false,
          "deprecated": false
        },
        "driverRef": {
          "kind": "attribute",
          "type": "string",
          "description": "To refer to a custom XStream driver to lookup in the registry. The instance must be of type com.thoughtworks.xstream.io.HierarchicalStreamDriver",
          "title": "Driver Ref",
          "required": false,
          "deprecated": false
        },
        "mode": {
          "kind": "attribute",
          "type": "string",
          "description": "Mode for dealing with duplicate references The possible values are: NO_REFERENCES ID_REFERENCES XPATH_RELATIVE_REFERENCES XPATH_ABSOLUTE_REFERENCES SINGLE_NODE_XPATH_RELATIVE_REFERENCES SINGLE_NODE_XPATH_ABSOLUTE_REFERENCES",
          "title": "Mode",
          "required": false,
          "deprecated": false
        },
        "converters": {
          "kind": "element",
          "type": "array",
          "description": "List of class names for using custom XStream converters. The classes must be of type com.thoughtworks.xstream.converters.Converter",
          "title": "Converters",
          "required": false,
          "deprecated": false
        },
        "aliases": {
          "kind": "element",
          "type": "object",
          "description": "Alias a Class to a shorter name to be used in XML elements.",
          "title": "Aliases",
          "required": false,
          "deprecated": false
        },
        "omitFields": {
          "kind": "element",
          "type": "object",
          "description": "Prevents a field from being serialized. To omit a field you must always provide the declaring type and not necessarily the type that is converted.",
          "title": "Omit Fields",
          "required": false,
          "deprecated": false
        },
        "implicitCollections": {
          "kind": "element",
          "type": "object",
          "description": "Adds a default implicit collection which is used for any unmapped XML tag.",
          "title": "Implicit Collections",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "yaml": {
      "type": "object",
      "title": "YAML",
      "group": "dataformat,transformation,yaml",
      "icon": "generic24.png",
      "description": "YAML is a data format to marshal and unmarshal Java objects to and from YAML.",
      "properties": {
        "library": {
          "kind": "attribute",
          "type": "object",
          "defaultValue": "SnakeYAML",
          "enum": [ "SnakeYAML" ],
          "description": "Which yaml library to use. By default it is SnakeYAML",
          "title": "Library",
          "required": false,
          "deprecated": false
        },
        "unmarshalTypeName": {
          "kind": "attribute",
          "type": "string",
          "description": "Class name of the java type to use when unarmshalling",
          "title": "Unmarshal Type Name",
          "required": false,
          "deprecated": false
        },
        "constructor": {
          "kind": "attribute",
          "type": "string",
          "description": "BaseConstructor to construct incoming documents.",
          "title": "Constructor",
          "required": false,
          "deprecated": false
        },
        "representer": {
          "kind": "attribute",
          "type": "string",
          "description": "Representer to emit outgoing objects.",
          "title": "Representer",
          "required": false,
          "deprecated": false
        },
        "dumperOptions": {
          "kind": "attribute",
          "type": "string",
          "description": "DumperOptions to configure outgoing objects.",
          "title": "Dumper Options",
          "required": false,
          "deprecated": false
        },
        "resolver": {
          "kind": "attribute",
          "type": "string",
          "description": "Resolver to detect implicit type",
          "title": "Resolver",
          "required": false,
          "deprecated": false
        },
        "useApplicationContextClassLoader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Use ApplicationContextClassLoader as custom ClassLoader",
          "title": "Use Application Context Class Loader",
          "required": false,
          "deprecated": false
        },
        "prettyFlow": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Force the emitter to produce a pretty YAML document when using the flow style.",
          "title": "Pretty Flow",
          "required": false,
          "deprecated": false
        },
        "allowAnyType": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Allow any class to be un-marshaled",
          "title": "Allow Any Type",
          "required": false,
          "deprecated": false
        },
        "typeFilter": {
          "kind": "element",
          "type": "array",
          "description": "Set the types SnakeYAML is allowed to un-marshall",
          "title": "Type Filter",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "zip": {
      "type": "object",
      "title": "Zip Deflate Compression",
      "group": "dataformat,transformation",
      "icon": "generic24.png",
      "description": "Zip Deflate Compression data format is a message compression and de-compression format (not zip files).",
      "properties": {
        "compressionLevel": {
          "kind": "attribute",
          "type": "integer",
          "defaultValue": "-1",
          "description": "To specify a specific compression between 0-9. -1 is default compression, 0 is no compression, and 9 is best compression.",
          "title": "Compression Level",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "zipFile": {
      "type": "object",
      "title": "Zip File",
      "group": "dataformat,transformation,file",
      "icon": "generic24.png",
      "description": "The Zip File data format is a message compression and de-compression format of zip files.",
      "properties": {
        "usingIterator": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the zip file has more then one entry, the setting this option to true, allows to work with the splitter EIP, to split the data using an iterator in a streaming mode.",
          "title": "Using Iterator",
          "required": false,
          "deprecated": false
        },
        "allowEmptyDirectory": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the zip file has more then one entry, setting this option to true, allows to get the iterator even if the directory is empty",
          "title": "Allow Empty Directory",
          "required": false,
          "deprecated": false
        },
        "preservePathElements": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the file name contains path elements, setting this option to true, allows the path to be maintained in the zip file.",
          "title": "Preserve Path Elements",
          "required": false,
          "deprecated": false
        },
        "contentTypeHeader": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the data format should set the Content-Type header with the type from the data format if the data format is capable of doing so. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSon etc.",
          "title": "Content Type Header",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the value of the id property.",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    }
  },
  "languages": {
    "constant": {
      "type": "object",
      "title": "Constant",
      "group": "language,core",
      "icon": "generic24.png",
      "description": "To use a constant value in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "el": {
      "type": "object",
      "title": "EL",
      "group": "language,script",
      "icon": "generic24.png",
      "description": "To use EL scripts in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "exchangeProperty": {
      "type": "object",
      "title": "ExchangeProperty",
      "group": "language,core",
      "icon": "generic24.png",
      "description": "To use a Camel Exchange property in expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "expression": {
      "type": "object",
      "title": "Expression",
      "group": "language",
      "icon": "generic24.png",
      "description": "A useful base class for an expression",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "groovy": {
      "type": "object",
      "title": "Groovy",
      "group": "language,script",
      "icon": "generic24.png",
      "description": "To use Groovy scripts in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "header": {
      "type": "object",
      "title": "Header",
      "group": "language,core",
      "icon": "generic24.png",
      "description": "To use a Camel Message header in expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "javaScript": {
      "type": "object",
      "title": "JavaScript",
      "group": "language,script",
      "icon": "generic24.png",
      "description": "To use JavaScript in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "jsonpath": {
      "type": "object",
      "title": "JsonPath",
      "group": "language,json",
      "icon": "generic24.png",
      "description": "To use JsonPath in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "resultType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name of the result type (type from output)",
          "title": "Result Type",
          "required": false,
          "deprecated": false
        },
        "suppressExceptions": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to suppress exceptions such as PathNotFoundException.",
          "title": "Suppress Exceptions",
          "required": false,
          "deprecated": false
        },
        "allowSimple": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to allow in inlined simple exceptions in the JsonPath expression",
          "title": "Allow Simple",
          "required": false,
          "deprecated": false
        },
        "allowEasyPredicate": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to allow using the easy predicate parser to pre-parse predicates.",
          "title": "Allow Easy Predicate",
          "required": false,
          "deprecated": false
        },
        "writeAsString": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to write the output of each row/element as a JSON String value instead of a Map/POJO value.",
          "title": "Write As String",
          "required": false,
          "deprecated": false
        },
        "headerName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of header to use as input, instead of the message body",
          "title": "Header Name",
          "required": false,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "jxpath": {
      "type": "object",
      "title": "JXPath",
      "group": "language,java",
      "icon": "generic24.png",
      "description": "To use JXPath in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "lenient": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Allows to turn lenient on the JXPathContext. When turned on this allows the JXPath expression to evaluate against expressions and message bodies which may be invalid / missing data. This option is by default false",
          "title": "Lenient",
          "required": false,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "language": {
      "type": "object",
      "title": "Language",
      "group": "language,core",
      "icon": "generic24.png",
      "description": "To use the specified language in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "language": {
          "kind": "attribute",
          "type": "string",
          "description": "The name of the language to use",
          "title": "Language",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "method": {
      "type": "object",
      "title": "Bean method",
      "group": "language,core,java",
      "icon": "generic24.png",
      "description": "To use a Java bean (aka method call) in Camel expressions or predicates.",
      "properties": {
        "bean": {
          "kind": "attribute",
          "type": "string",
          "description": "Either a reference or a class name of the bean to use",
          "title": "Bean",
          "required": false,
          "deprecated": true
        },
        "ref": {
          "kind": "attribute",
          "type": "string",
          "description": "Reference to bean to lookup in the registry",
          "title": "Ref",
          "required": false,
          "deprecated": false
        },
        "method": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of method to call",
          "title": "Method",
          "required": false,
          "deprecated": false
        },
        "beanType": {
          "kind": "attribute",
          "type": "string",
          "description": "Class name of the bean to use",
          "title": "Bean Type",
          "required": false,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "mvel": {
      "type": "object",
      "title": "MVEL",
      "group": "language,java",
      "icon": "generic24.png",
      "description": "To use MVEL scripts in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "ognl": {
      "type": "object",
      "title": "OGNL",
      "group": "language,java",
      "icon": "generic24.png",
      "description": "To use OGNL scripts in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "php": {
      "type": "object",
      "title": "PHP",
      "group": "language,script",
      "icon": "generic24.png",
      "description": "To use PHP scripts in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "python": {
      "type": "object",
      "title": "Python",
      "group": "language,script",
      "icon": "generic24.png",
      "description": "To use Python scripts in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "ref": {
      "type": "object",
      "title": "Ref",
      "group": "language,core",
      "icon": "generic24.png",
      "description": "Reference to an existing Camel expression or predicate, which is looked up from the Camel registry.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "ruby": {
      "type": "object",
      "title": "Ruby",
      "group": "language,script",
      "icon": "generic24.png",
      "description": "To use Ruby scripts in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "simple": {
      "type": "object",
      "title": "Simple",
      "group": "language,core,java",
      "icon": "generic24.png",
      "description": "To use Camels built-in Simple language in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "resultType": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name of the result type (type from output)",
          "title": "Result Type",
          "required": false,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "spel": {
      "type": "object",
      "title": "SpEL",
      "group": "language,spring",
      "icon": "generic24.png",
      "description": "To use Spring Expression Language (SpEL) in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "sql": {
      "type": "object",
      "title": "SQL",
      "group": "language",
      "icon": "generic24.png",
      "description": "To use SQL (on Java beans) in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "terser": {
      "type": "object",
      "title": "HL7 Terser",
      "group": "language,hl7",
      "icon": "generic24.png",
      "description": "To use HL7 terser scripts in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "tokenize": {
      "type": "object",
      "title": "Tokenize",
      "group": "language,core",
      "icon": "generic24.png",
      "description": "To use Camel message body or header with a tokenizer in Camel expressions or predicates.",
      "properties": {
        "token": {
          "kind": "attribute",
          "type": "string",
          "description": "The (start) token to use as tokenizer, for example you can use the new line token. You can use simple language as the token to support dynamic tokens.",
          "title": "Token",
          "required": true,
          "deprecated": false
        },
        "endToken": {
          "kind": "attribute",
          "type": "string",
          "description": "The end token to use as tokenizer if using start/end token pairs. You can use simple language as the token to support dynamic tokens.",
          "title": "End Token",
          "required": false,
          "deprecated": false
        },
        "inheritNamespaceTagName": {
          "kind": "attribute",
          "type": "string",
          "description": "To inherit namespaces from a root/parent tag name when using XML You can use simple language as the tag name to support dynamic names.",
          "title": "Inherit Namespace Tag Name",
          "required": false,
          "deprecated": false
        },
        "headerName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of header to tokenize instead of using the message body.",
          "title": "Header Name",
          "required": false,
          "deprecated": false
        },
        "regex": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "If the token is a regular expression pattern. The default value is false",
          "title": "Regex",
          "required": false,
          "deprecated": false
        },
        "xml": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether the input is XML messages. This option must be set to true if working with XML payloads.",
          "title": "Xml",
          "required": false,
          "deprecated": false
        },
        "includeTokens": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to include the tokens in the parts when using pairs The default value is false",
          "title": "Include Tokens",
          "required": false,
          "deprecated": false
        },
        "group": {
          "kind": "attribute",
          "type": "string",
          "description": "To group N parts together, for example to split big files into chunks of 1000 lines. You can use simple language as the group to support dynamic group sizes.",
          "title": "Group",
          "required": false,
          "deprecated": false
        },
        "skipFirst": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "To skip the very first element",
          "title": "Skip First",
          "required": false,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "xpath": {
      "type": "object",
      "title": "XPath",
      "group": "language,core,xml",
      "icon": "generic24.png",
      "description": "To use XPath (XML) in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "documentType": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of class for document type The default value is org.w3c.dom.Document",
          "title": "Document Type",
          "required": false,
          "deprecated": false
        },
        "resultType": {
          "kind": "attribute",
          "type": "string",
          "defaultValue": "NODESET",
          "enum": [ "BOOLEAN", "NODE", "NODESET", "NUMBER", "STRING" ],
          "description": "Sets the class name of the result type (type from output) The default result type is NodeSet",
          "title": "Result Type",
          "required": false,
          "deprecated": false
        },
        "saxon": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to use Saxon.",
          "title": "Saxon",
          "required": false,
          "deprecated": false
        },
        "factoryRef": {
          "kind": "attribute",
          "type": "string",
          "description": "References to a custom XPathFactory to lookup in the registry",
          "title": "Factory Ref",
          "required": false,
          "deprecated": false
        },
        "objectModel": {
          "kind": "attribute",
          "type": "string",
          "description": "The XPath object model to use",
          "title": "Object Model",
          "required": false,
          "deprecated": false
        },
        "logNamespaces": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to log namespaces which can assist during trouble shooting",
          "title": "Log Namespaces",
          "required": false,
          "deprecated": false
        },
        "headerName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of header to use as input, instead of the message body",
          "title": "Header Name",
          "required": false,
          "deprecated": false
        },
        "threadSafety": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "false",
          "description": "Whether to enable thread-safety for the returned result of the xpath expression. This applies to when using NODESET as the result type, and the returned set has multiple elements. In this situation there can be thread-safety issues if you process the NODESET concurrently such as from a Camel Splitter EIP in parallel processing mode. This option prevents concurrency issues by doing defensive copies of the nodes. It is recommended to turn this option on if you are using camel-saxon or Saxon in your application. Saxon has thread-safety issues which can be prevented by turning this option on.",
          "title": "Thread Safety",
          "required": false,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "xquery": {
      "type": "object",
      "title": "XQuery",
      "group": "language,xml",
      "icon": "generic24.png",
      "description": "To use XQuery (XML) in Camel expressions or predicates.",
      "properties": {
        "expression": {
          "kind": "value",
          "type": "string",
          "description": "The expression value in your chosen language syntax",
          "title": "Expression",
          "required": true,
          "deprecated": false
        },
        "type": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the class name of the result type (type from output) The default result type is NodeSet",
          "title": "Type",
          "required": false,
          "deprecated": false
        },
        "headerName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of header to use as input, instead of the message body",
          "title": "Header Name",
          "required": false,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    },
    "xtokenize": {
      "type": "object",
      "title": "XML Tokenize",
      "group": "language,core,xml",
      "icon": "generic24.png",
      "description": "To use Camel message body or header with a XML tokenizer in Camel expressions or predicates.",
      "properties": {
        "headerName": {
          "kind": "attribute",
          "type": "string",
          "description": "Name of header to tokenize instead of using the message body.",
          "title": "Header Name",
          "required": false,
          "deprecated": false
        },
        "mode": {
          "kind": "attribute",
          "type": "string",
          "description": "The extraction mode. The available extraction modes are: i - injecting the contextual namespace bindings into the extracted token (default) w - wrapping the extracted token in its ancestor context u - unwrapping the extracted token to its child content t - extracting the text content of the specified element",
          "title": "Mode",
          "required": false,
          "deprecated": false
        },
        "group": {
          "kind": "attribute",
          "type": "integer",
          "description": "To group N parts together",
          "title": "Group",
          "required": false,
          "deprecated": false
        },
        "trim": {
          "kind": "attribute",
          "type": "boolean",
          "defaultValue": "true",
          "description": "Whether to trim the value to remove leading and trailing whitespaces and line breaks",
          "title": "Trim",
          "required": false,
          "deprecated": false
        },
        "id": {
          "kind": "attribute",
          "type": "string",
          "description": "Sets the id of this node",
          "title": "Id",
          "required": false,
          "deprecated": false
        }
      }
    }
  }
};

/*****************************************************************************
 * Metrics-Watcher
 *
 * Copyright 2012 Ben Bertola and iovation, Inc.
 *
 * To use this library:
 * 1. Call metricsWatcher.addXXX() for each graph you want on your page
 * 2. Call metricsWatcher.initGraphs() once to draw the initial graphs
 * 3. Call metricsWatcher.updateGraphs(jsonData) with JSON data from your
 *    metrics/servlet as often as you'd like your graphs to update
 *
 *****************************************************************************/

(function(metricsWatcher, $) {

	/**
	 * Add a Gauge type graph to your page.
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param metricName The metric name of your metrics data, from the metrics servlet
	 * @param title The user-displayed title of this graph
	 */
	metricsWatcher.addGauge = function(divId, className, metricName, title) {
		var metricInfo = new MetricInfo(divId, className, metricName, null, title, 'gauges', null);
		graphs.push(metricInfo);
	};

	/**
	 * Add a Meter type graph to your page.
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param metricName The metric name of your metrics data, from the metrics servlet
	 * @param max What the max value target is, used to determine the % width of progress bars for this graph
	 * @param title The user-displayed title of this graph
	 */
	metricsWatcher.addMeter = function(divId, className, metricName, max, title, eventType) {
		if (eventType == undefined) eventType = 'Calls';
		var metricInfo = new MetricInfo(divId, className, metricName, max, title, 'meters', eventType);
		metricInfo.eventType = eventType;
		graphs.push(metricInfo);
	};

	/**
	 * Add a Counter graph
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param metricName The metric name of your metrics data, from the metrics servlet
	 * @param max What the max value target is, used to determine the % width of progress bars for this graph
	 * @param title The user-displayed title of this graph
	 */
	metricsWatcher.addCounter = function(divId, className, metricName, max, title) {
		var metricInfo = new MetricInfo(divId, className, metricName, max, title, 'counters', null);
		graphs.push(metricInfo);
	};

		/**
	 * Add a standalone Histogram graph
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param metricName The metric name of your metrics data, from the metrics servlet
	 * @param max What the max value target is, used to determine the % width of progress bars for this graph
	 * @param title The user-displayed title of this graph
	 */
	metricsWatcher.addHistogram = function(divId, className, metricName, max, title){
		var metricInfo = new MetricInfo(divId, className, metricName, (!max ? 1: max), title, 'histograms', null);
		graphs.push(metricInfo);
	};

	/**
	 * Add a linked Counter graph. Linked Counters differ from a plain counter graph in that both the numerator and denominator
	 * of a linked counter graph each come from individual Counter Metrics.
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param metricName The metric name of your metrics data, from the metrics servlet
	 * @param maxClassName
	 * @param maxMetricName
	 * @param title The user-displayed title of this graph
	 */
	metricsWatcher.addLinkedCounter = function(divId, className, metricName, maxClassName, maxMetricName, title) {
		var metricInfo = new MetricInfo(divId, className, metricName, null, title, "counters", null);
		if(!metricInfo)
			metricInfo = new MetricInfo(divId, className, metricName, null, title, "timers", null);
		
		metricInfo.maxClassName = maxClassName;
		metricInfo.maxMetricName = maxMetricName;

		metricInfo.getMax = function(json) {
			var maxNode = this.getMetricNode(this.maxClassName, this.maxMetricName, json);
			return maxNode["count"];
		};
		
			metricInfo.getMetricNode = function getMetricNode(className, metricName, jsonRoot) {
				
				var node=!(jsonRoot["counters"][className+'.'+metricName]) ? null : jsonRoot["counters"][className+'.'+metricName];
				if(node){
					return node;
				}else{
					return !(jsonRoot["timers"][className+'.'+metricName]) ? null : jsonRoot["timers"][className+'.'+metricName];
				}
			};

		graphs.push(metricInfo);
	};

	/**
	 * Add a Timer graph. This will include a Meter, Timing Info, and a Histogram.
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param metricName The metric name of your metrics data, from the metrics servlet
	 * @param max The max target value for the Meter, showing frequency
	 * @param title The user-displayed title of this graph
	 * @param eventType a name for this event type
	 * @param durationMax The max target value for duration
	 */
	metricsWatcher.addTimer = function(divId, className, metricName, max, title, eventType, durationMax) {
		var timer = addTimerInternal(divId, className, metricName, max, title, eventType, durationMax, false);
		graphs.push(timer);
	};

	/**
	 * Add an ehcache graph.
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param title The user-displayed title of this graph
	 */
	metricsWatcher.addCache = function(divId, className, title) {
		var metricInfo = new MetricInfo(divId, className, null, null, title, "caches", null);

		metricInfo.components = {
			gauges : [
				new MetricInfo(null, className, "hits", null, "Hits", "gauges", null),
				new MetricInfo(null, className, "misses", null, "Misses", "gauges", null),
				new MetricInfo(null, className, "objects", null, "Objects", "gauges", null),
				new MetricInfo(null, className, "eviction-count", null, "Eviction Count", "gauges", null),
				new MetricInfo(null, className, "in-memory-hits", null, "In Memory Hits", "gauges", null),
				new MetricInfo(null, className, "in-memory-misses", null, "In Memory Misses", "gauges", null),
				new MetricInfo(null, className, "in-memory-objects", null, "In Memory Objects", "gauges", null),
				new MetricInfo(null, className, "off-heap-hits", null, "Off Heap Hits", "gauges", null),
				new MetricInfo(null, className, "off-heap-misses", null, "Off Heap Misses", "gauges", null),
				new MetricInfo(null, className, "off-heap-objects", null, "Off Heap Objects", "gauges", null),
				new MetricInfo(null, className, "on-disk-hits", null, "On Disk Hits", "gauges", null),
				new MetricInfo(null, className, "on-disk-misses", null, "On Disk Misses", "gauges", null),
				new MetricInfo(null, className, "on-disk-objects", null, "On Disk Objects", "gauges", null),
				new MetricInfo(null, className, "mean-get-time", null, "Mean Get Time", "gauges", null),
				new MetricInfo(null, className, "mean-search-time", null, "Mean Search Time", "gauges", null),
				new MetricInfo(null, className, "searches-per-second", null, "Searches Per Sec", "gauges", null),
				new MetricInfo(null, className, "writer-queue-size", null, "Writer Queue Size", "gauges", null),
				new MetricInfo(null, className, "accuracy", null, "Accuracy", "gauges", null)
			]
		};
		metricInfo.getTimer = addTimerInternal(divId + "gettimer", className, "gets", 5, "Get", "get", 1, true);
		metricInfo.putTimer = addTimerInternal(divId + "puttimer", className, "puts", 5, "Put", "put", 1, true);

		graphs.push(metricInfo);
	};

	/**
	 * Add a JVM graph.
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param title The user-displayed title of this graph
	 */
	metricsWatcher.addJvm = function(divId, className, title) {
		var metricInfo = new MetricInfo(divId, className, null, null, title, "jvms", null);
		graphs.push(metricInfo);
	};

	/**
	 * Add a web server graph.
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param title The user-displayed title of this graph
	 */
	metricsWatcher.addWeb = function(divId, className, title) {
		var metricInfo = new MetricInfo(divId, className, null, null, title, "webs", null);

		metricInfo.components = {
			meters : [
				new MetricInfo(divId + " td.responseCodesOkGraph", className, "responseCodes.ok", 10, "OK Responses", "meters", null),
				new MetricInfo(divId + " td.responseCodesBadRequestGraph", className, "responseCodes.badRequest", 10, "Bad Requests", "meters", null),
				new MetricInfo(divId + " td.responseCodesCreatedGraph", className, "responseCodes.created", 10, "Created Responses", "meters", null),
				new MetricInfo(divId + " td.responseCodesNoContentGraph", className, "responseCodes.noContent", 10, "No Content Responses", "meters", null),
				new MetricInfo(divId + " td.responseCodesNotFoundGraph", className, "responseCodes.notFound", 10, "Not Found Responses", "meters", null),
				new MetricInfo(divId + " td.responseCodesOtherGraph", className, "responseCodes.other", 10, "Other Responses", "meters", null),
				new MetricInfo(divId + " td.responseCodesServerErrorGraph", className, "responseCodes.serverError", 10, "Server Error Responses", "meters", null)
			],
			activeRequestsInfo : new MetricInfo(divId + " td.activeRequestsGraph", className, "activeRequests", 10, "Active Requests", "counters", null),
			requestsInfo : addTimerInternal(divId + " td.requestsGraph", className, "requests", 100, "Requests", "requests", 100, true)
		};

		graphs.push(metricInfo);
	};

	/**
	 * Add a log4j logged events graph.
	 *
	 * @param divId The id of the div to draw the graph in
	 * @param className The class name of your metrics data, from the metrics servlet
	 * @param title The user-displayed title of this graph
	 */
	metricsWatcher.addLog4j = function(divId, className, title) {
		var metricInfo = new MetricInfo(divId, className, null, null, title, "log4js", null);

		metricInfo.components = {
			meters : [
				new MetricInfo(divId + " td.all", className, "all", 100, "all", "meters", null),
				new MetricInfo(divId + " td.fatal", className, "fatal", 100, "fatal", "meters", null),
				new MetricInfo(divId + " td.error", className, "error", 100, "error", "meters", null),
				new MetricInfo(divId + " td.warn", className, "warn", 100, "warn", "meters", null),
				new MetricInfo(divId + " td.info", className, "info", 100, "info", "meters", null),
				new MetricInfo(divId + " td.debug", className, "debug", 100, "debug", "meters", null),
				new MetricInfo(divId + " td.trace", className, "trace", 100, "trace", "meters", null)
			]
		};

		graphs.push(metricInfo);
	};

	/**
	 * Initialized each of the graphs that you have added through addXXX() calls,
	 * and draws them on the screen for the first time
	 */
	metricsWatcher.initGraphs = function() {
		// draw all graphs for the first time
		for (var i = 0; i < graphs.length; i++) {
			if (graphs[i].type == "gauges")
				drawGauge(graphs[i]);
			else if (graphs[i].type == "meters")
				drawMeter(graphs[i]);
			else if (graphs[i].type == "counters" || graphs[i].type == "linkedTimerCounters")
				drawCounter(graphs[i]);
			else if (graphs[i].type == "histograms")
				drawHistogram(graphs[i]);
			else if (graphs[i].type == "timers")
				drawTimer(graphs[i]);
			else if (graphs[i].type == "caches")
				drawCache(graphs[i]);
			else if (graphs[i].type == "jvms")
				drawJvm(graphs[i]);
			else if (graphs[i].type == "webs")
				drawWeb(graphs[i]);
			else if (graphs[i].type == "log4js")
				drawLog4j(graphs[i]);
			else
				alert("Unknown meter info type: " + graphs[i].type);
		}
	};

	/**
	 * Update the existing graphs with new data. You can call this method as frequently as you would
	 * like to, and all graph info will be updated.
	 *
	 * @param json The root of the json node returned from your ajax call to the metrics servlet
	 */
	metricsWatcher.updateGraphs = function(json) {
		for (var i = 0; i < graphs.length; i++) {
			if (graphs[i].type == "gauges")
				updateGauge(graphs[i], json);
			else if (graphs[i].type == "meters")
				updateMeter(graphs[i], json);
			else if (graphs[i].type == "counters" || graphs[i].type == "linkedTimerCounters")
				updateCounter(graphs[i], json);
			else if (graphs[i].type == "histograms")
				updateHistogram(graphs[i], json);
			else if (graphs[i].type == "timers")
				updateTimer(graphs[i], json);
			else if (graphs[i].type == "caches")
				updateCache(graphs[i], json);
			else if (graphs[i].type == "jvms")
				updateJvm(graphs[i], json);
			else if (graphs[i].type == "webs")
				updateWeb(graphs[i], json);
			else if (graphs[i].type == "log4js")
				updateLog4j(graphs[i], json);
			else
				alert("Unknown meter info type: " + graphs[i].type);
		}
	};

	/*
	 * Private Methods
	 */
	var graphs = [];

  function MetricInfo(divId, className, metricName, max, title, type, subTitle) {
		this.divId = divId;
		this.className = className;
		this.metricName = metricName;
		this.max = max;
		this.title = title;
		this.type = type;
    this.subTitle = subTitle;

		this.getMax = function(json) {
			return this.max;
		};
		this.getMetricNode = function getMetricNode(className, metricName, jsonRoot) {
			return !(jsonRoot[type][className+'.'+metricName]) ? null : jsonRoot[type][className+'.'+metricName];
		};

    this.getSubTitle = function() {
      if (this.subTitle != null) {
        return this.subTitle;
      } else {
        // fallback and use title
        return this.title;
      }
    }
	}

	function calculatePercentage(currentVal, maxVal) {
		var p = (currentVal / maxVal) * 100;
		return p.toFixed(0);
	}

	function formatNumber(varNumber, n) {
		if (isNaN(n)) n = 1;

		return !isNaN(varNumber)?varNumber.toFixed(n):n;
	}

	function capitalizeFirstLetter(input) {
		return input.charAt(0).toUpperCase() + input.slice(1);
	}

	function addTimerInternal(divId, className, metricName, max, title, eventType, durationMax, isNested) {
		var metricInfo = new MetricInfo(divId, className, metricName, max, title, 'timers', eventType);

		metricInfo.getMeterInfo = function() {
			var myDivId = this.divId + " div.timerGraph div.meterGraph";
			var retVal = new MetricInfo(myDivId, this.className, this.metricName, this.max, "Frequency", 'timers', null);

			retVal.getMetricNode = function(className, metricName, jsonRoot) {
				return !jsonRoot['timers'][className+'.'+metricName] ? null : jsonRoot['timers'][className+'.'+metricName];
			};

			retVal.eventType = eventType;
			return retVal;
		};

		metricInfo.getTimerStatsDivId = function() {
			return "#" + this.divId + " div.timerGraph div.timerStatsGraph";
		};
		metricInfo.getTimerHistogramDivId = function() {
			return "#" + this.divId + " div.timerGraph div.timerHistogram";
		};
		metricInfo.durationMax = durationMax;
		metricInfo.isNested = isNested;

		return metricInfo;
	}

	/*
	 * Counter methods
	 */
	function drawCounter(counterInfo) {
		var parentDiv = $("#" + counterInfo.divId);
		var html = "<div class='counter counterGraph'><h3>" + counterInfo.title
				+ "</h3><div class='progress'><div class='progress-bar' style='width: 0%;'></div></div></div>";
		parentDiv.html(html);
	}
	
	function updateCounter(counterInfo, json) {
		var metricData = counterInfo.getMetricNode(counterInfo.className, counterInfo.metricName, json);
		var pct = calculatePercentage(metricData.count, counterInfo.getMax(json));

		$("#" + counterInfo.divId + " div.progress div.progress-bar").css("width", pct + "%");
		$("#" + counterInfo.divId + " div.progress div.progress-bar").html(metricData.count + "/" + counterInfo.getMax(json));
	}

	/*
	 * Timer methods
	 */
	function drawTimer(timerInfo) {
		var parentDiv = $("#" + timerInfo.divId);

		var nested = (timerInfo.isNested) ? " nested" : "";
		var html = 
          '<div class="metricsWatcher timer timerGraph' + nested + '">'
        + '  <div class="panel-group" id="accordion-' + timerInfo.divId + '">'
				+ '    <div class="panel panel-default">'
				+ '      <div class="panel-heading">'
				+ '        <h4 class="panel-title">'
        +            ((timerInfo.isNested)
                       ? '<a>'
                       : '<a data-toggle="collapse" data-parent="accordion-' + timerInfo.divId + '" href="#' + timerInfo.divId + 'Collapse">')
				+            timerInfo.title + '</a>'
				+ '        </h4>'
				+ '      </div>'
				+ '      <div id="' + timerInfo.divId + 'Collapse" class="panel-collapse' + ((timerInfo.isNested) ? '': ' collapse in') + '">'
				+ '        <div class="panel-body">'
				+ '          <div class="meterGraph col-md-12 col-lg-4"></div>'
				+ '          <div class="timerStatsGraph col-md-12 col-lg-4"></div>'
				+ '          <div class="timerHistogram col-md-12 col-lg-4"></div>'
				+ '        </div>'
        + '      </div>'
        + '    </div>'
        + '  </div>'
        + '</div>';
		parentDiv.html(html);

		drawMeter(timerInfo.getMeterInfo());
		drawDurationStats(timerInfo);
		drawDurationHistogram(timerInfo);
	};

	function drawDurationStats(timerInfo) {
		var html = "<h3>Duration</h3><div class='timeUnit'></div><div class='metricGraph'><table class='progressTable'>"
			+ addMeterRow("Min", "min")
			+ addMeterRow("Mean", "mean")
			+ addMeterRow("Max", "max")
			+ addMeterRow("Std&nbsp;Dev", "stddev")
			+ "</table></div>";
		var parentDiv = $(timerInfo.getTimerStatsDivId());
		parentDiv.html(html);
	}

	function drawDurationHistogram(timerInfo) {
		var html = "<h3> " +(timerInfo.isNested?  "Histogram" :timerInfo.getSubTitle()) + "</h3><div>Percentiles</div><div class='metricGraph'><table class='progressTable'>"
			+ addMeterRow("99.9%", "p999")
			+ addMeterRow("99%", "p99")
			+ addMeterRow("98%", "p98")
			+ addMeterRow("95%", "p95")
			+ addMeterRow("75%", "p75")
			+ addMeterRow("50%", "p50")
			+ "</table></div>";
		var parentDiv = $(timerInfo.getTimerHistogramDivId());
		parentDiv.html(html);
	}

	function updateTimer(timerInfo, json) {
		updateMeter(timerInfo.getMeterInfo(), json);
		updateDurationStats(timerInfo, json);
		updateDurationHistogram(timerInfo, json);
	}

	function updateDurationStats(timerInfo, json) {
		var metricNode = timerInfo.getMetricNode(timerInfo.className, timerInfo.metricName, json);
		if (!metricNode) return;

		var timeUnitDiv = $(timerInfo.getTimerStatsDivId() + " div.timeUnit");
		timeUnitDiv.html(capitalizeFirstLetter(metricNode["duration_units"]));

		updateDuration(timerInfo.getTimerStatsDivId(), metricNode, "min", timerInfo.durationMax);
		updateDuration(timerInfo.getTimerStatsDivId(), metricNode, "mean", timerInfo.durationMax);
		updateDuration(timerInfo.getTimerStatsDivId(), metricNode, "max", timerInfo.durationMax);
		updateDuration(timerInfo.getTimerStatsDivId(), metricNode, "stddev", timerInfo.durationMax);
	}

	function updateDuration(timerStatsDivId, durationData, style, max) {
		$(timerStatsDivId + " tr." + style + " td.progressValue").html(formatNumber(durationData[style]));
		$(timerStatsDivId + " tr." + style + " td.progressBar div.progress div.progress-bar")
			.css("width", calculatePercentage(durationData[style], max) + "%");
	}

	function updateDurationHistogram(timerInfo, json) {
		var metricNode = timerInfo.getMetricNode(timerInfo.className, timerInfo.metricName, json);
		if (!metricNode) return;

		updateDuration(timerInfo.getTimerHistogramDivId(), metricNode, "p999", timerInfo.durationMax);
		updateDuration(timerInfo.getTimerHistogramDivId(), metricNode, "p99", timerInfo.durationMax);
		updateDuration(timerInfo.getTimerHistogramDivId(), metricNode, "p98", timerInfo.durationMax);
		updateDuration(timerInfo.getTimerHistogramDivId(), metricNode, "p95", timerInfo.durationMax);
		updateDuration(timerInfo.getTimerHistogramDivId(), metricNode, "p75", timerInfo.durationMax);
		updateDuration(timerInfo.getTimerHistogramDivId(), metricNode, "p50", timerInfo.durationMax);
	}

/*
 * Histogram methods
 */

	function drawHistogram(histogramInfo) {
		var parentDiv = $("#" + histogramInfo.divId);
		var html = "<div class='metricsWatcher histogram histogramContainer'>" 
			+ "<div class='heading1 btn-link col-md-12' data-toggle='collapse' data-target='#" + histogramInfo.divId + "Collapse'> " +(histogramInfo.isNested?  "Histogram" :histogramInfo.title) + "</div>" 
			+ "<div class='collapse' id='" + histogramInfo.divId + "Collapse'>"
			+ "<table>" 
				+ "<tr><td class='col-md-4'>Count</td><td class='col-md-4'>Min</td><td class='col-md-4'>Max<td class='col-md-4'>Mean</td></tr>" 
				+ "<tr><td class='countVal'></td><td class='minVal'></td><td class='meanVal'></td><td class='maxVal'></td></tr>"
			+ "</table>"
			+	"<p>Percentiles</p>"
			+"<table class='progressTable'>"
			+ addMeterRow("99.9%", "p999")
			+ addMeterRow("99%", "p99")
			+ addMeterRow("98%", "p98")
			+ addMeterRow("95%", "p95")
			+ addMeterRow("75%", "p75")
			+ addMeterRow("50%", "p50")
			+ "</table></div></div>";
		parentDiv.html(html);
	}

	function updateHistogram(histogramInfo, json) {
		var metricNode = histogramInfo.getMetricNode(histogramInfo.className, histogramInfo.metricName, json);
		$("#" + histogramInfo.divId +  " td.countVal").html(formatNumber(metricNode['count'],0));
		$("#" + histogramInfo.divId +  " td.minVal").html(formatNumber(metricNode['min'],0));
		$("#" + histogramInfo.divId +  " td.maxVal").html(formatNumber(metricNode['max'],0));
		$("#" + histogramInfo.divId +  " td.meanVal").html(formatNumber(metricNode['mean'],0));
		
		setMeterRow(histogramInfo, metricNode, "p999", "p999", histogramInfo.max);
		setMeterRow(histogramInfo, metricNode, "p99", "p99", histogramInfo.max);
		setMeterRow(histogramInfo, metricNode, "p98", "p98", histogramInfo.max);
		setMeterRow(histogramInfo, metricNode, "p95", "p95", histogramInfo.max);
		setMeterRow(histogramInfo, metricNode, "p75", "p75", histogramInfo.max);
		setMeterRow(histogramInfo, metricNode, "p50", "p50", histogramInfo.max);
	}

	/*
	 * Meter methods
	 */
	function drawMeter(meterInfo) {
		var parentDiv = $("#" + meterInfo.divId);

		var html = "<div class='metric metricGraph'><h3>" + meterInfo.title
			+ "</h3><div class='counterVal'></div><table class='progressTable'>"
			+ addMeterRow("1&nbsp;min", "onemin")
			+ addMeterRow("5&nbsp;min", "fivemin")
			+ addMeterRow("15&nbsp;min", "fifteenmin")
			+ addMeterRow("Mean", "mean")
			+ "</table></div>";
		parentDiv.html(html);
	}

	function addMeterRow(type, className) {
		return "<tr class='" + className + "'><td class='progressLabel'>" + type + "</td>"
			+ "<td class='progressBar'><div class='progress'><div class='progress-bar' style='width: 0%;'></div>"
			+ "</div></td><td class='progressValue'>0</td></tr>";
	}

	function updateMeter(meterInfo, json) {
		var metricData = meterInfo.getMetricNode(meterInfo.className, meterInfo.metricName, json);
		if (metricData) {
			updateMeterData(meterInfo, metricData);
		}
	}

	function updateMeterData(meterInfo, meterData) {
		// set the big counter
		var gaugeDiv = $("#" + meterInfo.divId + " div.counterVal");

		gaugeDiv.html(meterData.rate_units + " (" + meterData.count + " total)");

		var maxRate = Math.max(meterData['mean_rate'],meterData['m1_rate'],meterData['m5_rate'],meterData['m15_rate']);

		// set the mean count
		setMeterRow(meterInfo, meterData, "mean_rate", "mean", maxRate);
		setMeterRow(meterInfo, meterData, "m1_rate", "onemin", maxRate);
		setMeterRow(meterInfo, meterData, "m5_rate", "fivemin", maxRate);
		setMeterRow(meterInfo, meterData, "m15_rate", "fifteenmin", maxRate);
	}

	function setMeterRow(meterInfo, meterData, rowType, rowStyle) {
		setMeterRow(meterInfo, meterData, rowType, rowStyle, meterInfo.max);
	}

	function setMeterRow(meterInfo, meterData, rowType, rowStyle, max) {
		$("#" + meterInfo.divId + " tr." + rowStyle + " td.progressValue").html(formatNumber(meterData[rowType]));
		$("#" + meterInfo.divId + " tr." + rowStyle + " td.progressBar div.progress div.progress-bar")
			.css("width", calculatePercentage(meterData[rowType], max) + "%");
	}

	/*
	 * Gauge methods
	 */
	function drawGauge(gaugeInfo) {
		var parentDiv = $("#" + gaugeInfo.divId);
		var html = "<div class='metric metricGraph'><h3>" + gaugeInfo.title + "</h3><div class='gaugeDataVal'></div></div>";
		parentDiv.html(html);
	}
	function updateGauge(gaugeInfo, json) {
		var metricData = gaugeInfo.getMetricNode(gaugeInfo.className, gaugeInfo.metricName, json);
		if (metricData) {
			updateGaugeData(gaugeInfo, metricData);
		}
	}
	function updateGaugeData(gaugeInfo, gaugeData) {
		var gaugeDiv = $("#" + gaugeInfo.divId + " div.gaugeDataVal");
		gaugeDiv.html(gaugeData.value);
	}

	/*
	 * GaugeTable methods
	 */
	function drawGaugeTable(divId, title, gauges) {
		var parentDiv = $("#" + divId);
		var html = "<div class='metricsWatcher metric metricGraph nested'>"
				+ "<fieldset><legend><div class='heading1'>" + title + "</div></legend>"
				+ "<div class='gaugeTableContainer'><table class='gaugeTable'></table></div></fieldset></div>";

		parentDiv.html(html);
	}
	function updateGaugeTable(divId, gauges, json) {
		var div = $("#" + divId + " table");

		var html = "";
		var length = gauges.length;
		for (var i = 0; i < length; i++) {
			var gauge = gauges[i];
			html += "<tr><td><h5>" + gauge.title + "</h5></td>"
				+ "<td><h4>" + gauge.getMetricNode(gauge.className, gauge.metricName, json).value
				+ "</h4></td></tr>";
		}
		div.html(html);
	}

	/*
	 * Cache methods
	 */
	function drawCache(cacheInfo) {
		var parentDiv = $("#" + cacheInfo.divId);

		var html = "<div class='metricsWatcher cache cacheGraph col-md-12'>"
				+ "<fieldset><legend><div class='heading1'>" + cacheInfo.title + "</div></legend>"
				+ "<div class='cacheContainer col-md-12'>"
				+ "	<div class='row'>"
				+ "		<div class='col-md-3'><div id='" + cacheInfo.divId + "Statistics'></div></div>"
				+ "		<div class='col-md-9'>"
				+ "			<div id='" + cacheInfo.divId + "gettimer'></div>"
				+ "			<div id='" + cacheInfo.divId + "puttimer'></div>"
				+ "		</div>"
				+ "	</div>"
				+ "</div></fieldset></div>";
		parentDiv.html(html);

		var length = cacheInfo.components.gauges.length;
		for (var i = 0; i < length; i++) {
			drawGauge(cacheInfo.components.gauges[i]);
		}
		drawTimer(cacheInfo.getTimer);
		drawTimer(cacheInfo.putTimer);
		drawGaugeTable(cacheInfo.divId + "Statistics", "Statistics", cacheInfo.components.gauges);
	}
	function updateCache(cacheInfo, json) {
		var length = cacheInfo.components.gauges.length;
		for (var i = 0; i < length; i++) {
			var gauge = cacheInfo.components.gauges[i];
			var data = gauge.getMetricNode(cacheInfo.className, gauge.metricName, json);
			if (data) {
				var gaugeDiv = $("#" + gauge.divId + " div.metricGraph div.gaugeDataVal");
				gaugeDiv.html(data.value);
			}
		}
		updateTimer(cacheInfo.getTimer, json);
		updateTimer(cacheInfo.putTimer, json);
		updateGaugeTable(cacheInfo.divId + "Statistics", cacheInfo.components.gauges, json);
	}

	/*
	 * JVM methods
	 */
	function drawJvm(jvmInfo) {
		var parentDiv = $("#" + jvmInfo.divId);
		var html = "<div class='metricsWatcher jvm metricGraph col-md-12'>"
				+ "<fieldset><legend><div  class='heading1 btn-link' data-toggle='collapse' data-target='#" + jvmInfo.divId + "Collapse'>" + jvmInfo.title + "</div></legend>"
				+ "<div class='jvmContainer col-md-12 collapse' id='" + jvmInfo.divId + "Collapse'>"
				+ "	<div id='" + jvmInfo.divId + "Vm'></div>"
				+ "</div>"
				+ "</fieldset></div>";
		parentDiv.html(html);
	}

	function updateJvm(jvmInfo, json) {
		var vmDiv = $("#" + jvmInfo.divId + "Vm");
		var jvm = json['gauges'];
		var html = "<div class='row'>"
				+ "<div class='col-md-3'><table class='jvmTable'><caption>Memory</caption>"
				+ "<tr><td><h5>Total Init</h5></td><td>" + jvm['jvm.memory.total.init'].value + "</td></tr>"
				+ "<tr><td><h5>Total Used</h5></td><td>" + jvm['jvm.memory.total.used'].value + "</td></tr>"
				+ "<tr><td><h5>Total Max</h5></td><td>" + jvm['jvm.memory.total.max'].value + "</td></tr>"
				+ "<tr><td><h5>Total Committed</h5></td><td>" + jvm['jvm.memory.total.committed'].value + "</td></tr>"
				+ "<tr><td><h5>Heap Init</h5></td><td>" + jvm['jvm.memory.heap.init'].value + "</td></tr>"
				+ "<tr><td><h5>Heap Used</h5></td><td>" + jvm['jvm.memory.heap.used'].value + "</td></tr>"
				+ "<tr><td><h5>Heap Max</h5></td><td>" + jvm['jvm.memory.heap.max'].value + "</td></tr>"
				+ "<tr><td><h5>Heap Committed</h5></td><td>" + jvm['jvm.memory.heap.committed'].value + "</td></tr>"
				+ "<tr><td><h5>Non Heap Init</h5></td><td>" + jvm['jvm.memory.non-heap.init'].value + "</td></tr>"
				+ "<tr><td><h5>Non Heap Used</h5></td><td>" + jvm['jvm.memory.non-heap.used'].value + "</td></tr>"
				+ "<tr><td><h5>Non Heap Max</h5></td><td>" + jvm['jvm.memory.non-heap.max'].value + "</td></tr>"
				+ "<tr><td><h5>Non Heap Committed</h5></td><td>" + jvm['jvm.memory.non-heap.committed'].value + "</td></tr>"
				+ "</table></div>"
				+ "<div class='col-md-3'><table class='jvmTable'><caption>Memory Usage</caption>"
				+ "<tr><td><h5>Heap Usage</h5></td><td>" + (jvm['jvm.memory.heap.usage'].value * 100).toFixed(2) + "</td></tr>"
				+ "<tr><td><h5>Non Heap Usage</h5></td><td>" + (jvm['jvm.memory.non-heap.usage'].value * 100).toFixed(2) + "</td></tr>"
				+ (!jvm['jvm.memory.pools.JIT-code-cache.usage']?"":("<tr><td><h5>JIT Code Cache Usage</h5></td><td>" + (jvm['jvm.memory.pools.JIT-code-cache.usage'].value * 100).toFixed(2) + "</td></tr>"))
				+ (!jvm['jvm.memory.pools.Code-Cache.usage']?"":("<tr><td><h5>JIT Code Cache Usage</h5></td><td>" + (jvm['jvm.memory.pools.Code-Cache.usage'].value * 100).toFixed(2) + "</td></tr>"))
				+ (!jvm['jvm.memory.pools.JIT-data-cache.usage']?"":("<tr><td><h5>JIT Data Cache Usage</h5></td><td>" + (jvm['jvm.memory.pools.JIT-data-cache.usage'].value * 100).toFixed(2) + "</td></tr>"))
				+ (!jvm['jvm.memory.pools.Java-heap.usage']?"":("<tr><td><h5>Java Heap Usage</h5></td><td>" + (jvm['jvm.memory.pools.Java-heap.usage'].value * 100).toFixed(2) + "</td></tr>"))
				+ (!jvm['jvm.memory.pools.class-storage.usage']?"":("<tr><td><h5>Class Storage Usage</h5></td><td>" + (jvm['jvm.memory.pools.class-storage.usage'].value * 100).toFixed(2) + "</td></tr>"))
				+ (!jvm['jvm.memory.pools.Perm-Gen.usage']?"":("<tr><td><h5>Perm Gen Usage</h5></td><td>" + (jvm['jvm.memory.pools.Perm-Gen.usage'].value * 100).toFixed(2) + "</td></tr>"))
				+ (!jvm['jvm.memory.pools.Tenured-Gen.usage']?"":("<tr><td><h5>Tenured Gen Usage</h5></td><td>" + (jvm['jvm.memory.pools.Tenured-Gen.usage'].value * 100).toFixed(2) + "</td></tr>"))
				+ (!jvm['jvm.memory.pools.miscellaneous-non-heap-storage.usage']?"":("<tr><td><h5>Misc Non Heap Storage Usage</h5></td><td>" + (jvm['jvm.memory.pools.miscellaneous-non-heap-storage.usage'].value * 100).toFixed(2)  + "</td></tr>"))
				+ (!jvm['jvm.memory.pools.Survivor-Space.usage']?"":("<tr><td><h5>Survivor Space Usage</h5></td><td>" + (jvm['jvm.memory.pools.Survivor-Space.usage'].value * 100).toFixed(2) + "</td></tr>"))
				+ (!jvm['jvm.memory.pools.Eden-Space.usage']?"":("<tr><td><h5>Eden Space Usage</h5></td><td>" + (jvm['jvm.memory.pools.Eden-Space.usage'].value * 100).toFixed(2) + "</td></tr>"))
				+"</table></div>"
				+ "<div class='col-md-3'><table class='jvmTable'><caption>Garbage Collection</caption>"
				+ "<tr><td><h5>PS Mark Sweep Runs</h5></td><td>" + jvm['jvm.gc.MarkSweepCompact.count'].value + "</td></tr>"
				+ "<tr><td><h5>PS Mark Sweep Time</h5></td><td>" + jvm['jvm.gc.MarkSweepCompact.time'].value + "</td></tr>"
				+ "<tr><td><h5>GC Copy Runs</h5></td><td>" + jvm['jvm.gc.Copy.count'].value + "</td></tr>"
				+ "<tr><td><h5>GC Copy Time</h5></td><td>" + jvm['jvm.gc.Copy.time'].value + "</td></tr>"
				+ "</table></div>"
				+ "<div class='col-md-3'><table class='jvmTable'><caption>Threads</caption>"
//				+ "<tr><td class='rowName'><h5>Name</h5></td><td>" + jvm['jvm.vm.name'].value + "</td></tr>"
//				+ "<tr><td><h5>Version</h5></td><td>" + jvm['jvm.vm.version'].value + "</td></tr>"
//				+ "<tr><td><h5>Current Time</h5></td><td>" + jvm['jvm.current_time'].value + "</td></tr>"
//				+ "<tr><td><h5>Uptime</h5></td><td>" + jvm['jvm.uptime'].value + "</td></tr>"
				+ "<tr><td><h5>FD Usage</h5></td><td>" + formatNumber(jvm['jvm.fd.usage'].value, 2) + "</td></tr>"
				+ "<tr><td><h5>Daemon Threads</h5></td><td>" + jvm['jvm.thread-states.daemon.count'].value + "</td></tr>"
				+ "<tr><td><h5>Threads</h5></td><td>" + jvm['jvm.thread-states.count'].value + "</td></tr>"
				+ "<tr><td><h5>Deadlocks</h5></td><td>" + jvm['jvm.thread-states.deadlocks'].value + "</td></tr>"
				+ "</table><table class='jvmTable'><caption>Thread States</caption>"
				+ "<tr><td><h5>Terminated</h5></td><td>" + jvm['jvm.thread-states.terminated.count'].value + "</td></tr>"
				+ "<tr><td><h5>Timed Waiting</h5></td><td>" + jvm['jvm.thread-states.timed_waiting.count'].value + "</td></tr>"
				+ "<tr><td><h5>Blocked</h5></td><td>" + jvm['jvm.thread-states.blocked.count'].value + "</td></tr>"
				+ "<tr><td><h5>Waiting</h5></td><td>" + jvm['jvm.thread-states.waiting.count'].value + "</td></tr>"
				+ "<tr><td><h5>Runnable</h5></td><td>" + jvm['jvm.thread-states.runnable.count'].value + "</td></tr>"
				+ "<tr><td><h5>New</h5></td><td>" + jvm['jvm.thread-states.new.count'].value + "</td></tr>"
				+ "</table></div></div>";

		vmDiv.html(html);
	};

	/*
	 * Web Server methods
	 */
	function drawWeb(webInfo) {
		var parentDiv = $("#" + webInfo.divId);
		var html = "<div class='metricsWatcher web metricGraph col-md-12'>"
				+ "<fieldset><legend><div class='heading1 btn-link' data-toggle='collapse' data-target='#"+webInfo.divId+"Collapse'>" + webInfo.title + "</div></legend>"
				+ "<div class='webContainer col-md-12' id='"+webInfo.divId+"Collapse'>"
				+ "	<div id='" + webInfo.divId + "Web'></div>"
				+ "<table><tr>"
				+ "<td colspan='4' class='requestsGraph col-md-12'></td>"
				+ "</tr><tr>"
				+ "<td class='activeRequestsGraph col-md-3'></td>"
				+ "<td class='responseCodesOkGraph col-md-3'></td>"
				+ "<td class='responseCodesCreatedGraph col-md-3'></td>"
				+ "<td class='responseCodesOtherGraph col-md-3'></td>"
				+ "</tr><tr>"
				+ "<td class='responseCodesBadRequestGraph col-md-3'></td>"
				+ "<td class='responseCodesNoContentGraph col-md-3'></td>"
				+ "<td class='responseCodesNotFoundGraph col-md-3'></td>"
				+ "<td class='responseCodesServerErrorGraph col-md-3'></td>"
				+ "</tr></table>"
				+ "</div>"
				+ "</fieldset></div>";
		parentDiv.html(html);

		drawTimer(webInfo.components.requestsInfo);
		drawCounter(webInfo.components.activeRequestsInfo);

		var length = webInfo.components.meters.length;
		for (var i = 0; i < length; i++) {
			drawMeter(webInfo.components.meters[i]);
		}
	};

	function updateWeb(webInfo, json) {
		updateTimer(webInfo.components.requestsInfo, json);
		updateCounter(webInfo.components.activeRequestsInfo, json);

		var length = webInfo.components.meters.length;
		for (var i = 0; i < length; i++) {
			updateMeter(webInfo.components.meters[i], json);
		}
	};

	/*
	 * Log4j events stream  methods
	 */
	function drawLog4j(log4jInfo) {
		var parentDiv = $("#" + log4jInfo.divId);
		var html = "<div class='metricsWatcher log4j metricGraph col-md-12'>"
				+ "<fieldset><legend><div class='heading1 btn-link' data-toggle='collapse' data-target='#"+log4jInfo.divId+"Collapse'>" + log4jInfo.title + "</div></legend>"
				+ "<div class='log4jContainer col-md-12' id='"+log4jInfo.divId+"Collapse'>"
				+ "	<div id='" + log4jInfo.divId + "Log4j'></div>"
				+ "<table><tr>"
				+ "<td colspan='4' class='col-md-12'></td>"
				+ "</tr><tr>"
				+ "<td class='all col-md-3'></td>"
				+ "<td class='fatal col-md-3'></td>"
				+ "<td class='error col-md-3'></td>"
				+ "<td class='warn col-md-3'></td>"
				+ "</tr><tr>"
				+ "<td class='info col-md-3'></td>"
				+ "<td class='debug col-md-3'></td>"
				+ "<td class='trace col-md-3'></td>"
				+ "</tr></table>"
				+ "</div>"
				+ "</fieldset></div>";
		parentDiv.html(html);

		var length = log4jInfo.components.meters.length;
		for (var i = 0; i < length; i++) {
			drawMeter(log4jInfo.components.meters[i]);
		}
	};

	function updateLog4j(log4jInfo, json) {
		var length = log4jInfo.components.meters.length;
		for (var i = 0; i < length; i++) {
			updateMeter(log4jInfo.components.meters[i], json);
		}
	};

}(window.metricsWatcher = window.metricsWatcher || {}, jQuery));

var Integration;
(function (Integration) {
    configureAboutPage.$inject = ["aboutService"];
    function configureAboutPage(aboutService) {
        'ngInject';
        aboutService.addProductInfo('Hawtio Integration', '4.1.4');
    }
    Integration.configureAboutPage = configureAboutPage;
})(Integration || (Integration = {}));
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.pluginName = 'hawtio-integration-activemq';
    ActiveMQ.log = Logger.get(ActiveMQ.pluginName);
    ActiveMQ.jmxDomain = 'org.apache.activemq';
    function findFolder(node, titles, ascend) {
        if (!node) {
            return null;
        }
        var answer = null;
        angular.forEach(titles, function (title) {
            if (node.text === title) {
                answer = node;
            }
        });
        if (answer === null) {
            if (ascend) {
                var parent = node.parent;
                if (parent) {
                    answer = findFolder(parent, titles, ascend);
                }
            }
            else {
                // retrieves only one level down for children
                angular.forEach(node.children, function (child) {
                    angular.forEach(titles, function (title) {
                        if (child.text === title) {
                            answer = child;
                        }
                    });
                });
            }
        }
        return answer;
    }
    function retrieveQueueNames(workspace, ascend) {
        var selection = workspace.selection;
        var queueFolder = selection ? findFolder(selection, ["Queues", "Queue"], ascend) : null;
        return queueFolder ? queueFolder.children.map(function (n) { return n.text; }) : [];
    }
    ActiveMQ.retrieveQueueNames = retrieveQueueNames;
    function retrieveTopicNames(workspace, ascend) {
        var selection = workspace.selection;
        var topicFolder = selection ? findFolder(selection, ["Topics", "Topic"], ascend) : null;
        return topicFolder ? topicFolder.children.map(function (n) { return n.text; }) : [];
    }
    ActiveMQ.retrieveTopicNames = retrieveTopicNames;
    /**
     * Sets $scope.row to currently selected JMS message.
     * Used in:
     *  - activemq/js/browse.ts
     *  - camel/js/browseEndpoint.ts
     *
     * TODO: remove $scope argument and operate directly on other variables. but it's too much side effects here...
     *
     * @param message
     * @param key unique key inside message that distinguishes between values
     * @param $scope
     */
    function selectCurrentMessage(message, key, $scope) {
        // clicking on message's link would interfere with messages selected with checkboxes
        if ('selectAll' in $scope.gridOptions) {
            $scope.gridOptions.selectAll(false);
        }
        else {
            $scope.gridOptions.selectedItems.length = 0;
        }
        var idx = Core.pathGet(message, ["rowIndex"]) || Core.pathGet(message, ['index']);
        var jmsMessageID = Core.pathGet(message, ["entity", key]);
        $scope.rowIndex = idx;
        var selected = $scope.gridOptions.selectedItems;
        selected.splice(0, selected.length);
        if (idx >= 0 && idx < $scope.messages.length) {
            $scope.row = _.find($scope.messages, function (msg) { return msg[key] === jmsMessageID; });
            if ($scope.row) {
                selected.push($scope.row);
            }
        }
        else {
            $scope.row = null;
        }
    }
    ActiveMQ.selectCurrentMessage = selectCurrentMessage;
    /**
     * - Adds functions needed for message browsing with details
     * - Adds a watch to deselect all rows after closing the slideout with message details
     * TODO: export these functions too?
     *
     * @param $scope
     * @param fn optional function to call if the selected row was changed
     */
    function decorate($scope, fn) {
        if (fn === void 0) { fn = null; }
        $scope.selectRowIndex = function (idx) {
            $scope.rowIndex = idx;
            var selected = $scope.gridOptions.selectedItems;
            selected.splice(0, selected.length);
            if (idx >= 0 && idx < $scope.messages.length) {
                $scope.row = $scope.messages[idx];
                if ($scope.row) {
                    selected.push($scope.row);
                }
            }
            else {
                $scope.row = null;
            }
            if (fn) {
                fn.apply();
            }
        };
        $scope.$watch("showMessageDetails", function () {
            if (!$scope.showMessageDetails) {
                $scope.row = null;
                $scope.gridOptions.selectedItems.splice(0, $scope.gridOptions.selectedItems.length);
            }
        });
    }
    ActiveMQ.decorate = decorate;
    function getBrokerMBean(workspace, jolokia, jmxDomain) {
        var mbean = null;
        var selection = workspace.selection;
        if (selection && isBroker(workspace) && selection.objectName) {
            return selection.objectName;
        }
        if (selection) {
            var folderNames = selection.folderNames;
            var parent = selection ? selection.parent : null;
            if (parent && jolokia && folderNames && folderNames.length > 1) {
                mbean = parent.objectName;
                // we might be a destination, so lets try one more parent
                if (!mbean && parent) {
                    mbean = parent.parent.objectName;
                }
                if (!mbean) {
                    mbean = "" + folderNames[0] + ":BrokerName=" + folderNames[1] + ",Type=Broker";
                }
            }
        }
        return mbean;
    }
    ActiveMQ.getBrokerMBean = getBrokerMBean;
    ;
    function isBroker(workspace) {
        if (workspace.selectionHasDomainAndType(ActiveMQ.jmxDomain, 'Broker')) {
            var self = Core.pathGet(workspace, ["selection"]);
            var parent = Core.pathGet(workspace, ["selection", "parent"]);
            return !(parent && (parent.ancestorHasType('Broker') || self.ancestorHasType('Broker')));
        }
        return false;
    }
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="../activemqHelpers.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    var DestinationController = /** @class */ (function () {
        DestinationController.$inject = ["$scope", "workspace", "$location", "jolokia", "localStorage"];
        function DestinationController($scope, workspace, $location, jolokia, localStorage) {
            'ngInject';
            this.$scope = $scope;
            this.workspace = workspace;
            this.$location = $location;
            this.jolokia = jolokia;
            this.localStorage = localStorage;
            this.amqJmxDomain = this.localStorage['activemqJmxDomain'] || "org.apache.activemq";
            this.message = "";
            this.destinationName = "";
            this.destinationType = "Queue";
            this.createDialog = false;
            this.deleteDialog = false;
            this.purgeDialog = false;
        }
        DestinationController.prototype.operationSuccess = function () {
            this.destinationName = "";
            this.workspace.operationCounter += 1;
            Core.notification("success", this.message);
            this.workspace.loadTree();
            Core.$apply(this.$scope);
        };
        DestinationController.prototype.deleteSuccess = function () {
            // lets set the selection to the parent
            this.workspace.removeAndSelectParentNode();
            this.workspace.operationCounter += 1;
            Core.notification("success", this.message);
            // and switch to show the attributes (table view)
            this.$location.path('/jmx/attributes').search({ "main-tab": "activemq", "sub-tab": "activemq-attributes" });
            this.workspace.loadTree();
            Core.$apply(this.$scope);
        };
        DestinationController.prototype.validateDestinationName = function (name) {
            return name.indexOf(":") === -1;
        };
        DestinationController.prototype.isQueue = function (destinationType) {
            return destinationType === "Queue";
        };
        DestinationController.prototype.checkIfDestinationExists = function (name, destinationType) {
            var answer = false;
            var destinations;
            if (this.isQueue(destinationType)) {
                destinations = ActiveMQ.retrieveQueueNames(this.workspace, false);
            }
            else {
                destinations = ActiveMQ.retrieveTopicNames(this.workspace, false);
            }
            angular.forEach(destinations, function (destination) {
                if (name === destination) {
                    answer = true;
                }
            });
            return answer;
        };
        DestinationController.prototype.validateAndCreateDestination = function (name, destinationType) {
            if (!this.validateDestinationName(name)) {
                this.createDialog = true;
                return;
            }
            if (this.checkIfDestinationExists(name, destinationType)) {
                Core.notification("danger", "The " + this.uncapitalisedDestinationType() + " \"" + name + "\" already exists");
                return;
            }
            this.createDestination(name, destinationType);
        };
        DestinationController.prototype.createDestination = function (name, destinationType) {
            var _this = this;
            var mbean = ActiveMQ.getBrokerMBean(this.workspace, this.jolokia, this.amqJmxDomain);
            name = Core.escapeHtml(name);
            if (mbean) {
                var operation = void 0;
                if (this.isQueue(destinationType)) {
                    operation = "addQueue(java.lang.String)";
                    this.message = "Created queue \"" + name + "\"";
                }
                else {
                    operation = "addTopic(java.lang.String)";
                    this.message = "Created topic \"" + name + "\"";
                }
                if (mbean) {
                    this.jolokia.execute(mbean, operation, name, Core.onSuccess(function () { return _this.operationSuccess(); }));
                }
                else {
                    Core.notification("danger", "Could not find the Broker MBean!");
                }
            }
        };
        /**
         * When destination name contains "_" like "aaa_bbb", the actual name might be either
         * "aaa_bbb" or "aaa:bbb", so the actual name needs to be checked before removal.
         * @param name destination name
         */
        DestinationController.prototype.restoreRealDestinationName = function (name) {
            if (name.indexOf("_") === -1) {
                return name;
            }
            return this.jolokia.getAttribute(this.workspace.getSelectedMBeanName(), "Name", Core.onSuccess(null));
        };
        DestinationController.prototype.deleteDestination = function () {
            var _this = this;
            var mbean = ActiveMQ.getBrokerMBean(this.workspace, this.jolokia, this.amqJmxDomain);
            var selection = this.workspace.selection;
            var entries = selection.entries;
            if (mbean && selection && this.jolokia && entries) {
                var domain = selection.domain;
                var name_1 = entries["Destination"] || entries["destinationName"] || selection.text;
                var operation = void 0;
                if (this.isQueue(entries["Type"] || entries["destinationType"])) {
                    operation = "removeQueue(java.lang.String)";
                    this.message = "Deleted queue \"" + name_1 + "\"";
                }
                else {
                    operation = "removeTopic(java.lang.String)";
                    this.message = "Deleted topic \"" + name_1 + "\"";
                }
                name_1 = this.restoreRealDestinationName(name_1);
                // do not unescape name for destination deletion
                this.jolokia.execute(mbean, operation, name_1, Core.onSuccess(function () { return _this.deleteSuccess(); }));
            }
        };
        DestinationController.prototype.purgeDestination = function () {
            var _this = this;
            var mbean = this.workspace.getSelectedMBeanName();
            var selection = this.workspace.selection;
            var entries = selection.entries;
            if (mbean && selection && this.jolokia && entries) {
                var name_2 = entries["Destination"] || entries["destinationName"] || selection.text;
                var operation = "purge()";
                this.message = "Purged queue \"" + name_2 + "\"";
                // unescape should be done right before invoking jolokia
                name_2 = _.unescape(name_2);
                this.jolokia.execute(mbean, operation, Core.onSuccess(function () { return _this.operationSuccess(); }));
            }
        };
        DestinationController.prototype.selectedName = function () {
            var selection = this.workspace.selection;
            return selection ? _.unescape(selection.text) : null;
        };
        DestinationController.prototype.uncapitalisedDestinationType = function () {
            return this.destinationType.charAt(0).toLowerCase() + this.destinationType.substring(1);
        };
        return DestinationController;
    }());
    ActiveMQ.DestinationController = DestinationController;
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="destination.controller.ts"/>
/// <reference path="../activemqHelpers.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.createDestinationComponent = {
        controller: ActiveMQ.DestinationController,
        templateUrl: 'plugins/activemq/html/destination/create.html'
    };
    ActiveMQ.deleteQueueComponent = {
        controller: ActiveMQ.DestinationController,
        templateUrl: 'plugins/activemq/html/destination/deleteQueue.html'
    };
    ActiveMQ.deleteTopicComponent = {
        controller: ActiveMQ.DestinationController,
        templateUrl: 'plugins/activemq/html/destination/deleteTopic.html'
    };
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="destination.component.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.destinationModule = angular
        .module('hawtio-activemq-destination', [])
        .component('createDestination', ActiveMQ.createDestinationComponent)
        .component('deleteQueue', ActiveMQ.deleteQueueComponent)
        .component('deleteTopic', ActiveMQ.deleteTopicComponent)
        .name;
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="../activemqPlugin.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    var TreeController = /** @class */ (function () {
        TreeController.$inject = ["$scope", "$location", "workspace", "$element"];
        function TreeController($scope, $location, workspace, $element) {
            'ngInject';
            this.$scope = $scope;
            this.$location = $location;
            this.workspace = workspace;
            this.$element = $element;
            // it's not possible to declare classes to the component host tag in AngularJS
            $element.addClass('tree-nav-sidebar-content');
        }
        TreeController.prototype.$onInit = function () {
            var _this = this;
            this.$scope.$on('$destroy', function () { return _this.removeTree(); });
            this.$scope.$on('$routeChangeStart', function () { return Jmx.updateTreeSelectionFromURL(_this.$location, $(ActiveMQ.treeElementId)); });
            this.$scope.$on('jmxTreeUpdated', function () { return _this.populateTree(); });
            this.populateTree();
        };
        TreeController.prototype.updateSelectionFromURL = function () {
            Jmx.updateTreeSelectionFromURLAndAutoSelect(this.$location, $(ActiveMQ.treeElementId), function (first) {
                if (first.children == null) {
                    return null;
                }
                // use function to auto select the queue folder on the 1st broker
                var queues = first.children[0];
                if (queues && queues.text === 'Queue') {
                    return queues;
                }
                return null;
            }, true);
        };
        TreeController.prototype.populateTree = function () {
            var _this = this;
            var children = [];
            var tree = this.workspace.tree;
            if (tree) {
                var domainName = 'org.apache.activemq';
                var folder = tree.get(domainName);
                if (folder) {
                    children = folder.children;
                }
                if (children.length) {
                    var firstChild = children[0];
                    // the children could be AMQ 5.7 style broker name folder with the actual MBean in the children
                    // along with folders for the Queues etc...
                    if (!firstChild.typeName && firstChild.children.length < 4) {
                        // lets avoid the top level folder
                        var answer_1 = [];
                        angular.forEach(children, function (child) {
                            answer_1 = answer_1.concat(child.children);
                        });
                        children = answer_1;
                    }
                }
                // filter out advisory topics
                children.forEach(function (broker) {
                    var grandChildren = broker.children;
                    if (grandChildren) {
                        var old = _.find(grandChildren, function (n) { return n.text === 'Topic'; });
                        if (old) {
                            // we need to store all topics the first time on the workspace
                            // so we have access to them later if the user changes the filter in the preferences
                            var key = "ActiveMQ-allTopics-" + broker.text;
                            var allTopics = _.clone(old.children);
                            _this.workspace.mapData[key] = allTopics;
                            var filter = Core.parseBooleanValue(localStorage['activemqFilterAdvisoryTopics']);
                            if (filter) {
                                if (old && old.children) {
                                    var filteredTopics = _.filter(old.children, function (c) { return !_.startsWith(c.text, 'ActiveMQ.Advisory'); });
                                    old.children = filteredTopics;
                                }
                            }
                            else if (allTopics) {
                                old.children = allTopics;
                            }
                        }
                    }
                });
                this.removeTree();
                Jmx.enableTree(this.$scope, this.$location, this.workspace, $(ActiveMQ.treeElementId), children);
                this.updateSelectionFromURL();
            }
        };
        TreeController.prototype.removeTree = function () {
            var tree = $(ActiveMQ.treeElementId).treeview(true);
            // There is no exposed API to check whether the tree has already been initialized,
            // so let's just check if the methods are presents
            if (tree.clearSearch) {
                tree.clearSearch();
                // Bootstrap tree view leaks the node elements into the data structure
                // so let's clean this up when the user leaves the view
                var cleanTreeFolder_1 = function (node) {
                    delete node['$el'];
                    if (node.nodes)
                        node.nodes.forEach(cleanTreeFolder_1);
                };
                cleanTreeFolder_1(this.workspace.tree);
                // Then call the tree clean-up method
                tree.remove();
            }
        };
        return TreeController;
    }());
    ActiveMQ.TreeController = TreeController;
})(ActiveMQ || (ActiveMQ = {}));
var ActiveMQ;
(function (ActiveMQ) {
    var TreeHeaderController = /** @class */ (function () {
        TreeHeaderController.$inject = ["$scope", "$element"];
        function TreeHeaderController($scope, $element) {
            'ngInject';
            this.$scope = $scope;
            this.$element = $element;
            this.filter = '';
            this.result = [];
            // it's not possible to declare classes to the component host tag in AngularJS
            $element.addClass('tree-nav-sidebar-header');
        }
        TreeHeaderController.prototype.$onInit = function () {
            var _this = this;
            this.$scope.$watch(angular.bind(this, function () { return _this.filter; }), function (filter, previous) {
                if (filter !== previous) {
                    _this.search(filter);
                }
            });
        };
        TreeHeaderController.prototype.search = function (filter) {
            var _this = this;
            var doSearch = function (filter) {
                var _a;
                var result = _this.tree().search(filter, {
                    ignoreCase: true,
                    exactMatch: false,
                    revealResults: true,
                });
                _this.result.length = 0;
                (_a = _this.result).push.apply(_a, result);
                Core.$apply(_this.$scope);
            };
            _.debounce(doSearch, 300, { leading: false, trailing: true })(filter);
        };
        TreeHeaderController.prototype.tree = function () {
            return $(ActiveMQ.treeElementId).treeview(true);
        };
        TreeHeaderController.prototype.expandAll = function () {
            return this.tree()
                .expandNode(this.tree().getNodes(), { levels: 1, silent: true });
        };
        TreeHeaderController.prototype.contractAll = function () {
            return this.tree()
                .collapseNode(this.tree().getNodes(), { ignoreChildren: true, silent: true });
        };
        return TreeHeaderController;
    }());
    ActiveMQ.TreeHeaderController = TreeHeaderController;
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="tree.controller.ts"/>
/// <reference path="tree-header.controller.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.treeHeaderComponent = {
        templateUrl: 'plugins/activemq/html/tree/header.html',
        controller: ActiveMQ.TreeHeaderController,
    };
    ActiveMQ.treeComponent = {
        templateUrl: 'plugins/activemq/html/tree/content.html',
        controller: ActiveMQ.TreeController,
    };
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="tree.component.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.treeModule = angular
        .module('hawtio-activemq-tree', [])
        .component('activemqTreeHeader', ActiveMQ.treeHeaderComponent)
        .component('activemqTree', ActiveMQ.treeComponent)
        .name;
    ActiveMQ.treeElementId = '#activemqtree';
})(ActiveMQ || (ActiveMQ = {}));
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.activeMQComponent = {
        template: "\n      <div class=\"tree-nav-layout\">\n        <div class=\"sidebar-pf sidebar-pf-left\" resizable r-directions=\"['right']\">\n          <activemq-tree-header></activemq-tree-header>\n          <activemq-tree></activemq-tree>\n        </div>\n        <div class=\"tree-nav-main\">\n          <div>\n            <jmx-header></jmx-header>\n          </div>\n          <activemq-navigation></activemq-navigation>\n          <div class=\"contents\" ng-view></div>\n        </div>\n      </div>\n    "
    };
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="activemqHelpers.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    var TAB_CONFIG = {
        attributes: {
            title: 'Attributes',
            route: '/activemq/attributes'
        },
        operations: {
            title: 'Operations',
            route: '/activemq/operations'
        },
        chart: {
            title: 'Chart',
            route: '/activemq/charts'
        },
        browse: {
            title: 'Browse',
            route: '/activemq/browseQueue'
        },
        sendMessage: {
            title: 'Send',
            route: '/activemq/sendMessage'
        },
        durableSubscribers: {
            title: 'Durable Subscribers',
            route: '/activemq/durableSubscribers'
        },
        jobs: {
            title: 'Jobs',
            route: '/activemq/jobs'
        },
        createDestination: {
            title: 'Create',
            route: '/activemq/createDestination'
        },
        deleteTopic: {
            title: 'Delete',
            route: '/activemq/deleteTopic'
        },
        deleteQueue: {
            title: 'Delete',
            route: '/activemq/deleteQueue'
        },
        queues: {
            title: 'Queues',
            route: '/activemq/queues'
        },
        topics: {
            title: 'Topics',
            route: '/activemq/topics'
        },
    };
    var ActiveMQNavigationService = /** @class */ (function () {
        ActiveMQNavigationService.$inject = ["workspace"];
        function ActiveMQNavigationService(workspace) {
            'ngInject';
            this.workspace = workspace;
        }
        ActiveMQNavigationService.prototype.getTabs = function () {
            var tabs = [];
            var enabledRoutes = Object.keys(TAB_CONFIG)
                .map(function (config) { return TAB_CONFIG[config].route; })
                .filter(function (route) { return _.startsWith(route, '/activemq'); });
            if (enabledRoutes.length > 0) {
                tabs.push(new Nav.HawtioTab(TAB_CONFIG.attributes.title, TAB_CONFIG.attributes.route));
                tabs.push(new Nav.HawtioTab(TAB_CONFIG.operations.title, TAB_CONFIG.operations.route));
                tabs.push(new Nav.HawtioTab(TAB_CONFIG.chart.title, TAB_CONFIG.chart.route));
                if (this.shouldShowBrowseTab()) {
                    tabs.push(new Nav.HawtioTab(TAB_CONFIG.browse.title, TAB_CONFIG.browse.route));
                }
                if (this.shouldShowSendTab()) {
                    tabs.push(new Nav.HawtioTab(TAB_CONFIG.sendMessage.title, TAB_CONFIG.sendMessage.route));
                }
                if (this.shouldShowDurableSubscribersTab()) {
                    tabs.push(new Nav.HawtioTab(TAB_CONFIG.durableSubscribers.title, TAB_CONFIG.durableSubscribers.route));
                }
                if (this.shouldShowJobsTab()) {
                    tabs.push(new Nav.HawtioTab(TAB_CONFIG.jobs.title, TAB_CONFIG.jobs.route));
                }
                if (this.shouldShowCreateTab()) {
                    tabs.push(new Nav.HawtioTab(TAB_CONFIG.createDestination.title, TAB_CONFIG.createDestination.route));
                }
                if (this.shouldShowDeleteTopicTab()) {
                    tabs.push(new Nav.HawtioTab(TAB_CONFIG.deleteTopic.title, TAB_CONFIG.deleteTopic.route));
                }
                if (this.shouldShowDeleteQueueTab()) {
                    tabs.push(new Nav.HawtioTab(TAB_CONFIG.deleteQueue.title, TAB_CONFIG.deleteQueue.route));
                }
                if (this.shouldShowQueuesTab()) {
                    tabs.push(new Nav.HawtioTab(TAB_CONFIG.queues.title, TAB_CONFIG.queues.route));
                }
                if (this.shouldShowTopicsTab()) {
                    tabs.push(new Nav.HawtioTab(TAB_CONFIG.topics.title, TAB_CONFIG.topics.route));
                }
            }
            return tabs;
        };
        ActiveMQNavigationService.prototype.shouldShowBrowseTab = function () {
            return this.isQueue() && this.workspace.hasInvokeRights(this.workspace.selection, 'browse()');
        };
        ActiveMQNavigationService.prototype.shouldShowSendTab = function () {
            return (this.isQueue() || this.isTopic()) &&
                this.workspace.hasInvokeRights(this.workspace.selection, 'sendTextMessage(java.util.Map,java.lang.String,java.lang.String,java.lang.String)');
        };
        ActiveMQNavigationService.prototype.shouldShowDurableSubscribersTab = function () {
            return this.isBroker();
        };
        ActiveMQNavigationService.prototype.shouldShowJobsTab = function () {
            return this.isJobScheduler();
        };
        ActiveMQNavigationService.prototype.shouldShowCreateTab = function () {
            return this.isBroker() && this.workspace.hasInvokeRights(this.getBroker(), 'addQueue', 'addTopic');
        };
        ActiveMQNavigationService.prototype.shouldShowDeleteTopicTab = function () {
            return this.isTopic() && this.workspace.hasInvokeRights(this.getBroker(), 'removeTopic');
        };
        ActiveMQNavigationService.prototype.shouldShowDeleteQueueTab = function () {
            return this.isQueue() && this.workspace.hasInvokeRights(this.getBroker(), 'removeQueue');
        };
        ActiveMQNavigationService.prototype.shouldShowQueuesTab = function () {
            return this.isBroker();
        };
        ActiveMQNavigationService.prototype.shouldShowTopicsTab = function () {
            return this.isBroker();
        };
        ActiveMQNavigationService.prototype.isQueue = function () {
            return this.workspace.hasDomainAndProperties(ActiveMQ.jmxDomain, { 'destinationType': 'Queue' }, 4) ||
                this.workspace.selectionHasDomainAndType(ActiveMQ.jmxDomain, 'Queue');
        };
        ActiveMQNavigationService.prototype.isTopic = function () {
            return this.workspace.hasDomainAndProperties(ActiveMQ.jmxDomain, { 'destinationType': 'Topic' }, 4) || this.workspace.selectionHasDomainAndType(ActiveMQ.jmxDomain, 'Topic');
        };
        ActiveMQNavigationService.prototype.isQueuesFolder = function () {
            return this.workspace.selectionHasDomainAndLastFolderName(ActiveMQ.jmxDomain, 'Queue');
        };
        ActiveMQNavigationService.prototype.isTopicsFolder = function () {
            return this.workspace.selectionHasDomainAndLastFolderName(ActiveMQ.jmxDomain, 'Topic');
        };
        ActiveMQNavigationService.prototype.isJobScheduler = function () {
            return this.workspace.hasDomainAndProperties(ActiveMQ.jmxDomain, { 'service': 'JobScheduler' }, 4);
        };
        ActiveMQNavigationService.prototype.isBroker = function () {
            if (this.workspace.selectionHasDomainAndType(ActiveMQ.jmxDomain, 'Broker')) {
                var self = Core.pathGet(this.workspace, ["selection"]);
                var parent = Core.pathGet(this.workspace, ["selection", "parent"]);
                return !(parent && (parent.ancestorHasType('Broker') || self.ancestorHasType('Broker')));
            }
            return false;
        };
        ActiveMQNavigationService.prototype.getBroker = function () {
            var answer = null;
            var selection = this.workspace.selection;
            if (selection) {
                answer = selection.findAncestor(function (current) {
                    var entries = current.entries;
                    if (entries) {
                        return (('type' in entries && entries.type === 'Broker') && 'brokerName' in entries && !('destinationName' in entries) && !('destinationType' in entries));
                    }
                    else {
                        return false;
                    }
                });
            }
            return answer;
        };
        return ActiveMQNavigationService;
    }());
    ActiveMQ.ActiveMQNavigationService = ActiveMQNavigationService;
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="activemq-navigation.service.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    var ActiveMQNavigationController = /** @class */ (function () {
        ActiveMQNavigationController.$inject = ["$scope", "$location", "activeMQNavigationService"];
        function ActiveMQNavigationController($scope, $location, activeMQNavigationService) {
            'ngInject';
            var _this = this;
            this.$location = $location;
            this.activeMQNavigationService = activeMQNavigationService;
            $scope.$on('jmxTreeClicked', function () {
                _this.tabs = activeMQNavigationService.getTabs();
                var tab = _.find(_this.tabs, { path: _this.$location.path() });
                if (!tab) {
                    tab = _this.tabs[0];
                }
                _this.$location.path(tab.path);
            });
        }
        ActiveMQNavigationController.prototype.$onInit = function () {
            this.tabs = this.activeMQNavigationService.getTabs();
        };
        ActiveMQNavigationController.prototype.goto = function (tab) {
            this.$location.path(tab.path);
        };
        return ActiveMQNavigationController;
    }());
    ActiveMQ.ActiveMQNavigationController = ActiveMQNavigationController;
    ActiveMQ.activeMQNavigationComponent = {
        template: '<hawtio-tabs tabs="$ctrl.tabs" on-change="$ctrl.goto(tab)"></hawtio-tabs>',
        controller: ActiveMQNavigationController
    };
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="destination/destination.module.ts"/>
/// <reference path="tree/tree.module.ts"/>
/// <reference path="activemq.component.ts"/>
/// <reference path="activemq-navigation.component.ts"/>
/// <reference path="activemq-navigation.service.ts"/>
/// <reference path="activemqHelpers.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    defineRoutes.$inject = ["$routeProvider"];
    configurePlugin.$inject = ["mainNavService", "workspace", "helpRegistry", "preferencesRegistry", "localStorage", "preLogoutTasks", "documentBase", "activeMQNavigationService"];
    ActiveMQ._module = angular
        .module(ActiveMQ.pluginName, [
        'angularResizable',
        ActiveMQ.destinationModule,
        ActiveMQ.treeModule,
    ])
        .config(defineRoutes)
        .controller('topicsController', ['$scope', function ($scope) {
            $scope.destinationType = 'topics';
        }])
        .controller('queuesController', ['$scope', function ($scope) {
            $scope.destinationType = 'queues';
        }])
        .component('activemq', ActiveMQ.activeMQComponent)
        .component('activemqNavigation', ActiveMQ.activeMQNavigationComponent)
        .service('activeMQNavigationService', ActiveMQ.ActiveMQNavigationService)
        .run(configurePlugin);
    function defineRoutes($routeProvider) {
        'ngInject';
        $routeProvider.
            when('/activemq/attributes', { templateUrl: 'plugins/jmx/html/attributes/attributes.html' }).
            when('/activemq/operations', { template: '<operations></operations>' }).
            when('/activemq/charts', { templateUrl: 'plugins/jmx/html/charts.html' }).
            when('/activemq/charts/edit', { templateUrl: 'plugins/jmx/html/chartEdit.html' }).
            when('/activemq/browseQueue', { templateUrl: 'plugins/activemq/html/browseQueue.html' }).
            when('/activemq/createDestination', { template: '<create-destination></create-destination>' }).
            when('/activemq/deleteQueue', { template: '<delete-queue></delete-queue>' }).
            when('/activemq/deleteTopic', { template: '<delete-topic></delete-topic>' }).
            when('/activemq/sendMessage', { templateUrl: 'plugins/camel/html/sendMessage.html' }).
            when('/activemq/durableSubscribers', { templateUrl: 'plugins/activemq/html/durableSubscribers.html' }).
            when('/activemq/jobs', { templateUrl: 'plugins/activemq/html/jobs.html' }).
            when('/activemq/queues', { templateUrl: 'plugins/activemq/html/destinations.html', controller: 'queuesController' }).
            when('/activemq/topics', { templateUrl: 'plugins/activemq/html/destinations.html', controller: 'topicsController' });
    }
    function configurePlugin(mainNavService, workspace, helpRegistry, preferencesRegistry, localStorage, preLogoutTasks, documentBase, activeMQNavigationService) {
        'ngInject';
        helpRegistry.addUserDoc('activemq', 'plugins/activemq/doc/help.md', function () {
            return workspace.treeContainsDomainAndProperties("org.apache.activemq");
        });
        preferencesRegistry.addTab("ActiveMQ", "plugins/activemq/html/preferences.html", function () {
            return workspace.treeContainsDomainAndProperties("org.apache.activemq");
        });
        mainNavService.addItem({
            title: 'ActiveMQ',
            basePath: '/activemq',
            template: '<activemq></activemq>',
            isValid: function () { return workspace.treeContainsDomainAndProperties(ActiveMQ.jmxDomain) && activeMQNavigationService.getTabs().length > 0; }
        });
        workspace.addTreePostProcessor(postProcessTree);
        // clean up local storage upon logout
        preLogoutTasks.addTask('CleanupActiveMQCredentials', function () {
            ActiveMQ.log.debug("Clean up ActiveMQ credentials in local storage");
            localStorage.removeItem('activemqUserName');
            localStorage.removeItem('activemqPassword');
        });
        // register default attribute views
        var attributes = workspace.attributeColumnDefs;
        attributes[ActiveMQ.jmxDomain + "/Broker/folder"] = [
            { field: 'BrokerName', displayName: 'Name', width: "**" },
            { field: 'TotalProducerCount', displayName: 'Producer' },
            { field: 'TotalConsumerCount', displayName: 'Consumer' },
            { field: 'StorePercentUsage', displayName: 'Store %' },
            { field: 'TempPercentUsage', displayName: 'Temp %' },
            { field: 'MemoryPercentUsage', displayName: 'Memory %' },
            { field: 'TotalEnqueueCount', displayName: 'Enqueue' },
            { field: 'TotalDequeueCount', displayName: 'Dequeue' }
        ];
        attributes[ActiveMQ.jmxDomain + "/Queue/folder"] = [
            { field: 'Name', displayName: 'Name', width: "***" },
            { field: 'QueueSize', displayName: 'Queue Size' },
            { field: 'ProducerCount', displayName: 'Producer' },
            { field: 'ConsumerCount', displayName: 'Consumer' },
            { field: 'EnqueueCount', displayName: 'Enqueue' },
            { field: 'DequeueCount', displayName: 'Dequeue' },
            { field: 'MemoryPercentUsage', displayName: 'Memory %' },
            { field: 'DispatchCount', displayName: 'Dispatch', visible: false }
        ];
        attributes[ActiveMQ.jmxDomain + "/Topic/folder"] = [
            { field: 'Name', displayName: 'Name', width: "****" },
            { field: 'ProducerCount', displayName: 'Producer' },
            { field: 'ConsumerCount', displayName: 'Consumer' },
            { field: 'EnqueueCount', displayName: 'Enqueue' },
            { field: 'DequeueCount', displayName: 'Dequeue' },
            { field: 'MemoryPercentUsage', displayName: 'Memory %' },
            { field: 'DispatchCount', displayName: 'Dispatch', visible: false }
        ];
        attributes[ActiveMQ.jmxDomain + "/Consumer/folder"] = [
            { field: 'ConnectionId', displayName: 'Name', width: "**" },
            { field: 'PrefetchSize', displayName: 'Prefetch Size' },
            { field: 'Priority', displayName: 'Priority' },
            { field: 'DispatchedQueueSize', displayName: 'Dispatched Queue #' },
            { field: 'SlowConsumer', displayName: 'Slow ?' },
            { field: 'Retroactive', displayName: 'Retroactive' },
            { field: 'Selector', displayName: 'Selector' }
        ];
        attributes[ActiveMQ.jmxDomain + "/networkConnectors/folder"] = [
            { field: 'Name', displayName: 'Name', width: "**" },
            { field: 'UserName', displayName: 'User Name' },
            { field: 'PrefetchSize', displayName: 'Prefetch Size' },
            { field: 'ConduitSubscriptions', displayName: 'Conduit Subscriptions?' },
            { field: 'Duplex', displayName: 'Duplex' },
            { field: 'DynamicOnly', displayName: 'Dynamic Only' }
        ];
        attributes[ActiveMQ.jmxDomain + "/PersistenceAdapter/folder"] = [
            { field: 'IndexDirectory', displayName: 'Index Directory', width: "**" },
            { field: 'LogDirectory', displayName: 'Log Directory', width: "**" }
        ];
        function postProcessTree(tree) {
            var activemq = tree.get("org.apache.activemq");
            setConsumerType(activemq);
            // lets move queue and topic as first children within brokers
            if (activemq) {
                angular.forEach(activemq.children, function (broker) {
                    angular.forEach(broker.children, function (child) {
                        // lets move Topic/Queue to the front.
                        var grandChildren = child.children;
                        if (grandChildren) {
                            var names = ["Topic", "Queue"];
                            angular.forEach(names, function (name) {
                                var idx = _.findIndex(grandChildren, function (n) { return n.text === name; });
                                if (idx > 0) {
                                    var old = grandChildren[idx];
                                    grandChildren.splice(idx, 1);
                                    grandChildren.splice(0, 0, old);
                                }
                            });
                        }
                    });
                });
            }
        }
        function setConsumerType(node) {
            if (node) {
                var parent = node.parent;
                var entries = node.entries;
                if (parent && !parent.typeName && entries) {
                    var endpoint = entries["endpoint"];
                    if (endpoint === "Consumer" || endpoint === "Producer") {
                        parent.typeName = endpoint;
                    }
                    var connectorName = entries["connectorName"];
                    if (connectorName && !node.icon) {
                        // lets default a connector icon
                        node.icon = UrlHelpers.join(documentBase, "/img/icons/activemq/connector.png");
                    }
                }
                angular.forEach(node.children, function (child) { return setConsumerType(child); });
            }
        }
    }
    hawtioPluginLoader.addModule(ActiveMQ.pluginName);
})(ActiveMQ || (ActiveMQ = {}));
var Camel;
(function (Camel) {
    var Context = /** @class */ (function () {
        function Context(name, state, mbeanName) {
            this.name = name;
            this.state = state;
            this.mbeanName = mbeanName;
            this.selected = false;
        }
        Context.prototype.isStarted = function () {
            return this.state === 'Started';
        };
        Context.prototype.isSuspended = function () {
            return this.state === 'Suspended';
        };
        return Context;
    }());
    Camel.Context = Context;
})(Camel || (Camel = {}));
/// <reference path="context.ts"/>
var Camel;
(function (Camel) {
    var ContextsService = /** @class */ (function () {
        ContextsService.$inject = ["jolokiaService", "treeService"];
        function ContextsService(jolokiaService, treeService) {
            'ngInject';
            this.jolokiaService = jolokiaService;
            this.treeService = treeService;
        }
        ContextsService.prototype.getContexts = function () {
            var _this = this;
            return this.treeService.getSelectedMBean()
                .then(function (nodeSelection) {
                if (nodeSelection.children) {
                    var mbeanNames_1 = nodeSelection.children.filter(function (node) { return node.objectName; }).map(function (node) { return node.objectName; });
                    return _this.jolokiaService.getMBeans(mbeanNames_1)
                        .then(function (mbeans) { return mbeans.map(function (mbean, i) { return new Camel.Context(mbean.CamelId, mbean.State, mbeanNames_1[i]); }); });
                }
                else {
                    return [];
                }
            });
        };
        ContextsService.prototype.getContext = function (mbeanName) {
            return this.jolokiaService.getMBean(mbeanName)
                .then(function (mbean) { return new Camel.Context(mbean.CamelId, mbean.State, mbeanName); });
        };
        ContextsService.prototype.startContext = function (context) {
            return this.executeOperationOnContext('start()', context);
        };
        ContextsService.prototype.startContexts = function (contexts) {
            return this.executeOperationOnContexts('start()', contexts);
        };
        ContextsService.prototype.suspendContext = function (context) {
            return this.executeOperationOnContext('suspend()', context);
        };
        ContextsService.prototype.suspendContexts = function (contexts) {
            return this.executeOperationOnContexts('suspend()', contexts);
        };
        ContextsService.prototype.stopContext = function (context) {
            return this.executeOperationOnContext('stop()', context);
        };
        ContextsService.prototype.stopContexts = function (contexts) {
            return this.executeOperationOnContexts('stop()', contexts);
        };
        ContextsService.prototype.executeOperationOnContext = function (operation, context) {
            return this.jolokiaService.execute(context.mbeanName, operation);
        };
        ContextsService.prototype.executeOperationOnContexts = function (operation, contexts) {
            var objectNames = contexts.map(function (context) { return context.mbeanName; });
            return this.jolokiaService.executeMany(objectNames, operation);
        };
        return ContextsService;
    }());
    Camel.ContextsService = ContextsService;
})(Camel || (Camel = {}));
/// <reference path="context.ts"/>
/// <reference path="contexts.service.ts"/>
var Camel;
(function (Camel) {
    var ContextsController = /** @class */ (function () {
        ContextsController.$inject = ["$timeout", "$uibModal", "workspace", "contextsService"];
        function ContextsController($timeout, $uibModal, workspace, contextsService) {
            'ngInject';
            var _this = this;
            this.$timeout = $timeout;
            this.$uibModal = $uibModal;
            this.workspace = workspace;
            this.contextsService = contextsService;
            this.startAction = {
                name: 'Start',
                actionFn: function (action) {
                    var selectedContexts = _this.getSelectedContexts();
                    _this.contextsService.startContexts(selectedContexts)
                        .then(function (response) {
                        Core.notification('success', "Started " + Core.maybePlural(selectedContexts.length, 'Camel context') + " successfully");
                        _this.updateContexts();
                    })
                        .catch(function (error) {
                        Core.notification('danger', error);
                    });
                },
                isDisabled: true
            };
            this.suspendAction = {
                name: 'Suspend',
                actionFn: function (action) {
                    var selectedContexts = _this.getSelectedContexts();
                    _this.contextsService.suspendContexts(selectedContexts)
                        .then(function (response) {
                        Core.notification('success', "Suspended " + Core.maybePlural(selectedContexts.length, 'Camel context') + " successfully");
                        _this.updateContexts();
                    })
                        .catch(function (error) {
                        Core.notification('danger', error);
                    });
                },
                isDisabled: true
            };
            this.deleteAction = {
                name: 'Delete',
                actionFn: function (action) {
                    _this.$uibModal.open({
                        templateUrl: 'plugins/camel/html/deleteContextWarningModal.html'
                    })
                        .result.then(function () {
                        var selectedContexts = _this.getSelectedContexts();
                        _this.contextsService.stopContexts(selectedContexts)
                            .then(function (response) {
                            Core.notification('success', "Deleted " + Core.maybePlural(selectedContexts.length, 'Camel context') + " successfully");
                            _this.removeSelectedContexts();
                        })
                            .catch(function (error) {
                            Core.notification('danger', error);
                        });
                    });
                },
                isDisabled: true
            };
            this.toolbarConfig = {
                actionsConfig: {
                    primaryActions: [
                        this.startAction,
                        this.suspendAction
                    ],
                    moreActions: [
                        this.deleteAction
                    ]
                },
                isTableView: true
            };
            this.tableConfig = {
                selectionMatchProp: "name",
                onCheckBoxChange: function (item) { return _this.enableDisableActions(); }
            };
            this.tableColumns = [
                { header: "Name", itemField: "name" },
                { header: "State", itemField: "state" }
            ];
            this.showTable = true;
        }
        ContextsController.prototype.$onInit = function () {
            var _this = this;
            this.contextsService.getContexts()
                .then(function (contexts) { return _this.contexts = contexts; });
        };
        ContextsController.prototype.getSelectedContexts = function () {
            return this.contexts.filter(function (context) { return context.selected; });
        };
        ContextsController.prototype.enableDisableActions = function () {
            var selectedContexts = this.getSelectedContexts();
            this.startAction.isDisabled = !selectedContexts.some(function (context) { return context.state === 'Suspended'; });
            this.suspendAction.isDisabled = !selectedContexts.some(function (context) { return context.state === 'Started'; });
            this.deleteAction.isDisabled = selectedContexts.length === 0;
        };
        ContextsController.prototype.updateContexts = function () {
            var _this = this;
            this.contextsService.getContexts()
                .then(function (contexts) {
                for (var i = 0; i < contexts.length; i++) {
                    if (_this.contexts[i].state !== contexts[i].state) {
                        _this.contexts[i] = angular.extend({}, _this.contexts[i], { state: contexts[i].state });
                    }
                }
                _this.enableDisableActions();
                _this.repaintTable();
            });
        };
        ContextsController.prototype.removeSelectedContexts = function () {
            _.remove(this.contexts, function (context) { return context.selected; });
            this.workspace.loadTree();
            this.enableDisableActions();
        };
        // This is a hack to keep the 'select all' checkbox working after starting/suspending contexts
        ContextsController.prototype.repaintTable = function () {
            var _this = this;
            this.showTable = false;
            this.$timeout(function () { return _this.showTable = true; });
        };
        return ContextsController;
    }());
    Camel.ContextsController = ContextsController;
    Camel.contextsComponent = {
        template: "\n      <h2>Contexts</h2>\n      <p ng-if=\"!$ctrl.contexts\">Loading...</p>\n      <div ng-if=\"$ctrl.contexts\">\n        <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n        <div ng-if=\"$ctrl.showTable\">\n          <pf-table-view config=\"$ctrl.tableConfig\" columns=\"$ctrl.tableColumns\" items=\"$ctrl.contexts\"></pf-table-view>\n        </div>\n      </div>\n    ",
        controller: ContextsController
    };
})(Camel || (Camel = {}));
/// <reference path="contexts.service.ts"/>
/// <reference path="context.ts"/>
var Camel;
(function (Camel) {
    var ContextActionsController = /** @class */ (function () {
        ContextActionsController.$inject = ["$scope", "$uibModal", "workspace", "contextsService"];
        function ContextActionsController($scope, $uibModal, workspace, contextsService) {
            'ngInject';
            this.$scope = $scope;
            this.$uibModal = $uibModal;
            this.workspace = workspace;
            this.contextsService = contextsService;
            this.context = null;
        }
        ContextActionsController.prototype.$onInit = function () {
            var _this = this;
            this.unsubscribe = this.$scope.$on(Jmx.TreeEvent.NodeSelected, function (event, selectedNode) {
                if (selectedNode.typeName === 'context' && selectedNode.objectName) {
                    _this.contextsService.getContext(selectedNode.objectName)
                        .then(function (context) { return _this.context = context; });
                }
                else {
                    _this.context = null;
                }
            });
        };
        ContextActionsController.prototype.$onDestroy = function () {
            this.unsubscribe();
        };
        ContextActionsController.prototype.start = function () {
            var _this = this;
            this.contextsService.startContext(this.context)
                .then(function (response) {
                Core.notification('success', 'Camel context started successfully');
                _this.contextsService.getContext(_this.context.mbeanName)
                    .then(function (context) { return _this.context = context; });
            })
                .catch(function (error) {
                Core.notification('danger', error);
            });
        };
        ContextActionsController.prototype.suspend = function () {
            var _this = this;
            this.contextsService.suspendContext(this.context)
                .then(function (response) {
                Core.notification('success', 'Camel context suspended successfully');
                _this.contextsService.getContext(_this.context.mbeanName)
                    .then(function (context) { return _this.context = context; });
            })
                .catch(function (error) {
                Core.notification('danger', error);
            });
        };
        ContextActionsController.prototype.delete = function () {
            var _this = this;
            this.$uibModal.open({
                templateUrl: 'plugins/camel/html/deleteContextWarningModal.html'
            })
                .result.then(function () {
                _this.contextsService.stopContext(_this.context)
                    .then(function (response) {
                    Core.notification('success', 'Camel context deleted successfully');
                    _this.context = null;
                    _this.workspace.loadTree();
                });
            })
                .catch(function (error) {
                Core.notification('danger', error);
            });
        };
        return ContextActionsController;
    }());
    Camel.ContextActionsController = ContextActionsController;
    Camel.contextActionsComponent = {
        template: "\n      <div class=\"dropdown camel-main-actions\" ng-show=\"$ctrl.context\"\n        hawtio-show object-name-model=\"$ctrl.context.mbeanName\" method-name=\"stop\" mode=\"remove\">\n        <button type=\"button\" id=\"dropdownMenu1\" class=\"btn btn-default dropdown-toggle\"\n          data-toggle=\"dropdown\" aria-haspopup=\"true\" aria-expanded=\"true\">\n          <span class=\"fa\" ng-class=\"{'fa-play': $ctrl.context.isStarted(), 'fa-pause': $ctrl.context.isSuspended()}\"></span>\n          &nbsp;\n          {{$ctrl.context.state}}\n          &nbsp;\n          <span class=\"caret\"></span>\n        </button>\n        <ul class=\"dropdown-menu\" aria-labelledby=\"dropdownMenu1\">\n          <li ng-class=\"{disabled: $ctrl.context.state === 'Started'}\">\n            <a href=\"#\" ng-click=\"$ctrl.start()\">Start</a>\n          </li>\n          <li ng-class=\"{disabled: $ctrl.context.state === 'Suspended'}\">\n            <a href=\"#\" ng-click=\"$ctrl.suspend()\">Suspend</a>\n          </li>\n          <li>\n            <a href=\"#\" ng-click=\"$ctrl.delete()\">Delete</a>\n          </li>\n        </ul>\n      </div>\n    ",
        controller: ContextActionsController
    };
})(Camel || (Camel = {}));
/// <reference path="contexts.component.ts"/>
/// <reference path="context-actions.component.ts"/>
/// <reference path="contexts.service.ts"/>
var Camel;
(function (Camel) {
    Camel.contextsModule = angular
        .module('hawtio-camel-contexts', [])
        .component('contexts', Camel.contextsComponent)
        .component('contextActions', Camel.contextActionsComponent)
        .service('contextsService', Camel.ContextsService)
        .name;
})(Camel || (Camel = {}));
var Pf;
(function (Pf) {
    function filter(items, filterConfig) {
        var filteredItems = items;
        if (filterConfig.appliedFilters) {
            filterConfig.appliedFilters.forEach(function (filter) {
                var filterType = _.find(filterConfig.fields, { 'id': filter.id }).filterType;
                switch (filterType) {
                    case 'text':
                        var regExp_1 = new RegExp(filter.value, 'i');
                        filteredItems = filteredItems.filter(function (item) { return regExp_1.test(item[filter.id]); });
                        break;
                    case 'number':
                        filteredItems = filteredItems.filter(function (item) { return item[filter.id] === parseInt(filter.value); });
                        break;
                    case 'select':
                        filteredItems = filteredItems.filter(function (item) { return item[filter.id] === filter.value; });
                        break;
                }
            });
        }
        filterConfig.resultsCount = filteredItems.length;
        return filteredItems;
    }
    Pf.filter = filter;
})(Pf || (Pf = {}));
var Camel;
(function (Camel) {
    var EndpointsStatisticsService = /** @class */ (function () {
        EndpointsStatisticsService.$inject = ["jolokiaService", "treeService"];
        function EndpointsStatisticsService(jolokiaService, treeService) {
            'ngInject';
            this.jolokiaService = jolokiaService;
            this.treeService = treeService;
        }
        EndpointsStatisticsService.prototype.getStatistics = function () {
            var _this = this;
            return this.treeService.findMBeanWithProperties('org.apache.camel', { type: 'services', name: 'DefaultRuntimeEndpointRegistry*' })
                .then(function (mbean) { return _this.jolokiaService.execute(mbean.objectName, 'endpointStatistics')
                .then(function (response) { return _.values(response); }); });
        };
        return EndpointsStatisticsService;
    }());
    Camel.EndpointsStatisticsService = EndpointsStatisticsService;
})(Camel || (Camel = {}));
/// <reference path="../../../pf-utils.ts"/>
/// <reference path="endpoints-statistics.service.ts"/>
var Camel;
(function (Camel) {
    var EndpointsStatisticsController = /** @class */ (function () {
        EndpointsStatisticsController.$inject = ["endpointsStatisticsService"];
        function EndpointsStatisticsController(endpointsStatisticsService) {
            'ngInject';
            var _this = this;
            this.endpointsStatisticsService = endpointsStatisticsService;
            this.toolbarConfig = {
                filterConfig: {
                    fields: [
                        {
                            id: 'url',
                            title: 'URL',
                            placeholder: 'Filter by URL...',
                            filterType: 'text'
                        },
                        {
                            id: 'routeId',
                            title: 'Route ID',
                            placeholder: 'Filter by route ID...',
                            filterType: 'text'
                        },
                        {
                            id: 'direction',
                            title: 'Direction',
                            placeholder: 'Filter by direction...',
                            filterType: 'text'
                        }
                    ],
                    onFilterChange: function (filters) {
                        _this.filteredItems = Pf.filter(_this.allItems, _this.toolbarConfig.filterConfig);
                    },
                    appliedFilters: [],
                    resultsCount: 0
                },
                isTableView: true
            };
            this.tableConfig = {
                selectionMatchProp: 'url',
                showCheckboxes: false
            };
            this.tableDtOptions = {
                order: [[0, "asc"]],
            };
            this.tableColumns = [
                { itemField: 'url', header: 'URL' },
                { itemField: 'routeId', header: 'Route ID' },
                { itemField: 'direction', header: 'Direction' },
                { itemField: 'static', header: 'Static' },
                { itemField: 'dynamic', header: 'Dynamic' },
                { itemField: 'hits', header: 'Hits' }
            ];
        }
        EndpointsStatisticsController.prototype.$onInit = function () {
            var _this = this;
            this.endpointsStatisticsService.getStatistics()
                .then(function (items) {
                _this.allItems = items;
                _this.filteredItems = items;
                _this.toolbarConfig.filterConfig.resultsCount = items.length;
            });
        };
        return EndpointsStatisticsController;
    }());
    Camel.EndpointsStatisticsController = EndpointsStatisticsController;
    Camel.endpointsStatisticsComponent = {
        template: "\n      <h2>Endpoints (in/out)</h2>\n      <p ng-if=\"!$ctrl.filteredItems\">Loading...</p>\n      <div ng-if=\"$ctrl.filteredItems\">\n        <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n        <pf-table-view config=\"$ctrl.tableConfig\"\n                       dt-options=\"$ctrl.tableDtOptions\"\n                       columns=\"$ctrl.tableColumns\"\n                       items=\"$ctrl.filteredItems\"></pf-table-view>\n      </div>\n    ",
        controller: EndpointsStatisticsController
    };
})(Camel || (Camel = {}));
/// <reference path="endpoints-statistics.component.ts"/>
/// <reference path="endpoints-statistics.service.ts"/>
var Camel;
(function (Camel) {
    Camel.endpointsStatisticsModule = angular
        .module('hawtio-camel-endpoints-statistics', [])
        .component('endpointsStatistics', Camel.endpointsStatisticsComponent)
        .service('endpointsStatisticsService', Camel.EndpointsStatisticsService)
        .name;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var Endpoint = /** @class */ (function () {
        Endpoint.$inject = ["uri", "state", "mbean"];
        function Endpoint(uri, state, mbean) {
            'ngInject';
            this.uri = uri;
            this.state = state;
            this.mbean = mbean;
        }
        return Endpoint;
    }());
    Camel.Endpoint = Endpoint;
})(Camel || (Camel = {}));
/// <reference path="endpoint.ts"/>
var Camel;
(function (Camel) {
    var EndpointsService = /** @class */ (function () {
        EndpointsService.$inject = ["$q", "jolokiaService", "workspace"];
        function EndpointsService($q, jolokiaService, workspace) {
            'ngInject';
            this.$q = $q;
            this.jolokiaService = jolokiaService;
            this.workspace = workspace;
        }
        EndpointsService.prototype.getEndpoints = function () {
            if (this.workspace.selection && this.workspace.selection.children && this.workspace.selection.children.length > 0) {
                var mbeans_1 = this.workspace.selection.children.map(function (node) { return node.objectName; });
                return this.jolokiaService.getMBeans(mbeans_1)
                    .then(function (objects) { return objects.map(function (object, i) { return new Camel.Endpoint(object.EndpointUri, object.State, mbeans_1[i]); }); });
            }
            else {
                return this.$q.resolve([]);
            }
        };
        EndpointsService.prototype.canCreateEndpoints = function () {
            return this.workspace.selection &&
                this.workspace.hasInvokeRights(this.workspace.selection, "createEndpoint");
        };
        return EndpointsService;
    }());
    Camel.EndpointsService = EndpointsService;
})(Camel || (Camel = {}));
/// <reference path="endpoint.ts"/>
/// <reference path="endpoints.service.ts"/>
var Camel;
(function (Camel) {
    var EndpointsController = /** @class */ (function () {
        EndpointsController.$inject = ["$location", "endpointsService"];
        function EndpointsController($location, endpointsService) {
            'ngInject';
            var _this = this;
            this.$location = $location;
            this.endpointsService = endpointsService;
            this.addAction = {
                name: 'Add',
                actionFn: function (action) {
                    _this.$location.path('/camel/createEndpoint');
                },
                isDisabled: true
            };
            this.toolbarConfig = {
                actionsConfig: {
                    primaryActions: [
                        this.addAction
                    ]
                },
                isTableView: true
            };
            this.tableConfig = {
                selectionMatchProp: 'uri',
                showCheckboxes: false
            };
            this.tableDtOptions = {
                order: [[0, "asc"]],
            };
            this.tableColumns = [
                { header: 'URI', itemField: 'uri' },
                { header: 'State', itemField: 'state' }
            ];
        }
        EndpointsController.prototype.$onInit = function () {
            var _this = this;
            this.endpointsService.getEndpoints()
                .then(function (endpoints) { return _this.endpoints = endpoints; });
            this.addAction.isDisabled = !this.endpointsService.canCreateEndpoints();
        };
        return EndpointsController;
    }());
    Camel.EndpointsController = EndpointsController;
    Camel.endpointsComponent = {
        template: "\n      <h2>Endpoints</h2>\n      <p ng-if=\"!$ctrl.endpoints\">Loading...</p>\n      <div ng-if=\"$ctrl.endpoints\">\n        <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n        <pf-table-view config=\"$ctrl.tableConfig\"\n                       dt-options=\"$ctrl.tableDtOptions\"\n                       columns=\"$ctrl.tableColumns\"\n                       items=\"$ctrl.endpoints\"></pf-table-view>\n      </div>\n    ",
        controller: EndpointsController
    };
})(Camel || (Camel = {}));
/// <reference path="endpoints.component.ts"/>
/// <reference path="endpoints.service.ts"/>
var Camel;
(function (Camel) {
    Camel.endpointsModule = angular
        .module('hawtio-camel-endpoints', [])
        .component('endpoints', Camel.endpointsComponent)
        .service('endpointsService', Camel.EndpointsService)
        .name;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel.exchangesComponent = {
        template: "\n      <h2>Exchanges</h2>\n      <inflight-exchanges></inflight-exchanges>\n      <blocked-exchanges></blocked-exchanges>\n    "
    };
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var ExchangesService = /** @class */ (function () {
        ExchangesService.$inject = ["jolokiaService", "treeService", "workspace"];
        function ExchangesService(jolokiaService, treeService, workspace) {
            'ngInject';
            this.jolokiaService = jolokiaService;
            this.treeService = treeService;
            this.workspace = workspace;
        }
        ExchangesService.prototype.getInflightExchanges = function () {
            return this.getExchanges('DefaultInflightRepository*');
        };
        ExchangesService.prototype.getBlockedExchanges = function () {
            return this.getExchanges('DefaultAsyncProcessorAwaitManager*');
        };
        ExchangesService.prototype.getExchanges = function (serviceName) {
            var _this = this;
            return this.treeService.findMBeanWithProperties('org.apache.camel', { type: 'services', name: serviceName })
                .then(function (mbean) {
                return _this.jolokiaService.execute(mbean.objectName, 'browse()')
                    .then(function (response) {
                    var exchanges = _.values(response);
                    // if the selected tree node is a route then keep only the exchanges related to that route
                    var routeId = Camel.getSelectedRouteId(_this.workspace);
                    if (routeId != null) {
                        exchanges = _.filter(exchanges, { 'routeId': routeId });
                    }
                    exchanges = _.sortBy(exchanges, "exchangeId");
                    return exchanges;
                });
            });
        };
        ExchangesService.prototype.unblockExchange = function (exchange) {
            var _this = this;
            Camel.log.info("Unblocking thread (" + exchange.id + "/" + exchange.name + ") for exchangeId: " + exchange.exchangeId);
            return this.treeService.findMBeanWithProperties('org.apache.camel', { type: 'services', name: 'DefaultAsyncProcessorAwaitManager*' })
                .then(function (mbean) {
                return _this.jolokiaService.execute(mbean.objectName, 'interrupt(java.lang.String)', exchange.exchangeId);
            });
        };
        return ExchangesService;
    }());
    Camel.ExchangesService = ExchangesService;
})(Camel || (Camel = {}));
/// <reference path="exchanges.service.ts"/>
var Camel;
(function (Camel) {
    var InflightExchangesController = /** @class */ (function () {
        InflightExchangesController.$inject = ["$timeout", "exchangesService"];
        function InflightExchangesController($timeout, exchangesService) {
            'ngInject';
            this.$timeout = $timeout;
            this.exchangesService = exchangesService;
            this.reloadDelay = 10000;
            this.exchanges = null;
        }
        InflightExchangesController.prototype.$onInit = function () {
            this.loadDataPeriodically();
        };
        InflightExchangesController.prototype.$onDestroy = function () {
            this.cancelTimer();
        };
        InflightExchangesController.prototype.loadDataPeriodically = function () {
            var _this = this;
            this.exchangesService.getInflightExchanges()
                .then(function (exchanges) { return _this.exchanges = exchanges; })
                .then(function () { return _this.promise = _this.$timeout(function () { return _this.loadDataPeriodically(); }, _this.reloadDelay); });
        };
        InflightExchangesController.prototype.cancelTimer = function () {
            this.$timeout.cancel(this.promise);
        };
        return InflightExchangesController;
    }());
    Camel.InflightExchangesController = InflightExchangesController;
    Camel.inflightExchangesComponent = {
        template: "\n      <h3>Inflight</h3>\n      <p ng-if=\"$ctrl.exchanges === null\">Loading...</p>\n      <p ng-if=\"$ctrl.exchanges.length === 0\">No inflight exchanges</p>\n      <div ng-if=\"$ctrl.exchanges.length > 0\">\n        <table class=\"table table-striped table-bordered\">\n          <thead>\n            <tr>\n              <th>Exchange ID</th>\n              <th>Route ID</th>\n              <th>Node ID</th>\n              <th>Duration (ms)</th>\n              <th>Elapsed (ms)</th>\n            </tr>\n          </thead>\n          <tbody>\n            <tr ng-repeat=\"exchange in $ctrl.exchanges track by exchange.exchangeId\">\n              <td>{{exchange.exchangeId}}</td>\n              <td>{{exchange.routeId}}</td>\n              <td>{{exchange.nodeId}}</td>\n              <td>{{exchange.duration}}</td>\n              <td>{{exchange.elapsed}}</td>\n            </tr>\n          </tbody>\n        </table>\n      </div>\n    ",
        controller: InflightExchangesController
    };
})(Camel || (Camel = {}));
/// <reference path="exchanges.service.ts"/>
var Camel;
(function (Camel) {
    var BlockedExchangesController = /** @class */ (function () {
        BlockedExchangesController.$inject = ["$timeout", "$uibModal", "exchangesService"];
        function BlockedExchangesController($timeout, $uibModal, exchangesService) {
            'ngInject';
            this.$timeout = $timeout;
            this.$uibModal = $uibModal;
            this.exchangesService = exchangesService;
            this.reloadDelay = 10000;
            this.exchanges = null;
        }
        BlockedExchangesController.prototype.$onInit = function () {
            this.loadDataPeriodically();
        };
        BlockedExchangesController.prototype.$onDestroy = function () {
            this.cancelTimer();
        };
        BlockedExchangesController.prototype.loadDataPeriodically = function () {
            var _this = this;
            this.exchangesService.getBlockedExchanges()
                .then(function (exchanges) { return _this.exchanges = exchanges; })
                .then(function () { return _this.promise = _this.$timeout(function () { return _this.loadDataPeriodically(); }, _this.reloadDelay); });
        };
        BlockedExchangesController.prototype.cancelTimer = function () {
            this.$timeout.cancel(this.promise);
        };
        BlockedExchangesController.prototype.unblock = function (exchange) {
            var _this = this;
            this.$uibModal.open({
                component: 'confirmUnblockExchange'
            })
                .result.then(function () {
                _this.exchangesService.unblockExchange(exchange)
                    .then(function () {
                    _this.cancelTimer();
                    _this.loadDataPeriodically();
                });
            });
        };
        return BlockedExchangesController;
    }());
    Camel.BlockedExchangesController = BlockedExchangesController;
    Camel.blockedExchangesComponent = {
        template: "\n      <h3>Blocked</h3>\n      <p ng-if=\"$ctrl.exchanges === null\">Loading...</p>\n      <p ng-if=\"$ctrl.exchanges.length === 0\">No blocked exchanges</p>\n      <div ng-if=\"$ctrl.exchanges.length > 0\">\n        <table class=\"table table-striped table-bordered dataTable\">\n          <thead>\n            <tr>\n              <th>Exchange ID</th>\n              <th>Route ID</th>\n              <th>Node ID</th>\n              <th>Duration (ms)</th>\n              <th>Thread ID</th>\n              <th>Thread name</th>\n              <th></th>\n            </tr>\n          </thead>\n          <tbody>\n            <tr ng-repeat=\"exchange in $ctrl.exchanges track by exchange.exchangeId\">\n              <td>{{exchange.exchangeId}}</td>\n              <td>{{exchange.routeId}}</td>\n              <td>{{exchange.nodeId}}</td>\n              <td>{{exchange.duration}}</td>\n              <td>{{exchange.id}}</td>\n              <td>{{exchange.name}}</td>\n              <td class=\"table-view-pf-actions\">\n                <div class=\"table-view-pf-btn\">\n                  <button type=\"button\" class=\"btn btn-default\" ng-click=\"$ctrl.unblock(exchange)\">Unblock</button>\n                </div>\n              </td>\n            </tr>\n          </tbody>\n        </table>\n      </div>\n    ",
        controller: BlockedExchangesController
    };
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel.confirmUnblockExchangeComponent = {
        bindings: {
            close: '&',
            dismiss: '&'
        },
        template: "\n      <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"$ctrl.dismiss()\">\n          <span class=\"pficon pficon-close\" aria-hidden=\"true\"></span>\n        </button>\n        <h4 class=\"modal-title\">Unblock Exchange</h4>\n      </div>\n      <div class=\"modal-body\">\n        <p>You are about to unblock the selected thread.</p>\n        <p>This operation cannot be undone so please be careful.</p>\n      </div>\n      <div class=\"modal-footer\">\n        <button type=\"button\" class=\"btn btn-default\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"btn btn-danger\" ng-click=\"$ctrl.close()\">Unblock</button>\n      </div>\n    "
    };
})(Camel || (Camel = {}));
/// <reference path="exchanges.component.ts"/>
/// <reference path="inflight-exchanges.component.ts"/>
/// <reference path="blocked-exchanges.component.ts"/>
/// <reference path="confirm-unblock-exchange.component.ts"/>
/// <reference path="exchanges.service.ts"/>
var Camel;
(function (Camel) {
    Camel.exchangesModule = angular
        .module('hawtio-camel-exchanges', [])
        .component('exchanges', Camel.exchangesComponent)
        .component('inflightExchanges', Camel.inflightExchangesComponent)
        .component('blockedExchanges', Camel.blockedExchangesComponent)
        .component('confirmUnblockExchange', Camel.confirmUnblockExchangeComponent)
        .service('exchangesService', Camel.ExchangesService)
        .name;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var Property = /** @class */ (function () {
        function Property(name, value, description) {
            this.name = name;
            this.value = value;
            this.description = description;
        }
        Property.sortByName = function (a, b) {
            if (a.name < b.name)
                return -1;
            if (a.name > b.name)
                return 1;
            return 0;
        };
        return Property;
    }());
    Camel.Property = Property;
})(Camel || (Camel = {}));
/// <reference path="property.ts"/>
var Camel;
(function (Camel) {
    var PropertiesService = /** @class */ (function () {
        function PropertiesService() {
        }
        PropertiesService.prototype.getDefinedProperties = function (schemaProperties) {
            return Object.keys(schemaProperties)
                .filter(function (key) { return schemaProperties[key]['value']; })
                .map(function (key) {
                var propertySchema = schemaProperties[key];
                var name = propertySchema['title'] || key;
                return new Camel.Property(name, propertySchema['value'], propertySchema['description']);
            })
                .sort(Camel.Property.sortByName);
        };
        PropertiesService.prototype.getDefaultProperties = function (schemaProperties) {
            return Object.keys(schemaProperties)
                .filter(function (key) { return !schemaProperties[key]['value']; })
                .filter(function (key) { return 'defaultValue' in schemaProperties[key]; })
                .map(function (key) {
                var propertySchema = schemaProperties[key];
                var name = propertySchema['title'] || key;
                return new Camel.Property(name, propertySchema['defaultValue'], propertySchema['description']);
            })
                .sort(Camel.Property.sortByName);
        };
        PropertiesService.prototype.getUndefinedProperties = function (schemaProperties) {
            return Object.keys(schemaProperties)
                .filter(function (key) { return !schemaProperties[key]['value']; })
                .filter(function (key) { return !('defaultValue' in schemaProperties[key]); })
                .map(function (key) {
                var propertySchema = schemaProperties[key];
                var name = propertySchema['title'] || key;
                return new Camel.Property(name, null, propertySchema['description']);
            })
                .sort(Camel.Property.sortByName);
        };
        return PropertiesService;
    }());
    Camel.PropertiesService = PropertiesService;
})(Camel || (Camel = {}));
/// <reference path="../camelPlugin.ts"/>
/// <reference path="properties.service.ts"/>
var Camel;
(function (Camel) {
    PropertiesComponentController.$inject = ["$scope", "workspace", "jolokia", "documentBase", "propertiesService"];
    function PropertiesComponentController($scope, workspace, jolokia, documentBase, propertiesService) {
        'ngInject';
        function updateData() {
            var contextMBean = Camel.getSelectionCamelContextMBean(workspace);
            var componentMBeanName = null;
            if (!componentMBeanName) {
                componentMBeanName = workspace.getSelectedMBeanName();
            }
            if (componentMBeanName && contextMBean) {
                // TODO: grab name from tree instead? avoids a JMX call
                var reply = jolokia.request({ type: "read", mbean: componentMBeanName, attribute: ["ComponentName"] });
                var name = reply.value["ComponentName"];
                if (name) {
                    $scope.componentName = name;
                    Camel.log.info("Calling explainComponentJson for name:", name);
                    var query = {
                        type: 'exec',
                        mbean: contextMBean,
                        operation: 'explainComponentJson(java.lang.String,boolean)',
                        arguments: [name, true]
                    };
                    jolokia.request(query, Core.onSuccess(populateData));
                }
            }
        }
        function populateData(response) {
            Camel.log.debug("Populate data", response);
            if (response.value) {
                var schema = JSON.parse(response.value);
                $scope.icon = UrlHelpers.join(documentBase, "/img/icons/camel/endpoint24.png");
                $scope.title = schema.component.title;
                $scope.description = schema.component.description;
                $scope.labels = schema.component.label ? schema.component.label.split(',') : [];
                $scope.definedProperties = propertiesService.getDefinedProperties(schema['componentProperties']);
                $scope.defaultProperties = propertiesService.getDefaultProperties(schema['componentProperties']);
                $scope.undefinedProperties = propertiesService.getUndefinedProperties(schema['componentProperties']);
                $scope.viewTemplate = "plugins/camel/html/nodePropertiesView.html";
                Core.$apply($scope);
            }
        }
        setTimeout(function () {
            $('[data-toggle=tooltip]').tooltip();
        }, 1000);
        updateData();
    }
    Camel.PropertiesComponentController = PropertiesComponentController;
})(Camel || (Camel = {}));
/// <reference path="../camelPlugin.ts"/>
/// <reference path="properties.service.ts"/>
var Camel;
(function (Camel) {
    PropertiesDataFormatController.$inject = ["$scope", "workspace", "jolokia", "documentBase", "propertiesService"];
    function PropertiesDataFormatController($scope, workspace, jolokia, documentBase, propertiesService) {
        'ngInject';
        function updateData() {
            var dataFormatMBeanName = null;
            if (!dataFormatMBeanName) {
                dataFormatMBeanName = workspace.getSelectedMBeanName();
            }
            if (dataFormatMBeanName) {
                Camel.log.info("Calling informationJson");
                var query = {
                    type: 'exec',
                    mbean: dataFormatMBeanName,
                    operation: 'informationJson'
                };
                jolokia.request(query, Core.onSuccess(populateData));
            }
        }
        function populateData(response) {
            Camel.log.debug("Populate data", response);
            if (response.value) {
                var schema = JSON.parse(response.value);
                $scope.icon = UrlHelpers.join(documentBase, "/img/icons/camel/marshal24.png");
                $scope.title = schema.dataformat.title + " (" + schema.dataformat.name + ")";
                $scope.labels = schema.dataformat.label ? schema.dataformat.label.split(',') : [];
                $scope.description = schema.dataformat.description;
                $scope.definedProperties = propertiesService.getDefinedProperties(schema['properties']);
                $scope.defaultProperties = propertiesService.getDefaultProperties(schema['properties']);
                $scope.undefinedProperties = propertiesService.getUndefinedProperties(schema['properties']);
                $scope.viewTemplate = "plugins/camel/html/nodePropertiesView.html";
                Core.$apply($scope);
            }
        }
        setTimeout(function () {
            $('[data-toggle=tooltip]').tooltip();
        }, 1000);
        updateData();
    }
    Camel.PropertiesDataFormatController = PropertiesDataFormatController;
})(Camel || (Camel = {}));
/// <reference path="../camelPlugin.ts"/>
/// <reference path="properties.service.ts"/>
var Camel;
(function (Camel) {
    PropertiesEndpointController.$inject = ["$scope", "workspace", "jolokia", "documentBase", "propertiesService"];
    function PropertiesEndpointController($scope, workspace, jolokia, documentBase, propertiesService) {
        'ngInject';
        function updateData() {
            var contextMBean = Camel.getSelectionCamelContextMBean(workspace);
            var endpointMBean = null;
            if ($scope.contextId && $scope.endpointPath) {
                var node = workspace.findMBeanWithProperties(Camel.jmxDomain, {
                    context: $scope.contextId,
                    type: "endpoints",
                    name: $scope.endpointPath
                });
                if (node) {
                    endpointMBean = node.objectName;
                }
            }
            if (!endpointMBean) {
                endpointMBean = workspace.getSelectedMBeanName();
            }
            if (endpointMBean && contextMBean) {
                // TODO: grab url from tree instead? avoids a JMX call
                var reply = jolokia.request({ type: "read", mbean: endpointMBean, attribute: ["EndpointUri"] });
                var url = reply.value["EndpointUri"];
                if (url) {
                    $scope.endpointUrl = url;
                    Camel.log.info("Calling explainEndpointJson for url:", url);
                    var query = {
                        type: 'exec',
                        mbean: contextMBean,
                        operation: 'explainEndpointJson(java.lang.String,boolean)',
                        arguments: [url, true]
                    };
                    jolokia.request(query, Core.onSuccess(populateData));
                }
            }
        }
        function populateData(response) {
            Camel.log.debug("Populate data", response);
            if (response.value) {
                var schema = JSON.parse(response.value);
                $scope.icon = UrlHelpers.join(documentBase, "/img/icons/camel/endpoint24.png");
                $scope.title = $scope.endpointUrl;
                $scope.labels = schema.component.label ? schema.component.label.split(',') : [];
                $scope.description = schema.component.description;
                $scope.definedProperties = propertiesService.getDefinedProperties(schema['properties']);
                $scope.defaultProperties = propertiesService.getDefaultProperties(schema['properties']);
                $scope.undefinedProperties = propertiesService.getUndefinedProperties(schema['properties']);
                $scope.viewTemplate = "plugins/camel/html/nodePropertiesView.html";
                Core.$apply($scope);
            }
        }
        setTimeout(function () {
            $('[data-toggle=tooltip]').tooltip();
        }, 1000);
        updateData();
    }
    Camel.PropertiesEndpointController = PropertiesEndpointController;
})(Camel || (Camel = {}));
/// <reference path="properties.service.ts"/>
var Camel;
(function (Camel) {
    PropertiesRouteController.$inject = ["$scope", "workspace", "propertiesService"];
    function PropertiesRouteController($scope, workspace, propertiesService) {
        'ngInject';
        var routeXmlNode = Camel.getSelectedRouteNode(workspace);
        if (routeXmlNode) {
            init(routeXmlNode);
        }
        else {
            var unsubscribe_1 = $scope.$on('routeXmlNode', function () {
                unsubscribe_1();
                routeXmlNode = Camel.getSelectedRouteNode(workspace);
                init(routeXmlNode);
            });
        }
        function init(routeXmlNode) {
            var data = Camel.getRouteNodeJSON(routeXmlNode);
            var schema = Camel.getCamelSchema(routeXmlNode.nodeName);
            addValueToProperties(data, schema);
            if (Camel.log.enabledFor(Logger.DEBUG)) {
                Camel.log.debug("Properties - data:", JSON.stringify(data, null, "  "));
                Camel.log.debug("Properties - schema:", JSON.stringify(schema, null, "  "));
            }
            $scope.icon = Camel.getRouteNodeIcon(routeXmlNode);
            $scope.title = schema.title;
            $scope.labels = schema.group ? schema.group.split(',') : [];
            $scope.description = schema.description;
            $scope.definedProperties = propertiesService.getDefinedProperties(schema['properties']);
            $scope.defaultProperties = propertiesService.getDefaultProperties(schema['properties']);
            $scope.undefinedProperties = propertiesService.getUndefinedProperties(schema['properties']);
            $scope.viewTemplate = "plugins/camel/html/nodePropertiesView.html";
        }
        function addValueToProperties(data, schema) {
            for (var key in data) {
                var property = schema.properties[key];
                if (property) {
                    property.value = data[key];
                }
            }
        }
        setTimeout(function () {
            $('[data-toggle=tooltip]').tooltip();
        }, 1000);
    }
    Camel.PropertiesRouteController = PropertiesRouteController;
})(Camel || (Camel = {}));
/// <reference path="../camelPlugin.ts"/>
var Camel;
(function (Camel) {
    Camel.propertyListComponent = {
        bindings: {
            title: '@',
            properties: '<'
        },
        template: "\n      <div ng-show=\"$ctrl.properties.length > 0\">\n        <h3 title=\"\">{{$ctrl.title}}</h3>\n        <dl class=\"dl-horizontal\">\n          <dt ng-repeat-start=\"property in $ctrl.properties\" title=\"{{property.name}}\">\n            {{property.name}}\n          </dt>\n          <dd class=\"camel-properties-value\" title=\"\" ng-repeat-end>\n            <span class=\"pficon pficon-info camel-properties-info-circle\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"{{property.description}}\"></span>\n            {{property.value}}\n          </dd>\n        </dl>\n      </div>\n    "
    };
})(Camel || (Camel = {}));
/// <reference path="properties-component.controller.ts"/>
/// <reference path="properties-dataformat.controller.ts"/>
/// <reference path="properties-endpoint.controller.ts"/>
/// <reference path="properties-route.controller.ts"/>
/// <reference path="properties.service.ts"/>
/// <reference path="property-list.component.ts"/>
var Camel;
(function (Camel) {
    Camel.propertiesModule = angular
        .module('hawtio-camel-properties', [])
        .controller("Camel.PropertiesComponentController", Camel.PropertiesComponentController)
        .controller("Camel.PropertiesDataFormatController", Camel.PropertiesDataFormatController)
        .controller("Camel.PropertiesEndpointController", Camel.PropertiesEndpointController)
        .controller("Camel.PropertiesRouteController", Camel.PropertiesRouteController)
        .service('propertiesService', Camel.PropertiesService)
        .component('propertyList', Camel.propertyListComponent)
        .name;
})(Camel || (Camel = {}));
/// <reference path="rest-service.ts"/>
var Camel;
(function (Camel) {
    var RestServicesService = /** @class */ (function () {
        RestServicesService.$inject = ["jolokiaService", "workspace"];
        function RestServicesService(jolokiaService, workspace) {
            'ngInject';
            this.jolokiaService = jolokiaService;
            this.workspace = workspace;
        }
        RestServicesService.prototype.getRestServices = function () {
            var objectName = Camel.getSelectionCamelRestRegistry(this.workspace);
            return this.jolokiaService.execute(objectName, 'listRestServices')
                .then(function (obj) {
                var restServices = [];
                // the JMX tabular data has 2 indexes so we need to dive 2 levels down to grab the data
                _.values(obj).forEach(function (prop) {
                    _.values(prop).forEach(function (restService) {
                        restServices.push({
                            url: restService.url,
                            method: _.upperCase(restService.method),
                            consumes: restService.consumes,
                            produces: restService.produces,
                            routeId: restService.routeId
                        });
                    });
                });
                return restServices;
            });
        };
        return RestServicesService;
    }());
    Camel.RestServicesService = RestServicesService;
})(Camel || (Camel = {}));
/// <reference path="rest-service.ts"/>
/// <reference path="rest-services.service.ts"/>
var Camel;
(function (Camel) {
    var RestServicesController = /** @class */ (function () {
        RestServicesController.$inject = ["restServicesService"];
        function RestServicesController(restServicesService) {
            'ngInject';
            var _this = this;
            this.restServicesService = restServicesService;
            this.toolbarConfig = {
                filterConfig: {
                    fields: [
                        {
                            id: 'url',
                            title: 'URL',
                            placeholder: 'Filter by URL...',
                            filterType: 'text'
                        },
                        {
                            id: 'method',
                            title: 'Method',
                            placeholder: 'Filter by method...',
                            filterType: 'select',
                            filterValues: ['GET', 'POST', 'PUT', 'DELETE', 'PATCH']
                        },
                        {
                            id: 'consumes',
                            title: 'Consumes',
                            placeholder: 'Filter by consumes...',
                            filterType: 'text'
                        },
                        {
                            id: 'produces',
                            title: 'Produces',
                            placeholder: 'Filter by produces...',
                            filterType: 'text'
                        },
                        {
                            id: 'routeId',
                            title: 'Route ID',
                            placeholder: 'Filter by route ID...',
                            filterType: 'text'
                        }
                    ],
                    onFilterChange: function () {
                        _this.tableItems = Pf.filter(_this.restServices, _this.toolbarConfig.filterConfig);
                    },
                    resultsCount: 0
                },
                isTableView: true
            };
            this.tableConfig = {
                selectionMatchProp: "url",
                showCheckboxes: false
            };
            this.tableOptions = {
                order: [[1, "asc"], [2, "asc"]]
            };
            this.tableColumns = [
                { header: "URL", itemField: "url" },
                { header: "Method", itemField: "method" },
                { header: "Consumes", itemField: "consumes" },
                { header: "Produces", itemField: "produces" },
                { header: "Route ID", itemField: "routeId" }
            ];
        }
        RestServicesController.prototype.$onInit = function () {
            var _this = this;
            this.restServicesService.getRestServices()
                .then(function (restServices) {
                _this.restServices = restServices;
                _this.tableItems = Pf.filter(_this.restServices, _this.toolbarConfig.filterConfig);
            });
        };
        return RestServicesController;
    }());
    Camel.RestServicesController = RestServicesController;
    Camel.restServicesComponent = {
        template: "\n      <h2>REST Services</h2>\n      <p ng-if=\"!$ctrl.tableItems\">Loading...</p>\n      <div ng-if=\"$ctrl.tableItems\">\n        <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n        <pf-table-view config=\"$ctrl.tableConfig\" dt-options=\"$ctrl.tableOptions\" columns=\"$ctrl.tableColumns\"\n                       items=\"$ctrl.tableItems\"></pf-table-view>\n      </div>\n    ",
        controller: RestServicesController
    };
})(Camel || (Camel = {}));
/// <reference path="rest-services.component.ts"/>
/// <reference path="rest-services.service.ts"/>
var Camel;
(function (Camel) {
    Camel.restServicesModule = angular
        .module('hawtio-camel-rest-services', [])
        .component('restServices', Camel.restServicesComponent)
        .service('restServicesService', Camel.RestServicesService)
        .name;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var Route = /** @class */ (function () {
        function Route(name, state, mbean) {
            this.name = name;
            this.state = state;
            this.mbean = mbean;
            this.selected = false;
        }
        Route.prototype.isStarted = function () {
            return this.state === 'Started';
        };
        Route.prototype.isStopped = function () {
            return this.state === 'Stopped';
        };
        return Route;
    }());
    Camel.Route = Route;
})(Camel || (Camel = {}));
/// <reference path="route.ts"/>
var Camel;
(function (Camel) {
    var RoutesService = /** @class */ (function () {
        RoutesService.$inject = ["jolokiaService", "workspace"];
        function RoutesService(jolokiaService, workspace) {
            'ngInject';
            this.jolokiaService = jolokiaService;
            this.workspace = workspace;
            this.Operation = {
                START: 'start()',
                STOP: 'stop()',
                DELETE: 'remove()'
            };
        }
        RoutesService.prototype.getRoute = function (objectName) {
            return this.jolokiaService.getMBean(objectName)
                .then(function (mbean) { return new Camel.Route(mbean.RouteId, mbean.State, objectName); });
        };
        RoutesService.prototype.getRoutes = function (objectNames) {
            return this.jolokiaService.getMBeans(objectNames)
                .then(function (mbeans) { return mbeans.map(function (mbean, i) { return new Camel.Route(mbean.RouteId, mbean.State, objectNames[i]); }); });
        };
        RoutesService.prototype.startRoute = function (route) {
            return this.startRoutes([route]);
        };
        RoutesService.prototype.startRoutes = function (routes) {
            return this.executeOperationOnRoutes(this.Operation.START, routes);
        };
        RoutesService.prototype.stopRoute = function (route) {
            return this.stopRoutes([route]);
        };
        RoutesService.prototype.stopRoutes = function (routes) {
            return this.executeOperationOnRoutes(this.Operation.STOP, routes);
        };
        RoutesService.prototype.removeRoute = function (route) {
            return this.removeRoutes([route]);
        };
        RoutesService.prototype.removeRoutes = function (routes) {
            return this.executeOperationOnRoutes(this.Operation.DELETE, routes);
        };
        RoutesService.prototype.executeOperationOnRoutes = function (operation, routes) {
            var objectNames = routes.map(function (route) { return route.mbean; });
            return this.jolokiaService.executeMany(objectNames, operation);
        };
        RoutesService.prototype.canStartRoutes = function (routes) {
            return this.canExecuteOperationOnRoutes(this.Operation.START, routes);
        };
        RoutesService.prototype.canStopRoutes = function (routes) {
            return this.canExecuteOperationOnRoutes(this.Operation.STOP, routes);
        };
        RoutesService.prototype.canDeleteRoutes = function (routes) {
            return this.canExecuteOperationOnRoutes(this.Operation.DELETE, routes);
        };
        RoutesService.prototype.canExecuteOperationOnRoutes = function (operation, routes) {
            var _this = this;
            return _.every(routes, function (route) { return _this.workspace.hasInvokeRightsForName(route.mbean, operation); });
        };
        return RoutesService;
    }());
    Camel.RoutesService = RoutesService;
})(Camel || (Camel = {}));
/// <reference path="route.ts"/>
/// <reference path="routes.service.ts"/>
var Camel;
(function (Camel) {
    var RoutesController = /** @class */ (function () {
        RoutesController.$inject = ["$timeout", "$uibModal", "workspace", "treeService", "routesService"];
        function RoutesController($timeout, $uibModal, workspace, treeService, routesService) {
            'ngInject';
            var _this = this;
            this.$timeout = $timeout;
            this.$uibModal = $uibModal;
            this.workspace = workspace;
            this.treeService = treeService;
            this.routesService = routesService;
            this.startAction = {
                name: 'Start',
                actionFn: function (action) {
                    var selectedRoutes = _this.getSelectedRoutes();
                    _this.routesService.startRoutes(selectedRoutes)
                        .then(function (response) {
                        Core.notification('success', "Started " + Core.maybePlural(selectedRoutes.length, 'route') + " successfully");
                        _this.updateRoutes();
                    })
                        .catch(function (error) {
                        Core.notification('danger', error);
                        _this.updateRoutes();
                    });
                },
                isDisabled: true
            };
            this.stopAction = {
                name: 'Stop',
                actionFn: function (action) {
                    var selectedRoutes = _this.getSelectedRoutes();
                    _this.routesService.stopRoutes(selectedRoutes)
                        .then(function (response) {
                        Core.notification('success', "Stopped " + Core.maybePlural(selectedRoutes.length, 'route') + " successfully");
                        _this.updateRoutes();
                    })
                        .catch(function (error) {
                        Core.notification('danger', error);
                        _this.updateRoutes();
                    });
                },
                isDisabled: true
            };
            this.deleteAction = {
                name: 'Delete',
                actionFn: function (action) {
                    var selectedRoutes = _this.getSelectedRoutes();
                    _this.$uibModal.open({
                        templateUrl: 'plugins/camel/html/deleteRouteWarningModal.html'
                    })
                        .result.then(function () {
                        _this.routesService.removeRoutes(selectedRoutes)
                            .then(function (response) {
                            Core.notification('success', "Deleted " + Core.maybePlural(selectedRoutes.length, 'route') + " successfully");
                            _this.removeSelectedRoutes();
                        })
                            .catch(function (error) {
                            Core.notification('danger', error);
                            _this.updateRoutes();
                        });
                    });
                },
                isDisabled: true
            };
            this.toolbarConfig = null;
            this.tableConfig = {
                selectionMatchProp: "name",
                onCheckBoxChange: function (item) { return _this.enableDisableActions(); }
            };
            this.tableColumns = [
                { header: "Name", itemField: "name" },
                { header: "State", itemField: "state" }
            ];
            this.showTable = true;
        }
        RoutesController.prototype.$onInit = function () {
            var _this = this;
            this.loadRoutes()
                .then(function () { return _this.configureToolbar(); });
        };
        RoutesController.prototype.configureToolbar = function () {
            var primaryActions = [];
            var moreActions = [];
            if (this.routesService.canStartRoutes(this.routes)) {
                primaryActions.push(this.startAction);
            }
            if (this.routesService.canStopRoutes(this.routes)) {
                primaryActions.push(this.stopAction);
            }
            if (this.routesService.canDeleteRoutes(this.routes)) {
                moreActions.push(this.deleteAction);
            }
            Camel.log.debug("RBAC - Rendered routes actions:", primaryActions.concat(moreActions));
            if (primaryActions.length > 0 || moreActions.length > 0) {
                this.toolbarConfig = {
                    actionsConfig: {
                        primaryActions: primaryActions,
                        moreActions: moreActions
                    },
                    isTableView: true
                };
            }
        };
        RoutesController.prototype.getSelectedRoutes = function () {
            return this.routes.filter(function (route) { return route.selected; });
        };
        RoutesController.prototype.enableDisableActions = function () {
            var selectedRoutes = this.getSelectedRoutes();
            this.startAction.isDisabled = !selectedRoutes.some(function (route) { return route.state === 'Stopped'; });
            this.stopAction.isDisabled = !selectedRoutes.some(function (route) { return route.state === 'Started'; });
            this.deleteAction.isDisabled = !selectedRoutes.every(function (route) { return route.state === 'Stopped'; });
        };
        RoutesController.prototype.loadRoutes = function () {
            var _this = this;
            return this.treeService.getSelectedMBean()
                .then(function (mbean) {
                if (mbean.children) {
                    var children = mbean.children.filter(function (node) { return node.objectName != null; });
                    var mbeanNames = _.map(children, function (node) { return node.objectName; });
                    return _this.routesService.getRoutes(mbeanNames)
                        .then(function (routes) { return _this.routes = routes; });
                }
            });
        };
        RoutesController.prototype.updateRoutes = function () {
            var _this = this;
            var mbeans = _.map(this.routes, function (route) { return route.mbean; });
            this.routesService.getRoutes(mbeans)
                .then(function (routes) {
                for (var i = 0; i < routes.length; i++) {
                    if (_this.routes[i].state !== routes[i].state) {
                        _this.routes[i] = angular.extend({}, _this.routes[i], { state: routes[i].state });
                    }
                }
                _this.enableDisableActions();
                _this.repaintTable();
            });
        };
        RoutesController.prototype.removeSelectedRoutes = function () {
            _.remove(this.routes, function (route) { return route.selected; });
            this.workspace.loadTree();
            this.enableDisableActions();
        };
        // This is a hack to keep the 'select all' checkbox working after starting/stopping routes
        RoutesController.prototype.repaintTable = function () {
            var _this = this;
            this.showTable = false;
            this.$timeout(function () { return _this.showTable = true; });
        };
        return RoutesController;
    }());
    Camel.RoutesController = RoutesController;
    Camel.routesComponent = {
        template: "\n      <h2>Routes</h2>\n      <p ng-if=\"!$ctrl.routes\">Loading...</p>\n      <div ng-if=\"$ctrl.routes\">\n        <div ng-if=\"$ctrl.toolbarConfig\">\n          <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n        </div>\n        <div ng-if=\"$ctrl.showTable\">\n          <pf-table-view config=\"$ctrl.tableConfig\" columns=\"$ctrl.tableColumns\" items=\"$ctrl.routes\"></pf-table-view>\n        </div>\n      </div>\n    ",
        controller: RoutesController
    };
})(Camel || (Camel = {}));
/// <reference path="routes.service.ts"/>
/// <reference path="route.ts"/>
var Camel;
(function (Camel) {
    var RouteActionsController = /** @class */ (function () {
        RouteActionsController.$inject = ["$scope", "$uibModal", "workspace", "routesService"];
        function RouteActionsController($scope, $uibModal, workspace, routesService) {
            'ngInject';
            this.$scope = $scope;
            this.$uibModal = $uibModal;
            this.workspace = workspace;
            this.routesService = routesService;
            this.route = null;
        }
        RouteActionsController.prototype.$onInit = function () {
            var _this = this;
            this.unsubscribe = this.$scope.$on(Jmx.TreeEvent.NodeSelected, function (event, selectedNode) {
                if (_this.workspace.isRoute()) {
                    _this.routesService.getRoute(selectedNode.objectName)
                        .then(function (route) { return _this.route = route; });
                }
                else {
                    _this.route = null;
                }
            });
        };
        RouteActionsController.prototype.$onDestroy = function () {
            this.unsubscribe();
        };
        RouteActionsController.prototype.start = function () {
            var _this = this;
            this.routesService.startRoute(this.route)
                .then(function (response) {
                Core.notification('success', 'Route started successfully');
                _this.routesService.getRoute(_this.route.mbean)
                    .then(function (route) { return _this.route = route; });
            })
                .catch(function (error) {
                Core.notification('danger', error);
            });
        };
        RouteActionsController.prototype.stop = function () {
            var _this = this;
            this.routesService.stopRoute(this.route)
                .then(function (response) {
                Core.notification('success', 'Route stopped successfully');
                _this.routesService.getRoute(_this.route.mbean)
                    .then(function (route) { return _this.route = route; });
            })
                .catch(function (error) {
                Core.notification('danger', error);
            });
        };
        RouteActionsController.prototype.delete = function () {
            var _this = this;
            this.$uibModal.open({
                templateUrl: 'plugins/camel/html/deleteRouteWarningModal.html'
            })
                .result.then(function () {
                _this.routesService.removeRoute(_this.route)
                    .then(function (response) {
                    Core.notification('success', 'Route deleted successfully');
                    _this.route = null;
                    _this.workspace.loadTree();
                })
                    .catch(function (error) {
                    Core.notification('danger', error);
                });
            });
        };
        return RouteActionsController;
    }());
    Camel.RouteActionsController = RouteActionsController;
    Camel.routeActionsComponent = {
        template: "\n      <div class=\"dropdown camel-main-actions\" ng-show=\"$ctrl.route\"\n        hawtio-show object-name-model=\"$ctrl.route.mbean\" method-name=\"stop\" mode=\"remove\">\n        <button type=\"button\" id=\"dropdownMenu1\" class=\"btn btn-default dropdown-toggle\"\n          data-toggle=\"dropdown\" aria-haspopup=\"true\" aria-expanded=\"true\">\n          <span class=\"fa\" ng-class=\"{'fa-play': $ctrl.route.isStarted(), 'fa-stop': $ctrl.route.isStopped()}\"></span>\n          &nbsp;\n          {{$ctrl.route.state}}\n          &nbsp;\n          <span class=\"caret\"></span>\n        </button>\n        <ul class=\"dropdown-menu\" aria-labelledby=\"dropdownMenu1\">\n          <li ng-class=\"{disabled: $ctrl.route.isStarted()}\">\n            <a href=\"#\" ng-click=\"$ctrl.start()\">Start</a>\n          </li>\n          <li ng-class=\"{disabled: $ctrl.route.isStopped()}\">\n            <a href=\"#\" ng-click=\"$ctrl.stop()\">Stop</a>\n          </li>\n          <li ng-class=\"{disabled: $ctrl.route.isStarted()}\">\n            <a href=\"#\" ng-click=\"$ctrl.delete()\">Delete</a>\n          </li>\n        </ul>\n      </div>\n    ",
        controller: RouteActionsController
    };
})(Camel || (Camel = {}));
/// <reference path="routes.component.ts"/>
/// <reference path="route-actions.component.ts"/>
/// <reference path="routes.service.ts"/>
var Camel;
(function (Camel) {
    Camel.routesModule = angular
        .module('hawtio-camel-routes', [])
        .component('routes', Camel.routesComponent)
        .component('routeActions', Camel.routeActionsComponent)
        .service('routesService', Camel.RoutesService)
        .name;
})(Camel || (Camel = {}));
/// <reference path="../camelPlugin.ts"/>
var Camel;
(function (Camel) {
    var TreeController = /** @class */ (function () {
        TreeController.$inject = ["$scope", "$location", "workspace", "jolokia", "$element"];
        function TreeController($scope, $location, workspace, jolokia, $element) {
            'ngInject';
            this.$scope = $scope;
            this.$location = $location;
            this.workspace = workspace;
            this.jolokia = jolokia;
            this.$element = $element;
            // it's not possible to declare classes to the component host tag in AngularJS
            $element.addClass('tree-nav-sidebar-content');
        }
        TreeController.prototype.$onInit = function () {
            var _this = this;
            this.$scope.$on('$destroy', function () { return _this.removeTree(); });
            this.$scope.$on('$routeChangeStart', function () { return Jmx.updateTreeSelectionFromURL(_this.$location, $(Camel.treeElementId)); });
            this.$scope.$on('jmxTreeUpdated', function () { return _this.populateTree(); });
            this.populateTree();
        };
        TreeController.prototype.updateSelectionFromURL = function () {
            Jmx.updateTreeSelectionFromURLAndAutoSelect(this.$location, $(Camel.treeElementId), function (first) {
                // use function to auto select first Camel context routes if there is only one Camel context
                var contexts = first.children;
                if (contexts && contexts.length === 1) {
                    var first_1 = contexts[0];
                    var children = first_1.children;
                    if (children && children.length) {
                        var routes = children[0];
                        if (routes.typeName === 'routes') {
                            return routes;
                        }
                    }
                }
                return null;
            }, true);
            this.workspace.broadcastSelectionNode();
        };
        TreeController.prototype.populateTree = function () {
            var tree = this.workspace.tree;
            if (tree) {
                var rootFolder = tree.findDescendant(function (node) { return node.key === 'camelContexts'; });
                if (rootFolder) {
                    this.removeTree();
                    Jmx.enableTree(this.$scope, this.$location, this.workspace, $(Camel.treeElementId), [rootFolder]);
                    this.updateSelectionFromURL();
                }
                else {
                    // No camel contexts so redirect to the JMX view and select the first tree node
                    if (tree.children && tree.children.length > 0) {
                        var firstNode = tree.children[0];
                        this.$location.path('/jmx/attributes').search({ 'nid': firstNode['id'] });
                    }
                }
            }
        };
        TreeController.prototype.removeTree = function () {
            var tree = $(Camel.treeElementId).treeview(true);
            // There is no exposed API to check whether the tree has already been initialized,
            // so let's just check if the methods are presents
            if (tree.clearSearch) {
                tree.clearSearch();
                // Bootstrap tree view leaks the node elements into the data structure
                // so let's clean this up when the user leaves the view
                var cleanTreeFolder_2 = function (node) {
                    delete node['$el'];
                    if (node.nodes)
                        node.nodes.forEach(cleanTreeFolder_2);
                };
                cleanTreeFolder_2(this.workspace.tree);
                // Then call the tree clean-up method
                tree.remove();
            }
        };
        return TreeController;
    }());
    Camel.TreeController = TreeController;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var TreeHeaderController = /** @class */ (function () {
        TreeHeaderController.$inject = ["$scope", "$element"];
        function TreeHeaderController($scope, $element) {
            'ngInject';
            this.$scope = $scope;
            this.$element = $element;
            this.filter = '';
            this.result = [];
            // it's not possible to declare classes to the component host tag in AngularJS
            $element.addClass('tree-nav-sidebar-header');
        }
        TreeHeaderController.prototype.$onInit = function () {
            var _this = this;
            this.$scope.$watch(angular.bind(this, function () { return _this.filter; }), function (filter, previous) {
                if (filter !== previous) {
                    _this.search(filter);
                }
            });
        };
        TreeHeaderController.prototype.search = function (filter) {
            var _this = this;
            var doSearch = function (filter) {
                var _a;
                var result = _this.tree().search(filter, {
                    ignoreCase: true,
                    exactMatch: false,
                    revealResults: true,
                });
                _this.result.length = 0;
                (_a = _this.result).push.apply(_a, result);
                Core.$apply(_this.$scope);
            };
            _.debounce(doSearch, 300, { leading: false, trailing: true })(filter);
        };
        TreeHeaderController.prototype.tree = function () {
            return $(Camel.treeElementId).treeview(true);
        };
        TreeHeaderController.prototype.expandAll = function () {
            return this.tree()
                .expandNode(this.tree().getNodes(), { levels: 1, silent: true });
        };
        TreeHeaderController.prototype.contractAll = function () {
            return this.tree()
                .collapseNode(this.tree().getNodes(), { ignoreChildren: true, silent: true });
        };
        return TreeHeaderController;
    }());
    Camel.TreeHeaderController = TreeHeaderController;
})(Camel || (Camel = {}));
/// <reference path="tree.controller.ts"/>
/// <reference path="tree-header.controller.ts"/>
var Camel;
(function (Camel) {
    Camel.treeHeaderComponent = {
        templateUrl: 'plugins/camel/html/tree/header.html',
        controller: Camel.TreeHeaderController,
    };
    Camel.treeComponent = {
        templateUrl: 'plugins/camel/html/tree/content.html',
        controller: Camel.TreeController,
    };
})(Camel || (Camel = {}));
/// <reference path="tree.component.ts"/>
var Camel;
(function (Camel) {
    Camel.treeModule = angular
        .module('hawtio-camel-tree', [])
        .component('camelTreeHeader', Camel.treeHeaderComponent)
        .component('camelTree', Camel.treeComponent)
        .name;
    Camel.treeElementId = '#cameltree';
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel.typeConvertersComponent = {
        template: "\n      <h2>Type Converters</h2>\n      <type-converters-statistics></type-converters-statistics>\n      <type-converters-table></type-converters-table>\n    "
    };
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var TypeConvertersStatistics = /** @class */ (function () {
        function TypeConvertersStatistics(object) {
            angular.extend(this, object);
        }
        TypeConvertersStatistics.prototype.reset = function () {
            this.AttemptCounter = 0;
            this.HitCounter = 0;
            this.MissCounter = 0;
            this.FailedCounter = 0;
        };
        return TypeConvertersStatistics;
    }());
    Camel.TypeConvertersStatistics = TypeConvertersStatistics;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var TypeConverter = /** @class */ (function () {
        function TypeConverter(from, to) {
            this.from = from;
            this.to = to;
        }
        return TypeConverter;
    }());
    Camel.TypeConverter = TypeConverter;
})(Camel || (Camel = {}));
/// <reference path='type-converters-statistics.ts'/>
/// <reference path="type-converter.ts"/>
var Camel;
(function (Camel) {
    var TypeConvertersService = /** @class */ (function () {
        TypeConvertersService.$inject = ["jolokiaService", "treeService"];
        function TypeConvertersService(jolokiaService, treeService) {
            'ngInject';
            this.jolokiaService = jolokiaService;
            this.treeService = treeService;
        }
        TypeConvertersService.prototype.enableStatistics = function () {
            var _this = this;
            return this.getTypeConverterObjectName()
                .then(function (objectName) { return _this.jolokiaService.setAttribute(objectName, 'StatisticsEnabled', true); });
        };
        TypeConvertersService.prototype.disableStatistics = function () {
            var _this = this;
            return this.getTypeConverterObjectName()
                .then(function (objectName) { return _this.jolokiaService.setAttribute(objectName, 'StatisticsEnabled', false); });
        };
        TypeConvertersService.prototype.resetStatistics = function () {
            var _this = this;
            return this.getTypeConverterObjectName()
                .then(function (objectName) { return _this.jolokiaService.execute(objectName, 'resetTypeConversionCounters'); });
        };
        TypeConvertersService.prototype.getStatistics = function () {
            var _this = this;
            var attributes = ['AttemptCounter', 'HitCounter', 'MissCounter', 'FailedCounter'];
            return this.getTypeConverterObjectName()
                .then(function (objectName) { return _this.jolokiaService.getAttributes(objectName, attributes); })
                .then(function (object) { return new Camel.TypeConvertersStatistics(object); });
        };
        TypeConvertersService.prototype.getTypeConverters = function () {
            var _this = this;
            return this.getTypeConverterObjectName()
                .then(function (objectName) { return _this.jolokiaService.execute(objectName, 'listTypeConverters')
                .then(function (object) {
                var typeConverters = [];
                for (var from in object) {
                    var tos = object[from];
                    for (var to in tos) {
                        typeConverters.push(new Camel.TypeConverter(from, to));
                    }
                }
                return typeConverters;
            }); });
        };
        TypeConvertersService.prototype.getTypeConverterObjectName = function () {
            return this.treeService.findMBeanWithProperties('org.apache.camel', { type: 'services', name: '*TypeConverter' })
                .then(function (mbean) { return mbean.objectName; });
        };
        return TypeConvertersService;
    }());
    Camel.TypeConvertersService = TypeConvertersService;
})(Camel || (Camel = {}));
/// <reference path="type-converters.service.ts"/>
/// <reference path='type-converters-statistics.ts'/>
var Camel;
(function (Camel) {
    var TypeCovertersStatisticsController = /** @class */ (function () {
        TypeCovertersStatisticsController.$inject = ["$timeout", "typeConvertersService"];
        function TypeCovertersStatisticsController($timeout, typeConvertersService) {
            'ngInject';
            var _this = this;
            this.$timeout = $timeout;
            this.typeConvertersService = typeConvertersService;
            this.reloadDelay = 10000;
            this.enableStatisticsAction = {
                name: 'Enable statistics',
                actionFn: function () { return _this.enableStatistics(); }
            };
            this.disableStatisticsAction = {
                name: 'Disable statistics',
                actionFn: function () { return _this.disableStatistics(); }
            };
            this.resetStatisticsAction = {
                name: 'Reset statistics',
                actionFn: function () { return _this.resetStatistics(); },
                isDisabled: true
            };
            this.toolbarConfig = {
                actionsConfig: {
                    primaryActions: [
                        this.enableStatisticsAction,
                        this.resetStatisticsAction
                    ]
                }
            };
        }
        TypeCovertersStatisticsController.prototype.enableStatistics = function () {
            this.typeConvertersService.enableStatistics();
            this.loadDataPeriodically();
            this.showDisableStatisticsButton();
        };
        TypeCovertersStatisticsController.prototype.showDisableStatisticsButton = function () {
            this.toolbarConfig.actionsConfig.primaryActions[0] = this.disableStatisticsAction;
            this.resetStatisticsAction.isDisabled = false;
        };
        TypeCovertersStatisticsController.prototype.disableStatistics = function () {
            this.cancelTimer();
            this.typeConvertersService.disableStatistics();
            this.showEnableStatisticsButton();
        };
        TypeCovertersStatisticsController.prototype.showEnableStatisticsButton = function () {
            this.toolbarConfig.actionsConfig.primaryActions[0] = this.enableStatisticsAction;
            this.resetStatisticsAction.isDisabled = true;
            this.statistics = null;
        };
        TypeCovertersStatisticsController.prototype.resetStatistics = function () {
            this.typeConvertersService.resetStatistics();
            this.statistics.reset();
        };
        TypeCovertersStatisticsController.prototype.$onDestroy = function () {
            this.cancelTimer();
        };
        TypeCovertersStatisticsController.prototype.loadDataPeriodically = function () {
            var _this = this;
            this.typeConvertersService.getStatistics()
                .then(function (statistics) { return _this.statistics = statistics; })
                .then(function () { return _this.promise = _this.$timeout(function () { return _this.loadDataPeriodically(); }, _this.reloadDelay); });
        };
        TypeCovertersStatisticsController.prototype.cancelTimer = function () {
            this.$timeout.cancel(this.promise);
        };
        return TypeCovertersStatisticsController;
    }());
    Camel.TypeCovertersStatisticsController = TypeCovertersStatisticsController;
    Camel.typeConvertersStatisticsComponent = {
        template: "\n      <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n      <dl class=\"dl-horizontal camel-type-converters-statistics\">\n        <dt>Attempts</dt>\n        <dd>{{$ctrl.statistics ? $ctrl.statistics.AttemptCounter : '-'}}</dd>\n        <dt>Hits</dt>\n        <dd>{{$ctrl.statistics ? $ctrl.statistics.HitCounter : '-'}}</dd>\n        <dt>Misses</dt>\n        <dd>{{$ctrl.statistics ? $ctrl.statistics.MissCounter : '-'}}</dd>\n        <dt>Failures</dt>\n        <dd>{{$ctrl.statistics ? $ctrl.statistics.FailedCounter : '-'}}</dd>\n      </dl>\n    ",
        controller: TypeCovertersStatisticsController
    };
})(Camel || (Camel = {}));
/// <reference path="type-converter.ts"/>
var Camel;
(function (Camel) {
    var TypeCovertersTableController = /** @class */ (function () {
        TypeCovertersTableController.$inject = ["typeConvertersService"];
        function TypeCovertersTableController(typeConvertersService) {
            'ngInject';
            var _this = this;
            this.typeConvertersService = typeConvertersService;
            this.toolbarConfig = {
                filterConfig: {
                    fields: [
                        {
                            id: 'from',
                            title: 'From',
                            placeholder: 'Filter by from...',
                            filterType: 'text'
                        },
                        {
                            id: 'to',
                            title: 'To',
                            placeholder: 'Filter by to...',
                            filterType: 'text'
                        }
                    ],
                    onFilterChange: function (filters) {
                        _this.applyFilters(filters);
                    },
                    resultsCount: 0
                },
                isTableView: true
            };
            this.tableConfig = {
                selectionMatchProp: 'from',
                showCheckboxes: false
            };
            this.tableDtOptions = {
                order: [[0, "asc"], [1, "asc"]],
            };
            this.tableColumns = [
                { header: 'From', itemField: 'from' },
                { header: 'To', itemField: 'to' }
            ];
        }
        TypeCovertersTableController.prototype.$onInit = function () {
            var _this = this;
            this.typeConvertersService.getTypeConverters()
                .then(function (typeConverters) {
                _this.allTypeConverters = typeConverters;
                _this.applyFilters([]);
            });
        };
        TypeCovertersTableController.prototype.applyFilters = function (filters) {
            var _this = this;
            this.typeConverters = this.allTypeConverters;
            filters.forEach(function (filter) {
                var regExp = new RegExp(filter.value, 'i');
                switch (filter.id) {
                    case 'from':
                        _this.typeConverters = _this.typeConverters.filter(function (typeConverter) { return regExp.test(typeConverter.from); });
                        break;
                    case 'to':
                        _this.typeConverters = _this.typeConverters.filter(function (typeConverter) { return regExp.test(typeConverter.to); });
                        break;
                }
            });
            this.toolbarConfig.filterConfig.resultsCount = this.typeConverters.length;
        };
        return TypeCovertersTableController;
    }());
    Camel.TypeCovertersTableController = TypeCovertersTableController;
    Camel.typeConvertersTableComponent = {
        template: "\n      <div class=\"table-view\">\n        <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n        <pf-table-view config=\"$ctrl.tableConfig\"\n                       dt-options=\"$ctrl.tableDtOptions\"\n                       columns=\"$ctrl.tableColumns\"\n                       items=\"$ctrl.typeConverters\"></pf-table-view>\n      </div>\n    ",
        controller: TypeCovertersTableController
    };
})(Camel || (Camel = {}));
/// <reference path="type-converters.component.ts"/>
/// <reference path="type-converters-statistics.component.ts"/>
/// <reference path="type-converters-table.component.ts"/>
/// <reference path="type-converters.service.ts"/>
var Camel;
(function (Camel) {
    Camel.typeConvertersModule = angular
        .module('hawtio-camel-type-converters', [])
        .component('typeConverters', Camel.typeConvertersComponent)
        .component('typeConvertersStatistics', Camel.typeConvertersStatisticsComponent)
        .component('typeConvertersTable', Camel.typeConvertersTableComponent)
        .service('typeConvertersService', Camel.TypeConvertersService)
        .name;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    /**
     * Define the default categories for endpoints and map them to endpoint names
     * @property
     * @for Camel
     * @type {Object}
     */
    Camel.endpointCategories = {
        bigdata: {
            label: "Big Data",
            endpoints: ["hdfs", "hbase", "lucene", "solr"],
            endpointIcon: "img/icons/camel/endpointRepository24.png"
        },
        database: {
            label: "Database",
            endpoints: ["couchdb", "elasticsearch", "hbase", "jdbc", "jpa", "hibernate", "mongodb", "mybatis", "sql"],
            endpointIcon: "img/icons/camel/endpointRepository24.png"
        },
        cloud: {
            label: "Cloud",
            endpoints: [
                "aws-cw", "aws-ddb", "aws-sdb", "aws-ses", "aws-sns", "aws-sqs", "aws-s3",
                "gauth", "ghhtp", "glogin", "gtask",
                "jclouds"
            ]
        },
        core: {
            label: "Core",
            endpoints: ["bean", "direct", "seda"]
        },
        messaging: {
            label: "Messaging",
            endpoints: ["jms", "activemq", "amqp", "cometd", "cometds", "mqtt", "netty", "vertx", "websocket"],
            endpointIcon: "img/icons/camel/endpointQueue24.png"
        },
        mobile: {
            label: "Mobile",
            endpoints: ["apns"]
        },
        sass: {
            label: "SaaS",
            endpoints: ["salesforce", "sap-netweaver"]
        },
        social: {
            label: "Social",
            endpoints: ["atom", "facebook", "irc", "ircs", "rss", "smpp", "twitter", "weather"]
        },
        storage: {
            label: "Storage",
            endpointIcon: "img/icons/camel/endpointFolder24.png",
            endpoints: ["file", "ftp", "sftp", "scp", "jsch"]
        },
        template: {
            label: "Templating",
            endpoints: ["freemarker", "velocity", "xquery", "xslt", "scalate", "string-template"]
        }
    };
    /**
     * Maps endpoint names to a category object
     * @property
     * @for Camel
     * @type {Object}
     */
    Camel.endpointToCategory = {};
    Camel.endpointIcon = "img/icons/camel/endpoint24.png";
    /**
     *  specify custom label & icon properties for endpoint names
     * @property
     * @for Camel
     * @type {Object}
     */
    Camel.endpointConfigurations = {
        drools: {
            icon: "img/icons/camel/endpointQueue24.png"
        },
        quartz: {
            icon: "img/icons/camel/endpointTimer24.png"
        },
        facebook: {
            icon: "img/icons/camel/endpoints/facebook24.jpg"
        },
        salesforce: {
            icon: "img/icons/camel/endpoints/salesForce24.png"
        },
        sap: {
            icon: "img/icons/camel/endpoints/SAPe24.png"
        },
        "sap-netweaver": {
            icon: "img/icons/camel/endpoints/SAPNetweaver24.jpg"
        },
        timer: {
            icon: "img/icons/camel/endpointTimer24.png"
        },
        twitter: {
            icon: "img/icons/camel/endpoints/twitter24.png"
        },
        weather: {
            icon: "img/icons/camel/endpoints/weather24.jpg"
        }
    };
    /**
     * Define the default form configurations
     * @property
     * @for Camel
     * @type {Object}
     */
    Camel.endpointForms = {
        file: {
            tabs: {
                //'Core': ['key', 'value'],
                'Options': ['*']
            }
        },
        activemq: {
            tabs: {
                'Connection': ['clientId', 'transacted', 'transactedInOut', 'transactionName', 'transactionTimeout'],
                'Producer': ['timeToLive', 'priority', 'allowNullBody', 'pubSubNoLocal', 'preserveMessageQos'],
                'Consumer': ['concurrentConsumers', 'acknowledgementModeName', 'selector', 'receiveTimeout'],
                'Reply': ['replyToDestination', 'replyToDeliveryPersistent', 'replyToCacheLevelName', 'replyToDestinationSelectorName'],
                'Options': ['*']
            }
        }
    };
    Camel.endpointForms["jms"] = Camel.endpointForms.activemq;
    angular.forEach(Camel.endpointCategories, function (category, catKey) {
        category['id'] = catKey;
        angular.forEach(category.endpoints, function (endpoint) {
            Camel.endpointToCategory[endpoint] = category;
        });
    });
    /**
     * Override the EIP pattern tabs...
     * @property
     * @for Camel
     * @type {Object}
     */
    var camelModelTabExtensions = {
        route: {
            'Overview': ['id', 'description'],
            'Advanced': ['*']
        }
    };
    function getEndpointIcon(endpointName) {
        var value = Camel.getEndpointConfig(endpointName, null);
        var answer = Core.pathGet(value, ["icon"]);
        if (!answer) {
            var category = getEndpointCategory(endpointName);
            answer = Core.pathGet(category, ["endpointIcon"]);
        }
        return answer || Camel.endpointIcon;
    }
    Camel.getEndpointIcon = getEndpointIcon;
    function getEndpointConfig(endpointName, category) {
        var answer = Camel.endpointConfigurations[endpointName];
        if (!answer) {
            answer = {};
            Camel.endpointConfigurations[endpointName] = answer;
        }
        if (!answer.label) {
            answer.label = endpointName;
        }
        if (!answer.icon) {
            answer.icon = Core.pathGet(category, ["endpointIcon"]) || Camel.endpointIcon;
        }
        if (!answer.category) {
            answer.category = category;
        }
        return answer;
    }
    Camel.getEndpointConfig = getEndpointConfig;
    function getEndpointCategory(endpointName) {
        return Camel.endpointToCategory[endpointName] || Camel.endpointCategories.core;
    }
    Camel.getEndpointCategory = getEndpointCategory;
    function getConfiguredCamelModel() {
        var schema = Camel._apacheCamelModel;
        var definitions = schema["definitions"];
        if (definitions) {
            angular.forEach(camelModelTabExtensions, function (tabs, name) {
                var model = definitions[name];
                if (model) {
                    if (!model["tabs"]) {
                        model["tabs"] = tabs;
                    }
                }
            });
        }
        return schema;
    }
    Camel.getConfiguredCamelModel = getConfiguredCamelModel;
    function initEndpointChooserScope($scope, $location, localStorage, workspace, jolokia) {
        $scope.selectedComponentName = null;
        $scope.endpointParameters = {};
        $scope.endpointPath = "";
        $scope.schema = {
            definitions: {}
        };
        $scope.jolokia = jolokia;
        $scope.profileWorkspace = workspace;
        var silentOptions = { silent: true };
        $scope.$watch('selectedComponentName', function () {
            if ($scope.selectedComponentName !== $scope.loadedComponentName) {
                $scope.endpointParameters = {};
                $scope.loadEndpointSchema($scope.selectedComponentName);
                $scope.loadedComponentName = $scope.selectedComponentName;
            }
        });
        $scope.endpointCompletions = function (completionText) {
            var answer = null;
            var mbean = findCamelContextMBean();
            var componentName = $scope.selectedComponentName;
            var endpointParameters = {};
            if (mbean && componentName && completionText) {
                answer = $scope.jolokia.execute(mbean, 'completeEndpointPath', componentName, endpointParameters, completionText, Core.onSuccess(null, silentOptions));
            }
            return answer || [];
        };
        $scope.loadEndpointNames = function () {
            $scope.componentNames = null;
            var mbean = findCamelContextMBean();
            if (mbean) {
                $scope.jolokia.execute(mbean, 'findComponentNames', Core.onSuccess(onComponents, silentOptions));
            }
            else {
                Camel.log.warn('WARNING: No camel context mbean so cannot load component names');
            }
        };
        $scope.loadEndpointSchema = function (componentName) {
            var mbean = findCamelContextMBean();
            if (mbean && componentName && componentName !== $scope.loadedEndpointSchema) {
                $scope.selectedComponentName = componentName;
                $scope.jolokia.execute(mbean, 'componentParameterJsonSchema', componentName, Core.onSuccess(onEndpointSchema, silentOptions));
            }
        };
        function onComponents(response) {
            $scope.componentNames = response;
            Camel.log.info("onComponents: " + response);
            $scope.hasComponentNames = $scope.componentNames ? true : false;
            Core.$apply($scope);
        }
        function onEndpointSchema(response) {
            if (response) {
                try {
                    var json = JSON.parse(response);
                    var endpointName = $scope.selectedComponentName;
                    configureEndpointSchema(endpointName, json);
                    $scope.endpointSchema = json;
                    $scope.schema.definitions[endpointName] = json;
                    $scope.loadedEndpointSchema = endpointName;
                    Core.$apply($scope);
                }
                catch (e) {
                    Camel.log.error("Failed to parse JSON " + e);
                    Camel.log.error("JSON: " + response);
                }
            }
        }
        function configureEndpointSchema(endpointName, json) {
            var config = Camel.endpointForms[endpointName];
            if (config && json) {
                if (config.tabs) {
                    json.tabs = config.tabs;
                }
            }
        }
        /**
         * Creates a remote workspace given a remote jolokia for querying the JMX MBeans inside the jolokia
         * @param remoteJolokia
         * @param remoteJolokiaStatus
         * @param $location
         * @param localStorage
         * @return {Workspace}
         */
        function createRemoteWorkspace(remoteJolokia, remoteJolokiaStatus, $location, localStorage, $rootScope, $compile, $templateCache) {
            if ($rootScope === void 0) { $rootScope = null; }
            if ($compile === void 0) { $compile = null; }
            if ($templateCache === void 0) { $templateCache = null; }
            // lets create a child workspace object for the remote container
            var jolokiaStatus = {
                xhr: null,
                listMethod: remoteJolokiaStatus.listMethod,
                listMBean: remoteJolokiaStatus.listMBean
            };
            // disable reload notifications
            var jmxTreeLazyLoadRegistry = Core.lazyLoaders;
            var profileWorkspace = new Jmx.Workspace(remoteJolokia, jolokiaStatus, jmxTreeLazyLoadRegistry, $location, $compile, $templateCache, localStorage, $rootScope);
            Camel.log.info("Loading the profile using jolokia: " + remoteJolokia);
            profileWorkspace.loadTree();
            return profileWorkspace;
        }
        function findCamelContextMBean() {
            var profileWorkspace = $scope.profileWorkspace;
            if (!profileWorkspace) {
                var remoteJolokia = $scope.jolokia;
                if (remoteJolokia) {
                    profileWorkspace = createRemoteWorkspace(remoteJolokia, workspace.jolokiaStatus, $location, localStorage);
                    $scope.profileWorkspace = profileWorkspace;
                }
            }
            if (!profileWorkspace) {
                Camel.log.info("No profileWorkspace found so defaulting it to workspace for now");
                profileWorkspace = workspace;
            }
            // TODO we need to find the MBean for the CamelContext / Route we are editing!
            var componentName = $scope.selectedComponentName;
            var selectedCamelContextId;
            var selectedRouteId;
            if (angular.isDefined($scope.camelSelectionDetails)) {
                selectedCamelContextId = $scope.camelSelectionDetails.selectedCamelContextId;
                selectedRouteId = $scope.camelSelectionDetails.selectedRouteId;
            }
            var contexts = Camel.camelContextMBeansById(profileWorkspace);
            if (selectedCamelContextId) {
                var context = contexts[selectedCamelContextId];
                if (context) {
                    return context.objectName;
                }
            }
            if (selectedRouteId) {
                var map = Camel.camelContextMBeansByRouteId(profileWorkspace);
                var mbean = Core.pathGet(map, [selectedRouteId, 'mbean']);
                if (mbean) {
                    return mbean;
                }
            }
            if (componentName) {
                var map = Camel.camelContextMBeansByComponentName(profileWorkspace);
                var mbean = Core.pathGet(map, [componentName, 'mbean']);
                if (mbean) {
                    return mbean;
                }
            }
            // NOTE we don't really know which camel context to pick, so lets just find the first one?
            return _.first(_.values(contexts)).objectName;
        }
    }
    Camel.initEndpointChooserScope = initEndpointChooserScope;
})(Camel || (Camel = {}));
/// <reference path="endpointChooser.ts"/>
var Camel;
(function (Camel) {
    Camel.pluginName = 'hawtio-integration-camel';
    Camel.log = Logger.get(Camel.pluginName);
    Camel.jmxDomain = 'org.apache.camel';
    Camel.defaultMaximumLabelWidth = 34;
    Camel.defaultCamelMaximumTraceOrDebugBodyLength = 5000;
    Camel.defaultCamelTraceOrDebugIncludeStreams = false;
    Camel.defaultCamelRouteMetricMaxSeconds = 10;
    Camel.defaultHideOptionDocumentation = false;
    Camel.defaultHideOptionDefaultValue = false;
    Camel.defaultHideOptionUnusedValue = false;
    Camel._apacheCamelModel = undefined;
    hawtioPluginLoader.registerPreBootstrapTask(function (next) {
        Camel._apacheCamelModel = window['_apacheCamelModel'];
        Camel.log.debug("Setting apache camel model: ", Camel._apacheCamelModel);
        next();
    });
    /**
     * Returns if the given CamelContext has any rest services
     *
     * @param workspace
     * @param jolokia
     * @returns {boolean}
     */
    function hasRestServices(workspace, jolokia) {
        var mbean = getSelectionCamelRestRegistry(workspace);
        if (mbean) {
            var numberOfRestServices = jolokia.getAttribute(mbean, 'NumberOfRestServices');
            return numberOfRestServices > 0;
        }
        return false;
    }
    Camel.hasRestServices = hasRestServices;
    /**
     * Looks up the route XML for the given context and selected route and
     * processes the selected route's XML with the given function
     * @method processRouteXml
     * @param {Workspace} workspace
     * @param {Object} jolokia
     * @param {Folder} folder
     * @param {Function} onRoute
     */
    function processRouteXml(workspace, jolokia, folder, onRoute) {
        var selectedRouteId = getSelectedRouteId(workspace, folder);
        var mbean = getExpandingFolderCamelContextMBean(workspace, folder) || getSelectionCamelContextMBean(workspace);
        var onRouteXml = function (xml) {
            var route = null;
            if (xml) {
                var doc = $.parseXML(xml);
                var routes = $(doc).find("route[id='" + selectedRouteId + "']");
                if (routes && routes.length) {
                    route = routes[0];
                }
            }
            onRoute(route);
        };
        if (mbean && selectedRouteId) {
            // Run synchronously as we want the treeview lazy function to fully complete
            var response = jolokia.request({ type: 'exec', mbean: mbean, operation: 'dumpRoutesAsXml()' }, Core.onSuccess(null));
            var xml = null;
            if (response && response.value) {
                xml = response.value;
            }
            else if (response && response.error) {
                Camel.log.error('Jolokia request dumpRoutesAsXml failed:', response.error);
            }
            onRouteXml(xml);
        }
        else {
            if (!selectedRouteId) {
                Camel.log.warn("No selectedRouteId when trying to lazy load the route!");
            }
            onRoute(null);
        }
    }
    Camel.processRouteXml = processRouteXml;
    /**
     * Returns the URI string for the given EIP pattern node or null if it is not applicable
     * @method getRouteNodeUri
     * @param {Object} node
     * @return {String}
     */
    function getRouteNodeUri(node) {
        var uri = null;
        if (node) {
            uri = node.getAttribute("uri");
            if (!uri) {
                var ref = node.getAttribute("ref");
                if (ref) {
                    var method = node.getAttribute("method");
                    if (method) {
                        uri = ref + "." + method + "()";
                    }
                    else {
                        uri = "ref:" + ref;
                    }
                }
            }
        }
        return uri;
    }
    Camel.getRouteNodeUri = getRouteNodeUri;
    /**
     * Returns the JSON data for the camel folder; extracting it from the associated
     * routeXmlNode or using the previously extracted and/or edited JSON
     * @method getRouteFolderJSON
     * @param {Folder} folder
     * @param {Object} answer
     * @return {Object}
     */
    function getRouteFolderJSON(folder, answer) {
        if (answer === void 0) { answer = {}; }
        var nodeData = folder["camelNodeData"];
        if (!nodeData) {
            var routeXmlNode = folder["routeXmlNode"];
            if (routeXmlNode) {
                nodeData = Camel.getRouteNodeJSON(routeXmlNode);
            }
            if (!nodeData) {
                nodeData = answer;
            }
            folder["camelNodeData"] = nodeData;
        }
        return nodeData;
    }
    Camel.getRouteFolderJSON = getRouteFolderJSON;
    function getRouteNodeJSON(routeXmlNode, answer) {
        if (answer === void 0) { answer = {}; }
        if (routeXmlNode) {
            angular.forEach(routeXmlNode.attributes, function (attr) {
                answer[attr.name] = attr.value;
            });
            // lets not iterate into routes/rests or top level tags
            var localName = routeXmlNode.localName;
            if (localName !== "route" && localName !== "routes" && localName !== "camelContext" && localName !== "rests") {
                // lets look for nested elements and convert those
                // explicitly looking for expressions
                $(routeXmlNode).children("*").each(function (idx, element) {
                    var nodeName = element.localName;
                    var langSettings = Camel.camelLanguageSettings(nodeName);
                    if (langSettings) {
                        // TODO the expression key could be anything really; how should we know?
                        answer["expression"] = {
                            language: nodeName,
                            expression: element.textContent
                        };
                    }
                    else {
                        if (!isCamelPattern(nodeName)) {
                            var nested = getRouteNodeJSON(element);
                            if (nested) {
                                // unwrap the nested expression which we do not want to double wrap
                                if (nested["expression"]) {
                                    nested = nested["expression"];
                                }
                                // special for aggregate as it has duplicate option names
                                if (nodeName === "completionSize") {
                                    nodeName = "completionSizeExpression";
                                }
                                else if (nodeName === "completionTimeout") {
                                    nodeName = "completionTimeoutExpression";
                                }
                                answer[nodeName] = nested;
                            }
                        }
                    }
                });
            }
        }
        return answer;
    }
    Camel.getRouteNodeJSON = getRouteNodeJSON;
    function increaseIndent(currentIndent, indentAmount) {
        if (indentAmount === void 0) { indentAmount = "  "; }
        return currentIndent + indentAmount;
    }
    Camel.increaseIndent = increaseIndent;
    function setRouteNodeJSON(routeXmlNode, newData, indent) {
        if (routeXmlNode) {
            var childIndent = increaseIndent(indent);
            function doUpdate(value, key, append) {
                if (append === void 0) { append = false; }
                if (angular.isArray(value)) {
                    // remove previous nodes
                    $(routeXmlNode).children(key).remove();
                    angular.forEach(value, function (item) {
                        doUpdate(item, key, true);
                    });
                }
                else if (angular.isObject(value)) {
                    // convert languages to the right xml
                    var textContent = null;
                    if (key === "expression") {
                        var languageName = value["language"];
                        if (languageName) {
                            key = languageName;
                            textContent = value["expression"];
                            value = angular.copy(value);
                            delete value["expression"];
                            delete value["language"];
                        }
                    }
                    // TODO deal with nested objects...
                    var nested = $(routeXmlNode).children(key);
                    var element = null;
                    if (append || !nested || !nested.length) {
                        var doc = routeXmlNode.ownerDocument || document;
                        routeXmlNode.appendChild(doc.createTextNode("\n" + childIndent));
                        element = doc.createElementNS(routeXmlNode.namespaceURI, key);
                        if (textContent) {
                            element.appendChild(doc.createTextNode(textContent));
                        }
                        routeXmlNode.appendChild(element);
                    }
                    else {
                        element = nested[0];
                    }
                    setRouteNodeJSON(element, value, childIndent);
                    if (textContent) {
                        nested.text(textContent);
                    }
                }
                else {
                    if (value) {
                        if (_.startsWith(key, "_")) {
                            // ignore
                        }
                        else {
                            var text = value.toString();
                            routeXmlNode.setAttribute(key, text);
                        }
                    }
                    else {
                        routeXmlNode.removeAttribute(key);
                    }
                }
            }
            angular.forEach(newData, function (value, key) { return doUpdate(value, key, false); });
        }
    }
    Camel.setRouteNodeJSON = setRouteNodeJSON;
    function getRouteNodeIcon(nodeSettingsOrXmlNode) {
        var nodeSettings = null;
        if (nodeSettingsOrXmlNode) {
            var nodeName = nodeSettingsOrXmlNode.localName;
            if (nodeName) {
                nodeSettings = getCamelSchema(nodeName);
            }
            else {
                nodeSettings = nodeSettingsOrXmlNode;
            }
        }
        if (nodeSettings) {
            var imageName = nodeSettings["icon"] || "generic24.png";
            return UrlHelpers.join("img/icons/camel/", imageName);
        }
        else {
            return null;
        }
    }
    Camel.getRouteNodeIcon = getRouteNodeIcon;
    /**
     * Parse out the currently selected endpoint's name to be used when invoking on a
     * context operation that wants an endpoint name
     * @method getSelectedEndpointName
     * @param {Workspace} workspace
     * @return {any} either a string that is the endpoint name or null if it couldn't be parsed
     */
    function getSelectedEndpointName(workspace) {
        var selection = workspace.selection;
        if (selection && selection['objectName'] && selection['typeName'] && selection['typeName'] === 'endpoints') {
            var mbean = Core.parseMBean(selection['objectName']);
            if (!mbean) {
                return null;
            }
            var attributes = mbean['attributes'];
            if (!attributes) {
                return null;
            }
            if (!('name' in attributes)) {
                return null;
            }
            var uri = attributes['name'];
            uri = uri.replace("\\?", "?");
            if (_.startsWith(uri, "\"")) {
                uri = uri.substr(1);
            }
            if (_.endsWith(uri, "\"")) {
                uri = uri.substr(0, uri.length - 1);
            }
            return uri;
        }
        else {
            return null;
        }
    }
    Camel.getSelectedEndpointName = getSelectedEndpointName;
    /**
     * Escapes the given URI text so it can be used in a JMX name
     */
    function escapeEndpointUriNameForJmx(uri) {
        if (angular.isString(uri)) {
            var answer = uri.replace("?", "\\?");
            // lets ensure that we have a "//" after each ":"
            answer = answer.replace(/\:(\/[^\/])/, "://$1");
            answer = answer.replace(/\:([^\/])/, "://$1");
            return answer;
        }
        else {
            return uri;
        }
    }
    Camel.escapeEndpointUriNameForJmx = escapeEndpointUriNameForJmx;
    /**
     * Returns the mbean for the currently selected camel context and the name of the currently
     * selected endpoint for JMX operations on a context that require an endpoint name.
     * @method
     * @param workspace
     * @return {{uri: string, mbean: string}} either value could be null if there's a parse failure
     */
    function getContextAndTargetEndpoint(workspace) {
        return {
            uri: Camel.getSelectedEndpointName(workspace),
            mbean: Camel.getSelectionCamelContextMBean(workspace)
        };
    }
    Camel.getContextAndTargetEndpoint = getContextAndTargetEndpoint;
    /**
     * Returns the cached Camel XML route node stored in the current tree selection Folder
     * @method
     */
    function getSelectedRouteNode(workspace) {
        var selection = workspace.selection || workspace.getSelectedMBean();
        return (selection && Camel.jmxDomain === selection.domain) ? selection["routeXmlNode"] : null;
    }
    Camel.getSelectedRouteNode = getSelectedRouteNode;
    /**
     * Returns true when the selected node is a Camel XML route node, false otherwise.
     * @method
     */
    function isRouteNode(workspace) {
        var selection = workspace.selection || workspace.getSelectedMBean();
        return selection && selection.domain === Camel.jmxDomain && selection.typeName === 'routeNode';
    }
    Camel.isRouteNode = isRouteNode;
    /**
     * Looks up the given node name in the Camel schema
     * @method
     */
    function getCamelSchema(nodeIdOrDefinition) {
        return (angular.isObject(nodeIdOrDefinition)) ? nodeIdOrDefinition : Forms.lookupDefinition(nodeIdOrDefinition, Camel._apacheCamelModel);
    }
    Camel.getCamelSchema = getCamelSchema;
    /**
     * Returns true if the given nodeId is a route, endpoint or pattern
     * (and not some nested type like a data format)
     * @method
     */
    function isCamelPattern(nodeId) {
        return Forms.lookupDefinition(nodeId, Camel._apacheCamelModel) != null;
    }
    Camel.isCamelPattern = isCamelPattern;
    /**
     * Looks up the Camel language settings for the given language name
     * @method
     */
    function camelLanguageSettings(nodeName) {
        return Camel._apacheCamelModel.languages[nodeName];
    }
    Camel.camelLanguageSettings = camelLanguageSettings;
    function isCamelLanguage(nodeName) {
        return (camelLanguageSettings(nodeName) || nodeName === "expression") ? true : false;
    }
    Camel.isCamelLanguage = isCamelLanguage;
    /**
     * Adds the route children to the given folder for each step in the route
     * @method
     */
    function loadRouteChildren(folder, route, workspace) {
        folder['routeXmlNode'] = route;
        route.setAttribute('_cid', folder.key);
        var children = [];
        $(route).children('*').each(function (idx, node) {
            children.push(loadRouteChild(folder, node, workspace));
        });
        workspace.$rootScope.$broadcast('routeXmlNode', route);
        return _.compact(children);
    }
    Camel.loadRouteChildren = loadRouteChildren;
    /**
     * Adds a child to the given folder / route
     * @method
     */
    function loadRouteChild(parent, route, workspace) {
        var nodeName = route.localName;
        var nodeSettings = getCamelSchema(nodeName);
        if (nodeSettings) {
            var imageUrl = getRouteNodeIcon(nodeSettings);
            var node = new Jmx.Folder(nodeName);
            node.domain = Camel.jmxDomain;
            node.typeName = 'routeNode';
            updateRouteNodeLabelAndTooltip(node, route, nodeSettings);
            // TODO should maybe auto-generate these?
            node.folderNames = parent.folderNames;
            var id = route.getAttribute('id') || nodeName;
            var key = parent.key + '_' + Core.toSafeDomID(id);
            // lets find the next key thats unique
            var counter = 1;
            var notFound = true;
            while (notFound) {
                var tmpKey = key + counter;
                if (_.find(parent.children, { key: tmpKey })) {
                    counter += 1;
                }
                else {
                    notFound = false;
                    key = tmpKey;
                }
            }
            node.key = key;
            node.image = imageUrl;
            node['routeXmlNode'] = route;
            var children = loadRouteChildren(node, route, workspace);
            children.forEach(function (child) { return node.moveChild(child); });
            return node;
        }
    }
    /**
     * Returns the root JMX Folder of the camel mbeans
     */
    function getRootCamelFolder(workspace) {
        var tree = workspace ? workspace.tree : null;
        if (tree) {
            return tree.get(Camel.jmxDomain);
        }
        return null;
    }
    Camel.getRootCamelFolder = getRootCamelFolder;
    /**
     * Returns the JMX folder for the camel context
     */
    function getCamelContextFolder(workspace, camelContextId) {
        var answer = null;
        var root = getRootCamelFolder(workspace);
        if (root && camelContextId) {
            return root.findDescendant(function (node) { return camelContextId === node.text; });
        }
        return answer;
    }
    Camel.getCamelContextFolder = getCamelContextFolder;
    /**
     * Returns the mbean for the given camel context ID or null if it cannot be found
     */
    function getCamelContextMBean(workspace, camelContextId) {
        var contextsFolder = getCamelContextFolder(workspace, camelContextId);
        if (contextsFolder) {
            return contextsFolder.objectName;
        }
        return null;
    }
    Camel.getCamelContextMBean = getCamelContextMBean;
    function getFolderCamelNodeId(folder) {
        var answer = Core.pathGet(folder, ["routeXmlNode", "localName"]);
        return ("from" === answer || "to" === answer) ? "endpoint" : answer;
    }
    Camel.getFolderCamelNodeId = getFolderCamelNodeId;
    /**
     * Rebuilds the DOM tree from the tree node and performs all the various hacks
     * to turn the folder / JSON / model into valid camel XML
     * such as renaming language elements from <language expression="foo" language="bar/>
     * to <bar>foo</bar>
     * and changing <endpoint> into either <from> or <to>
     * @method
     * @param treeNode is either the Node from the tree widget (with the real Folder in the data property) or a Folder
     */
    function createFolderXmlTree(treeNode, xmlNode, indent) {
        if (indent === void 0) { indent = Camel.increaseIndent(""); }
        var folder = treeNode.data || treeNode;
        var count = 0;
        var parentName = getFolderCamelNodeId(folder);
        if (folder) {
            if (!xmlNode) {
                xmlNode = document.createElement(parentName);
                var rootJson = Camel.getRouteFolderJSON(folder);
                if (rootJson) {
                    Camel.setRouteNodeJSON(xmlNode, rootJson, indent);
                }
            }
            var doc = xmlNode.ownerDocument || document;
            var namespaceURI = xmlNode.namespaceURI;
            var from = parentName !== "route";
            var childIndent = Camel.increaseIndent(indent);
            angular.forEach(treeNode.children || treeNode.getChildren(), function (childTreeNode) {
                var childFolder = childTreeNode.data || childTreeNode;
                var name = Camel.getFolderCamelNodeId(childFolder);
                var json = Camel.getRouteFolderJSON(childFolder);
                if (name && json) {
                    var language = false;
                    if (name === "endpoint") {
                        if (from) {
                            name = "to";
                        }
                        else {
                            name = "from";
                            from = true;
                        }
                    }
                    if (name === "expression") {
                        var languageName = json["language"];
                        if (languageName) {
                            name = languageName;
                            language = true;
                        }
                    }
                    // lets create the XML
                    xmlNode.appendChild(doc.createTextNode("\n" + childIndent));
                    var newNode = doc.createElementNS(namespaceURI, name);
                    Camel.setRouteNodeJSON(newNode, json, childIndent);
                    xmlNode.appendChild(newNode);
                    count += 1;
                    createFolderXmlTree(childTreeNode, newNode, childIndent);
                }
            });
            if (count) {
                xmlNode.appendChild(doc.createTextNode("\n" + indent));
            }
        }
        return xmlNode;
    }
    Camel.createFolderXmlTree = createFolderXmlTree;
    function updateRouteNodeLabelAndTooltip(folder, routeXmlNode, nodeSettings) {
        var localName = routeXmlNode.localName;
        var id = routeXmlNode.getAttribute("id");
        var label = nodeSettings["title"] || localName;
        // lets use the ID for routes and other things we give an id
        var tooltip = nodeSettings["tooltip"] || nodeSettings["description"] || label;
        if (id) {
            label = id;
        }
        else {
            var uri = getRouteNodeUri(routeXmlNode);
            if (uri) {
                // Don't use from/to as it gets odd if you drag/drop and reorder
                // label += " " + uri;
                label = uri;
                var split = uri.split("?");
                if (split && split.length > 1) {
                    label = split[0];
                }
                tooltip += " " + uri;
            }
            else {
                var children = $(routeXmlNode).children("*");
                if (children && children.length) {
                    var child = children[0];
                    var childName = child.localName;
                    var expression = null;
                    if (Camel.isCamelLanguage(childName)) {
                        expression = child.textContent;
                        if (!expression) {
                            expression = child.getAttribute("expression");
                        }
                    }
                    if (expression) {
                        label += " " + expression;
                        tooltip += " " + childName + " expression";
                    }
                }
            }
        }
        folder.text = label;
        folder.tooltip = tooltip;
        return label;
    }
    Camel.updateRouteNodeLabelAndTooltip = updateRouteNodeLabelAndTooltip;
    /**
     * Returns the selected camel context object name for the given selection or null if it cannot be found
     * @method
     */
    function getSelectionCamelContextMBean(workspace) {
        var context = getSelectionCamelContext(workspace);
        if (context) {
            return context.objectName;
        }
        return null;
    }
    Camel.getSelectionCamelContextMBean = getSelectionCamelContextMBean;
    /**
     * Returns the selected camel context object name for the given selection or null if it cannot be found
     * @method
     */
    function getSelectionCamelContext(workspace) {
        if (workspace) {
            var contextId_1 = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain_1 = selection.domain;
                if (domain_1 && contextId_1) {
                    return tree.findDescendant(function (node) { return node.typeName === 'context'
                        && node.domain === domain_1
                        && node.text === contextId_1; });
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelContext = getSelectionCamelContext;
    /**
     * When lazy loading route info (using dumpRoutesAsXml() operation) we need MBean name from the folder
     * and *not* from the selection
     * @param {Workspace} workspace
     * @param {Folder} folder
     */
    function getExpandingFolderCamelContextMBean(workspace, folder) {
        if (folder.entries && folder.entries['type'] === 'routes') {
            var context = workspace.tree.findDescendant(function (node) { return node.typeName === 'context'
                && node.domain === 'org.apache.camel'
                && node.text === folder.entries['context']; });
            if (context) {
                return context.objectName;
            }
        }
        return null;
    }
    Camel.getExpandingFolderCamelContextMBean = getExpandingFolderCamelContextMBean;
    function getSelectionCamelContextEndpoints(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    return tree.navigate(domain, 'Camel Contexts', contextId, 'endpoints');
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelContextEndpoints = getSelectionCamelContextEndpoints;
    /**
     * Returns the selected camel trace mbean for the given selection or null if it cannot be found
     * @method
     */
    // TODO Should be a service
    function getSelectionCamelTraceMBean(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    // look for the Camel 2.11 mbean which we prefer
                    var result = tree.navigate(domain, 'Camel Contexts', contextId, 'MBeans', 'tracer');
                    if (result && result.children) {
                        var mbean = _.find(result.children, function (m) { return _.startsWith(m.text, 'BacklogTracer'); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelTraceMBean = getSelectionCamelTraceMBean;
    function getSelectionCamelDebugMBean(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, 'Camel Contexts', contextId, 'MBeans', 'tracer');
                    if (result && result.children) {
                        var mbean = _.find(result.children, function (m) { return _.startsWith(m.text, 'BacklogDebugger'); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelDebugMBean = getSelectionCamelDebugMBean;
    function getSelectionCamelTypeConverter(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, 'Camel Contexts', contextId, 'MBeans', 'services');
                    if (result && result.children) {
                        var mbean = _.find(result.children, function (m) { return _.endsWith(m.text, 'TypeConverter'); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelTypeConverter = getSelectionCamelTypeConverter;
    function getSelectionCamelRestRegistry(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, 'Camel Contexts', contextId, 'MBeans', 'services');
                    if (result && result.children) {
                        var mbean = _.find(result.children, function (m) { return _.startsWith(m.text, 'DefaultRestRegistry'); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelRestRegistry = getSelectionCamelRestRegistry;
    function getSelectionCamelEndpointRuntimeRegistry(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, 'Camel Contexts', contextId, 'MBeans', 'services');
                    if (result && result.children) {
                        var mbean = _.find(result.children, function (m) { return _.startsWith(m.text, 'DefaultRuntimeEndpointRegistry'); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelEndpointRuntimeRegistry = getSelectionCamelEndpointRuntimeRegistry;
    function getSelectionCamelInflightRepository(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, 'Camel Contexts', contextId, 'MBeans', 'services');
                    if (result && result.children) {
                        var mbean = _.find(result.children, function (m) { return _.startsWith(m.text, 'DefaultInflightRepository'); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelInflightRepository = getSelectionCamelInflightRepository;
    function getSelectionCamelBlockedExchanges(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, 'Camel Contexts', contextId, 'MBeans', 'services');
                    if (result && result.children) {
                        var mbean = _.find(result.children, function (m) { return _.startsWith(m.text, 'DefaultAsyncProcessorAwaitManager'); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelBlockedExchanges = getSelectionCamelBlockedExchanges;
    function getSelectionCamelRouteMetrics(workspace) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, 'Camel Contexts', contextId, 'MBeans', 'services');
                    if (result && result.children) {
                        var mbean = _.find(result.children, function (m) { return _.startsWith(m.text, 'MetricsRegistryService'); });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionCamelRouteMetrics = getSelectionCamelRouteMetrics;
    // TODO should be a service
    function getContextId(workspace) {
        var selection = workspace.selection;
        if (selection) {
            var context = selection.findAncestor(function (ancestor) { return ancestor.typeName === 'context'; });
            if (context) {
                return context.text;
            }
        }
    }
    Camel.getContextId = getContextId;
    function iconClass(state) {
        if (state) {
            switch (state.toLowerCase()) {
                case 'started':
                    return "green fa fa-play-circle";
                case 'suspended':
                    return "fa fa-pause";
            }
        }
        return "orange fa fa-off";
    }
    Camel.iconClass = iconClass;
    function getSelectedRouteId(workspace, folder) {
        var selection = folder || workspace.selection;
        var selectedRouteId = null;
        if (selection) {
            if (selection && selection.entries) {
                var typeName = selection.entries["type"];
                var name = selection.entries["name"];
                if ("routes" === typeName && name) {
                    selectedRouteId = Core.trimQuotes(name);
                }
            }
        }
        return selectedRouteId;
    }
    Camel.getSelectedRouteId = getSelectedRouteId;
    /**
     * Returns the selected camel route mbean for the given route id
     * @method
     */
    // TODO Should be a service
    function getSelectionRouteMBean(workspace, routeId) {
        if (workspace) {
            var contextId = getContextId(workspace);
            var selection = workspace.selection;
            var tree = workspace.tree;
            if (tree && selection) {
                var domain = selection.domain;
                if (domain && contextId) {
                    var result = tree.navigate(domain, 'Camel Contexts', contextId, 'routes');
                    if (result && result.children) {
                        var mbean = _.find(result.children, function (m) { return m.text === routeId; });
                        if (mbean) {
                            return mbean.objectName;
                        }
                    }
                }
            }
        }
        return null;
    }
    Camel.getSelectionRouteMBean = getSelectionRouteMBean;
    function getCamelVersion(workspace, jolokia) {
        var context = getSelectionCamelContext(workspace);
        if (context && context.parent != null) {
            if (context.version) {
                // return cached version
                return context.version;
            }
            else {
                // fetch version using onSuccess(null) to force synchronous call
                context.version = jolokia.getAttribute(context.objectName, 'CamelVersion', Core.onSuccess(null));
                return context.version;
            }
        }
        return null;
    }
    Camel.getCamelVersion = getCamelVersion;
    function createMessageFromXml(exchange) {
        var exchangeElement = $(exchange);
        var uid = exchangeElement.children("uid").text();
        var timestamp = exchangeElement.children("timestamp").text();
        var messageData = {
            headers: {},
            headerTypes: {},
            id: null,
            uid: uid,
            timestamp: timestamp,
            headerHtml: ""
        };
        var message = exchangeElement.children("message")[0];
        if (!message) {
            message = exchange;
        }
        var messageElement = $(message);
        var headers = messageElement.find("header");
        var headerHtml = "";
        headers.each(function (idx, header) {
            var key = header.getAttribute("key");
            var typeName = header.getAttribute("type");
            var value = header.textContent;
            if (key) {
                if (value)
                    messageData.headers[key] = value;
                if (typeName)
                    messageData.headerTypes[key] = typeName;
                headerHtml += "<tr><td class='property-name'>" + key + "</td>" +
                    "<td class='property-value'>" + (humanizeJavaType(typeName)) + "</td>" +
                    "<td class='property-value'>" + (value || "") + "</td></tr>";
            }
        });
        messageData.headerHtml = headerHtml;
        var id = messageData.headers["breadcrumbId"];
        if (!id) {
            var postFixes = ["MessageID", "ID", "Path", "Name"];
            angular.forEach(postFixes, function (postfix) {
                if (!id) {
                    angular.forEach(messageData.headers, function (value, key) {
                        if (!id && _.endsWith(key, postfix)) {
                            id = value;
                        }
                    });
                }
            });
            // lets find the first header with a name or Path in it
            // if still no value, lets use the first :)
            angular.forEach(messageData.headers, function (value, key) {
                if (!id)
                    id = value;
            });
        }
        messageData.id = id;
        var body = messageElement.children("body")[0];
        if (body) {
            var bodyText = body.textContent;
            var bodyType = body.getAttribute("type");
            messageData["body"] = bodyText;
            messageData["bodyType"] = humanizeJavaType(bodyType);
        }
        return messageData;
    }
    Camel.createMessageFromXml = createMessageFromXml;
    function humanizeJavaType(type) {
        if (!type) {
            return "";
        }
        // skip leading java.lang
        if (_.startsWith(type, "java.lang")) {
            return type.substr(10);
        }
        return type;
    }
    Camel.humanizeJavaType = humanizeJavaType;
    function createBrowseGridOptions() {
        return {
            selectedItems: [],
            data: 'messages',
            displayFooter: false,
            showFilter: false,
            showColumnMenu: true,
            enableColumnResize: true,
            enableColumnReordering: true,
            filterOptions: {
                filterText: ''
            },
            selectWithCheckboxOnly: true,
            showSelectionCheckbox: true,
            maintainColumnRatios: false,
            columnDefs: [
                {
                    field: 'id',
                    displayName: 'ID',
                    // for ng-grid
                    //width: '50%',
                    // for hawtio-datatable
                    // width: "22em",
                    cellTemplate: '<div class="ngCellText"><a href="" ng-click="row.entity.openMessageDialog(row)">{{row.entity.id}}</a></div>'
                }
            ]
        };
    }
    Camel.createBrowseGridOptions = createBrowseGridOptions;
    function loadRouteXmlNodes($scope, doc, selectedRouteId, nodes, links, width) {
        var allRoutes = $(doc).find("route");
        var routeDelta = width / allRoutes.length;
        var rowX = 0;
        allRoutes.each(function (idx, route) {
            var routeId = route.getAttribute("id");
            if (!selectedRouteId || !routeId || selectedRouteId === routeId) {
                Camel.addRouteXmlChildren($scope, route, nodes, links, null, rowX, 0);
                rowX += routeDelta;
            }
        });
    }
    Camel.loadRouteXmlNodes = loadRouteXmlNodes;
    function addRouteXmlChildren($scope, parent, nodes, links, parentId, parentX, parentY, parentNode) {
        if (parentNode === void 0) { parentNode = null; }
        var delta = 150;
        var x = parentX;
        var y = parentY + delta;
        var rid = parent.getAttribute("id");
        var siblingNodes = [];
        var parenNodeName = parent.localName;
        $(parent).children().each(function (idx, route) {
            var id = nodes.length;
            // from acts as a parent even though its a previous sibling :)
            var nodeId = route.localName;
            if (nodeId === "from" && !parentId) {
                parentId = id;
            }
            var nodeSettings = getCamelSchema(nodeId);
            var node = null;
            if (nodeSettings) {
                var label = nodeSettings["title"] || nodeId;
                var uri = getRouteNodeUri(route);
                if (uri) {
                    label += " " + uri.split("?")[0];
                }
                var tooltip = nodeSettings["tooltip"] || nodeSettings["description"] || label;
                if (uri) {
                    tooltip += " " + uri;
                }
                var elementID = route.getAttribute("id");
                var labelSummary = label;
                if (elementID) {
                    var customId = route.getAttribute("customId");
                    if ($scope.camelIgnoreIdForLabel || (!customId || customId === "false")) {
                        labelSummary = "id: " + elementID;
                    }
                    else {
                        label = elementID;
                    }
                }
                // lets check if we need to trim the label
                var labelLimit = $scope.camelMaximumLabelWidth || Camel.defaultMaximumLabelWidth;
                var length = label.length;
                if (length > labelLimit) {
                    labelSummary = label + "\n\n" + labelSummary;
                    label = label.substring(0, labelLimit) + "..";
                }
                var imageUrl = getRouteNodeIcon(nodeSettings);
                if ((nodeId === "from" || nodeId === "to") && uri) {
                    var uriIdx = uri.indexOf(":");
                    if (uriIdx > 0) {
                        var componentScheme = uri.substring(0, uriIdx);
                        if (componentScheme) {
                            var value = Camel.getEndpointIcon(componentScheme);
                            if (value) {
                                imageUrl = Core.url(value);
                            }
                        }
                    }
                }
                var cid = route.getAttribute("_cid") || route.getAttribute("id");
                node = { "name": name, "label": label, "labelSummary": labelSummary, "group": 1, "id": id, "elementId": elementID,
                    "x": x, "y:": y, "imageUrl": imageUrl, "cid": cid, "tooltip": tooltip, "type": nodeId, "uri": uri };
                if (rid) {
                    node["rid"] = rid;
                    if (!$scope.routeNodes)
                        $scope.routeNodes = {};
                    $scope.routeNodes[rid] = node;
                }
                if (!cid) {
                    cid = nodeId + (nodes.length + 1);
                }
                if (cid) {
                    node["cid"] = cid;
                    if (!$scope.nodes)
                        $scope.nodes = {};
                    $scope.nodes[cid] = node;
                }
                // only use the route id on the first from node
                rid = null;
                nodes.push(node);
                if (parentId !== null && parentId !== id) {
                    if (siblingNodes.length === 0 || parenNodeName === "choice") {
                        links.push({ "source": parentId, "target": id, "value": 1 });
                    }
                    else {
                        siblingNodes.forEach(function (nodeId) {
                            links.push({ "source": nodeId, "target": id, "value": 1 });
                        });
                        siblingNodes.length = 0;
                    }
                }
            }
            else {
                // ignore non EIP nodes, though we should add expressions...
                var langSettings = Camel.camelLanguageSettings(nodeId);
                if (langSettings && parentNode) {
                    // lets add the language kind
                    var name = langSettings["name"] || nodeId;
                    var text = route.textContent;
                    if (text) {
                        parentNode["tooltip"] = parentNode["label"] + " " + name + " " + text;
                        parentNode["label"] += ": " + appendLabel(route, text, true);
                    }
                    else {
                        parentNode["label"] += ": " + appendLabel(route, name, false);
                    }
                }
            }
            var siblings = addRouteXmlChildren($scope, route, nodes, links, id, x, y, node);
            if (parenNodeName === "choice") {
                siblingNodes = siblingNodes.concat(siblings);
                x += delta;
            }
            else if (nodeId === "choice") {
                siblingNodes = siblings;
                y += delta;
            }
            else {
                siblingNodes = [nodes.length - 1];
                y += delta;
            }
        });
        return siblingNodes;
    }
    Camel.addRouteXmlChildren = addRouteXmlChildren;
    function appendLabel(route, label, text) {
        switch (route.localName) {
            case "method":
                if (!text) {
                    if (route.getAttribute("bean")) {
                        label += " " + route.getAttribute("bean");
                    }
                    else if (route.getAttribute("ref")) {
                        label += " " + route.getAttribute("ref");
                    }
                    else if (route.getAttribute("beanType")) {
                        label += " " + route.getAttribute("beanType");
                    }
                }
                if (route.getAttribute("method")) {
                    label += " " + route.getAttribute("method");
                }
                break;
            default:
        }
        return label;
    }
    /**
     * Returns an object of all the CamelContext MBeans keyed by their id
     * @method
     */
    function camelContextMBeansById(workspace) {
        var answer = {};
        var tree = workspace.tree;
        if (tree) {
            var contexts = tree.navigate(Camel.jmxDomain, 'Camel Contexts');
            if (contexts) {
                angular.forEach(contexts.children, function (context) {
                    var id = Core.pathGet(context, ['entries', 'name']) || context.key;
                    if (id) {
                        answer[id] = context;
                    }
                });
            }
        }
        return answer;
    }
    Camel.camelContextMBeansById = camelContextMBeansById;
    /**
     * Returns an object of all the CamelContext MBeans keyed by the component name
     * @method
     */
    function camelContextMBeansByComponentName(workspace) {
        return camelContextMBeansByRouteOrComponentId(workspace, 'components');
    }
    Camel.camelContextMBeansByComponentName = camelContextMBeansByComponentName;
    /**
     * Returns an object of all the CamelContext MBeans keyed by the route ID
     * @method
     */
    function camelContextMBeansByRouteId(workspace) {
        return camelContextMBeansByRouteOrComponentId(workspace, 'routes');
    }
    Camel.camelContextMBeansByRouteId = camelContextMBeansByRouteId;
    function camelContextMBeansByRouteOrComponentId(workspace, componentsOrRoutes) {
        var answer = {};
        var tree = workspace.tree;
        if (tree) {
            var contexts = tree.navigate(Camel.jmxDomain, 'Camel Contexts');
            if (contexts) {
                angular.forEach(contexts.children, function (context) {
                    var components = context.navigate(componentsOrRoutes);
                    if (context && components && context.children && context.children.length) {
                        var mbean = context.objectName;
                        if (mbean) {
                            var contextValues_1 = {
                                folder: context,
                                mbean: mbean
                            };
                            angular.forEach(components.children, function (componentFolder) {
                                var id = componentFolder.text;
                                if (id) {
                                    answer[id] = contextValues_1;
                                }
                            });
                        }
                    }
                });
            }
        }
        return answer;
    }
    /**
     * Returns true if we should ignore ID values for labels in camel diagrams
     * @method
     */
    function ignoreIdForLabel(localStorage) {
        var value = localStorage["camelIgnoreIdForLabel"];
        return Core.parseBooleanValue(value);
    }
    Camel.ignoreIdForLabel = ignoreIdForLabel;
    /**
     * Returns the maximum width of a label before we start to truncate
     * @method
     */
    function maximumLabelWidth(localStorage) {
        var value = localStorage["camelMaximumLabelWidth"];
        if (angular.isString(value)) {
            value = parseInt(value);
        }
        if (!value) {
            value = Camel.defaultMaximumLabelWidth;
        }
        return value;
    }
    Camel.maximumLabelWidth = maximumLabelWidth;
    /**
     * Returns the max body length for tracer and debugger
     * @method
     */
    function maximumTraceOrDebugBodyLength(localStorage) {
        var value = localStorage["camelMaximumTraceOrDebugBodyLength"];
        if (angular.isString(value)) {
            value = parseInt(value);
        }
        if (!value) {
            value = Camel.defaultCamelMaximumTraceOrDebugBodyLength;
        }
        return value;
    }
    Camel.maximumTraceOrDebugBodyLength = maximumTraceOrDebugBodyLength;
    /**
     * Returns whether to include streams body for tracer and debugger
     * @method
     */
    function traceOrDebugIncludeStreams(localStorage) {
        var value = localStorage["camelTraceOrDebugIncludeStreams"];
        return Core.parseBooleanValue(value, Camel.defaultCamelTraceOrDebugIncludeStreams);
    }
    Camel.traceOrDebugIncludeStreams = traceOrDebugIncludeStreams;
    /**
     * Returns true if we should show inflight counter in Camel route diagram
     * @method
     */
    function showInflightCounter(localStorage) {
        var value = localStorage["camelShowInflightCounter"];
        // is default enabled
        return Core.parseBooleanValue(value, true);
    }
    Camel.showInflightCounter = showInflightCounter;
    /**
     * Returns the max value for seconds in the route metrics UI
     * @method
     */
    function routeMetricMaxSeconds(localStorage) {
        var value = localStorage["camelRouteMetricMaxSeconds"];
        if (angular.isString(value)) {
            value = parseInt(value);
        }
        if (!value) {
            value = Camel.defaultCamelRouteMetricMaxSeconds;
        }
        return value;
    }
    Camel.routeMetricMaxSeconds = routeMetricMaxSeconds;
    /**
     * Whether to hide the documentation for the options
     * @method
     */
    function hideOptionDocumentation(localStorage) {
        var value = localStorage["camelHideOptionDocumentation"];
        return Core.parseBooleanValue(value, Camel.defaultHideOptionDocumentation);
    }
    Camel.hideOptionDocumentation = hideOptionDocumentation;
    /**
     * Whether to hide options which uses default values
     * @method
     */
    function hideOptionDefaultValue(localStorage) {
        var value = localStorage["camelHideOptionDefaultValue"];
        return Core.parseBooleanValue(value, Camel.defaultHideOptionDefaultValue);
    }
    Camel.hideOptionDefaultValue = hideOptionDefaultValue;
    /**
     * Whether to hide options which have unused/empty values
     * @method
     */
    function hideOptionUnusedValue(localStorage) {
        var value = localStorage["camelHideOptionUnusedValue"];
        return Core.parseBooleanValue(value, Camel.defaultHideOptionUnusedValue);
    }
    Camel.hideOptionUnusedValue = hideOptionUnusedValue;
    /**
     * Function to highlight the selected toNode in the nodes graph
     *
     * @param nodes the nodes
     * @param toNode the node to highlight
     */
    function highlightSelectedNode(nodes, toNode) {
        // lets clear the selected node first
        nodes.classed("selected", false);
        nodes.filter(function (item) {
            if (item) {
                var cid = item["cid"];
                var rid = item["rid"];
                var type = item["type"];
                var elementId = item["elementId"];
                // if its from then match on rid
                if ("from" === type) {
                    return toNode === rid;
                }
                // okay favor using element id as the cids can become
                // undefined or mangled with mbean object names, causing this to not work
                // where as elementId when present works fine
                if (elementId) {
                    // we should match elementId if defined
                    return toNode === elementId;
                }
                // then fallback to cid
                if (cid) {
                    return toNode === cid;
                }
                else {
                    // and last rid
                    return toNode === rid;
                }
            }
            return null;
        }).classed("selected", true);
    }
    Camel.highlightSelectedNode = highlightSelectedNode;
    /**
     * Is the currently selected Camel version equal or greater than
     *
     * @param major   major version as number
     * @param minor   minor version as number
     */
    function isCamelVersionEQGT(major, minor, workspace, jolokia) {
        var camelVersion = getCamelVersion(workspace, jolokia);
        if (camelVersion) {
            camelVersion += "camel-";
            var numbers = Core.parseVersionNumbers(camelVersion);
            if (Core.compareVersionNumberArrays(numbers, [major, minor]) >= 0) {
                return true;
            }
            else {
                return false;
            }
        }
        return false;
    }
    Camel.isCamelVersionEQGT = isCamelVersionEQGT;
    /**
     * Determines whether the endpoint supports browse operations
     * @param endpoint The selected endpoint JMX tree node
     */
    function isBrowsableEndpoint(endpoint) {
        if (endpoint && endpoint['mbean']) {
            var mbean = endpoint['mbean'];
            if (mbean['op']) {
                return mbean['op']['browseAllMessagesAsXml'] != null;
            }
        }
        return false;
    }
    Camel.isBrowsableEndpoint = isBrowsableEndpoint;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var CamelTreeService = /** @class */ (function () {
        CamelTreeService.$inject = ["treeService"];
        function CamelTreeService(treeService) {
            'ngInject';
            this.treeService = treeService;
        }
        CamelTreeService.prototype.getSelectedRouteId = function () {
            return this.treeService.getSelectedMBean()
                .then(function (mbean) { return mbean.entries.type === 'routes' ? Core.trimQuotes(mbean.entries.name) : null; });
        };
        return CamelTreeService;
    }());
    Camel.CamelTreeService = CamelTreeService;
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    var CamelNavigationService = /** @class */ (function () {
        CamelNavigationService.$inject = ["workspace", "jolokia"];
        function CamelNavigationService(workspace, jolokia) {
            'ngInject';
            this.workspace = workspace;
            this.jolokia = jolokia;
        }
        CamelNavigationService.prototype.getTabs = function () {
            var tabs = [];
            var isCamelContext = this.workspace.isCamelContext();
            var isCamelVersionEQGT_2_13 = Camel.isCamelVersionEQGT(2, 13, this.workspace, this.jolokia);
            var isCamelVersionEQGT_2_14 = Camel.isCamelVersionEQGT(2, 14, this.workspace, this.jolokia);
            var isCamelVersionEQGT_2_15 = Camel.isCamelVersionEQGT(2, 15, this.workspace, this.jolokia);
            var isCamelVersionEQGT_2_16 = Camel.isCamelVersionEQGT(2, 16, this.workspace, this.jolokia);
            var isComponent = this.workspace.isComponent();
            var isComponentsFolder = this.workspace.isComponentsFolder();
            var isContextsFolder = this.workspace.selection && this.workspace.selection.key === 'camelContexts';
            var isEndpoint = this.workspace.isEndpoint();
            var isEndpointsFolder = this.workspace.isEndpointsFolder();
            var inEndpointRuntimeRegistry = Camel.getSelectionCamelEndpointRuntimeRegistry(this.workspace) !== null;
            var isDataformat = this.workspace.isDataformat();
            var isDebugMbean = Camel.getSelectionCamelDebugMBean(this.workspace) !== null;
            var isRestRegistry = Camel.getSelectionCamelRestRegistry(this.workspace) !== null;
            var isRoute = this.workspace.isRoute();
            var isRoutesFolder = this.workspace.isRoutesFolder();
            var isRouteMetrics = Camel.getSelectionCamelRouteMetrics(this.workspace) !== null;
            var isTraceMBean = Camel.getSelectionCamelTraceMBean(this.workspace) !== null;
            var canBrowse = this.workspace.hasInvokeRightsForName(Camel.getSelectionCamelInflightRepository(this.workspace), "browse");
            var canBrowseAllMessagesAsXml = this.workspace.hasInvokeRights(this.workspace.selection, "browseAllMessagesAsXml");
            var canDumpRoutesAsXml = this.workspace.hasInvokeRightsForName(Camel.getSelectionCamelContextMBean(this.workspace), "dumpRoutesAsXml");
            var canExplainEndpointJson = this.workspace.hasInvokeRights(this.workspace.selection, "explainEndpointJson");
            var canExplainComponentJson = this.workspace.hasInvokeRights(this.workspace.selection, "explainComponentJson");
            var canExplainDataFormatJson = this.workspace.hasInvokeRights(this.workspace.selection, "explainDataFormatJson");
            var canDumpAllTracedMessagesAsXml = this.workspace.hasInvokeRightsForName(Camel.getSelectionCamelTraceMBean(this.workspace), "dumpAllTracedMessagesAsXml");
            var canDumpStatisticsAsJson = this.workspace.hasInvokeRightsForName(Camel.getSelectionCamelRouteMetrics(this.workspace), "dumpStatisticsAsJson");
            var canGetBreakpoints = this.workspace.hasInvokeRightsForName(Camel.getSelectionCamelDebugMBean(this.workspace), "getBreakpoints");
            var canListRestServices = this.workspace.hasInvokeRightsForName(Camel.getSelectionCamelRestRegistry(this.workspace), "listRestServices");
            var canListTypeConverters = this.workspace.hasInvokeRightsForName(Camel.getSelectionCamelTypeConverter(this.workspace), "listTypeConverters");
            var canSeeEndpointStatistics = this.workspace.hasInvokeRightsForName(Camel.getSelectionCamelEndpointRuntimeRegistry(this.workspace), "endpointStatistics");
            var canSendMesssage = this.workspace.hasInvokeRights(this.workspace.selection, this.workspace.selection && this.workspace.selection.domain === "org.apache.camel" ? "sendBodyAndHeaders" : "sendTextMessage");
            if (!isContextsFolder && !isRoutesFolder && !Camel.isRouteNode(this.workspace)) {
                tabs.push(new Nav.HawtioTab('Attributes', '/camel/attributes'));
            }
            if (isContextsFolder) {
                tabs.push(new Nav.HawtioTab('Contexts', '/camel/contexts'));
            }
            if (isRoutesFolder) {
                tabs.push(new Nav.HawtioTab('Routes', '/camel/routes'));
            }
            if ((isRoute || isRoutesFolder) && canDumpRoutesAsXml) {
                tabs.push(new Nav.HawtioTab('Route Diagram', '/camel/routeDiagram'));
            }
            if (!isEndpoint && !isEndpointsFolder && (isRoute || isRoutesFolder) && canDumpRoutesAsXml) {
                tabs.push(new Nav.HawtioTab('Source', '/camel/source'));
            }
            if (isRoute || Camel.isRouteNode(this.workspace)) {
                tabs.push(new Nav.HawtioTab('Properties', '/camel/propertiesRoute'));
            }
            if (isEndpoint && isCamelVersionEQGT_2_15 && canExplainEndpointJson) {
                tabs.push(new Nav.HawtioTab('Properties', '/camel/propertiesEndpoint'));
            }
            if (isComponent && isCamelVersionEQGT_2_15 && canExplainComponentJson) {
                tabs.push(new Nav.HawtioTab('Properties', '/camel/propertiesComponent'));
            }
            if (isDataformat && isCamelVersionEQGT_2_16 && canExplainDataFormatJson) {
                tabs.push(new Nav.HawtioTab('Properties', '/camel/propertiesDataFormat'));
            }
            if (!isEndpointsFolder && !isEndpoint && !isComponentsFolder &&
                !isComponent && (isCamelContext || isRoutesFolder || isRoute) &&
                isCamelVersionEQGT_2_15 && canBrowse) {
                tabs.push(new Nav.HawtioTab('Exchanges', '/camel/exchanges'));
            }
            if (!isEndpointsFolder && !isEndpoint && (isCamelContext || isRoutesFolder) &&
                isCamelVersionEQGT_2_14 && isRouteMetrics && canDumpStatisticsAsJson) {
                tabs.push(new Nav.HawtioTab('Route Metrics', '/camel/routeMetrics'));
            }
            if (!isRoute && !Camel.isRouteNode(this.workspace) && !isEndpointsFolder && !isEndpoint && !isComponentsFolder && !isComponent &&
                (isCamelContext || isRoutesFolder) && isCamelVersionEQGT_2_14 && isRestRegistry &&
                Camel.hasRestServices(this.workspace, this.jolokia) && canListRestServices) {
                tabs.push(new Nav.HawtioTab('REST Services', '/camel/restServices'));
            }
            if (!isEndpointsFolder && !isEndpoint && !isComponentsFolder && !isComponent &&
                (isCamelContext || isRoutesFolder) && isCamelVersionEQGT_2_16 && inEndpointRuntimeRegistry &&
                canSeeEndpointStatistics) {
                tabs.push(new Nav.HawtioTab('Endpoints (in/out)', '/camel/endpoints-statistics'));
            }
            if (!isRoute && !Camel.isRouteNode(this.workspace) && !isEndpointsFolder && !isEndpoint && !isComponentsFolder && !isComponent &&
                (isCamelContext || isRoutesFolder) && isCamelVersionEQGT_2_13 && canListTypeConverters) {
                tabs.push(new Nav.HawtioTab('Type Converters', '/camel/typeConverter'));
            }
            if (isRoute && isTraceMBean && canDumpAllTracedMessagesAsXml) {
                tabs.push(new Nav.HawtioTab('Profile', '/camel/profileRoute'));
            }
            if (isRoute && isDebugMbean && canGetBreakpoints) {
                tabs.push(new Nav.HawtioTab('Debug', '/camel/debugRoute'));
            }
            if (isRoute && isTraceMBean && canDumpAllTracedMessagesAsXml) {
                tabs.push(new Nav.HawtioTab('Trace', '/camel/traceRoute'));
            }
            if (isEndpoint && Camel.isBrowsableEndpoint(this.workspace.selection) && canBrowseAllMessagesAsXml) {
                tabs.push(new Nav.HawtioTab('Browse', '/camel/browseEndpoint'));
            }
            if (isEndpoint && canSendMesssage) {
                tabs.push(new Nav.HawtioTab('Send', '/camel/sendMessage'));
            }
            if (isEndpointsFolder) {
                tabs.push(new Nav.HawtioTab('Endpoints', '/camel/endpoints'));
            }
            if (!isContextsFolder && !isRoutesFolder && !Camel.isRouteNode(this.workspace)) {
                tabs.push(new Nav.HawtioTab('Operations', '/camel/operations'));
            }
            if (!isContextsFolder && !isRoutesFolder && !Camel.isRouteNode(this.workspace)) {
                tabs.push(new Nav.HawtioTab('Chart', '/camel/charts'));
            }
            return tabs;
        };
        return CamelNavigationService;
    }());
    Camel.CamelNavigationService = CamelNavigationService;
})(Camel || (Camel = {}));
/// <reference path="camel-navigation.service.ts"/>
var Camel;
(function (Camel) {
    var CamelNavigationController = /** @class */ (function () {
        CamelNavigationController.$inject = ["$scope", "$location", "camelNavigationService", "workspace"];
        function CamelNavigationController($scope, $location, camelNavigationService, workspace) {
            'ngInject';
            var _this = this;
            this.$location = $location;
            this.camelNavigationService = camelNavigationService;
            this.workspace = workspace;
            $scope.$on('jmxTreeClicked', function () {
                _this.tabs = camelNavigationService.getTabs();
            });
        }
        CamelNavigationController.prototype.$onInit = function () {
            this.tabs = this.camelNavigationService.getTabs();
        };
        CamelNavigationController.prototype.goto = function (tab) {
            this.$location.path(tab.path);
        };
        return CamelNavigationController;
    }());
    Camel.CamelNavigationController = CamelNavigationController;
    Camel.camelNavigationComponent = {
        template: '<hawtio-tabs tabs="$ctrl.tabs" on-change="$ctrl.goto(tab)"></hawtio-tabs>',
        controller: CamelNavigationController
    };
})(Camel || (Camel = {}));
var Camel;
(function (Camel) {
    Camel.camelComponent = {
        template: "\n      <div class=\"tree-nav-layout\">\n        <div class=\"sidebar-pf sidebar-pf-left\" resizable r-directions=\"['right']\">\n          <camel-tree-header></camel-tree-header>\n          <camel-tree></camel-tree>\n        </div>\n        <div class=\"tree-nav-main\">\n          <div>\n            <context-actions></context-actions>\n            <route-actions></route-actions>\n            <jmx-header></jmx-header>\n          </div>\n          <camel-navigation></camel-navigation>\n          <div class=\"contents\" ng-view></div>\n        </div>\n      </div>\n    "
    };
})(Camel || (Camel = {}));
/// <reference path="contexts/contexts.module.ts"/>
/// <reference path="endpoints-statistics/endpoints-statistics.module.ts"/>
/// <reference path="endpoints/endpoints.module.ts"/>
/// <reference path="exchanges/exchanges.module.ts"/>
/// <reference path="properties/properties.module.ts"/>
/// <reference path="rest-services/rest-services.module.ts"/>
/// <reference path="routes/routes.module.ts"/>
/// <reference path="tree/tree.module.ts"/>
/// <reference path="type-converters/type-converters.module.ts"/>
/// <reference path="camelHelpers.ts"/>
/// <reference path="camel-tree.service.ts"/>
/// <reference path="camel-navigation.component.ts"/>
/// <reference path="camel-navigation.service.ts"/>
/// <reference path="camel.component.ts"/>
var Camel;
(function (Camel) {
    Camel._module = angular.module(Camel.pluginName, [
        'angularResizable',
        Camel.contextsModule,
        Camel.endpointsStatisticsModule,
        Camel.endpointsModule,
        Camel.exchangesModule,
        Camel.propertiesModule,
        Camel.restServicesModule,
        Camel.routesModule,
        Camel.treeModule,
        Camel.typeConvertersModule
    ])
        .component('camel', Camel.camelComponent)
        .component('camelNavigation', Camel.camelNavigationComponent)
        .service('camelTreeService', Camel.CamelTreeService)
        .service('camelNavigationService', Camel.CamelNavigationService);
    Camel._module.config(["$routeProvider", function ($routeProvider) {
            $routeProvider
                .when('/camel/attributes', { templateUrl: 'plugins/jmx/html/attributes/attributes.html' })
                .when('/camel/operations', { template: '<operations></operations>' })
                .when('/camel/charts', { templateUrl: 'plugins/jmx/html/charts.html' })
                .when('/camel/charts/edit', { templateUrl: 'plugins/jmx/html/chartEdit.html' })
                .when('/camel/contexts', { template: '<contexts></contexts>' })
                .when('/camel/routes', { template: '<routes></routes>' })
                .when('/camel/endpoints', { template: '<endpoints></endpoints>' })
                .when('/camel/browseEndpoint', { templateUrl: 'plugins/camel/html/browseEndpoint.html' })
                .when('/camel/endpoint/browse/:contextId/*endpointPath', { templateUrl: 'plugins/camel/html/browseEndpoint.html' })
                .when('/camel/createEndpoint', { templateUrl: 'plugins/camel/html/createEndpoint.html' })
                .when('/camel/route/diagram/:contextId/:routeId', { templateUrl: 'plugins/camel/html/routeDiagram.html' })
                .when('/camel/routeDiagram', { templateUrl: 'plugins/camel/html/routeDiagram.html' })
                .when('/camel/source', { templateUrl: 'plugins/camel/html/source.html' })
                .when('/camel/typeConverter', { template: '<type-converters></type-converters>' })
                .when('/camel/restServices', { template: '<rest-services></rest-services>' })
                .when('/camel/endpoints-statistics', { template: '<endpoints-statistics></endpoints-statistics>' })
                .when('/camel/routeMetrics', { templateUrl: 'plugins/camel/html/routeMetrics.html', reloadOnSearch: false })
                .when('/camel/exchanges', { template: '<exchanges></exchanges>' })
                .when('/camel/sendMessage', { templateUrl: 'plugins/camel/html/sendMessage.html', reloadOnSearch: false })
                .when('/camel/traceRoute', { templateUrl: 'plugins/camel/html/traceRoute.html' })
                .when('/camel/debugRoute', { templateUrl: 'plugins/camel/html/debug.html' })
                .when('/camel/profileRoute', { templateUrl: 'plugins/camel/html/profileRoute.html' })
                .when('/camel/propertiesRoute', { templateUrl: 'plugins/camel/html/propertiesRoute.html' })
                .when('/camel/propertiesComponent', { templateUrl: 'plugins/camel/html/propertiesComponent.html' })
                .when('/camel/propertiesDataFormat', { templateUrl: 'plugins/camel/html/propertiesDataFormat.html' })
                .when('/camel/propertiesEndpoint', { templateUrl: 'plugins/camel/html/propertiesEndpoint.html' });
        }]);
    Camel._module.factory('tracerStatus', function () {
        return {
            messages: []
        };
    });
    Camel._module.filter('camelIconClass', function () { return Camel.iconClass; });
    Camel._module.factory('activeMQMessage', function () {
        return { 'message': null };
    });
    // service for the codehale metrics
    Camel._module.factory('metricsWatcher', ["$window", function ($window) {
            var answer = $window.metricsWatcher;
            if (!answer) {
                // lets avoid any NPEs
                answer = {};
                $window.metricsWatcher = answer;
            }
            return answer;
        }]);
    Camel._module.run(["mainNavService", "workspace", "jolokia", "helpRegistry", "preferencesRegistry", "$rootScope", function (mainNavService, workspace, jolokia, helpRegistry, preferencesRegistry, $rootScope) {
            helpRegistry.addUserDoc('camel', 'plugins/camel/doc/help.md', function () {
                return workspace.treeContainsDomainAndProperties(Camel.jmxDomain);
            });
            preferencesRegistry.addTab('Camel', 'plugins/camel/html/preferences.html', function () {
                return workspace.treeContainsDomainAndProperties(Camel.jmxDomain);
            });
            mainNavService.addItem({
                title: 'Camel',
                basePath: '/camel',
                template: '<camel></camel>',
                isValid: function () { return workspace.treeContainsDomainAndProperties(Camel.jmxDomain); }
            });
            // register default attribute views
            var stateField = 'State';
            var stateTemplate = '<div class="ngCellText pagination-centered" title="{{row.getProperty(col.field)}}"><i class="{{row.getProperty(\'' + stateField + '\') | camelIconClass}}"></i></div>';
            var stateColumn = {
                field: stateField, displayName: stateField,
                cellTemplate: stateTemplate,
                width: 56,
                minWidth: 56,
                maxWidth: 56,
                resizable: false,
                defaultSort: false
                // we do not want to default sort the state column
            };
            var attributes = workspace.attributeColumnDefs;
            attributes[Camel.jmxDomain + "/context/folder"] = [
                stateColumn,
                { field: 'CamelId', displayName: 'Context' },
                { field: 'Uptime', displayName: 'Uptime', visible: false },
                { field: 'CamelVersion', displayName: 'Version', visible: false },
                { field: 'ExchangesCompleted', displayName: 'Completed' },
                { field: 'ExchangesFailed', displayName: 'Failed' },
                { field: 'FailuresHandled', displayName: 'Failed Handled', visible: false },
                { field: 'ExchangesTotal', displayName: 'Total', visible: false },
                { field: 'Redeliveries', displayName: 'Redelivery', visible: false },
                { field: 'ExchangesInflight', displayName: 'Inflight' },
                { field: 'OldestInflightDuration', displayName: 'Oldest Inflight Time', visible: false },
                { field: 'MeanProcessingTime', displayName: 'Mean Time' },
                { field: 'MinProcessingTime', displayName: 'Min Time' },
                { field: 'MaxProcessingTime', displayName: 'Max Time' },
                { field: 'TotalProcessingTime', displayName: 'Total Time', visible: false },
                { field: 'DeltaProcessingTime', displayName: 'Delta Time', visible: false },
                { field: 'LastProcessingTime', displayName: 'Last Time', visible: false },
                { field: 'LastExchangeCompletedTimestamp', displayName: 'Last completed', visible: false },
                { field: 'LastExchangeFailedTimestamp', displayName: 'Last failed', visible: false },
                { field: 'ExternalRedeliveries', displayName: 'External Redelivery', visible: false },
                { field: 'StartedRoutes', displayName: 'Started Routes' },
                { field: 'TotalRoutes', displayName: 'Total Routes' }
            ];
            attributes[Camel.jmxDomain + "/routes/folder"] = [
                stateColumn,
                { field: 'CamelId', displayName: 'Context' },
                { field: 'RouteId', displayName: 'Route' },
                { field: 'ExchangesCompleted', displayName: 'Completed' },
                { field: 'ExchangesFailed', displayName: 'Failed' },
                { field: 'FailuresHandled', displayName: 'Failed Handled', visible: false },
                { field: 'Redeliveries', displayName: 'Redelivery', visible: false },
                { field: 'ExchangesTotal', displayName: 'Total', visible: false },
                { field: 'ExchangesInflight', displayName: 'Inflight' },
                { field: 'OldestInflightDuration', displayName: 'Oldest Inflight Time', visible: false },
                { field: 'MeanProcessingTime', displayName: 'Mean Time' },
                { field: 'MinProcessingTime', displayName: 'Min Time' },
                { field: 'MaxProcessingTime', displayName: 'Max Time' },
                { field: 'TotalProcessingTime', displayName: 'Total Time', visible: false },
                { field: 'DeltaProcessingTime', displayName: 'Delta Time', visible: false },
                { field: 'LastProcessingTime', displayName: 'Last Time', visible: false },
                { field: 'LastExchangeCompletedTimestamp', displayName: 'Last completed', visible: false },
                { field: 'LastExchangeFailedTimestamp', displayName: 'Last failed', visible: false },
                { field: 'Redeliveries', displayName: 'Redelivery', visible: false },
                { field: 'ExternalRedeliveries', displayName: 'External Redelivery', visible: false }
            ];
            attributes[Camel.jmxDomain + "/processors/folder"] = [
                stateColumn,
                { field: 'CamelId', displayName: 'Context' },
                { field: 'RouteId', displayName: 'Route' },
                { field: 'ProcessorId', displayName: 'Processor' },
                { field: 'ExchangesCompleted', displayName: 'Completed' },
                { field: 'ExchangesFailed', displayName: 'Failed' },
                { field: 'FailuresHandled', displayName: 'Failed Handled', visible: false },
                { field: 'Redeliveries', displayName: 'Redelivery', visible: false },
                { field: 'ExchangesTotal', displayName: 'Total', visible: false },
                { field: 'ExchangesInflight', displayName: 'Inflight' },
                { field: 'OldestInflightDuration', displayName: 'Oldest Inflight Time', visible: false },
                { field: 'MeanProcessingTime', displayName: 'Mean Time' },
                { field: 'MinProcessingTime', displayName: 'Min Time' },
                { field: 'MaxProcessingTime', displayName: 'Max Time' },
                { field: 'TotalProcessingTime', displayName: 'Total Time', visible: false },
                { field: 'DeltaProcessingTime', displayName: 'Delta Time', visible: false },
                { field: 'LastProcessingTime', displayName: 'Last Time', visible: false },
                { field: 'LastExchangeCompletedTimestamp', displayName: 'Last completed', visible: false },
                { field: 'LastExchangeFailedTimestamp', displayName: 'Last failed', visible: false },
                { field: 'ExternalRedeliveries', displayName: 'External Redelivery', visible: false }
            ];
            attributes[Camel.jmxDomain + "/components/folder"] = [
                stateColumn,
                { field: 'CamelId', displayName: 'Context' },
                { field: 'ComponentName', displayName: 'Name' }
            ];
            attributes[Camel.jmxDomain + "/consumers/folder"] = [
                stateColumn,
                { field: 'CamelId', displayName: 'Context' },
                { field: 'RouteId', displayName: 'Route' },
                { field: 'EndpointUri', displayName: 'Endpoint URI', width: "**" },
                { field: 'Suspended', displayName: 'Suspended', resizable: false },
                { field: 'InflightExchanges', displayName: 'Inflight' }
            ];
            attributes[Camel.jmxDomain + "/producers/folder"] = [
                stateColumn,
                { field: 'CamelId', displayName: 'Context' },
                { field: 'RouteId', displayName: 'Route' },
                { field: 'EndpointUri', displayName: 'Endpoint URI', width: "**" },
                { field: 'Suspended', displayName: 'Suspended', resizable: false }
            ];
            attributes[Camel.jmxDomain + "/services/folder"] = [
                stateColumn,
                { field: 'CamelId', displayName: 'Context' },
                { field: 'RouteId', displayName: 'Route' },
                { field: 'Suspended', displayName: 'Suspended', resizable: false },
                { field: 'SupportsSuspended', displayName: 'Can Suspend', resizable: false }
            ];
            attributes[Camel.jmxDomain + "/endpoints/folder"] = [
                stateColumn,
                { field: 'CamelId', displayName: 'Context' },
                { field: 'EndpointUri', displayName: 'Endpoint URI', width: "***" },
                { field: 'Singleton', displayName: 'Singleton', resizable: false }
            ];
            attributes[Camel.jmxDomain + "/threadpools/folder"] = [
                { field: 'Id', displayName: 'Id', width: "**" },
                { field: 'ActiveCount', displayName: 'Active' },
                { field: 'PoolSize', displayName: 'Pool Size' },
                { field: 'CorePoolSize', displayName: 'Core Pool Size' },
                { field: 'TaskQueueSize', displayName: 'Task Queue Size' },
                { field: 'TaskCount', displayName: 'Task' },
                { field: 'CompletedTaskCount', displayName: 'Completed Task' }
            ];
            attributes[Camel.jmxDomain + "/errorhandlers/folder"] = [
                { field: 'CamelId', displayName: 'Context' },
                { field: 'DeadLetterChannel', displayName: 'Dead Letter' },
                { field: 'DeadLetterChannelEndpointUri', displayName: 'Endpoint URI', width: "**", resizable: true },
                { field: 'MaximumRedeliveries', displayName: 'Max Redeliveries' },
                { field: 'RedeliveryDelay', displayName: 'Redelivery Delay' },
                { field: 'MaximumRedeliveryDelay', displayName: 'Max Redeliveries Delay' }
            ];
            workspace.addNamedTreePostProcessor('camel', function (tree) {
                var domainName = Camel.jmxDomain;
                if (tree) {
                    var rootFolder_1 = new Jmx.Folder('Camel Contexts');
                    rootFolder_1.class = 'org-apache-camel-context-folder';
                    rootFolder_1.children = [];
                    rootFolder_1.typeName = 'context';
                    rootFolder_1.key = 'camelContexts';
                    rootFolder_1.domain = domainName;
                    var domain = tree.get(domainName);
                    if (domain) {
                        var children_1 = [];
                        angular.forEach(domain.children, function (child, key) {
                            var contextsFolder = child.get('context');
                            var routesNode = child.get('routes');
                            var endpointsNode = child.get('endpoints');
                            var componentsNode = child.get('components');
                            var dataFormatsNode = child.get('dataformats');
                            if (contextsFolder) {
                                var contextNode_1 = contextsFolder.children[0];
                                if (contextNode_1) {
                                    // fetch the camel version and add it to the tree here to avoid making a blocking call elsewhere
                                    jolokia.request({
                                        'type': 'read',
                                        'mbean': contextNode_1.objectName,
                                        'attribute': 'CamelVersion'
                                    }, Core.onSuccess(function (response) {
                                        contextNode_1.version = response.value;
                                        Core.$apply($rootScope);
                                    }));
                                    if (routesNode) {
                                        contextNode_1.moveChild(routesNode);
                                        routesNode.typeName = 'routes';
                                        routesNode.class = 'org-apache-camel-routes-folder';
                                        angular.forEach(routesNode.children, function (n) { return n.class = 'org-apache-camel-routes'; });
                                    }
                                    if (endpointsNode) {
                                        contextNode_1.moveChild(endpointsNode);
                                        endpointsNode.typeName = 'endpoints';
                                        endpointsNode.class = 'org-apache-camel-endpoints-folder';
                                        angular.forEach(endpointsNode.children, function (n) { return n.class = 'org-apache-camel-endpoints'; });
                                    }
                                    if (componentsNode) {
                                        contextNode_1.moveChild(componentsNode);
                                        componentsNode.typeName = 'components';
                                        componentsNode.class = 'org-apache-camel-components-folder';
                                        angular.forEach(componentsNode.children, function (n) { return n.class = 'org-apache-camel-components'; });
                                    }
                                    if (dataFormatsNode) {
                                        contextNode_1.moveChild(dataFormatsNode);
                                        dataFormatsNode.class = 'org-apache-camel-dataformats-folder';
                                        angular.forEach(dataFormatsNode.children, function (n) { return n.class = 'org-apache-camel-dataformats'; });
                                        dataFormatsNode.typeName = 'dataformats';
                                    }
                                    var jmxNode_1 = new Jmx.Folder('MBeans');
                                    workspace.configureFolder(jmxNode_1, domainName, 'org-apache-camel', _.clone(child.folderNames).concat('mbeans'), 'mbeans');
                                    // lets add all the entries which are not one context/routes/endpoints/components/dataformats as MBeans
                                    child.children
                                        .filter(function (child) { return !(child.text === 'context'
                                        || child.text === 'routes'
                                        || child.text === 'endpoints'
                                        || child.text === 'components'
                                        || child.text === 'dataformats'); })
                                        .forEach(function (child) { return jmxNode_1.moveChild(child); });
                                    if (jmxNode_1.children.length > 0) {
                                        jmxNode_1.sortChildren(false);
                                        contextNode_1.moveChild(jmxNode_1);
                                    }
                                    rootFolder_1.moveChild(contextNode_1);
                                }
                                children_1.push(child);
                            }
                        });
                        children_1.forEach(function (child) { return child.detach(); });
                        domain.children.splice(0, 0, rootFolder_1);
                    }
                }
            });
        }]);
    hawtioPluginLoader.addModule(Camel.pluginName);
    // register the jmx lazy loader here as it won't have been invoked in the run method
    hawtioPluginLoader.registerPreBootstrapTask(function (task) {
        Jmx.registerLazyLoadHandler(Camel.jmxDomain, function (folder) {
            if (Camel.jmxDomain === folder.domain && 'routes' === folder.typeName) {
                return function (workspace, parent, onComplete) {
                    if ('routes' === parent.typeName) {
                        Camel.processRouteXml(workspace, workspace.jolokia, parent, function (route) { return onComplete(route ?
                            Camel.loadRouteChildren(parent, route, workspace) :
                            new Array()); });
                    }
                    else {
                        onComplete(new Array());
                    }
                };
            }
            return null;
        });
        task();
    });
})(Camel || (Camel = {}));
var Karaf;
(function (Karaf) {
    Karaf.pluginName = 'hawtio-integration-karaf';
    Karaf.log = Logger.get(Karaf.pluginName);
    function setSelect(selection, group) {
        if (!angular.isDefined(selection)) {
            return group[0];
        }
        var answer = _.findIndex(group, function (item) { return item.id === selection.id; });
        if (answer !== -1) {
            return group[answer];
        }
        else {
            return group[0];
        }
    }
    Karaf.setSelect = setSelect;
    function installRepository(workspace, jolokia, uri, success, error) {
        Karaf.log.info("installing URI: ", uri);
        jolokia.request({
            type: 'exec', mbean: getSelectionFeaturesMBean(workspace),
            operation: 'addRepository(java.lang.String)',
            arguments: [uri]
        }, Core.onSuccess(success, { error: error }));
    }
    Karaf.installRepository = installRepository;
    function uninstallRepository(workspace, jolokia, uri, success, error) {
        Karaf.log.info("uninstalling URI: ", uri);
        jolokia.request({
            type: 'exec', mbean: getSelectionFeaturesMBean(workspace),
            operation: 'removeRepository(java.lang.String)',
            arguments: [uri]
        }, Core.onSuccess(success, { error: error }));
    }
    Karaf.uninstallRepository = uninstallRepository;
    function installFeature(workspace, jolokia, feature, version, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionFeaturesMBean(workspace),
            operation: 'installFeature(java.lang.String, java.lang.String)',
            arguments: [feature, version]
        }, Core.onSuccess(success, { error: error, ajaxError: success }));
    }
    Karaf.installFeature = installFeature;
    function uninstallFeature(workspace, jolokia, feature, version, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionFeaturesMBean(workspace),
            operation: 'uninstallFeature(java.lang.String, java.lang.String)',
            arguments: [feature, version]
        }, Core.onSuccess(success, { error: error, ajaxError: success }));
    }
    Karaf.uninstallFeature = uninstallFeature;
    // TODO move to core?
    function toCollection(values) {
        var collection = values;
        if (!angular.isArray(values)) {
            collection = [values];
        }
        return collection;
    }
    Karaf.toCollection = toCollection;
    function featureLinks(workspace, name, version) {
        return "<a href='" + Core.url("#/karaf/features/" + name + "/" + version + workspace.hash()) + "'>" + version + "</a>";
    }
    Karaf.featureLinks = featureLinks;
    function extractFeature(attributes, name, version) {
        var features = [];
        var repos = [];
        populateFeaturesAndRepos(attributes, features, repos);
        return _.find(features, function (feature) { return feature.Name == name && feature.Version == version; });
    }
    Karaf.extractFeature = extractFeature;
    var platformBundlePatterns = [
        "^org.apache.aries",
        "^org.apache.karaf",
        "^activemq-karaf",
        "^org.apache.commons",
        "^org.apache.felix",
        "^io.fabric8",
        "^io.fabric8.fab",
        "^io.fabric8.insight",
        "^io.fabric8.mq",
        "^io.fabric8.patch",
        "^io.fabric8.runtime",
        "^io.fabric8.security",
        "^org.apache.geronimo.specs",
        "^org.apache.servicemix.bundles",
        "^org.objectweb.asm",
        "^io.hawt",
        "^javax.mail",
        "^javax",
        "^org.jvnet",
        "^org.mvel2",
        "^org.apache.mina.core",
        "^org.apache.sshd.core",
        "^org.apache.neethi",
        "^org.apache.servicemix.specs",
        "^org.apache.xbean",
        "^org.apache.santuario.xmlsec",
        "^biz.aQute.bndlib",
        "^groovy-all",
        "^com.google.guava",
        "jackson-\\w+-asl",
        "^com.fasterxml.jackson",
        "^org.ops4j",
        "^org.springframework",
        "^bcprov$",
        "^jline$",
        "scala-library$",
        "^org.scala-lang",
        "^stax2-api$",
        "^woodstox-core-asl",
        "^org.jboss.amq.mq-fabric",
        "^gravia-",
        "^joda-time$",
        "^org.apache.ws",
        "-commands$",
        "patch.patch",
        "org.fusesource.insight",
        "activeio-core",
        "activemq-osgi",
        "^org.eclipse.jetty",
        "org.codehaus.jettison.jettison",
        "org.jledit.core",
        "org.fusesource.jansi",
        "org.eclipse.equinox.region"
    ];
    var platformBundleRegex = new RegExp(platformBundlePatterns.join('|'));
    var camelBundlePatterns = ["^org.apache.camel", "camel-karaf-commands$", "activemq-camel$"];
    var camelBundleRegex = new RegExp(camelBundlePatterns.join('|'));
    var cxfBundlePatterns = ["^org.apache.cxf"];
    var cxfBundleRegex = new RegExp(cxfBundlePatterns.join('|'));
    var activemqBundlePatterns = ["^org.apache.activemq", "activemq-camel$"];
    var activemqBundleRegex = new RegExp(activemqBundlePatterns.join('|'));
    function isPlatformBundle(symbolicName) {
        return platformBundleRegex.test(symbolicName);
    }
    Karaf.isPlatformBundle = isPlatformBundle;
    function isActiveMQBundle(symbolicName) {
        return activemqBundleRegex.test(symbolicName);
    }
    Karaf.isActiveMQBundle = isActiveMQBundle;
    function isCamelBundle(symbolicName) {
        return camelBundleRegex.test(symbolicName);
    }
    Karaf.isCamelBundle = isCamelBundle;
    function isCxfBundle(symbolicName) {
        return cxfBundleRegex.test(symbolicName);
    }
    Karaf.isCxfBundle = isCxfBundle;
    function populateFeaturesAndRepos(attributes, features, repositories) {
        var fullFeatures = attributes["Features"];
        angular.forEach(attributes["Repositories"], function (repo) {
            repositories.push({
                id: repo["Name"],
                uri: repo["Uri"]
            });
            if (!fullFeatures) {
                return;
            }
            angular.forEach(repo["Features"], function (feature) {
                angular.forEach(feature, function (entry) {
                    if (fullFeatures[entry['Name']] !== undefined) {
                        var f = _.cloneDeep(fullFeatures[entry['Name']][entry['Version']]);
                        f["Id"] = entry["Name"] + "/" + entry["Version"];
                        f["RepositoryName"] = repo["Name"];
                        f["RepositoryURI"] = repo["Uri"];
                        features.push(f);
                    }
                });
            });
        });
    }
    Karaf.populateFeaturesAndRepos = populateFeaturesAndRepos;
    function createScrComponentsView(workspace, jolokia, components) {
        var result = [];
        angular.forEach(components, function (component) {
            result.push({
                Name: component,
                State: getComponentStateDescription(getComponentState(workspace, jolokia, component))
            });
        });
        return result;
    }
    Karaf.createScrComponentsView = createScrComponentsView;
    function getComponentStateDescription(state) {
        switch (state) {
            case 2:
                return "Enabled";
            case 4:
                return "Unsatisfied";
            case 8:
                return "Activating";
            case 16:
                return "Active";
            case 32:
                return "Registered";
            case 64:
                return "Factory";
            case 128:
                return "Deactivating";
            case 256:
                return "Destroying";
            case 1024:
                return "Disabling";
            case 2048:
                return "Disposing";
        }
        return "Unknown";
    }
    Karaf.getComponentStateDescription = getComponentStateDescription;
    ;
    function getAllComponents(workspace, jolokia) {
        var scrMBean = getSelectionScrMBean(workspace);
        var response = jolokia.request({
            type: 'read', mbean: scrMBean,
            arguments: []
        });
        //Check if the MBean provides the Components attribute.
        if (!('Components' in response.value)) {
            response = jolokia.request({
                type: 'exec', mbean: scrMBean, operation: 'listComponents()'
            });
            return createScrComponentsView(workspace, jolokia, response.value);
        }
        return response.value['Components'].values;
    }
    Karaf.getAllComponents = getAllComponents;
    function getComponentByName(workspace, jolokia, componentName) {
        var components = getAllComponents(workspace, jolokia);
        return _.find(components, function (c) { return c.Name == componentName; });
    }
    Karaf.getComponentByName = getComponentByName;
    function isComponentActive(workspace, jolokia, component) {
        var response = jolokia.request({
            type: 'exec', mbean: getSelectionScrMBean(workspace),
            operation: 'isComponentActive(java.lang.String)',
            arguments: [component]
        });
        return response.value;
    }
    Karaf.isComponentActive = isComponentActive;
    function getComponentState(workspace, jolokia, component) {
        var response = jolokia.request({
            type: 'exec', mbean: getSelectionScrMBean(workspace),
            operation: 'componentState(java.lang.String)',
            arguments: [component]
        });
        return response.value;
    }
    Karaf.getComponentState = getComponentState;
    function activateComponent(workspace, jolokia, component, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionScrMBean(workspace),
            operation: 'activateComponent(java.lang.String)',
            arguments: [component]
        }, Core.onSuccess(success, { error: error }));
    }
    Karaf.activateComponent = activateComponent;
    function deactivateComponent(workspace, jolokia, component, success, error) {
        jolokia.request({
            type: 'exec', mbean: getSelectionScrMBean(workspace),
            operation: 'deactivateComponent(java.lang.String)',
            arguments: [component]
        }, Core.onSuccess(success, { error: error }));
    }
    Karaf.deactivateComponent = deactivateComponent;
    function populateDependencies(attributes, dependencies, features) {
        angular.forEach(dependencies, function (feature) {
            angular.forEach(feature, function (entry) {
                var enhancedFeature = extractFeature(attributes, entry["Name"], entry["Version"]);
                enhancedFeature["id"] = entry["Name"] + "/" + entry["Version"];
                //enhancedFeature["repository"] = repo["Name"];
                features.push(enhancedFeature);
            });
        });
    }
    Karaf.populateDependencies = populateDependencies;
    function getSelectionFeaturesMBean(workspace) {
        if (workspace) {
            var featuresStuff = workspace.mbeanTypesToDomain["features"] || workspace.mbeanTypesToDomain['feature'] || {};
            var karaf = featuresStuff["org.apache.karaf"] || {};
            var mbean = karaf.objectName;
            if (mbean) {
                return mbean;
            }
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("org.apache.karaf", "features");
            if (!folder) {
                // sometimes the features mbean is inside the 'root' folder
                folder = workspace.tree.navigate("org.apache.karaf");
                if (folder) {
                    var children = folder.children;
                    folder = null;
                    angular.forEach(children, function (child) {
                        if (!folder) {
                            folder = child.navigate("features");
                        }
                    });
                }
            }
            if (folder) {
                var children = folder.children;
                if (children) {
                    var node = children[0];
                    if (node) {
                        return node.objectName;
                    }
                }
                return folder.objectName;
            }
        }
        return null;
    }
    Karaf.getSelectionFeaturesMBean = getSelectionFeaturesMBean;
    function getSelectionFeaturesMBeanAsync(workspace, $q) {
        return Osgi.runWhenTreeReady(function () { return getSelectionFeaturesMBean(workspace); }, workspace, $q);
    }
    Karaf.getSelectionFeaturesMBeanAsync = getSelectionFeaturesMBeanAsync;
    function getSelectionScrMBean(workspace) {
        if (workspace) {
            var scrStuff = workspace.mbeanTypesToDomain["scr"] || {};
            var karaf = scrStuff["org.apache.karaf"] || {};
            var mbean = karaf.objectName;
            if (mbean) {
                return mbean;
            }
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("org.apache.karaf", "scr");
            if (!folder) {
                // sometimes the features mbean is inside the 'root' folder
                folder = workspace.tree.navigate("org.apache.karaf");
                if (folder) {
                    var children = folder.children;
                    folder = null;
                    angular.forEach(children, function (child) {
                        if (!folder) {
                            folder = child.navigate("scr");
                        }
                    });
                }
            }
            if (folder) {
                var children = folder.children;
                if (children) {
                    var node = children[0];
                    if (node) {
                        return node.objectName;
                    }
                }
                return folder.objectName;
            }
        }
        return null;
    }
    Karaf.getSelectionScrMBean = getSelectionScrMBean;
    function getSelectionScrMBeanAsync(workspace, $q) {
        return Osgi.runWhenTreeReady(function () { return getSelectionScrMBean(workspace); }, workspace, $q);
    }
    Karaf.getSelectionScrMBeanAsync = getSelectionScrMBeanAsync;
})(Karaf || (Karaf = {}));
var Osgi;
(function (Osgi) {
    Osgi.pluginName = 'hawtio-integration-osgi';
    Osgi.log = Logger.get(Osgi.pluginName);
    function defaultBundleValues(workspace, $scope, values) {
        var allValues = values;
        angular.forEach(values, function (row) {
            row["ImportData"] = parseActualPackages(row["ImportedPackages"]);
            row["ExportData"] = parseActualPackages(row["ExportedPackages"]);
            row["IdentifierLink"] = bundleLinks(workspace, row["Identifier"]);
            row["Hosts"] = labelBundleLinks(workspace, row["Hosts"], allValues);
            row["Fragments"] = labelBundleLinks(workspace, row["Fragments"], allValues);
            row["ImportedPackages"] = _.uniq(row["ImportedPackages"]);
            row["StateStyle"] = getStateStyle("label", row["State"]);
            row["RequiringBundles"] = labelBundleLinks(workspace, row["RequiringBundles"], allValues);
        });
        return values;
    }
    Osgi.defaultBundleValues = defaultBundleValues;
    function getStateStyle(prefix, state) {
        switch (state) {
            case "INSTALLED":
                return prefix + "-important";
            case "RESOLVED":
                return prefix + "-inverse";
            case "STARTING":
                return prefix + "-warning";
            case "ACTIVE":
                return prefix + "-success";
            case "STOPPING":
                return prefix + "-info";
            case "UNINSTALLED":
                return ""; // the default color, which is grey
            default:
                return prefix + "-important";
        }
    }
    Osgi.getStateStyle = getStateStyle;
    function defaultServiceValues(workspace, $scope, values) {
        angular.forEach(values, function (row) {
            row["BundleLinks"] = bundleLinks(workspace, row["BundleIdentifier"]);
        });
        return values;
    }
    Osgi.defaultServiceValues = defaultServiceValues;
    function defaultPackageValues(workspace, $scope, values) {
        var packages = [];
        function onPackageEntry(packageEntry, row) {
            if (!row)
                row = packageEntry;
            var name = packageEntry["Name"];
            var version = packageEntry["Version"];
            if (name && !_.startsWith(name, "#")) {
                var importingBundles = row["ImportingBundles"] || packageEntry["ImportingBundles"];
                var exportingBundles = row["ExportingBundles"] || packageEntry["ExportingBundles"];
                packageEntry["ImportingBundleUrls"] = bundleUrls(workspace, importingBundles);
                packageEntry["ExportingBundleUrls"] = bundleUrls(workspace, exportingBundles);
                packages.push(packageEntry);
            }
        }
        // the values could contain a child 'values' array of objects so use those directly
        var childValues = values.values;
        if (childValues) {
            angular.forEach(childValues, onPackageEntry);
        }
        angular.forEach(values, function (row) {
            angular.forEach(row, function (version) {
                angular.forEach(version, function (packageEntry) {
                    onPackageEntry(packageEntry, row);
                });
            });
        });
        return packages;
    }
    Osgi.defaultPackageValues = defaultPackageValues;
    function parseActualPackages(packages) {
        var result = {};
        for (var i = 0; i < packages.length; i++) {
            var pkg = packages[i];
            var idx = pkg.indexOf(";");
            if (idx > 0) {
                var name = pkg.substring(0, idx);
                var ver = pkg.substring(idx + 1);
                var data = result[name];
                if (data === undefined) {
                    data = {};
                    result[name] = data;
                }
                data["ReportedVersion"] = ver;
            }
        }
        return result;
    }
    Osgi.parseActualPackages = parseActualPackages;
    function parseManifestHeader(headers, name) {
        var result = {};
        var data = {};
        var hdr = headers[name];
        if (hdr === undefined) {
            return result;
        }
        var ephdr = hdr.Value;
        var inPkg = true;
        var inQuotes = false;
        var pkgName = "";
        var daDecl = "";
        for (var i = 0; i < ephdr.length; i++) {
            var c = ephdr[i];
            if (c === '"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inQuotes) {
                daDecl += c;
                continue;
            }
            // from here on we are never inside quotes
            if (c === ';') {
                if (inPkg) {
                    inPkg = false;
                }
                else {
                    handleDADecl(data, daDecl);
                    // reset directive and attribute variable
                    daDecl = "";
                }
                continue;
            }
            if (c === ',') {
                handleDADecl(data, daDecl);
                result[pkgName] = data;
                // reset data
                data = {};
                pkgName = "";
                daDecl = "";
                inPkg = true;
                continue;
            }
            if (inPkg) {
                pkgName += c;
            }
            else {
                daDecl += c;
            }
        }
        handleDADecl(data, daDecl);
        result[pkgName] = data;
        return result;
    }
    Osgi.parseManifestHeader = parseManifestHeader;
    function handleDADecl(data, daDecl) {
        var didx = daDecl.indexOf(":=");
        if (didx > 0) {
            data["D" + daDecl.substring(0, didx)] = daDecl.substring(didx + 2);
            return;
        }
        var aidx = daDecl.indexOf("=");
        if (aidx > 0) {
            data["A" + daDecl.substring(0, aidx)] = daDecl.substring(aidx + 1);
            return;
        }
    }
    function toCollection(values) {
        var collection = values;
        if (!angular.isArray(values)) {
            collection = [values];
        }
        return collection;
    }
    Osgi.toCollection = toCollection;
    function labelBundleLinks(workspace, values, allValues) {
        return toCollection(values)
            .sort(function (a, b) { return a - b; })
            .filter(function (value) { return allValues.hasOwnProperty(value); })
            .map(function (value) { return ({
            label: allValues[value].SymbolicName,
            url: Core.url("/osgi/bundles/" + value + workspace.hash())
        }); });
    }
    Osgi.labelBundleLinks = labelBundleLinks;
    function bundleLinks(workspace, values) {
        var answer = "";
        var sorted = toCollection(values).sort(function (a, b) { return a - b; });
        angular.forEach(sorted, function (value, key) {
            var prefix = "";
            if (answer.length > 0) {
                prefix = " ";
            }
            answer += prefix + "<a href='" + Core.url("/osgi/bundles/" + value + workspace.hash()) + "'>Bundle " + value + "</a>";
        });
        return answer;
    }
    Osgi.bundleLinks = bundleLinks;
    function bundleUrls(workspace, values) {
        var answer = [];
        angular.forEach(values, function (value, key) {
            answer.push(Core.url("/osgi/bundles/" + value + workspace.hash()));
        });
        return answer;
    }
    Osgi.bundleUrls = bundleUrls;
    function pidLinks(workspace, values) {
        var answer = "";
        angular.forEach(toCollection(values), function (value, key) {
            var prefix = "";
            if (answer.length > 0) {
                prefix = " ";
            }
            answer += prefix + "<a href='" + Core.url("/osgi/bundles/" + value + workspace.hash()) + "'>" + value + "</a>";
        });
        return answer;
    }
    Osgi.pidLinks = pidLinks;
    /**
     * Finds a bundle by id
     *
     * @method findBundle
     * @for Osgi
     * @param {String} bundleId
     * @param {Array} values
     * @return {any}
     *
     */
    function findBundle(bundleId, values) {
        var answer = "";
        angular.forEach(values, function (row) {
            var id = row["Identifier"];
            if (bundleId === id.toString()) {
                answer = row;
                return answer;
            }
        });
        return answer;
    }
    Osgi.findBundle = findBundle;
    function getSelectionBundleMBean(workspace) {
        if (workspace) {
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("osgi.core", "bundleState");
            return Osgi.findFirstObjectName(folder);
        }
        return null;
    }
    Osgi.getSelectionBundleMBean = getSelectionBundleMBean;
    /**
     * Walks the tree looking in the first child all the way down until we find an objectName
     * @method findFirstObjectName
     * @for Osgi
     * @param {Folder} node
     * @return {String}
     *
     */
    function findFirstObjectName(node) {
        if (node) {
            var answer = node.objectName;
            if (answer) {
                return answer;
            }
            else {
                var children = node.children;
                if (children && children.length) {
                    return findFirstObjectName(children[0]);
                }
            }
        }
        return null;
    }
    Osgi.findFirstObjectName = findFirstObjectName;
    function getSelectionFrameworkMBean(workspace) {
        if (workspace) {
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("osgi.core", "framework");
            return Osgi.findFirstObjectName(folder);
        }
        return null;
    }
    Osgi.getSelectionFrameworkMBean = getSelectionFrameworkMBean;
    function getSelectionFrameworkMBeanAsync(workspace, $q) {
        return runWhenTreeReady(function () { return getSelectionFrameworkMBean(workspace); }, workspace, $q);
    }
    Osgi.getSelectionFrameworkMBeanAsync = getSelectionFrameworkMBeanAsync;
    function getSelectionServiceMBean(workspace) {
        if (workspace) {
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("osgi.core", "serviceState");
            return Osgi.findFirstObjectName(folder);
        }
        return null;
    }
    Osgi.getSelectionServiceMBean = getSelectionServiceMBean;
    function getSelectionServiceMBeanAsync(workspace, $q) {
        return runWhenTreeReady(function () { return getSelectionServiceMBean(workspace); }, workspace, $q);
    }
    Osgi.getSelectionServiceMBeanAsync = getSelectionServiceMBeanAsync;
    function getSelectionPackageMBean(workspace) {
        if (workspace) {
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("osgi.core", "packageState");
            return Osgi.findFirstObjectName(folder);
        }
        return null;
    }
    Osgi.getSelectionPackageMBean = getSelectionPackageMBean;
    function getSelectionPackageMBeanAsync(workspace, $q) {
        return runWhenTreeReady(function () { return getSelectionPackageMBean(workspace); }, workspace, $q);
    }
    Osgi.getSelectionPackageMBeanAsync = getSelectionPackageMBeanAsync;
    function getSelectionConfigAdminMBean(workspace) {
        if (workspace) {
            // lets navigate to the tree item based on paths
            var folder = workspace.tree.navigate("osgi.compendium", "cm");
            return Osgi.findFirstObjectName(folder);
        }
        return null;
    }
    Osgi.getSelectionConfigAdminMBean = getSelectionConfigAdminMBean;
    function getSelectionConfigAdminMBeanAsync(workspace, $q) {
        return runWhenTreeReady(function () { return getSelectionConfigAdminMBean(workspace); }, workspace, $q);
    }
    Osgi.getSelectionConfigAdminMBeanAsync = getSelectionConfigAdminMBeanAsync;
    function getMetaTypeMBean(workspace) {
        if (workspace) {
            var mbeanTypesToDomain = workspace.mbeanTypesToDomain;
            var typeFolder = mbeanTypesToDomain["MetaTypeFacade"] || {};
            var mbeanFolder = typeFolder["io.fabric8"] || {};
            return mbeanFolder["objectName"];
        }
        return null;
    }
    Osgi.getMetaTypeMBean = getMetaTypeMBean;
    function getProfileMetadataMBean(workspace) {
        if (workspace) {
            var mbeanTypesToDomain = workspace.mbeanTypesToDomain;
            var typeFolder = mbeanTypesToDomain["ProfileMetadata"] || {};
            var mbeanFolder = typeFolder["io.fabric8"] || {};
            return mbeanFolder["objectName"];
        }
        return null;
    }
    Osgi.getProfileMetadataMBean = getProfileMetadataMBean;
    function getHawtioOSGiToolsMBean(workspace) {
        if (workspace) {
            var mbeanTypesToDomain = workspace.mbeanTypesToDomain;
            var toolsFacades = mbeanTypesToDomain["OSGiTools"] || {};
            var hawtioFolder = toolsFacades["hawtio"] || {};
            return hawtioFolder["objectName"];
        }
        return null;
    }
    Osgi.getHawtioOSGiToolsMBean = getHawtioOSGiToolsMBean;
    function getHawtioConfigAdminMBean(workspace) {
        if (workspace) {
            var mbeanTypesToDomain = workspace.mbeanTypesToDomain;
            var typeFolder = mbeanTypesToDomain["ConfigAdmin"] || {};
            var mbeanFolder = typeFolder["hawtio"] || {};
            return mbeanFolder["objectName"];
        }
        return null;
    }
    Osgi.getHawtioConfigAdminMBean = getHawtioConfigAdminMBean;
    /**
     * Creates a link to the given configuration pid and/or factoryPid
     */
    function createConfigPidLink($scope, workspace, pid, isFactory) {
        if (isFactory === void 0) { isFactory = false; }
        return createConfigPidPath($scope, pid, isFactory) + workspace.hash();
    }
    Osgi.createConfigPidLink = createConfigPidLink;
    /**
     * Creates a path to the given configuration pid and/or factoryPid
     */
    function createConfigPidPath($scope, pid, isFactory) {
        if (isFactory === void 0) { isFactory = false; }
        var link = pid;
        var versionId = $scope.versionId;
        var profileId = $scope.profileId;
        if (versionId && versionId) {
            var configPage = isFactory ? "/newConfiguration/" : "/configuration/";
            return "/wiki/branch/" + versionId + configPage + link + "/" + $scope.pageId;
        }
        else {
            return "osgi/configurations/pid/" + link;
        }
    }
    Osgi.createConfigPidPath = createConfigPidPath;
    function getConfigurationProperties(workspace, jolokia, pid, onDataFn) {
        var mbean = getSelectionConfigAdminMBean(workspace);
        var answer = null;
        if (jolokia && mbean) {
            answer = jolokia.execute(mbean, 'getProperties', pid, Core.onSuccess(onDataFn));
        }
        return answer;
    }
    Osgi.getConfigurationProperties = getConfigurationProperties;
    /**
     * For a pid of the form "foo.generatedId" for a pid "foo" or "foo.bar" remove the "foo." prefix
     */
    function removeFactoryPidPrefix(pid, factoryPid) {
        if (pid && factoryPid) {
            if (_.startsWith(pid, factoryPid)) {
                return pid.substring(factoryPid.length + 1);
            }
            var idx = factoryPid.lastIndexOf(".");
            if (idx > 0) {
                var prefix = factoryPid.substring(0, idx + 1);
                return Core.trimLeading(pid, prefix);
            }
        }
        return pid;
    }
    Osgi.removeFactoryPidPrefix = removeFactoryPidPrefix;
    function runWhenTreeReady(fn, workspace, $q) {
        return $q(function (resolve, reject) {
            if (workspace.treeFetched) {
                resolve(fn());
            }
            else {
                var unsubscribe_2 = workspace.$rootScope.$on(Jmx.TreeEvent.Updated, function () {
                    unsubscribe_2();
                    resolve(fn());
                });
            }
        });
    }
    Osgi.runWhenTreeReady = runWhenTreeReady;
})(Osgi || (Osgi = {}));
/// <reference path="../osgiHelpers.ts"/>
/// <reference path="bundle.ts"/>
var Osgi;
(function (Osgi) {
    var BundlesService = /** @class */ (function () {
        BundlesService.$inject = ["workspace", "jolokiaService"];
        function BundlesService(workspace, jolokiaService) {
            'ngInject';
            this.workspace = workspace;
            this.jolokiaService = jolokiaService;
        }
        BundlesService.prototype.getBundles = function () {
            var objectName = Osgi.getSelectionBundleMBean(this.workspace);
            return this.jolokiaService.execute(objectName, 'listBundles()')
                .then(function (result) { return _.values(result).map(function (item) { return ({
                id: item.Identifier,
                name: item.Headers['Bundle-Name'] ? item.Headers['Bundle-Name']['Value'] : '',
                location: item.Location,
                symbolicName: item.SymbolicName,
                state: item.State.toLowerCase(),
                version: item.Version,
                startLevel: item.StartLevel,
                fragment: item.Fragment
            }); }); });
        };
        BundlesService.prototype.startBundles = function (bundles) {
            var mbean = Osgi.getSelectionFrameworkMBean(this.workspace);
            var ids = bundles.map(function (bundle) { return bundle.id; });
            return this.jolokiaService.execute(mbean, 'startBundles([J)', ids)
                .then(this.handleResponse);
        };
        BundlesService.prototype.stopBundles = function (bundles) {
            var mbean = Osgi.getSelectionFrameworkMBean(this.workspace);
            var ids = bundles.map(function (bundle) { return bundle.id; });
            return this.jolokiaService.execute(mbean, 'stopBundles([J)', ids)
                .then(this.handleResponse);
        };
        BundlesService.prototype.updateBundles = function (bundles) {
            var mbean = Osgi.getSelectionFrameworkMBean(this.workspace);
            var ids = bundles.map(function (bundle) { return bundle.id; });
            return this.jolokiaService.execute(mbean, 'updateBundles([J)', ids)
                .then(this.handleResponse);
        };
        BundlesService.prototype.refreshBundles = function (bundles) {
            var mbean = Osgi.getSelectionFrameworkMBean(this.workspace);
            var ids = bundles.map(function (bundle) { return bundle.id; });
            return this.jolokiaService.execute(mbean, 'refreshBundles([J)', ids)
                .then(this.handleResponse);
        };
        BundlesService.prototype.uninstallBundles = function (bundles) {
            var mbean = Osgi.getSelectionFrameworkMBean(this.workspace);
            var ids = bundles.map(function (bundle) { return bundle.id; });
            return this.jolokiaService.execute(mbean, 'uninstallBundles([J)', ids)
                .then(this.handleResponse);
        };
        BundlesService.prototype.installBundle = function (bundleUrl) {
            var _this = this;
            var mbean = Osgi.getSelectionFrameworkMBean(this.workspace);
            return this.jolokiaService.execute(mbean, 'installBundle(java.lang.String)', bundleUrl)
                .then(function (response) { return _this.jolokiaService.execute(mbean, 'startBundles([J)', response); })
                .then(this.handleResponse);
        };
        BundlesService.prototype.handleResponse = function (response) {
            if (response && response['Error']) {
                throw response['Error'];
            }
            else {
                return "The operation completed successfully";
            }
        };
        return BundlesService;
    }());
    Osgi.BundlesService = BundlesService;
})(Osgi || (Osgi = {}));
/// <reference path="bundle.ts"/>
/// <reference path="bundles.service.ts"/>
var Osgi;
(function (Osgi) {
    var BundlesController = /** @class */ (function () {
        BundlesController.$inject = ["bundlesService", "workspace"];
        function BundlesController(bundlesService, workspace) {
            'ngInject';
            var _this = this;
            this.bundlesService = bundlesService;
            this.workspace = workspace;
            this.startAction = {
                name: 'Start',
                actionFn: function (action) {
                    var selectedBundles = _this.getSelectedBundles();
                    var fragmentBundles = selectedBundles.filter(function (bundle) { return bundle.fragment; });
                    if (fragmentBundles.length > 0) {
                        Core.notification('warning', 'Fragment bundles cannot be started');
                    }
                    else {
                        _this.bundlesService.startBundles(selectedBundles)
                            .then(function (response) {
                            Core.notification('success', response);
                            _this.loadBundles();
                        })
                            .catch(function (error) { return Core.notification('danger', error); });
                    }
                },
                isDisabled: true
            };
            this.stopAction = {
                name: 'Stop',
                actionFn: function (action) {
                    var selectedBundles = _this.getSelectedBundles();
                    _this.bundlesService.stopBundles(selectedBundles)
                        .then(function (response) {
                        Core.notification('success', response);
                        _this.loadBundles();
                    })
                        .catch(function (error) { return Core.notification('danger', error); });
                },
                isDisabled: true
            };
            this.refreshAction = {
                name: 'Refresh',
                actionFn: function (action) {
                    var selectedBundles = _this.getSelectedBundles();
                    _this.bundlesService.refreshBundles(selectedBundles)
                        .then(function (response) {
                        Core.notification('success', response);
                        // delay reloading because some bundles change their state for a moment after a refresh
                        setTimeout(function () { return _this.loadBundles(); }, 2000);
                    })
                        .catch(function (error) { return Core.notification('danger', error); });
                },
                isDisabled: true
            };
            this.updateAction = {
                name: 'Update',
                actionFn: function (action) {
                    var selectedBundles = _this.getSelectedBundles();
                    _this.bundlesService.updateBundles(selectedBundles)
                        .then(function (response) {
                        Core.notification('success', response);
                        _this.loadBundles();
                    })
                        .catch(function (error) { return Core.notification('danger', error); });
                },
                isDisabled: true
            };
            this.uninstallAction = {
                name: 'Uninstall',
                actionFn: function (action) {
                    var selectedBundles = _this.getSelectedBundles();
                    _this.bundlesService.uninstallBundles(selectedBundles)
                        .then(function (response) {
                        Core.notification('success', response);
                        _this.loadBundles();
                    })
                        .catch(function (error) { return Core.notification('danger', error); });
                },
                isDisabled: true
            };
            this.tableConfig = {
                selectionMatchProp: 'id',
                showCheckboxes: true,
                onCheckBoxChange: function (item) { return _this.enableDisableActions(); }
            };
            this.toolbarConfig = {
                filterConfig: {
                    fields: [
                        {
                            id: 'state',
                            title: 'State',
                            placeholder: 'Filter by state...',
                            filterType: 'select',
                            filterValues: [
                                'active',
                                'installed',
                                'resolved',
                                'signers_all',
                                'signers_trusted',
                                'start_activation_policy',
                                'start_transient',
                                'starting',
                                'stop_transient',
                                'stopping',
                                'uninstalled'
                            ]
                        },
                        {
                            id: 'name',
                            title: 'Name',
                            placeholder: 'Filter by name...',
                            filterType: 'text'
                        },
                        {
                            id: 'symbolicName',
                            title: 'Symbolic Name',
                            placeholder: 'Filter by symbolic name...',
                            filterType: 'text'
                        },
                        {
                            id: 'version',
                            title: 'Version',
                            placeholder: 'Filter by version...',
                            filterType: 'text'
                        }
                    ],
                    onFilterChange: function (filters) {
                        _this.applyFilters(filters);
                    },
                    appliedFilters: [],
                    resultsCount: 0
                },
                actionsConfig: {
                    primaryActions: this.toolbarActions()
                },
                isTableView: true
            };
            this.tableColumns = [
                { header: 'ID', itemField: 'id', templateFn: function (value) { return "<a href=\"osgi/bundles/" + value + "\">" + value + "</a>"; } },
                { header: 'State', itemField: 'state' },
                { header: 'Name', itemField: 'name' },
                { header: 'Symbolic Name', itemField: 'symbolicName' },
                { header: 'Version', itemField: 'version' }
            ];
            this.tableItems = null;
            this.loading = true;
        }
        BundlesController.prototype.$onInit = function () {
            this.loadBundles();
        };
        BundlesController.prototype.loadBundles = function () {
            var _this = this;
            this.bundlesService.getBundles()
                .then(function (bundles) {
                _this.bundles = bundles;
                _this.applyFilters(_this.toolbarConfig.filterConfig.appliedFilters);
                _this.enableDisableActions();
                _this.loading = false;
            });
        };
        BundlesController.prototype.toolbarActions = function () {
            var actions = [];
            var frameworkMBean = Osgi.getSelectionFrameworkMBean(this.workspace);
            if (this.workspace.hasInvokeRightsForName(frameworkMBean, 'startBundle')) {
                actions.push(this.startAction);
            }
            if (this.workspace.hasInvokeRightsForName(frameworkMBean, 'stopBundle')) {
                actions.push(this.stopAction);
            }
            if (this.workspace.hasInvokeRightsForName(frameworkMBean, 'refreshBundle')) {
                actions.push(this.refreshAction);
            }
            if (this.workspace.hasInvokeRightsForName(frameworkMBean, 'updateBundle')) {
                actions.push(this.updateAction);
            }
            if (this.workspace.hasInvokeRightsForName(frameworkMBean, 'uninstallBundle')) {
                actions.push(this.uninstallAction);
            }
            Osgi.log.debug("RBAC - Rendered bundles actions:", actions);
            if (_.isEmpty(actions)) {
                Osgi.log.debug("RBAC - Disable checkboxes");
                this.tableConfig.showCheckboxes = false;
            }
            return actions;
        };
        BundlesController.prototype.applyFilters = function (filters) {
            if (filters === void 0) { filters = []; }
            var filteredBundles = this.bundles;
            filters.forEach(function (filter) {
                filteredBundles = BundlesController.FILTER_FUNCTIONS[filter.id](filteredBundles, filter.value);
            });
            this.tableItems = filteredBundles;
            this.toolbarConfig.filterConfig.resultsCount = filteredBundles.length;
        };
        BundlesController.prototype.getSelectedBundles = function () {
            return this.tableItems
                .filter(function (tableItem) { return tableItem.selected; });
        };
        BundlesController.prototype.enableDisableActions = function () {
            var selectedBundles = this.getSelectedBundles();
            var noBundlesSelected = selectedBundles.length === 0;
            this.startAction.isDisabled = noBundlesSelected || selectedBundles.every(function (bundle) { return bundle.state === 'active'; });
            this.stopAction.isDisabled = noBundlesSelected || selectedBundles.every(function (bundle) { return bundle.state !== 'active'; });
            this.refreshAction.isDisabled = noBundlesSelected;
            this.updateAction.isDisabled = noBundlesSelected;
            this.uninstallAction.isDisabled = noBundlesSelected;
        };
        BundlesController.FILTER_FUNCTIONS = {
            state: function (bundles, state) { return bundles.filter(function (bundle) { return bundle.state === state; }); },
            name: function (bundles, name) {
                var regExp = new RegExp(name, 'i');
                return bundles.filter(function (bundle) { return regExp.test(bundle.name); });
            },
            symbolicName: function (bundles, symbolicName) {
                return bundles.filter(function (bundle) { return bundle.symbolicName.indexOf(symbolicName) !== -1; });
            },
            version: function (bundles, version) {
                return bundles.filter(function (bundle) { return bundle.version.indexOf(version) !== -1; });
            }
        };
        return BundlesController;
    }());
    Osgi.BundlesController = BundlesController;
    Osgi.bundlesComponent = {
        template: "\n      <div class=\"table-view\">\n        <h1>Bundles</h1>\n        <p ng-if=\"$ctrl.loading\">Loading...</p>\n        <div ng-if=\"!$ctrl.loading\">\n          <install-bundle bundles=\"$ctrl.bundles\" on-install=\"$ctrl.loadBundles()\"></install-bundle>\n          <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n          <pf-table-view config=\"$ctrl.tableConfig\"\n                         columns=\"$ctrl.tableColumns\"\n                         items=\"$ctrl.tableItems\"></pf-table-view>\n        </div>\n      </div>\n    ",
        controller: BundlesController
    };
})(Osgi || (Osgi = {}));
/// <reference path="bundle.ts"/>
var Osgi;
(function (Osgi) {
    var InstallBundleController = /** @class */ (function () {
        InstallBundleController.$inject = ["bundlesService", "workspace"];
        function InstallBundleController(bundlesService, workspace) {
            'ngInject';
            this.bundlesService = bundlesService;
            this.workspace = workspace;
            this.loading = false;
            this.bundles = [];
            this.frameworkMBean = Osgi.getSelectionFrameworkMBean(this.workspace);
        }
        InstallBundleController.prototype.install = function (bundleUrl) {
            var _this = this;
            var bundle = this.findBundleByUrl(bundleUrl);
            if (bundle) {
                Core.notification('warning', "Bundle " + bundle.name + " " + bundle.version + " is already installed");
                return;
            }
            this.loading = true;
            this.bundlesService.installBundle(bundleUrl)
                .then(function (response) {
                _this.loading = false;
                Core.notification('success', response);
                _this['onInstall']();
            })
                .catch(function (error) {
                _this.loading = false;
                Core.notification('danger', error);
            });
        };
        InstallBundleController.prototype.findBundleByUrl = function (bundleUrl) {
            return this.bundles.filter(function (bundle) { return bundle.location === bundleUrl.trim(); })[0];
        };
        InstallBundleController.prototype.installDisabled = function (bundleUrl) {
            return this.loading || (!bundleUrl || bundleUrl.trim().length === 0);
        };
        return InstallBundleController;
    }());
    Osgi.InstallBundleController = InstallBundleController;
    Osgi.installBundleComponent = {
        template: "\n      <div class=\"row install-bundle\"\n          hawtio-show object-name=\"{{$ctrl.frameworkMBean}}\" method-name=\"installBundle\">\n        <div class=\"col-lg-6\">\n          <div class=\"input-group\">\n            <input type=\"text\" class=\"form-control\" placeholder=\"Bundle URL...\" ng-model=\"bundleUrl\">\n            <span class=\"input-group-btn\">\n              <button type=\"button\" class=\"btn btn-default\" ng-click=\"$ctrl.install(bundleUrl)\" ng-disabled=\"$ctrl.installDisabled(bundleUrl)\">\n                Install\n              </button>\n            </span>\n          </div>\n        </div>\n        <div class=\"col-lg-6\">\n        </div>\n      </div>\n    ",
        controller: InstallBundleController,
        bindings: {
            onInstall: '&',
            bundles: '<'
        }
    };
})(Osgi || (Osgi = {}));
/// <reference path="bundles.component.ts"/>
/// <reference path="install-bundle.component.ts"/>
/// <reference path="bundles.service.ts"/>
var Osgi;
(function (Osgi) {
    Osgi.bundlesModule = angular
        .module('hawtio-osgi-bundles', [])
        .component('bundles', Osgi.bundlesComponent)
        .component('installBundle', Osgi.installBundleComponent)
        .service('bundlesService', Osgi.BundlesService)
        .name;
})(Osgi || (Osgi = {}));
var Osgi;
(function (Osgi) {
    var ConfigurationPropertyAddModalController = /** @class */ (function () {
        function ConfigurationPropertyAddModalController() {
            this.property = new Osgi.ConfigurationProperty('', '');
        }
        return ConfigurationPropertyAddModalController;
    }());
    Osgi.ConfigurationPropertyAddModalController = ConfigurationPropertyAddModalController;
    Osgi.configurationPropertyAddModal = {
        bindings: {
            close: '&',
            dismiss: '&'
        },
        template: "\n      <form name=\"addPropertyForm\" class=\"form-horizontal\" ng-submit=\"$ctrl.close({$value: $ctrl.property})\">\n        <div class=\"modal-header\">\n          <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"$ctrl.dismiss()\">\n            <span class=\"pficon pficon-close\" aria-hidden=\"true\"></span>\n          </button>\n          <h4 class=\"modal-title\">Add property</h4>\n        </div>\n        <div class=\"modal-body\">\n          <div class=\"form-group\" ng-class=\"{'has-error': addPropertyForm.propKey.$invalid}\">\n            <label class=\"col-sm-2 control-label\" for=\"propKey\">Key</label>\n            <div class=\"col-sm-10\">\n              <input type=\"text\" class=\"form-control\" id=\"propKey\" name=\"propKey\" ng-model=\"$ctrl.property.key\" ng-pattern=\"/^\\S+$/\">\n              <span class=\"help-block\" ng-show=\"addPropertyForm.propKey.$invalid\">Spaces are not allowed</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-2 control-label\" for=\"propValue\">Value</label>\n            <div class=\"col-sm-10\">\n              <textarea class=\"form-control\" id=\"propValue\" name=\"propValue\" rows=\"5\" ng-model=\"$ctrl.property.value\"></textarea>\n            </div>\n          </div>\n        </div>\n        <div class=\"modal-footer\">\n          <button type=\"button\" class=\"btn btn-default\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n          <button type=\"submit\" class=\"btn btn-primary\" ng-disabled=\"!$ctrl.property.key\">Add</button>\n        </div>\n      </form>\n    ",
        controller: ConfigurationPropertyAddModalController
    };
})(Osgi || (Osgi = {}));
var Osgi;
(function (Osgi) {
    Osgi.configurationPropertyDeleteModal = {
        bindings: {
            close: '&',
            dismiss: '&',
            resolve: '<'
        },
        template: "\n      <form class=\"form-horizontal\" ng-submit=\"$ctrl.close()\">\n        <div class=\"modal-header\">\n          <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"$ctrl.dismiss()\">\n            <span class=\"pficon pficon-close\" aria-hidden=\"true\"></span>\n          </button>\n          <h4 class=\"modal-title\">Delete property</h4>\n        </div>\n        <div class=\"modal-body\">\n          <p>Delete property '{{$ctrl.resolve.property.key}}'?</p>\n        </div>\n        <div class=\"modal-footer\">\n          <button type=\"button\" class=\"btn btn-default\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n          <button type=\"submit\" class=\"btn btn-danger\">Delete</button>\n        </div>\n      </form>\n    "
    };
})(Osgi || (Osgi = {}));
var Osgi;
(function (Osgi) {
    Osgi.configurationPropertyEditModal = {
        bindings: {
            close: '&',
            dismiss: '&',
            resolve: '<'
        },
        template: "\n      <form name=\"addPropertyForm\" class=\"form-horizontal\" ng-submit=\"$ctrl.close({$value: $ctrl.resolve.property})\">\n        <div class=\"modal-header\">\n          <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"$ctrl.dismiss()\">\n            <span class=\"pficon pficon-close\" aria-hidden=\"true\"></span>\n          </button>\n          <h4 class=\"modal-title\">Edit property</h4>\n        </div>\n        <div class=\"modal-body\">\n          <div class=\"form-group\" ng-class=\"{'has-error': addPropertyForm.propKey.$invalid}\">\n            <label class=\"col-sm-2 control-label\" for=\"propKey\">Key</label>\n            <div class=\"col-sm-10\">\n              <input type=\"text\" class=\"form-control\" id=\"propKey\" name=\"propKey\" ng-model=\"$ctrl.resolve.property.key\" ng-pattern=\"/^\\S+$/\">\n              <span class=\"help-block\" ng-show=\"addPropertyForm.propKey.$invalid\">Spaces are not allowed</span>\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-2 control-label\" for=\"propValue\">Value</label>\n            <div class=\"col-sm-10\">\n              <textarea class=\"form-control\" id=\"propValue\" name=\"propValue\" rows=\"5\" ng-model=\"$ctrl.resolve.property.value\"></textarea>\n            </div>\n          </div>\n        </div>\n        <div class=\"modal-footer\">\n          <button type=\"button\" class=\"btn btn-default\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n          <button type=\"submit\" class=\"btn btn-primary\" ng-disabled=\"!$ctrl.resolve.property.key\">Save</button>\n        </div>\n      </form>\n    "
    };
})(Osgi || (Osgi = {}));
var Osgi;
(function (Osgi) {
    var ConfigurationProperty = /** @class */ (function () {
        function ConfigurationProperty(key, value) {
            this.key = key;
            this.value = value;
        }
        return ConfigurationProperty;
    }());
    Osgi.ConfigurationProperty = ConfigurationProperty;
})(Osgi || (Osgi = {}));
/// <reference path="configuration-property.ts"/>
var Osgi;
(function (Osgi) {
    var Configuration = /** @class */ (function () {
        function Configuration(id, properties) {
            this.id = id;
            this.properties = properties;
        }
        Configuration.prototype.getPropertiesAsJson = function () {
            var obj = {};
            this.properties.forEach(function (property) { return obj[property.key] = property.value; });
            return JSON.stringify(obj);
        };
        return Configuration;
    }());
    Osgi.Configuration = Configuration;
})(Osgi || (Osgi = {}));
/// <reference path="configuration.ts"/>
/// <reference path="configuration-property.ts"/>
var Osgi;
(function (Osgi) {
    var ConfigurationController = /** @class */ (function () {
        ConfigurationController.$inject = ["$routeParams", "$uibModal", "configurationService"];
        function ConfigurationController($routeParams, $uibModal, configurationService) {
            'ngInject';
            var _this = this;
            this.$routeParams = $routeParams;
            this.$uibModal = $uibModal;
            this.configurationService = configurationService;
            this.toolbarConfig = {
                actionsConfig: {
                    primaryActions: []
                },
                isTableView: true
            };
            this.tableConfig = {
                selectionMatchProp: 'key',
                showCheckboxes: false
            };
            this.tableColumns = [
                { header: 'Key', itemField: 'key' },
                { header: 'Value', itemField: 'value' }
            ];
            this.addAction = function () {
                _this.$uibModal.open({
                    component: 'configurationPropertyAddModal'
                })
                    .result.then(function (property) {
                    _this.configurationService.addProperty(_this.configuration, property)
                        .then(function (configuration) {
                        _this.configuration = configuration;
                        Core.notification('success', 'Successfully added property');
                    });
                });
            };
            this.editAction = function (action, property) {
                _this.$uibModal.open({
                    component: 'configurationPropertyEditModal',
                    resolve: { property: function () { return new Osgi.ConfigurationProperty(property.key, property.value); } }
                })
                    .result.then(function (editedProperty) {
                    _this.configurationService.replaceProperty(_this.configuration, property, editedProperty)
                        .then(function (configuration) {
                        _this.configuration = configuration;
                        Core.notification('success', 'Successfully updated property');
                    });
                });
            };
            this.deleteAction = function (action, property) {
                _this.$uibModal.open({
                    component: 'configurationPropertyDeleteModal',
                    resolve: { property: function () { return property; } }
                })
                    .result.then(function () {
                    _this.configurationService.deleteProperty(_this.configuration, property)
                        .then(function (configuration) {
                        _this.configuration = configuration;
                        Core.notification('success', 'Successfully deleted property');
                    });
                });
            };
            this.toolbarConfig.actionsConfig.primaryActions = this.getToolbarActions();
            this.tableMenuActions = this.getTableMenuActions();
        }
        ConfigurationController.prototype.$onInit = function () {
            this.loadConfiguration();
        };
        ConfigurationController.prototype.loadConfiguration = function () {
            var _this = this;
            var id = this.$routeParams.id;
            this.configurationService.getConfiguration(id)
                .then(function (configuration) { return _this.configuration = configuration; });
        };
        ConfigurationController.prototype.getToolbarActions = function () {
            var actions = [];
            if (this.configurationService.hasRightsToAddProperty()) {
                actions.push({ name: 'Add property', actionFn: this.addAction });
            }
            return actions;
        };
        ConfigurationController.prototype.getTableMenuActions = function () {
            var actions = [];
            if (this.configurationService.hasRightsToEditProperties()) {
                actions.push({ name: 'Edit', actionFn: this.editAction });
            }
            if (this.configurationService.hasRightsToDeleteProperties()) {
                actions.push({ name: 'Delete', actionFn: this.deleteAction });
            }
            return actions;
        };
        return ConfigurationController;
    }());
    Osgi.ConfigurationController = ConfigurationController;
    Osgi.configurationComponent = {
        template: "\n      <div class=\"table-view\">\n        <ol class=\"breadcrumb\">\n          <li><a ng-href=\"osgi/configurations\">Configuration</a></li>\n          <li class=\"page-title\">{{$ctrl.configuration.id}}</li>\n        </ol>\n        <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n        <pf-table-view config=\"$ctrl.tableConfig\" columns=\"$ctrl.tableColumns\" items=\"$ctrl.configuration.properties\"\n          menu-actions=\"$ctrl.tableMenuActions\"></pf-table-view>\n      </div>\n    ",
        controller: ConfigurationController
    };
})(Osgi || (Osgi = {}));
/// <reference path="configuration.ts"/>
/// <reference path="configuration-property.ts"/>
var Osgi;
(function (Osgi) {
    var ConfigurationService = /** @class */ (function () {
        ConfigurationService.$inject = ["workspace", "jolokiaService"];
        function ConfigurationService(workspace, jolokiaService) {
            'ngInject';
            this.workspace = workspace;
            this.jolokiaService = jolokiaService;
            this.hawtioConfigAdminMBean = Osgi.getHawtioConfigAdminMBean(workspace);
            this.configAdminMBean = Osgi.getSelectionConfigAdminMBean(workspace);
        }
        ConfigurationService.prototype.getConfiguration = function (id) {
            return this.jolokiaService.execute(this.configAdminMBean, 'getProperties', id)
                .then(function (result) {
                var properties = [];
                _.values(result)
                    .filter(function (item) { return item.Key !== 'service.pid'; })
                    .map(function (item) { return properties.push(new Osgi.ConfigurationProperty(item.Key, item.Value)); });
                return new Osgi.Configuration(id, properties);
            });
        };
        ConfigurationService.prototype.addProperty = function (configuration, property) {
            configuration.properties.push(property);
            return this.saveAndLoadConfiguration(configuration);
        };
        ConfigurationService.prototype.replaceProperty = function (configuration, oldProperty, newProperty) {
            configuration.properties = configuration.properties.filter(function (p) { return p !== oldProperty; });
            configuration.properties.push(newProperty);
            return this.saveAndLoadConfiguration(configuration);
        };
        ConfigurationService.prototype.deleteProperty = function (configuration, property) {
            configuration.properties = configuration.properties.filter(function (p) { return p !== property; });
            return this.saveAndLoadConfiguration(configuration);
        };
        ConfigurationService.prototype.saveAndLoadConfiguration = function (configuration) {
            var _this = this;
            return this.jolokiaService.execute(this.hawtioConfigAdminMBean, 'configAdminUpdate', configuration.id, configuration.getPropertiesAsJson())
                .then(function () { return _this.getConfiguration(configuration.id); });
        };
        ConfigurationService.prototype.hasRightsToAddProperty = function () {
            return this.workspace.hasInvokeRightsForName(this.configAdminMBean, 'createFactoryConfiguration')
                && this.workspace.hasInvokeRightsForName(this.hawtioConfigAdminMBean, 'configAdminUpdate');
        };
        ConfigurationService.prototype.hasRightsToEditProperties = function () {
            return this.workspace.hasInvokeRightsForName(this.hawtioConfigAdminMBean, 'configAdminUpdate');
        };
        ConfigurationService.prototype.hasRightsToDeleteProperties = function () {
            return this.workspace.hasInvokeRightsForName(this.hawtioConfigAdminMBean, 'configAdminUpdate');
        };
        return ConfigurationService;
    }());
    Osgi.ConfigurationService = ConfigurationService;
})(Osgi || (Osgi = {}));
/// <reference path="configuration-property-add-modal.component.ts"/>
/// <reference path="configuration-property-delete-modal.component.ts"/>
/// <reference path="configuration-property-edit-modal.component.ts"/>
/// <reference path="configuration.component.ts"/>
/// <reference path="configuration.service.ts"/>
var Osgi;
(function (Osgi) {
    Osgi.configurationModule = angular
        .module('hawtio-osgi-configuration', [])
        .component('osgiConfiguration', Osgi.configurationComponent)
        .component('configurationPropertyAddModal', Osgi.configurationPropertyAddModal)
        .component('configurationPropertyDeleteModal', Osgi.configurationPropertyDeleteModal)
        .component('configurationPropertyEditModal', Osgi.configurationPropertyEditModal)
        .service('configurationService', Osgi.ConfigurationService)
        .name;
})(Osgi || (Osgi = {}));
/// <reference path="../osgiHelpers.ts"/>
/// <reference path="framework.ts"/>
var Osgi;
(function (Osgi) {
    var FrameworkService = /** @class */ (function () {
        FrameworkService.$inject = ["$q", "workspace", "jolokiaService"];
        function FrameworkService($q, workspace, jolokiaService) {
            'ngInject';
            this.$q = $q;
            this.workspace = workspace;
            this.jolokiaService = jolokiaService;
        }
        FrameworkService.prototype.getFramework = function () {
            var _this = this;
            return Osgi.getSelectionFrameworkMBeanAsync(this.workspace, this.$q)
                .then(function (objectName) { return _this.jolokiaService.getMBean(objectName); })
                .then(function (response) {
                var framework = {
                    initialBundleStartLevel: response.InitialBundleStartLevel,
                    startLevel: response.FrameworkStartLevel
                };
                return framework;
            });
        };
        FrameworkService.prototype.updateConfiguration = function (framework) {
            var mbean = Osgi.getSelectionFrameworkMBean(this.workspace);
            if (mbean) {
                return this.jolokiaService.setAttributes(mbean, FrameworkService.FRAMEWORK_MBEAN_ATTRIBUTES, [framework.startLevel.toString(), framework.initialBundleStartLevel.toString()]);
            }
        };
        FrameworkService.FRAMEWORK_MBEAN_ATTRIBUTES = [
            'FrameworkStartLevel',
            'InitialBundleStartLevel'
        ];
        return FrameworkService;
    }());
    Osgi.FrameworkService = FrameworkService;
})(Osgi || (Osgi = {}));
/// <reference path="framework.ts"/>
/// <reference path="framework.service.ts"/>
/// <reference path="../bundles/bundles.service.ts"/>
var Osgi;
(function (Osgi) {
    var FrameworkController = /** @class */ (function () {
        FrameworkController.$inject = ["frameworkService", "bundlesService", "attributesService", "workspace", "$q"];
        function FrameworkController(frameworkService, bundlesService, attributesService, workspace, $q) {
            'ngInject';
            this.frameworkService = frameworkService;
            this.bundlesService = bundlesService;
            this.attributesService = attributesService;
            this.workspace = workspace;
            this.$q = $q;
            this.framework = null;
            this.maxBundleStartLevel = null;
            this.loading = false;
            this.saveInProgress = false;
            this.canSave = false;
        }
        FrameworkController.prototype.$onInit = function () {
            var _this = this;
            this.loading = true;
            this.frameworkService.getFramework()
                .then(function (framework) { return _this.framework = framework; })
                .catch(function (error) { return Core.notification('danger', error); });
            this.bundlesService.getBundles()
                .then(function (bundles) {
                var bundleStartLevels = bundles.filter(function (bundle) { return bundle.state === 'active'; }).map(function (bundle) { return bundle.startLevel; });
                _this.maxBundleStartLevel = Math.max.apply(Math, bundleStartLevels);
            })
                .then(function (_) { return _this.fetchPermissions(); })
                .then(function (permissions) {
                _this.canSave = _.every(permissions);
                _this.loading = false;
            })
                .catch(function (error) {
                _this.loading = false;
                Osgi.log.error(error);
            });
        };
        FrameworkController.prototype.fetchPermissions = function () {
            var _this = this;
            var mbean = Osgi.getSelectionFrameworkMBean(this.workspace);
            return this.$q.all(Osgi.FrameworkService.FRAMEWORK_MBEAN_ATTRIBUTES
                .map(function (attribute) { return _this.attributesService.canInvoke(mbean, attribute, 'Int'); }));
        };
        FrameworkController.prototype.updateFrameworkConfiguration = function () {
            var _this = this;
            if (this.framework.startLevel < this.framework.initialBundleStartLevel) {
                Core.notification('danger', 'Cannot set framework start level below initial bundle start level');
            }
            else if (this.maxBundleStartLevel !== null && this.framework.startLevel < this.maxBundleStartLevel) {
                Core.notification('danger', "Cannot set framework start level to " + this.framework.startLevel + ".\n\nSome installed bundles require a start level of " + this.maxBundleStartLevel + ".");
            }
            else {
                this.saveInProgress = true;
                this.frameworkService.updateConfiguration(this.framework)
                    .then(function (response) {
                    _this.saveInProgress = false;
                    Core.notification('success', 'Configuration updated');
                })
                    .catch(function (error) {
                    _this.saveInProgress = false;
                    Core.notification('danger', error);
                });
            }
        };
        FrameworkController.prototype.saveDisabled = function () {
            return this.framework === null ||
                this.framework.initialBundleStartLevel === null ||
                this.framework.startLevel === null ||
                this.saveInProgress === true;
        };
        FrameworkController.prototype.hasEditPermission = function () {
            return this.canSave;
        };
        return FrameworkController;
    }());
    Osgi.FrameworkController = FrameworkController;
    Osgi.frameworkComponent = {
        template: "\n      <div class=\"framework-main\">\n        <h1>Framework Configuration</h1>\n        <p ng-if=\"$ctrl.loading\">Loading...</p>\n        <div ng-if=\"!$ctrl.loading\">\n          <form class=\"form-horizontal framework-form\" ng-submit=\"$ctrl.updateFrameworkConfiguration()\">\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"startLevel\">Current Framework Start Level</label>\n              <div class=\"col-sm-2\">\n                <input id=\"startLevel\" class=\"form-control\" type=\"number\" min=\"0\" max=\"100\" ng-model=\"$ctrl.framework.startLevel\">\n              </div>\n            </div>\n            <div class=\"form-group\">\n              <label class=\"col-sm-3 control-label\" for=\"initialBundleStartLevel\">Initial Bundle Start Level</label>\n              <div class=\"col-sm-2\">\n                <input id=\"initialBundleStartLevel\" class=\"form-control\" type=\"number\" min=\"0\" max=\"100\" ng-model=\"$ctrl.framework.initialBundleStartLevel\">\n              </div>\n            </div>\n            <div ng-if=\"$ctrl.hasEditPermission()\" class=\"form-group\">\n              <div class=\"col-sm-offset-3 col-sm-2\">\n                <button type=\"submit\" class=\"btn btn-primary\" ng-disabled=\"$ctrl.saveDisabled()\">\n                  Save\n                </button>\n              </div>\n            </div>\n          </form>\n        </div>\n      </div>\n    ",
        controller: FrameworkController
    };
})(Osgi || (Osgi = {}));
/// <reference path="framework.component.ts"/>
/// <reference path="framework.service.ts"/>
var Osgi;
(function (Osgi) {
    Osgi.frameworkModule = angular
        .module('hawtio-osgi-framework', [])
        .component('framework', Osgi.frameworkComponent)
        .service('frameworkService', Osgi.FrameworkService)
        .name;
})(Osgi || (Osgi = {}));
var Osgi;
(function (Osgi) {
    var OsgiController = /** @class */ (function () {
        OsgiController.$inject = ["workspace"];
        function OsgiController(workspace) {
            'ngInject';
            this.workspace = workspace;
        }
        OsgiController.prototype.$onInit = function () {
            this.tabs = [];
            var bundlesTab = new Nav.HawtioTab('Bundles', '/osgi/bundles');
            this.tabs.push(bundlesTab);
            if (Karaf.getSelectionFeaturesMBean(this.workspace)) {
                this.tabs.push(new Nav.HawtioTab('Features', '/osgi/features'));
            }
            this.tabs.push(new Nav.HawtioTab('Packages', '/osgi/packages'));
            this.tabs.push(new Nav.HawtioTab('Services', '/osgi/services'));
            if (Karaf.getSelectionScrMBean(this.workspace)) {
                this.tabs.push(new Nav.HawtioTab('Declarative Services', '/osgi/scr-components'));
            }
            this.tabs.push(new Nav.HawtioTab('Server', '/osgi/server'));
            this.tabs.push(new Nav.HawtioTab('Framework', '/osgi/fwk'));
            this.tabs.push(new Nav.HawtioTab('Configuration', '/osgi/configurations'));
        };
        return OsgiController;
    }());
    Osgi.OsgiController = OsgiController;
    Osgi.osgiComponent = {
        template: '<hawtio-tabs-layout tabs="$ctrl.tabs"></hawtio-tabs-layout>',
        controller: OsgiController
    };
})(Osgi || (Osgi = {}));
/// <reference path="osgiHelpers.ts"/>
/// <reference path="osgiPlugin.ts"/>
var Osgi;
(function (Osgi) {
    var OsgiDataService = /** @class */ (function () {
        function OsgiDataService(workspace, jolokia) {
            this.jolokia = jolokia;
            this.workspace = workspace;
        }
        OsgiDataService.prototype.getBundles = function () {
            var bundles = {};
            // TODO make this async,especially given this returns lots of data
            var response = this.jolokia.request({
                type: 'exec',
                mbean: Osgi.getSelectionBundleMBean(this.workspace),
                operation: 'listBundles()'
            }, Core.onSuccess(null));
            angular.forEach(response.value, function (value, key) {
                var obj = {
                    Identifier: value.Identifier,
                    Name: "",
                    SymbolicName: value.SymbolicName,
                    Fragment: value.Fragment,
                    State: value.State,
                    Version: value.Version,
                    LastModified: new Date(Number(value.LastModified)),
                    Location: value.Location,
                    StartLevel: undefined,
                    RegisteredServices: value.RegisteredServices,
                    ServicesInUse: value.ServicesInUse
                };
                if (value.Headers['Bundle-Name']) {
                    obj.Name = value.Headers['Bundle-Name']['Value'];
                }
                bundles[value.Identifier] = obj;
            });
            return bundles;
        };
        OsgiDataService.prototype.getServices = function () {
            var services = {};
            var response = this.jolokia.request({
                type: 'exec',
                mbean: Osgi.getSelectionServiceMBean(this.workspace),
                operation: 'listServices()'
            }, Core.onSuccess(null));
            var answer = response.value;
            angular.forEach(answer, function (value, key) {
                services[value.Identifier] = value;
            });
            return services;
        };
        OsgiDataService.prototype.getPackages = function () {
            var packages = {};
            var response = this.jolokia.request({
                type: 'exec',
                mbean: Osgi.getSelectionPackageMBean(this.workspace),
                operation: 'listPackages()'
            }, Core.onSuccess(null));
            var answer = response.value.values;
            answer.forEach(function (value) {
                packages[value.Name + "-" + value.Version] = value;
            });
            return packages;
        };
        return OsgiDataService;
    }());
    Osgi.OsgiDataService = OsgiDataService;
})(Osgi || (Osgi = {}));
/// <reference path="../../karaf/ts/karafHelpers.ts"/>
/// <reference path="bundles/bundles.module.ts"/>
/// <reference path="configuration/configuration.module.ts"/>
/// <reference path="framework/framework.module.ts"/>
/// <reference path="osgi.component.ts"/>
/// <reference path="osgiData.ts"/>
/// <reference path="osgiHelpers.ts"/>
var Osgi;
(function (Osgi) {
    Osgi._module = angular
        .module(Osgi.pluginName, [
        'infinite-scroll',
        Osgi.bundlesModule,
        Osgi.configurationModule,
        Osgi.frameworkModule
    ])
        .component('osgi', Osgi.osgiComponent);
    Osgi._module.config(["$routeProvider", function ($routeProvider) {
            $routeProvider
                .when('/osgi/bundles', { template: '<bundles></bundles>' })
                .when('/osgi/bundles/:bundleId', { templateUrl: 'plugins/osgi/html/bundle.html' })
                .when('/osgi/services', { templateUrl: 'plugins/osgi/html/services.html' })
                .when('/osgi/packages', { templateUrl: 'plugins/osgi/html/packages.html' })
                .when('/osgi/configurations', { templateUrl: 'plugins/osgi/html/configurations.html' })
                .when('/osgi/configurations/:id', { template: '<osgi-configuration></osgi-configuration>' })
                .when('/osgi/fwk', { template: '<framework></framework>' });
        }]);
    Osgi._module.run(["mainNavService", "workspace", "helpRegistry", function (mainNavService, workspace, helpRegistry) {
            helpRegistry.addUserDoc('osgi', 'plugins/osgi/doc/help.md', function () {
                return workspace.treeContainsDomainAndProperties("osgi.core");
            });
            mainNavService.addItem({
                title: 'OSGi',
                basePath: '/osgi',
                template: '<osgi></osgi>',
                isValid: function () { return workspace.treeContainsDomainAndProperties("osgi.core"); }
            });
        }]);
    Osgi._module.factory('osgiDataService', ["workspace", "jolokia", function (workspace, jolokia) {
            return new Osgi.OsgiDataService(workspace, jolokia);
        }]);
    hawtioPluginLoader.addModule(Osgi.pluginName);
})(Osgi || (Osgi = {}));
var SpringBoot;
(function (SpringBoot) {
    var Health = /** @class */ (function () {
        function Health(global, details) {
            this.global = global;
            this.details = details;
        }
        return Health;
    }());
    SpringBoot.Health = Health;
})(SpringBoot || (SpringBoot = {}));
/// <reference path="health.ts"/>
/// <reference path="../common/endpoint-mbean.ts"/>
var SpringBoot;
(function (SpringBoot) {
    var HealthService = /** @class */ (function () {
        HealthService.$inject = ["jolokiaService", "humanizeService", "springBootService"];
        function HealthService(jolokiaService, humanizeService, springBootService) {
            'ngInject';
            this.jolokiaService = jolokiaService;
            this.humanizeService = humanizeService;
            this.springBootService = springBootService;
            this.sortByFirstValue = function (pairA, pairB) {
                var nameA = pairA[0].toLowerCase();
                var nameB = pairB[0].toLowerCase();
                if (nameA === 'status') {
                    return -1;
                }
                if (nameB === 'status') {
                    return 1;
                }
                if (nameA < nameB) {
                    return -1;
                }
                if (nameA > nameB) {
                    return 1;
                }
                return 0;
            };
        }
        HealthService.prototype.getHealth = function () {
            var _this = this;
            SpringBoot.log.debug('Fetch health data');
            var mbean = this.springBootService.getEndpointMBean(['healthEndpoint', 'Health'], ['getData', 'health']);
            return this.jolokiaService.execute(mbean.objectName, mbean.operation)
                .then(function (response) {
                var details = response.details ? response.details : response;
                var globalItem = _this.getGlobalCard(response);
                var items = _this.getDetailCards(details);
                return new SpringBoot.Health(globalItem, items);
            });
        };
        HealthService.prototype.getGlobalCard = function (data) {
            return {
                title: 'Overall status: ' + data.status,
                iconClass: this.getIconClass(data.status)
            };
        };
        HealthService.prototype.getDetailCards = function (data) {
            var _this = this;
            return _.toPairs(data)
                .filter(function (pair) { return _.isObject(pair[1]); })
                .sort(this.sortByFirstValue)
                .map(function (pair) { return ({
                title: _this.humanizeService.toSentenceCase(pair[0]),
                iconClass: _this.getIconClass(pair[1]['status']),
                info: _this.buildInfo(pair[1])
            }); });
        };
        HealthService.prototype.buildInfo = function (obj) {
            var _this = this;
            return _.toPairs(obj)
                .sort(this.sortByFirstValue)
                .map(function (pair) {
                var result = null;
                if (_.isObject(pair[1])) {
                    result = '<ul>' +
                        '<span class="info-item-label">' + _this.humanizeService.toSentenceCase(pair[0]) + '</span>' +
                        '<li>' +
                        _this.buildInfo(pair[1]).join('') +
                        '</li></ul>';
                }
                else {
                    result = '<ul><li>' +
                        '<span class="info-item-label">' + _this.humanizeService.toSentenceCase(pair[0]) + ': </span>' +
                        pair[1] +
                        '</li></ul>';
                }
                return result;
            });
        };
        HealthService.prototype.getIconClass = function (status) {
            switch (status) {
                case 'UP':
                    return 'pficon pficon-ok';
                case 'DOWN':
                    return 'pficon pficon-error-circle-o';
                case 'OUT_OF_SERVICE':
                    return 'pficon pficon-warning-triangle-o';
                case 'UNKNOWN':
                    return 'pficon pficon-help';
                default:
                    return 'pficon pficon-info';
            }
        };
        return HealthService;
    }());
    SpringBoot.HealthService = HealthService;
})(SpringBoot || (SpringBoot = {}));
/// <reference path="health.service.ts"/>
/// <reference path="health.ts"/>
var SpringBoot;
(function (SpringBoot) {
    var HealthController = /** @class */ (function () {
        HealthController.$inject = ["$timeout", "healthService"];
        function HealthController($timeout, healthService) {
            'ngInject';
            this.$timeout = $timeout;
            this.healthService = healthService;
            this.reloadDelay = 20000;
        }
        HealthController.prototype.$onInit = function () {
            this.loadDataPeriodically();
        };
        HealthController.prototype.$onDestroy = function () {
            this.cancelTimer();
        };
        HealthController.prototype.loadDataPeriodically = function () {
            var _this = this;
            this.healthService.getHealth()
                .then(function (health) { return _this.health = health; })
                .then(function () { return _this.promise = _this.$timeout(function () { return _this.loadDataPeriodically(); }, _this.reloadDelay); });
        };
        HealthController.prototype.cancelTimer = function () {
            this.$timeout.cancel(this.promise);
        };
        return HealthController;
    }());
    SpringBoot.HealthController = HealthController;
    SpringBoot.healthComponent = {
        template: "\n      <div class=\"spring-boot-health-main\">\n        <h1>Health</h1>\n        <div class=\"cards-pf\" ng-if=\"$ctrl.health\">\n          <div class=\"container-fluid container-cards-pf\">\n            <div class=\"row row-cards-pf\">\n              <div class=\"col-lg-12\">\n                <pf-info-status-card status=\"$ctrl.health.global\" show-top-border=\"true\"></pf-info-status-card>\n              </div>\n              <div class=\"col-lg-12\" ng-repeat=\"item in $ctrl.health.details\">\n                <pf-info-status-card status=\"item\" html-content=\"true\"></pf-info-status-card>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    ",
        controller: HealthController
    };
})(SpringBoot || (SpringBoot = {}));
/// <reference path="health.component.ts"/>
/// <reference path="health.service.ts"/>
var SpringBoot;
(function (SpringBoot) {
    SpringBoot.healthModule = angular
        .module('spring-boot-health', [])
        .component('springBootHealth', SpringBoot.healthComponent)
        .service('healthService', SpringBoot.HealthService)
        .name;
})(SpringBoot || (SpringBoot = {}));
var SpringBoot;
(function (SpringBoot) {
    var Trace = /** @class */ (function () {
        function Trace(trace) {
            this.timestamp = trace.timestamp;
            if (trace.info) {
                this.method = trace.info.method;
                this.path = trace.info.path;
                this.info = trace.info;
                if (trace.info.timeTaken) {
                    this.timeTaken = parseInt(trace.info.timeTaken);
                }
                if (trace.info.headers.response) {
                    this.httpStatusCode = parseInt(this.info.headers.response.status);
                }
            }
            else if (trace.request) {
                this.method = trace.request.method;
                this.path = new URL(trace.request.uri).pathname;
                this.info = trace;
                if (trace.timeTaken) {
                    this.timeTaken = parseInt(trace.timeTaken);
                }
                if (trace.response && trace.response.status) {
                    this.httpStatusCode = parseInt(trace.response.status);
                }
            }
        }
        return Trace;
    }());
    SpringBoot.Trace = Trace;
})(SpringBoot || (SpringBoot = {}));
/// <reference path="trace.ts"/>
/// <reference path="../common/endpoint-mbean.ts"/>
var SpringBoot;
(function (SpringBoot) {
    var TraceService = /** @class */ (function () {
        TraceService.$inject = ["jolokiaService", "springBootService"];
        function TraceService(jolokiaService, springBootService) {
            'ngInject';
            this.jolokiaService = jolokiaService;
            this.springBootService = springBootService;
        }
        TraceService.prototype.getTraces = function () {
            var mbean = this.springBootService.getEndpointMBean(['traceEndpoint', 'Httptrace'], ['getData', 'traces']);
            return this.jolokiaService.execute(mbean.objectName, mbean.operation)
                .then(function (response) {
                var data = response.traces ? response.traces : response;
                return data.filter(function (trace) {
                    var path = trace.info ? trace.info.path : trace.request.uri;
                    // Avoid including our own jolokia requests in the results
                    return /.*?\/jolokia\/?(?:\/.*(?=$))?$/.test(path) === false;
                })
                    .map(function (traceEvent) { return new SpringBoot.Trace(traceEvent); });
            });
        };
        return TraceService;
    }());
    SpringBoot.TraceService = TraceService;
})(SpringBoot || (SpringBoot = {}));
/// <reference path="trace.service.ts"/>
var SpringBoot;
(function (SpringBoot) {
    var TraceController = /** @class */ (function () {
        TraceController.$inject = ["traceService", "$scope", "$filter", "$timeout", "$interval", "$uibModal"];
        function TraceController(traceService, $scope, $filter, $timeout, $interval, $uibModal) {
            'ngInject';
            var _this = this;
            this.traceService = traceService;
            this.$scope = $scope;
            this.$filter = $filter;
            this.$timeout = $timeout;
            this.$interval = $interval;
            this.$uibModal = $uibModal;
            this.toolbarConfig = {
                isTableView: true,
                filterConfig: {
                    fields: [
                        {
                            id: 'timestamp',
                            title: 'Timestamp',
                            placeholder: 'Filter by timestamp...',
                            filterType: 'text'
                        },
                        {
                            id: 'status',
                            title: 'HTTP Status',
                            placeholder: 'Filter by HTTP status...',
                            filterType: 'text'
                        },
                        {
                            id: 'method',
                            title: 'HTTP Method',
                            placeholder: 'Filter by HTTP method...',
                            filterType: 'select',
                            filterValues: ['GET', 'DELETE', 'HEAD', 'OPTIONS', 'PATCH', 'POST', 'PUT', 'TRACE']
                        },
                        {
                            id: 'path',
                            title: 'Path',
                            placeholder: 'Filter by path...',
                            filterType: 'text'
                        },
                        {
                            id: 'timeTaken',
                            title: 'Time Taken',
                            placeholder: 'Filter by time taken...',
                            filterType: 'number'
                        },
                    ],
                    onFilterChange: function (filters) {
                        _this.applyFilters(filters);
                    },
                    appliedFilters: [],
                    resultsCount: 0
                },
            };
            this.loading = true;
            this.traces = [];
            this.tableItems = [];
            this.dateFormat = "yyyy-MM-dd HH:mm:ss.sss";
        }
        TraceController.prototype.$onInit = function () {
            var _this = this;
            this.loadTraces();
            this.promise = this.$interval(function () { return _this.loadTraces(); }, 10000);
        };
        TraceController.prototype.$onDestroy = function () {
            this.$interval.cancel(this.promise);
        };
        TraceController.prototype.loadTraces = function () {
            var _this = this;
            this.loading = true;
            this.traceService.getTraces()
                .then(function (traces) {
                var _a;
                (_a = _this.traces).unshift.apply(_a, _this.aggregateTraces(traces));
                if (_this.traces.length > TraceController.CACHE_SIZE) {
                    var spliceFrom = (_this.traces.length) - (_this.traces.length - TraceController.CACHE_SIZE);
                    var splitAmount = _this.traces.length - TraceController.CACHE_SIZE;
                    _this.traces.splice(spliceFrom, splitAmount);
                }
                _this.applyFilters(_this.toolbarConfig.filterConfig.appliedFilters);
                _this.scrollIfRequired();
                _this.loading = false;
            });
        };
        TraceController.prototype.applyFilters = function (filters) {
            var _this = this;
            var filteredTraces = this.traces;
            var dateFilter = this.$filter('date');
            filters.forEach(function (filter) {
                var regExp = new RegExp(filter.value, 'i');
                switch (filter.id) {
                    case 'timestamp':
                        filteredTraces = filteredTraces.filter(function (trace) { return regExp.test(dateFilter(trace.timestamp, _this.dateFormat)); });
                        break;
                    case 'status':
                        filteredTraces = filteredTraces.filter(function (trace) { return parseInt(filter.value) === trace.httpStatusCode; });
                        break;
                    case 'method':
                        filteredTraces = filteredTraces.filter(function (trace) { return regExp.test(trace.method); });
                        break;
                    case 'path':
                        filteredTraces = filteredTraces.filter(function (trace) { return regExp.test(trace.path); });
                        break;
                    case 'timeTaken':
                        filteredTraces = filteredTraces.filter(function (trace) { return parseInt(filter.value) === trace.timeTaken; });
                        break;
                }
            });
            this.tableItems = filteredTraces;
            this.toolbarConfig.filterConfig.resultsCount = filteredTraces.length;
        };
        TraceController.prototype.getStatusClass = function (trace) {
            if (trace.httpStatusCode) {
                if (trace.httpStatusCode < 400) {
                    return 'http-status-code-icon pficon pficon-ok';
                }
                else {
                    return 'http-status-code-icon pficon pficon-error-circle-o';
                }
            }
            return '';
        };
        TraceController.prototype.openTraceModal = function (trace) {
            this.$scope.trace = trace;
            this.$uibModal.open({
                templateUrl: 'traceDetailsModal.html',
                scope: this.$scope,
                size: 'lg',
                appendTo: $(document.querySelector('.spring-boot-trace-main'))
            });
        };
        TraceController.prototype.aggregateTraces = function (traces) {
            var _this = this;
            var aggregatedTraces = [];
            traces.forEach(function (trace) {
                var match = false;
                _this.traces.forEach(function (existingTrace) {
                    if (existingTrace.timestamp === trace.timestamp &&
                        existingTrace.method === trace.method &&
                        existingTrace.path === trace.path) {
                        match = true;
                        return;
                    }
                });
                if (!match) {
                    aggregatedTraces.push(trace);
                }
            });
            return aggregatedTraces;
        };
        TraceController.prototype.scrollIfRequired = function () {
            var scrollableTable = document.querySelector('.spring-boot-trace-scrollable-table');
            if (scrollableTable !== null && scrollableTable.scrollTop === 0) {
                this.$timeout(function () { return scrollableTable.scrollTop = 0; }, 0);
            }
        };
        TraceController.CACHE_SIZE = 500;
        return TraceController;
    }());
    SpringBoot.TraceController = TraceController;
    SpringBoot.traceComponent = {
        templateUrl: 'plugins/spring-boot/trace/trace.html',
        controller: TraceController,
    };
})(SpringBoot || (SpringBoot = {}));
/// <reference path="trace.component.ts"/>
/// <reference path="trace.service.ts"/>
var SpringBoot;
(function (SpringBoot) {
    SpringBoot.traceModule = angular
        .module('spring-boot-trace', [])
        .component('springBootTrace', SpringBoot.traceComponent)
        .service('traceService', SpringBoot.TraceService)
        .name;
})(SpringBoot || (SpringBoot = {}));
/// <reference path="logger.ts"/>
/// <reference path="../common/endpoint-mbean.ts"/>
var SpringBoot;
(function (SpringBoot) {
    var LoggersService = /** @class */ (function () {
        LoggersService.$inject = ["jolokiaService", "springBootService"];
        function LoggersService(jolokiaService, springBootService) {
            'ngInject';
            this.jolokiaService = jolokiaService;
            this.springBootService = springBootService;
        }
        LoggersService.prototype.getLoggerConfiguration = function () {
            var mbean = this.springBootService.getEndpointMBean(['loggersEndpoint', 'Loggers'], ['getLoggers', 'loggers']);
            return this.jolokiaService.execute(mbean.objectName, mbean.operation)
                .then(function (data) {
                var loggers = [];
                angular.forEach(data.loggers, function (loggerInfo, loggerName) {
                    var logger = {
                        name: loggerName,
                        configuredLevel: loggerInfo.configuredLevel == null ? loggerInfo.effectiveLevel : loggerInfo.configuredLevel,
                        effectiveLevel: loggerInfo.effectiveLevel
                    };
                    loggers.push(logger);
                });
                var loggerConfiguration = {
                    levels: data.levels,
                    loggers: loggers
                };
                return loggerConfiguration;
            });
        };
        LoggersService.prototype.setLoggerLevel = function (logger) {
            var mbean = this.springBootService.getEndpointMBean(['loggersEndpoint', 'Loggers'], ['setLogLevel', 'configureLogLevel']);
            return this.jolokiaService.execute(mbean.objectName, mbean.operation, logger.name, logger.configuredLevel);
        };
        return LoggersService;
    }());
    SpringBoot.LoggersService = LoggersService;
})(SpringBoot || (SpringBoot = {}));
/// <reference path="loggers.service.ts"/>
/// <reference path="logger.ts"/>
var SpringBoot;
(function (SpringBoot) {
    var LoggersController = /** @class */ (function () {
        LoggersController.$inject = ["loggersService"];
        function LoggersController(loggersService) {
            'ngInject';
            var _this = this;
            this.loggersService = loggersService;
            this.filterFields = [
                {
                    id: 'name',
                    title: 'Logger Name',
                    placeholder: 'Filter by logger name...',
                    filterType: 'text'
                },
                {
                    id: 'level',
                    title: 'Log Level',
                    placeholder: 'Filter by log level...',
                    filterType: 'select',
                    filterValues: []
                }
            ];
            this.filterConfig = {
                fields: this.filterFields,
                onFilterChange: function (filters) {
                    _this.applyFilters(filters);
                },
                appliedFilters: [],
                resultsCount: 0
            };
            this.toolbarConfig = {
                filterConfig: this.filterConfig,
                isTableView: false
            };
            this.pageSize = 10;
            this.pageNumber = 1;
            this.loading = true;
            this.loggers = [];
            this.tableItems = [];
        }
        LoggersController.prototype.$onInit = function () {
            this.loadData();
        };
        LoggersController.prototype.loadData = function () {
            var _this = this;
            this.loggersService.getLoggerConfiguration().then(function (logConfiguration) {
                _this.loggers = logConfiguration.loggers;
                _this.loggerLevels = logConfiguration.levels;
                _this.tableItems = logConfiguration.loggers;
                _this.filterConfig.resultsCount = logConfiguration.loggers.length;
                _this.filterFields[1]['filterValues'] = logConfiguration.levels;
                _this.numTotalItems = _this.tableItems.length;
                if (_this.filterConfig.appliedFilters.length > 0) {
                    _this.applyFilters(_this.filterConfig.appliedFilters);
                }
                _this.loading = false;
            }).catch(function (error) { return Core.notification('danger', error); });
        };
        LoggersController.prototype.setLoggerLevel = function (logger) {
            var _this = this;
            this.loggersService.setLoggerLevel(logger).then(function () {
                _this.loadData();
            }).catch(function (error) { return Core.notification('danger', error); });
        };
        LoggersController.prototype.applyFilters = function (filters) {
            var filteredLoggers = this.loggers;
            filters.forEach(function (filter) {
                var regExp = new RegExp(filter.value, 'i');
                switch (filter.id) {
                    case 'name':
                        filteredLoggers = filteredLoggers.filter(function (logger) { return logger.name.match(regExp) !== null; });
                        break;
                    case 'level':
                        filteredLoggers = filteredLoggers.filter(function (logger) { return logger.effectiveLevel.match(regExp) !== null; });
                        break;
                }
            });
            this.tableItems = filteredLoggers;
            this.numTotalItems = filteredLoggers.length;
            this.toolbarConfig.filterConfig.resultsCount = filteredLoggers.length;
        };
        LoggersController.prototype.orderLoggers = function (item) {
            if (item.name === 'ROOT') {
                return -1;
            }
            else
                return item.name;
        };
        return LoggersController;
    }());
    SpringBoot.LoggersController = LoggersController;
    SpringBoot.loggersComponent = {
        template: "\n      <div class=\"spring-boot-loggers-main\">\n        <h1>Loggers</h1>\n        <div class=\"blank-slate-pf no-border\" ng-if=\"$ctrl.loading === false && $ctrl.loggers.length === 0\">\n          <div class=\"blank-slate-pf-icon\">\n            <span class=\"pficon pficon pficon-warning-triangle-o\"></span>\n          </div>\n          <h1>No Spring Boot Loggers</h1>\n          <p>There are no loggers to display for this application.</p>\n          <p>Check your Spring Boot logging configuration.</p>\n        </div>\n        <div ng-show=\"$ctrl.loggers.length > 0\">\n          <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n          <ul class=\"list-group spring-boot-loggers-list-group\">\n            <li class=\"list-group-item\"\n                ng-repeat=\"item in $ctrl.tableItems | orderBy : $ctrl.orderLoggers | startFrom:($ctrl.pageNumber - 1) * $ctrl.pageSize | limitTo: $ctrl.pageSize\">\n                <div title=\"Logger Level\">\n                  <select ng-model=\"item.configuredLevel\"\n                          ng-options=\"level for level in $ctrl.loggerLevels\"\n                          ng-change=\"$ctrl.setLoggerLevel(item)\"\n                          ng-selected=\"item.effectiveLevel === level\">\n                  </select>\n                </div>\n                <div class=\"list-group-item-heading\">{{item.name}}</div>\n            </li>\n          </ul>\n          <pf-pagination\n            page-size=\"$ctrl.pageSize\"\n            page-number=\"$ctrl.pageNumber\"\n            num-total-items=\"$ctrl.numTotalItems\">\n          </pf-pagination>\n        </div>\n      </div>\n    ",
        controller: LoggersController
    };
})(SpringBoot || (SpringBoot = {}));
/// <reference path="loggers.component.ts"/>
/// <reference path="loggers.service.ts"/>
var SpringBoot;
(function (SpringBoot) {
    SpringBoot.loggersModule = angular
        .module('spring-boot-loggers', [])
        .component('springBootLoggers', SpringBoot.loggersComponent)
        .service('loggersService', SpringBoot.LoggersService)
        .name;
})(SpringBoot || (SpringBoot = {}));
var SpringBoot;
(function (SpringBoot) {
    var SpringBootService = /** @class */ (function () {
        SpringBootService.$inject = ["workspace"];
        function SpringBootService(workspace) {
            'ngInject';
            this.workspace = workspace;
        }
        SpringBootService.prototype.getTabs = function () {
            var tabs = [];
            if (this.hasEndpoint('healthEndpoint') || this.hasEndpoint('Health')) {
                tabs.push(new Nav.HawtioTab('Health', '/spring-boot/health'));
            }
            if (this.hasEndpoint('loggersEndpoint') || this.hasEndpoint('Loggers')) {
                tabs.push(new Nav.HawtioTab('Loggers', '/spring-boot/loggers'));
            }
            if (this.hasEndpoint('traceEndpoint') || this.hasEndpoint('Httptrace')) {
                tabs.push(new Nav.HawtioTab('Trace', '/spring-boot/trace'));
            }
            return tabs;
        };
        SpringBootService.prototype.getEndpointMBean = function (endpoints, operations) {
            var _this = this;
            var mbeans = endpoints
                .map(function (endpoint) { return _this.workspace.findMBeanWithProperties("org.springframework.boot", { type: 'Endpoint', name: endpoint }); })
                .filter(function (endpoint) { return endpoint !== null; });
            if (mbeans.length > 0) {
                var mbean_1 = mbeans[0];
                var ops = operations.filter(function (operation) { return mbean_1.mbean.op[operation]; });
                if (ops.length > 0) {
                    return { objectName: mbean_1.objectName, operation: ops[0] };
                }
            }
            return null;
        };
        SpringBootService.prototype.hasEndpoint = function (name) {
            return this.workspace.treeContainsDomainAndProperties('org.springframework.boot', { type: 'Endpoint', name: name });
        };
        return SpringBootService;
    }());
    SpringBoot.SpringBootService = SpringBootService;
})(SpringBoot || (SpringBoot = {}));
/// <reference path="spring-boot.service.ts"/>
var SpringBoot;
(function (SpringBoot) {
    configureRoutes.$inject = ["$routeProvider"];
    configureLayout.$inject = ["workspace", "springBootService", "mainNavService"];
    function configureRoutes($routeProvider) {
        'ngInject';
        $routeProvider
            .when('/spring-boot/health', { template: '<spring-boot-health></spring-boot-health>' })
            .when('/spring-boot/trace', { template: '<spring-boot-trace></spring-boot-trace>' })
            .when('/spring-boot/loggers', { template: '<spring-boot-loggers></spring-boot-loggers>' });
    }
    SpringBoot.configureRoutes = configureRoutes;
    function configureLayout(workspace, springBootService, mainNavService) {
        'ngInject';
        mainNavService.addItem({
            title: 'Spring Boot',
            href: '/spring-boot',
            template: '<spring-boot></spring-boot>',
            isValid: function () { return springBootService.getTabs().length > 0; }
        });
    }
    SpringBoot.configureLayout = configureLayout;
})(SpringBoot || (SpringBoot = {}));
/// <reference path="spring-boot.service.ts"/>
var SpringBoot;
(function (SpringBoot) {
    var SpringBootController = /** @class */ (function () {
        SpringBootController.$inject = ["springBootService"];
        function SpringBootController(springBootService) {
            'ngInject';
            this.springBootService = springBootService;
        }
        SpringBootController.prototype.$onInit = function () {
            this.tabs = this.springBootService.getTabs();
        };
        return SpringBootController;
    }());
    SpringBoot.SpringBootController = SpringBootController;
    SpringBoot.springBootComponent = {
        template: '<hawtio-tabs-layout tabs="$ctrl.tabs"></hawtio-tabs-layout>',
        controller: SpringBootController
    };
})(SpringBoot || (SpringBoot = {}));
/// <reference path="health/health.module.ts"/>
/// <reference path="trace/trace.module.ts"/>
/// <reference path="loggers/loggers.module.ts"/>
/// <reference path="spring-boot.config.ts"/>
/// <reference path="spring-boot.component.ts"/>
/// <reference path="spring-boot.service.ts"/>
var SpringBoot;
(function (SpringBoot) {
    SpringBoot.springBootModule = angular
        .module('hawtio-integration-spring-boot', [
        SpringBoot.healthModule,
        SpringBoot.loggersModule,
        SpringBoot.traceModule
    ])
        .config(SpringBoot.configureRoutes)
        .run(SpringBoot.configureLayout)
        .component('springBoot', SpringBoot.springBootComponent)
        .service('springBootService', SpringBoot.SpringBootService)
        .name;
    SpringBoot.log = Logger.get(SpringBoot.springBootModule);
})(SpringBoot || (SpringBoot = {}));
/// <reference path="activemq/ts/activemqPlugin.ts"/>
/// <reference path="camel/ts/camelPlugin.ts"/>
/// <reference path="osgi/ts/osgiPlugin.ts"/>
/// <reference path="spring-boot/spring-boot.module.ts"/>
var Integration;
(function (Integration) {
    Integration.integrationModule = angular
        .module('hawtio-integration', [
        ActiveMQ._module.name,
        Camel._module.name,
        Osgi._module.name,
        SpringBoot.springBootModule
    ])
        .run(Integration.configureAboutPage)
        .name;
    hawtioPluginLoader.addModule(Integration.integrationModule);
})(Integration || (Integration = {}));
/// <reference path="activemqHelpers.ts"/>
/// <reference path="activemqPlugin.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ.BrowseQueueController = ActiveMQ._module.controller("ActiveMQ.BrowseQueueController", ["$scope", "workspace", "jolokia", "localStorage", '$location', "activeMQMessage", "$timeout", "$routeParams", "$dialog", "$templateCache", function ($scope, workspace, jolokia, localStorage, $location, activeMQMessage, $timeout, $routeParams, $dialog, $templateCache) {
            var amqJmxDomain = localStorage['activemqJmxDomain'] || "org.apache.activemq";
            // all the queue names from the tree
            $scope.queueNames = [];
            // selected queue name in move dialog
            $scope.queueName = $routeParams["queueName"];
            $scope.searchText = '';
            $scope.workspace = workspace;
            $scope.allMessages = [];
            $scope.messages = [];
            $scope.headers = {};
            $scope.mode = 'text';
            $scope.showButtons = true;
            $scope.deleteDialog = false;
            $scope.moveDialog = false;
            $scope.gridOptions = {
                selectedItems: [],
                data: 'messages',
                displayFooter: false,
                showFilter: false,
                showColumnMenu: true,
                enableColumnResize: true,
                enableColumnReordering: true,
                enableHighlighting: true,
                filterOptions: {
                    filterText: '',
                    useExternalFilter: true
                },
                selectWithCheckboxOnly: true,
                showSelectionCheckbox: true,
                maintainColumnRatios: false,
                columnDefs: [
                    {
                        field: 'JMSMessageID',
                        displayName: 'Message ID',
                        cellTemplate: '<div class="ngCellText"><a href="" ng-click="row.entity.openMessageDialog(row)">{{row.entity.JMSMessageID}}</a></div>',
                        // for ng-grid
                        width: '34%'
                        // for hawtio-datatable
                        // width: "22em"
                    },
                    {
                        field: 'JMSType',
                        displayName: 'Type',
                        width: '10%'
                    },
                    {
                        field: 'JMSPriority',
                        displayName: 'Priority',
                        width: '7%'
                    },
                    {
                        field: 'JMSTimestamp',
                        displayName: 'Timestamp',
                        width: '19%'
                    },
                    {
                        field: 'JMSExpiration',
                        displayName: 'Expires',
                        width: '10%'
                    },
                    {
                        field: 'JMSReplyTo',
                        displayName: 'Reply To',
                        width: '10%'
                    },
                    {
                        field: 'JMSCorrelationID',
                        displayName: 'Correlation ID',
                        width: '10%'
                    }
                ],
                primaryKeyFn: function (entity) { return entity.JMSMessageID; }
            };
            $scope.showMessageDetails = false;
            // openMessageDialog is for the dialog itself so we should skip that guy
            var ignoreColumns = ["PropertiesText", "BodyPreview", "Text", "openMessageDialog"];
            var flattenColumns = ["BooleanProperties", "ByteProperties", "ShortProperties", "IntProperties", "LongProperties", "FloatProperties",
                "DoubleProperties", "StringProperties"];
            $scope.$watch('gridOptions.filterOptions.filterText', function (filterText) {
                filterMessages(filterText);
            });
            $scope.openMessageDialog = function (message) {
                ActiveMQ.selectCurrentMessage(message, "JMSMessageID", $scope);
                if ($scope.row) {
                    $scope.mode = CodeEditor.detectTextFormat($scope.row.Text);
                    $scope.showMessageDetails = true;
                }
            };
            $scope.refresh = loadTable;
            ActiveMQ.decorate($scope);
            $scope.moveMessages = function () {
                var selection = workspace.selection;
                var mbean = selection.objectName;
                if (!mbean || !selection || !$scope.queueName) {
                    return;
                }
                var selectedItems = $scope.gridOptions.selectedItems;
                $scope.message = "Moved " + Core.maybePlural(selectedItems.length, "message") + " to " + $scope.queueName;
                var operation = "moveMessageTo(java.lang.String, java.lang.String)";
                angular.forEach(selectedItems, function (item, idx) {
                    var id = item.JMSMessageID;
                    if (id) {
                        var callback = (idx + 1 < selectedItems.length) ? intermediateResult : moveSuccess;
                        jolokia.execute(mbean, operation, id, $scope.queueName, Core.onSuccess(callback));
                    }
                });
            };
            $scope.resendMessage = function () {
                var selection = workspace.selection;
                var mbean = selection.objectName;
                if (mbean && selection) {
                    var selectedItems = $scope.gridOptions.selectedItems;
                    //always assume a single message
                    activeMQMessage.message = selectedItems[0];
                    $location.path('activemq/sendMessage');
                }
            };
            $scope.deleteMessages = function () {
                var selection = workspace.selection;
                var mbean = selection.objectName;
                if (!mbean || !selection) {
                    return;
                }
                var selectedItems = $scope.gridOptions.selectedItems;
                if (!selectedItems || selectedItems.length === 0) {
                    return;
                }
                $scope.message = "Deleted " + Core.maybePlural(selectedItems.length, "message");
                var operation = "removeMessage(java.lang.String)";
                angular.forEach(selectedItems, function (item, idx) {
                    var id = item.JMSMessageID;
                    if (id) {
                        var callback = (idx + 1 < selectedItems.length) ? intermediateResult : operationSuccess;
                        jolokia.execute(mbean, operation, id, Core.onSuccess(callback));
                    }
                });
            };
            $scope.retryMessages = function () {
                var selection = workspace.selection;
                var mbean = selection.objectName;
                if (mbean && selection) {
                    var selectedItems = $scope.gridOptions.selectedItems;
                    $scope.message = "Retry " + Core.maybePlural(selectedItems.length, "message");
                    var operation = "retryMessage(java.lang.String)";
                    angular.forEach(selectedItems, function (item, idx) {
                        var id = item.JMSMessageID;
                        if (id) {
                            var callback = (idx + 1 < selectedItems.length) ? intermediateResult : operationSuccess;
                            jolokia.execute(mbean, operation, id, Core.onSuccess(callback));
                        }
                    });
                }
            };
            function populateTable(response) {
                // setup queue names
                if ($scope.queueNames.length === 0) {
                    var queueNames = ActiveMQ.retrieveQueueNames(workspace, true);
                    var selectedQueue = workspace.selection.text;
                    $scope.queueNames = queueNames.filter(function (name) { return name !== selectedQueue; });
                }
                var data = response.value;
                if (!angular.isArray(data)) {
                    $scope.allMessages = [];
                    angular.forEach(data, function (value, idx) {
                        $scope.allMessages.push(value);
                    });
                }
                else {
                    $scope.allMessages = data;
                }
                angular.forEach($scope.allMessages, function (message) {
                    message.openMessageDialog = $scope.openMessageDialog;
                    message.headerHtml = createHeaderHtml(message);
                    message.bodyText = createBodyText(message);
                });
                filterMessages($scope.gridOptions.filterOptions.filterText);
                Core.$apply($scope);
            }
            /*
             * For some reason using ng-repeat in the modal dialog doesn't work so lets
             * just create the HTML in code :)
             */
            function createBodyText(message) {
                if (message.Text) {
                    var body = message.Text;
                    var lenTxt = "" + body.length;
                    message.textMode = "text (" + lenTxt + " chars)";
                    return body;
                }
                else if (message.BodyPreview) {
                    var code = Core.parseIntValue(localStorage["activemqBrowseBytesMessages"] || "1", "browse bytes messages");
                    var body;
                    message.textMode = "bytes (turned off)";
                    if (code != 99) {
                        var bytesArr = [];
                        var textArr = [];
                        message.BodyPreview.forEach(function (b) {
                            if (code === 1 || code === 2) {
                                // text
                                textArr.push(String.fromCharCode(b));
                            }
                            if (code === 1 || code === 4) {
                                // hex and must be 2 digit so they space out evenly
                                var s = b.toString(16);
                                if (s.length === 1) {
                                    s = "0" + s;
                                }
                                bytesArr.push(s);
                            }
                            else {
                                // just show as is without spacing out, as that is usually more used for hex than decimal
                                var s = b.toString(10);
                                bytesArr.push(s);
                            }
                        });
                        var bytesData = bytesArr.join(" ");
                        var textData = textArr.join("");
                        if (code === 1 || code === 2) {
                            // bytes and text
                            var len = message.BodyPreview.length;
                            var lenTxt = "" + textArr.length;
                            body = "bytes:\n" + bytesData + "\n\ntext:\n" + textData;
                            message.textMode = "bytes (" + len + " bytes) and text (" + lenTxt + " chars)";
                        }
                        else {
                            // bytes only
                            var len = message.BodyPreview.length;
                            body = bytesData;
                            message.textMode = "bytes (" + len + " bytes)";
                        }
                    }
                    return body;
                }
                else {
                    message.textMode = "unsupported";
                    return "Unsupported message body type which cannot be displayed by hawtio";
                }
            }
            /*
             * For some reason using ng-repeat in the modal dialog doesn't work so lets
             * just create the HTML in code :)
             */
            function createHeaderHtml(message) {
                var headers = createHeaders(message);
                var properties = createProperties(message);
                var headerKeys = _.keys(headers);
                function sort(a, b) {
                    if (a > b)
                        return 1;
                    if (a < b)
                        return -1;
                    return 0;
                }
                var propertiesKeys = _.keys(properties).sort(sort);
                var jmsHeaders = _.filter(headerKeys, function (key) { return _.startsWith(key, "JMS"); }).sort(sort);
                var remaining = _.difference(headerKeys, jmsHeaders.concat(propertiesKeys)).sort(sort);
                var buffer = [];
                function appendHeader(key) {
                    var value = headers[key];
                    if (value === null) {
                        value = '';
                    }
                    buffer.push('<tr><td class="propertyName"><span class="green">Header</span> - ' +
                        key +
                        '</td><td class="property-value">' +
                        value +
                        '</td></tr>');
                }
                function appendProperty(key) {
                    var value = properties[key];
                    if (value === null) {
                        value = '';
                    }
                    buffer.push('<tr><td class="propertyName">' +
                        key +
                        '</td><td class="property-value">' +
                        value +
                        '</td></tr>');
                }
                jmsHeaders.forEach(appendHeader);
                remaining.forEach(appendHeader);
                propertiesKeys.forEach(appendProperty);
                return buffer.join("\n");
            }
            function createHeaders(row) {
                var answer = {};
                angular.forEach(row, function (value, key) {
                    if (!_.some(ignoreColumns, function (k) { return k === key; }) && !_.some(flattenColumns, function (k) { return k === key; })) {
                        answer[_.escape(key)] = _.escape(value);
                    }
                });
                return answer;
            }
            function createProperties(row) {
                var answer = {};
                angular.forEach(row, function (value, key) {
                    if (!_.some(ignoreColumns, function (k) { return k === key; }) && _.some(flattenColumns, function (k) { return k === key; })) {
                        angular.forEach(value, function (v2, k2) {
                            answer['<span class="green">' + key.replace('Properties', ' Property') + '</span> - ' + _.escape(k2)] = _.escape(v2);
                        });
                    }
                });
                return answer;
            }
            function loadTable() {
                var objName;
                if ($scope.queueName) {
                    $scope.showButtons = false;
                    $scope.dlq = false;
                    var mbean = ActiveMQ.getBrokerMBean(workspace, jolokia, amqJmxDomain);
                    // browseQueue(java.lang.String) is not available until ActiveMQ 5.15.0
                    // https://issues.apache.org/jira/browse/AMQ-6435
                    jolokia.request({ type: 'exec', mbean: mbean, operation: 'browseQueue(java.lang.String)', arguments: [$scope.queueName] }, Core.onSuccess(populateTable, {
                        error: function (response) {
                            // try again with the old ActiveMQ API
                            $scope.queueName = null;
                            $scope.showButtons = true;
                            loadTable();
                        }
                    }));
                    $scope.queueName = null;
                }
                else {
                    if (workspace.selection) {
                        objName = workspace.selection.objectName;
                    }
                    else {
                        // in case of refresh
                        var key = $location.search()['nid'];
                        var node = workspace.keyToNodeMap[key];
                        objName = node.objectName;
                    }
                    if (objName) {
                        $scope.dlq = false;
                        jolokia.getAttribute(objName, "DLQ", Core.onSuccess(onDlq, { silent: true }));
                        jolokia.request({ type: 'exec', mbean: objName, operation: 'browse()' }, Core.onSuccess(populateTable));
                    }
                }
            }
            function onDlq(response) {
                $scope.dlq = response;
                Core.$apply($scope);
            }
            function intermediateResult() {
            }
            function operationSuccess() {
                deselectAll();
                Core.notification("success", $scope.message);
                setTimeout(loadTable, 50);
            }
            function moveSuccess() {
                operationSuccess();
                workspace.loadTree();
            }
            function filterMessages(filter) {
                var searchConditions = buildSearchConditions(filter);
                evalFilter(searchConditions);
            }
            function evalFilter(searchConditions) {
                if (!searchConditions || searchConditions.length === 0) {
                    $scope.messages = $scope.allMessages;
                }
                else {
                    ActiveMQ.log.debug("Filtering conditions:", searchConditions);
                    $scope.messages = $scope.allMessages.filter(function (message) {
                        ActiveMQ.log.debug("Message:", message);
                        var matched = true;
                        $.each(searchConditions, function (index, condition) {
                            if (!condition.column) {
                                matched = matched && evalMessage(message, condition.regex);
                            }
                            else {
                                matched = matched &&
                                    (message[condition.column] && condition.regex.test(message[condition.column])) ||
                                    (message.StringProperties && message.StringProperties[condition.column] && condition.regex.test(message.StringProperties[condition.column]));
                            }
                        });
                        return matched;
                    });
                }
            }
            function evalMessage(message, regex) {
                var jmsHeaders = ['JMSDestination', 'JMSDeliveryMode', 'JMSExpiration', 'JMSPriority', 'JMSMessageID', 'JMSTimestamp', 'JMSCorrelationID', 'JMSReplyTo', 'JMSType', 'JMSRedelivered'];
                for (var i = 0; i < jmsHeaders.length; i++) {
                    var header = jmsHeaders[i];
                    if (message[header] && regex.test(message[header])) {
                        return true;
                    }
                }
                if (message.StringProperties) {
                    for (var property in message.StringProperties) {
                        if (regex.test(message.StringProperties[property])) {
                            return true;
                        }
                    }
                }
                if (message.bodyText && regex.test(message.bodyText)) {
                    return true;
                }
                return false;
            }
            function getRegExp(str, modifiers) {
                try {
                    return new RegExp(str, modifiers);
                }
                catch (err) {
                    return new RegExp(str.replace(/(\^|\$|\(|\)|<|>|\[|\]|\{|\}|\\|\||\.|\*|\+|\?)/g, '\\$1'));
                }
            }
            function buildSearchConditions(filterText) {
                var searchConditions = [];
                var qStr;
                if (!(qStr = $.trim(filterText))) {
                    return;
                }
                var columnFilters = qStr.split(";");
                for (var i = 0; i < columnFilters.length; i++) {
                    var args = columnFilters[i].split(':');
                    if (args.length > 1) {
                        var columnName = $.trim(args[0]);
                        var columnValue = $.trim(args[1]);
                        if (columnName && columnValue) {
                            searchConditions.push({
                                column: columnName,
                                columnDisplay: columnName.replace(/\s+/g, '').toLowerCase(),
                                regex: getRegExp(columnValue, 'i')
                            });
                        }
                    }
                    else {
                        var val = $.trim(args[0]);
                        if (val) {
                            searchConditions.push({
                                column: '',
                                regex: getRegExp(val, 'i')
                            });
                        }
                    }
                }
                return searchConditions;
            }
            function deselectAll() {
                $scope.gridOptions.selectedItems = [];
            }
            $scope.refresh();
        }]);
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="activemqPlugin.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ._module.controller("ActiveMQ.QueuesController", ["$scope", "workspace", "jolokia", "localStorage", function ($scope, workspace, jolokia, localStorage) {
            var amqJmxDomain = localStorage['activemqJmxDomain'] || "org.apache.activemq";
            $scope.workspace = workspace;
            $scope.destinationType;
            var allDestinations = [];
            $scope.destinations = [];
            $scope.totalServerItems = 0;
            var refreshAction = {
                name: 'Refresh',
                actionFn: function (action) { return $scope.loadTable(); }
            };
            $scope.toolbarConfig = {
                filterConfig: {
                    fields: [
                        {
                            id: 'name',
                            title: 'Name',
                            placeholder: 'Filter by name...',
                            filterType: 'text'
                        }
                    ],
                    onFilterChange: function (filters) {
                        $scope.destinations = Pf.filter(allDestinations, $scope.toolbarConfig.filterConfig);
                    }
                },
                actionsConfig: {
                    primaryActions: [refreshAction]
                },
                isTableView: true
            };
            $scope.tableConfig = {
                selectionMatchProp: 'name',
                showCheckboxes: false
            };
            $scope.pageConfig = {
                pageSize: 20,
                pageNumber: 1
            };
            if ($scope.destinationType == 'topics') {
                $scope.tableColumns = [
                    { header: 'Name', itemField: 'name' },
                    { header: 'Producer Count', itemField: 'producerCount' },
                    { header: 'Consumer Count', itemField: 'consumerCount' },
                    { header: 'Enqueue Count', itemField: 'enqueueCount' },
                    { header: 'Dequeue Count', itemField: 'dequeueCount' }
                ];
            }
            else {
                $scope.tableColumns = [
                    { header: 'Name', itemField: 'name', templateFn: function (value) { return "<a href=\"activemq/browseQueue?main-tab=activemq&queueName=" + value + "\">" + value + "</a>"; } },
                    { header: 'Queue Size', itemField: 'queueSize' },
                    { header: 'Producer Count', itemField: 'producerCount' },
                    { header: 'Consumer Count', itemField: 'consumerCount' },
                    { header: 'Enqueue Count', itemField: 'enqueueCount' },
                    { header: 'Dequeue Count', itemField: 'dequeueCount' },
                    { header: 'Dispatch Count', itemField: 'dispatchCount' },
                ];
            }
            $scope.refresh = function () {
                $scope.loadTable();
            };
            $scope.loadTable = function () {
                var mbean = ActiveMQ.getBrokerMBean(workspace, jolokia, amqJmxDomain);
                if (mbean) {
                    var method = 'queryQueues(java.lang.String, int, int)';
                    if ($scope.destinationType == 'topics') {
                        method = 'queryTopics(java.lang.String, int, int)';
                    }
                    var destinationFilter = {
                        name: '',
                        filter: ''
                    };
                    var appliedFilters = $scope.toolbarConfig.filterConfig.appliedFilters;
                    if (appliedFilters && appliedFilters.length > 0) {
                        destinationFilter['filter'] = $scope.toolbarConfig.filterConfig.appliedFilters[0].value;
                    }
                    jolokia.request({ type: 'exec', mbean: mbean, operation: method, arguments: [JSON.stringify(destinationFilter), $scope.pageConfig.pageNumber, $scope.pageConfig.pageSize] }, Core.onSuccess(populateTable, { error: onError }));
                }
            };
            function onError() {
                Core.notification("danger", "The feature is not available in this broker version!");
                $scope.workspace.selectParentNode();
            }
            function populateTable(response) {
                var data = JSON.parse(response.value);
                $scope.destinations = [];
                angular.forEach(data["data"], function (value, idx) {
                    $scope.destinations.push(value);
                });
                $scope.totalServerItems = data["count"];
                allDestinations = $scope.destinations;
                $scope.destinations = Pf.filter(allDestinations, $scope.toolbarConfig.filterConfig);
                Core.$apply($scope);
            }
            $scope.loadTable();
        }]);
})(ActiveMQ || (ActiveMQ = {}));
/// <reference path="activemqHelpers.ts"/>
/// <reference path="activemqPlugin.ts"/>
var ActiveMQ;
(function (ActiveMQ) {
    ActiveMQ._module.controller("ActiveMQ.DurableSubscriberController", ["$scope", "$uibModal", "workspace", "jolokia", function ($scope, $uibModal, workspace, jolokia) {
            var amqJmxDomain = localStorage['activemqJmxDomain'] || "org.apache.activemq";
            var allSubscribers = null;
            $scope.durableSubscribers = null;
            $scope.selectedSubscriber;
            $scope.createSubscriberDialog;
            $scope.deleteSubscriberDialog = new UI.Dialog();
            $scope.showSubscriberDialog;
            $scope.topicName = '';
            $scope.clientId = '';
            $scope.subscriberName