/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.quarkus.deployment;

import io.hawt.quarkus.HawtioConfig;
import io.hawt.quarkus.HawtioProducers;
import io.hawt.quarkus.HawtioRecorder;
import io.hawt.quarkus.auth.HawtioQuarkusAuthenticator;
import io.hawt.quarkus.filters.HawtioQuarkusAuthenticationFilter;
import io.hawt.quarkus.filters.HawtioQuarkusLoginRedirectFilter;
import io.hawt.quarkus.filters.HawtioQuarkusPathFilter;
import io.hawt.quarkus.servlets.HawtioQuakusLoginServlet;
import io.hawt.quarkus.servlets.HawtioQuakusLogoutServlet;
import io.hawt.web.auth.AuthenticationFilter;
import io.hawt.web.auth.LoginRedirectFilter;
import io.hawt.web.auth.LoginServlet;
import io.hawt.web.auth.LogoutServlet;
import io.hawt.web.filters.BaseTagHrefFilter;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.quarkus.undertow.deployment.ListenerBuildItem;
import io.quarkus.undertow.deployment.MPConfigPropertyResolver;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.parser.servlet.WebMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.metadata.property.PropertyResolver;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class HawtioProcessor {
    private static final Set<String> DISALLOWED_SERVLETS = Set.of("io.hawt.web.plugin.PluginServlet");
    private static final Set<String> DISALLOWED_FILTERS = Collections.emptySet();
    private static final Set<String> DISALLOWED_LISTENERS = Collections.emptySet();
    private static final Map<String, String> WEB_XML_OVERRIDES = Map.of(LoginServlet.class.getName(), HawtioQuakusLoginServlet.class.getName(), LogoutServlet.class.getName(), HawtioQuakusLogoutServlet.class.getName(), LoginRedirectFilter.class.getName(), HawtioQuarkusLoginRedirectFilter.class.getName(), AuthenticationFilter.class.getName(), HawtioQuarkusAuthenticationFilter.class.getName());
    private static final String FEATURE = "hawtio";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerHawtioBeans(BuildProducer<ServletBuildItem> servlet, BuildProducer<FilterBuildItem> filter, BuildProducer<ListenerBuildItem> listener) throws Exception {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        MetaDataElementParser.DTDInfo dtdInfo = new MetaDataElementParser.DTDInfo();
        inputFactory.setXMLResolver((XMLResolver)dtdInfo);
        try (InputStream in = HawtioProcessor.class.getResourceAsStream("/META-INF/web.xml");){
            XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(in);
            WebMetaData result = WebMetaDataParser.parse((XMLStreamReader)xmlReader, (MetaDataElementParser.DTDInfo)dtdInfo, (PropertyReplacer)PropertyReplacers.resolvingReplacer((PropertyResolver)new MPConfigPropertyResolver()));
            this.registerServlets(result, servlet);
            this.registerFilters(result, filter);
            this.registerListeners(result, listener);
        }
    }

    private void registerServlets(WebMetaData webMetaData, BuildProducer<ServletBuildItem> servlet) {
        if (webMetaData.getServlets() == null) {
            return;
        }
        for (ServletMetaData servletMetaData : webMetaData.getServlets()) {
            if (DISALLOWED_SERVLETS.contains(servletMetaData.getServletClass())) continue;
            ServletBuildItem.Builder builder = ServletBuildItem.builder((String)servletMetaData.getServletName(), (String)this.getClassName(servletMetaData.getServletClass())).setLoadOnStartup(servletMetaData.getLoadOnStartupDefault());
            this.getServletMappings(webMetaData, servletMetaData.getName()).ifPresent(servletMappings -> servletMappings.getUrlPatterns().stream().map(s -> "/hawtio" + s).forEach(arg_0 -> ((ServletBuildItem.Builder)builder).addMapping(arg_0)));
            if (servletMetaData.getInitParam() != null) {
                servletMetaData.getInitParam().forEach(param -> builder.addInitParam(param.getParamName(), param.getParamValue()));
            }
            servlet.produce((BuildItem)builder.build());
        }
    }

    private void registerFilters(WebMetaData webMetaData, BuildProducer<FilterBuildItem> filter) {
        if (webMetaData.getFilters() != null) {
            for (FilterMetaData filterMetaData : webMetaData.getFilters()) {
                if (DISALLOWED_FILTERS.contains(filterMetaData.getFilterClass())) continue;
                FilterBuildItem.Builder builder = FilterBuildItem.builder((String)filterMetaData.getFilterName(), (String)this.getClassName(filterMetaData.getFilterClass()));
                if (filterMetaData.getFilterClass().equals(BaseTagHrefFilter.class.getName())) {
                    builder.addInitParam("applicationContextPath", "/hawtio");
                }
                this.getFilterMappings(webMetaData, filterMetaData.getName()).ifPresent(filterMappings -> {
                    for (String urlPattern : filterMappings.getUrlPatterns()) {
                        if (filterMappings.getDispatchers() != null) {
                            for (DispatcherType dispatcher : filterMappings.getDispatchers()) {
                                builder.addFilterUrlMapping("/hawtio" + urlPattern, javax.servlet.DispatcherType.valueOf((String)dispatcher.name()));
                            }
                            continue;
                        }
                        builder.addFilterUrlMapping("/hawtio" + urlPattern, javax.servlet.DispatcherType.REQUEST);
                    }
                });
                filter.produce((BuildItem)builder.build());
            }
        }
        FilterBuildItem pathHandler = FilterBuildItem.builder((String)"PathFilter", (String)HawtioQuarkusPathFilter.class.getName()).addFilterUrlMapping("/hawtio/*", javax.servlet.DispatcherType.REQUEST).build();
        filter.produce((BuildItem)pathHandler);
    }

    private void registerListeners(WebMetaData webMetaData, BuildProducer<ListenerBuildItem> listener) {
        if (webMetaData.getListeners() == null) {
            return;
        }
        for (ListenerMetaData listenerMetaData : webMetaData.getListeners()) {
            if (DISALLOWED_LISTENERS.contains(listenerMetaData.getListenerClass())) continue;
            listener.produce((BuildItem)new ListenerBuildItem(listenerMetaData.getListenerClass()));
        }
    }

    @BuildStep
    void unremoveableBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(HawtioProducers.class));
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(HawtioQuarkusAuthenticator.class));
    }

    @BuildStep
    void hawtioSystemProperties(BuildProducer<SystemPropertyBuildItem> systemProperties, HawtioConfig config, Capabilities capabilities) {
        if (config.authenticationEnabled.booleanValue() && !capabilities.isPresent("io.quarkus.security")) {
            throw new RuntimeException("Hawtio authentication is enabled but no Quarkus security extension is present. You must configure one or disable authentication");
        }
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem("hawtio.authenticationEnabled", config.authenticationEnabled.toString()));
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem("hawtio.keycloakEnabled", config.keycloakEnabled.toString()));
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem("hawtio.disableProxy", config.disableProxy.toString()));
        systemProperties.produce((BuildItem)new SystemPropertyBuildItem("hawtio.localAddressProbing", config.localAddressProbing.toString()));
        config.roles.map(roles -> new SystemPropertyBuildItem("hawtio.roles", String.join((CharSequence)",", roles))).ifPresent(arg_0 -> systemProperties.produce(arg_0));
        config.keycloakClientConfig.map(keycloakClientConfig -> new SystemPropertyBuildItem("hawtio.keycloakClientConfig", keycloakClientConfig)).ifPresent(arg_0 -> systemProperties.produce(arg_0));
        config.proxyAllowlist.map(allowlist -> new SystemPropertyBuildItem("hawtio.proxyAllowlist", String.join((CharSequence)",", allowlist))).ifPresent(arg_0 -> systemProperties.produce(arg_0));
        config.sessionTimeout.map(sessionTimeout -> new SystemPropertyBuildItem("hawtio.sessionTimeout", sessionTimeout.toString())).ifPresent(arg_0 -> systemProperties.produce(arg_0));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    RouteBuildItem hawtioPluginHandler(HawtioConfig config, HawtioRecorder recorder, Capabilities capabilities) {
        if (config.pluginConfigs == null || config.pluginConfigs.isEmpty()) {
            return null;
        }
        if (capabilities.isMissing("io.quarkus.jackson")) {
            throw new RuntimeException("Hawtio plugin support requires jackson. Please add a dependency for quarkus-jackson to your application");
        }
        return RouteBuildItem.builder().route("/hawtio/plugin").handler(recorder.pluginHandler(config.pluginConfigs)).build();
    }

    @BuildStep(onlyIf={NativeBuild.class})
    void nativeUnsupported() {
        throw new RuntimeException("The Hawtio Quarkus extension is not supported in native mode");
    }

    private String getClassName(String className) {
        if (WEB_XML_OVERRIDES.containsKey(className)) {
            return WEB_XML_OVERRIDES.get(className);
        }
        return className;
    }

    private Optional<ServletMappingMetaData> getServletMappings(WebMetaData metaData, String servletName) {
        return metaData.getServletMappings().stream().filter(servletMappingMetaData -> servletMappingMetaData.getServletName().equals(servletName)).findFirst();
    }

    private Optional<FilterMappingMetaData> getFilterMappings(WebMetaData metaData, String filterName) {
        return metaData.getFilterMappings().stream().filter(filterMappingMetaData -> filterMappingMetaData.getFilterName().equals(filterName)).findFirst();
    }
}

