/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.hawt.log.LogFilter;
import io.hawt.log.LogResults;
import io.hawt.log.support.LogQuerySupportMBean;
import io.hawt.log.support.Objects;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogQuerySupport
implements LogQuerySupportMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(LogQuerySupport.class);
    protected ObjectMapper mapper = new ObjectMapper();
    private ObjectName mbeanName;
    private MBeanServer mbeanServer;
    private String hostName;
    private volatile ObjectInstance objectInstance;

    protected LogQuerySupport() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("Failed to get host name: " + e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String loadString(URL url) throws IOException {
        InputStream is = url.openStream();
        if (is == null) {
            return null;
        }
        try {
            int n;
            InputStreamReader reader = new InputStreamReader(is);
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            writer.flush();
            String string = writer.toString();
            return string;
        }
        finally {
            is.close();
        }
    }

    public void start() {
        MBeanServer server = this.getMbeanServer();
        if (server != null) {
            this.registerMBeanServer(server);
        } else {
            LOG.error("No MBeanServer available so cannot register mbean");
        }
    }

    public void stop() {
        MBeanServer server = this.getMbeanServer();
        if (server != null) {
            this.unregisterMBeanServer(server);
        }
    }

    @Override
    public LogResults allLogResults() throws IOException {
        return this.getLogResults(-1);
    }

    @Override
    public LogResults logResultsSince(long time) throws IOException {
        LogFilter filter = new LogFilter();
        filter.setAfterTimestamp(time);
        return this.queryLogResults(filter);
    }

    @Override
    public String getLogEvents(int maxCount) throws IOException {
        LogResults results = this.getLogResults(maxCount);
        return this.toJSON(results);
    }

    @Override
    public String filterLogEvents(String jsonFilter) throws IOException {
        LogResults results = this.jsonQueryLogResults(jsonFilter);
        return this.toJSON(results);
    }

    @Override
    public LogResults jsonQueryLogResults(String jsonFilter) throws IOException {
        LogFilter filter = this.jsonToLogFilter(jsonFilter);
        return this.queryLogResults(filter);
    }

    public ObjectName getMbeanName() throws MalformedObjectNameException {
        if (this.mbeanName == null) {
            this.mbeanName = new ObjectName("hawtio:type=LogQuery");
        }
        return this.mbeanName;
    }

    public void setMbeanName(ObjectName mbeanName) {
        this.mbeanName = mbeanName;
    }

    public MBeanServer getMbeanServer() {
        if (this.mbeanServer == null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getMbeanName();
            if (mbeanServer.isRegistered(name)) {
                LOG.warn("MBean " + name + " is already registered!");
            } else {
                this.objectInstance = mbeanServer.registerMBean(this, name);
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name;
                ObjectName objectName = name = this.objectInstance != null ? this.objectInstance.getObjectName() : this.getMbeanName();
                if (name != null && mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                    this.objectInstance = null;
                }
            }
            catch (Exception e) {
                LOG.warn("An error occurred during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    protected String toJSON(Object answer) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            this.mapper.writeValue((Writer)writer, answer);
            return writer.toString();
        }
        catch (IOException e) {
            LOG.warn("Failed to marshal the events: " + e, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    protected LogFilter jsonToLogFilter(String json) throws IOException {
        if (json == null) {
            return null;
        }
        if ((json = json.trim()).length() == 0 || json.equals("{}")) {
            return null;
        }
        return (LogFilter)this.mapper.readerFor(LogFilter.class).readValue(json);
    }

    @Override
    public String getSource(String mavenCoords, String className, String filePath) throws IOException {
        int idx;
        String classNamePath = null;
        if (!Objects.isBlank(className)) {
            classNamePath = className.replace('.', '/') + ".java";
        }
        if (Objects.isBlank(filePath)) {
            filePath = classNamePath;
        } else if (filePath.lastIndexOf(47) <= 0 && classNamePath != null && (idx = classNamePath.lastIndexOf(47)) > 0) {
            filePath = classNamePath.substring(0, idx) + LogQuerySupport.ensureStartsWithSlash(filePath);
        }
        return this.getArtifactFile(mavenCoords, filePath, "sources");
    }

    @Override
    public String getJavaDoc(String mavenCoordinates, String filePath) throws IOException {
        return this.getArtifactFile(mavenCoordinates, filePath, "javadoc");
    }

    protected String getArtifactFile(String mavenCoords, String filePath, String classifier) throws IOException {
        filePath = LogQuerySupport.ensureStartsWithSlash(filePath);
        String coords = mavenCoords.replace(':', '/');
        String[] array = coords.split("\\s+");
        if (array == null || array.length < 2) {
            return this.loadCoords(coords, filePath, classifier);
        }
        if (this.isRoot(filePath)) {
            StringBuilder buffer = new StringBuilder();
            for (String coord : array) {
                try {
                    String text = this.loadCoords(coord, filePath, classifier);
                    if (text == null) continue;
                    buffer.append(text);
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("" + e);
                }
            }
            return buffer.toString();
        }
        for (String coord : array) {
            try {
                return this.loadCoords(coord, filePath, classifier);
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("" + e);
            }
        }
        return null;
    }

    protected String loadCoords(String coords, String filePath, String classifier) throws IOException {
        URL url = new URL("jar:mvn:" + coords + "/jar/" + classifier + "!" + filePath);
        if (this.isRoot(filePath)) {
            return this.jarIndex(url);
        }
        return LogQuerySupport.loadString(url);
    }

    protected String jarIndex(URL url) throws IOException {
        StringBuilder buffer = new StringBuilder();
        JarURLConnection uc = (JarURLConnection)url.openConnection();
        return this.jarIndex(uc.getJarFile());
    }

    protected String jarIndex(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        return this.jarIndex(jarFile);
    }

    protected String jarIndex(JarFile jarFile) {
        StringBuilder buffer = new StringBuilder();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            this.addJarEntryToIndex(entry, buffer);
        }
        return buffer.toString();
    }

    protected void addJarEntryToIndex(JarEntry entry, StringBuilder buffer) {
        if (!entry.isDirectory()) {
            buffer.append(entry.getName());
            buffer.append("\n");
        }
    }

    protected boolean isRoot(String filePath) {
        return filePath == null || filePath.length() == 0 || filePath.equals("/");
    }

    public static String ensureStartsWithSlash(String path) {
        if (path != null && !path.startsWith("/")) {
            return "/" + path;
        }
        return path;
    }
}

