/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jvm.local;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import io.hawt.jvm.local.JVMListMBean;
import io.hawt.jvm.local.VMDescriptorDTO;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jolokia.jvmagent.client.command.CommandDispatcher;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.PlatformUtils;
import org.jolokia.jvmagent.client.util.VirtualMachineHandlerOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMList
implements JVMListMBean {
    private static final Logger LOG = LoggerFactory.getLogger(JVMList.class);
    private MBeanServer mBeanServer;
    private ObjectName objectName;
    protected static final Map<String, String> VM_ALIAS_MAP = new HashMap<String, String>();
    protected static final Map<String, String> VM_ALIAS_OVERRIDE_MAP = new HashMap<String, String>();

    public void init() {
        LOG.debug("Registering JVM discovery MBean: hawtio:type=JVMList");
        try {
            try {
                this.listLocalJVMs();
            }
            catch (LinkageError e) {
                LOG.warn("Local JVM discovery disabled as this JVM cannot access com.sun.tools.attach.VirtualMachine due to: {}", (Object)e.getMessage());
                return;
            }
            if (this.objectName == null) {
                this.objectName = new ObjectName("hawtio:type=JVMList");
            }
            if (this.mBeanServer == null) {
                this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                LOG.info("Re-registering SchemaLookup MBean");
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this, this.objectName);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception during initialization: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        LOG.info("Registered JVM discovery MBean: hawtio:type=JVMList");
    }

    public void destroy() {
        try {
            if (this.objectName != null && this.mBeanServer != null) {
                this.mBeanServer.unregisterMBean(this.objectName);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception unregistering mbean: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<VMDescriptorDTO> listLocalJVMs() {
        ArrayList<VMDescriptorDTO> rc = new ArrayList<VMDescriptorDTO>();
        try {
            List<VirtualMachineDescriptor> processes = VirtualMachine.list();
            for (VirtualMachineDescriptor process : processes) {
                VMDescriptorDTO dto = new VMDescriptorDTO(process);
                dto.setAgentUrl(this.agentStatus(dto.getId()));
                String alias = JVMList.getVmAlias(process.displayName(), dto.getAgentUrl());
                dto.setAlias(alias);
                if (dto.getAgentUrl() != null) {
                    try {
                        URL url = new URL(dto.getAgentUrl());
                        dto.setScheme(url.getProtocol());
                        dto.setHostname(url.getHost());
                        dto.setPort(url.getPort());
                        dto.setPath(url.getPath());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                rc.add(dto);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get local JVM processes due to: {}", (Object)e.getMessage());
            throw new RuntimeException("Failed to get local JVM processes due to: " + e.getMessage(), e);
        }
        return rc;
    }

    private void doAction(String PID, String action) {
        OptionsAndArgs options = action.equals("start") ? new OptionsAndArgs(CommandDispatcher.getAvailableCommands(), new String[]{"--quiet", "--port", this.allocateFreePort(), action, PID}) : new OptionsAndArgs(CommandDispatcher.getAvailableCommands(), new String[]{"--quiet", action, PID});
        VirtualMachineHandlerOperations vmHandler = PlatformUtils.createVMAccess((OptionsAndArgs)options);
        CommandDispatcher dispatcher = new CommandDispatcher(options);
        Object vm = null;
        try {
            vm = vmHandler.attachVirtualMachine();
            dispatcher.dispatchCommand(vm, vmHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to " + action + " agent in process " + PID, e);
        }
        finally {
            if (vm != null) {
                try {
                    vmHandler.detachAgent(vm);
                }
                catch (Exception exception) {}
            }
        }
    }

    private String allocateFreePort() {
        int port = 8778;
        try (ServerSocket sock = new ServerSocket(0);){
            port = sock.getLocalPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.toString(port);
    }

    @Override
    public void startAgent(String PID) {
        this.doAction(PID, "start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String agentStatus(String PID) {
        Object vm = null;
        OptionsAndArgs options = new OptionsAndArgs(CommandDispatcher.getAvailableCommands(), new String[]{"--quiet", "status", PID});
        VirtualMachineHandlerOperations vmHandler = PlatformUtils.createVMAccess((OptionsAndArgs)options);
        String agentUrl = null;
        try {
            vm = vmHandler.attachVirtualMachine();
            agentUrl = this.checkAgentUrl(vm);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                vmHandler.detachAgent(vm);
            }
            catch (Exception exception) {}
        }
        return agentUrl;
    }

    @Override
    public String agentVersion(String PID) {
        return null;
    }

    @Override
    public void stopAgent(String PID) {
        this.doAction(PID, "stop");
    }

    static String getVmAlias(String displayName, String agentUrl) {
        String answer = displayName;
        for (String key : VM_ALIAS_MAP.keySet()) {
            if (!displayName.contains(key)) continue;
            answer = VM_ALIAS_MAP.get(key);
            break;
        }
        if (agentUrl != null) {
            for (String key : VM_ALIAS_OVERRIDE_MAP.keySet()) {
                if (!agentUrl.contains(key)) continue;
                answer = VM_ALIAS_OVERRIDE_MAP.get(key);
                break;
            }
        }
        return answer;
    }

    protected String checkAgentUrl(Object pVm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Properties systemProperties = this.getAgentSystemProperties(pVm);
        return systemProperties.getProperty("jolokia.agent");
    }

    protected Properties getAgentSystemProperties(Object pVm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = pVm.getClass();
        Method method = clazz.getMethod("getSystemProperties", new Class[0]);
        return (Properties)method.invoke(pVm, new Object[0]);
    }

    static {
        VM_ALIAS_MAP.put("hawtio-app", "hawtio");
        VM_ALIAS_MAP.put("com.intellij.idea.Main", "IntelliJ IDEA");
        VM_ALIAS_MAP.put("com.intellij.rt.execution.application.AppMain", "IntelliJ IDEA");
        VM_ALIAS_MAP.put("org.jetbrains.idea.maven.server.RemoteMavenServer", "IntelliJ IDEA");
        VM_ALIAS_MAP.put("idea maven server", "IntelliJ IDEA");
        VM_ALIAS_MAP.put("IntelliJ IDEA", "IntelliJ IDEA");
        VM_ALIAS_MAP.put("org.apache.karaf.main.Main", "Apache Karaf");
        VM_ALIAS_MAP.put("activemq.jar start", "Apache ActiveMQ");
        VM_ALIAS_MAP.put("org.apache.catalina", "Apache Tomcat");
        VM_ALIAS_MAP.put("jetty", "Jetty");
        VM_ALIAS_MAP.put("org.eclipse.equinox.launcher.Main", "Eclipse Equinox");
        VM_ALIAS_MAP.put("scala.tools.nsc.MainGenericRunner", "Scala REPL");
        VM_ALIAS_MAP.put("org.codehaus.groovy.tools.shell.Main", "Groovy Shell");
        VM_ALIAS_MAP.put("org.codehaus.groovy.tools.GroovyStarter", "Groovy Starter");
        VM_ALIAS_MAP.put("jboss-eap-6.1/jboss-modules.jar", "JBoss EAP 6");
        VM_ALIAS_MAP.put("wildfly", "WildFly");
        VM_ALIAS_MAP.put("target/surefire", "Maven Surefire Test");
        VM_ALIAS_MAP.put("org.apache.camel:camel-maven-plugin:run", "Apache Camel");
        VM_ALIAS_MAP.put("camel:run", "Apache Camel");
        VM_ALIAS_MAP.put("org.codehaus.plexus.classworlds.launcher.Launcher spring-boot:run", "Spring Boot");
        VM_ALIAS_MAP.put("org.springframework.boot.loader.JarLauncher shell", "Spring Boot Shell");
        VM_ALIAS_MAP.put("org.jboss.forge.bootstrap.Bootstrap", "JBoss Forge Shell");
        VM_ALIAS_OVERRIDE_MAP.put("${zk:root/http}/jolokia", "Fabric8");
    }
}

