/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jvm.local;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import io.hawt.jvm.local.JVMListMBean;
import io.hawt.jvm.local.VMDescriptorDTO;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jolokia.jvmagent.client.command.CommandDispatcher;
import org.jolokia.jvmagent.client.util.OptionsAndArgs;
import org.jolokia.jvmagent.client.util.VirtualMachineHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVMList
implements JVMListMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(JVMList.class);
    private MBeanServer mBeanServer;
    private ObjectName objectName;
    protected static final Map<String, String> vmAliasMap = new HashMap<String, String>();
    private VirtualMachineHandler vmHandler;

    public void init() {
        try {
            this.listLocalJVMs();
            if (this.objectName == null) {
                this.objectName = new ObjectName("io.hawt.jvm.local:type=JVMList");
            }
            if (this.mBeanServer == null) {
                this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                LOG.info("Re-registering SchemaLookup MBean");
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this, this.objectName);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception during initialization: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        try {
            if (this.objectName != null && this.mBeanServer != null) {
                this.mBeanServer.unregisterMBean(this.objectName);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception unregistering mbean: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<VMDescriptorDTO> listLocalJVMs() {
        ArrayList<VMDescriptorDTO> rc = new ArrayList<VMDescriptorDTO>();
        try {
            List<VirtualMachineDescriptor> processes = VirtualMachine.list();
            for (VirtualMachineDescriptor process : processes) {
                VMDescriptorDTO dto = new VMDescriptorDTO(process);
                dto.setAgentUrl(this.agentStatus(dto.getId()));
                rc.add(dto);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get local JVM processes due to:", (Throwable)e);
            throw new RuntimeException("Failed to get local JVM processes due to " + e);
        }
        return rc;
    }

    private void doAction(String PID, String action) {
        OptionsAndArgs options = null;
        options = action.equals("start") ? new OptionsAndArgs(CommandDispatcher.getAvailableCommands(), new String[]{"--quiet", "--port", this.allocateFreePort(), action, PID}) : new OptionsAndArgs(CommandDispatcher.getAvailableCommands(), new String[]{"--quiet", action, PID});
        VirtualMachineHandler vmHandler = new VirtualMachineHandler(options);
        CommandDispatcher dispatcher = new CommandDispatcher(options);
        Object vm = null;
        try {
            vm = vmHandler.attachVirtualMachine();
            dispatcher.dispatchCommand(vm, vmHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to " + action + " agent in process " + PID, e);
        }
        finally {
            if (vm != null) {
                try {
                    vmHandler.detachAgent(vm);
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String allocateFreePort() {
        int port = 8778;
        ServerSocket sock = null;
        try {
            sock = new ServerSocket(0);
            port = sock.getLocalPort();
        }
        catch (Exception e) {
        }
        finally {
            if (sock != null) {
                try {
                    sock.close();
                }
                catch (Exception e) {}
            }
        }
        return new Integer(port).toString();
    }

    @Override
    public void startAgent(String PID) {
        this.doAction(PID, "start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String agentStatus(String PID) {
        Object vm = null;
        OptionsAndArgs options = new OptionsAndArgs(CommandDispatcher.getAvailableCommands(), new String[]{"--quiet", "status", PID});
        VirtualMachineHandler vmHandler = new VirtualMachineHandler(options);
        String agentUrl = null;
        try {
            vm = vmHandler.attachVirtualMachine();
            agentUrl = this.checkAgentUrl(vm);
        }
        catch (Exception e) {
        }
        finally {
            try {
                vmHandler.detachAgent(vm);
            }
            catch (Exception e) {}
        }
        return agentUrl;
    }

    @Override
    public String agentVersion(String PID) {
        return null;
    }

    @Override
    public void stopAgent(String PID) {
        this.doAction(PID, "stop");
    }

    static String getVmAlias(String displayName) {
        for (String key : vmAliasMap.keySet()) {
            if (!displayName.contains(key)) continue;
            return vmAliasMap.get(key);
        }
        return displayName;
    }

    protected String checkAgentUrl(Object pVm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Properties systemProperties = this.getAgentSystemProperties(pVm);
        return systemProperties.getProperty("jolokia.agent");
    }

    protected Properties getAgentSystemProperties(Object pVm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = pVm.getClass();
        Method method = clazz.getMethod("getSystemProperties", new Class[0]);
        return (Properties)method.invoke(pVm, new Object[0]);
    }

    static {
        vmAliasMap.put("com.intellij.idea.Main", "IDEA");
        vmAliasMap.put("com.intellij.rt.execution.application.AppMain", "IDEA");
        vmAliasMap.put("org.apache.karaf.main.Main", "Karaf");
        vmAliasMap.put("org.eclipse.equinox.launcher.Main", "Equinox");
        vmAliasMap.put("org.jetbrains.idea.maven.server.RemoteMavenServer", "IDEA Maven server");
        vmAliasMap.put("idea maven server", "");
        vmAliasMap.put("scala.tools.nsc.MainGenericRunner", "scala repl");
        vmAliasMap.put("jboss-eap-6.1/jboss-modules.jar", "JBoss EAP 6");
        vmAliasMap.put("target/surefire", "Maven Surefire Test");
        vmAliasMap.put("org.apache.camel:camel-maven-plugin:run", "Local Camel Context");
    }
}

