/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.protobuf;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import io.grpc.protobuf.ProtoMethodDescriptorSupplier;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.protobuf.SimpleRequest;
import io.grpc.testing.protobuf.SimpleResponse;
import io.grpc.testing.protobuf.SimpleServiceProto;
import java.util.Iterator;

public final class SimpleServiceGrpc {
    public static final String SERVICE_NAME = "grpc.testing.SimpleService";
    public static final MethodDescriptor<SimpleRequest, SimpleResponse> METHOD_UNARY_RPC = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"grpc.testing.SimpleService", (String)"UnaryRpc")).setRequestMarshaller(ProtoUtils.marshaller((Message)SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new SimpleServiceMethodDescriptorSupplier("UnaryRpc")).build();
    public static final MethodDescriptor<SimpleRequest, SimpleResponse> METHOD_CLIENT_STREAMING_RPC = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.CLIENT_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"grpc.testing.SimpleService", (String)"ClientStreamingRpc")).setRequestMarshaller(ProtoUtils.marshaller((Message)SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new SimpleServiceMethodDescriptorSupplier("ClientStreamingRpc")).build();
    public static final MethodDescriptor<SimpleRequest, SimpleResponse> METHOD_SERVER_STREAMING_RPC = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"grpc.testing.SimpleService", (String)"ServerStreamingRpc")).setRequestMarshaller(ProtoUtils.marshaller((Message)SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new SimpleServiceMethodDescriptorSupplier("ServerStreamingRpc")).build();
    public static final MethodDescriptor<SimpleRequest, SimpleResponse> METHOD_BIDI_STREAMING_RPC = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"grpc.testing.SimpleService", (String)"BidiStreamingRpc")).setRequestMarshaller(ProtoUtils.marshaller((Message)SimpleRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SimpleResponse.getDefaultInstance())).setSchemaDescriptor((Object)new SimpleServiceMethodDescriptorSupplier("BidiStreamingRpc")).build();
    private static final int METHODID_UNARY_RPC = 0;
    private static final int METHODID_SERVER_STREAMING_RPC = 1;
    private static final int METHODID_CLIENT_STREAMING_RPC = 2;
    private static final int METHODID_BIDI_STREAMING_RPC = 3;
    private static volatile ServiceDescriptor serviceDescriptor;

    private SimpleServiceGrpc() {
    }

    public static SimpleServiceStub newStub(Channel channel) {
        return new SimpleServiceStub(channel);
    }

    public static SimpleServiceBlockingStub newBlockingStub(Channel channel) {
        return new SimpleServiceBlockingStub(channel);
    }

    public static SimpleServiceFutureStub newFutureStub(Channel channel) {
        return new SimpleServiceFutureStub(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceDescriptor getServiceDescriptor() {
        ServiceDescriptor result = serviceDescriptor;
        if (result != null) return result;
        Class<SimpleServiceGrpc> clazz = SimpleServiceGrpc.class;
        synchronized (SimpleServiceGrpc.class) {
            result = serviceDescriptor;
            if (result != null) return result;
            serviceDescriptor = result = ServiceDescriptor.newBuilder((String)SERVICE_NAME).setSchemaDescriptor((Object)new SimpleServiceFileDescriptorSupplier()).addMethod(METHOD_UNARY_RPC).addMethod(METHOD_CLIENT_STREAMING_RPC).addMethod(METHOD_SERVER_STREAMING_RPC).addMethod(METHOD_BIDI_STREAMING_RPC).build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private static final class SimpleServiceMethodDescriptorSupplier
    extends SimpleServiceBaseDescriptorSupplier
    implements ProtoMethodDescriptorSupplier {
        private final String methodName;

        SimpleServiceMethodDescriptorSupplier(String methodName) {
            this.methodName = methodName;
        }

        public Descriptors.MethodDescriptor getMethodDescriptor() {
            return this.getServiceDescriptor().findMethodByName(this.methodName);
        }
    }

    private static final class SimpleServiceFileDescriptorSupplier
    extends SimpleServiceBaseDescriptorSupplier {
        SimpleServiceFileDescriptorSupplier() {
        }
    }

    private static abstract class SimpleServiceBaseDescriptorSupplier
    implements ProtoFileDescriptorSupplier,
    ProtoServiceDescriptorSupplier {
        SimpleServiceBaseDescriptorSupplier() {
        }

        public Descriptors.FileDescriptor getFileDescriptor() {
            return SimpleServiceProto.getDescriptor();
        }

        public Descriptors.ServiceDescriptor getServiceDescriptor() {
            return this.getFileDescriptor().findServiceByName("SimpleService");
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final SimpleServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(SimpleServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.unaryRpc((SimpleRequest)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.serverStreamingRpc((SimpleRequest)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 2: {
                    return this.serviceImpl.clientStreamingRpc(responseObserver);
                }
                case 3: {
                    return this.serviceImpl.bidiStreamingRpc(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static final class SimpleServiceFutureStub
    extends AbstractStub<SimpleServiceFutureStub> {
        private SimpleServiceFutureStub(Channel channel) {
            super(channel);
        }

        private SimpleServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SimpleServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new SimpleServiceFutureStub(channel, callOptions);
        }

        public ListenableFuture<SimpleResponse> unaryRpc(SimpleRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNARY_RPC, this.getCallOptions()), (Object)request);
        }
    }

    public static final class SimpleServiceBlockingStub
    extends AbstractStub<SimpleServiceBlockingStub> {
        private SimpleServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private SimpleServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SimpleServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new SimpleServiceBlockingStub(channel, callOptions);
        }

        public SimpleResponse unaryRpc(SimpleRequest request) {
            return (SimpleResponse)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_UNARY_RPC, (CallOptions)this.getCallOptions(), (Object)request);
        }

        public Iterator<SimpleResponse> serverStreamingRpc(SimpleRequest request) {
            return ClientCalls.blockingServerStreamingCall((Channel)this.getChannel(), METHOD_SERVER_STREAMING_RPC, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class SimpleServiceStub
    extends AbstractStub<SimpleServiceStub> {
        private SimpleServiceStub(Channel channel) {
            super(channel);
        }

        private SimpleServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected SimpleServiceStub build(Channel channel, CallOptions callOptions) {
            return new SimpleServiceStub(channel, callOptions);
        }

        public void unaryRpc(SimpleRequest request, StreamObserver<SimpleResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_UNARY_RPC, this.getCallOptions()), (Object)request, responseObserver);
        }

        public StreamObserver<SimpleRequest> clientStreamingRpc(StreamObserver<SimpleResponse> responseObserver) {
            return ClientCalls.asyncClientStreamingCall((ClientCall)this.getChannel().newCall(METHOD_CLIENT_STREAMING_RPC, this.getCallOptions()), responseObserver);
        }

        public void serverStreamingRpc(SimpleRequest request, StreamObserver<SimpleResponse> responseObserver) {
            ClientCalls.asyncServerStreamingCall((ClientCall)this.getChannel().newCall(METHOD_SERVER_STREAMING_RPC, this.getCallOptions()), (Object)request, responseObserver);
        }

        public StreamObserver<SimpleRequest> bidiStreamingRpc(StreamObserver<SimpleResponse> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_BIDI_STREAMING_RPC, this.getCallOptions()), responseObserver);
        }
    }

    public static abstract class SimpleServiceImplBase
    implements BindableService {
        public void unaryRpc(SimpleRequest request, StreamObserver<SimpleResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_UNARY_RPC, responseObserver);
        }

        public StreamObserver<SimpleRequest> clientStreamingRpc(StreamObserver<SimpleResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_CLIENT_STREAMING_RPC, responseObserver);
        }

        public void serverStreamingRpc(SimpleRequest request, StreamObserver<SimpleResponse> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_SERVER_STREAMING_RPC, responseObserver);
        }

        public StreamObserver<SimpleRequest> bidiStreamingRpc(StreamObserver<SimpleResponse> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_BIDI_STREAMING_RPC, responseObserver);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)SimpleServiceGrpc.getServiceDescriptor()).addMethod(METHOD_UNARY_RPC, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(METHOD_CLIENT_STREAMING_RPC, ServerCalls.asyncClientStreamingCall(new MethodHandlers(this, 2))).addMethod(METHOD_SERVER_STREAMING_RPC, ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 1))).addMethod(METHOD_BIDI_STREAMING_RPC, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 3))).build();
        }
    }
}

