/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.handshaker;

import com.google.errorprone.annotations.Immutable;
import com.google.s2a.proto.v2.AuthenticationMechanism;
import io.grpc.s2a.internal.handshaker.S2AIdentity;
import io.grpc.s2a.internal.handshaker.tokenmanager.AccessTokenManager;
import java.util.Optional;

@Immutable
final class GetAuthenticationMechanisms {
    static final Optional<AccessTokenManager> TOKEN_MANAGER = AccessTokenManager.create();

    static Optional<AuthenticationMechanism> getAuthMechanism(Optional<S2AIdentity> localIdentity, Optional<AccessTokenManager> tokenManager) {
        if (!tokenManager.isPresent()) {
            return Optional.empty();
        }
        AccessTokenManager manager = tokenManager.get();
        if (!localIdentity.isPresent()) {
            return Optional.of(AuthenticationMechanism.newBuilder().setToken(manager.getDefaultToken()).build());
        }
        return Optional.of(AuthenticationMechanism.newBuilder().setIdentity(localIdentity.get().getIdentity()).setToken(manager.getToken(localIdentity.get())).build());
    }

    private GetAuthenticationMechanisms() {
    }
}

