/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.AbstractClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.Http2ClientStreamTransportState;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.TransportTracer;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import io.grpc.okhttp.ExceptionHandlingFrameWriter;
import io.grpc.okhttp.Headers;
import io.grpc.okhttp.OkHttpClientTransport;
import io.grpc.okhttp.OkHttpReadableBuffer;
import io.grpc.okhttp.OkHttpWritableBuffer;
import io.grpc.okhttp.OkHttpWritableBufferAllocator;
import io.grpc.okhttp.OutboundFlowController;
import io.grpc.okhttp.Utils;
import io.grpc.okhttp.internal.framed.ErrorCode;
import io.grpc.okhttp.internal.framed.Header;
import io.perfmark.PerfMark;
import io.perfmark.Tag;
import io.perfmark.TaskCloseable;
import java.util.List;
import okio.Buffer;

class OkHttpClientStream
extends AbstractClientStream {
    private static final Buffer EMPTY_BUFFER = new Buffer();
    public static final int ABSENT_ID = -1;
    private final MethodDescriptor<?, ?> method;
    private final String userAgent;
    private final StatsTraceContext statsTraceCtx;
    private String authority;
    private final TransportState state;
    private final Sink sink = new Sink();
    private final Attributes attributes;
    private boolean useGet = false;

    OkHttpClientStream(MethodDescriptor<?, ?> method, Metadata headers, ExceptionHandlingFrameWriter frameWriter, OkHttpClientTransport transport, OutboundFlowController outboundFlow, Object lock, int maxMessageSize, int initialWindowSize, String authority, String userAgent, StatsTraceContext statsTraceCtx, TransportTracer transportTracer, CallOptions callOptions, boolean useGetForSafeMethods) {
        super((WritableBufferAllocator)new OkHttpWritableBufferAllocator(), statsTraceCtx, transportTracer, headers, callOptions, useGetForSafeMethods && method.isSafe());
        this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceCtx, (Object)"statsTraceCtx");
        this.method = method;
        this.authority = authority;
        this.userAgent = userAgent;
        this.attributes = transport.getAttributes();
        this.state = new TransportState(maxMessageSize, statsTraceCtx, lock, frameWriter, outboundFlow, transport, initialWindowSize, method.getFullMethodName(), callOptions);
    }

    protected TransportState transportState() {
        return this.state;
    }

    protected Sink abstractClientStreamSink() {
        return this.sink;
    }

    public MethodDescriptor.MethodType getType() {
        return this.method.getType();
    }

    boolean useGet() {
        return this.useGet;
    }

    public void setAuthority(String authority) {
        this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    class TransportState
    extends Http2ClientStreamTransportState
    implements OutboundFlowController.Stream {
        private final int initialWindowSize;
        private final Object lock;
        @GuardedBy(value="lock")
        private List<Header> requestHeaders;
        @GuardedBy(value="lock")
        private Buffer pendingData;
        private boolean pendingDataHasEndOfStream;
        private boolean flushPendingData;
        @GuardedBy(value="lock")
        private boolean cancelSent;
        @GuardedBy(value="lock")
        private int window;
        @GuardedBy(value="lock")
        private int processedWindow;
        @GuardedBy(value="lock")
        private final ExceptionHandlingFrameWriter frameWriter;
        @GuardedBy(value="lock")
        private final OutboundFlowController outboundFlow;
        @GuardedBy(value="lock")
        private final OkHttpClientTransport transport;
        @GuardedBy(value="lock")
        private boolean canStart;
        private final Tag tag;
        @GuardedBy(value="lock")
        private OutboundFlowController.StreamState outboundFlowState;
        private int id;

        public TransportState(int maxMessageSize, StatsTraceContext statsTraceCtx, Object lock, ExceptionHandlingFrameWriter frameWriter, OutboundFlowController outboundFlow, OkHttpClientTransport transport, int initialWindowSize, String methodName, CallOptions options) {
            super(maxMessageSize, statsTraceCtx, OkHttpClientStream.this.getTransportTracer(), options);
            this.pendingData = new Buffer();
            this.pendingDataHasEndOfStream = false;
            this.flushPendingData = false;
            this.cancelSent = false;
            this.canStart = true;
            this.id = -1;
            this.lock = Preconditions.checkNotNull((Object)lock, (Object)"lock");
            this.frameWriter = frameWriter;
            this.outboundFlow = outboundFlow;
            this.transport = transport;
            this.window = initialWindowSize;
            this.processedWindow = initialWindowSize;
            this.initialWindowSize = initialWindowSize;
            this.tag = PerfMark.createTag((String)methodName);
        }

        @GuardedBy(value="lock")
        public void start(int streamId) {
            Preconditions.checkState((this.id == -1 ? 1 : 0) != 0, (String)"the stream has been started with id %s", (int)streamId);
            this.id = streamId;
            this.outboundFlowState = this.outboundFlow.createState(this, streamId);
            OkHttpClientStream.this.state.onStreamAllocated();
            if (this.canStart) {
                this.frameWriter.synStream(OkHttpClientStream.this.useGet, false, this.id, 0, this.requestHeaders);
                OkHttpClientStream.this.statsTraceCtx.clientOutboundHeaders();
                this.requestHeaders = null;
                if (this.pendingData.size() > 0L) {
                    this.outboundFlow.data(this.pendingDataHasEndOfStream, this.outboundFlowState, this.pendingData, this.flushPendingData);
                }
                this.canStart = false;
            }
        }

        @GuardedBy(value="lock")
        protected void onStreamAllocated() {
            super.onStreamAllocated();
            this.getTransportTracer().reportLocalStreamStarted();
        }

        @GuardedBy(value="lock")
        protected void http2ProcessingFailed(Status status, boolean stopDelivery, Metadata trailers) {
            this.cancel(status, stopDelivery, trailers);
        }

        @GuardedBy(value="lock")
        public void deframeFailed(Throwable cause) {
            this.http2ProcessingFailed(Status.fromThrowable((Throwable)cause), true, new Metadata());
        }

        @GuardedBy(value="lock")
        public void bytesRead(int processedBytes) {
            this.processedWindow -= processedBytes;
            if ((float)this.processedWindow <= (float)this.initialWindowSize * 0.5f) {
                int delta = this.initialWindowSize - this.processedWindow;
                this.window += delta;
                this.processedWindow += delta;
                this.frameWriter.windowUpdate(this.id(), delta);
            }
        }

        @GuardedBy(value="lock")
        public void deframerClosed(boolean hasPartialMessage) {
            this.onEndOfStream();
            super.deframerClosed(hasPartialMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @GuardedBy(value="lock")
        public void runOnTransportThread(Runnable r) {
            Object object = this.lock;
            synchronized (object) {
                r.run();
            }
        }

        @GuardedBy(value="lock")
        public void transportHeadersReceived(List<Header> headers, boolean endOfStream) {
            if (endOfStream) {
                this.transportTrailersReceived(Utils.convertTrailers(headers));
            } else {
                this.transportHeadersReceived(Utils.convertHeaders(headers));
            }
        }

        @GuardedBy(value="lock")
        public void transportDataReceived(Buffer frame, boolean endOfStream, int paddingLen) {
            int length = (int)frame.size();
            this.window -= length + paddingLen;
            this.processedWindow -= paddingLen;
            if (this.window < 0) {
                this.frameWriter.rstStream(this.id(), ErrorCode.FLOW_CONTROL_ERROR);
                this.transport.finishStream(this.id(), Status.INTERNAL.withDescription("Received data size exceeded our receiving window size"), ClientStreamListener.RpcProgress.PROCESSED, false, null, null);
                return;
            }
            super.transportDataReceived((ReadableBuffer)new OkHttpReadableBuffer(frame), endOfStream);
        }

        @GuardedBy(value="lock")
        private void onEndOfStream() {
            if (!this.isOutboundClosed()) {
                this.transport.finishStream(this.id(), null, ClientStreamListener.RpcProgress.PROCESSED, false, ErrorCode.CANCEL, null);
            } else {
                this.transport.finishStream(this.id(), null, ClientStreamListener.RpcProgress.PROCESSED, false, null, null);
            }
        }

        @GuardedBy(value="lock")
        private void cancel(Status reason, boolean stopDelivery, Metadata trailers) {
            if (this.cancelSent) {
                return;
            }
            this.cancelSent = true;
            if (this.canStart) {
                this.transport.removePendingStream(OkHttpClientStream.this);
                this.requestHeaders = null;
                this.pendingData.clear();
                this.canStart = false;
                this.transportReportStatus(reason, true, trailers != null ? trailers : new Metadata());
            } else {
                this.transport.finishStream(this.id(), reason, ClientStreamListener.RpcProgress.PROCESSED, stopDelivery, ErrorCode.CANCEL, trailers);
            }
        }

        @GuardedBy(value="lock")
        private void sendBuffer(Buffer buffer, boolean endOfStream, boolean flush) {
            if (this.cancelSent) {
                return;
            }
            if (this.canStart) {
                int dataSize = (int)buffer.size();
                this.pendingData.write(buffer, (long)dataSize);
                this.pendingDataHasEndOfStream |= endOfStream;
                this.flushPendingData |= flush;
            } else {
                Preconditions.checkState((this.id() != -1 ? 1 : 0) != 0, (Object)"streamId should be set");
                this.outboundFlow.data(endOfStream, this.outboundFlowState, buffer, flush);
            }
        }

        @GuardedBy(value="lock")
        private void streamReady(Metadata metadata, String path) {
            this.requestHeaders = Headers.createRequestHeaders(metadata, path, OkHttpClientStream.this.authority, OkHttpClientStream.this.userAgent, OkHttpClientStream.this.useGet, this.transport.isUsingPlaintext());
            this.transport.streamReadyToStart(OkHttpClientStream.this, OkHttpClientStream.this.authority);
        }

        Tag tag() {
            return this.tag;
        }

        int id() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        OutboundFlowController.StreamState getOutboundFlowState() {
            Object object = this.lock;
            synchronized (object) {
                return this.outboundFlowState;
            }
        }
    }

    class Sink
    implements AbstractClientStream.Sink {
        Sink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeHeaders(Metadata metadata, byte[] payload) {
            try (TaskCloseable ignore = PerfMark.traceTask((String)"OkHttpClientStream$Sink.writeHeaders");){
                String defaultPath = "/" + OkHttpClientStream.this.method.getFullMethodName();
                if (payload != null) {
                    OkHttpClientStream.this.useGet = true;
                    defaultPath = defaultPath + "?" + BaseEncoding.base64().encode(payload);
                }
                Object object = OkHttpClientStream.this.state.lock;
                synchronized (object) {
                    OkHttpClientStream.this.state.streamReady(metadata, defaultPath);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeFrame(WritableBuffer frame, boolean endOfStream, boolean flush, int numMessages) {
            try (TaskCloseable ignore = PerfMark.traceTask((String)"OkHttpClientStream$Sink.writeFrame");){
                Buffer buffer;
                if (frame == null) {
                    buffer = EMPTY_BUFFER;
                } else {
                    buffer = ((OkHttpWritableBuffer)frame).buffer();
                    int size = (int)buffer.size();
                    if (size > 0) {
                        OkHttpClientStream.this.onSendingBytes(size);
                    }
                }
                Object object = OkHttpClientStream.this.state.lock;
                synchronized (object) {
                    OkHttpClientStream.this.state.sendBuffer(buffer, endOfStream, flush);
                    OkHttpClientStream.this.getTransportTracer().reportMessageSent(numMessages);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(Status reason) {
            try (TaskCloseable ignore = PerfMark.traceTask((String)"OkHttpClientStream$Sink.cancel");){
                Object object = OkHttpClientStream.this.state.lock;
                synchronized (object) {
                    OkHttpClientStream.this.state.cancel(reason, true, null);
                }
            }
        }
    }
}

