/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.InsecureServerCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.Status;
import io.grpc.gcp.csm.observability.CsmObservability;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.grpc.protobuf.services.ProtoReflectionServiceV1;
import io.grpc.services.AdminInterface;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.EmptyProtos;
import io.grpc.testing.integration.LoadBalancerStatsServiceGrpc;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import io.grpc.testing.integration.XdsTestServer;
import io.grpc.testing.integration.XdsUpdateClientConfigureServiceGrpc;
import io.grpc.xds.XdsChannelCredentials;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

public final class XdsTestClient {
    private static Logger logger = Logger.getLogger(XdsTestClient.class.getName());
    private final Set<XdsStatsWatcher> watchers = new HashSet<XdsStatsWatcher>();
    private final Object lock = new Object();
    private final List<ManagedChannel> channels = new ArrayList<ManagedChannel>();
    private final StatsAccumulator statsAccumulator = new StatsAccumulator();
    private int numChannels = 1;
    private boolean printResponse = false;
    private int qps = 1;
    private volatile List<RpcConfig> rpcConfigs;
    private int rpcTimeoutSec = 20;
    private boolean secureMode = false;
    private String server = "localhost:8080";
    private int requestSize;
    private int responseSize;
    private boolean enableCsmObservability;
    private int statsPort = 8081;
    private Server statsServer;
    private long currentRequestId;
    private ListeningScheduledExecutorService exec;
    private CsmObservability csmObservability;

    public static void main(String[] args) {
        final XdsTestClient client = new XdsTestClient();
        client.parseArgs(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    client.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        client.run();
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        Object rpcTypes = ImmutableList.of((Object)((Object)Messages.ClientConfigureRequest.RpcType.UNARY_CALL));
        EnumMap<Messages.ClientConfigureRequest.RpcType, Object> metadata = new EnumMap(Messages.ClientConfigureRequest.RpcType.class);
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("metadata".equals(key)) {
                metadata = XdsTestClient.parseMetadata(value);
                continue;
            }
            if ("num_channels".equals(key)) {
                this.numChannels = Integer.valueOf(value);
                continue;
            }
            if ("print_response".equals(key)) {
                this.printResponse = Boolean.valueOf(value);
                continue;
            }
            if ("qps".equals(key)) {
                this.qps = Integer.valueOf(value);
                continue;
            }
            if ("rpc".equals(key)) {
                rpcTypes = XdsTestClient.parseRpcs(value);
                continue;
            }
            if ("rpc_timeout_sec".equals(key)) {
                this.rpcTimeoutSec = Integer.valueOf(value);
                continue;
            }
            if ("server".equals(key)) {
                this.server = value;
                continue;
            }
            if ("request_payload_size".equals(key)) {
                this.requestSize = Integer.valueOf(value);
                continue;
            }
            if ("response_payload_size".equals(key)) {
                this.responseSize = Integer.valueOf(value);
                continue;
            }
            if ("enable_csm_observability".equals(key)) {
                this.enableCsmObservability = Boolean.valueOf(value);
                continue;
            }
            if ("stats_port".equals(key)) {
                this.statsPort = Integer.valueOf(value);
                continue;
            }
            if ("secure_mode".equals(key)) {
                this.secureMode = Boolean.valueOf(value);
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        ArrayList<RpcConfig> configs = new ArrayList<RpcConfig>();
        for (Messages.ClientConfigureRequest.RpcType type : rpcTypes) {
            Metadata md = new Metadata();
            if (metadata.containsKey((Object)type)) {
                md = (Metadata)metadata.get((Object)type);
            }
            configs.add(new RpcConfig(type, md, this.rpcTimeoutSec));
        }
        this.rpcConfigs = Collections.unmodifiableList(configs);
        if (usage) {
            XdsTestClient c = new XdsTestClient();
            System.err.println("Usage: [ARGS...]\n\n  --num_channels=INT     Default: " + c.numChannels + "\n  --print_response=BOOL  Write RPC response to stdout. Default: " + c.printResponse + "\n  --qps=INT              Qps per channel, for each type of RPC. Default: " + c.qps + "\n  --rpc=STR              Types of RPCs to make, ',' separated string. RPCs can be EmptyCall or UnaryCall. Default: UnaryCall\n[deprecated] Use XdsUpdateClientConfigureService\n  --metadata=STR         The metadata to send with each RPC, in the format EmptyCall:key1:value1,UnaryCall:key2:value2.\n[deprecated] Use XdsUpdateClientConfigureService\n  --rpc_timeout_sec=INT  Per RPC timeout seconds. Default: " + c.rpcTimeoutSec + "\n  --server=host:port     Address of server. Default: " + c.server + "\n  --secure_mode=BOOLEAN  Use true to enable XdsCredentials. Default: " + c.secureMode + "\n  --request_payload_size=INT   Per-request size. Default: " + c.requestSize + "\n  --response_payload_size=INT  Per-response size. Default: " + c.responseSize + "\n  --enable_csm_observability=BOOL  Enable CSM observability reporting. Default: " + c.enableCsmObservability + "\n  --stats_port=INT       Port to expose peer distribution stats service. Default: " + c.statsPort);
            System.exit(1);
        }
    }

    private static List<Messages.ClientConfigureRequest.RpcType> parseRpcs(String rpcArg) {
        ArrayList<Messages.ClientConfigureRequest.RpcType> rpcs = new ArrayList<Messages.ClientConfigureRequest.RpcType>();
        for (String rpc : Splitter.on((char)',').split((CharSequence)rpcArg)) {
            rpcs.add(XdsTestClient.parseRpc(rpc));
        }
        return rpcs;
    }

    private static EnumMap<Messages.ClientConfigureRequest.RpcType, Metadata> parseMetadata(String metadataArg) {
        EnumMap<Messages.ClientConfigureRequest.RpcType, Metadata> rpcMetadata = new EnumMap<Messages.ClientConfigureRequest.RpcType, Metadata>(Messages.ClientConfigureRequest.RpcType.class);
        for (String metadata : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)metadataArg)) {
            List parts = Splitter.on((char)':').splitToList((CharSequence)metadata);
            if (parts.size() != 3) {
                throw new IllegalArgumentException("Invalid metadata: '" + metadata + "'");
            }
            Messages.ClientConfigureRequest.RpcType rpc = XdsTestClient.parseRpc((String)parts.get(0));
            String key = (String)parts.get(1);
            String value = (String)parts.get(2);
            Metadata md = new Metadata();
            md.put(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)value);
            if (rpcMetadata.containsKey((Object)rpc)) {
                rpcMetadata.get((Object)rpc).merge(md);
                continue;
            }
            rpcMetadata.put(rpc, md);
        }
        return rpcMetadata;
    }

    private static Messages.ClientConfigureRequest.RpcType parseRpc(String rpc) {
        if ("EmptyCall".equals(rpc)) {
            return Messages.ClientConfigureRequest.RpcType.EMPTY_CALL;
        }
        if ("UnaryCall".equals(rpc)) {
            return Messages.ClientConfigureRequest.RpcType.UNARY_CALL;
        }
        throw new IllegalArgumentException("Unknown RPC: '" + rpc + "'");
    }

    private void run() {
        if (this.enableCsmObservability) {
            this.csmObservability = CsmObservability.newBuilder().sdk((OpenTelemetry)AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(() -> ImmutableMap.of((Object)"otel.logs.exporter", (Object)"none", (Object)"otel.metrics.exporter", (Object)"prometheus", (Object)"otel.traces.exporter", (Object)"none")).build().getOpenTelemetrySdk()).build();
            this.csmObservability.registerGlobal();
        }
        BindableService oldReflectionService = ProtoReflectionService.newInstance();
        this.statsServer = Grpc.newServerBuilderForPort((int)this.statsPort, (ServerCredentials)InsecureServerCredentials.create()).addService((BindableService)new XdsStatsImpl()).addService((BindableService)new ConfigureUpdateServiceImpl()).addService(oldReflectionService).addService(ProtoReflectionServiceV1.newInstance()).addServices(AdminInterface.getStandardServices()).build();
        try {
            this.statsServer.start();
            for (int i = 0; i < this.numChannels; ++i) {
                this.channels.add(Grpc.newChannelBuilder((String)this.server, (ChannelCredentials)(this.secureMode ? XdsChannelCredentials.create((ChannelCredentials)InsecureChannelCredentials.create()) : InsecureChannelCredentials.create())).enableRetry().build());
            }
            this.exec = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor());
            Messages.Payload requestPayload = Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[this.requestSize])).build();
            this.runQps(requestPayload);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error running client", t);
            System.exit(1);
        }
    }

    private void stop() throws InterruptedException {
        if (this.statsServer != null) {
            this.statsServer.shutdownNow();
            if (!this.statsServer.awaitTermination(5L, TimeUnit.SECONDS)) {
                System.err.println("Timed out waiting for server shutdown");
            }
        }
        for (ManagedChannel channel : this.channels) {
            channel.shutdownNow();
        }
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
        if (this.csmObservability != null) {
            this.csmObservability.close();
        }
    }

    private void runQps(final Messages.Payload requestPayload) throws InterruptedException, ExecutionException {
        final SettableFuture failure = SettableFuture.create();
        long nanosPerQuery = TimeUnit.SECONDS.toNanos(1L) / (long)this.qps;
        final class PeriodicRpc
        implements Runnable {
            PeriodicRpc() {
            }

            @Override
            public void run() {
                List configs = XdsTestClient.this.rpcConfigs;
                for (RpcConfig cfg : configs) {
                    this.makeRpc(cfg);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void makeRpc(final RpcConfig config) {
                long requestId;
                final HashSet savedWatchers = new HashSet();
                Object object = XdsTestClient.this.lock;
                synchronized (object) {
                    XdsTestClient.this.currentRequestId += 1L;
                    requestId = XdsTestClient.this.currentRequestId;
                    savedWatchers.addAll(XdsTestClient.this.watchers);
                }
                ManagedChannel channel = (ManagedChannel)XdsTestClient.this.channels.get((int)(requestId % (long)XdsTestClient.this.channels.size()));
                TestServiceGrpc.TestServiceStub stub = TestServiceGrpc.newStub((Channel)channel);
                final AtomicReference clientCallRef = new AtomicReference();
                final AtomicReference hostnameRef = new AtomicReference();
                stub = (TestServiceGrpc.TestServiceStub)((TestServiceGrpc.TestServiceStub)stub.withDeadlineAfter(config.timeoutSec, TimeUnit.SECONDS)).withInterceptors(new ClientInterceptor[]{new ClientInterceptor(){

                    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                        ClientCall call = next.newCall(method, callOptions);
                        clientCallRef.set(call);
                        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                                headers.merge(config.metadata);
                                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                                    public void onHeaders(Metadata headers) {
                                        hostnameRef.set((String)headers.get(XdsTestServer.HOSTNAME_KEY));
                                        super.onHeaders(headers);
                                    }
                                }, headers);
                            }
                        };
                    }
                }});
                if (config.rpcType == Messages.ClientConfigureRequest.RpcType.EMPTY_CALL) {
                    stub.emptyCall(EmptyProtos.Empty.getDefaultInstance(), new StreamObserver<EmptyProtos.Empty>(){

                        public void onCompleted() {
                            this.handleRpcCompleted(requestId, config.rpcType, (String)hostnameRef.get(), savedWatchers);
                        }

                        public void onError(Throwable t) {
                            this.handleRpcError(requestId, config.rpcType, Status.fromThrowable((Throwable)t), savedWatchers);
                        }

                        public void onNext(EmptyProtos.Empty response) {
                        }
                    });
                } else if (config.rpcType == Messages.ClientConfigureRequest.RpcType.UNARY_CALL) {
                    Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillServerId(true).setPayload(requestPayload).setResponseSize(XdsTestClient.this.responseSize).build();
                    stub.unaryCall(request, new StreamObserver<Messages.SimpleResponse>(){

                        public void onCompleted() {
                            this.handleRpcCompleted(requestId, config.rpcType, (String)hostnameRef.get(), savedWatchers);
                        }

                        public void onError(Throwable t) {
                            if (XdsTestClient.this.printResponse) {
                                logger.log(Level.WARNING, "Rpc failed", t);
                            }
                            this.handleRpcError(requestId, config.rpcType, Status.fromThrowable((Throwable)t), savedWatchers);
                        }

                        public void onNext(Messages.SimpleResponse response) {
                            if (XdsTestClient.this.printResponse) {
                                System.out.println("Greeting: Hello world, this is " + response.getHostname() + ", from " + ((ClientCall)clientCallRef.get()).getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
                            }
                            if (hostnameRef.get() == null) {
                                hostnameRef.set(response.getHostname());
                            }
                        }
                    });
                } else {
                    throw new AssertionError((Object)("Unknown RPC type: " + (Object)((Object)config.rpcType)));
                }
                XdsTestClient.this.statsAccumulator.recordRpcStarted(config.rpcType);
            }

            private void handleRpcCompleted(long requestId, Messages.ClientConfigureRequest.RpcType rpcType, String hostname, Set<XdsStatsWatcher> watchers) {
                XdsTestClient.this.statsAccumulator.recordRpcFinished(rpcType, Status.OK);
                XdsTestClient.this.notifyWatchers(watchers, rpcType, requestId, hostname);
            }

            private void handleRpcError(long requestId, Messages.ClientConfigureRequest.RpcType rpcType, Status status, Set<XdsStatsWatcher> watchers) {
                XdsTestClient.this.statsAccumulator.recordRpcFinished(rpcType, status);
                XdsTestClient.this.notifyWatchers(watchers, rpcType, requestId, null);
            }
        }
        ListenableScheduledFuture future = this.exec.scheduleAtFixedRate((Runnable)new PeriodicRpc(), 0L, nanosPerQuery, TimeUnit.NANOSECONDS);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

            public void onFailure(Throwable t) {
                failure.setException(t);
            }

            public void onSuccess(Object o) {
            }
        }, (Executor)MoreExecutors.directExecutor());
        failure.get();
    }

    private void notifyWatchers(Set<XdsStatsWatcher> watchers, Messages.ClientConfigureRequest.RpcType rpcType, long requestId, String hostname) {
        for (XdsStatsWatcher watcher : watchers) {
            watcher.rpcCompleted(rpcType, requestId, hostname);
        }
    }

    private static class XdsStatsWatcher {
        private final CountDownLatch latch;
        private final long startId;
        private final long endId;
        private final Map<String, Integer> rpcsByPeer = new HashMap<String, Integer>();
        private final EnumMap<Messages.ClientConfigureRequest.RpcType, Map<String, Integer>> rpcsByTypeAndPeer = new EnumMap(Messages.ClientConfigureRequest.RpcType.class);
        private final Object lock = new Object();
        private int rpcsFailed;

        private XdsStatsWatcher(long startId, long endId) {
            this.latch = new CountDownLatch(Ints.checkedCast((long)(endId - startId)));
            this.startId = startId;
            this.endId = endId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rpcCompleted(Messages.ClientConfigureRequest.RpcType rpcType, long requestId, @Nullable String hostname) {
            Object object = this.lock;
            synchronized (object) {
                if (this.startId <= requestId && requestId < this.endId) {
                    if (hostname != null) {
                        if (this.rpcsByPeer.containsKey(hostname)) {
                            this.rpcsByPeer.put(hostname, this.rpcsByPeer.get(hostname) + 1);
                        } else {
                            this.rpcsByPeer.put(hostname, 1);
                        }
                        if (this.rpcsByTypeAndPeer.containsKey((Object)rpcType)) {
                            if (this.rpcsByTypeAndPeer.get((Object)rpcType).containsKey(hostname)) {
                                this.rpcsByTypeAndPeer.get((Object)rpcType).put(hostname, this.rpcsByTypeAndPeer.get((Object)rpcType).get(hostname) + 1);
                            } else {
                                this.rpcsByTypeAndPeer.get((Object)rpcType).put(hostname, 1);
                            }
                        } else {
                            HashMap<String, Integer> rpcMap = new HashMap<String, Integer>();
                            rpcMap.put(hostname, 1);
                            this.rpcsByTypeAndPeer.put(rpcType, rpcMap);
                        }
                    } else {
                        ++this.rpcsFailed;
                    }
                    this.latch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Messages.LoadBalancerStatsResponse waitForRpcStats(long timeoutSeconds) {
            try {
                boolean success = this.latch.await(timeoutSeconds, TimeUnit.SECONDS);
                if (!success) {
                    logger.log(Level.INFO, "Await timed out, returning partial stats");
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.INFO, "Await interrupted, returning partial stats", e);
                Thread.currentThread().interrupt();
            }
            Messages.LoadBalancerStatsResponse.Builder builder = Messages.LoadBalancerStatsResponse.newBuilder();
            Object object = this.lock;
            synchronized (object) {
                builder.putAllRpcsByPeer(this.rpcsByPeer);
                for (Map.Entry<Messages.ClientConfigureRequest.RpcType, Map<String, Integer>> entry : this.rpcsByTypeAndPeer.entrySet()) {
                    Messages.LoadBalancerStatsResponse.RpcsByPeer.Builder rpcs = Messages.LoadBalancerStatsResponse.RpcsByPeer.newBuilder();
                    rpcs.putAllRpcsByPeer(entry.getValue());
                    builder.putRpcsByMethod(XdsStatsWatcher.getRpcTypeString(entry.getKey()), rpcs.build());
                }
                builder.setNumFailures(this.rpcsFailed);
            }
            return builder.build();
        }

        private static String getRpcTypeString(Messages.ClientConfigureRequest.RpcType rpcType) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, rpcType.name());
        }
    }

    @ThreadSafe
    private static final class StatsAccumulator {
        private final Map<String, Integer> rpcsStartedByMethod = new HashMap<String, Integer>();
        private final Map<String, Integer> rpcsFailedByMethod = new HashMap<String, Integer>();
        private final Map<String, Integer> rpcsSucceededByMethod = new HashMap<String, Integer>();
        private final Map<String, Map<Integer, Integer>> rpcStatusByMethod = new HashMap<String, Map<Integer, Integer>>();

        private StatsAccumulator() {
        }

        private synchronized void recordRpcStarted(Messages.ClientConfigureRequest.RpcType rpcType) {
            String method = StatsAccumulator.getRpcTypeString(rpcType);
            int count = this.rpcsStartedByMethod.containsKey(method) ? this.rpcsStartedByMethod.get(method) : 0;
            this.rpcsStartedByMethod.put(method, count + 1);
        }

        private synchronized void recordRpcFinished(Messages.ClientConfigureRequest.RpcType rpcType, Status status) {
            int count;
            String method = StatsAccumulator.getRpcTypeString(rpcType);
            if (status.isOk()) {
                count = this.rpcsSucceededByMethod.containsKey(method) ? this.rpcsSucceededByMethod.get(method) : 0;
                this.rpcsSucceededByMethod.put(method, count + 1);
            } else {
                count = this.rpcsFailedByMethod.containsKey(method) ? this.rpcsFailedByMethod.get(method) : 0;
                this.rpcsFailedByMethod.put(method, count + 1);
            }
            int statusCode = status.getCode().value();
            Map<Integer, Integer> statusCounts = this.rpcStatusByMethod.get(method);
            if (statusCounts == null) {
                statusCounts = new HashMap<Integer, Integer>();
                this.rpcStatusByMethod.put(method, statusCounts);
            }
            int count2 = statusCounts.containsKey(statusCode) ? statusCounts.get(statusCode) : 0;
            statusCounts.put(statusCode, count2 + 1);
        }

        private synchronized Messages.LoadBalancerAccumulatedStatsResponse getRpcStats() {
            Messages.LoadBalancerAccumulatedStatsResponse.Builder builder = Messages.LoadBalancerAccumulatedStatsResponse.newBuilder();
            builder.putAllNumRpcsStartedByMethod(this.rpcsStartedByMethod);
            builder.putAllNumRpcsSucceededByMethod(this.rpcsSucceededByMethod);
            builder.putAllNumRpcsFailedByMethod(this.rpcsFailedByMethod);
            for (String method : this.rpcsStartedByMethod.keySet()) {
                Messages.LoadBalancerAccumulatedStatsResponse.MethodStats.Builder methodStatsBuilder = Messages.LoadBalancerAccumulatedStatsResponse.MethodStats.newBuilder();
                methodStatsBuilder.setRpcsStarted(this.rpcsStartedByMethod.get(method));
                if (this.rpcStatusByMethod.containsKey(method)) {
                    methodStatsBuilder.putAllResult(this.rpcStatusByMethod.get(method));
                }
                builder.putStatsPerMethod(method, methodStatsBuilder.build());
            }
            return builder.build();
        }

        private static String getRpcTypeString(Messages.ClientConfigureRequest.RpcType rpcType) {
            return rpcType.name();
        }
    }

    private static final class RpcConfig {
        private final Messages.ClientConfigureRequest.RpcType rpcType;
        private final Metadata metadata;
        private final int timeoutSec;

        private RpcConfig(Messages.ClientConfigureRequest.RpcType rpcType, Metadata metadata, int timeoutSec) {
            this.rpcType = rpcType;
            this.metadata = metadata;
            this.timeoutSec = timeoutSec;
        }
    }

    private class XdsStatsImpl
    extends LoadBalancerStatsServiceGrpc.LoadBalancerStatsServiceImplBase {
        private XdsStatsImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getClientStats(Messages.LoadBalancerStatsRequest req, StreamObserver<Messages.LoadBalancerStatsResponse> responseObserver) {
            XdsStatsWatcher watcher;
            Object object = XdsTestClient.this.lock;
            synchronized (object) {
                long startId = XdsTestClient.this.currentRequestId + 1L;
                long endId = startId + (long)req.getNumRpcs();
                watcher = new XdsStatsWatcher(startId, endId);
                XdsTestClient.this.watchers.add(watcher);
            }
            Messages.LoadBalancerStatsResponse response = watcher.waitForRpcStats(req.getTimeoutSec());
            Object object2 = XdsTestClient.this.lock;
            synchronized (object2) {
                XdsTestClient.this.watchers.remove(watcher);
            }
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }

        @Override
        public void getClientAccumulatedStats(Messages.LoadBalancerAccumulatedStatsRequest request, StreamObserver<Messages.LoadBalancerAccumulatedStatsResponse> responseObserver) {
            responseObserver.onNext((Object)XdsTestClient.this.statsAccumulator.getRpcStats());
            responseObserver.onCompleted();
        }
    }

    private final class ConfigureUpdateServiceImpl
    extends XdsUpdateClientConfigureServiceGrpc.XdsUpdateClientConfigureServiceImplBase {
        private ConfigureUpdateServiceImpl() {
        }

        @Override
        public void configure(Messages.ClientConfigureRequest request, StreamObserver<Messages.ClientConfigureResponse> responseObserver) {
            EnumMap<Messages.ClientConfigureRequest.RpcType, Metadata> newMetadata = new EnumMap<Messages.ClientConfigureRequest.RpcType, Metadata>(Messages.ClientConfigureRequest.RpcType.class);
            for (Messages.ClientConfigureRequest.Metadata metadata : request.getMetadataList()) {
                Metadata md = (Metadata)newMetadata.get((Object)metadata.getType());
                if (md == null) {
                    md = new Metadata();
                }
                md.put(Metadata.Key.of((String)metadata.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)metadata.getValue());
                newMetadata.put(metadata.getType(), md);
            }
            ArrayList<RpcConfig> configs = new ArrayList<RpcConfig>();
            for (Messages.ClientConfigureRequest.RpcType type : request.getTypesList()) {
                Metadata md = newMetadata.containsKey((Object)type) ? (Metadata)newMetadata.get((Object)type) : new Metadata();
                int timeout = request.getTimeoutSec() != 0 ? request.getTimeoutSec() : XdsTestClient.this.rpcTimeoutSec;
                configs.add(new RpcConfig(type, md, timeout));
            }
            XdsTestClient.this.rpcConfigs = Collections.unmodifiableList(configs);
            responseObserver.onNext((Object)Messages.ClientConfigureResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }
}

