/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.LoadBalancerStatsServiceGrpc;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class XdsTestClient {
    private static Logger logger = Logger.getLogger(XdsTestClient.class.getName());
    private final Set<XdsStatsWatcher> watchers = new HashSet<XdsStatsWatcher>();
    private final Object lock = new Object();
    private final List<ManagedChannel> channels = new ArrayList<ManagedChannel>();
    private int numChannels = 1;
    private boolean printResponse = false;
    private int qps = 1;
    private int rpcTimeoutSec = 2;
    private String server = "localhost:8080";
    private int statsPort = 8081;
    private Server statsServer;
    private long currentRequestId;
    private ListeningScheduledExecutorService exec;

    public static void main(String[] args) {
        XdsTestClient client = new XdsTestClient();
        client.parseArgs(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    XdsTestClient.this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        client.run();
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("num_channels".equals(key)) {
                this.numChannels = Integer.valueOf(value);
                continue;
            }
            if ("print_response".equals(key)) {
                this.printResponse = Boolean.valueOf(value);
                continue;
            }
            if ("qps".equals(key)) {
                this.qps = Integer.valueOf(value);
                continue;
            }
            if ("rpc_timeout_sec".equals(key)) {
                this.rpcTimeoutSec = Integer.valueOf(value);
                continue;
            }
            if ("server".equals(key)) {
                this.server = value;
                continue;
            }
            if ("stats_port".equals(key)) {
                this.statsPort = Integer.valueOf(value);
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            XdsTestClient c = new XdsTestClient();
            System.err.println("Usage: [ARGS...]\n\n  --num_channels=INT     Default: " + c.numChannels + "\n  --print_response=BOOL  Write RPC response to stdout. Default: " + c.printResponse + "\n  --qps=INT              Qps per channel. Default: " + c.qps + "\n  --rpc_timeout_sec=INT  Per RPC timeout seconds. Default: " + c.rpcTimeoutSec + "\n  --server=host:port     Address of server. Default: " + c.server + "\n  --stats_port=INT       Port to expose peer distribution stats service. Default: " + c.statsPort);
            System.exit(1);
        }
    }

    private void run() {
        this.statsServer = ((NettyServerBuilder)NettyServerBuilder.forPort((int)this.statsPort).addService((BindableService)new XdsStatsImpl())).build();
        try {
            this.statsServer.start();
            for (int i = 0; i < this.numChannels; ++i) {
                this.channels.add(NettyChannelBuilder.forTarget((String)this.server).usePlaintext().build());
            }
            this.exec = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor());
            this.runQps();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error running client", t);
            System.exit(1);
        }
    }

    private void stop() throws InterruptedException {
        if (this.statsServer != null) {
            this.statsServer.shutdownNow();
            if (!this.statsServer.awaitTermination(5L, TimeUnit.SECONDS)) {
                System.err.println("Timed out waiting for server shutdown");
            }
        }
        for (ManagedChannel channel : this.channels) {
            channel.shutdownNow();
        }
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
    }

    private void runQps() throws InterruptedException, ExecutionException, TimeoutException {
        final SettableFuture failure = SettableFuture.create();
        long nanosPerQuery = TimeUnit.SECONDS.toNanos(1L) / (long)this.qps;
        final class PeriodicRpc
        implements Runnable {
            final AtomicLong messageIds = new AtomicLong();

            PeriodicRpc() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long requestId;
                final HashSet savedWatchers = new HashSet();
                Object object = XdsTestClient.this.lock;
                synchronized (object) {
                    XdsTestClient.this.currentRequestId += 1L;
                    requestId = XdsTestClient.this.currentRequestId;
                    savedWatchers.addAll(XdsTestClient.this.watchers);
                }
                Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillServerId(true).build();
                ManagedChannel channel = (ManagedChannel)XdsTestClient.this.channels.get((int)(requestId % (long)XdsTestClient.this.channels.size()));
                final ClientCall call = channel.newCall(TestServiceGrpc.getUnaryCallMethod(), CallOptions.DEFAULT.withDeadlineAfter((long)XdsTestClient.this.rpcTimeoutSec, TimeUnit.SECONDS));
                call.start((ClientCall.Listener)new ClientCall.Listener<Messages.SimpleResponse>(){
                    private String serverId;

                    public void onMessage(Messages.SimpleResponse response) {
                        this.serverId = response.getServerId();
                        if (XdsTestClient.this.printResponse) {
                            System.out.println("Greeting: Hello world, this is " + response.getHostname() + ", from " + call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
                        }
                    }

                    public void onClose(Status status, Metadata trailers) {
                        for (XdsStatsWatcher watcher : savedWatchers) {
                            watcher.rpcCompleted(requestId, this.serverId);
                        }
                    }
                }, new Metadata());
                call.sendMessage((Object)request);
                call.request(1);
                call.halfClose();
            }
        }
        ListenableScheduledFuture future = this.exec.scheduleAtFixedRate((Runnable)new PeriodicRpc(), 0L, nanosPerQuery, TimeUnit.NANOSECONDS);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

            public void onFailure(Throwable t) {
                failure.setException(t);
            }

            public void onSuccess(Object o) {
            }
        }, (Executor)MoreExecutors.directExecutor());
        failure.get();
    }

    private static class XdsStatsWatcher {
        private final CountDownLatch latch;
        private final long startId;
        private final long endId;
        private final Map<String, Integer> rpcsByPeer = new HashMap<String, Integer>();
        private final Object lock = new Object();
        private int noRemotePeer;

        private XdsStatsWatcher(long startId, long endId) {
            this.latch = new CountDownLatch(Ints.checkedCast((long)(endId - startId)));
            this.startId = startId;
            this.endId = endId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rpcCompleted(long requestId, @Nullable String serverId) {
            Object object = this.lock;
            synchronized (object) {
                if (this.startId <= requestId && requestId < this.endId) {
                    if (serverId != null) {
                        if (this.rpcsByPeer.containsKey(serverId)) {
                            this.rpcsByPeer.put(serverId, this.rpcsByPeer.get(serverId) + 1);
                        } else {
                            this.rpcsByPeer.put(serverId, 1);
                        }
                    } else {
                        ++this.noRemotePeer;
                    }
                    this.latch.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Messages.LoadBalancerStatsResponse waitForRpcStats(long timeoutSeconds) {
            try {
                boolean success = this.latch.await(timeoutSeconds, TimeUnit.SECONDS);
                if (!success) {
                    logger.log(Level.INFO, "Await timed out, returning partial stats");
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.INFO, "Await interrupted, returning partial stats", e);
                Thread.currentThread().interrupt();
            }
            Messages.LoadBalancerStatsResponse.Builder builder = Messages.LoadBalancerStatsResponse.newBuilder();
            Object object = this.lock;
            synchronized (object) {
                builder.putAllRpcsByPeer(this.rpcsByPeer);
                builder.setNumFailures(this.noRemotePeer + (int)this.latch.getCount());
            }
            return builder.build();
        }
    }

    private class XdsStatsImpl
    extends LoadBalancerStatsServiceGrpc.LoadBalancerStatsServiceImplBase {
        private XdsStatsImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getClientStats(Messages.LoadBalancerStatsRequest req, StreamObserver<Messages.LoadBalancerStatsResponse> responseObserver) {
            XdsStatsWatcher watcher;
            Object object = XdsTestClient.this.lock;
            synchronized (object) {
                long startId = XdsTestClient.this.currentRequestId + 1L;
                long endId = startId + (long)req.getNumRpcs();
                watcher = new XdsStatsWatcher(startId, endId);
                XdsTestClient.this.watchers.add(watcher);
            }
            Messages.LoadBalancerStatsResponse response = watcher.waitForRpcStats(req.getTimeoutSec());
            Object object2 = XdsTestClient.this.lock;
            synchronized (object2) {
                XdsTestClient.this.watchers.remove(watcher);
            }
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
    }
}

