/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class XdsTestServer {
    private static Logger logger = Logger.getLogger(XdsTestServer.class.getName());
    private int port = 8080;
    private String serverId = "java_server";
    private Server server;

    public static void main(String[] args) throws Exception {
        XdsTestServer server = new XdsTestServer();
        server.parseArgs(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    System.out.println("Shutting down");
                    XdsTestServer.this.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        server.start();
        System.out.println("Server started on port " + server.port);
        server.blockUntilShutdown();
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("port".equals(key)) {
                this.port = Integer.valueOf(value);
                continue;
            }
            if ("server_id".equals(key)) {
                this.serverId = value;
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            XdsTestServer s = new XdsTestServer();
            System.err.println("Usage: [ARGS...]\n\n  --port=INT          listening port for server.\n                      Default: " + s.port + "\n  --server_id=STRING  server ID for response.\n                      Default: " + s.serverId);
            System.exit(1);
        }
    }

    private void start() throws Exception {
        this.server = ((NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService((BindableService)new TestServiceImpl())).build().start();
    }

    private void stop() throws Exception {
        this.server.shutdownNow();
        if (!this.server.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.err.println("Timed out waiting for server shutdown");
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    private class TestServiceImpl
    extends TestServiceGrpc.TestServiceImplBase {
        private String host = "";

        private TestServiceImpl() {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.log(Level.WARNING, "Failed to get host", e);
            }
        }

        @Override
        public void unaryCall(Messages.SimpleRequest req, StreamObserver<Messages.SimpleResponse> responseObserver) {
            responseObserver.onNext((Object)Messages.SimpleResponse.newBuilder().setServerId(XdsTestServer.this.serverId).setHostname(this.host).build());
            responseObserver.onCompleted();
        }
    }
}

