/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import io.grpc.Metadata;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.testing.integration.Messages;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.junit.Assert;

public class Util {
    public static final Metadata.Key<Messages.SimpleContext> METADATA_KEY = ProtoUtils.keyForProto((Message)Messages.SimpleContext.getDefaultInstance());

    public static int pickUnusedPort() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            return port;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File loadCert(String name) throws IOException {
        InputStream in = Util.class.getResourceAsStream("/certs/" + name);
        File tmpFile = File.createTempFile(name, "");
        tmpFile.deleteOnExit();
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));
        try {
            int b;
            while ((b = in.read()) != -1) {
                writer.write(b);
            }
        }
        finally {
            writer.close();
        }
        return tmpFile;
    }

    public static void assertEquals(MessageLite expected, MessageLite actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else if (!expected.equals(actual)) {
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.fail((String)"Messages not equal, but assertEquals didn't throw");
        }
    }

    public static void assertEquals(List<? extends MessageLite> expected, List<? extends MessageLite> actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals(expected, actual);
        } else if (expected.size() != actual.size()) {
            Assert.assertEquals(expected, actual);
        } else {
            for (int i = 0; i < expected.size(); ++i) {
                Util.assertEquals(expected.get(i), actual.get(i));
            }
        }
    }

    public static SSLSocketFactory getSslSocketFactoryForCertainCert(File certChainFile) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new BufferedInputStream(new FileInputStream(certChainFile)));
        X500Principal principal = cert.getSubjectX500Principal();
        ks.setCertificateEntry(principal.getName("RFC2253"), cert);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(ks);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustManagerFactory.getTrustManagers(), null);
        return context.getSocketFactory();
    }
}

