/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.EmptyProtos;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.Messages;

public class ReconnectServiceGrpc {
    public static final String SERVICE_NAME = "grpc.testing.ReconnectService";
    public static final MethodDescriptor<EmptyProtos.Empty, EmptyProtos.Empty> METHOD_START = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.ReconnectService", (String)"Start"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance()));
    public static final MethodDescriptor<EmptyProtos.Empty, Messages.ReconnectInfo> METHOD_STOP = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"grpc.testing.ReconnectService", (String)"Stop"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)EmptyProtos.Empty.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Messages.ReconnectInfo.getDefaultInstance()));
    private static final int METHODID_START = 0;
    private static final int METHODID_STOP = 1;

    private ReconnectServiceGrpc() {
    }

    public static ReconnectServiceStub newStub(Channel channel) {
        return new ReconnectServiceStub(channel);
    }

    public static ReconnectServiceBlockingStub newBlockingStub(Channel channel) {
        return new ReconnectServiceBlockingStub(channel);
    }

    public static ReconnectServiceFutureStub newFutureStub(Channel channel) {
        return new ReconnectServiceFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(ReconnectService serviceImpl) {
        return ServerServiceDefinition.builder((String)SERVICE_NAME).addMethod(METHOD_START, ServerCalls.asyncUnaryCall(new MethodHandlers(serviceImpl, 0))).addMethod(METHOD_STOP, ServerCalls.asyncUnaryCall(new MethodHandlers(serviceImpl, 1))).build();
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final ReconnectService serviceImpl;
        private final int methodId;

        public MethodHandlers(ReconnectService serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.start((EmptyProtos.Empty)request, responseObserver);
                    break;
                }
                case 1: {
                    this.serviceImpl.stop((EmptyProtos.Empty)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static class ReconnectServiceFutureStub
    extends AbstractStub<ReconnectServiceFutureStub>
    implements ReconnectServiceFutureClient {
        private ReconnectServiceFutureStub(Channel channel) {
            super(channel);
        }

        private ReconnectServiceFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected ReconnectServiceFutureStub build(Channel channel, CallOptions callOptions) {
            return new ReconnectServiceFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<EmptyProtos.Empty> start(EmptyProtos.Empty request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_START, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<Messages.ReconnectInfo> stop(EmptyProtos.Empty request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_STOP, this.getCallOptions()), (Object)request);
        }
    }

    public static class ReconnectServiceBlockingStub
    extends AbstractStub<ReconnectServiceBlockingStub>
    implements ReconnectServiceBlockingClient {
        private ReconnectServiceBlockingStub(Channel channel) {
            super(channel);
        }

        private ReconnectServiceBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected ReconnectServiceBlockingStub build(Channel channel, CallOptions callOptions) {
            return new ReconnectServiceBlockingStub(channel, callOptions);
        }

        @Override
        public EmptyProtos.Empty start(EmptyProtos.Empty request) {
            return (EmptyProtos.Empty)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_START, (CallOptions)this.getCallOptions(), (Object)request);
        }

        @Override
        public Messages.ReconnectInfo stop(EmptyProtos.Empty request) {
            return (Messages.ReconnectInfo)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_STOP, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static class ReconnectServiceStub
    extends AbstractStub<ReconnectServiceStub>
    implements ReconnectService {
        private ReconnectServiceStub(Channel channel) {
            super(channel);
        }

        private ReconnectServiceStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected ReconnectServiceStub build(Channel channel, CallOptions callOptions) {
            return new ReconnectServiceStub(channel, callOptions);
        }

        @Override
        public void start(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_START, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void stop(EmptyProtos.Empty request, StreamObserver<Messages.ReconnectInfo> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_STOP, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static interface ReconnectServiceFutureClient {
        public ListenableFuture<EmptyProtos.Empty> start(EmptyProtos.Empty var1);

        public ListenableFuture<Messages.ReconnectInfo> stop(EmptyProtos.Empty var1);
    }

    public static interface ReconnectServiceBlockingClient {
        public EmptyProtos.Empty start(EmptyProtos.Empty var1);

        public Messages.ReconnectInfo stop(EmptyProtos.Empty var1);
    }

    public static abstract class AbstractReconnectService
    implements ReconnectService,
    BindableService {
        @Override
        public void start(EmptyProtos.Empty request, StreamObserver<EmptyProtos.Empty> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_START, responseObserver);
        }

        @Override
        public void stop(EmptyProtos.Empty request, StreamObserver<Messages.ReconnectInfo> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_STOP, responseObserver);
        }

        public ServerServiceDefinition bindService() {
            return ReconnectServiceGrpc.bindService(this);
        }
    }

    public static interface ReconnectService {
        public void start(EmptyProtos.Empty var1, StreamObserver<EmptyProtos.Empty> var2);

        public void stop(EmptyProtos.Empty var1, StreamObserver<Messages.ReconnectInfo> var2);
    }
}

