/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Attributes;
import io.grpc.Channel;
import io.grpc.ClientStreamTracer;
import io.grpc.ConnectivityState;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.grpclb.ClientStats;
import io.grpc.grpclb.GrpclbClientLoadRecorder;
import io.grpc.grpclb.GrpclbConstants;
import io.grpc.grpclb.InitialLoadBalanceRequest;
import io.grpc.grpclb.InitialLoadBalanceResponse;
import io.grpc.grpclb.LbAddressGroup;
import io.grpc.grpclb.LoadBalanceRequest;
import io.grpc.grpclb.LoadBalanceResponse;
import io.grpc.grpclb.LoadBalancerGrpc;
import io.grpc.grpclb.Server;
import io.grpc.grpclb.ServerList;
import io.grpc.grpclb.TimeProvider;
import io.grpc.internal.LogId;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.WithLogId;
import io.grpc.stub.StreamObserver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class GrpclbLoadBalancer
extends LoadBalancer
implements WithLogId {
    private static final Logger logger = Logger.getLogger(GrpclbLoadBalancer.class.getName());
    @VisibleForTesting
    static final LoadBalancer.PickResult DROP_PICK_RESULT = LoadBalancer.PickResult.withError((Status)Status.UNAVAILABLE.withDescription("Dropped as requested by balancer"));
    @VisibleForTesting
    static final LoadBalancer.SubchannelPicker BUFFER_PICKER = new LoadBalancer.SubchannelPicker(){

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }
    };
    private final LogId logId = LogId.allocate((String)((Object)((Object)this)).getClass().getName());
    private final String serviceName;
    private final LoadBalancer.Helper helper;
    private final LoadBalancer.Factory pickFirstBalancerFactory;
    private final LoadBalancer.Factory roundRobinBalancerFactory;
    private final ObjectPool<ScheduledExecutorService> timerServicePool;
    private final TimeProvider time;
    private static final Attributes.Key<AtomicReference<ConnectivityStateInfo>> STATE_INFO = Attributes.Key.of((String)"io.grpc.grpclb.GrpclbLoadBalancer.stateInfo");
    private ScheduledExecutorService timerService;
    @Nullable
    private LoadBalancer delegate;
    private GrpclbConstants.LbPolicy lbPolicy;
    @Nullable
    private LbAddressGroup lbAddressGroup;
    @Nullable
    private ManagedChannel lbCommChannel;
    @Nullable
    private LbStream lbStream;
    private Map<EquivalentAddressGroup, LoadBalancer.Subchannel> subchannels = Collections.emptyMap();
    private List<RoundRobinEntry> roundRobinList = Collections.emptyList();
    private LoadBalancer.SubchannelPicker currentPicker = BUFFER_PICKER;

    GrpclbLoadBalancer(LoadBalancer.Helper helper, LoadBalancer.Factory pickFirstBalancerFactory, LoadBalancer.Factory roundRobinBalancerFactory, ObjectPool<ScheduledExecutorService> timerServicePool, TimeProvider time) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.serviceName = (String)Preconditions.checkNotNull((Object)helper.getAuthority(), (Object)"helper returns null authority");
        this.pickFirstBalancerFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)pickFirstBalancerFactory, (Object)"pickFirstBalancerFactory");
        this.roundRobinBalancerFactory = (LoadBalancer.Factory)Preconditions.checkNotNull((Object)roundRobinBalancerFactory, (Object)"roundRobinBalancerFactory");
        this.timerServicePool = (ObjectPool)Preconditions.checkNotNull(timerServicePool, (Object)"timerServicePool");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timerServicePool.getObject(), (Object)"timerService");
        this.time = (TimeProvider)Preconditions.checkNotNull((Object)time, (Object)"time provider");
    }

    public LogId getLogId() {
        return this.logId;
    }

    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newState) {
        if (this.delegate != null) {
            this.delegate.handleSubchannelState(subchannel, newState);
            return;
        }
        if (newState.getState() == ConnectivityState.SHUTDOWN || !this.subchannels.values().contains(subchannel)) {
            return;
        }
        if (newState.getState() == ConnectivityState.IDLE) {
            subchannel.requestConnection();
        }
        ((AtomicReference)subchannel.getAttributes().get(STATE_INFO)).set(newState);
        this.maybeUpdatePicker();
    }

    public void handleResolvedAddressGroups(List<EquivalentAddressGroup> updatedServers, Attributes attributes) {
        GrpclbConstants.LbPolicy newLbPolicy = (GrpclbConstants.LbPolicy)((Object)attributes.get(GrpclbConstants.ATTR_LB_POLICY));
        ArrayList<LbAddressGroup> newLbAddressGroups = new ArrayList<LbAddressGroup>();
        ArrayList<EquivalentAddressGroup> newBackendServers = new ArrayList<EquivalentAddressGroup>();
        for (EquivalentAddressGroup server : updatedServers) {
            String lbAddrAuthority = (String)server.getAttributes().get(GrpclbConstants.ATTR_LB_ADDR_AUTHORITY);
            if (lbAddrAuthority != null) {
                newLbAddressGroups.add(new LbAddressGroup(server, lbAddrAuthority));
                continue;
            }
            newBackendServers.add(server);
        }
        if (!newLbAddressGroups.isEmpty() && newLbPolicy != GrpclbConstants.LbPolicy.GRPCLB) {
            newLbPolicy = GrpclbConstants.LbPolicy.GRPCLB;
            logger.log(Level.FINE, "[{0}] Switching to GRPCLB because there is at least one balancer", this.logId);
        }
        if (newLbPolicy == null) {
            logger.log(Level.FINE, "[{0}] New config missing policy. Using PICK_FIRST", this.logId);
            newLbPolicy = GrpclbConstants.LbPolicy.PICK_FIRST;
        }
        if (newLbPolicy != this.lbPolicy) {
            this.shutdownDelegate();
            this.shutdownLbComm();
            this.lbAddressGroup = null;
            switch (newLbPolicy) {
                case PICK_FIRST: {
                    this.delegate = (LoadBalancer)Preconditions.checkNotNull((Object)this.pickFirstBalancerFactory.newLoadBalancer(this.helper), (Object)"pickFirstBalancerFactory.newLoadBalancer()");
                    break;
                }
                case ROUND_ROBIN: {
                    this.delegate = (LoadBalancer)Preconditions.checkNotNull((Object)this.roundRobinBalancerFactory.newLoadBalancer(this.helper), (Object)"roundRobinBalancerFactory.newLoadBalancer()");
                    break;
                }
            }
        }
        this.lbPolicy = newLbPolicy;
        switch (this.lbPolicy) {
            case PICK_FIRST: 
            case ROUND_ROBIN: {
                Preconditions.checkNotNull((Object)this.delegate, (Object)("delegate should not be null. newLbPolicy=" + (Object)((Object)newLbPolicy)));
                this.delegate.handleResolvedAddressGroups(newBackendServers, attributes);
                break;
            }
            case GRPCLB: {
                if (newLbAddressGroups.isEmpty()) {
                    this.shutdownLbComm();
                    this.lbAddressGroup = null;
                    this.handleGrpclbError(Status.UNAVAILABLE.withDescription("NameResolver returned no LB address while asking for GRPCLB"));
                    break;
                }
                this.lbAddressGroup = this.flattenLbAddressGroups(newLbAddressGroups);
                this.startLbComm();
                if (this.lbStream != null) break;
                this.startLbRpc();
                break;
            }
        }
    }

    private void shutdownLbComm() {
        if (this.lbCommChannel != null) {
            this.lbCommChannel.shutdown();
            this.lbCommChannel = null;
        }
        this.shutdownLbRpc();
    }

    private void shutdownLbRpc() {
        if (this.lbStream != null) {
            this.lbStream.close(null);
        }
    }

    private void startLbComm() {
        if (this.lbCommChannel == null) {
            this.lbCommChannel = this.helper.createOobChannel(this.lbAddressGroup.getAddresses(), this.lbAddressGroup.getAuthority());
        } else if (this.lbAddressGroup.getAuthority().equals(this.lbCommChannel.authority())) {
            this.helper.updateOobChannelAddresses(this.lbCommChannel, this.lbAddressGroup.getAddresses());
        } else {
            this.shutdownLbComm();
            this.lbCommChannel = this.helper.createOobChannel(this.lbAddressGroup.getAddresses(), this.lbAddressGroup.getAuthority());
        }
    }

    private void startLbRpc() {
        Preconditions.checkState((this.lbStream == null ? 1 : 0) != 0, (Object)"previous lbStream has not been cleared yet");
        LoadBalancerGrpc.LoadBalancerStub stub = LoadBalancerGrpc.newStub((Channel)this.lbCommChannel);
        this.lbStream = new LbStream(stub);
        LoadBalanceRequest initRequest = LoadBalanceRequest.newBuilder().setInitialRequest(InitialLoadBalanceRequest.newBuilder().setName(this.serviceName).build()).build();
        try {
            this.lbStream.lbRequestWriter.onNext((Object)initRequest);
        }
        catch (Exception e) {
            this.lbStream.close(e);
        }
    }

    private void shutdownDelegate() {
        if (this.delegate != null) {
            this.delegate.shutdown();
            this.delegate = null;
        }
    }

    public void shutdown() {
        this.shutdownDelegate();
        this.shutdownLbComm();
        for (LoadBalancer.Subchannel subchannel : this.subchannels.values()) {
            subchannel.shutdown();
        }
        this.subchannels = Collections.emptyMap();
        this.timerService = (ScheduledExecutorService)this.timerServicePool.returnObject((Object)this.timerService);
    }

    private void handleGrpclbError(Status status) {
        logger.log(Level.FINE, "[{0}] Had an error: {1}; roundRobinList={2}", new Object[]{this.logId, status, this.roundRobinList});
        if (this.roundRobinList.isEmpty()) {
            this.maybeUpdatePicker(ConnectivityState.TRANSIENT_FAILURE, new ErrorPicker(status));
        }
    }

    public void handleNameResolutionError(Status error) {
        if (this.delegate != null) {
            this.delegate.handleNameResolutionError(error);
        } else {
            this.handleGrpclbError(error);
        }
    }

    @Nullable
    @VisibleForTesting
    GrpclbClientLoadRecorder getLoadRecorder() {
        if (this.lbStream == null) {
            return null;
        }
        return this.lbStream.loadRecorder;
    }

    private void maybeUpdatePicker() {
        ArrayList<RoundRobinEntry> resultList = new ArrayList<RoundRobinEntry>();
        Status error = null;
        boolean hasIdle = false;
        for (RoundRobinEntry entry : this.roundRobinList) {
            LoadBalancer.Subchannel subchannel = entry.result.getSubchannel();
            if (subchannel != null) {
                Attributes attrs = subchannel.getAttributes();
                ConnectivityStateInfo stateInfo = (ConnectivityStateInfo)((AtomicReference)attrs.get(STATE_INFO)).get();
                if (stateInfo.getState() == ConnectivityState.READY) {
                    resultList.add(entry);
                    continue;
                }
                if (stateInfo.getState() == ConnectivityState.TRANSIENT_FAILURE) {
                    error = stateInfo.getStatus();
                    continue;
                }
                if (stateInfo.getState() != ConnectivityState.IDLE) continue;
                hasIdle = true;
                continue;
            }
            resultList.add(entry);
        }
        if (resultList.isEmpty()) {
            if (error != null && !hasIdle) {
                logger.log(Level.FINE, "[{0}] No ready Subchannel. Using error: {1}", new Object[]{this.logId, error});
                this.maybeUpdatePicker(ConnectivityState.TRANSIENT_FAILURE, new ErrorPicker(error));
            } else {
                logger.log(Level.FINE, "[{0}] No ready Subchannel and still connecting", this.logId);
                this.maybeUpdatePicker(ConnectivityState.CONNECTING, BUFFER_PICKER);
            }
        } else {
            logger.log(Level.FINE, "[{0}] Using list {1}", new Object[]{this.logId, resultList});
            this.maybeUpdatePicker(ConnectivityState.READY, new RoundRobinPicker(resultList));
        }
    }

    private void maybeUpdatePicker(ConnectivityState state, LoadBalancer.SubchannelPicker picker) {
        if (picker == BUFFER_PICKER && this.currentPicker == BUFFER_PICKER) {
            return;
        }
        if (picker instanceof RoundRobinPicker && this.currentPicker instanceof RoundRobinPicker && ((RoundRobinPicker)picker).list.equals(((RoundRobinPicker)this.currentPicker).list)) {
            return;
        }
        this.currentPicker = picker;
        this.helper.updateBalancingState(state, picker);
    }

    @VisibleForTesting
    LoadBalancer getDelegate() {
        return this.delegate;
    }

    @VisibleForTesting
    GrpclbConstants.LbPolicy getLbPolicy() {
        return this.lbPolicy;
    }

    private LbAddressGroup flattenLbAddressGroups(List<LbAddressGroup> groupList) {
        assert (!groupList.isEmpty());
        ArrayList<EquivalentAddressGroup> eags = new ArrayList<EquivalentAddressGroup>(groupList.size());
        String authority = groupList.get(0).getAuthority();
        for (LbAddressGroup group : groupList) {
            if (!authority.equals(group.getAuthority())) {
                logger.log(Level.WARNING, "[{0}] Multiple authorities found for LB. Skipping addresses for {0} in preference to {1}", new Object[]{this.logId, group.getAuthority(), authority});
                continue;
            }
            eags.add(group.getAddresses());
        }
        return new LbAddressGroup(GrpclbLoadBalancer.flattenEquivalentAddressGroup(eags), authority);
    }

    private static EquivalentAddressGroup flattenEquivalentAddressGroup(List<EquivalentAddressGroup> groupList) {
        ArrayList addrs = new ArrayList();
        for (EquivalentAddressGroup group : groupList) {
            addrs.addAll(group.getAddresses());
        }
        return new EquivalentAddressGroup(addrs);
    }

    @VisibleForTesting
    static final class RoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        final List<RoundRobinEntry> list;
        private int index;

        RoundRobinPicker(List<RoundRobinEntry> resultList) {
            Preconditions.checkArgument((!resultList.isEmpty() ? 1 : 0) != 0, (Object)"resultList is empty");
            this.list = (List)Preconditions.checkNotNull(resultList, (Object)"resultList");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            List<RoundRobinEntry> list = this.list;
            synchronized (list) {
                RoundRobinEntry result = this.list.get(this.index);
                ++this.index;
                if (this.index == this.list.size()) {
                    this.index = 0;
                }
                result.updateHeaders(args.getHeaders());
                if (result.isDrop()) {
                    result.loadRecorder.recordDroppedRequest(result.token);
                }
                return result.result;
            }
        }
    }

    @VisibleForTesting
    static final class RoundRobinEntry {
        final LoadBalancer.PickResult result;
        final GrpclbClientLoadRecorder loadRecorder;
        final String token;

        private RoundRobinEntry(LoadBalancer.PickResult result, GrpclbClientLoadRecorder loadRecorder, String token) {
            this.result = (LoadBalancer.PickResult)Preconditions.checkNotNull((Object)result);
            this.loadRecorder = (GrpclbClientLoadRecorder)((Object)Preconditions.checkNotNull((Object)((Object)loadRecorder), (Object)"loadRecorder"));
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
        }

        static RoundRobinEntry newEntry(LoadBalancer.Subchannel subchannel, GrpclbClientLoadRecorder loadRecorder, String token) {
            return new RoundRobinEntry(LoadBalancer.PickResult.withSubchannel((LoadBalancer.Subchannel)subchannel, (ClientStreamTracer.Factory)loadRecorder), loadRecorder, token);
        }

        static RoundRobinEntry newDropEntry(GrpclbClientLoadRecorder loadRecorder, String token) {
            return new RoundRobinEntry(DROP_PICK_RESULT, loadRecorder, token);
        }

        void updateHeaders(Metadata headers) {
            if (!this.isDrop()) {
                headers.discardAll(GrpclbConstants.TOKEN_METADATA_KEY);
                headers.put(GrpclbConstants.TOKEN_METADATA_KEY, (Object)this.token);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("result", (Object)this.result).add("token", (Object)this.token).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.result, this.token});
        }

        public boolean equals(Object other) {
            if (!(other instanceof RoundRobinEntry)) {
                return false;
            }
            RoundRobinEntry that = (RoundRobinEntry)other;
            return Objects.equal((Object)this.result, (Object)that.result) && Objects.equal((Object)this.token, (Object)that.token);
        }

        boolean isDrop() {
            return this.result == DROP_PICK_RESULT;
        }
    }

    @VisibleForTesting
    static final class ErrorPicker
    extends LoadBalancer.SubchannelPicker {
        final LoadBalancer.PickResult result;

        ErrorPicker(Status status) {
            this.result = LoadBalancer.PickResult.withError((Status)status);
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.result;
        }
    }

    private class LbStream
    implements StreamObserver<LoadBalanceResponse> {
        final StreamObserver<LoadBalanceRequest> lbRequestWriter;
        final GrpclbClientLoadRecorder loadRecorder;
        final Runnable loadReportRunnable = new Runnable(){

            @Override
            public void run() {
                GrpclbLoadBalancer.this.helper.runSerialized(new Runnable(){

                    @Override
                    public void run() {
                        LbStream.this.loadReportTask = null;
                        LbStream.this.sendLoadReport();
                    }
                });
            }
        };
        boolean initialResponseReceived;
        boolean closed;
        long loadReportIntervalMillis = -1L;
        ScheduledFuture<?> loadReportTask;

        LbStream(LoadBalancerGrpc.LoadBalancerStub stub) {
            this.loadRecorder = new GrpclbClientLoadRecorder(GrpclbLoadBalancer.this.time);
            this.lbRequestWriter = ((LoadBalancerGrpc.LoadBalancerStub)stub.withWaitForReady()).balanceLoad(this);
        }

        public void onNext(final LoadBalanceResponse response) {
            GrpclbLoadBalancer.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleResponse(response);
                }
            });
        }

        public void onError(final Throwable error) {
            GrpclbLoadBalancer.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.fromThrowable((Throwable)error).augmentDescription("Stream to GRPCLB LoadBalancer had an error"));
                }
            });
        }

        public void onCompleted() {
            GrpclbLoadBalancer.this.helper.runSerialized(new Runnable(){

                @Override
                public void run() {
                    LbStream.this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Stream to GRPCLB LoadBalancer was closed"));
                }
            });
        }

        private void sendLoadReport() {
            if (this.closed) {
                return;
            }
            ClientStats stats = this.loadRecorder.generateLoadReport();
            try {
                this.lbRequestWriter.onNext((Object)LoadBalanceRequest.newBuilder().setClientStats(stats).build());
                this.scheduleNextLoadReport();
            }
            catch (Exception e) {
                this.close(e);
            }
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportIntervalMillis > 0L) {
                this.loadReportTask = GrpclbLoadBalancer.this.timerService.schedule(this.loadReportRunnable, this.loadReportIntervalMillis, TimeUnit.MILLISECONDS);
            }
        }

        private void handleResponse(LoadBalanceResponse response) {
            if (this.closed) {
                return;
            }
            logger.log(Level.FINE, "[{0}] Got an LB response: {1}", new Object[]{GrpclbLoadBalancer.this.logId, response});
            LoadBalanceResponse.LoadBalanceResponseTypeCase typeCase = response.getLoadBalanceResponseTypeCase();
            if (!this.initialResponseReceived) {
                if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.INITIAL_RESPONSE) {
                    logger.log(Level.WARNING, "[{0}] : Did not receive response with type initial response: {1}", new Object[]{GrpclbLoadBalancer.this.logId, response});
                    return;
                }
                this.initialResponseReceived = true;
                InitialLoadBalanceResponse initialResponse = response.getInitialResponse();
                this.loadReportIntervalMillis = Durations.toMillis((Duration)initialResponse.getClientStatsReportInterval());
                this.scheduleNextLoadReport();
                return;
            }
            if (typeCase != LoadBalanceResponse.LoadBalanceResponseTypeCase.SERVER_LIST) {
                logger.log(Level.WARNING, "[{0}] : Ignoring unexpected response type: {1}", new Object[]{GrpclbLoadBalancer.this.logId, response});
                return;
            }
            ServerList serverList = response.getServerList();
            HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel> newSubchannelMap = new HashMap<EquivalentAddressGroup, LoadBalancer.Subchannel>();
            ArrayList<RoundRobinEntry> newRoundRobinList = new ArrayList<RoundRobinEntry>();
            for (Server server : serverList.getServersList()) {
                InetSocketAddress address;
                String token = server.getLoadBalanceToken();
                if (server.getDrop()) {
                    newRoundRobinList.add(RoundRobinEntry.newDropEntry(this.loadRecorder, token));
                    continue;
                }
                try {
                    address = new InetSocketAddress(InetAddress.getByAddress(server.getIpAddress().toByteArray()), server.getPort());
                }
                catch (UnknownHostException e) {
                    GrpclbLoadBalancer.this.handleGrpclbError(Status.UNAVAILABLE.withCause((Throwable)e));
                    continue;
                }
                EquivalentAddressGroup eag = new EquivalentAddressGroup((SocketAddress)address);
                LoadBalancer.Subchannel subchannel = (LoadBalancer.Subchannel)newSubchannelMap.get(eag);
                if (subchannel == null) {
                    subchannel = (LoadBalancer.Subchannel)GrpclbLoadBalancer.this.subchannels.get(eag);
                    if (subchannel == null) {
                        Attributes subchannelAttrs = Attributes.newBuilder().set(STATE_INFO, new AtomicReference<ConnectivityStateInfo>(ConnectivityStateInfo.forNonError((ConnectivityState)ConnectivityState.IDLE))).build();
                        subchannel = GrpclbLoadBalancer.this.helper.createSubchannel(eag, subchannelAttrs);
                        subchannel.requestConnection();
                    }
                    newSubchannelMap.put(eag, subchannel);
                }
                newRoundRobinList.add(RoundRobinEntry.newEntry(subchannel, this.loadRecorder, token));
            }
            for (Map.Entry entry : GrpclbLoadBalancer.this.subchannels.entrySet()) {
                EquivalentAddressGroup eag = (EquivalentAddressGroup)entry.getKey();
                if (newSubchannelMap.containsKey(eag)) continue;
                ((LoadBalancer.Subchannel)entry.getValue()).shutdown();
            }
            GrpclbLoadBalancer.this.subchannels = newSubchannelMap;
            GrpclbLoadBalancer.this.roundRobinList = newRoundRobinList;
            GrpclbLoadBalancer.this.maybeUpdatePicker();
        }

        private void handleStreamClosed(Status status) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            GrpclbLoadBalancer.this.handleGrpclbError(status);
            GrpclbLoadBalancer.this.startLbRpc();
        }

        void close(@Nullable Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            try {
                if (error == null) {
                    this.lbRequestWriter.onCompleted();
                } else {
                    this.lbRequestWriter.onError((Throwable)error);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void cleanUp() {
            if (this.loadReportTask != null) {
                this.loadReportTask.cancel(false);
                this.loadReportTask = null;
            }
            if (GrpclbLoadBalancer.this.lbStream == this) {
                GrpclbLoadBalancer.this.lbStream = null;
            }
        }
    }
}

