/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.observabilitylog.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.grpc.observabilitylog.v1.Address;
import io.grpc.observabilitylog.v1.AddressOrBuilder;
import io.grpc.observabilitylog.v1.GrpcLogRecordOrBuilder;
import io.grpc.observabilitylog.v1.ObservabilityLogProto;
import io.grpc.observabilitylog.v1.Payload;
import io.grpc.observabilitylog.v1.PayloadOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class GrpcLogRecord
extends GeneratedMessageV3
implements GrpcLogRecordOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int CALL_ID_FIELD_NUMBER = 2;
    private volatile Object callId_ = "";
    public static final int SEQUENCE_ID_FIELD_NUMBER = 3;
    private long sequenceId_ = 0L;
    public static final int TYPE_FIELD_NUMBER = 4;
    private int type_ = 0;
    public static final int LOGGER_FIELD_NUMBER = 5;
    private int logger_ = 0;
    public static final int PAYLOAD_FIELD_NUMBER = 6;
    private Payload payload_;
    public static final int PAYLOAD_TRUNCATED_FIELD_NUMBER = 7;
    private boolean payloadTruncated_ = false;
    public static final int PEER_FIELD_NUMBER = 8;
    private Address peer_;
    public static final int AUTHORITY_FIELD_NUMBER = 10;
    private volatile Object authority_ = "";
    public static final int SERVICE_NAME_FIELD_NUMBER = 11;
    private volatile Object serviceName_ = "";
    public static final int METHOD_NAME_FIELD_NUMBER = 12;
    private volatile Object methodName_ = "";
    private byte memoizedIsInitialized = (byte)-1;
    private static final GrpcLogRecord DEFAULT_INSTANCE = new GrpcLogRecord();
    private static final Parser<GrpcLogRecord> PARSER = new AbstractParser<GrpcLogRecord>(){

        public GrpcLogRecord parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GrpcLogRecord.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GrpcLogRecord(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GrpcLogRecord() {
        this.callId_ = "";
        this.type_ = 0;
        this.logger_ = 0;
        this.authority_ = "";
        this.serviceName_ = "";
        this.methodName_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GrpcLogRecord();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ObservabilityLogProto.internal_static_grpc_observabilitylog_v1_GrpcLogRecord_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ObservabilityLogProto.internal_static_grpc_observabilitylog_v1_GrpcLogRecord_fieldAccessorTable.ensureFieldAccessorsInitialized(GrpcLogRecord.class, Builder.class);
    }

    @Override
    public String getCallId() {
        Object ref = this.callId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.callId_ = s;
        return s;
    }

    @Override
    public ByteString getCallIdBytes() {
        Object ref = this.callId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.callId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getSequenceId() {
        return this.sequenceId_;
    }

    @Override
    public int getTypeValue() {
        return this.type_;
    }

    @Override
    public EventType getType() {
        EventType result = EventType.forNumber(this.type_);
        return result == null ? EventType.UNRECOGNIZED : result;
    }

    @Override
    public int getLoggerValue() {
        return this.logger_;
    }

    @Override
    public EventLogger getLogger() {
        EventLogger result = EventLogger.forNumber(this.logger_);
        return result == null ? EventLogger.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasPayload() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Payload getPayload() {
        return this.payload_ == null ? Payload.getDefaultInstance() : this.payload_;
    }

    @Override
    public PayloadOrBuilder getPayloadOrBuilder() {
        return this.payload_ == null ? Payload.getDefaultInstance() : this.payload_;
    }

    @Override
    public boolean getPayloadTruncated() {
        return this.payloadTruncated_;
    }

    @Override
    public boolean hasPeer() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Address getPeer() {
        return this.peer_ == null ? Address.getDefaultInstance() : this.peer_;
    }

    @Override
    public AddressOrBuilder getPeerOrBuilder() {
        return this.peer_ == null ? Address.getDefaultInstance() : this.peer_;
    }

    @Override
    public String getAuthority() {
        Object ref = this.authority_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.authority_ = s;
        return s;
    }

    @Override
    public ByteString getAuthorityBytes() {
        Object ref = this.authority_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.authority_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getServiceName() {
        Object ref = this.serviceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.serviceName_ = s;
        return s;
    }

    @Override
    public ByteString getServiceNameBytes() {
        Object ref = this.serviceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.serviceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getMethodName() {
        Object ref = this.methodName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.methodName_ = s;
        return s;
    }

    @Override
    public ByteString getMethodNameBytes() {
        Object ref = this.methodName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.methodName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.callId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.callId_);
        }
        if (this.sequenceId_ != 0L) {
            output.writeUInt64(3, this.sequenceId_);
        }
        if (this.type_ != EventType.EVENT_TYPE_UNKNOWN.getNumber()) {
            output.writeEnum(4, this.type_);
        }
        if (this.logger_ != EventLogger.LOGGER_UNKNOWN.getNumber()) {
            output.writeEnum(5, this.logger_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(6, (MessageLite)this.getPayload());
        }
        if (this.payloadTruncated_) {
            output.writeBool(7, this.payloadTruncated_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(8, (MessageLite)this.getPeer());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.authority_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)10, (Object)this.authority_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.serviceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.methodName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.methodName_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.callId_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.callId_);
        }
        if (this.sequenceId_ != 0L) {
            size += CodedOutputStream.computeUInt64Size((int)3, (long)this.sequenceId_);
        }
        if (this.type_ != EventType.EVENT_TYPE_UNKNOWN.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)4, (int)this.type_);
        }
        if (this.logger_ != EventLogger.LOGGER_UNKNOWN.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.logger_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getPayload());
        }
        if (this.payloadTruncated_) {
            size += CodedOutputStream.computeBoolSize((int)7, (boolean)this.payloadTruncated_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getPeer());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.authority_)) {
            size += GeneratedMessageV3.computeStringSize((int)10, (Object)this.authority_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.serviceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)11, (Object)this.serviceName_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.methodName_)) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.methodName_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GrpcLogRecord)) {
            return super.equals(obj);
        }
        GrpcLogRecord other = (GrpcLogRecord)obj;
        if (!this.getCallId().equals(other.getCallId())) {
            return false;
        }
        if (this.getSequenceId() != other.getSequenceId()) {
            return false;
        }
        if (this.type_ != other.type_) {
            return false;
        }
        if (this.logger_ != other.logger_) {
            return false;
        }
        if (this.hasPayload() != other.hasPayload()) {
            return false;
        }
        if (this.hasPayload() && !this.getPayload().equals(other.getPayload())) {
            return false;
        }
        if (this.getPayloadTruncated() != other.getPayloadTruncated()) {
            return false;
        }
        if (this.hasPeer() != other.hasPeer()) {
            return false;
        }
        if (this.hasPeer() && !this.getPeer().equals(other.getPeer())) {
            return false;
        }
        if (!this.getAuthority().equals(other.getAuthority())) {
            return false;
        }
        if (!this.getServiceName().equals(other.getServiceName())) {
            return false;
        }
        if (!this.getMethodName().equals(other.getMethodName())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GrpcLogRecord.getDescriptor().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getCallId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashLong((long)this.getSequenceId());
        hash = 37 * hash + 4;
        hash = 53 * hash + this.type_;
        hash = 37 * hash + 5;
        hash = 53 * hash + this.logger_;
        if (this.hasPayload()) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getPayload().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getPayloadTruncated());
        if (this.hasPeer()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getPeer().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getAuthority().hashCode();
        hash = 37 * hash + 11;
        hash = 53 * hash + this.getServiceName().hashCode();
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getMethodName().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GrpcLogRecord parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GrpcLogRecord)PARSER.parseFrom(data);
    }

    public static GrpcLogRecord parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GrpcLogRecord)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GrpcLogRecord parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GrpcLogRecord)PARSER.parseFrom(data);
    }

    public static GrpcLogRecord parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GrpcLogRecord)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GrpcLogRecord parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GrpcLogRecord)PARSER.parseFrom(data);
    }

    public static GrpcLogRecord parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GrpcLogRecord)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GrpcLogRecord parseFrom(InputStream input) throws IOException {
        return (GrpcLogRecord)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GrpcLogRecord parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GrpcLogRecord)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GrpcLogRecord parseDelimitedFrom(InputStream input) throws IOException {
        return (GrpcLogRecord)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GrpcLogRecord parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GrpcLogRecord)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GrpcLogRecord parseFrom(CodedInputStream input) throws IOException {
        return (GrpcLogRecord)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GrpcLogRecord parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GrpcLogRecord)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GrpcLogRecord.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GrpcLogRecord prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GrpcLogRecord getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GrpcLogRecord> parser() {
        return PARSER;
    }

    public Parser<GrpcLogRecord> getParserForType() {
        return PARSER;
    }

    public GrpcLogRecord getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GrpcLogRecordOrBuilder {
        private int bitField0_;
        private Object callId_ = "";
        private long sequenceId_;
        private int type_ = 0;
        private int logger_ = 0;
        private Payload payload_;
        private SingleFieldBuilderV3<Payload, Payload.Builder, PayloadOrBuilder> payloadBuilder_;
        private boolean payloadTruncated_;
        private Address peer_;
        private SingleFieldBuilderV3<Address, Address.Builder, AddressOrBuilder> peerBuilder_;
        private Object authority_ = "";
        private Object serviceName_ = "";
        private Object methodName_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return ObservabilityLogProto.internal_static_grpc_observabilitylog_v1_GrpcLogRecord_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ObservabilityLogProto.internal_static_grpc_observabilitylog_v1_GrpcLogRecord_fieldAccessorTable.ensureFieldAccessorsInitialized(GrpcLogRecord.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getPayloadFieldBuilder();
                this.getPeerFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.callId_ = "";
            this.sequenceId_ = 0L;
            this.type_ = 0;
            this.logger_ = 0;
            this.payload_ = null;
            if (this.payloadBuilder_ != null) {
                this.payloadBuilder_.dispose();
                this.payloadBuilder_ = null;
            }
            this.payloadTruncated_ = false;
            this.peer_ = null;
            if (this.peerBuilder_ != null) {
                this.peerBuilder_.dispose();
                this.peerBuilder_ = null;
            }
            this.authority_ = "";
            this.serviceName_ = "";
            this.methodName_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ObservabilityLogProto.internal_static_grpc_observabilitylog_v1_GrpcLogRecord_descriptor;
        }

        public GrpcLogRecord getDefaultInstanceForType() {
            return GrpcLogRecord.getDefaultInstance();
        }

        public GrpcLogRecord build() {
            GrpcLogRecord result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GrpcLogRecord buildPartial() {
            GrpcLogRecord result = new GrpcLogRecord(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(GrpcLogRecord result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.callId_ = this.callId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.sequenceId_ = this.sequenceId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.type_ = this.type_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.logger_ = this.logger_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x10) != 0) {
                result.payload_ = this.payloadBuilder_ == null ? this.payload_ : (Payload)this.payloadBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.payloadTruncated_ = this.payloadTruncated_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.peer_ = this.peerBuilder_ == null ? this.peer_ : (Address)this.peerBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.authority_ = this.authority_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.serviceName_ = this.serviceName_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.methodName_ = this.methodName_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GrpcLogRecord) {
                return this.mergeFrom((GrpcLogRecord)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GrpcLogRecord other) {
            if (other == GrpcLogRecord.getDefaultInstance()) {
                return this;
            }
            if (!other.getCallId().isEmpty()) {
                this.callId_ = other.callId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.getSequenceId() != 0L) {
                this.setSequenceId(other.getSequenceId());
            }
            if (other.type_ != 0) {
                this.setTypeValue(other.getTypeValue());
            }
            if (other.logger_ != 0) {
                this.setLoggerValue(other.getLoggerValue());
            }
            if (other.hasPayload()) {
                this.mergePayload(other.getPayload());
            }
            if (other.getPayloadTruncated()) {
                this.setPayloadTruncated(other.getPayloadTruncated());
            }
            if (other.hasPeer()) {
                this.mergePeer(other.getPeer());
            }
            if (!other.getAuthority().isEmpty()) {
                this.authority_ = other.authority_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (!other.getServiceName().isEmpty()) {
                this.serviceName_ = other.serviceName_;
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            if (!other.getMethodName().isEmpty()) {
                this.methodName_ = other.methodName_;
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block18: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block18;
                        }
                        case 18: {
                            this.callId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block18;
                        }
                        case 24: {
                            this.sequenceId_ = input.readUInt64();
                            this.bitField0_ |= 2;
                            continue block18;
                        }
                        case 32: {
                            this.type_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block18;
                        }
                        case 40: {
                            this.logger_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block18;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getPayloadFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block18;
                        }
                        case 56: {
                            this.payloadTruncated_ = input.readBool();
                            this.bitField0_ |= 0x20;
                            continue block18;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getPeerFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x40;
                            continue block18;
                        }
                        case 82: {
                            this.authority_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block18;
                        }
                        case 90: {
                            this.serviceName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x100;
                            continue block18;
                        }
                        case 98: {
                            this.methodName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x200;
                            continue block18;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getCallId() {
            Object ref = this.callId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.callId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCallIdBytes() {
            Object ref = this.callId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.callId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCallId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.callId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearCallId() {
            this.callId_ = GrpcLogRecord.getDefaultInstance().getCallId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setCallIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GrpcLogRecord.checkByteStringIsUtf8((ByteString)value);
            this.callId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public long getSequenceId() {
            return this.sequenceId_;
        }

        public Builder setSequenceId(long value) {
            this.sequenceId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearSequenceId() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.sequenceId_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public int getTypeValue() {
            return this.type_;
        }

        public Builder setTypeValue(int value) {
            this.type_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public EventType getType() {
            EventType result = EventType.forNumber(this.type_);
            return result == null ? EventType.UNRECOGNIZED : result;
        }

        public Builder setType(EventType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.type_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.type_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getLoggerValue() {
            return this.logger_;
        }

        public Builder setLoggerValue(int value) {
            this.logger_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public EventLogger getLogger() {
            EventLogger result = EventLogger.forNumber(this.logger_);
            return result == null ? EventLogger.UNRECOGNIZED : result;
        }

        public Builder setLogger(EventLogger value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.logger_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearLogger() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.logger_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPayload() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public Payload getPayload() {
            if (this.payloadBuilder_ == null) {
                return this.payload_ == null ? Payload.getDefaultInstance() : this.payload_;
            }
            return (Payload)this.payloadBuilder_.getMessage();
        }

        public Builder setPayload(Payload value) {
            if (this.payloadBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.payload_ = value;
            } else {
                this.payloadBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setPayload(Payload.Builder builderForValue) {
            if (this.payloadBuilder_ == null) {
                this.payload_ = builderForValue.build();
            } else {
                this.payloadBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergePayload(Payload value) {
            if (this.payloadBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.payload_ != null && this.payload_ != Payload.getDefaultInstance()) {
                    this.getPayloadBuilder().mergeFrom(value);
                } else {
                    this.payload_ = value;
                }
            } else {
                this.payloadBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.payload_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPayload() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.payload_ = null;
            if (this.payloadBuilder_ != null) {
                this.payloadBuilder_.dispose();
                this.payloadBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Payload.Builder getPayloadBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (Payload.Builder)this.getPayloadFieldBuilder().getBuilder();
        }

        @Override
        public PayloadOrBuilder getPayloadOrBuilder() {
            if (this.payloadBuilder_ != null) {
                return (PayloadOrBuilder)this.payloadBuilder_.getMessageOrBuilder();
            }
            return this.payload_ == null ? Payload.getDefaultInstance() : this.payload_;
        }

        private SingleFieldBuilderV3<Payload, Payload.Builder, PayloadOrBuilder> getPayloadFieldBuilder() {
            if (this.payloadBuilder_ == null) {
                this.payloadBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPayload(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.payload_ = null;
            }
            return this.payloadBuilder_;
        }

        @Override
        public boolean getPayloadTruncated() {
            return this.payloadTruncated_;
        }

        public Builder setPayloadTruncated(boolean value) {
            this.payloadTruncated_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearPayloadTruncated() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.payloadTruncated_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPeer() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public Address getPeer() {
            if (this.peerBuilder_ == null) {
                return this.peer_ == null ? Address.getDefaultInstance() : this.peer_;
            }
            return (Address)this.peerBuilder_.getMessage();
        }

        public Builder setPeer(Address value) {
            if (this.peerBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.peer_ = value;
            } else {
                this.peerBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder setPeer(Address.Builder builderForValue) {
            if (this.peerBuilder_ == null) {
                this.peer_ = builderForValue.build();
            } else {
                this.peerBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder mergePeer(Address value) {
            if (this.peerBuilder_ == null) {
                if ((this.bitField0_ & 0x40) != 0 && this.peer_ != null && this.peer_ != Address.getDefaultInstance()) {
                    this.getPeerBuilder().mergeFrom(value);
                } else {
                    this.peer_ = value;
                }
            } else {
                this.peerBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.peer_ != null) {
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPeer() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.peer_ = null;
            if (this.peerBuilder_ != null) {
                this.peerBuilder_.dispose();
                this.peerBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Address.Builder getPeerBuilder() {
            this.bitField0_ |= 0x40;
            this.onChanged();
            return (Address.Builder)this.getPeerFieldBuilder().getBuilder();
        }

        @Override
        public AddressOrBuilder getPeerOrBuilder() {
            if (this.peerBuilder_ != null) {
                return (AddressOrBuilder)this.peerBuilder_.getMessageOrBuilder();
            }
            return this.peer_ == null ? Address.getDefaultInstance() : this.peer_;
        }

        private SingleFieldBuilderV3<Address, Address.Builder, AddressOrBuilder> getPeerFieldBuilder() {
            if (this.peerBuilder_ == null) {
                this.peerBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPeer(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.peer_ = null;
            }
            return this.peerBuilder_;
        }

        @Override
        public String getAuthority() {
            Object ref = this.authority_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.authority_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getAuthorityBytes() {
            Object ref = this.authority_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.authority_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setAuthority(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.authority_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearAuthority() {
            this.authority_ = GrpcLogRecord.getDefaultInstance().getAuthority();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setAuthorityBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GrpcLogRecord.checkByteStringIsUtf8((ByteString)value);
            this.authority_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public String getServiceName() {
            Object ref = this.serviceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.serviceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getServiceNameBytes() {
            Object ref = this.serviceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.serviceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setServiceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.serviceName_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearServiceName() {
            this.serviceName_ = GrpcLogRecord.getDefaultInstance().getServiceName();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder setServiceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GrpcLogRecord.checkByteStringIsUtf8((ByteString)value);
            this.serviceName_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public String getMethodName() {
            Object ref = this.methodName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.methodName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMethodNameBytes() {
            Object ref = this.methodName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.methodName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMethodName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.methodName_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder clearMethodName() {
            this.methodName_ = GrpcLogRecord.getDefaultInstance().getMethodName();
            this.bitField0_ &= 0xFFFFFDFF;
            this.onChanged();
            return this;
        }

        public Builder setMethodNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GrpcLogRecord.checkByteStringIsUtf8((ByteString)value);
            this.methodName_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum EventLogger implements ProtocolMessageEnum
    {
        LOGGER_UNKNOWN(0),
        CLIENT(1),
        SERVER(2),
        UNRECOGNIZED(-1);

        public static final int LOGGER_UNKNOWN_VALUE = 0;
        public static final int CLIENT_VALUE = 1;
        public static final int SERVER_VALUE = 2;
        private static final Internal.EnumLiteMap<EventLogger> internalValueMap;
        private static final EventLogger[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static EventLogger valueOf(int value) {
            return EventLogger.forNumber(value);
        }

        public static EventLogger forNumber(int value) {
            switch (value) {
                case 0: {
                    return LOGGER_UNKNOWN;
                }
                case 1: {
                    return CLIENT;
                }
                case 2: {
                    return SERVER;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<EventLogger> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)EventLogger.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return EventLogger.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)GrpcLogRecord.getDescriptor().getEnumTypes().get(1);
        }

        public static EventLogger valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != EventLogger.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private EventLogger(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<EventLogger>(){

                public EventLogger findValueByNumber(int number) {
                    return EventLogger.forNumber(number);
                }
            };
            VALUES = EventLogger.values();
        }
    }

    public static enum EventType implements ProtocolMessageEnum
    {
        EVENT_TYPE_UNKNOWN(0),
        CLIENT_HEADER(1),
        SERVER_HEADER(2),
        CLIENT_MESSAGE(3),
        SERVER_MESSAGE(4),
        CLIENT_HALF_CLOSE(5),
        SERVER_TRAILER(6),
        CANCEL(7),
        UNRECOGNIZED(-1);

        public static final int EVENT_TYPE_UNKNOWN_VALUE = 0;
        public static final int CLIENT_HEADER_VALUE = 1;
        public static final int SERVER_HEADER_VALUE = 2;
        public static final int CLIENT_MESSAGE_VALUE = 3;
        public static final int SERVER_MESSAGE_VALUE = 4;
        public static final int CLIENT_HALF_CLOSE_VALUE = 5;
        public static final int SERVER_TRAILER_VALUE = 6;
        public static final int CANCEL_VALUE = 7;
        private static final Internal.EnumLiteMap<EventType> internalValueMap;
        private static final EventType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static EventType valueOf(int value) {
            return EventType.forNumber(value);
        }

        public static EventType forNumber(int value) {
            switch (value) {
                case 0: {
                    return EVENT_TYPE_UNKNOWN;
                }
                case 1: {
                    return CLIENT_HEADER;
                }
                case 2: {
                    return SERVER_HEADER;
                }
                case 3: {
                    return CLIENT_MESSAGE;
                }
                case 4: {
                    return SERVER_MESSAGE;
                }
                case 5: {
                    return CLIENT_HALF_CLOSE;
                }
                case 6: {
                    return SERVER_TRAILER;
                }
                case 7: {
                    return CANCEL;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<EventType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)EventType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return EventType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)GrpcLogRecord.getDescriptor().getEnumTypes().get(0);
        }

        public static EventType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != EventType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private EventType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<EventType>(){

                public EventType findValueByNumber(int number) {
                    return EventType.forNumber(number);
                }
            };
            VALUES = EventType.values();
        }
    }
}

