/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.interceptors;

import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Internal;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.gcp.observability.interceptors.ConfigFilterHelper;
import io.grpc.gcp.observability.interceptors.LogHelper;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import io.opencensus.trace.ContextHandle;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.unsafe.ContextHandleUtils;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public final class InternalLoggingServerInterceptor
implements ServerInterceptor {
    private static final Logger logger = Logger.getLogger(InternalLoggingServerInterceptor.class.getName());
    private final LogHelper helper;
    private final ConfigFilterHelper filterHelper;

    private InternalLoggingServerInterceptor(LogHelper helper, ConfigFilterHelper filterHelper) {
        this.helper = helper;
        this.filterHelper = filterHelper;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        final AtomicLong seq = new AtomicLong(1L);
        final String callId = UUID.randomUUID().toString();
        final String authority = call.getAuthority();
        final String serviceName = call.getMethodDescriptor().getServiceName();
        final String methodName = call.getMethodDescriptor().getBareMethodName();
        SocketAddress peerAddress = LogHelper.getPeerAddress(call.getAttributes());
        Deadline deadline = Context.current().getDeadline();
        Duration timeout = deadline == null ? null : Durations.fromNanos((long)deadline.timeRemaining(TimeUnit.NANOSECONDS));
        Span span = ContextHandleUtils.getValue((ContextHandle)ContextHandleUtils.currentContext());
        final SpanContext serverSpanContext = span == null ? SpanContext.INVALID : span.getContext();
        ConfigFilterHelper.FilterParams filterParams = this.filterHelper.logRpcMethod(call.getMethodDescriptor().getFullMethodName(), false);
        if (!filterParams.log()) {
            return next.startCall(call, headers);
        }
        final int maxHeaderBytes = filterParams.headerBytes();
        final int maxMessageBytes = filterParams.messageBytes();
        try {
            this.helper.logClientHeader(seq.getAndIncrement(), serviceName, methodName, authority, timeout, headers, maxHeaderBytes, GrpcLogRecord.EventLogger.SERVER, callId, peerAddress, serverSpanContext);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to log request header", e);
        }
        ForwardingServerCall.SimpleForwardingServerCall wrapperCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void sendHeaders(Metadata headers) {
                try {
                    InternalLoggingServerInterceptor.this.helper.logServerHeader(seq.getAndIncrement(), serviceName, methodName, authority, headers, maxHeaderBytes, GrpcLogRecord.EventLogger.SERVER, callId, null, serverSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log response header", e);
                }
                super.sendHeaders(headers);
            }

            public void sendMessage(RespT message) {
                GrpcLogRecord.EventType responseMessageType = GrpcLogRecord.EventType.SERVER_MESSAGE;
                try {
                    InternalLoggingServerInterceptor.this.helper.logRpcMessage(seq.getAndIncrement(), serviceName, methodName, authority, responseMessageType, message, maxMessageBytes, GrpcLogRecord.EventLogger.SERVER, callId, serverSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log response message", e);
                }
                super.sendMessage(message);
            }

            public void close(Status status, Metadata trailers) {
                try {
                    InternalLoggingServerInterceptor.this.helper.logTrailer(seq.getAndIncrement(), serviceName, methodName, authority, status, trailers, maxHeaderBytes, GrpcLogRecord.EventLogger.SERVER, callId, null, serverSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log trailer", e);
                }
                super.close(status, trailers);
            }
        };
        ServerCall.Listener listener = next.startCall((ServerCall)wrapperCall, headers);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listener){

            public void onMessage(ReqT message) {
                GrpcLogRecord.EventType requestMessageType = GrpcLogRecord.EventType.CLIENT_MESSAGE;
                try {
                    InternalLoggingServerInterceptor.this.helper.logRpcMessage(seq.getAndIncrement(), serviceName, methodName, authority, requestMessageType, message, maxMessageBytes, GrpcLogRecord.EventLogger.SERVER, callId, serverSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log request message", e);
                }
                super.onMessage(message);
            }

            public void onHalfClose() {
                try {
                    InternalLoggingServerInterceptor.this.helper.logHalfClose(seq.getAndIncrement(), serviceName, methodName, authority, GrpcLogRecord.EventLogger.SERVER, callId, serverSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log half close", e);
                }
                super.onHalfClose();
            }

            public void onCancel() {
                try {
                    InternalLoggingServerInterceptor.this.helper.logCancel(seq.getAndIncrement(), serviceName, methodName, authority, GrpcLogRecord.EventLogger.SERVER, callId, serverSpanContext);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unable to log cancel", e);
                }
                super.onCancel();
            }
        };
    }

    public static class FactoryImpl
    implements Factory {
        private final LogHelper helper;
        private final ConfigFilterHelper filterHelper;

        public FactoryImpl(LogHelper helper, ConfigFilterHelper filterHelper) {
            this.helper = helper;
            this.filterHelper = filterHelper;
        }

        @Override
        public ServerInterceptor create() {
            return new InternalLoggingServerInterceptor(this.helper, this.filterHelper);
        }
    }

    public static interface Factory {
        public ServerInterceptor create();
    }
}

