/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.logging;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowController;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.v2.stub.LoggingServiceV2StubSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Internal;
import io.grpc.gcp.observability.ObservabilityConfig;
import io.grpc.gcp.observability.logging.Sink;
import io.grpc.gcp.observability.logging.TraceLoggingHelper;
import io.grpc.internal.JsonParser;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import io.opencensus.trace.SpanContext;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

@Internal
public class GcpLogSink
implements Sink {
    private final Logger logger = Logger.getLogger(GcpLogSink.class.getName());
    private static final String DEFAULT_LOG_NAME = "microservices.googleapis.com%2Fobservability%2Fgrpc";
    private static final Severity DEFAULT_LOG_LEVEL = Severity.DEBUG;
    private final String projectId;
    private final Map<String, String> customTags;
    private volatile Logging gcpLoggingClient;
    private final Collection<String> servicesToExclude;
    private final boolean isTraceEnabled;
    private final TraceLoggingHelper traceLoggingHelper;

    @VisibleForTesting
    GcpLogSink(Logging loggingClient, String projectId, ObservabilityConfig config, Collection<String> servicesToExclude, TraceLoggingHelper traceLoggingHelper) {
        this(projectId, config, servicesToExclude, traceLoggingHelper);
        this.gcpLoggingClient = loggingClient;
    }

    public GcpLogSink(String projectId, ObservabilityConfig config, Collection<String> servicesToExclude, TraceLoggingHelper traceLoggingHelper) {
        this.projectId = projectId;
        this.customTags = GcpLogSink.getCustomTags(config.getCustomTags());
        this.servicesToExclude = (Collection)Preconditions.checkNotNull(servicesToExclude, (Object)"servicesToExclude");
        this.isTraceEnabled = config.isEnableCloudTracing();
        this.traceLoggingHelper = traceLoggingHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(GrpcLogRecord logProto, SpanContext spanContext) {
        if (this.gcpLoggingClient == null) {
            GcpLogSink gcpLogSink = this;
            synchronized (gcpLogSink) {
                if (this.gcpLoggingClient == null) {
                    this.gcpLoggingClient = this.createLoggingClient();
                }
            }
        }
        if (this.servicesToExclude.contains(logProto.getServiceName())) {
            return;
        }
        LogEntry grpcLogEntry = null;
        try {
            GrpcLogRecord.EventType eventType = logProto.getType();
            Map<String, Object> logProtoMap = this.protoToMapConverter(logProto);
            LogEntry.Builder grpcLogEntryBuilder = LogEntry.newBuilder((Payload)Payload.JsonPayload.of(logProtoMap)).setSeverity(DEFAULT_LOG_LEVEL).setLogName(DEFAULT_LOG_NAME).setTimestamp(Instant.now());
            if (!this.customTags.isEmpty()) {
                grpcLogEntryBuilder.setLabels(this.customTags);
            }
            this.addTraceData(grpcLogEntryBuilder, spanContext);
            grpcLogEntry = grpcLogEntryBuilder.build();
            GcpLogSink gcpLogSink = this;
            synchronized (gcpLogSink) {
                this.logger.log(Level.FINEST, "Writing gRPC event : {0} to Cloud Logging", (Object)eventType);
                this.gcpLoggingClient.write(Collections.singleton(grpcLogEntry), new Logging.WriteOption[0]);
            }
        }
        catch (FlowController.FlowControlRuntimeException e) {
            String grpcLogEntryString = null;
            if (grpcLogEntry != null) {
                grpcLogEntryString = grpcLogEntry.toStructuredJsonString();
            }
            this.logger.log(Level.SEVERE, "Limit exceeded while writing log entry to cloud logging");
            this.logger.log(Level.SEVERE, "Log entry = ", grpcLogEntryString);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Caught exception while writing to Cloud Logging", e);
        }
    }

    void addTraceData(LogEntry.Builder builder, SpanContext spanContext) {
        if (!this.isTraceEnabled) {
            return;
        }
        this.traceLoggingHelper.enhanceLogEntry(builder, spanContext);
    }

    Logging createLoggingClient() {
        LoggingOptions.Builder builder = LoggingOptions.newBuilder();
        if (!Strings.isNullOrEmpty((String)this.projectId)) {
            builder.setProjectId(this.projectId);
        }
        BatchingSettings loggingDefaultBatchingSettings = LoggingServiceV2StubSettings.newBuilder().writeLogEntriesSettings().getBatchingSettings();
        BatchingSettings grpcLoggingVBatchingSettings = loggingDefaultBatchingSettings.toBuilder().setDelayThreshold(Duration.ofSeconds((long)1L)).setFlowControlSettings(loggingDefaultBatchingSettings.getFlowControlSettings().toBuilder().setMaxOutstandingRequestBytes(Long.valueOf(0x3200000L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build()).build();
        builder.setBatchingSettings(grpcLoggingVBatchingSettings);
        return (Logging)builder.build().getService();
    }

    @VisibleForTesting
    static Map<String, String> getCustomTags(Map<String, String> customTags) {
        ImmutableMap.Builder tagsBuilder = ImmutableMap.builder();
        if (customTags != null) {
            tagsBuilder.putAll(customTags);
        }
        return tagsBuilder.buildOrThrow();
    }

    private Map<String, Object> protoToMapConverter(GrpcLogRecord logProto) throws IOException {
        JsonFormat.Printer printer = JsonFormat.printer();
        String recordJson = printer.print((MessageOrBuilder)logProto);
        return (Map)JsonParser.parse((String)recordJson);
    }

    @Override
    public synchronized void close() {
        if (this.gcpLoggingClient == null) {
            this.logger.log(Level.WARNING, "Attempt to close after GcpLogSink is closed.");
            return;
        }
        try {
            this.gcpLoggingClient.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Caught exception while closing", e);
        }
    }
}

